<?php

class GeneralSettingsController extends Controller
{
    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update','setperiod','getperiod'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin','ngnms'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id)
    {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate()
    {
        $model = new GeneralSettings;

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        if (isset($_POST['GeneralSettings'])) {
            $model->attributes = $_POST['GeneralSettings'];
            if ($model->save())
                $this->redirect(array('admin', 'id' => $model->id));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id)
    {
        $model = $this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        if (isset($_POST['GeneralSettings'])) {
            $model->attributes = $_POST['GeneralSettings'];
            if ($model->save())
                $this->redirect(array('admin', 'id' => $model->id));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    public function actionSetperiod()
    {
        if (!Yii::app()->user->isGuest)
        {
            if (Yii::app()->request->isAjaxRequest && isset($_POST['label']))
            {
                $model = GeneralSettings::model()->findByAttributes(array('name'=>'perioddiscovery'));
                $arr_crontab = Yii::app()->params['cronperiods'];
                $ind = trim($_POST['label']);
                $model->value = $arr_crontab[$ind];
                if($model->save())
                {
                    $data = array("ok"=>1);
                }
                else
                {
                    $data = array("ok"=>0);
                }
                echo json_encode($data);
            }
        }
        else
        {
            $this->redirect('index.php?r=site/login');
        }
    }

    public function actionGetperiod()
    {
        if (!Yii::app()->user->isGuest)
        {
            if (Yii::app()->request->isAjaxRequest )
            {
                $model = GeneralSettings::model()->findByAttributes(array('name'=>'perioddiscovery'));
                $cur_disc = array_search($model->value, Yii::app()->params['cronperiods']);
                $data = array('label' => $cur_disc);
                echo json_encode($data);
            }
        }
        else
        {
            $this->redirect('index.php?r=site/login');
        }
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id)
    {
        if (Yii::app()->request->isPostRequest) {
// we only allow deletion via POST request
            $this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        } else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }

    /**
     * Lists all models.
     */
 /*   public function actionIndex()
    {
        $dataProvider = new CActiveDataProvider('GeneralSettings');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }*/

    /**
     * Manages all models.
     */
    public function actionAdmin()
    {
        $model = new GeneralSettings('search');
        $model->unsetAttributes(); // clear any default values
        if (isset($_GET['GeneralSettings']))
            $model->attributes = $_GET['GeneralSettings'];


        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id)
    {
        $model = GeneralSettings::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        if($model->name !='chiave' && $model->name !='perioddiscovery')
        {

            $model->value = trim(Cripto::decrypt($model->value));
        }
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'general-settings-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }
}
