--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: getalarms(timestamp with time zone, interval, interval, integer); Type: FUNCTION; Schema: public; Owner: ngnms
--

CREATE FUNCTION getalarms(timestamp with time zone, interval, interval, integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select sum(severity) from events 
   where origin_id = $4 and
   origin_ts > $1 + $2 and
   origin_ts <= $1 + $3$_$;


ALTER FUNCTION public.getalarms(timestamp with time zone, interval, interval, integer) OWNER TO ngnms;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: admrecords; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE admrecords (
    rec_id integer DEFAULT nextval(('"admrecords_RecID_seq"'::text)::regclass) NOT NULL,
    date_time timestamp without time zone NOT NULL,
    who character varying(20) NOT NULL,
    action character varying(20) NOT NULL,
    obj_type integer DEFAULT (-1),
    obj_id integer DEFAULT (-1)
);


ALTER TABLE public.admrecords OWNER TO ngnms;

--
-- Name: admrecords_RecID_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE "admrecords_RecID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public."admrecords_RecID_seq" OWNER TO ngnms;

--
-- Name: archives; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE archives (
    archive_id integer DEFAULT nextval(('"archives_archive_id_seq"'::text)::regclass) NOT NULL,
    start_time timestamp with time zone NOT NULL,
    end_time timestamp with time zone NOT NULL,
    file_name character varying(64) NOT NULL,
    in_db boolean DEFAULT false NOT NULL
);


ALTER TABLE public.archives OWNER TO ngnms;

--
-- Name: archives_archive_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE archives_archive_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.archives_archive_id_seq OWNER TO ngnms;

--
-- Name: authassignment; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE authassignment (
    itemname character varying(64) NOT NULL,
    userid character varying(64) NOT NULL,
    bizrule text,
    data text
);


ALTER TABLE public.authassignment OWNER TO ngnms;

--
-- Name: authitem; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE authitem (
    name character varying(64) NOT NULL,
    type integer NOT NULL,
    description text,
    bizrule text,
    data text
);


ALTER TABLE public.authitem OWNER TO ngnms;

--
-- Name: authitemchild; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE authitemchild (
    parent character varying(64) NOT NULL,
    child character varying(64) NOT NULL
);


ALTER TABLE public.authitemchild OWNER TO ngnms;

--
-- Name: events; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE events (
    event_id integer DEFAULT nextval(('"events_event_id_seq"'::text)::regclass) NOT NULL,
    origin_ts timestamp with time zone,
    receiver_ts timestamp with time zone,
    origin character varying(64),
    origin_id integer,
    facility character varying(64),
    code character varying(64),
    descr character varying(10000),
    priority character varying(10),
    severity integer
);


ALTER TABLE public.events OWNER TO ngnms;

--
-- Name: events_event_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE events_event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.events_event_id_seq OWNER TO ngnms;

--
-- Name: interfaces; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE interfaces (
    router_id integer NOT NULL,
    ph_int_id integer NOT NULL,
    ifc_id integer DEFAULT nextval(('"interfaces_ifc_id_seq"'::text)::regclass) NOT NULL,
    name character varying(32) NOT NULL,
    ip_addr inet,
    mask inet,
    descr character varying(100)
);


ALTER TABLE public.interfaces OWNER TO ngnms;

--
-- Name: interfaces_ifc_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE interfaces_ifc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interfaces_ifc_id_seq OWNER TO ngnms;

--
-- Name: inv_hw; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE inv_hw (
    router_id integer NOT NULL,
    hw_item character(50) NOT NULL,
    hw_name character(100),
    hw_version character(100),
    hw_amount character(30)
);


ALTER TABLE public.inv_hw OWNER TO ngnms;

--
-- Name: inv_sw; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE inv_sw (
    router_id integer NOT NULL,
    sw_item character(50) NOT NULL,
    sw_name character(100),
    sw_version character(100)
);


ALTER TABLE public.inv_sw OWNER TO ngnms;

--
-- Name: menu; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE menu (
    id integer NOT NULL,
    name character varying(100) NOT NULL,
    label character varying(50) NOT NULL
);


ALTER TABLE public.menu OWNER TO ngnms;

--
-- Name: menu_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE menu_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.menu_id_seq OWNER TO ngnms;

--
-- Name: menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ngnms
--

ALTER SEQUENCE menu_id_seq OWNED BY menu.id;


--
-- Name: menuitem; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE menuitem (
    id integer NOT NULL,
    name character varying(255) DEFAULT NULL::character varying,
    parentid integer,
    label character varying(50) DEFAULT NULL::character varying,
    ordervalue integer,
    route character varying(255) DEFAULT NULL::character varying,
    accesslevel character varying(255) DEFAULT NULL::character varying,
    depthlevel integer,
    menutypeid character varying(100) DEFAULT NULL::character varying,
    adminnotes text,
    active smallint,
    created timestamp without time zone DEFAULT now(),
    modified timestamp without time zone DEFAULT now() NOT NULL,
    deleted timestamp without time zone,
    icon character varying(255) DEFAULT NULL::character varying
);


ALTER TABLE public.menuitem OWNER TO ngnms;

--
-- Name: menuitem_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE menuitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.menuitem_id_seq OWNER TO ngnms;

--
-- Name: menuitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ngnms
--

ALTER SEQUENCE menuitem_id_seq OWNED BY menuitem.id;


--
-- Name: network; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE network (
    link_id integer DEFAULT nextval(('"network_link_id_seq"'::text)::regclass) NOT NULL,
    router_id_a integer NOT NULL,
    ifc_id_a integer,
    router_id_b integer NOT NULL,
    ifc_id_b integer,
    link_type character varying(4)
);


ALTER TABLE public.network OWNER TO ngnms;

--
-- Name: network_link_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE network_link_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.network_link_id_seq OWNER TO ngnms;

--
-- Name: pga_forms; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE pga_forms (
    formname character varying(64),
    formsource text
);


ALTER TABLE public.pga_forms OWNER TO ngnms;

--
-- Name: pga_layout; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE pga_layout (
    tablename character varying(64),
    nrcols smallint,
    colnames text,
    colwidth text
);


ALTER TABLE public.pga_layout OWNER TO ngnms;

--
-- Name: pga_queries; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE pga_queries (
    queryname character varying(64),
    querytype character(1),
    querycommand text,
    querytables text,
    querylinks text,
    queryresults text,
    querycomments text
);


ALTER TABLE public.pga_queries OWNER TO ngnms;

--
-- Name: pga_reports; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE pga_reports (
    reportname character varying(64),
    reportsource text,
    reportbody text,
    reportprocs text,
    reportoptions text
);


ALTER TABLE public.pga_reports OWNER TO ngnms;

--
-- Name: pga_schema; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE pga_schema (
    schemaname character varying(64),
    schematables text,
    schemalinks text
);


ALTER TABLE public.pga_schema OWNER TO ngnms;

--
-- Name: pga_scripts; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE pga_scripts (
    scriptname character varying(64),
    scriptsource text
);


ALTER TABLE public.pga_scripts OWNER TO ngnms;

--
-- Name: ph_int; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE ph_int (
    router_id integer NOT NULL,
    ph_int_id integer DEFAULT nextval(('"ph_int_ph_int_id_seq"'::text)::regclass) NOT NULL,
    name character varying(128) NOT NULL,
    state character varying(8),
    condition character varying(8),
    descr character varying(256),
    speed character varying(20)
);


ALTER TABLE public.ph_int OWNER TO ngnms;

--
-- Name: ph_int_ph_int_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE ph_int_ph_int_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ph_int_ph_int_id_seq OWNER TO ngnms;

--
-- Name: router_configuration; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE router_configuration (
    id integer NOT NULL,
    router_id integer NOT NULL,
    data bytea NOT NULL,
    created timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.router_configuration OWNER TO ngnms;

--
-- Name: router_configuration_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE router_configuration_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.router_configuration_id_seq OWNER TO ngnms;

--
-- Name: router_configuration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ngnms
--

ALTER SEQUENCE router_configuration_id_seq OWNED BY router_configuration.id;


--
-- Name: router_graph; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE router_graph (
    router_id integer NOT NULL,
    x real NOT NULL,
    y real NOT NULL
);


ALTER TABLE public.router_graph OWNER TO ngnms;

--
-- Name: router_vendors; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE router_vendors (
    id integer DEFAULT nextval(('"router_vendors_id_seq"'::text)::regclass) NOT NULL,
    name character varying(50) NOT NULL,
    rgb character(6) NOT NULL
);


ALTER TABLE public.router_vendors OWNER TO ngnms;

--
-- Name: router_vendors_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE router_vendors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.router_vendors_id_seq OWNER TO ngnms;

--
-- Name: routers; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE routers (
    router_id integer DEFAULT nextval(('"routers_router_id_seq"'::text)::regclass) NOT NULL,
    name character varying(32) NOT NULL,
    ip_addr inet,
    eq_type character(50),
    eq_vendor character(50),
    location character(255),
    status character(20),
    icon_color character(20) DEFAULT NULL::bpchar
);


ALTER TABLE public.routers OWNER TO ngnms;

--
-- Name: routers_router_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE routers_router_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.routers_router_id_seq OWNER TO ngnms;

--
-- Name: tbl_user; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE tbl_user (
    id integer NOT NULL,
    username character varying(128) NOT NULL,
    password character varying(128) NOT NULL,
    email character varying(128) NOT NULL,
    fname character varying(128) NOT NULL,
    lname character varying(128) NOT NULL,
    company character varying(128) NOT NULL
);


ALTER TABLE public.tbl_user OWNER TO ngnms;

--
-- Name: tbl_user_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE tbl_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tbl_user_id_seq OWNER TO ngnms;

--
-- Name: tbl_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ngnms
--

ALTER SEQUENCE tbl_user_id_seq OWNED BY tbl_user.id;


--
-- Name: usrs; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE usrs (
    usr character varying(25) NOT NULL,
    psw character varying(25) NOT NULL
);


ALTER TABLE public.usrs OWNER TO ngnms;

--
-- Name: id; Type: DEFAULT; Schema: public; Owner: ngnms
--

ALTER TABLE ONLY menu ALTER COLUMN id SET DEFAULT nextval('menu_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: ngnms
--

ALTER TABLE ONLY menuitem ALTER COLUMN id SET DEFAULT nextval('menuitem_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: ngnms
--

ALTER TABLE ONLY router_configuration ALTER COLUMN id SET DEFAULT nextval('router_configuration_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: ngnms
--

ALTER TABLE ONLY tbl_user ALTER COLUMN id SET DEFAULT nextval('tbl_user_id_seq'::regclass);


--
-- Data for Name: admrecords; Type: TABLE DATA; Schema: public; Owner: ngnms
--

COPY admrecords (rec_id, date_time, who, action, obj_type, obj_id) FROM stdin;
\.


--
-- Name: admrecords_RecID_seq; Type: SEQUENCE SET; Schema: public; Owner: ngnms
--

SELECT pg_catalog.setval('"admrecords_RecID_seq"', 1, false);


--
-- Data for Name: archives; Type: TABLE DATA; Schema: public; Owner: ngnms
--

COPY archives (archive_id, start_time, end_time, file_name, in_db) FROM stdin;
440	2003-11-19 17:00:02+02	2003-11-21 20:47:08+02	20031124-1200.sql	t
441	2003-11-24 12:44:10+02	2003-11-24 13:00:01+02	20031126-1200.sql	t
442	2003-11-24 13:00:12+02	2003-11-24 17:00:00+02	20031126-1600.sql	t
443	2003-11-24 17:00:03+02	2003-11-25 13:00:01+02	20031127-1200.sql	t
\.


--
-- Name: archives_archive_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ngnms
--

SELECT pg_catalog.setval('archives_archive_id_seq', 443, true);


--
-- Data for Name: authassignment; Type: TABLE DATA; Schema: public; Owner: ngnms
--

COPY authassignment (itemname, userid, bizrule, data) FROM stdin;
admin	1		s:0:"";
SRBAC access	1		s:0:"";
\.


--
-- Data for Name: authitem; Type: TABLE DATA; Schema: public; Owner: ngnms
--

COPY authitem (name, type, description, bizrule, data) FROM stdin;
SRBAC access	2	Allow SRBAC access		s:0:"";
changeRole	0	change Role		s:0:"";
createUser	0	create user		s:0:"";
deleteUser	0	delete  user		s:0:"";
Editor	2	it is possible update data of users		s:0:"";
editUser	1			s:0:"";
manage	1	manage users		s:0:"";
read	1			s:0:"";
readUser	0	read data of User		s:0:"";
updateOwnData	1	edit own record	return Yii::app()->user->id==$params["user"]->id;	s:0:"";
updateUser	0	update user		s:0:"";
User	2	User		s:0:"";
viewAssets	0			s:0:"";
viewEvents	0			s:0:"";
viewUsers	0	view users		s:0:"";
viewMap	0			s:0:"";
admin	2	Administrator		s:0:"";
\.


--
-- Data for Name: authitemchild; Type: TABLE DATA; Schema: public; Owner: ngnms
--

COPY authitemchild (parent, child) FROM stdin;
manage	changeRole
manage	createUser
manage	deleteUser
Editor	editUser
admin	manage
User	read
editUser	readUser
manage	readUser
User	updateOwnData
editUser	updateUser
manage	updateUser
updateOwnData	updateUser
manage	viewAssets
read	viewAssets
manage	viewEvents
read	viewEvents
editUser	viewUsers
manage	viewUsers
read	viewUsers
read	viewMap
admin	read
\.


--
-- Data for Name: events; Type: TABLE DATA; Schema: public; Owner: ngnms
--

COPY events (event_id, origin_ts, receiver_ts, origin, origin_id, facility, code, descr, priority, severity) FROM stdin;
1417032	2003-11-27 14:27:30+02	2003-11-27 14:27:30.776902+02	deimos	0	314296:		Nov 27 12:27:29.416 UTC: BGP: 62.154.13.1 multihop open delayed 19616ms (no route)		10
1417033	2003-11-27 14:27:31+02	2003-11-27 14:27:31.559545+02	mercury	0	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1417034	2003-11-27 14:27:31+02	2003-11-27 14:27:31.929914+02	mercury	0	login:		login from 172.26.27.115 on ttyp0 as lab		1
1417035	2003-11-27 14:27:31+02	2003-11-27 14:27:31.936469+02	mercury	0	mgd[11487]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1417036	2003-11-27 14:27:31+02	2003-11-27 14:27:31.940587+02	mercury	0	mgd[11487]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [11487]		1
1417037	2003-11-27 14:27:31+02	2003-11-27 14:27:31.944379+02	mercury	0	mgd[11487]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1417038	2003-11-27 15:00:45+02	2003-11-27 14:27:32.321334+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.22+639 addr 192.168.1.22+639: No route to host		10
1417039	2003-11-27 14:27:35+02	2003-11-27 14:27:35.255966+02	mercury	0	mgd[11487]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1417040	2003-11-27 14:27:35+02	2003-11-27 14:27:35.359066+02	mercury	0	mgd[11487]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show isis database extensive '		1
1417041	2003-11-27 14:27:35+02	2003-11-27 14:27:35.460371+02	mercury	0	mgd[11487]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show ospf database extensive '		1
1417042	2003-11-27 14:27:35+02	2003-11-27 14:27:35.57816+02	mercury	0	mgd[11487]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1417043	2003-11-27 14:27:35+02	2003-11-27 14:27:35.584109+02	mercury	0	mgd[11487]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1417044	2003-11-27 14:27:35+02	2003-11-27 14:27:35.689977+02	mercury	0	inetd[4440]:	/usr/libexec/telnetd[11485]:	exit status 0x100		10
1417045	2003-11-27 14:27:36+02	2003-11-27 14:27:36.548887+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1416755	2003-11-27 14:36:22+02	2003-11-27 14:19:47.944649+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416756	2003-11-27 14:36:23+02	2003-11-27 14:19:48.948017+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416757	2003-11-27 14:36:23+02	2003-11-27 14:19:48.961698+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416758	2003-11-27 14:36:24+02	2003-11-27 14:19:49.962633+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416759	2003-11-27 14:36:24+02	2003-11-27 14:19:49.971582+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416760	2003-11-27 14:36:24+02	2003-11-27 14:19:49.97579+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416761	2003-11-27 14:36:25+02	2003-11-27 14:19:50.946763+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416762	2003-11-27 14:36:25+02	2003-11-27 14:19:50.967395+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416763	2003-11-27 14:36:25+02	2003-11-27 14:19:51.07384+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416764	2003-11-27 14:36:26+02	2003-11-27 14:19:51.94768+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1417046	2003-11-27 14:27:36+02	2003-11-27 14:27:36.607268+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1416766	2003-11-27 14:36:26+02	2003-11-27 14:19:56.970637+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416767	2003-11-27 14:36:27+02	2003-11-27 14:19:56.974585+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1416768	2003-11-27 14:36:27+02	2003-11-27 14:19:56.978337+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1417047	2003-11-27 14:27:36+02	2003-11-27 14:27:36.613849+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1417048	2003-11-27 14:27:36+02	2003-11-27 14:27:36.619233+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1417049	2003-11-27 14:27:36+02	2003-11-27 14:27:36.624438+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1417050	2003-11-27 14:27:36+02	2003-11-27 14:27:36.668677+02	ganymede	3731	mgd[4332]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1417051	2003-11-27 14:27:36+02	2003-11-27 14:27:36.673964+02	ganymede	3731	mgd[4332]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4332]		1
1417052	2003-11-27 14:27:37+02	2003-11-27 14:27:37.554825+02	ganymede	3731	mgd[4332]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1416775	2003-11-27 14:36:28+02	2003-11-27 14:20:12.369666+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1417053	2003-11-27 14:27:37+02	2003-11-27 14:27:37.650985+02	ganymede	3731	mgd[4332]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1417054	2003-11-27 14:27:37+02	2003-11-27 14:27:37.760088+02	ganymede	3731	mgd[4332]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show isis database extensive '		1
1417055	2003-11-27 14:27:37+02	2003-11-27 14:27:37.937566+02	ganymede	3731	mgd[4332]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show ospf database extensive '		1
1417056	2003-11-27 14:27:37+02	2003-11-27 14:27:38.026472+02	ganymede	3731	mgd[4332]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1417057	2003-11-27 14:27:37+02	2003-11-27 14:27:38.032842+02	ganymede	3731	mgd[4332]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1417058	2003-11-27 14:27:37+02	2003-11-27 14:27:38.037129+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[4330]:	exit status 0x100		10
1417059	2003-11-27 15:00:52+02	2003-11-27 14:27:38.472853+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.59+639 addr 192.168.1.59+639: No route to host		10
1417060	2003-11-27 15:00:55+02	2003-11-27 14:27:41.480486+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.22+639 addr 192.168.1.22+639: No route to host		10
1417061	2003-11-27 15:01:00+02	2003-11-27 14:27:47.182802+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.59+639 addr 192.168.1.59+639: No route to host		10
1417062	2003-11-27 14:27:47+02	2003-11-27 14:27:47.223939+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1417063	2003-11-27 14:27:47+02	2003-11-27 14:27:47.232048+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp0 as lab		1
1417064	2003-11-27 14:27:47+02	2003-11-27 14:27:47.342108+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp1		1
1417065	2003-11-27 14:27:47+02	2003-11-27 14:27:47.34873+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1417066	2003-11-27 14:27:47+02	2003-11-27 14:27:47.354656+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1417067	2003-11-27 14:27:47+02	2003-11-27 14:27:47.360497+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1332022	2003-11-19 20:39:28+02	2003-11-19 20:41:25.449473+02	atlas	3730	snmpd[2244]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1417068	2003-11-27 14:27:47+02	2003-11-27 14:27:47.365635+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1417069	2003-11-27 14:27:47+02	2003-11-27 14:27:47.372672+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1417070	2003-11-27 14:27:47+02	2003-11-27 14:27:47.441297+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1417071	2003-11-27 14:27:47+02	2003-11-27 14:27:47.44638+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1417072	2003-11-27 14:27:47+02	2003-11-27 14:27:47.454113+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1417073	2003-11-27 14:27:47+02	2003-11-27 14:27:47.464647+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1379023	2003-11-24 16:50:20+02	2003-11-24 16:50:24.401329+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1417074	2003-11-27 14:27:47+02	2003-11-27 14:27:47.572978+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1417075	2003-11-27 14:27:47+02	2003-11-27 14:27:47.582375+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1417076	2003-11-27 14:27:47+02	2003-11-27 14:27:47.58742+02	atlas	3730	login:		login from 172.26.27.115 on ttyp0 as lab		1
1417077	2003-11-27 14:27:47+02	2003-11-27 14:27:47.593042+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp1 as lab		1
1417078	2003-11-27 14:27:47+02	2003-11-27 14:27:47.598244+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1417079	2003-11-27 14:27:47+02	2003-11-27 14:27:47.605891+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1417080	2003-11-27 14:27:47+02	2003-11-27 14:27:47.618142+02	r201	3732	login:		login from 172.26.27.115 on ttyp0 as lab		1
1417081	2003-11-27 14:27:47+02	2003-11-27 14:27:47.624165+02	ganymede	3731	mgd[4335]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1417082	2003-11-27 14:27:47+02	2003-11-27 14:27:47.628857+02	ganymede	3731	mgd[4335]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4335]		1
1417083	2003-11-27 14:27:47+02	2003-11-27 14:27:47.633481+02	atlas	3730	mgd[4046]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1417084	2003-11-27 14:27:47+02	2003-11-27 14:27:47.740393+02	atlas	3730	mgd[4046]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4046]		1
1417085	2003-11-27 14:27:47+02	2003-11-27 14:27:47.74625+02	r201	3732	mgd[6061]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1417086	2003-11-27 14:27:47+02	2003-11-27 14:27:47.750611+02	r201	3732	mgd[6061]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [6061]		1
1417087	2003-11-27 14:27:47+02	2003-11-27 14:27:47.754977+02	r201	3732	mgd[6061]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1417088	2003-11-27 14:27:47+02	2003-11-27 14:27:47.758782+02	adrastea	3726	mgd[6911]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1417089	2003-11-27 14:27:47+02	2003-11-27 14:27:47.763517+02	adrastea	3726	mgd[6911]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [6911]		1
1417090	2003-11-27 14:27:47+02	2003-11-27 14:27:47.767937+02	ganymede	3731	mgd[4335]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1417091	2003-11-27 14:27:47+02	2003-11-27 14:27:47.772746+02	adrastea	3726	mgd[6912]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1417092	2003-11-27 14:27:47+02	2003-11-27 14:27:47.780958+02	adrastea	3726	mgd[6912]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [6912]		1
1417093	2003-11-27 14:27:47+02	2003-11-27 14:27:47.786117+02	atlas	3730	mgd[4046]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1417094	2003-11-27 14:27:47+02	2003-11-27 14:27:47.900171+02	adrastea	3726	mgd[6912]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1417095	2003-11-27 14:27:47+02	2003-11-27 14:27:47.99264+02	adrastea	3726	mgd[6911]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1417096	2003-11-27 14:27:47+02	2003-11-27 14:27:48.000423+02	r201	3732	mgd[6061]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1417097	2003-11-27 14:27:47+02	2003-11-27 14:27:48.004506+02	ganymede	3731	mgd[4335]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1417098	2003-11-27 14:27:47+02	2003-11-27 14:27:48.008884+02	atlas	3730	mgd[4046]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1417099	2003-11-27 14:27:47+02	2003-11-27 14:27:48.013182+02	r201	3732	mgd[6061]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1416819	2003-11-27 14:38:16+02	2003-11-27 14:21:42.452367+02	jupiter	3727	chassisd[4445]:	CHASSISD_SNMP_TRAP6:	SNMP trap: Power Supply failed: jnxContentsContainerIndex 2, jnxContentsL1Index 2, jnxContentsL2Index 0, jnxContentsL3Index 0, jnxContentsDescr PEM 1, jnxOperatingState/Temp 6 		100
1417100	2003-11-27 14:27:47+02	2003-11-27 14:27:48.017019+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/proc/4434/file'		1
1417101	2003-11-27 14:27:47+02	2003-11-27 14:27:48.025817+02	adrastea	3726	mgd[6911]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1417102	2003-11-27 14:27:47+02	2003-11-27 14:27:48.030543+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/proc/4434/file', PID 6062, status 0		1
1417103	2003-11-27 14:27:47+02	2003-11-27 14:27:48.034647+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/proc/4453/file'		1
1417104	2003-11-27 14:27:47+02	2003-11-27 14:27:48.140168+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/proc/4453/file', PID 6063, status 0		1
1417105	2003-11-27 14:27:47+02	2003-11-27 14:27:48.153053+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/proc/4413/file'		1
1417106	2003-11-27 14:27:47+02	2003-11-27 14:27:48.156921+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/proc/4413/file', PID 6064, status 0		1
1417107	2003-11-27 14:27:47+02	2003-11-27 14:27:48.160834+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/proc/4424/file'		1
1417108	2003-11-27 14:27:47+02	2003-11-27 14:27:48.16762+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/proc/4424/file', PID 6065, status 0		1
1417109	2003-11-27 14:27:47+02	2003-11-27 14:27:48.171376+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1417110	2003-11-27 14:27:47+02	2003-11-27 14:27:48.175869+02	ganymede	3731	mgd[4335]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1417111	2003-11-27 14:27:47+02	2003-11-27 14:27:48.181998+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 6066, status 0		1
1417112	2003-11-27 14:27:47+02	2003-11-27 14:27:48.188343+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/proc/4438/file'		1
1417113	2003-11-27 14:27:47+02	2003-11-27 14:27:48.193093+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/proc/2244/file'		1
1417114	2003-11-27 14:27:47+02	2003-11-27 14:27:48.302161+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/proc/4438/file', PID 6067, status 0		1
1417115	2003-11-27 14:27:47+02	2003-11-27 14:27:48.307682+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/proc/4431/file'		1
1417116	2003-11-27 14:27:47+02	2003-11-27 14:27:48.312082+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/proc/2244/file', PID 4336, status 0		1
1417117	2003-11-27 14:27:47+02	2003-11-27 14:27:48.315787+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/proc/2263/file'		1
1417118	2003-11-27 14:27:47+02	2003-11-27 14:27:48.319866+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/proc/4431/file', PID 6068, status 0		1
1417119	2003-11-27 14:27:47+02	2003-11-27 14:27:48.323575+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/proc/4439/file'		1
1417120	2003-11-27 14:27:47+02	2003-11-27 14:27:48.327281+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/proc/2263/file', PID 4337, status 0		1
1417121	2003-11-27 14:27:47+02	2003-11-27 14:27:48.331051+02	atlas	3730	mgd[4046]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1417122	2003-11-27 14:27:47+02	2003-11-27 14:27:48.334989+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/proc/4439/file', PID 6069, status 0		1
1417123	2003-11-27 14:27:47+02	2003-11-27 14:27:48.338855+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/proc/2224/file'		1
1417124	2003-11-27 14:27:47+02	2003-11-27 14:27:48.453693+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/proc/4433/file'		1
1417125	2003-11-27 14:27:47+02	2003-11-27 14:27:48.470362+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/proc/2258/file'		1
1417126	2003-11-27 14:27:47+02	2003-11-27 14:27:48.547556+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/proc/4433/file', PID 6070, status 0		1
1417127	2003-11-27 14:27:47+02	2003-11-27 14:27:48.607951+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1417128	2003-11-27 14:27:47+02	2003-11-27 14:27:48.620637+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/proc/2224/file', PID 4338, status 0		1
1417129	2003-11-27 14:27:47+02	2003-11-27 14:27:48.626147+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 6071, status 0		1
1417130	2003-11-27 14:27:47+02	2003-11-27 14:27:48.671759+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/proc/2234/file'		1
1417131	2003-11-27 14:27:47+02	2003-11-27 14:27:48.678135+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/proc/4442/file'		1
1417132	2003-11-27 14:27:47+02	2003-11-27 14:27:48.714765+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/proc/2258/file', PID 4047, status 0		1
1417133	2003-11-27 14:27:47+02	2003-11-27 14:27:48.72017+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/proc/2307/file'		1
1417134	2003-11-27 14:27:47+02	2003-11-27 14:27:48.83014+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/proc/4442/file', PID 6072, status 0		1
1417135	2003-11-27 14:27:47+02	2003-11-27 14:27:48.842657+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/proc/2234/file', PID 4339, status 0		1
1417136	2003-11-27 14:27:47+02	2003-11-27 14:27:48.846639+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1417137	2003-11-27 14:27:47+02	2003-11-27 14:27:48.851654+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/proc/2307/file', PID 4048, status 0		1
1417138	2003-11-27 14:27:47+02	2003-11-27 14:27:48.855593+02	adrastea	3726	mgd[6911]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1416852	2003-11-27 14:23:05+02	2003-11-27 14:23:05.664811+02	adrastea	3726	xntpd[2231]:		offset -0.001172 sec freq 76.522 ppm error 0.000360 poll 10		500
1417139	2003-11-27 14:27:47+02	2003-11-27 14:27:48.860565+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1417140	2003-11-27 14:27:47+02	2003-11-27 14:27:48.864528+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4340, status 0		1
1417141	2003-11-27 14:27:47+02	2003-11-27 14:27:48.868548+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/proc/2246/file'		1
1417142	2003-11-27 14:27:47+02	2003-11-27 14:27:48.873976+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 6913, status 0		1
1417143	2003-11-27 14:27:47+02	2003-11-27 14:27:48.988521+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1417144	2003-11-27 14:27:47+02	2003-11-27 14:27:49.143465+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1417145	2003-11-27 14:27:47+02	2003-11-27 14:27:49.163559+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/proc/2246/file', PID 4341, status 0		1
1417146	2003-11-27 14:27:47+02	2003-11-27 14:27:49.216773+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1417147	2003-11-27 14:27:47+02	2003-11-27 14:27:49.223056+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 6914, status 0		1
1417148	2003-11-27 14:27:47+02	2003-11-27 14:27:49.230996+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 4049, status 0		1
1417149	2003-11-27 14:27:47+02	2003-11-27 14:27:49.236332+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1417150	2003-11-27 14:27:47+02	2003-11-27 14:27:49.24202+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1417151	2003-11-27 14:27:47+02	2003-11-27 14:27:49.246247+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 4342, status 0		1
1417152	2003-11-27 14:27:47+02	2003-11-27 14:27:49.252322+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/proc/2247/file'		1
1417153	2003-11-27 14:27:47+02	2003-11-27 14:27:49.258028+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 4050, status 0		1
1417154	2003-11-27 14:27:47+02	2003-11-27 14:27:49.371828+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 6915, status 0		1
1417155	2003-11-27 14:27:47+02	2003-11-27 14:27:49.404922+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1417156	2003-11-27 14:27:47+02	2003-11-27 14:27:49.40994+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/proc/2247/file', PID 4343, status 0		1
1417157	2003-11-27 14:27:47+02	2003-11-27 14:27:49.413756+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/proc/2243/file'		1
1417158	2003-11-27 14:27:47+02	2003-11-27 14:27:49.4177+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1417159	2003-11-27 14:27:47+02	2003-11-27 14:27:49.421862+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 6916, status 0		1
1417160	2003-11-27 14:27:47+02	2003-11-27 14:27:49.426534+02	r201	3732	mgd[6061]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1417161	2003-11-27 14:27:47+02	2003-11-27 14:27:49.43119+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/proc/2243/file', PID 4344, status 0		1
1417162	2003-11-27 14:27:47+02	2003-11-27 14:27:49.436042+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1417163	2003-11-27 14:27:47+02	2003-11-27 14:27:49.441146+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1417164	2003-11-27 14:27:47+02	2003-11-27 14:27:49.550159+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4051, status 0		1
1417165	2003-11-27 14:27:47+02	2003-11-27 14:27:49.573873+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/proc/2259/file'		1
1417166	2003-11-27 14:27:47+02	2003-11-27 14:27:49.580153+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 6917, status 0		1
1417167	2003-11-27 14:27:47+02	2003-11-27 14:27:49.585353+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1417168	2003-11-27 14:27:47+02	2003-11-27 14:27:49.591059+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4345, status 0		1
1417169	2003-11-27 14:27:47+02	2003-11-27 14:27:49.636807+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/proc/2259/file', PID 4052, status 0		1
1417170	2003-11-27 14:27:47+02	2003-11-27 14:27:49.650323+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1417171	2003-11-27 14:27:47+02	2003-11-27 14:27:49.656917+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/proc/2255/file'		1
1417172	2003-11-27 14:27:47+02	2003-11-27 14:27:49.662979+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 6918, status 0		1
1417173	2003-11-27 14:27:47+02	2003-11-27 14:27:49.670477+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1417174	2003-11-27 14:27:47+02	2003-11-27 14:27:49.79016+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/proc/2255/file', PID 4053, status 0		1
1417175	2003-11-27 14:27:47+02	2003-11-27 14:27:49.86892+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 6919, status 0		1
1417176	2003-11-27 14:27:47+02	2003-11-27 14:27:49.958649+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/proc/2260/file'		1
1417177	2003-11-27 14:27:47+02	2003-11-27 14:27:49.96293+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 4346, status 0		1
1417178	2003-11-27 14:27:47+02	2003-11-27 14:27:49.967699+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1417179	2003-11-27 14:27:47+02	2003-11-27 14:27:49.971676+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/proc/2260/file', PID 4054, status 0		1
1417180	2003-11-27 14:27:47+02	2003-11-27 14:27:49.975495+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/proc/2257/file'		1
1417181	2003-11-27 14:27:47+02	2003-11-27 14:27:49.98291+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 6920, status 0		1
1417182	2003-11-27 14:27:47+02	2003-11-27 14:27:49.98747+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1417183	2003-11-27 14:27:47+02	2003-11-27 14:27:49.991643+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/proc/2257/file', PID 4055, status 0		1
1417184	2003-11-27 14:27:47+02	2003-11-27 14:27:50.102536+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1417185	2003-11-27 14:27:47+02	2003-11-27 14:27:50.106554+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 6921, status 0		1
1417186	2003-11-27 14:27:47+02	2003-11-27 14:27:50.11049+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1417187	2003-11-27 14:27:47+02	2003-11-27 14:27:50.114426+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 6922, status 0		1
1417188	2003-11-27 14:27:47+02	2003-11-27 14:27:50.118651+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4056, status 0		1
1417189	2003-11-27 14:27:47+02	2003-11-27 14:27:50.124588+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1417190	2003-11-27 14:27:47+02	2003-11-27 14:27:50.128778+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/proc/2268/file'		1
1417191	2003-11-27 14:27:47+02	2003-11-27 14:27:50.134511+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 6923, status 0		1
1417192	2003-11-27 14:27:47+02	2003-11-27 14:27:50.140103+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1417193	2003-11-27 14:27:47+02	2003-11-27 14:27:50.14401+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/proc/2268/file', PID 4057, status 0		1
1417194	2003-11-27 14:27:47+02	2003-11-27 14:27:50.301186+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 6924, status 0		1
1417195	2003-11-27 14:27:47+02	2003-11-27 14:27:50.305738+02	r201	3732	mgd[6061]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1417196	2003-11-27 14:27:47+02	2003-11-27 14:27:50.310797+02	ganymede	3731	mgd[4335]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1417197	2003-11-27 14:27:47+02	2003-11-27 14:27:50.314938+02	adrastea	3726	mgd[6911]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1417198	2003-11-27 14:27:47+02	2003-11-27 14:27:50.318821+02	atlas	3730	mgd[4046]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1351337	2003-11-21 17:08:45+02	2003-11-21 16:51:25.641638+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351336	2003-11-21 17:08:45+02	2003-11-21 16:51:25.62015+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351338	2003-11-21 17:08:45+02	2003-11-21 16:51:25.645424+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1417199	2003-11-27 14:27:47+02	2003-11-27 14:27:50.324846+02	adrastea	3726	mgd[6911]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1351341	2003-11-21 17:08:46+02	2003-11-21 16:51:26.643638+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351339	2003-11-21 17:08:46+02	2003-11-21 16:51:26.620924+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351340	2003-11-21 17:08:46+02	2003-11-21 16:51:26.639563+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351343	2003-11-21 17:08:47+02	2003-11-21 16:51:27.622932+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351344	2003-11-21 17:08:47+02	2003-11-21 16:51:27.740673+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351345	2003-11-21 17:08:48+02	2003-11-21 16:51:33.166929+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356447	2003-11-21 19:13:45+02	2003-11-21 18:56:27.141862+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1417200	2003-11-27 14:27:47+02	2003-11-27 14:27:50.32924+02	ganymede	3731	mgd[4335]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1417201	2003-11-27 14:27:48+02	2003-11-27 14:27:50.333246+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417202	2003-11-27 14:27:48+02	2003-11-27 14:27:50.338833+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6073, status 0		1
1417203	2003-11-27 14:27:48+02	2003-11-27 14:27:50.347165+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417204	2003-11-27 14:27:48+02	2003-11-27 14:27:50.467248+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6074, status 0		1
1417205	2003-11-27 14:27:48+02	2003-11-27 14:27:50.612758+02	r201	3732	mgd[6061]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1417206	2003-11-27 14:27:48+02	2003-11-27 14:27:50.622725+02	r201	3732	mgd[6061]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417207	2003-11-27 14:27:48+02	2003-11-27 14:27:50.626957+02	atlas	3730	mgd[4046]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1417208	2003-11-27 14:27:48+02	2003-11-27 14:27:50.630949+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417209	2003-11-27 14:27:48+02	2003-11-27 14:27:50.635279+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6925, status 0		1
1417210	2003-11-27 14:27:48+02	2003-11-27 14:27:50.64307+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417211	2003-11-27 14:27:48+02	2003-11-27 14:27:50.647108+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417212	2003-11-27 14:27:48+02	2003-11-27 14:27:50.69797+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc39226fc/32		10
1417213	2003-11-27 14:27:48+02	2003-11-27 14:27:50.720678+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc38c87fc/32		10
1417214	2003-11-27 14:27:48+02	2003-11-27 14:27:50.830398+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc39461fc/32		10
1417215	2003-11-27 14:27:48+02	2003-11-27 14:27:50.881521+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc39226fc/32		10
1417216	2003-11-27 14:27:48+02	2003-11-27 14:27:50.890964+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417217	2003-11-27 14:27:48+02	2003-11-27 14:27:50.901822+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc39226fc/32		10
1417218	2003-11-27 14:27:48+02	2003-11-27 14:27:50.909477+02	r201	3732	mgd[6061]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6075, status 0		1
1417219	2003-11-27 14:27:48+02	2003-11-27 14:27:50.913381+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6926, status 0		1
1417220	2003-11-27 14:27:48+02	2003-11-27 14:27:50.91766+02	adrastea	3726	mgd[6911]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1417221	2003-11-27 14:27:48+02	2003-11-27 14:27:51.026617+02	adrastea	3726	mgd[6911]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304042	2003-11-19 17:00:05+02	2003-11-19 17:00:05.848621+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show pfe statistics traffic '		1
1417222	2003-11-27 14:27:48+02	2003-11-27 14:27:51.037567+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417223	2003-11-27 14:27:48+02	2003-11-27 14:27:51.052831+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4347, status 0		1
1417224	2003-11-27 14:27:48+02	2003-11-27 14:27:51.170297+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417225	2003-11-27 14:27:48+02	2003-11-27 14:27:51.199331+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417226	2003-11-27 14:27:48+02	2003-11-27 14:27:51.206147+02	r201	3732	mgd[6061]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1417227	2003-11-27 14:27:48+02	2003-11-27 14:27:51.210408+02	r201	3732	mgd[6061]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1417228	2003-11-27 14:27:48+02	2003-11-27 14:27:51.214806+02	r201	3732	inetd[4419]:	/usr/libexec/telnetd[6059]:	exit status 0x100		10
1417229	2003-11-27 14:27:48+02	2003-11-27 14:27:51.258461+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4058, status 0		1
1417230	2003-11-27 14:27:48+02	2003-11-27 14:27:51.336418+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4348, status 0		1
1417231	2003-11-27 14:27:48+02	2003-11-27 14:27:51.355084+02	ganymede	3731	mgd[4335]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1417232	2003-11-27 14:27:48+02	2003-11-27 14:27:51.364517+02	ganymede	3731	mgd[4335]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417233	2003-11-27 14:27:48+02	2003-11-27 14:27:51.368544+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417234	2003-11-27 14:27:48+02	2003-11-27 14:27:51.480683+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4059, status 0		1
1417235	2003-11-27 14:27:48+02	2003-11-27 14:27:51.485324+02	atlas	3730	mgd[4046]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1417236	2003-11-27 14:27:48+02	2003-11-27 14:27:51.489458+02	atlas	3730	mgd[4046]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417237	2003-11-27 14:27:48+02	2003-11-27 14:27:51.493317+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417238	2003-11-27 14:27:48+02	2003-11-27 14:27:51.500469+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b620fc/32		10
1417239	2003-11-27 14:27:48+02	2003-11-27 14:27:51.505448+02	adrastea	3726	last		message repeated 4 times		10
1417240	2003-11-27 14:27:48+02	2003-11-27 14:27:51.510582+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304069	2003-11-19 17:00:08+02	2003-11-19 17:00:09.442578+02	ganymede	3731	last		message repeated 3 times		10
1417241	2003-11-27 14:27:48+02	2003-11-27 14:27:51.519066+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1417242	2003-11-27 14:27:48+02	2003-11-27 14:27:51.522976+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1417243	2003-11-27 14:27:48+02	2003-11-27 14:27:51.527571+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1304070	2003-11-19 17:00:09+02	2003-11-19 17:00:09.450371+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1304072	2003-11-19 17:00:09+02	2003-11-19 17:00:09.499043+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1304071	2003-11-19 17:00:09+02	2003-11-19 17:00:09.493762+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1304090	2003-11-19 17:00:09+02	2003-11-19 17:00:10.158909+02	ganymede	3731	mgd[10787]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show ospf database extensive '		1
1304073	2003-11-19 17:00:09+02	2003-11-19 17:00:09.505075+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1417244	2003-11-27 14:27:48+02	2003-11-27 14:27:51.640408+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1304080	2003-11-19 17:00:09+02	2003-11-19 17:00:09.85651+02	ganymede	3731	mgd[10787]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show isis database extensive '		1
1304078	2003-11-19 17:00:09+02	2003-11-19 17:00:09.654954+02	ganymede	3731	mgd[10787]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1417245	2003-11-27 14:27:48+02	2003-11-27 14:27:51.715738+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1417246	2003-11-27 14:27:48+02	2003-11-27 14:27:51.723372+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1417247	2003-11-27 14:27:48+02	2003-11-27 14:27:51.730258+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1417248	2003-11-27 14:27:48+02	2003-11-27 14:27:51.736168+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1304075	2003-11-19 17:00:09+02	2003-11-19 17:00:09.515167+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show pfe statistics traffic '		1
1304074	2003-11-19 17:00:09+02	2003-11-19 17:00:09.510142+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp3 as lab		1
1304079	2003-11-19 17:00:09+02	2003-11-19 17:00:09.753848+02	ganymede	3731	mgd[10787]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1304077	2003-11-19 17:00:09+02	2003-11-19 17:00:09.630556+02	ganymede	3731	mgd[10787]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [10787]		1
1304076	2003-11-19 17:00:09+02	2003-11-19 17:00:09.624777+02	ganymede	3731	mgd[10787]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1304092	2003-11-19 17:00:10+02	2003-11-19 17:00:10.16774+02	ganymede	3731	mgd[10787]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1304093	2003-11-19 17:00:10+02	2003-11-19 17:00:10.174829+02	ganymede	3731	inetd[4403]:	/usr/libexec/telnetd[10785]:	exit status 0x100		10
1417249	2003-11-27 14:27:48+02	2003-11-27 14:27:51.740385+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1304094	2003-11-19 17:00:10+02	2003-11-19 17:00:10.190501+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show pfe statistics traffic '		1
1304091	2003-11-19 17:00:10+02	2003-11-19 17:00:10.163468+02	ganymede	3731	mgd[10787]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1417250	2003-11-27 14:27:48+02	2003-11-27 14:27:51.745468+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1417251	2003-11-27 14:27:48+02	2003-11-27 14:27:51.750719+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1417252	2003-11-27 14:27:48+02	2003-11-27 14:27:51.755124+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1417253	2003-11-27 14:27:48+02	2003-11-27 14:27:51.759873+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1417254	2003-11-27 14:27:48+02	2003-11-27 14:27:51.87038+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1417255	2003-11-27 14:27:48+02	2003-11-27 14:27:51.950062+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1417256	2003-11-27 14:27:48+02	2003-11-27 14:27:51.963824+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1417257	2003-11-27 14:27:48+02	2003-11-27 14:27:51.977596+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1417258	2003-11-27 14:27:48+02	2003-11-27 14:27:51.982014+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1417259	2003-11-27 14:27:48+02	2003-11-27 14:27:51.986596+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1417260	2003-11-27 14:27:48+02	2003-11-27 14:27:51.991959+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1417261	2003-11-27 14:27:48+02	2003-11-27 14:27:51.996918+02	adrastea	3726	mgd[6912]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1417262	2003-11-27 14:27:48+02	2003-11-27 14:27:52.00486+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304110	2003-11-19 17:00:12+02	2003-11-19 17:00:13.512538+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run start shell '		1
1417263	2003-11-27 14:27:48+02	2003-11-27 14:27:52.009111+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b8f5fc/32		10
1417264	2003-11-27 14:27:48+02	2003-11-27 14:27:52.125515+02	atlas	3730	last		message repeated 2 times		10
1417265	2003-11-27 14:27:48+02	2003-11-27 14:27:52.133506+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417266	2003-11-27 14:27:48+02	2003-11-27 14:27:52.14171+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417267	2003-11-27 14:27:48+02	2003-11-27 14:27:52.145883+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b8f5fc/32		10
1417268	2003-11-27 14:27:48+02	2003-11-27 14:27:52.150118+02	atlas	3730	mgd[4046]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4060, status 0		1
1417269	2003-11-27 14:27:48+02	2003-11-27 14:27:52.154069+02	adrastea	3726	mgd[6912]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1417270	2003-11-27 14:27:48+02	2003-11-27 14:27:52.158187+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1417271	2003-11-27 14:27:48+02	2003-11-27 14:27:53.921337+02	172.26.27.37	3733	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 6928, status 0		1
1304111	2003-11-19 17:00:13+02	2003-11-19 17:00:13.516566+02	ganymede	3731	su:		lab to root on /dev/ttyp0		10
1417272	2003-11-27 14:27:48+02	2003-11-27 14:27:53.933008+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1417273	2003-11-27 14:27:48+02	2003-11-27 14:27:53.937666+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 6929, status 0		1
1417274	2003-11-27 14:27:48+02	2003-11-27 14:27:54.050206+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1417275	2003-11-27 14:27:48+02	2003-11-27 14:27:54.053961+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 6930, status 0		1
1417276	2003-11-27 14:27:48+02	2003-11-27 14:27:54.058209+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1417277	2003-11-27 14:27:48+02	2003-11-27 14:27:54.062742+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 6931, status 0		1
1417278	2003-11-27 14:27:48+02	2003-11-27 14:27:54.066537+02	atlas	3730	mgd[4046]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1417279	2003-11-27 14:27:48+02	2003-11-27 14:27:54.070712+02	atlas	3730	mgd[4046]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1417280	2003-11-27 14:27:48+02	2003-11-27 14:27:54.09439+02	atlas	3730	inetd[2245]:	/usr/libexec/telnetd[4044]:	exit status 0x100		10
1417281	2003-11-27 14:27:49+02	2003-11-27 14:27:54.098228+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1417282	2003-11-27 14:27:49+02	2003-11-27 14:27:54.103827+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 6932, status 0		1
1417283	2003-11-27 14:27:49+02	2003-11-27 14:27:54.107663+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1417284	2003-11-27 14:27:49+02	2003-11-27 14:27:54.280336+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 6933, status 0		1
1417285	2003-11-27 14:27:49+02	2003-11-27 14:27:54.285797+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1417286	2003-11-27 14:27:49+02	2003-11-27 14:27:54.289883+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 6934, status 0		1
1417287	2003-11-27 14:27:49+02	2003-11-27 14:27:54.298506+02	adrastea	3726	mgd[6911]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6927, status 0		1
1417288	2003-11-27 14:27:49+02	2003-11-27 14:27:54.303138+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1417289	2003-11-27 14:27:49+02	2003-11-27 14:27:54.338623+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304139	2003-11-19 17:00:17+02	2003-11-19 17:00:18.510974+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1304159	2003-11-19 17:00:17+02	2003-11-19 17:00:18.830993+02	r201	3732	mgd[10644]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [10644]		1
1304148	2003-11-19 17:00:17+02	2003-11-19 17:00:18.677255+02	r201	3732	login:		login from 172.26.27.115 on ttyp2 as lab		1
1304143	2003-11-19 17:00:17+02	2003-11-19 17:00:18.54001+02	atlas	3730	login:		login from 172.26.27.115 on ttyp2 as lab		1
1304144	2003-11-19 17:00:17+02	2003-11-19 17:00:18.54521+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1304158	2003-11-19 17:00:17+02	2003-11-19 17:00:18.827143+02	r201	3732	mgd[10644]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1304137	2003-11-19 17:00:17+02	2003-11-19 17:00:18.498697+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp1		1
1304161	2003-11-19 17:00:17+02	2003-11-19 17:00:18.840101+02	atlas	3730	mgd[4782]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4782]		1
1304146	2003-11-19 17:00:17+02	2003-11-19 17:00:18.661371+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1304138	2003-11-19 17:00:17+02	2003-11-19 17:00:18.505771+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp1 as lab		1
1304136	2003-11-19 17:00:17+02	2003-11-19 17:00:18.492176+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp3 as lab		1
1304134	2003-11-19 17:00:17+02	2003-11-19 17:00:18.374376+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1304133	2003-11-19 17:00:17+02	2003-11-19 17:00:18.369039+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1304145	2003-11-19 17:00:17+02	2003-11-19 17:00:18.65391+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1304160	2003-11-19 17:00:17+02	2003-11-19 17:00:18.836171+02	atlas	3730	mgd[4782]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1304131	2003-11-19 17:00:17+02	2003-11-19 17:00:18.278152+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp0 as lab		1
1304132	2003-11-19 17:00:17+02	2003-11-19 17:00:18.289039+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1304135	2003-11-19 17:00:17+02	2003-11-19 17:00:18.484082+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1304140	2003-11-19 17:00:17+02	2003-11-19 17:00:18.517905+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1304141	2003-11-19 17:00:17+02	2003-11-19 17:00:18.526183+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1304156	2003-11-19 17:00:17+02	2003-11-19 17:00:18.819419+02	ganymede	3731	mgd[10797]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1304157	2003-11-19 17:00:17+02	2003-11-19 17:00:18.823316+02	ganymede	3731	mgd[10797]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [10797]		1
1304130	2003-11-19 17:00:17+02	2003-11-19 17:00:17.887269+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1304142	2003-11-19 17:00:17+02	2003-11-19 17:00:18.533076+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1304147	2003-11-19 17:00:17+02	2003-11-19 17:00:18.667133+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1304202	2003-11-19 17:00:18+02	2003-11-19 17:00:19.656917+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1304181	2003-11-19 17:00:18+02	2003-11-19 17:00:19.206572+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/proc/4399/file'		1
1304187	2003-11-19 17:00:18+02	2003-11-19 17:00:19.351929+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/4431/file'		1
1304188	2003-11-19 17:00:18+02	2003-11-19 17:00:19.355912+02	adrastea	3726	mgd[4741]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1304213	2003-11-19 17:00:18+02	2003-11-19 17:00:19.939739+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/proc/4520/file'		1
1304229	2003-11-19 17:00:18+02	2003-11-19 17:00:20.316879+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/proc/4426/file', PID 10805, status 0		1
1304201	2003-11-19 17:00:18+02	2003-11-19 17:00:19.652677+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 10647, status 0		1
1304300	2003-11-19 17:00:18+02	2003-11-19 17:00:22.228674+02	r201	3732	mgd[10644]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1304191	2003-11-19 17:00:18+02	2003-11-19 17:00:19.440229+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/proc/4516/file', PID 10801, status 0		1
1304200	2003-11-19 17:00:18+02	2003-11-19 17:00:19.647812+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/4442/file', PID 4784, status 0		1
1304263	2003-11-19 17:00:18+02	2003-11-19 17:00:21.075033+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/4429/file', PID 4791, status 0		1
1304205	2003-11-19 17:00:18+02	2003-11-19 17:00:19.774163+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/proc/4425/file'		1
1304176	2003-11-19 17:00:18+02	2003-11-19 17:00:19.17979+02	ganymede	3731	mgd[10797]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1304212	2003-11-19 17:00:18+02	2003-11-19 17:00:19.876049+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/proc/2255/file'		1
1304203	2003-11-19 17:00:18+02	2003-11-19 17:00:19.66165+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 4743, status 0		1
1304204	2003-11-19 17:00:18+02	2003-11-19 17:00:19.667154+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 10802, status 0		1
1304211	2003-11-19 17:00:18+02	2003-11-19 17:00:19.869518+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 10649, status 0		1
1304206	2003-11-19 17:00:18+02	2003-11-19 17:00:19.834096+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 10648, status 0		1
1304210	2003-11-19 17:00:18+02	2003-11-19 17:00:19.865319+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/proc/4425/file', PID 10803, status 0		1
1304209	2003-11-19 17:00:18+02	2003-11-19 17:00:19.849721+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/4407/file'		1
1304208	2003-11-19 17:00:18+02	2003-11-19 17:00:19.84552+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1304207	2003-11-19 17:00:18+02	2003-11-19 17:00:19.840956+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1304221	2003-11-19 17:00:18+02	2003-11-19 17:00:20.121296+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 4745, status 0		1
1304214	2003-11-19 17:00:18+02	2003-11-19 17:00:19.944865+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 4744, status 0		1
1304216	2003-11-19 17:00:18+02	2003-11-19 17:00:20.071383+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/proc/2255/file', PID 10650, status 0		1
1304186	2003-11-19 17:00:18+02	2003-11-19 17:00:19.347119+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/proc/2254/file'		1
1304182	2003-11-19 17:00:18+02	2003-11-19 17:00:19.211319+02	r201	3732	mgd[10644]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1417290	2003-11-27 14:27:49+02	2003-11-27 14:27:54.345243+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1baa1fc/32		10
1417291	2003-11-27 14:27:49+02	2003-11-27 14:27:54.349505+02	ganymede	3731	last		message repeated 5 times		10
1417292	2003-11-27 14:27:49+02	2003-11-27 14:27:54.40225+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417293	2003-11-27 14:27:49+02	2003-11-27 14:27:54.406005+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b2cbfc/32		10
1417294	2003-11-27 14:27:49+02	2003-11-27 14:27:54.510273+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417295	2003-11-27 14:27:49+02	2003-11-27 14:27:54.515726+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b2cbfc/32		10
1417296	2003-11-27 14:27:49+02	2003-11-27 14:27:54.574359+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1417297	2003-11-27 14:27:49+02	2003-11-27 14:27:54.578124+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1417298	2003-11-27 14:27:49+02	2003-11-27 14:27:54.582002+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/0) ifd vptree not initialized		10
1417299	2003-11-27 14:27:49+02	2003-11-27 14:27:54.585917+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1417300	2003-11-27 14:27:49+02	2003-11-27 14:27:54.592543+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1417301	2003-11-27 14:27:49+02	2003-11-27 14:27:54.59632+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1417302	2003-11-27 14:27:49+02	2003-11-27 14:27:54.600173+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1417303	2003-11-27 14:27:49+02	2003-11-27 14:27:54.603914+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/1) ifd vptree not initialized		10
1417304	2003-11-27 14:27:49+02	2003-11-27 14:27:54.716049+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1417305	2003-11-27 14:27:49+02	2003-11-27 14:27:54.7225+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1417306	2003-11-27 14:27:49+02	2003-11-27 14:27:54.726376+02	ganymede	3731	mgd[4335]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4349, status 0		1
1417307	2003-11-27 14:27:49+02	2003-11-27 14:27:54.730203+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 6935, status 0		1
1417308	2003-11-27 14:27:49+02	2003-11-27 14:27:54.73391+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1417309	2003-11-27 14:27:49+02	2003-11-27 14:27:54.73764+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 6936, status 0		1
1417310	2003-11-27 14:27:49+02	2003-11-27 14:27:54.74139+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1417311	2003-11-27 14:27:49+02	2003-11-27 14:27:54.745113+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 6937, status 0		1
1417312	2003-11-27 14:27:49+02	2003-11-27 14:27:54.748846+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1417313	2003-11-27 14:27:49+02	2003-11-27 14:27:54.752989+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 6938, status 0		1
1417314	2003-11-27 14:27:49+02	2003-11-27 14:27:54.860613+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1417315	2003-11-27 14:27:49+02	2003-11-27 14:27:54.866121+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 6939, status 0		1
1417316	2003-11-27 14:27:49+02	2003-11-27 14:27:54.870119+02	adrastea	3726	mgd[6912]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1417317	2003-11-27 14:27:49+02	2003-11-27 14:27:54.873856+02	adrastea	3726	mgd[6911]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1417318	2003-11-27 14:27:49+02	2003-11-27 14:27:54.877581+02	adrastea	3726	mgd[6911]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1417319	2003-11-27 14:27:49+02	2003-11-27 14:27:54.881478+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[6908]:	exit status 0x100		10
1417320	2003-11-27 14:27:49+02	2003-11-27 14:27:54.885431+02	ganymede	3731	mgd[4335]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1417321	2003-11-27 14:27:49+02	2003-11-27 14:27:54.889139+02	ganymede	3731	mgd[4335]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1417322	2003-11-27 14:27:49+02	2003-11-27 14:27:54.893688+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[4333]:	exit status 0x100		10
1417323	2003-11-27 14:27:49+02	2003-11-27 14:27:54.89751+02	adrastea	3726	mgd[6912]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1417324	2003-11-27 14:27:49+02	2003-11-27 14:27:55.010552+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417325	2003-11-27 14:27:49+02	2003-11-27 14:27:55.016157+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6940, status 0		1
1417326	2003-11-27 14:27:49+02	2003-11-27 14:27:55.02386+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417327	2003-11-27 14:27:49+02	2003-11-27 14:27:55.027915+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6941, status 0		1
1417328	2003-11-27 14:27:49+02	2003-11-27 14:27:55.032019+02	adrastea	3726	mgd[6912]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1417329	2003-11-27 14:27:49+02	2003-11-27 14:27:55.035874+02	adrastea	3726	mgd[6912]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417330	2003-11-27 14:27:49+02	2003-11-27 14:27:55.087698+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417331	2003-11-27 14:27:49+02	2003-11-27 14:27:55.093145+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1baccfc/32		10
1417332	2003-11-27 14:27:49+02	2003-11-27 14:27:55.096892+02	adrastea	3726	last		message repeated 4 times		10
1417333	2003-11-27 14:27:49+02	2003-11-27 14:27:55.108193+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417334	2003-11-27 14:27:53+02	2003-11-27 14:27:55.220616+02	deimos	0	314297:		Nov 27 12:27:49.032 UTC: BGP: 62.154.13.1 multihop open delayed 19456ms (no route)		10
1417335	2003-11-27 14:44:24+02	2003-11-27 14:27:55.226019+02	jupiter	3727	login:	tac_send_authen:	connect: timed out		1
1417336	2003-11-27 14:44:24+02	2003-11-27 14:27:55.23167+02	jupiter	3727	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1417337	2003-11-27 14:44:24+02	2003-11-27 14:27:55.236611+02	jupiter	3727	login:		login from 172.26.27.115 on ttyp0 as lab		1
1417338	2003-11-27 14:44:24+02	2003-11-27 14:27:55.241698+02	jupiter	3727	mgd[8978]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1417339	2003-11-27 14:44:24+02	2003-11-27 14:27:55.245635+02	jupiter	3727	mgd[8978]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [8978]		1
1417340	2003-11-27 14:44:24+02	2003-11-27 14:27:55.251375+02	jupiter	3727	mgd[8978]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1417341	2003-11-27 14:44:24+02	2003-11-27 14:27:59.023709+02	172.26.27.18	3734	mgd[8978]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1304215	2003-11-19 17:00:18+02	2003-11-19 17:00:20.054267+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1304217	2003-11-19 17:00:18+02	2003-11-19 17:00:20.076179+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/4407/file', PID 4785, status 0		1
1304228	2003-11-19 17:00:18+02	2003-11-19 17:00:20.312229+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1304220	2003-11-19 17:00:18+02	2003-11-19 17:00:20.09194+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/proc/4520/file', PID 10804, status 0		1
1304172	2003-11-19 17:00:18+02	2003-11-19 17:00:19.054876+02	r201	3732	mgd[10644]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1304218	2003-11-19 17:00:18+02	2003-11-19 17:00:20.082776+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/4419/file'		1
1304219	2003-11-19 17:00:18+02	2003-11-19 17:00:20.08814+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1304227	2003-11-19 17:00:18+02	2003-11-19 17:00:20.306484+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 10652, status 0		1
1304223	2003-11-19 17:00:18+02	2003-11-19 17:00:20.131119+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/proc/4426/file'		1
1304184	2003-11-19 17:00:18+02	2003-11-19 17:00:19.219919+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/proc/4399/file', PID 10800, status 0		1
1304222	2003-11-19 17:00:18+02	2003-11-19 17:00:20.127182+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 10651, status 0		1
1304224	2003-11-19 17:00:18+02	2003-11-19 17:00:20.141366+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1304226	2003-11-19 17:00:18+02	2003-11-19 17:00:20.300615+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1304225	2003-11-19 17:00:18+02	2003-11-19 17:00:20.25422+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/4419/file', PID 4786, status 0		1
1304171	2003-11-19 17:00:18+02	2003-11-19 17:00:19.050623+02	ganymede	3731	mgd[10797]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1304185	2003-11-19 17:00:18+02	2003-11-19 17:00:19.337401+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/proc/4516/file'		1
1304232	2003-11-19 17:00:18+02	2003-11-19 17:00:20.331467+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1304231	2003-11-19 17:00:18+02	2003-11-19 17:00:20.326251+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 10653, status 0		1
1304238	2003-11-19 17:00:18+02	2003-11-19 17:00:20.473743+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/proc/4409/file', PID 10806, status 0		1
1304230	2003-11-19 17:00:18+02	2003-11-19 17:00:20.32175+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/proc/4409/file'		1
1304247	2003-11-19 17:00:18+02	2003-11-19 17:00:20.695425+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 4748, status 0		1
1304233	2003-11-19 17:00:18+02	2003-11-19 17:00:20.335908+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4746, status 0		1
1304237	2003-11-19 17:00:18+02	2003-11-19 17:00:20.469057+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/proc/2259/file'		1
1304234	2003-11-19 17:00:18+02	2003-11-19 17:00:20.340352+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1304236	2003-11-19 17:00:18+02	2003-11-19 17:00:20.462011+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 10654, status 0		1
1304235	2003-11-19 17:00:18+02	2003-11-19 17:00:20.456647+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1304262	2003-11-19 17:00:18+02	2003-11-19 17:00:21.070738+02	r201	3732	mgd[10644]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1304241	2003-11-19 17:00:18+02	2003-11-19 17:00:20.485791+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/proc/2259/file', PID 10655, status 0		1
1304168	2003-11-19 17:00:18+02	2003-11-19 17:00:19.038674+02	adrastea	3726	mgd[4741]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4741]		1
1304246	2003-11-19 17:00:18+02	2003-11-19 17:00:20.690437+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/proc/4429/file'		1
1304240	2003-11-19 17:00:18+02	2003-11-19 17:00:20.481888+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 4747, status 0		1
1304239	2003-11-19 17:00:18+02	2003-11-19 17:00:20.477914+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1304242	2003-11-19 17:00:18+02	2003-11-19 17:00:20.493276+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4787, status 0		1
1304245	2003-11-19 17:00:18+02	2003-11-19 17:00:20.685706+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 10807, status 0		1
1304243	2003-11-19 17:00:18+02	2003-11-19 17:00:20.505279+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/4432/file'		1
1304244	2003-11-19 17:00:18+02	2003-11-19 17:00:20.57562+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1304170	2003-11-19 17:00:18+02	2003-11-19 17:00:19.046649+02	adrastea	3726	mgd[4740]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1304250	2003-11-19 17:00:18+02	2003-11-19 17:00:20.710752+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/4426/file'		1
1304260	2003-11-19 17:00:18+02	2003-11-19 17:00:21.060926+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4751, status 0		1
1304249	2003-11-19 17:00:18+02	2003-11-19 17:00:20.705974+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1304248	2003-11-19 17:00:18+02	2003-11-19 17:00:20.699442+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/4432/file', PID 4788, status 0		1
1304259	2003-11-19 17:00:18+02	2003-11-19 17:00:21.054524+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/4429/file'		1
1304169	2003-11-19 17:00:18+02	2003-11-19 17:00:19.042708+02	adrastea	3726	mgd[4741]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1304256	2003-11-19 17:00:18+02	2003-11-19 17:00:20.961452+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 4750, status 0		1
1304251	2003-11-19 17:00:18+02	2003-11-19 17:00:20.714658+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/proc/4429/file', PID 10808, status 0		1
1304255	2003-11-19 17:00:18+02	2003-11-19 17:00:20.834791+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/4433/file'		1
1304253	2003-11-19 17:00:18+02	2003-11-19 17:00:20.724814+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1304254	2003-11-19 17:00:18+02	2003-11-19 17:00:20.728965+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/4426/file', PID 4789, status 0		1
1304252	2003-11-19 17:00:18+02	2003-11-19 17:00:20.719992+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 4749, status 0		1
1417342	2003-11-27 14:44:24+02	2003-11-27 14:27:59.32109+02	jupiter	3727	mgd[8978]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1417343	2003-11-27 14:44:24+02	2003-11-27 14:27:59.461683+02	jupiter	3727	mgd[8978]:	UI_CHILD_START:	Starting child '/proc/4616/file'		1
1417344	2003-11-27 14:44:24+02	2003-11-27 14:27:59.466183+02	jupiter	3727	mgd[8978]:	UI_CHILD_STATUS:	Cleanup child '/proc/4616/file', PID 8979, status 0		1
1417345	2003-11-27 14:44:24+02	2003-11-27 14:27:59.470389+02	jupiter	3727	mgd[8978]:	UI_CHILD_START:	Starting child '/proc/4615/file'		1
1417346	2003-11-27 14:44:24+02	2003-11-27 14:27:59.474347+02	jupiter	3727	mgd[8978]:	UI_CHILD_STATUS:	Cleanup child '/proc/4615/file', PID 8980, status 0		1
1417347	2003-11-27 14:44:24+02	2003-11-27 14:27:59.478038+02	jupiter	3727	mgd[8978]:	UI_CHILD_START:	Starting child '/proc/4447/file'		1
1417348	2003-11-27 14:27:50+02	2003-11-27 14:27:59.481938+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1417349	2003-11-27 14:27:50+02	2003-11-27 14:27:59.502603+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1417350	2003-11-27 14:27:50+02	2003-11-27 14:27:59.506363+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1417351	2003-11-27 14:27:50+02	2003-11-27 14:27:59.620334+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1417352	2003-11-27 14:27:50+02	2003-11-27 14:27:59.625805+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1417353	2003-11-27 14:27:50+02	2003-11-27 14:27:59.629703+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1417354	2003-11-27 14:27:50+02	2003-11-27 14:27:59.633528+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1417355	2003-11-27 14:27:50+02	2003-11-27 14:27:59.637321+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1417356	2003-11-27 14:27:50+02	2003-11-27 14:27:59.641143+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1417357	2003-11-27 14:27:50+02	2003-11-27 14:27:59.644872+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1417358	2003-11-27 14:27:50+02	2003-11-27 14:27:59.648558+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1417359	2003-11-27 14:27:50+02	2003-11-27 14:27:59.652306+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1417360	2003-11-27 14:27:50+02	2003-11-27 14:27:59.69189+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1417361	2003-11-27 14:27:50+02	2003-11-27 14:27:59.800318+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1417362	2003-11-27 14:27:50+02	2003-11-27 14:27:59.805769+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1417363	2003-11-27 14:27:50+02	2003-11-27 14:27:59.810914+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1417364	2003-11-27 14:27:50+02	2003-11-27 14:27:59.814827+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1417365	2003-11-27 14:27:50+02	2003-11-27 14:27:59.820441+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1417366	2003-11-27 14:27:50+02	2003-11-27 14:27:59.824333+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1417367	2003-11-27 14:27:50+02	2003-11-27 14:27:59.828132+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1417368	2003-11-27 14:27:50+02	2003-11-27 14:27:59.832226+02	adrastea	3726	mgd[6912]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6942, status 0		1
1417369	2003-11-27 14:44:24+02	2003-11-27 14:27:59.836026+02	jupiter	3727	mgd[8978]:	UI_CHILD_STATUS:	Cleanup child '/proc/4447/file', PID 8981, status 0		1
1417370	2003-11-27 14:44:24+02	2003-11-27 14:27:59.839964+02	jupiter	3727	mgd[8978]:	UI_CHILD_START:	Starting child '/proc/4601/file'		1
1417371	2003-11-27 14:44:24+02	2003-11-27 14:27:59.950372+02	jupiter	3727	mgd[8978]:	UI_CHILD_STATUS:	Cleanup child '/proc/4601/file', PID 8982, status 0		1
1417372	2003-11-27 14:44:24+02	2003-11-27 14:27:59.955838+02	jupiter	3727	mgd[8978]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1417373	2003-11-27 14:44:24+02	2003-11-27 14:27:59.959667+02	jupiter	3727	mgd[8978]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 8983, status 0		1
1417374	2003-11-27 14:44:24+02	2003-11-27 14:27:59.963458+02	jupiter	3727	mgd[8978]:	UI_CHILD_START:	Starting child '/proc/4459/file'		1
1417375	2003-11-27 14:44:29+02	2003-11-27 14:27:59.967181+02	jupiter	3727	login:	tac_send_authen:	connect: timed out		1
1417376	2003-11-27 14:44:29+02	2003-11-27 14:27:59.972993+02	jupiter	3727	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1417377	2003-11-27 14:44:29+02	2003-11-27 14:27:59.977869+02	jupiter	3727	login:		login from 172.26.27.115 on ttyp0 as lab		1
1417378	2003-11-27 14:44:29+02	2003-11-27 14:27:59.982997+02	jupiter	3727	mgd[8996]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1417379	2003-11-27 14:44:29+02	2003-11-27 14:27:59.986988+02	jupiter	3727	mgd[8996]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [8996]		1
1417380	2003-11-27 14:44:29+02	2003-11-27 14:28:00.10032+02	jupiter	3727	mgd[8996]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1417381	2003-11-27 14:44:29+02	2003-11-27 14:28:00.105759+02	jupiter	3727	mgd[8996]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1417382	2003-11-27 14:44:29+02	2003-11-27 14:28:00.110202+02	jupiter	3727	mgd[8996]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1417383	2003-11-27 14:44:29+02	2003-11-27 14:28:00.114161+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/proc/4616/file'		1
1417384	2003-11-27 14:44:29+02	2003-11-27 14:28:00.117918+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/proc/4616/file', PID 8997, status 0		1
1417385	2003-11-27 14:44:29+02	2003-11-27 14:28:00.12177+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/proc/4615/file'		1
1417386	2003-11-27 14:44:29+02	2003-11-27 14:28:00.125486+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/proc/4615/file', PID 8998, status 0		1
1357177	2003-11-21 19:33:48+02	2003-11-21 19:16:29.450036+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1417387	2003-11-27 14:44:29+02	2003-11-27 14:28:00.129203+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/proc/4447/file'		1
1417388	2003-11-27 14:44:29+02	2003-11-27 14:28:00.132943+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/proc/4447/file', PID 8999, status 0		1
1417389	2003-11-27 14:44:29+02	2003-11-27 14:28:00.136667+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/proc/4601/file'		1
1417390	2003-11-27 14:44:29+02	2003-11-27 14:28:00.251591+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/proc/4601/file', PID 9000, status 0		1
1417391	2003-11-27 14:44:29+02	2003-11-27 14:28:00.257102+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1304257	2003-11-19 17:00:18+02	2003-11-19 17:00:21.031701+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1304258	2003-11-19 17:00:18+02	2003-11-19 17:00:21.048667+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/4433/file', PID 4790, status 0		1
1304284	2003-11-19 17:00:18+02	2003-11-19 17:00:21.878976+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 4759, status 0		1
1304319	2003-11-19 17:00:18+02	2003-11-19 17:00:22.671737+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304265	2003-11-19 17:00:18+02	2003-11-19 17:00:21.184089+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 4752, status 0		1
1304174	2003-11-19 17:00:18+02	2003-11-19 17:00:19.068167+02	adrastea	3726	mgd[4741]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1304175	2003-11-19 17:00:18+02	2003-11-19 17:00:19.174099+02	adrastea	3726	mgd[4740]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1304280	2003-11-19 17:00:18+02	2003-11-19 17:00:21.653048+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 4757, status 0		1
1304189	2003-11-19 17:00:18+02	2003-11-19 17:00:19.371782+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/proc/2254/file', PID 10645, status 0		1
1304264	2003-11-19 17:00:18+02	2003-11-19 17:00:21.079171+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1304270	2003-11-19 17:00:18+02	2003-11-19 17:00:21.280883+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/4436/file', PID 4793, status 0		1
1304190	2003-11-19 17:00:18+02	2003-11-19 17:00:19.424154+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/proc/2264/file'		1
1304299	2003-11-19 17:00:18+02	2003-11-19 17:00:22.224404+02	atlas	3730	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1304267	2003-11-19 17:00:18+02	2003-11-19 17:00:21.193177+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4792, status 0		1
1304269	2003-11-19 17:00:18+02	2003-11-19 17:00:21.265047+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/4436/file'		1
1304266	2003-11-19 17:00:18+02	2003-11-19 17:00:21.188165+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1304268	2003-11-19 17:00:18+02	2003-11-19 17:00:21.197399+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 4753, status 0		1
1304273	2003-11-19 17:00:18+02	2003-11-19 17:00:21.334667+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 4754, status 0		1
1304272	2003-11-19 17:00:18+02	2003-11-19 17:00:21.295836+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1304271	2003-11-19 17:00:18+02	2003-11-19 17:00:21.288689+02	adrastea	3726	mgd[4740]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1304279	2003-11-19 17:00:18+02	2003-11-19 17:00:21.596849+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1304173	2003-11-19 17:00:18+02	2003-11-19 17:00:19.058727+02	atlas	3730	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1304274	2003-11-19 17:00:18+02	2003-11-19 17:00:21.393283+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1304278	2003-11-19 17:00:18+02	2003-11-19 17:00:21.59108+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 4756, status 0		1
1304275	2003-11-19 17:00:18+02	2003-11-19 17:00:21.508291+02	ganymede	3731	mgd[10797]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1304276	2003-11-19 17:00:18+02	2003-11-19 17:00:21.525024+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 4755, status 0		1
1304277	2003-11-19 17:00:18+02	2003-11-19 17:00:21.581032+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1304282	2003-11-19 17:00:18+02	2003-11-19 17:00:21.869746+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4758, status 0		1
1304281	2003-11-19 17:00:18+02	2003-11-19 17:00:21.864217+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1304283	2003-11-19 17:00:18+02	2003-11-19 17:00:21.874988+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1304287	2003-11-19 17:00:18+02	2003-11-19 17:00:21.996616+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 4760, status 0		1
1304298	2003-11-19 17:00:18+02	2003-11-19 17:00:22.219832+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 4765, status 0		1
1304286	2003-11-19 17:00:18+02	2003-11-19 17:00:21.991824+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1304285	2003-11-19 17:00:18+02	2003-11-19 17:00:21.984183+02	atlas	3730	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1304289	2003-11-19 17:00:18+02	2003-11-19 17:00:22.005525+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 4761, status 0		1
1304291	2003-11-19 17:00:18+02	2003-11-19 17:00:22.016154+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 4762, status 0		1
1304288	2003-11-19 17:00:18+02	2003-11-19 17:00:22.000807+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1304297	2003-11-19 17:00:18+02	2003-11-19 17:00:22.213843+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1304261	2003-11-19 17:00:18+02	2003-11-19 17:00:21.066732+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1304290	2003-11-19 17:00:18+02	2003-11-19 17:00:22.00978+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1304294	2003-11-19 17:00:18+02	2003-11-19 17:00:22.086265+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1304296	2003-11-19 17:00:18+02	2003-11-19 17:00:22.208823+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 4764, status 0		1
1304293	2003-11-19 17:00:18+02	2003-11-19 17:00:22.077824+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4763, status 0		1
1304292	2003-11-19 17:00:18+02	2003-11-19 17:00:22.020153+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1304295	2003-11-19 17:00:18+02	2003-11-19 17:00:22.194126+02	ganymede	3731	mgd[10797]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1304313	2003-11-19 17:00:18+02	2003-11-19 17:00:22.475502+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304304	2003-11-19 17:00:18+02	2003-11-19 17:00:22.300324+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417392	2003-11-27 14:44:29+02	2003-11-27 14:28:00.260845+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 9001, status 0		1
1417393	2003-11-27 14:44:29+02	2003-11-27 14:28:00.264737+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/proc/4459/file'		1
1417394	2003-11-27 14:44:29+02	2003-11-27 14:28:00.268439+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/proc/4459/file', PID 9002, status 0		1
1417395	2003-11-27 14:44:29+02	2003-11-27 14:28:00.31925+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/proc/4605/file'		1
1417396	2003-11-27 14:44:29+02	2003-11-27 14:28:00.323084+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/proc/4605/file', PID 9003, status 0		1
1417397	2003-11-27 14:44:29+02	2003-11-27 14:28:00.37759+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/proc/4609/file'		1
1417398	2003-11-27 14:44:29+02	2003-11-27 14:28:00.381693+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/proc/4609/file', PID 9004, status 0		1
1417399	2003-11-27 14:44:29+02	2003-11-27 14:28:00.385557+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/proc/4457/file'		1
1417400	2003-11-27 14:44:29+02	2003-11-27 14:28:00.490895+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/proc/4457/file', PID 9005, status 0		1
1417401	2003-11-27 14:44:29+02	2003-11-27 14:28:00.496324+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1417402	2003-11-27 14:44:29+02	2003-11-27 14:28:00.500245+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 9006, status 0		1
1417403	2003-11-27 14:44:29+02	2003-11-27 14:28:00.55038+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1417404	2003-11-27 14:44:29+02	2003-11-27 14:28:00.554285+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 9007, status 0		1
1417405	2003-11-27 14:44:29+02	2003-11-27 14:28:00.558006+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/proc/4461/file'		1
1417406	2003-11-27 14:44:29+02	2003-11-27 14:28:00.561929+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/proc/4461/file', PID 9008, status 0		1
1417407	2003-11-27 14:44:29+02	2003-11-27 14:28:00.565632+02	jupiter	3727	mgd[8996]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1417408	2003-11-27 14:44:30+02	2003-11-27 14:28:00.569718+02	jupiter	3727	mgd[8996]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1417409	2003-11-27 14:44:30+02	2003-11-27 14:28:00.573604+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417410	2003-11-27 14:44:30+02	2003-11-27 14:28:00.680313+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 9009, status 0		1
1417411	2003-11-27 14:44:30+02	2003-11-27 14:28:00.685646+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417412	2003-11-27 14:44:30+02	2003-11-27 14:28:00.690847+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 9010, status 0		1
1417413	2003-11-27 14:44:30+02	2003-11-27 14:28:00.694716+02	jupiter	3727	mgd[8996]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1417414	2003-11-27 14:44:30+02	2003-11-27 14:28:00.69843+02	jupiter	3727	mgd[8996]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1417415	2003-11-27 15:01:09+02	2003-11-27 14:28:00.70299+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.59+639 addr 192.168.1.59+639: No route to host		10
1417416	2003-11-27 14:44:31+02	2003-11-27 14:28:00.706792+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417417	2003-11-27 14:44:31+02	2003-11-27 14:28:00.713158+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0xc39852fc/32		10
1417418	2003-11-27 14:44:31+02	2003-11-27 14:28:00.716991+02	jupiter	3727	last		message repeated 4 times		10
1417419	2003-11-27 14:44:31+02	2003-11-27 14:28:00.720751+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417420	2003-11-27 14:44:31+02	2003-11-27 14:28:00.830341+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1417421	2003-11-27 14:44:31+02	2003-11-27 14:28:00.835726+02	jupiter	3727	mgd[8996]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 9011, status 0		1
1417422	2003-11-27 14:44:31+02	2003-11-27 14:28:00.839532+02	jupiter	3727	mgd[8996]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1417423	2003-11-27 14:44:31+02	2003-11-27 14:28:00.84323+02	jupiter	3727	mgd[8996]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1417424	2003-11-27 14:44:31+02	2003-11-27 14:28:00.848885+02	jupiter	3727	inetd[4451]:	/usr/libexec/telnetd[8994]:	exit status 0x100		10
1417425	2003-11-27 15:01:14+02	2003-11-27 14:28:00.85279+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.22+639 addr 192.168.1.22+639: No route to host		10
1417426	2003-11-27 15:01:19+02	2003-11-27 14:28:05.634506+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.59+639 addr 192.168.1.59+639: No route to host		10
1417427	2003-11-27 15:01:22+02	2003-11-27 14:28:08.654712+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.22+639 addr 192.168.1.22+639: No route to host		10
1417428	2003-11-27 14:28:09+02	2003-11-27 14:28:09.567497+02	deimos	0	314298:		Nov 27 12:28:08.488 UTC: BGP: 62.154.13.1 multihop open delayed 10160ms (no route)		10
1417429	2003-11-27 15:01:29+02	2003-11-27 14:28:15.625411+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.59+639 addr 192.168.1.59+639: No route to host		10
1417430	2003-11-27 15:01:30+02	2003-11-27 14:28:16.72645+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.22+639 addr 192.168.1.22+639: No route to host		10
1417431	2003-11-27 14:28:19+02	2003-11-27 14:28:19.727721+02	deimos	0	314299:		Nov 27 12:28:18.648 UTC: BGP: 62.154.13.1 multihop open delayed 12912ms (no route)		10
1417432	2003-11-27 15:01:38+02	2003-11-27 14:28:24.926266+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.59+639 addr 192.168.1.59+639: No route to host		10
1417433	2003-11-27 15:01:38+02	2003-11-27 14:28:25.12632+02	titan	0	rpd[2658]:	task_connect:	task MSDP.192.168.1.22+639 addr 192.168.1.22+639: No route to host		10
1304303	2003-11-19 17:00:18+02	2003-11-19 17:00:22.295733+02	adrastea	3726	mgd[4740]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1304193	2003-11-19 17:00:18+02	2003-11-19 17:00:19.491491+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/4431/file', PID 4783, status 0		1
1304301	2003-11-19 17:00:18+02	2003-11-19 17:00:22.2801+02	adrastea	3726	mgd[4741]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1304199	2003-11-19 17:00:18+02	2003-11-19 17:00:19.643798+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1304302	2003-11-19 17:00:18+02	2003-11-19 17:00:22.288557+02	adrastea	3726	mgd[4740]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1304306	2003-11-19 17:00:18+02	2003-11-19 17:00:22.434688+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304307	2003-11-19 17:00:18+02	2003-11-19 17:00:22.44689+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304305	2003-11-19 17:00:18+02	2003-11-19 17:00:22.415151+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10656, status 0		1
1304312	2003-11-19 17:00:18+02	2003-11-19 17:00:22.470742+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304311	2003-11-19 17:00:18+02	2003-11-19 17:00:22.465853+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304310	2003-11-19 17:00:18+02	2003-11-19 17:00:22.459923+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4794, status 0		1
1304308	2003-11-19 17:00:18+02	2003-11-19 17:00:22.451021+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10657, status 0		1
1304309	2003-11-19 17:00:18+02	2003-11-19 17:00:22.455861+02	r201	3732	mgd[10644]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1304192	2003-11-19 17:00:18+02	2003-11-19 17:00:19.485652+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1304317	2003-11-19 17:00:18+02	2003-11-19 17:00:22.66004+02	atlas	3730	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1304164	2003-11-19 17:00:18+02	2003-11-19 17:00:18.862272+02	adrastea	3726	mgd[4740]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4740]		1
1304322	2003-11-19 17:00:18+02	2003-11-19 17:00:22.692404+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304162	2003-11-19 17:00:18+02	2003-11-19 17:00:18.845237+02	ganymede	3731	mgd[10797]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1304163	2003-11-19 17:00:18+02	2003-11-19 17:00:18.857306+02	adrastea	3726	mgd[4740]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1304315	2003-11-19 17:00:18+02	2003-11-19 17:00:22.59399+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4795, status 0		1
1304314	2003-11-19 17:00:18+02	2003-11-19 17:00:22.480962+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10809, status 0		1
1304316	2003-11-19 17:00:18+02	2003-11-19 17:00:22.651497+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304183	2003-11-19 17:00:18+02	2003-11-19 17:00:19.215298+02	atlas	3730	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1304167	2003-11-19 17:00:18+02	2003-11-19 17:00:18.983535+02	adrastea	3726	mgd[4741]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1304324	2003-11-19 17:00:18+02	2003-11-19 17:00:22.702306+02	ganymede	3731	mgd[10797]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1304318	2003-11-19 17:00:18+02	2003-11-19 17:00:22.667051+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304323	2003-11-19 17:00:18+02	2003-11-19 17:00:22.69805+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10810, status 0		1
1304321	2003-11-19 17:00:18+02	2003-11-19 17:00:22.68836+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4766, status 0		1
1304180	2003-11-19 17:00:18+02	2003-11-19 17:00:19.201296+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/proc/4523/file', PID 10799, status 0		1
1304177	2003-11-19 17:00:18+02	2003-11-19 17:00:19.183646+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/proc/4522/file'		1
1304196	2003-11-19 17:00:18+02	2003-11-19 17:00:19.62949+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 4742, status 0		1
1304198	2003-11-19 17:00:18+02	2003-11-19 17:00:19.639515+02	r201	3732	mgd[10644]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1304179	2003-11-19 17:00:18+02	2003-11-19 17:00:19.197204+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/proc/4523/file'		1
1304166	2003-11-19 17:00:18+02	2003-11-19 17:00:18.979585+02	atlas	3730	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1304325	2003-11-19 17:00:18+02	2003-11-19 17:00:22.81455+02	ganymede	3731	mgd[10797]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304195	2003-11-19 17:00:18+02	2003-11-19 17:00:19.614565+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/proc/2264/file', PID 10646, status 0		1
1304194	2003-11-19 17:00:18+02	2003-11-19 17:00:19.501439+02	atlas	3730	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/4442/file'		1
1304178	2003-11-19 17:00:18+02	2003-11-19 17:00:19.190665+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/proc/4522/file', PID 10798, status 0		1
1304197	2003-11-19 17:00:18+02	2003-11-19 17:00:19.633799+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1304165	2003-11-19 17:00:18+02	2003-11-19 17:00:18.973835+02	r201	3732	mgd[10644]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1304363	2003-11-19 17:00:19+02	2003-11-19 17:00:23.693301+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1304365	2003-11-19 17:00:19+02	2003-11-19 17:00:23.874157+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1304364	2003-11-19 17:00:19+02	2003-11-19 17:00:23.704062+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/0) ifd vptree not initialized		10
1304347	2003-11-19 17:00:19+02	2003-11-19 17:00:23.366033+02	atlas	3730	last		message repeated 2 times		10
1304330	2003-11-19 17:00:19+02	2003-11-19 17:00:22.936955+02	adrastea	3726	mgd[4740]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1344806	2003-11-20 19:13:14+02	2003-11-20 18:55:48.0117+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344809	2003-11-20 19:13:15+02	2003-11-20 18:55:49.000825+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344808	2003-11-20 19:13:15+02	2003-11-20 18:55:48.981252+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344812	2003-11-20 19:13:16+02	2003-11-20 18:55:50.000283+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344810	2003-11-20 19:13:16+02	2003-11-20 18:55:49.981503+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344811	2003-11-20 19:13:16+02	2003-11-20 18:55:49.996465+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344815	2003-11-20 19:13:17+02	2003-11-20 18:55:51.104873+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344814	2003-11-20 19:13:17+02	2003-11-20 18:55:51.099728+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344813	2003-11-20 19:13:17+02	2003-11-20 18:55:50.982189+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304368	2003-11-19 17:00:19+02	2003-11-19 17:00:23.895034+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1304369	2003-11-19 17:00:19+02	2003-11-19 17:00:23.899742+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/1) ifd vptree not initialized		10
1304372	2003-11-19 17:00:19+02	2003-11-19 17:00:23.914572+02	ganymede	3731	mgd[10797]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10811, status 0		1
1304371	2003-11-19 17:00:19+02	2003-11-19 17:00:23.910721+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1304366	2003-11-19 17:00:19+02	2003-11-19 17:00:23.88661+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1304370	2003-11-19 17:00:19+02	2003-11-19 17:00:23.905612+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1304357	2003-11-19 17:00:19+02	2003-11-19 17:00:23.611813+02	ganymede	3731	last		message repeated 5 times		10
1304367	2003-11-19 17:00:19+02	2003-11-19 17:00:23.891209+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1304362	2003-11-19 17:00:19+02	2003-11-19 17:00:23.673876+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1304328	2003-11-19 17:00:19+02	2003-11-19 17:00:22.926745+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4767, status 0		1
1304327	2003-11-19 17:00:19+02	2003-11-19 17:00:22.918016+02	adrastea	3726	mgd[4741]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1304361	2003-11-19 17:00:19+02	2003-11-19 17:00:23.651525+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1be99fc/32		10
1304332	2003-11-19 17:00:19+02	2003-11-19 17:00:23.006909+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304341	2003-11-19 17:00:19+02	2003-11-19 17:00:23.230041+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304331	2003-11-19 17:00:19+02	2003-11-19 17:00:22.945815+02	r201	3732	mgd[10644]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10658, status 0		1
1304329	2003-11-19 17:00:19+02	2003-11-19 17:00:22.93138+02	adrastea	3726	mgd[4740]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1304336	2003-11-19 17:00:19+02	2003-11-19 17:00:23.202205+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304340	2003-11-19 17:00:19+02	2003-11-19 17:00:23.223962+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4769, status 0		1
1304333	2003-11-19 17:00:19+02	2003-11-19 17:00:23.017666+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b235fc/32		10
1304335	2003-11-19 17:00:19+02	2003-11-19 17:00:23.194892+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304334	2003-11-19 17:00:19+02	2003-11-19 17:00:23.07195+02	adrastea	3726	last		message repeated 4 times		10
1304339	2003-11-19 17:00:19+02	2003-11-19 17:00:23.220024+02	r201	3732	inetd[2236]:	/usr/libexec/telnetd[10642]:	exit status 0x100		10
1304338	2003-11-19 17:00:19+02	2003-11-19 17:00:23.215064+02	r201	3732	mgd[10644]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1304337	2003-11-19 17:00:19+02	2003-11-19 17:00:23.210249+02	r201	3732	mgd[10644]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1304344	2003-11-19 17:00:19+02	2003-11-19 17:00:23.245969+02	adrastea	3726	mgd[4741]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304360	2003-11-19 17:00:19+02	2003-11-19 17:00:23.640762+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304342	2003-11-19 17:00:19+02	2003-11-19 17:00:23.2343+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4770, status 0		1
1304350	2003-11-19 17:00:19+02	2003-11-19 17:00:23.385545+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bc47fc/32		10
1304343	2003-11-19 17:00:19+02	2003-11-19 17:00:23.239647+02	adrastea	3726	mgd[4741]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1304349	2003-11-19 17:00:19+02	2003-11-19 17:00:23.380426+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304345	2003-11-19 17:00:19+02	2003-11-19 17:00:23.354942+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304348	2003-11-19 17:00:19+02	2003-11-19 17:00:23.376536+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304346	2003-11-19 17:00:19+02	2003-11-19 17:00:23.361973+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bc47fc/32		10
1304353	2003-11-19 17:00:19+02	2003-11-19 17:00:23.45393+02	atlas	3730	mgd[4782]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1304351	2003-11-19 17:00:19+02	2003-11-19 17:00:23.389503+02	atlas	3730	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4796, status 0		1
1304359	2003-11-19 17:00:19+02	2003-11-19 17:00:23.633722+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1be99fc/32		10
1304352	2003-11-19 17:00:19+02	2003-11-19 17:00:23.444739+02	atlas	3730	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1304355	2003-11-19 17:00:19+02	2003-11-19 17:00:23.574797+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304354	2003-11-19 17:00:19+02	2003-11-19 17:00:23.461101+02	atlas	3730	inetd[4414]:	/usr/libexec/telnetd[4780]:	exit status 0x100		10
1304358	2003-11-19 17:00:19+02	2003-11-19 17:00:23.628603+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304356	2003-11-19 17:00:19+02	2003-11-19 17:00:23.606389+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b742fc/32		10
1304413	2003-11-19 17:00:20+02	2003-11-19 17:00:24.917082+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1304381	2003-11-19 17:00:20+02	2003-11-19 17:00:24.173517+02	ganymede	3731	mgd[10797]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1304382	2003-11-19 17:00:20+02	2003-11-19 17:00:24.178197+02	ganymede	3731	mgd[10797]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1304383	2003-11-19 17:00:20+02	2003-11-19 17:00:24.182331+02	ganymede	3731	inetd[4403]:	/usr/libexec/telnetd[10795]:	exit status 0x100		10
1304394	2003-11-19 17:00:20+02	2003-11-19 17:00:24.523792+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1329821	2003-11-19 20:42:45+02	2003-11-19 20:25:11.379769+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329822	2003-11-19 20:42:46+02	2003-11-19 20:25:12.382199+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329823	2003-11-19 20:42:46+02	2003-11-19 20:25:12.400781+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329824	2003-11-19 20:42:47+02	2003-11-19 20:25:13.381324+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329826	2003-11-19 20:42:47+02	2003-11-19 20:25:13.400198+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329825	2003-11-19 20:42:47+02	2003-11-19 20:25:13.396387+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329830	2003-11-19 20:42:48+02	2003-11-19 20:25:14.499345+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329828	2003-11-19 20:42:48+02	2003-11-19 20:25:14.38148+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304389	2003-11-19 17:00:20+02	2003-11-19 17:00:24.383177+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304397	2003-11-19 17:00:20+02	2003-11-19 17:00:24.562464+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1304390	2003-11-19 17:00:20+02	2003-11-19 17:00:24.38861+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bd56fc/32		10
1304393	2003-11-19 17:00:20+02	2003-11-19 17:00:24.518454+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1304392	2003-11-19 17:00:20+02	2003-11-19 17:00:24.398606+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304391	2003-11-19 17:00:20+02	2003-11-19 17:00:24.392791+02	adrastea	3726	last		message repeated 4 times		10
1304395	2003-11-19 17:00:20+02	2003-11-19 17:00:24.528425+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1304398	2003-11-19 17:00:20+02	2003-11-19 17:00:24.570164+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1304410	2003-11-19 17:00:20+02	2003-11-19 17:00:24.791157+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1304402	2003-11-19 17:00:20+02	2003-11-19 17:00:24.594685+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1304399	2003-11-19 17:00:20+02	2003-11-19 17:00:24.582021+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1304403	2003-11-19 17:00:20+02	2003-11-19 17:00:24.707853+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1304401	2003-11-19 17:00:20+02	2003-11-19 17:00:24.590764+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1304400	2003-11-19 17:00:20+02	2003-11-19 17:00:24.58676+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1304404	2003-11-19 17:00:20+02	2003-11-19 17:00:24.713028+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1304409	2003-11-19 17:00:20+02	2003-11-19 17:00:24.785411+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1304405	2003-11-19 17:00:20+02	2003-11-19 17:00:24.720155+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1304408	2003-11-19 17:00:20+02	2003-11-19 17:00:24.779868+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1304396	2003-11-19 17:00:20+02	2003-11-19 17:00:24.532866+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1304407	2003-11-19 17:00:20+02	2003-11-19 17:00:24.731099+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1304406	2003-11-19 17:00:20+02	2003-11-19 17:00:24.72653+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1304414	2003-11-19 17:00:20+02	2003-11-19 17:00:24.929763+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1304425	2003-11-19 17:00:20+02	2003-11-19 17:00:25.145475+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1304416	2003-11-19 17:00:20+02	2003-11-19 17:00:24.941373+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1304415	2003-11-19 17:00:20+02	2003-11-19 17:00:24.93689+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1304417	2003-11-19 17:00:20+02	2003-11-19 17:00:24.945907+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1304418	2003-11-19 17:00:20+02	2003-11-19 17:00:24.95274+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1304424	2003-11-19 17:00:20+02	2003-11-19 17:00:25.139512+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1304419	2003-11-19 17:00:20+02	2003-11-19 17:00:24.961169+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1304423	2003-11-19 17:00:20+02	2003-11-19 17:00:25.134272+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1304420	2003-11-19 17:00:20+02	2003-11-19 17:00:25.012273+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1304421	2003-11-19 17:00:20+02	2003-11-19 17:00:25.020427+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1304422	2003-11-19 17:00:20+02	2003-11-19 17:00:25.025444+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1304431	2003-11-19 17:00:20+02	2003-11-19 17:00:25.253027+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1304426	2003-11-19 17:00:20+02	2003-11-19 17:00:25.151192+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1304427	2003-11-19 17:00:20+02	2003-11-19 17:00:25.226544+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1304430	2003-11-19 17:00:20+02	2003-11-19 17:00:25.246158+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1304820	2003-11-19 17:01:29+02	2003-11-19 17:01:30.056754+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304428	2003-11-19 17:00:20+02	2003-11-19 17:00:25.232269+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1304429	2003-11-19 17:00:20+02	2003-11-19 17:00:25.240351+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1304412	2003-11-19 17:00:20+02	2003-11-19 17:00:24.801569+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1304435	2003-11-19 17:00:20+02	2003-11-19 17:00:25.449035+02	adrastea	3726	mgd[4740]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4768, status 0		1
1304434	2003-11-19 17:00:20+02	2003-11-19 17:00:25.390814+02	adrastea	3726	mgd[4741]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4771, status 0		1
1304433	2003-11-19 17:00:20+02	2003-11-19 17:00:25.364247+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1304432	2003-11-19 17:00:20+02	2003-11-19 17:00:25.257384+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1304447	2003-11-19 17:00:21+02	2003-11-19 17:00:25.647853+02	adrastea	3726	mgd[4741]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1304446	2003-11-19 17:00:21+02	2003-11-19 17:00:25.642532+02	adrastea	3726	mgd[4741]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1304443	2003-11-19 17:00:21+02	2003-11-19 17:00:25.603833+02	adrastea	3726	mgd[4740]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1304442	2003-11-19 17:00:21+02	2003-11-19 17:00:25.4902+02	adrastea	3726	mgd[4740]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1304448	2003-11-19 17:00:21+02	2003-11-19 17:00:25.657169+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[4738]:	exit status 0x100		10
1304444	2003-11-19 17:00:21+02	2003-11-19 17:00:25.632778+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[4736]:	exit status 0x100		10
1329829	2003-11-19 20:42:48+02	2003-11-19 20:25:14.39213+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329831	2003-11-19 20:42:49+02	2003-11-19 20:25:15.382789+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329833	2003-11-19 20:42:49+02	2003-11-19 20:25:15.40593+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329832	2003-11-19 20:42:49+02	2003-11-19 20:25:15.402109+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329840	2003-11-19 20:42:50+02	2003-11-19 20:25:16.489334+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329839	2003-11-19 20:42:50+02	2003-11-19 20:25:16.381698+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1329853	2003-11-19 20:42:51+02	2003-11-19 20:25:24.459962+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344817	2003-11-20 19:13:18+02	2003-11-20 18:55:52.003317+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344818	2003-11-20 19:13:18+02	2003-11-20 18:55:52.061645+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344816	2003-11-20 19:13:18+02	2003-11-20 18:55:51.983552+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344820	2003-11-20 19:13:19+02	2003-11-20 18:55:52.997997+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344819	2003-11-20 19:13:19+02	2003-11-20 18:55:52.983445+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344823	2003-11-20 19:13:20+02	2003-11-20 18:55:59.288755+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304648	2003-11-19 17:00:51+02	2003-11-19 17:00:51.340827+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1304684	2003-11-19 17:01:00+02	2003-11-19 17:01:00.665916+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show isis adjacency '		1
1304693	2003-11-19 17:01:02+02	2003-11-19 17:01:02.412305+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1304694	2003-11-19 17:01:02+02	2003-11-19 17:01:02.418283+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1304695	2003-11-19 17:01:02+02	2003-11-19 17:01:02.422082+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1304716	2003-11-19 17:01:07+02	2003-11-19 17:01:08.055872+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10660, status 0		1
1304715	2003-11-19 17:01:07+02	2003-11-19 17:01:08.042163+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304714	2003-11-19 17:01:07+02	2003-11-19 17:01:08.036431+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show interfaces ge-1/3/0 extensive '		1
1304711	2003-11-19 17:01:07+02	2003-11-19 17:01:07.119316+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304712	2003-11-19 17:01:07+02	2003-11-19 17:01:07.13909+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10659, status 0		1
1355378	2003-11-21 18:36:47+02	2003-11-21 18:36:47.694302+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1355376	2003-11-21 18:36:47+02	2003-11-21 18:36:47.681446+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1304738	2003-11-19 17:01:12+02	2003-11-19 17:01:13.107928+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304739	2003-11-19 17:01:13+02	2003-11-19 17:01:13.128124+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10661, status 0		1
1304755	2003-11-19 17:01:15+02	2003-11-19 17:01:15.280056+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run clear interfaces statistics all '		1
1304756	2003-11-19 17:01:15+02	2003-11-19 17:01:15.283861+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304753	2003-11-19 17:01:15+02	2003-11-19 17:01:15.261135+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304754	2003-11-19 17:01:15+02	2003-11-19 17:01:15.276214+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10662, status 0		1
1304757	2003-11-19 17:01:15+02	2003-11-19 17:01:15.300243+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10663, status 0		1
1304767	2003-11-19 17:01:16+02	2003-11-19 17:01:16.889004+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304768	2003-11-19 17:01:16+02	2003-11-19 17:01:16.895716+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10664, status 0		1
1304766	2003-11-19 17:01:16+02	2003-11-19 17:01:16.870754+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show interfaces ge-1/3/0 extensive '		1
1304799	2003-11-19 17:01:24+02	2003-11-19 17:01:24.47594+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10665, status 0		1
1304798	2003-11-19 17:01:24+02	2003-11-19 17:01:24.429146+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304797	2003-11-19 17:01:24+02	2003-11-19 17:01:24.42318+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show interfaces ge-1/3/0 extensive '		1
1304809	2003-11-19 17:01:27+02	2003-11-19 17:01:27.652259+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show interfaces ge-1/3/0 extensive '		1
1304811	2003-11-19 17:01:27+02	2003-11-19 17:01:27.671753+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10666, status 0		1
1304810	2003-11-19 17:01:27+02	2003-11-19 17:01:27.666779+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304821	2003-11-19 17:01:29+02	2003-11-19 17:01:30.060557+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10667, status 0		1
1304819	2003-11-19 17:01:29+02	2003-11-19 17:01:30.035793+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show interfaces ge-1/3/0 extensive '		1
1304830	2003-11-19 17:01:31+02	2003-11-19 17:01:31.706965+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304831	2003-11-19 17:01:31+02	2003-11-19 17:01:31.710749+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10668, status 0		1
1304829	2003-11-19 17:01:31+02	2003-11-19 17:01:31.686881+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show interfaces ge-1/3/0 extensive '		1
1304848	2003-11-19 17:01:35+02	2003-11-19 17:01:35.392854+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run monitor interface traffic '		1
1332386	2003-11-19 20:47:28+02	2003-11-19 20:51:25.706088+02	atlas	3730	snmpd[2244]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1330421	2003-11-19 20:47:45+02	2003-11-19 20:30:11.568594+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330422	2003-11-19 20:47:46+02	2003-11-19 20:30:12.569393+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330423	2003-11-19 20:47:46+02	2003-11-19 20:30:12.585532+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330427	2003-11-19 20:47:47+02	2003-11-19 20:30:13.585559+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330425	2003-11-19 20:47:47+02	2003-11-19 20:30:13.569877+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330426	2003-11-19 20:47:47+02	2003-11-19 20:30:13.581624+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330430	2003-11-19 20:47:48+02	2003-11-19 20:30:14.591406+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330429	2003-11-19 20:47:48+02	2003-11-19 20:30:14.569901+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330431	2003-11-19 20:47:48+02	2003-11-19 20:30:14.595299+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330433	2003-11-19 20:47:49+02	2003-11-19 20:30:15.587192+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330432	2003-11-19 20:47:49+02	2003-11-19 20:30:15.570744+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330434	2003-11-19 20:47:49+02	2003-11-19 20:30:15.590952+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330440	2003-11-19 20:47:50+02	2003-11-19 20:30:16.576357+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330439	2003-11-19 20:47:50+02	2003-11-19 20:30:16.570324+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1330452	2003-11-19 20:47:51+02	2003-11-19 20:30:24.589936+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300838	2003-11-19 17:02:39+02	2003-11-19 16:45:04.305554+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300846	2003-11-19 17:02:40+02	2003-11-19 16:45:05.430078+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356451	2003-11-21 19:13:46+02	2003-11-21 18:56:28.034267+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356449	2003-11-21 19:13:46+02	2003-11-21 18:56:28.018824+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356450	2003-11-21 19:13:46+02	2003-11-21 18:56:28.027837+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356454	2003-11-21 19:13:47+02	2003-11-21 18:56:29.042824+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356452	2003-11-21 19:13:47+02	2003-11-21 18:56:29.018771+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356453	2003-11-21 19:13:47+02	2003-11-21 18:56:29.037934+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356455	2003-11-21 19:13:48+02	2003-11-21 18:56:30.019693+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356456	2003-11-21 19:13:48+02	2003-11-21 18:56:30.033775+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356457	2003-11-21 19:13:48+02	2003-11-21 18:56:30.142851+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356458	2003-11-21 19:13:49+02	2003-11-21 18:56:31.019474+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356459	2003-11-21 19:13:49+02	2003-11-21 18:56:31.029535+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356462	2003-11-21 19:13:50+02	2003-11-21 18:56:36.42163+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300845	2003-11-19 17:02:40+02	2003-11-19 16:45:05.306398+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300852	2003-11-19 17:02:41+02	2003-11-19 16:45:06.320035+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300851	2003-11-19 17:02:41+02	2003-11-19 16:45:06.31616+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300850	2003-11-19 17:02:41+02	2003-11-19 16:45:06.307318+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300855	2003-11-19 17:02:42+02	2003-11-19 16:45:07.468741+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300856	2003-11-19 17:02:42+02	2003-11-19 16:45:07.580294+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300854	2003-11-19 17:02:42+02	2003-11-19 16:45:07.306881+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300861	2003-11-19 17:02:43+02	2003-11-19 16:45:08.321938+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300860	2003-11-19 17:02:43+02	2003-11-19 16:45:08.307697+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300862	2003-11-19 17:02:43+02	2003-11-19 16:45:08.32579+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300865	2003-11-19 17:02:44+02	2003-11-19 16:45:09.31356+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300864	2003-11-19 17:02:44+02	2003-11-19 16:45:09.307486+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1300896	2003-11-19 17:02:45+02	2003-11-19 16:45:18.830289+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305173	2003-11-19 17:02:52+02	2003-11-19 17:02:53.07618+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 10677, status 0		1
1305159	2003-11-19 17:02:52+02	2003-11-19 17:02:52.828039+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/proc/2254/file', PID 10670, status 0		1
1305160	2003-11-19 17:02:52+02	2003-11-19 17:02:52.833792+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/proc/2264/file'		1
1305157	2003-11-19 17:02:52+02	2003-11-19 17:02:52.654993+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show version '		1
1305158	2003-11-19 17:02:52+02	2003-11-19 17:02:52.721435+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/proc/2254/file'		1
1305162	2003-11-19 17:02:52+02	2003-11-19 17:02:52.841324+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1305161	2003-11-19 17:02:52+02	2003-11-19 17:02:52.837616+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/proc/2264/file', PID 10671, status 0		1
1305171	2003-11-19 17:02:52+02	2003-11-19 17:02:53.067761+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 10676, status 0		1
1305166	2003-11-19 17:02:52+02	2003-11-19 17:02:52.938972+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1305165	2003-11-19 17:02:52+02	2003-11-19 17:02:52.93472+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 10673, status 0		1
1305164	2003-11-19 17:02:52+02	2003-11-19 17:02:52.930984+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1305163	2003-11-19 17:02:52+02	2003-11-19 17:02:52.927172+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 10672, status 0		1
1305167	2003-11-19 17:02:52+02	2003-11-19 17:02:52.942675+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 10674, status 0		1
1305170	2003-11-19 17:02:52+02	2003-11-19 17:02:53.061653+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1305168	2003-11-19 17:02:52+02	2003-11-19 17:02:52.948348+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/proc/2255/file'		1
1305169	2003-11-19 17:02:52+02	2003-11-19 17:02:53.056118+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/proc/2255/file', PID 10675, status 0		1
1305176	2003-11-19 17:02:52+02	2003-11-19 17:02:53.087611+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1305175	2003-11-19 17:02:52+02	2003-11-19 17:02:53.083862+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 10678, status 0		1
1305174	2003-11-19 17:02:52+02	2003-11-19 17:02:53.080051+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1305177	2003-11-19 17:02:52+02	2003-11-19 17:02:53.091328+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 10679, status 0		1
1305172	2003-11-19 17:02:52+02	2003-11-19 17:02:53.071693+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1305179	2003-11-19 17:02:52+02	2003-11-19 17:02:53.206163+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/proc/2259/file', PID 10680, status 0		1
1305178	2003-11-19 17:02:52+02	2003-11-19 17:02:53.095567+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/proc/2259/file'		1
1305187	2003-11-19 17:02:55+02	2003-11-19 17:02:55.910062+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'top '		1
1305198	2003-11-19 17:02:56+02	2003-11-19 17:02:56.854669+02	r201	3732	mgd[10531]:	UI_DBASE_LOGOUT_EVENT:	User 'lab' exiting configuration mode		1
1305197	2003-11-19 17:02:56+02	2003-11-19 17:02:56.839144+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'exit '		1
1344981	2003-11-20 19:18:14+02	2003-11-20 19:00:48.059287+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344982	2003-11-20 19:18:15+02	2003-11-20 19:00:49.060249+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344983	2003-11-20 19:18:15+02	2003-11-20 19:00:49.073848+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344984	2003-11-20 19:18:16+02	2003-11-20 19:00:50.060011+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344985	2003-11-20 19:18:16+02	2003-11-20 19:00:50.095919+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344986	2003-11-20 19:18:16+02	2003-11-20 19:00:50.0997+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344987	2003-11-20 19:18:17+02	2003-11-20 19:00:51.055812+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344988	2003-11-20 19:18:17+02	2003-11-20 19:00:51.17431+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344989	2003-11-20 19:18:17+02	2003-11-20 19:00:51.179632+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344990	2003-11-20 19:18:18+02	2003-11-20 19:00:52.055833+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344991	2003-11-20 19:18:18+02	2003-11-20 19:00:52.075407+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344992	2003-11-20 19:18:18+02	2003-11-20 19:00:52.079226+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344993	2003-11-20 19:18:19+02	2003-11-20 19:00:53.056573+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344994	2003-11-20 19:18:19+02	2003-11-20 19:00:53.071349+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1344998	2003-11-20 19:18:20+02	2003-11-20 19:00:59.419417+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345003	2003-11-20 19:18:39+02	2003-11-20 19:01:13.341723+02	jupiter	3727	chassisd[4445]:	CHASSISD_SNMP_TRAP6:	SNMP trap: Power Supply failed: jnxContentsContainerIndex 2, jnxContentsL1Index 2, jnxContentsL2Index 0, jnxContentsL3Index 0, jnxContentsDescr PEM 1, jnxOperatingState/Temp 6 		100
1305221	2003-11-19 17:03:03+02	2003-11-19 17:03:03.772486+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'request system software /var/tmp/'		1
1305239	2003-11-19 17:03:07+02	2003-11-19 17:03:07.256315+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'ftp 172.26.26.20 '		1
1331203	2003-11-19 20:52:45+02	2003-11-19 20:35:11.671641+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351504	2003-11-21 17:13:42+02	2003-11-21 16:56:22.701597+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351506	2003-11-21 17:13:43+02	2003-11-21 16:56:23.693237+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351507	2003-11-21 17:13:43+02	2003-11-21 16:56:23.71495+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351510	2003-11-21 17:13:44+02	2003-11-21 16:56:24.712789+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351509	2003-11-21 17:13:44+02	2003-11-21 16:56:24.708933+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351508	2003-11-21 17:13:44+02	2003-11-21 16:56:24.6936+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351513	2003-11-21 17:13:45+02	2003-11-21 16:56:25.818583+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351512	2003-11-21 17:13:45+02	2003-11-21 16:56:25.813232+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351511	2003-11-21 17:13:45+02	2003-11-21 16:56:25.695661+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351516	2003-11-21 17:13:46+02	2003-11-21 16:56:26.71837+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305342	2003-11-19 17:03:34+02	2003-11-19 17:03:34.560791+02	r201	3732	mgd[10531]:	UI_CHILD_START:	Starting child '/usr/libexec/ui/package'		1
1305341	2003-11-19 17:03:34+02	2003-11-19 17:03:34.556921+02	r201	3732	mgd[10531]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'request system software add jbundle-6.1R1.4-domestic-signed.tgz delay-restart reboot '		1
1305343	2003-11-19 17:03:34+02	2003-11-19 17:03:34.564603+02	r201	3732	mgd[10531]:		/usr/libexec/ui/package update -reboot -delay /var/home/lab/jbundle-6.1R1.4-domestic-signed.tgz		1
1331204	2003-11-19 20:52:46+02	2003-11-19 20:35:12.673123+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331205	2003-11-19 20:52:46+02	2003-11-19 20:35:12.685901+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331207	2003-11-19 20:52:47+02	2003-11-19 20:35:13.681622+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331206	2003-11-19 20:52:47+02	2003-11-19 20:35:13.67297+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331208	2003-11-19 20:52:47+02	2003-11-19 20:35:13.788366+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331211	2003-11-19 20:52:48+02	2003-11-19 20:35:14.69544+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331210	2003-11-19 20:52:48+02	2003-11-19 20:35:14.691622+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331209	2003-11-19 20:52:48+02	2003-11-19 20:35:14.673726+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331212	2003-11-19 20:52:49+02	2003-11-19 20:35:15.673782+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331214	2003-11-19 20:52:49+02	2003-11-19 20:35:15.691413+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331213	2003-11-19 20:52:49+02	2003-11-19 20:35:15.687536+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331219	2003-11-19 20:52:50+02	2003-11-19 20:35:16.674211+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331220	2003-11-19 20:52:50+02	2003-11-19 20:35:16.678515+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331235	2003-11-19 20:52:51+02	2003-11-19 20:35:24.720513+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354833	2003-11-21 18:38:44+02	2003-11-21 18:21:25.474378+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354835	2003-11-21 18:38:45+02	2003-11-21 18:21:26.512348+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354834	2003-11-21 18:38:45+02	2003-11-21 18:21:26.475451+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354837	2003-11-21 18:38:46+02	2003-11-21 18:21:27.4756+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354838	2003-11-21 18:38:46+02	2003-11-21 18:21:27.492501+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354839	2003-11-21 18:38:46+02	2003-11-21 18:21:27.496296+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354847	2003-11-21 18:38:47+02	2003-11-21 18:21:28.51589+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354846	2003-11-21 18:38:47+02	2003-11-21 18:21:28.510216+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354848	2003-11-21 18:38:47+02	2003-11-21 18:21:28.520268+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354850	2003-11-21 18:38:48+02	2003-11-21 18:21:29.476372+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354852	2003-11-21 18:38:48+02	2003-11-21 18:21:29.502109+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354851	2003-11-21 18:38:48+02	2003-11-21 18:21:29.498189+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354854	2003-11-21 18:38:49+02	2003-11-21 18:21:30.493959+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354853	2003-11-21 18:38:49+02	2003-11-21 18:21:30.476419+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1354866	2003-11-21 18:38:50+02	2003-11-21 18:21:35.510227+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332522	2003-11-19 20:54:00+02	2003-11-19 20:54:00.619989+02	atlas	3730	xntpd[2436]:		offset 0.001578 sec freq 77.025 ppm error 0.000097 poll 6		500
1332532	2003-11-19 20:54:14+02	2003-11-19 20:54:14.360846+02	ganymede	3731	xntpd[2535]:		offset 0.000614 sec freq 84.556 ppm error 0.000060 poll 6		500
1305656	2003-11-19 17:04:39+02	2003-11-19 17:04:40.57644+02	r201	3732	init:		process_mode mode=BOTH cmd=inet-process master_mode=1		10
1305653	2003-11-19 17:04:39+02	2003-11-19 17:04:40.563809+02	r201	3732	init:		process_mode mode=BOTH cmd=snmp master_mode=1		10
1305634	2003-11-19 17:04:39+02	2003-11-19 17:04:40.185062+02	r201	3732	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1305661	2003-11-19 17:04:39+02	2003-11-19 17:04:40.763593+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1305652	2003-11-19 17:04:39+02	2003-11-19 17:04:40.560018+02	r201	3732	init:		process_mode mode=BOTH cmd=management master_mode=1		10
1305664	2003-11-19 17:04:39+02	2003-11-19 17:04:40.874867+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1305666	2003-11-19 17:04:39+02	2003-11-19 17:04:40.894103+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1305678	2003-11-19 17:04:39+02	2003-11-19 17:04:41.157767+02	r201	3732	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1305613	2003-11-19 17:04:39+02	2003-11-19 17:04:39.880108+02	r201	3732	init:		process_mode mode=BOTH cmd=craft-control master_mode=1		10
1305669	2003-11-19 17:04:39+02	2003-11-19 17:04:41.016681+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1305627	2003-11-19 17:04:39+02	2003-11-19 17:04:40.05134+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1305677	2003-11-19 17:04:39+02	2003-11-19 17:04:41.048964+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1305608	2003-11-19 17:04:39+02	2003-11-19 17:04:39.81776+02	r201	3732	init:		process_mode mode=BOTH cmd=tnp-process master_mode=1		10
1305628	2003-11-19 17:04:39+02	2003-11-19 17:04:40.159612+02	r201	3732	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1305648	2003-11-19 17:04:39+02	2003-11-19 17:04:40.49774+02	r201	3732	init:		process_mode mode=BOTH cmd=chassis-control master_mode=1		10
1305638	2003-11-19 17:04:39+02	2003-11-19 17:04:40.309027+02	r201	3732	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1305620	2003-11-19 17:04:39+02	2003-11-19 17:04:40.020854+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1305655	2003-11-19 17:04:39+02	2003-11-19 17:04:40.572636+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing 		10
1305623	2003-11-19 17:04:39+02	2003-11-19 17:04:40.032162+02	r201	3732	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1305657	2003-11-19 17:04:39+02	2003-11-19 17:04:40.588291+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1305663	2003-11-19 17:04:39+02	2003-11-19 17:04:40.847728+02	r201	3732	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1305619	2003-11-19 17:04:39+02	2003-11-19 17:04:40.01581+02	r201	3732	init:		process_mode mode=BOTH cmd=inet-process master_mode=1		10
1305615	2003-11-19 17:04:39+02	2003-11-19 17:04:39.887985+02	r201	3732	init:		process_mode mode=BOTH cmd=management master_mode=1		10
1305624	2003-11-19 17:04:39+02	2003-11-19 17:04:40.035867+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1305665	2003-11-19 17:04:39+02	2003-11-19 17:04:40.890338+02	r201	3732	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1305676	2003-11-19 17:04:39+02	2003-11-19 17:04:41.0452+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1305625	2003-11-19 17:04:39+02	2003-11-19 17:04:40.043677+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1305618	2003-11-19 17:04:39+02	2003-11-19 17:04:40.010177+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing 		10
1332619	2003-11-19 20:55:28+02	2003-11-19 20:55:28.86805+02	atlas	3730	snmpd[2244]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1305668	2003-11-19 17:04:39+02	2003-11-19 17:04:41.010925+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1305646	2003-11-19 17:04:39+02	2003-11-19 17:04:40.386146+02	r201	3732	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1305680	2003-11-19 17:04:39+02	2003-11-19 17:04:41.167955+02	r201	3732	init:	Multiuser:	old requested_transition==0x0 sighupped=0 		10
1305667	2003-11-19 17:04:39+02	2003-11-19 17:04:40.897841+02	r201	3732	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1305640	2003-11-19 17:04:39+02	2003-11-19 17:04:40.318494+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1305626	2003-11-19 17:04:39+02	2003-11-19 17:04:40.047548+02	r201	3732	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1305630	2003-11-19 17:04:39+02	2003-11-19 17:04:40.169292+02	r201	3732	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1305679	2003-11-19 17:04:39+02	2003-11-19 17:04:41.163436+02	r201	3732	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1305662	2003-11-19 17:04:39+02	2003-11-19 17:04:40.803213+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1305660	2003-11-19 17:04:39+02	2003-11-19 17:04:40.707971+02	r201	3732	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1305651	2003-11-19 17:04:39+02	2003-11-19 17:04:40.51219+02	r201	3732	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1305674	2003-11-19 17:04:39+02	2003-11-19 17:04:41.037755+02	r201	3732	init:		clean_process:process firewall RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1305636	2003-11-19 17:04:39+02	2003-11-19 17:04:40.192709+02	r201	3732	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1305611	2003-11-19 17:04:39+02	2003-11-19 17:04:39.872377+02	r201	3732	init:		process_mode mode=BOTH cmd=chassis-control master_mode=1		10
1305671	2003-11-19 17:04:39+02	2003-11-19 17:04:41.024213+02	r201	3732	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1305609	2003-11-19 17:04:39+02	2003-11-19 17:04:39.821608+02	r201	3732	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1305672	2003-11-19 17:04:39+02	2003-11-19 17:04:41.03018+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1305670	2003-11-19 17:04:39+02	2003-11-19 17:04:41.020495+02	r201	3732	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1305629	2003-11-19 17:04:39+02	2003-11-19 17:04:40.165468+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1305635	2003-11-19 17:04:39+02	2003-11-19 17:04:40.188888+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1305617	2003-11-19 17:04:39+02	2003-11-19 17:04:39.895386+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1305633	2003-11-19 17:04:39+02	2003-11-19 17:04:40.181258+02	r201	3732	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1305649	2003-11-19 17:04:39+02	2003-11-19 17:04:40.504225+02	r201	3732	init:		process_mode mode=BOTH cmd=alarm-control master_mode=1		10
1305631	2003-11-19 17:04:39+02	2003-11-19 17:04:40.173018+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1305614	2003-11-19 17:04:39+02	2003-11-19 17:04:39.88425+02	r201	3732	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1305610	2003-11-19 17:04:39+02	2003-11-19 17:04:39.825363+02	r201	3732	init:		clean_process:process interface-control RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1305612	2003-11-19 17:04:39+02	2003-11-19 17:04:39.876183+02	r201	3732	init:		process_mode mode=BOTH cmd=alarm-control master_mode=1		10
1305643	2003-11-19 17:04:39+02	2003-11-19 17:04:40.33178+02	r201	3732	init:	Multiuser:	old requested_transition==0x0 sighupped=1 		10
1305637	2003-11-19 17:04:39+02	2003-11-19 17:04:40.196459+02	r201	3732	init:		clean_process:process firewall RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1305644	2003-11-19 17:04:39+02	2003-11-19 17:04:40.335483+02	r201	3732	init:		process_mode mode=BOTH cmd=watchdog master_mode=1		10
1305632	2003-11-19 17:04:39+02	2003-11-19 17:04:40.177314+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1305654	2003-11-19 17:04:39+02	2003-11-19 17:04:40.568798+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1305639	2003-11-19 17:04:39+02	2003-11-19 17:04:40.314748+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1305616	2003-11-19 17:04:39+02	2003-11-19 17:04:39.891677+02	r201	3732	init:		process_mode mode=BOTH cmd=snmp master_mode=1		10
1305641	2003-11-19 17:04:39+02	2003-11-19 17:04:40.322199+02	r201	3732	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1305658	2003-11-19 17:04:39+02	2003-11-19 17:04:40.697823+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1305607	2003-11-19 17:04:39+02	2003-11-19 17:04:39.706577+02	r201	3732	init:		process_mode mode=BOTH cmd=watchdog master_mode=1		10
1305645	2003-11-19 17:04:39+02	2003-11-19 17:04:40.339275+02	r201	3732	init:		process_mode mode=BOTH cmd=tnp-process master_mode=1		10
1305622	2003-11-19 17:04:39+02	2003-11-19 17:04:40.028439+02	r201	3732	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1305621	2003-11-19 17:04:39+02	2003-11-19 17:04:40.024661+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1305675	2003-11-19 17:04:39+02	2003-11-19 17:04:41.041471+02	r201	3732	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1305647	2003-11-19 17:04:39+02	2003-11-19 17:04:40.390964+02	r201	3732	init:		clean_process:process interface-control RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1305642	2003-11-19 17:04:39+02	2003-11-19 17:04:40.328064+02	r201	3732	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1305673	2003-11-19 17:04:39+02	2003-11-19 17:04:41.033987+02	r201	3732	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1305650	2003-11-19 17:04:39+02	2003-11-19 17:04:40.508118+02	r201	3732	init:		process_mode mode=BOTH cmd=craft-control master_mode=1		10
1305659	2003-11-19 17:04:39+02	2003-11-19 17:04:40.701624+02	r201	3732	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1351514	2003-11-21 17:13:46+02	2003-11-21 16:56:26.693961+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351515	2003-11-21 17:13:46+02	2003-11-21 16:56:26.714603+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351518	2003-11-21 17:13:47+02	2003-11-21 16:56:27.695174+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351519	2003-11-21 17:13:47+02	2003-11-21 16:56:27.710192+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351522	2003-11-21 17:13:48+02	2003-11-21 16:56:33.297086+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357179	2003-11-21 19:33:49+02	2003-11-21 19:16:30.347357+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305696	2003-11-19 17:04:43+02	2003-11-19 17:04:43.363319+02	r201	3732	snmpd[2233]:	SNMPD_TRAP_QUEUE_MAX_ATTEMPTS:	trap_dq_send_traps: after 10 attempts, deleting 22 traps queued to 172.1.0.10 		2
1305695	2003-11-19 17:04:43+02	2003-11-19 17:04:43.344836+02	r201	3732	snmpd[2233]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1345757	2003-11-20 19:23:05+02	2003-11-20 19:23:05.742894+02	adrastea	3726	xntpd[2231]:		offset -0.000618 sec freq 76.483 ppm error 0.000864 poll 10		500
1331919	2003-11-19 20:57:45+02	2003-11-19 20:40:11.750588+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331922	2003-11-19 20:57:46+02	2003-11-19 20:40:12.774658+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331921	2003-11-19 20:57:46+02	2003-11-19 20:40:12.751229+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331923	2003-11-19 20:57:47+02	2003-11-19 20:40:13.751894+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306191	2003-11-19 17:06:26+02	2003-11-19 17:06:28.139351+02	r201	3732	eccd[2259]:		SIGTERM received, exiting 		10
1331924	2003-11-19 20:57:47+02	2003-11-19 20:40:13.769665+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331925	2003-11-19 20:57:47+02	2003-11-19 20:40:13.773431+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331928	2003-11-19 20:57:48+02	2003-11-19 20:40:14.880601+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331927	2003-11-19 20:57:48+02	2003-11-19 20:40:14.874745+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331926	2003-11-19 20:57:48+02	2003-11-19 20:40:14.754204+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331929	2003-11-19 20:57:49+02	2003-11-19 20:40:15.75279+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331930	2003-11-19 20:57:49+02	2003-11-19 20:40:15.761434+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331931	2003-11-19 20:57:49+02	2003-11-19 20:40:15.765408+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331937	2003-11-19 20:57:50+02	2003-11-19 20:40:16.862957+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331936	2003-11-19 20:57:50+02	2003-11-19 20:40:16.752489+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1331961	2003-11-19 20:57:51+02	2003-11-19 20:40:24.850796+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305860	2003-11-19 17:05:17+02	2003-11-19 17:05:18.11029+02	r201	3732	init:		ipsec-key-management (PID 2246) exited with status=0 Normal Exit		10
1305861	2003-11-19 17:05:17+02	2003-11-19 17:05:18.246457+02	r201	3732	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1305859	2003-11-19 17:05:17+02	2003-11-19 17:05:18.09427+02	r201	3732	rpdc:		performing a "rpdc -D kmd stop" command for user root		10
1332070	2003-11-19 21:00:00+02	2003-11-19 20:42:27.145341+02	jupiter	3727	CRON[6959]:		(root) CMD (newsyslog) 		10
1345164	2003-11-20 19:23:14+02	2003-11-20 19:05:48.132612+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345166	2003-11-20 19:23:15+02	2003-11-20 19:05:49.133304+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345167	2003-11-20 19:23:15+02	2003-11-20 19:05:49.14739+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345170	2003-11-20 19:23:16+02	2003-11-20 19:05:50.1468+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345169	2003-11-20 19:23:16+02	2003-11-20 19:05:50.142977+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345168	2003-11-20 19:23:16+02	2003-11-20 19:05:50.13395+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345172	2003-11-20 19:23:17+02	2003-11-20 19:05:51.153245+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345171	2003-11-20 19:23:17+02	2003-11-20 19:05:51.133907+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345173	2003-11-20 19:23:17+02	2003-11-20 19:05:51.25882+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345176	2003-11-20 19:23:18+02	2003-11-20 19:05:52.152603+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345174	2003-11-20 19:23:18+02	2003-11-20 19:05:52.134742+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345175	2003-11-20 19:23:18+02	2003-11-20 19:05:52.148824+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345178	2003-11-20 19:23:19+02	2003-11-20 19:05:53.170802+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345179	2003-11-20 19:23:19+02	2003-11-20 19:05:53.178745+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345181	2003-11-20 19:23:20+02	2003-11-20 19:05:59.549711+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332142	2003-11-19 21:02:45+02	2003-11-19 20:45:11.824083+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332144	2003-11-19 21:02:46+02	2003-11-19 20:45:12.847267+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332143	2003-11-19 21:02:46+02	2003-11-19 20:45:12.824888+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332147	2003-11-19 21:02:47+02	2003-11-19 20:45:13.918736+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332148	2003-11-19 21:02:47+02	2003-11-19 20:45:13.922485+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332146	2003-11-19 21:02:47+02	2003-11-19 20:45:13.825135+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332150	2003-11-19 21:02:48+02	2003-11-19 20:45:14.937389+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332149	2003-11-19 21:02:48+02	2003-11-19 20:45:14.825373+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332151	2003-11-19 21:02:48+02	2003-11-19 20:45:14.942957+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332152	2003-11-19 21:02:49+02	2003-11-19 20:45:15.826043+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332153	2003-11-19 21:02:49+02	2003-11-19 20:45:15.847033+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332154	2003-11-19 21:02:49+02	2003-11-19 20:45:15.85117+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332162	2003-11-19 21:02:50+02	2003-11-19 20:45:16.829957+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332163	2003-11-19 21:02:50+02	2003-11-19 20:45:16.83367+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332175	2003-11-19 21:02:51+02	2003-11-19 20:45:24.980582+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306106	2003-11-19 17:06:21+02	2003-11-19 17:06:22.035329+02	r201	3732	mgd[10531]:	UI_CHILD_STATUS:	Cleanup child '/usr/libexec/ui/package', PID 10684, status 0		1
1306130	2003-11-19 17:06:26+02	2003-11-19 17:06:27.034546+02	r201	3732	shutdown:		reboot by root: 		10
1306148	2003-11-19 17:06:26+02	2003-11-19 17:06:27.316991+02	r201	3732	/kernel:		if_msg_ifl_family_delete(69) family 2		10
1306179	2003-11-19 17:06:26+02	2003-11-19 17:06:27.877027+02	r201	3732	/kernel:		if_msg_ifl_family_delete(71) family 2		10
1306162	2003-11-19 17:06:26+02	2003-11-19 17:06:27.650335+02	r201	3732	/kernel:		if_msg_ifl_family_delete(68) family 2		10
1306169	2003-11-19 17:06:26+02	2003-11-19 17:06:27.685773+02	r201	3732	rpd[2235]:		EVENT <UpDown MTU> index 140 <Broadcast Multicast>		10
1306152	2003-11-19 17:06:26+02	2003-11-19 17:06:27.435764+02	r201	3732	/kernel:		if_msg_ifl_family_delete(69) family 7		10
1306182	2003-11-19 17:06:26+02	2003-11-19 17:06:27.996465+02	r201	3732	/kernel:		if_msg_ifl_family_delete(71) family 7		10
1306138	2003-11-19 17:06:26+02	2003-11-19 17:06:27.172396+02	r201	3732	rpd[2235]:	RPD_LDP_NBRDOWN:	LDP neighbor 1.1.0.2 (ge-0/3/0.0) is down		10
1306133	2003-11-19 17:06:26+02	2003-11-19 17:06:27.153306+02	r201	3732	/kernel:		if_msg_ifl_addr_delete(69) local_prefix 0xc94ed874 dest_prefix 0xc94f3c74 dest_plen 30 flags 0x3		10
1306136	2003-11-19 17:06:26+02	2003-11-19 17:06:27.164625+02	r201	3732	rpd[2235]:		EVENT <UpDown> ge-0/3/0.0 index 69 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306166	2003-11-19 17:06:26+02	2003-11-19 17:06:27.674605+02	r201	3732	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 2, af 2, run-len 0		10
1306170	2003-11-19 17:06:26+02	2003-11-19 17:06:27.692277+02	r201	3732	rpd[2235]:		EVENT Delete ge-0/3/0.0 index 69 <Broadcast Multicast>		10
1306132	2003-11-19 17:06:26+02	2003-11-19 17:06:27.14944+02	r201	3732	craftd[2230]:	craftd_user_conn_shutdown:	socket 8, errno = 0 		10
1306175	2003-11-19 17:06:26+02	2003-11-19 17:06:27.819617+02	r201	3732	rpd[2235]:		EVENT <UpDown MTU> index 143 <Broadcast Multicast>		10
1306163	2003-11-19 17:06:26+02	2003-11-19 17:06:27.656084+02	r201	3732	/kernel:		if_msg_ifl_family_delete(68) family 2		10
1306146	2003-11-19 17:06:26+02	2003-11-19 17:06:27.309+02	r201	3732	snmpd[2233]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 1 traps in queue 		2
1306143	2003-11-19 17:06:26+02	2003-11-19 17:06:27.29558+02	r201	3732	rpd[2235]:		EVENT <UpDown> index 135 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306142	2003-11-19 17:06:26+02	2003-11-19 17:06:27.289881+02	r201	3732	rpd[2235]:		EVENT UpDown ge-0/3/0.0 index 69 <Broadcast Multicast>		10
1306140	2003-11-19 17:06:26+02	2003-11-19 17:06:27.180304+02	r201	3732	rpd[2235]:		EVENT UpDown ge-0/3/0.0 index 69 <Broadcast Multicast>		10
1306139	2003-11-19 17:06:26+02	2003-11-19 17:06:27.176193+02	r201	3732	rpd[2235]:	RPD_LDP_SESSIONDOWN:	LDP session 10.100.254.21 is down, reason: all adjacencies down		10
1306145	2003-11-19 17:06:26+02	2003-11-19 17:06:27.304562+02	r201	3732	snmpd[2233]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1306144	2003-11-19 17:06:26+02	2003-11-19 17:06:27.300644+02	r201	3732	rpd[2235]:		EVENT Delete ge-0/3/0.0 index 69 1.1.0.1/30 -> 1.1.0.3 <Broadcast Multicast>		10
1306190	2003-11-19 17:06:26+02	2003-11-19 17:06:28.033228+02	r201	3732	rpd[2235]:		EVENT <Delete> index 139 <Broadcast Multicast>		10
1306147	2003-11-19 17:06:26+02	2003-11-19 17:06:27.312731+02	r201	3732	snmpd[2233]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 2 traps in queue 		2
1306188	2003-11-19 17:06:26+02	2003-11-19 17:06:28.025415+02	r201	3732	fsad[2257]:	FSAD_TERMINATING_SIGNAL:	Received terminating signal Terminated; preparing to clean up		10
1306180	2003-11-19 17:06:26+02	2003-11-19 17:06:27.880968+02	r201	3732	/kernel:		if_msg_ifl_family_delete(71) family 2		10
1306159	2003-11-19 17:06:26+02	2003-11-19 17:06:27.521361+02	r201	3732	/kernel:		if_msg_ifl_addr_delete(68) local_prefix 0xc953b38c dest_prefix 0xc953b3a0 dest_plen 32 flags 0x3		10
1306183	2003-11-19 17:06:26+02	2003-11-19 17:06:28.000199+02	r201	3732	/kernel:		if_msg_ifl_family_delete(71) family 7		10
1306165	2003-11-19 17:06:26+02	2003-11-19 17:06:27.669723+02	r201	3732	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 1, af 2, run-len 0		10
1306172	2003-11-19 17:06:26+02	2003-11-19 17:06:27.805008+02	r201	3732	rpd[2235]:		EVENT <Delete> ge-0/3/0.0 index 69 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306149	2003-11-19 17:06:26+02	2003-11-19 17:06:27.32073+02	r201	3732	/kernel:		if_msg_ifl_family_delete(69) family 2		10
1306164	2003-11-19 17:06:26+02	2003-11-19 17:06:27.661734+02	r201	3732	rpd[2235]:		EVENT <UpDown MTU> index 138 <Broadcast Multicast>		10
1306160	2003-11-19 17:06:26+02	2003-11-19 17:06:27.528563+02	r201	3732	/kernel:		if_msg_ifl_addr_delete(65) local_prefix 0xc953278c dest_prefix 0 dest_plen 0 flags 0x2		10
1306173	2003-11-19 17:06:26+02	2003-11-19 17:06:27.811001+02	r201	3732	rpd[2235]:		EVENT <Delete> index 135 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306174	2003-11-19 17:06:26+02	2003-11-19 17:06:27.814964+02	r201	3732	chassisd[2228]:	CHASSISD_IFDEV_DETACH_FPC:	ifdev_detach(1) 		10
1306155	2003-11-19 17:06:26+02	2003-11-19 17:06:27.451478+02	r201	3732	rpd[2235]:		EVENT <UpDown> sp-0/2/0.16383 index 68 <Broadcast PointToPoint Multicast>		10
1306134	2003-11-19 17:06:26+02	2003-11-19 17:06:27.157142+02	r201	3732	/kernel:		if_msg_ifl_addr_delete(69) local_prefix 0xc950f98c dest_prefix 0xc950f9a0 dest_plen 30 flags 0x3		10
1306153	2003-11-19 17:06:26+02	2003-11-19 17:06:27.440495+02	r201	3732	/kernel:		if_msg_ifl_family_delete(69) family 33		10
1306189	2003-11-19 17:06:26+02	2003-11-19 17:06:28.029448+02	r201	3732	rpd[2235]:		EVENT <Delete> index 138 <Broadcast Multicast>		10
1306151	2003-11-19 17:06:26+02	2003-11-19 17:06:27.429438+02	r201	3732	/kernel:		if_msg_ifl_family_delete(69) family 7		10
1306181	2003-11-19 17:06:26+02	2003-11-19 17:06:27.990761+02	r201	3732	rpd[2235]:		EVENT Delete sp-0/2/0.16383 index 68 <Broadcast PointToPoint Multicast>		10
1306167	2003-11-19 17:06:26+02	2003-11-19 17:06:27.678329+02	r201	3732	/kernel:	sp-0/2/0:	ifl config: op: 3; sub: 16383; flags: 0x8010, curr: 0x8010.		10
1306154	2003-11-19 17:06:26+02	2003-11-19 17:06:27.445553+02	r201	3732	/kernel:		if_msg_ifl_family_delete(69) family 33		10
1306195	2003-11-19 17:06:26+02	2003-11-19 17:06:28.156262+02	r201	3732	xntpd[8818]:		ntpd exiting on signal 15		1
1306196	2003-11-19 17:06:26+02	2003-11-19 17:06:28.162008+02	r201	3732	chassisd[2228]:	CHASSISD_IFDEV_DETACH_ALL_PSEUDO:	ifdev_detach(pseudo devices: all) 		10
1306168	2003-11-19 17:06:26+02	2003-11-19 17:06:27.682074+02	r201	3732	rpd[2235]:		EVENT <UpDown MTU> index 139 <Broadcast Multicast>		10
1306186	2003-11-19 17:06:26+02	2003-11-19 17:06:28.017817+02	r201	3732	rpd[2235]:		EVENT <Delete> sp-0/2/0.16383 index 68 <Broadcast PointToPoint Multicast>		10
1306157	2003-11-19 17:06:26+02	2003-11-19 17:06:27.463539+02	r201	3732	rpd[2235]:		EVENT UpDown sp-0/2/0.16383 index 68 10.0.0.1 -> 10.0.0.18 <Broadcast PointToPoint Multicast Localup>		10
1306156	2003-11-19 17:06:26+02	2003-11-19 17:06:27.455423+02	r201	3732	rpd[2235]:		EVENT UpDown sp-0/2/0.16383 index 68 <Broadcast PointToPoint Multicast>		10
1306192	2003-11-19 17:06:26+02	2003-11-19 17:06:28.144912+02	r201	3732	rpd[2235]:	RPD_SNMP_SARECV:	snmp_epi_recv: error from sam_recv: 0		500
1306194	2003-11-19 17:06:26+02	2003-11-19 17:06:28.152539+02	r201	3732	rpd[2235]:	RPD_SIGNAL_TERMINATE:	first termination signal received		10
1306177	2003-11-19 17:06:26+02	2003-11-19 17:06:27.827163+02	r201	3732	/kernel:		if_msg_ifl_addr_delete(71) local_prefix 0xc95587b4 dest_prefix 0xc9572a74 dest_plen 30 flags 0x3		10
1306131	2003-11-19 17:06:26+02	2003-11-19 17:06:27.04361+02	r201	3732	chassisd[2228]:	CHASSISD_IFDEV_DETACH_FPC:	ifdev_detach(0) 		10
1306187	2003-11-19 17:06:26+02	2003-11-19 17:06:28.021679+02	r201	3732	rpd[2235]:		EVENT <Delete> index 137 <Broadcast Multicast>		10
1306176	2003-11-19 17:06:26+02	2003-11-19 17:06:27.823425+02	r201	3732	rpd[2235]:		EVENT Delete sp-0/2/0.16383 index 68 10.0.0.1 -> 10.0.0.18 <Broadcast PointToPoint Multicast>		10
1306185	2003-11-19 17:06:26+02	2003-11-19 17:06:28.011712+02	r201	3732	/kernel:		if_msg_ifl_family_delete(71) family 33		10
1345797	2003-11-20 19:24:42+02	2003-11-20 19:24:42.579448+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1345795	2003-11-20 19:24:42+02	2003-11-20 19:24:42.511614+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1345796	2003-11-20 19:24:42+02	2003-11-20 19:24:42.525057+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1306178	2003-11-19 17:06:26+02	2003-11-19 17:06:27.831072+02	r201	3732	/kernel:		if_msg_ifl_addr_delete(71) local_prefix 0xc94de78c dest_prefix 0xc94de7a0 dest_plen 30 flags 0x3		10
1306171	2003-11-19 17:06:26+02	2003-11-19 17:06:27.799388+02	r201	3732	rpd[2235]:		EVENT Delete ge-0/3/0.0 index 69 <Broadcast Multicast>		10
1306135	2003-11-19 17:06:26+02	2003-11-19 17:06:27.160888+02	r201	3732	mib2d[2234]:	SNMP_TRAP_LINK_DOWN:	ifIndex 21, ifAdminStatus up(1), ifOperStatus down(2), ifName ge-0/3/0		10
1306158	2003-11-19 17:06:26+02	2003-11-19 17:06:27.470106+02	r201	3732	/kernel:		if_msg_ifl_addr_delete(68) local_prefix 0xc94f08f4 dest_prefix 0xc9544a34 dest_plen 32 flags 0x3		10
1306184	2003-11-19 17:06:26+02	2003-11-19 17:06:28.005683+02	r201	3732	/kernel:		if_msg_ifl_family_delete(71) family 33		10
1306197	2003-11-19 17:06:26+02	2003-11-19 17:06:28.165808+02	r201	3732	rpd[2235]:	RPD_EXIT:	Exit rpd[2235] version 6.0R2.3 built by builder on 2003-09-25 00:04:23 UTC, caller 809d7f3		10
1306161	2003-11-19 17:06:26+02	2003-11-19 17:06:27.64297+02	r201	3732	rpd[2235]:		EVENT <UpDown MTU> index 137 <Broadcast Multicast>		10
1306137	2003-11-19 17:06:26+02	2003-11-19 17:06:27.168347+02	r201	3732	rpd[2235]:		EVENT UpDown ge-0/3/0.0 index 69 1.1.0.1/30 -> 1.1.0.3 <Broadcast Multicast Localup>		10
1306141	2003-11-19 17:06:26+02	2003-11-19 17:06:27.184262+02	r201	3732	rpd[2235]:	RPD_ISIS_ADJDOWN:	IS-IS lost L2 adjacency to atlas on ge-0/3/0.0, reason: Interface Down		10
1306150	2003-11-19 17:06:26+02	2003-11-19 17:06:27.324446+02	r201	3732	snmpd[2233]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 3 traps in queue 		2
1306218	2003-11-19 17:06:27+02	2003-11-19 17:06:28.522265+02	ganymede	3731	rpd[4513]:	RPD_LDP_NBRDOWN:	LDP neighbor 1.0.0.2 (ge-1/3/0.0) is down		10
1306220	2003-11-19 17:06:27+02	2003-11-19 17:06:28.53189+02	ganymede	3731	rpd[4513]:		EVENT UpDown ge-1/3/0.0 index 74 <Broadcast Multicast>		10
1306219	2003-11-19 17:06:27+02	2003-11-19 17:06:28.525981+02	ganymede	3731	rpd[4513]:	RPD_LDP_SESSIONDOWN:	LDP session 10.100.254.23 is down, reason: all adjacencies down		10
1306213	2003-11-19 17:06:27+02	2003-11-19 17:06:28.499482+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 163 traps in queue 		2
1306203	2003-11-19 17:06:27+02	2003-11-19 17:06:28.351212+02	atlas	3730	rpd[4413]:	RPD_LDP_NBRDOWN:	LDP neighbor 1.1.0.1 (ge-0/3/0.0) is down		10
1306210	2003-11-19 17:06:27+02	2003-11-19 17:06:28.378197+02	atlas	3730	rpd[4413]:		EVENT <UpDown> index 134 <Broadcast Multicast> address #0 0.90.69.9e.30.5d		10
1306208	2003-11-19 17:06:27+02	2003-11-19 17:06:28.370243+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 160 traps in queue 		2
1306212	2003-11-19 17:06:27+02	2003-11-19 17:06:28.495075+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 162 traps in queue 		2
1306209	2003-11-19 17:06:27+02	2003-11-19 17:06:28.374377+02	atlas	3730	rpd[4413]:		EVENT UpDown ge-0/3/0.0 index 72 <Broadcast Multicast>		10
1306214	2003-11-19 17:06:27+02	2003-11-19 17:06:28.505293+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 164 traps in queue 		2
1306216	2003-11-19 17:06:27+02	2003-11-19 17:06:28.514752+02	ganymede	3731	mib2d[4512]:	SNMP_TRAP_LINK_DOWN:	ifIndex 58, ifAdminStatus up(1), ifOperStatus down(2), ifName ge-1/3/0		10
1306223	2003-11-19 17:06:27+02	2003-11-19 17:06:28.651677+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> index 151 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1306204	2003-11-19 17:06:27+02	2003-11-19 17:06:28.355128+02	atlas	3730	rpd[4413]:	RPD_LDP_SESSIONDOWN:	LDP session 10.100.254.23 is down, reason: all adjacencies down		10
1306217	2003-11-19 17:06:27+02	2003-11-19 17:06:28.518548+02	ganymede	3731	rpd[4513]:		EVENT UpDown ge-1/3/0.0 index 74 1.0.0.1/30 -> 1.0.0.3 <Broadcast Multicast Localup>		10
1306207	2003-11-19 17:06:27+02	2003-11-19 17:06:28.366484+02	atlas	3730	rpd[4413]:	RPD_ISIS_ADJDOWN:	IS-IS lost L2 adjacency to r201 on ge-0/3/0.0, reason: Interface Down		10
1306202	2003-11-19 17:06:27+02	2003-11-19 17:06:28.344992+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 158 traps in queue 		2
1306201	2003-11-19 17:06:27+02	2003-11-19 17:06:28.339374+02	atlas	3730	rpd[4413]:		EVENT UpDown ge-0/3/0.0 index 72 1.1.0.2/30 -> 1.1.0.3 <Broadcast Multicast Localup>		10
1306205	2003-11-19 17:06:27+02	2003-11-19 17:06:28.358926+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 159 traps in queue 		2
1306221	2003-11-19 17:06:27+02	2003-11-19 17:06:28.639417+02	ganymede	3731	rpd[4513]:	RPD_ISIS_ADJDOWN:	IS-IS lost L2 adjacency to r201 on ge-1/3/0.0, reason: Interface Down		10
1306206	2003-11-19 17:06:27+02	2003-11-19 17:06:28.362753+02	atlas	3730	rpd[4413]:		EVENT UpDown ge-0/3/0.0 index 72 <Broadcast Multicast>		10
1306199	2003-11-19 17:06:27+02	2003-11-19 17:06:28.175888+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 157 traps in queue 		2
1306211	2003-11-19 17:06:27+02	2003-11-19 17:06:28.489405+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 161 traps in queue 		2
1306200	2003-11-19 17:06:27+02	2003-11-19 17:06:28.234156+02	atlas	3730	mib2d[4412]:	SNMP_TRAP_LINK_DOWN:	ifIndex 24, ifAdminStatus up(1), ifOperStatus down(2), ifName ge-0/3/0		10
1306198	2003-11-19 17:06:27+02	2003-11-19 17:06:28.171875+02	atlas	3730	rpd[4413]:		EVENT <UpDown> ge-0/3/0.0 index 72 <Broadcast Multicast> address #0 0.90.69.9e.30.5d		10
1306222	2003-11-19 17:06:27+02	2003-11-19 17:06:28.644974+02	ganymede	3731	rpd[4513]:		EVENT UpDown ge-1/3/0.0 index 74 <Broadcast Multicast>		10
1306215	2003-11-19 17:06:27+02	2003-11-19 17:06:28.510365+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> ge-1/3/0.0 index 74 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1306225	2003-11-19 17:06:28+02	2003-11-19 17:06:28.661552+02	atlas	3730	rpd[4413]:	RPD_LAYER2_VC_DOWN:	 Layer-2 VC (VPN : x25_cqt, local-site : 1, remote-site : 2) state changed from UP to DELETED		10
1306224	2003-11-19 17:06:28+02	2003-11-19 17:06:28.65573+02	atlas	3730	/kernel:	e1-0/0/0:	received CCC status, setting CCC-Down		10
1306227	2003-11-19 17:06:29+02	2003-11-19 17:06:29.223337+02	ganymede	3731	rpd[4513]:	RPD_LAYER2_VC_DOWN:	 Layer-2 VC (VPN : x25_cqt, local-site : 2, remote-site : 1) state changed from UP to DELETED		10
1306226	2003-11-19 17:06:29+02	2003-11-19 17:06:29.21102+02	ganymede	3731	/kernel:	e1-0/0/0:	received CCC status, setting CCC-Down		10
1306237	2003-11-19 17:06:31+02	2003-11-19 17:06:31.268767+02	r201	3732	/kernel:		rdp keepalive expired, connection dropped - src 1:1020 dest 2:56321		10
1306259	2003-11-19 17:06:31+02	2003-11-19 17:06:31.597013+02	r201	3732	init:		vrrp (PID 2238) exited with status=0 Normal Exit		10
1306239	2003-11-19 17:06:31+02	2003-11-19 17:06:31.282501+02	r201	3732	/kernel:	pfe_listener_disconnect:	conn dropped: listener idx=0, tnpaddr=2		10
1306249	2003-11-19 17:06:31+02	2003-11-19 17:06:31.447406+02	r201	3732	init:		link-management (PID 2249) exited with status=0 Normal Exit		10
1306264	2003-11-19 17:06:31+02	2003-11-19 17:06:31.726583+02	r201	3732	init:		snmp (PID 2233) exited with status=0 Normal Exit		10
1306270	2003-11-19 17:06:31+02	2003-11-19 17:06:31.929483+02	r201	3732	init:		watchdog (PID 2225) exited with status=0 Normal Exit		10
1306267	2003-11-19 17:06:31+02	2003-11-19 17:06:31.739936+02	r201	3732	init:		alarm-control (PID 2229) exited with status=0 Normal Exit		10
1306232	2003-11-19 17:06:31+02	2003-11-19 17:06:31.115673+02	r201	3732	/kernel:	fxp1:	link media DOWN 10Mb / half-duplex		10
1306235	2003-11-19 17:06:31+02	2003-11-19 17:06:31.26+02	r201	3732	/kernel:		rdp retransmit error: Network is down (50) src 1:1020 dest 2:56321		500
1306255	2003-11-19 17:06:31+02	2003-11-19 17:06:31.580561+02	r201	3732	init:		ilmi (PID 2242) exited with status=0 Normal Exit		10
1306253	2003-11-19 17:06:31+02	2003-11-19 17:06:31.572771+02	r201	3732	init:		class-of-service (PID 2244) exited with status=0 Normal Exit		10
1306266	2003-11-19 17:06:31+02	2003-11-19 17:06:31.73616+02	r201	3732	init:		craft-control (PID 2230) exited with status=0 Normal Exit		10
1306265	2003-11-19 17:06:31+02	2003-11-19 17:06:31.730412+02	r201	3732	init:		management (PID 2232) exited with status=0 Normal Exit		10
1306263	2003-11-19 17:06:31+02	2003-11-19 17:06:31.722856+02	r201	3732	init:		mib-process (PID 2234) exited with status=0 Normal Exit		10
1306245	2003-11-19 17:06:31+02	2003-11-19 17:06:31.432486+02	r201	3732	init:		routing-socket-proxy (PID 2256) exited with status=0 Normal Exit		10
1306244	2003-11-19 17:06:31+02	2003-11-19 17:06:31.428733+02	r201	3732	init:		pic-services-logging (PID 2257) exited with status=0 Normal Exit		10
1306240	2003-11-19 17:06:31+02	2003-11-19 17:06:31.411337+02	r201	3732	init:		ntp (PID 8818) exited with status=0 Normal Exit		10
1306242	2003-11-19 17:06:31+02	2003-11-19 17:06:31.421145+02	r201	3732	init:		ecc-error-logging (PID 2259) exited with status=0 Normal Exit		500
1306248	2003-11-19 17:06:31+02	2003-11-19 17:06:31.443666+02	r201	3732	init:		disk-monitoring (PID 2251) exited with status=0 Normal Exit		10
1306260	2003-11-19 17:06:31+02	2003-11-19 17:06:31.709543+02	r201	3732	init:		sonet-aps (PID 2237) exited with status=0 Normal Exit		10
1306243	2003-11-19 17:06:31+02	2003-11-19 17:06:31.42485+02	r201	3732	init:		adaptive-services (PID 2258) exited with status=0 Normal Exit		10
1306269	2003-11-19 17:06:31+02	2003-11-19 17:06:31.822231+02	r201	3732	init:		tnp-process (PID 2226) exited with status=0 Normal Exit		10
1306250	2003-11-19 17:06:31+02	2003-11-19 17:06:31.559402+02	r201	3732	init:		remote-hello (PID 2248) exited with status=0 Normal Exit		10
1306258	2003-11-19 17:06:31+02	2003-11-19 17:06:31.593275+02	r201	3732	init:		sntp (PID 2239) exited with status=0 Normal Exit		10
1306251	2003-11-19 17:06:31+02	2003-11-19 17:06:31.565175+02	r201	3732	init:		helper (PID 2247) exited with status=0 Normal Exit		10
1306268	2003-11-19 17:06:31+02	2003-11-19 17:06:31.744062+02	r201	3732	init:		chassis-control (PID 2228) exited with status=0 Normal Exit		10
1306262	2003-11-19 17:06:31+02	2003-11-19 17:06:31.719097+02	r201	3732	init:		routing (PID 2235) exited with status=0 Normal Exit		10
1306252	2003-11-19 17:06:31+02	2003-11-19 17:06:31.568999+02	r201	3732	init:		network-access (PID 2245) exited with status=0 Normal Exit		10
1306241	2003-11-19 17:06:31+02	2003-11-19 17:06:31.417328+02	r201	3732	init:		interface-control (PID 2264) exited with status=0 Normal Exit		10
1306246	2003-11-19 17:06:31+02	2003-11-19 17:06:31.436209+02	r201	3732	init:		internal-routing-service (PID 2255) exited with status=0 Normal Exit		10
1306261	2003-11-19 17:06:31+02	2003-11-19 17:06:31.715247+02	r201	3732	init:		inet-process (PID 2236) exited with status=0 Normal Exit		10
1306233	2003-11-19 17:06:31+02	2003-11-19 17:06:31.131203+02	r201	3732	/kernel:		rdp retransmit error: Network is down (50) src 1:1020 dest 2:56321		500
1306238	2003-11-19 17:06:31+02	2003-11-19 17:06:31.273151+02	r201	3732	/kernel:	peer_inputs:	soreceive() error 64		500
1306256	2003-11-19 17:06:31+02	2003-11-19 17:06:31.584329+02	r201	3732	init:		sampling (PID 2241) exited with status=0 Normal Exit		10
1306257	2003-11-19 17:06:31+02	2003-11-19 17:06:31.588056+02	r201	3732	init:		pfe (PID 2240) exited with status=0 Normal Exit		10
1306254	2003-11-19 17:06:31+02	2003-11-19 17:06:31.576693+02	r201	3732	init:		remote-operations (PID 2243) exited with status=0 Normal Exit		10
1306247	2003-11-19 17:06:31+02	2003-11-19 17:06:31.439957+02	r201	3732	init:		firewall (PID 2254) exited with status=0 Normal Exit		10
1306272	2003-11-19 17:06:33+02	2003-11-19 17:06:33.136502+02	r201	3732	pccardd[2078]:		pccardd terminated: signal 15 received		10
1306275	2003-11-19 17:06:36+02	2003-11-19 17:06:37.09479+02	r201	3732	syslogd:		exiting on signal 14		10
1332319	2003-11-19 21:07:45+02	2003-11-19 20:50:11.903696+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332330	2003-11-19 21:07:46+02	2003-11-19 20:50:12.903673+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332331	2003-11-19 21:07:46+02	2003-11-19 20:50:12.917469+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332335	2003-11-19 21:07:47+02	2003-11-19 20:50:14.015044+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332334	2003-11-19 21:07:47+02	2003-11-19 20:50:14.007497+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332333	2003-11-19 21:07:47+02	2003-11-19 20:50:14.001951+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332338	2003-11-19 21:07:48+02	2003-11-19 20:50:14.92702+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332336	2003-11-19 21:07:48+02	2003-11-19 20:50:14.905078+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332337	2003-11-19 21:07:48+02	2003-11-19 20:50:14.923271+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332340	2003-11-19 21:07:49+02	2003-11-19 20:50:15.904256+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332341	2003-11-19 21:07:49+02	2003-11-19 20:50:15.920111+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332342	2003-11-19 21:07:49+02	2003-11-19 20:50:15.924096+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332348	2003-11-19 21:07:50+02	2003-11-19 20:50:16.919693+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332347	2003-11-19 21:07:50+02	2003-11-19 20:50:16.904714+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332359	2003-11-19 21:07:51+02	2003-11-19 20:50:25.111414+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306360	2003-11-19 17:07:31+02	2003-11-19 17:07:31.672478+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 165 traps in queue 		2
1306359	2003-11-19 17:07:31+02	2003-11-19 17:07:31.548911+02	atlas	3730	rpd[4413]:	bgp_traffic_timeout:	NOTIFICATION sent to 10.100.254.20 (Internal AS 100): code 4 (Hold Timer Expired Error), Reason: holdtime expired for 10.100.254.20 (Internal AS 100)		10
1306361	2003-11-19 17:07:31+02	2003-11-19 17:07:31.678291+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 166 traps in queue 		2
1301412	2003-11-19 17:07:39+02	2003-11-19 16:50:04.493801+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301420	2003-11-19 17:07:40+02	2003-11-19 16:50:05.496841+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301421	2003-11-19 17:07:40+02	2003-11-19 16:50:05.554535+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301423	2003-11-19 17:07:41+02	2003-11-19 16:50:06.516479+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301424	2003-11-19 17:07:41+02	2003-11-19 16:50:06.52025+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301422	2003-11-19 17:07:41+02	2003-11-19 16:50:06.495005+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301434	2003-11-19 17:07:42+02	2003-11-19 16:50:07.555502+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301432	2003-11-19 17:07:42+02	2003-11-19 16:50:07.496049+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301433	2003-11-19 17:07:42+02	2003-11-19 16:50:07.551594+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301435	2003-11-19 17:07:43+02	2003-11-19 16:50:08.497875+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301437	2003-11-19 17:07:43+02	2003-11-19 16:50:08.51165+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301436	2003-11-19 17:07:43+02	2003-11-19 16:50:08.507885+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301446	2003-11-19 17:07:44+02	2003-11-19 16:50:09.502668+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301445	2003-11-19 17:07:44+02	2003-11-19 16:50:09.496509+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1301497	2003-11-19 17:07:45+02	2003-11-19 16:50:18.858372+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306377	2003-11-19 17:07:51+02	2003-11-19 17:07:51.515436+02	ganymede	3731	rpd[4513]:	bgp_traffic_timeout:	NOTIFICATION sent to 10.100.254.21 (Internal AS 100): code 4 (Hold Timer Expired Error), Reason: holdtime expired for 10.100.254.21 (Internal AS 100)		10
1306399	2003-11-19 17:08:03+02	2003-11-19 17:08:03.574738+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 167 traps in queue 		2
1306402	2003-11-19 17:08:03+02	2003-11-19 17:08:03.722148+02	atlas	3730	rpd[4413]:	bgp_connect_start:	connect 10.100.254.20 (Internal AS 100): No route to host		10
1306400	2003-11-19 17:08:03+02	2003-11-19 17:08:03.712761+02	atlas	3730	rpd[4413]:	task_connect:	task BGP_100.10.100.254.20+179 addr 10.100.254.20+179: No route to host		10
1306401	2003-11-19 17:08:03+02	2003-11-19 17:08:03.718343+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 168 traps in queue 		2
1306404	2003-11-19 17:08:03+02	2003-11-19 17:08:03.730253+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 170 traps in queue 		2
1306403	2003-11-19 17:08:03+02	2003-11-19 17:08:03.726429+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 169 traps in queue 		2
1306419	2003-11-19 17:08:23+02	2003-11-19 17:08:23.528643+02	ganymede	3731	rpd[4513]:	task_connect:	task BGP_100.10.100.254.21+179 addr 10.100.254.21+179: No route to host		10
1306420	2003-11-19 17:08:23+02	2003-11-19 17:08:23.542732+02	ganymede	3731	rpd[4513]:	bgp_connect_start:	connect 10.100.254.21 (Internal AS 100): No route to host		10
1306424	2003-11-19 17:08:35+02	2003-11-19 17:08:35.584483+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 171 traps in queue 		2
1306427	2003-11-19 17:08:35+02	2003-11-19 17:08:35.701555+02	atlas	3730	rpd[4413]:	bgp_connect_start:	connect 10.100.254.20 (Internal AS 100): No route to host		10
1306425	2003-11-19 17:08:35+02	2003-11-19 17:08:35.591443+02	atlas	3730	rpd[4413]:	task_connect:	task BGP_100.10.100.254.20+179 addr 10.100.254.20+179: No route to host		10
1306426	2003-11-19 17:08:35+02	2003-11-19 17:08:35.59678+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 172 traps in queue 		2
1306428	2003-11-19 17:08:35+02	2003-11-19 17:08:35.708306+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 173 traps in queue 		2
1306429	2003-11-19 17:08:35+02	2003-11-19 17:08:35.712137+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 174 traps in queue 		2
1332587	2003-11-19 21:12:45+02	2003-11-19 20:55:11.981141+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332590	2003-11-19 21:12:46+02	2003-11-19 20:55:12.986375+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332589	2003-11-19 21:12:46+02	2003-11-19 20:55:12.981697+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332593	2003-11-19 21:12:47+02	2003-11-19 20:55:14.003255+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332592	2003-11-19 21:12:47+02	2003-11-19 20:55:13.999508+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332591	2003-11-19 21:12:47+02	2003-11-19 20:55:13.982097+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332596	2003-11-19 21:12:48+02	2003-11-19 20:55:15.137639+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332595	2003-11-19 21:12:48+02	2003-11-19 20:55:15.117484+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332594	2003-11-19 21:12:48+02	2003-11-19 20:55:14.994866+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332599	2003-11-19 21:12:49+02	2003-11-19 20:55:15.984311+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332598	2003-11-19 21:12:49+02	2003-11-19 20:55:15.978429+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332600	2003-11-19 21:12:49+02	2003-11-19 20:55:15.988079+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332606	2003-11-19 21:12:50+02	2003-11-19 20:55:16.983862+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332605	2003-11-19 21:12:50+02	2003-11-19 20:55:16.977934+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332618	2003-11-19 21:12:51+02	2003-11-19 20:55:25.241667+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306465	2003-11-19 17:08:51+02	2003-11-19 17:08:51.544819+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1306466	2003-11-19 17:08:51+02	2003-11-19 17:08:51.554935+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUE_MAX_ATTEMPTS:	trap_dq_send_traps: after 10 attempts, deleting 174 traps queued to 172.1.0.10 		2
1306482	2003-11-19 17:08:54+02	2003-11-19 17:09:06.829575+02	r201	3732	/kernel:	TNP:	adding neighbor 2 to interface fxp1.		10
1306484	2003-11-19 17:08:54+02	2003-11-19 17:09:06.838332+02	r201	3732	tnp.bootpd[4578]:	BOOTPD_BOOTSTRING:	Boot string: boot 1 sbr.jbf		10
1306481	2003-11-19 17:08:54+02	2003-11-19 17:09:06.823749+02	r201	3732	/kernel:	TNP:	version is changing to 1		10
1306483	2003-11-19 17:08:54+02	2003-11-19 17:09:06.834372+02	r201	3732	tnp.bootpd[4578]:	BOOTPD_VERSION:	Version: TNP.BOOTPD release 6.1R1.4 built by builder on 2003-10-09 20:17:47 UTC		10
1306485	2003-11-19 17:08:54+02	2003-11-19 17:09:06.896529+02	r201	3732	tnp.tftpd[4580]:	TFTPD_CONNECT_INFO:	TFTP read from address 2 port 1024 file sbr.jbf		10
1306475	2003-11-19 17:08:55+02	2003-11-19 17:08:55.549773+02	ganymede	3731	rpd[4513]:	bgp_connect_start:	connect 10.100.254.21 (Internal AS 100): No route to host		10
1306474	2003-11-19 17:08:55+02	2003-11-19 17:08:55.543437+02	ganymede	3731	rpd[4513]:	task_connect:	task BGP_100.10.100.254.21+179 addr 10.100.254.21+179: No route to host		10
1306494	2003-11-19 17:08:58+02	2003-11-19 17:09:09.576397+02	r201	3732	tnp.tftpd[4580]:	TFTPD_SENDCOMPLETE_INFO:	Sent 6144 blocks of 1024 and 1 block of 72 for file '/usr/share/pfe/sbr.jbf' 		10
1306492	2003-11-19 17:09:07+02	2003-11-19 17:09:07.752813+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 3 traps in queue 		2
1306491	2003-11-19 17:09:07+02	2003-11-19 17:09:07.749017+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 2 traps in queue 		2
1306490	2003-11-19 17:09:07+02	2003-11-19 17:09:07.742735+02	atlas	3730	rpd[4413]:	bgp_connect_start:	connect 10.100.254.20 (Internal AS 100): No route to host		10
1306489	2003-11-19 17:09:07+02	2003-11-19 17:09:07.628625+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 1 traps in queue 		2
1306487	2003-11-19 17:09:07+02	2003-11-19 17:09:07.599228+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1306488	2003-11-19 17:09:07+02	2003-11-19 17:09:07.62298+02	atlas	3730	rpd[4413]:	task_connect:	task BGP_100.10.100.254.20+179 addr 10.100.254.20+179: No route to host		10
1306493	2003-11-19 17:09:07+02	2003-11-19 17:09:07.756541+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 4 traps in queue 		2
1306517	2003-11-19 17:09:22+02	2003-11-19 17:09:34.279453+02	r201	3732	rpd[4418]:		EVENT <UpDown> fxp1.0 index 2 <Broadcast Multicast> address #0 0.80.42.11.ca.ae		10
1306516	2003-11-19 17:09:22+02	2003-11-19 17:09:34.273648+02	r201	3732	/kernel:	fxp1:	link media DOWN 10Mb / half-duplex		10
1306525	2003-11-19 17:09:22+02	2003-11-19 17:09:34.436308+02	r201	3732	rpd[4418]:		EVENT <Bandwidth UpDown> index 2 <Broadcast Multicast> address #0 0.80.42.11.ca.ae		10
1306524	2003-11-19 17:09:22+02	2003-11-19 17:09:34.430548+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_DOWN:	ifIndex 2, ifAdminStatus up(1), ifOperStatus down(2), ifName fxp1		10
1306520	2003-11-19 17:09:22+02	2003-11-19 17:09:34.414184+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to throttle queue, 99 traps in queue 		2
1306521	2003-11-19 17:09:22+02	2003-11-19 17:09:34.417902+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.75 to throttle queue, 100 traps in queue 		2
1306519	2003-11-19 17:09:22+02	2003-11-19 17:09:34.410347+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 98 traps in queue 		2
1306518	2003-11-19 17:09:22+02	2003-11-19 17:09:34.392257+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 97 traps in queue 		2
1306522	2003-11-19 17:09:22+02	2003-11-19 17:09:34.422893+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to throttle queue, 101 traps in queue 		2
1306523	2003-11-19 17:09:22+02	2003-11-19 17:09:34.426755+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.75 to throttle queue, 102 traps in queue 		2
1306526	2003-11-19 17:09:22+02	2003-11-19 17:09:34.440148+02	r201	3732	rpd[4418]:		EVENT <Bandwidth> fxp1.0 index 2 <Broadcast Multicast> address #0 0.80.42.11.ca.ae		10
1306527	2003-11-19 17:09:23+02	2003-11-19 17:09:35.108342+02	r201	3732	/kernel:	fxp1:	media DOWN 100Mb / full-duplex		10
1306528	2003-11-19 17:09:23+02	2003-11-19 17:09:35.232241+02	r201	3732	rpd[4418]:		EVENT <Bandwidth> index 2 <Broadcast Multicast> address #0 0.80.42.11.ca.ae		10
1306529	2003-11-19 17:09:23+02	2003-11-19 17:09:35.237887+02	r201	3732	rpd[4418]:		EVENT <Bandwidth> fxp1.0 index 2 <Broadcast Multicast> address #0 0.80.42.11.ca.ae		10
1306539	2003-11-19 17:09:24+02	2003-11-19 17:09:36.248506+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.75 to throttle queue, 106 traps in queue 		2
1306540	2003-11-19 17:09:24+02	2003-11-19 17:09:36.252334+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to throttle queue, 107 traps in queue 		2
1306541	2003-11-19 17:09:24+02	2003-11-19 17:09:36.256059+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.75 to throttle queue, 108 traps in queue 		2
1306542	2003-11-19 17:09:24+02	2003-11-19 17:09:36.259787+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 2, ifAdminStatus up(1), ifOperStatus up(1), ifName fxp1		10
1306543	2003-11-19 17:09:24+02	2003-11-19 17:09:36.263543+02	r201	3732	rpd[4418]:		EVENT <UpDown> index 2 <Up Broadcast Multicast> address #0 0.80.42.11.ca.ae		10
1306538	2003-11-19 17:09:24+02	2003-11-19 17:09:36.242824+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to throttle queue, 105 traps in queue 		2
1306537	2003-11-19 17:09:24+02	2003-11-19 17:09:36.129481+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 104 traps in queue 		2
1306536	2003-11-19 17:09:24+02	2003-11-19 17:09:36.125671+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 103 traps in queue 		2
1306534	2003-11-19 17:09:24+02	2003-11-19 17:09:36.110447+02	r201	3732	/kernel:	fxp1:	link UP 100Mb / full-duplex		10
1306535	2003-11-19 17:09:24+02	2003-11-19 17:09:36.120556+02	r201	3732	rpd[4418]:		EVENT <UpDown> fxp1.0 index 2 <Up Broadcast Multicast> address #0 0.80.42.11.ca.ae		10
1306546	2003-11-19 17:09:26+02	2003-11-19 17:09:37.234741+02	r201	3732	feb	SNTPD:	Initial time of day set. 		10
1306545	2003-11-19 17:09:26+02	2003-11-19 17:09:37.230142+02	r201	3732	feb		On-board NVRAM contains diagnostic information. 		10
1306544	2003-11-19 17:09:26+02	2003-11-19 17:09:37.217007+02	r201	3732	feb		Version 6.1R1.4 by builder on 2003-10-09 21:04:51 UTC 		10
1306585	2003-11-19 17:09:26+02	2003-11-19 17:09:38.494826+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 34 traps in queue 		2
1306580	2003-11-19 17:09:26+02	2003-11-19 17:09:38.469761+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 29 traps in queue 		2
1306581	2003-11-19 17:09:26+02	2003-11-19 17:09:38.473511+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 30 traps in queue 		2
1306579	2003-11-19 17:09:26+02	2003-11-19 17:09:38.466053+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 28 traps in queue 		2
1306578	2003-11-19 17:09:26+02	2003-11-19 17:09:38.461889+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 27 traps in queue 		2
1306584	2003-11-19 17:09:26+02	2003-11-19 17:09:38.484721+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 33 traps in queue 		2
1306583	2003-11-19 17:09:26+02	2003-11-19 17:09:38.480984+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 32 traps in queue 		2
1306582	2003-11-19 17:09:26+02	2003-11-19 17:09:38.47727+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 31 traps in queue 		2
1306551	2003-11-19 17:09:26+02	2003-11-19 17:09:37.886809+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1306552	2003-11-19 17:09:26+02	2003-11-19 17:09:37.894579+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 1 traps in queue 		2
1306553	2003-11-19 17:09:26+02	2003-11-19 17:09:38.019973+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 2 traps in queue 		2
1306577	2003-11-19 17:09:26+02	2003-11-19 17:09:38.458035+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 26 traps in queue 		2
1306562	2003-11-19 17:09:26+02	2003-11-19 17:09:38.170557+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 11 traps in queue 		2
1306554	2003-11-19 17:09:26+02	2003-11-19 17:09:38.025256+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 3 traps in queue 		2
1306561	2003-11-19 17:09:26+02	2003-11-19 17:09:38.166671+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 10 traps in queue 		2
1306558	2003-11-19 17:09:26+02	2003-11-19 17:09:38.153756+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 7 traps in queue 		2
1306557	2003-11-19 17:09:26+02	2003-11-19 17:09:38.147916+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 6 traps in queue 		2
1306556	2003-11-19 17:09:26+02	2003-11-19 17:09:38.142202+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 5 traps in queue 		2
1306555	2003-11-19 17:09:26+02	2003-11-19 17:09:38.030331+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 4 traps in queue 		2
1306560	2003-11-19 17:09:26+02	2003-11-19 17:09:38.16275+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 9 traps in queue 		2
1306559	2003-11-19 17:09:26+02	2003-11-19 17:09:38.157765+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 8 traps in queue 		2
1306564	2003-11-19 17:09:26+02	2003-11-19 17:09:38.185771+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 13 traps in queue 		2
1306563	2003-11-19 17:09:26+02	2003-11-19 17:09:38.182014+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 12 traps in queue 		2
1306568	2003-11-19 17:09:26+02	2003-11-19 17:09:38.31177+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 17 traps in queue 		2
1306565	2003-11-19 17:09:26+02	2003-11-19 17:09:38.189497+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 14 traps in queue 		2
1306567	2003-11-19 17:09:26+02	2003-11-19 17:09:38.307944+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 16 traps in queue 		2
1306576	2003-11-19 17:09:26+02	2003-11-19 17:09:38.452355+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 25 traps in queue 		2
1306566	2003-11-19 17:09:26+02	2003-11-19 17:09:38.302251+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 15 traps in queue 		2
1306571	2003-11-19 17:09:26+02	2003-11-19 17:09:38.323488+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 20 traps in queue 		2
1306570	2003-11-19 17:09:26+02	2003-11-19 17:09:38.319308+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 19 traps in queue 		2
1306569	2003-11-19 17:09:26+02	2003-11-19 17:09:38.315593+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 18 traps in queue 		2
1306575	2003-11-19 17:09:26+02	2003-11-19 17:09:38.339968+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 24 traps in queue 		2
1306574	2003-11-19 17:09:26+02	2003-11-19 17:09:38.336171+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 23 traps in queue 		2
1306572	2003-11-19 17:09:26+02	2003-11-19 17:09:38.327362+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 21 traps in queue 		2
1306573	2003-11-19 17:09:26+02	2003-11-19 17:09:38.331196+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 22 traps in queue 		2
1306503	2003-11-19 17:09:27+02	2003-11-19 17:09:27.555288+02	ganymede	3731	rpd[4513]:	task_connect:	task BGP_100.10.100.254.21+179 addr 10.100.254.21+179: No route to host		10
1306504	2003-11-19 17:09:27+02	2003-11-19 17:09:27.56258+02	ganymede	3731	rpd[4513]:	bgp_connect_start:	connect 10.100.254.21 (Internal AS 100): No route to host		10
1306598	2003-11-19 17:09:32+02	2003-11-19 17:09:43.649876+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 37 traps in queue 		2
1306594	2003-11-19 17:09:32+02	2003-11-19 17:09:43.376187+02	r201	3732	/kernel:		pfe_peer_alloc !VALID(state 0)->OPENING tnp 2		10
1306593	2003-11-19 17:09:32+02	2003-11-19 17:09:43.359798+02	r201	3732	feb	CM:	Established connection to routing engine 		10
1306596	2003-11-19 17:09:32+02	2003-11-19 17:09:43.642367+02	r201	3732	feb	PFEMAN:	Session manager active 		10
1306597	2003-11-19 17:09:32+02	2003-11-19 17:09:43.646131+02	r201	3732	feb	PFEMAN:	Established connection to Master 		10
1306595	2003-11-19 17:09:32+02	2003-11-19 17:09:43.528586+02	r201	3732	/kernel:	pfe_listener_connect:	conn established: listener idx=0, tnpaddr=2		10
1306599	2003-11-19 17:09:32+02	2003-11-19 17:09:43.65538+02	r201	3732	feb	CM:	ALARM SET: (Major) fxp0: ethernet link down 		10
1306600	2003-11-19 17:09:32+02	2003-11-19 17:09:43.661818+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 38 traps in queue 		2
1306603	2003-11-19 17:09:32+02	2003-11-19 17:09:43.676029+02	r201	3732	chassisd[4411]:	CHASSISD_IFDEV_DETACH_ALL_PSEUDO:	ifdev_detach(pseudo devices: all) 		10
1351686	2003-11-21 17:18:42+02	2003-11-21 17:01:22.77038+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351688	2003-11-21 17:18:43+02	2003-11-21 17:01:23.790421+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351687	2003-11-21 17:18:43+02	2003-11-21 17:01:23.771696+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351689	2003-11-21 17:18:44+02	2003-11-21 17:01:24.771316+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351690	2003-11-21 17:18:44+02	2003-11-21 17:01:24.802591+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351691	2003-11-21 17:18:44+02	2003-11-21 17:01:24.806372+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351693	2003-11-21 17:18:45+02	2003-11-21 17:01:25.772181+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351694	2003-11-21 17:18:45+02	2003-11-21 17:01:25.782051+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351695	2003-11-21 17:18:45+02	2003-11-21 17:01:25.785845+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351696	2003-11-21 17:18:46+02	2003-11-21 17:01:26.772099+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351697	2003-11-21 17:18:46+02	2003-11-21 17:01:26.79195+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351698	2003-11-21 17:18:46+02	2003-11-21 17:01:26.795716+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351699	2003-11-21 17:18:47+02	2003-11-21 17:01:27.772844+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351700	2003-11-21 17:18:47+02	2003-11-21 17:01:27.789007+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351703	2003-11-21 17:18:48+02	2003-11-21 17:01:33.430281+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306602	2003-11-19 17:09:32+02	2003-11-19 17:09:43.669845+02	r201	3732	chassisd[4411]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 6, jnxFruL1Index 1, jnxFruL2Index 0, jnxFruL3Index 0, jnxFruName FEB, jnxFruType 5, jnxFruSlot 1, jnxFruOfflineReason 2, jnxFruLastPowerOff 7005, jnxFruLastPowerOn 7005 		100
1306601	2003-11-19 17:09:32+02	2003-11-19 17:09:43.665551+02	r201	3732	feb	CM:	ALARM CLEAR: fxp0: ethernet link down 		10
1306615	2003-11-19 17:09:34+02	2003-11-19 17:09:45.227923+02	r201	3732	chassisd[4411]:	CHASSISD_FRU_EVENT:	fpc_m40_recv_restart: FPC slot 0 restart 		10
1306616	2003-11-19 17:09:34+02	2003-11-19 17:09:45.337767+02	r201	3732	chassisd[4411]:	CHASSISD_FRU_EVENT:	fpc_m40_recv_restart: FPC slot 1 restart 		10
1306550	2003-11-19 17:09:37+02	2003-11-19 17:09:37.691665+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1306625	2003-11-19 17:09:46+02	2003-11-19 17:09:57.709635+02	r201	3732	chassisd[4411]:	CHASSISD_FRU_EVENT:	scb_recv_slot_attach: FPC slot 0 attach 		10
1306638	2003-11-19 17:09:57+02	2003-11-19 17:10:09.079405+02	r201	3732	chassisd[4411]:	CHASSISD_FRU_EVENT:	scb_recv_slot_attach: FPC slot 1 attach 		10
1306644	2003-11-19 17:09:58+02	2003-11-19 17:10:09.322105+02	r201	3732	feb		COS IPC: Received FC->Q map, entries 4, op add 		10
1306639	2003-11-19 17:09:58+02	2003-11-19 17:10:09.179782+02	r201	3732	feb	PFEMAN:	sent Resync request to Master 		10
1306643	2003-11-19 17:09:58+02	2003-11-19 17:10:09.318349+02	r201	3732	feb		COS IPC: Received FC->Q map, entries 4, op add 		10
1306645	2003-11-19 17:09:58+02	2003-11-19 17:10:09.326135+02	r201	3732	feb	PFEMAN:	received Resync complete. 		10
1306652	2003-11-19 17:09:59+02	2003-11-19 17:10:11.11277+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 40 traps in queue 		2
1306653	2003-11-19 17:09:59+02	2003-11-19 17:10:11.118448+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 41 traps in queue 		2
1306651	2003-11-19 17:09:59+02	2003-11-19 17:10:11.001951+02	r201	3732	chassisd[4411]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 1, jnxFruL2Index 3, jnxFruL3Index 0, jnxFruName PIC:  @ 0/2/*, jnxFruType 11, jnxFruSlot 1, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 9768 		100
1306650	2003-11-19 17:09:59+02	2003-11-19 17:10:10.985875+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 39 traps in queue 		2
1306649	2003-11-19 17:09:59+02	2003-11-19 17:10:10.378589+02	r201	3732	feb	CM:	Slot 1: On-line 		10
1306655	2003-11-19 17:09:59+02	2003-11-19 17:10:11.126623+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 42 traps in queue 		2
1306648	2003-11-19 17:09:59+02	2003-11-19 17:10:10.37163+02	r201	3732	feb	CM:	Slot 0: On-line 		10
1306654	2003-11-19 17:09:59+02	2003-11-19 17:10:11.122728+02	r201	3732	chassisd[4411]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 1, jnxFruL2Index 4, jnxFruL3Index 0, jnxFruName PIC:  @ 0/3/*, jnxFruType 11, jnxFruSlot 1, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 9779 		100
1306697	2003-11-19 17:10:00+02	2003-11-19 17:10:12.237422+02	r201	3732	rpd[4418]:		EVENT <Add Bandwidth MTU> index 133 <Broadcast Multicast>		10
1306678	2003-11-19 17:10:00+02	2003-11-19 17:10:11.94758+02	r201	3732	chassisd[4411]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd pe-0/2/0 		10
1306707	2003-11-19 17:10:00+02	2003-11-19 17:10:12.438384+02	r201	3732	rpd[4418]:		EVENT <Add> ge-0/3/0.0 index 68 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306701	2003-11-19 17:10:00+02	2003-11-19 17:10:12.413566+02	r201	3732	rpd[4418]:		EVENT <Add Bandwidth MTU> index 134 <Broadcast Multicast>		10
1306660	2003-11-19 17:10:00+02	2003-11-19 17:10:11.594704+02	r201	3732	chassisd[4411]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd sp-0/2/0 		10
1306669	2003-11-19 17:10:00+02	2003-11-19 17:10:11.75912+02	r201	3732	rpd[4418]:		EVENT <MTU> index 6 <Up Broadcast Loopback Multicast>		10
1306683	2003-11-19 17:10:00+02	2003-11-19 17:10:12.072366+02	r201	3732	chassisd[4411]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd gr-0/2/0 		10
1306695	2003-11-19 17:10:00+02	2003-11-19 17:10:12.229967+02	r201	3732	chassisd[4411]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd vt-0/2/0 		10
1306717	2003-11-19 17:10:00+02	2003-11-19 17:10:12.637805+02	r201	3732	rpd[4418]:		EVENT Add ge-0/3/0.0 index 68 <Broadcast Multicast>		10
1306694	2003-11-19 17:10:00+02	2003-11-19 17:10:12.226048+02	r201	3732	chassisd[4411]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd ip-0/2/0 		10
1306671	2003-11-19 17:10:00+02	2003-11-19 17:10:11.872784+02	r201	3732	chassisd[4411]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd pd-0/2/0 		10
1306684	2003-11-19 17:10:00+02	2003-11-19 17:10:12.076161+02	r201	3732	rpd[4418]:		EVENT <> sp-0/2/0.16383 index 67 <Broadcast PointToPoint Multicast>		10
1306677	2003-11-19 17:10:00+02	2003-11-19 17:10:11.943748+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 46 traps in queue 		2
1306714	2003-11-19 17:10:00+02	2003-11-19 17:10:12.626067+02	r201	3732	rpd[4418]:		EVENT Add ge-0/3/0.0 index 68 <Broadcast Multicast>		10
1306713	2003-11-19 17:10:00+02	2003-11-19 17:10:12.622307+02	r201	3732	rpd[4418]:		EVENT <> ge-0/3/0.0 index 68 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306657	2003-11-19 17:10:00+02	2003-11-19 17:10:11.224916+02	r201	3732	chassisd[4411]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 2, jnxFruL2Index 4, jnxFruL3Index 0, jnxFruName PIC:  @ 1/3/*, jnxFruType 11, jnxFruSlot 2, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 9791 		100
1306698	2003-11-19 17:10:00+02	2003-11-19 17:10:12.241159+02	r201	3732	rpd[4418]:		EVENT <Add Bandwidth MTU> index 132 <Broadcast Multicast>		10
1306700	2003-11-19 17:10:00+02	2003-11-19 17:10:12.251722+02	r201	3732	rpd[4418]:		EVENT <MTU> index 133 <Broadcast Multicast>		10
1306699	2003-11-19 17:10:00+02	2003-11-19 17:10:12.247719+02	r201	3732	chassisd[4411]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd mt-0/2/0 		10
1306667	2003-11-19 17:10:00+02	2003-11-19 17:10:11.743816+02	r201	3732	feb	sp-0/2:	Releasing the Apollo reset 		10
1306676	2003-11-19 17:10:00+02	2003-11-19 17:10:11.939958+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_DOWN:	ifIndex 29, ifAdminStatus up(1), ifOperStatus down(2), ifName sp-0/2/0.16383		10
1306693	2003-11-19 17:10:00+02	2003-11-19 17:10:12.222311+02	r201	3732	rpd[4418]:		EVENT <Add Bandwidth MTU> index 130 <Broadcast Multicast>		10
1306716	2003-11-19 17:10:00+02	2003-11-19 17:10:12.633906+02	r201	3732	rpd[4418]:		EVENT <> ge-0/3/0.0 index 68 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306670	2003-11-19 17:10:00+02	2003-11-19 17:10:11.764858+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 45 traps in queue 		2
1306689	2003-11-19 17:10:00+02	2003-11-19 17:10:12.09791+02	r201	3732	rpd[4418]:		EVENT Add sp-0/2/0.16383 index 67 <Broadcast PointToPoint Multicast>		10
1306672	2003-11-19 17:10:00+02	2003-11-19 17:10:11.878451+02	r201	3732	rpd[4418]:		EVENT <MTU> index 128 <Broadcast Multicast>		10
1306656	2003-11-19 17:10:00+02	2003-11-19 17:10:11.217411+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 43 traps in queue 		2
1306692	2003-11-19 17:10:00+02	2003-11-19 17:10:12.218447+02	r201	3732	rpd[4418]:		EVENT <Add Bandwidth MTU> index 131 <Broadcast Multicast>		10
1306715	2003-11-19 17:10:00+02	2003-11-19 17:10:12.62988+02	r201	3732	rpd[4418]:		EVENT <MTU> ge-0/3/0.0 index 68 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306690	2003-11-19 17:10:00+02	2003-11-19 17:10:12.102054+02	r201	3732	rpd[4418]:		EVENT Add sp-0/2/0.16383 index 67 10.0.0.1 -> 10.0.0.18 <Broadcast PointToPoint Multicast>		10
1306691	2003-11-19 17:10:00+02	2003-11-19 17:10:12.212796+02	r201	3732	rpd[4418]:		EVENT <MTU> index 129 <Broadcast Multicast>		10
1306688	2003-11-19 17:10:00+02	2003-11-19 17:10:12.094179+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 48 traps in queue 		2
1306675	2003-11-19 17:10:00+02	2003-11-19 17:10:11.936219+02	r201	3732	rpd[4418]:		EVENT <Add Bandwidth MTU> index 129 <Broadcast Multicast>		10
1306705	2003-11-19 17:10:00+02	2003-11-19 17:10:12.430751+02	r201	3732	rpd[4418]:		EVENT <Add Bandwidth MTU> index 135 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306702	2003-11-19 17:10:00+02	2003-11-19 17:10:12.419341+02	r201	3732	rpd[4418]:		EVENT <MTU> index 134 <Broadcast Multicast>		10
1306696	2003-11-19 17:10:00+02	2003-11-19 17:10:12.233709+02	r201	3732	rpd[4418]:		EVENT <MTU> index 131 <Broadcast Multicast>		10
1345352	2003-11-20 19:28:14+02	2003-11-20 19:10:48.211104+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345353	2003-11-20 19:28:15+02	2003-11-20 19:10:49.212037+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345354	2003-11-20 19:28:15+02	2003-11-20 19:10:49.220565+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345356	2003-11-20 19:28:16+02	2003-11-20 19:10:50.212082+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345358	2003-11-20 19:28:16+02	2003-11-20 19:10:50.221422+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345357	2003-11-20 19:28:16+02	2003-11-20 19:10:50.217638+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345359	2003-11-20 19:28:17+02	2003-11-20 19:10:51.212488+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345360	2003-11-20 19:28:17+02	2003-11-20 19:10:51.333293+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345361	2003-11-20 19:28:17+02	2003-11-20 19:10:51.338505+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345362	2003-11-20 19:28:18+02	2003-11-20 19:10:52.21378+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345364	2003-11-20 19:28:18+02	2003-11-20 19:10:52.227516+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345363	2003-11-20 19:28:18+02	2003-11-20 19:10:52.222145+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345365	2003-11-20 19:28:19+02	2003-11-20 19:10:53.214573+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345366	2003-11-20 19:28:19+02	2003-11-20 19:10:53.232491+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345370	2003-11-20 19:28:20+02	2003-11-20 19:10:59.680037+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306668	2003-11-19 17:10:00+02	2003-11-19 17:10:11.747543+02	r201	3732	rpd[4418]:		EVENT <Add Bandwidth MTU> index 128 <Broadcast Multicast>		10
1306706	2003-11-19 17:10:00+02	2003-11-19 17:10:12.434653+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 49 traps in queue 		2
1306712	2003-11-19 17:10:00+02	2003-11-19 17:10:12.618554+02	r201	3732	rpd[4418]:		EVENT <MTU> ge-0/3/0.0 index 68 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1346361	2003-11-20 19:40:14+02	2003-11-20 19:40:15.059197+02	r201	3732	login:		login from 172.26.27.115 on ttyp0 as lab		1
1306704	2003-11-19 17:10:00+02	2003-11-19 17:10:12.426837+02	r201	3732	chassisd[4411]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd ge-0/3/0 		10
1306708	2003-11-19 17:10:00+02	2003-11-19 17:10:12.442249+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_DOWN:	ifIndex 37, ifAdminStatus up(1), ifOperStatus down(2), ifName ge-0/3/0.0		10
1306658	2003-11-19 17:10:00+02	2003-11-19 17:10:11.228698+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 44 traps in queue 		2
1306682	2003-11-19 17:10:00+02	2003-11-19 17:10:12.068546+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 47 traps in queue 		2
1306709	2003-11-19 17:10:00+02	2003-11-19 17:10:12.446015+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 50 traps in queue 		2
1306711	2003-11-19 17:10:00+02	2003-11-19 17:10:12.612808+02	r201	3732	rpd[4418]:		EVENT Add ge-0/3/0.0 index 68 1.1.0.1/30 -> 1.1.0.3 <Broadcast Multicast>		10
1306674	2003-11-19 17:10:00+02	2003-11-19 17:10:11.932407+02	r201	3732	/kernel:	sp-0/2/0:	ifl config: op: 1; sub: 16383; flags: 0x8010, curr: 0xdead.		10
1306673	2003-11-19 17:10:00+02	2003-11-19 17:10:11.884253+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 6, ifAdminStatus up(1), ifOperStatus up(1), ifName lo0		10
1306681	2003-11-19 17:10:00+02	2003-11-19 17:10:12.062853+02	r201	3732	rpd[4418]:		EVENT <MTU> sp-0/2/0.16383 index 67 <Broadcast PointToPoint Multicast>		10
1306710	2003-11-19 17:10:00+02	2003-11-19 17:10:12.449755+02	r201	3732	rpd[4418]:		EVENT <MTU> ge-0/3/0.0 index 68 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306680	2003-11-19 17:10:00+02	2003-11-19 17:10:11.95522+02	r201	3732	/kernel:	in_services_ifarequest:	sp-0/2/0		10
1306679	2003-11-19 17:10:00+02	2003-11-19 17:10:11.951324+02	r201	3732	rpd[4418]:		EVENT <Add> sp-0/2/0.16383 index 67 <Broadcast PointToPoint Multicast>		10
1306718	2003-11-19 17:10:01+02	2003-11-19 17:10:12.641628+02	r201	3732	chassisd[4411]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd ge-1/3/0 		10
1306721	2003-11-19 17:10:01+02	2003-11-19 17:10:12.762763+02	r201	3732	rpd[4418]:		EVENT <Add> ge-1/3/0.0 index 69 <Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1306723	2003-11-19 17:10:01+02	2003-11-19 17:10:12.77232+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 52 traps in queue 		2
1306722	2003-11-19 17:10:01+02	2003-11-19 17:10:12.768493+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_DOWN:	ifIndex 38, ifAdminStatus up(1), ifOperStatus down(2), ifName ge-1/3/0.0		10
1306729	2003-11-19 17:10:01+02	2003-11-19 17:10:12.796655+02	r201	3732	rpd[4418]:		EVENT Add ge-1/3/0.0 index 69 <Broadcast Multicast>		10
1306724	2003-11-19 17:10:01+02	2003-11-19 17:10:12.776119+02	r201	3732	rpd[4418]:		EVENT <MTU> ge-1/3/0.0 index 69 <Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1306727	2003-11-19 17:10:01+02	2003-11-19 17:10:12.787888+02	r201	3732	rpd[4418]:		EVENT Add ge-1/3/0.0 index 69 <Broadcast Multicast>		10
1306720	2003-11-19 17:10:01+02	2003-11-19 17:10:12.649449+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 51 traps in queue 		2
1306728	2003-11-19 17:10:01+02	2003-11-19 17:10:12.791604+02	r201	3732	rpd[4418]:		EVENT <MTU> ge-1/3/0.0 index 69 <Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1306726	2003-11-19 17:10:01+02	2003-11-19 17:10:12.784005+02	r201	3732	rpd[4418]:		EVENT <MTU> ge-1/3/0.0 index 69 <Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1306725	2003-11-19 17:10:01+02	2003-11-19 17:10:12.780043+02	r201	3732	rpd[4418]:		EVENT Add ge-1/3/0.0 index 69 1.0.0.2/30 -> 1.0.0.3 <Broadcast Multicast>		10
1306719	2003-11-19 17:10:01+02	2003-11-19 17:10:12.645665+02	r201	3732	rpd[4418]:		EVENT <Add Bandwidth MTU> index 136 <Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1306749	2003-11-19 17:10:02+02	2003-11-19 17:10:13.45265+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1306754	2003-11-19 17:10:03+02	2003-11-19 17:10:14.25082+02	r201	3732	rpd[4418]:	RPD_LDP_NBRUP:	LDP neighbor 1.1.0.2 (ge-0/3/0.0) is up		10
1306755	2003-11-19 17:10:03+02	2003-11-19 17:10:14.266479+02	r201	3732	rpd[4418]:	RPD_LDP_NBRUP:	LDP neighbor 1.0.0.1 (ge-1/3/0.0) is up		10
1306757	2003-11-19 17:10:04+02	2003-11-19 17:10:15.280264+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306756	2003-11-19 17:10:04+02	2003-11-19 17:10:15.250155+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306759	2003-11-19 17:10:05+02	2003-11-19 17:10:16.270098+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306760	2003-11-19 17:10:05+02	2003-11-19 17:10:16.383312+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306766	2003-11-19 17:10:06+02	2003-11-19 17:10:17.6085+02	r201	3732	chassisd[4411]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 7, jnxFruL1Index 1, jnxFruL2Index 0, jnxFruL3Index 0, jnxFruName FPC @ 0/*/*, jnxFruType 3, jnxFruSlot 1, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 10429 		100
1306772	2003-11-19 17:10:06+02	2003-11-19 17:10:17.786214+02	r201	3732	chassisd[4411]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 7, jnxFruL1Index 2, jnxFruL2Index 0, jnxFruL3Index 0, jnxFruName FPC @ 1/*/*, jnxFruType 3, jnxFruSlot 2, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 10441 		100
1306765	2003-11-19 17:10:06+02	2003-11-19 17:10:17.600634+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 53 traps in queue 		2
1306767	2003-11-19 17:10:06+02	2003-11-19 17:10:17.612862+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 54 traps in queue 		2
1306762	2003-11-19 17:10:06+02	2003-11-19 17:10:17.290266+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306771	2003-11-19 17:10:06+02	2003-11-19 17:10:17.782405+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 55 traps in queue 		2
1306763	2003-11-19 17:10:06+02	2003-11-19 17:10:17.309846+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306773	2003-11-19 17:10:06+02	2003-11-19 17:10:17.789945+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 56 traps in queue 		2
1306775	2003-11-19 17:10:07+02	2003-11-19 17:10:18.877508+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306774	2003-11-19 17:10:07+02	2003-11-19 17:10:18.300263+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306777	2003-11-19 17:10:08+02	2003-11-19 17:10:19.338213+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306776	2003-11-19 17:10:08+02	2003-11-19 17:10:19.32058+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306810	2003-11-19 17:10:09+02	2003-11-19 17:10:21.300381+02	r201	3732	rpd[4418]:		EVENT UpDown ge-0/3/0.0 index 68 <Up Broadcast Multicast>		10
1306831	2003-11-19 17:10:09+02	2003-11-19 17:10:21.604526+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 72 traps in queue 		2
1306823	2003-11-19 17:10:09+02	2003-11-19 17:10:21.461016+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 64 traps in queue 		2
1306782	2003-11-19 17:10:09+02	2003-11-19 17:10:20.330645+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306804	2003-11-19 17:10:09+02	2003-11-19 17:10:21.16851+02	r201	3732	rpd[4418]:		EVENT <UpDown MTU> index 132 <Up Broadcast Multicast>		10
1306803	2003-11-19 17:10:09+02	2003-11-19 17:10:21.164709+02	r201	3732	rpd[4418]:		EVENT <UpDown MTU> index 131 <Up Broadcast Multicast>		10
1306820	2003-11-19 17:10:09+02	2003-11-19 17:10:21.449569+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 21, ifAdminStatus up(1), ifOperStatus up(1), ifName ge-0/3/0		10
1306807	2003-11-19 17:10:09+02	2003-11-19 17:10:21.179897+02	r201	3732	rpd[4418]:		EVENT <UpDown> ge-0/3/0.0 index 68 <Up Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306802	2003-11-19 17:10:09+02	2003-11-19 17:10:21.117538+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 62 traps in queue 		2
1306793	2003-11-19 17:10:09+02	2003-11-19 17:10:20.972466+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 58 traps in queue 		2
1306796	2003-11-19 17:10:09+02	2003-11-19 17:10:20.983928+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 60 traps in queue 		2
1306799	2003-11-19 17:10:09+02	2003-11-19 17:10:21.102916+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 61 traps in queue 		2
1306830	2003-11-19 17:10:09+02	2003-11-19 17:10:21.59869+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 71 traps in queue 		2
1306822	2003-11-19 17:10:09+02	2003-11-19 17:10:21.457283+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 63 traps in queue 		2
1306821	2003-11-19 17:10:09+02	2003-11-19 17:10:21.453498+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 22, ifAdminStatus up(1), ifOperStatus up(1), ifName ge-1/3/0		10
1306809	2003-11-19 17:10:09+02	2003-11-19 17:10:21.294634+02	r201	3732	rpd[4418]:		EVENT UpDown ge-0/3/0.0 index 68 <Up Broadcast Multicast>		10
1306792	2003-11-19 17:10:09+02	2003-11-19 17:10:20.968521+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 57 traps in queue 		2
1306808	2003-11-19 17:10:09+02	2003-11-19 17:10:21.184399+02	r201	3732	rpd[4418]:		EVENT UpDown ge-0/3/0.0 index 68 1.1.0.1/30 -> 1.1.0.3 <Up Broadcast Multicast>		10
1306798	2003-11-19 17:10:09+02	2003-11-19 17:10:20.991805+02	r201	3732	rpd[4418]:		EVENT <UpDown MTU> index 129 <Up Broadcast Multicast>		10
1306789	2003-11-19 17:10:09+02	2003-11-19 17:10:20.952923+02	r201	3732	/kernel:	vt-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1306819	2003-11-19 17:10:09+02	2003-11-19 17:10:21.443911+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 36, ifAdminStatus up(1), ifOperStatus up(1), ifName mt-0/2/0		10
1306811	2003-11-19 17:10:09+02	2003-11-19 17:10:21.304212+02	r201	3732	rpd[4418]:		EVENT <UpDown> index 135 <Up Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1306818	2003-11-19 17:10:09+02	2003-11-19 17:10:21.331263+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 35, ifAdminStatus up(1), ifOperStatus up(1), ifName vt-0/2/0		10
1306812	2003-11-19 17:10:09+02	2003-11-19 17:10:21.307997+02	r201	3732	rpd[4418]:		EVENT <UpDown> ge-1/3/0.0 index 69 <Up Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1306791	2003-11-19 17:10:09+02	2003-11-19 17:10:20.964677+02	r201	3732	rpd[4418]:		EVENT <MTU> index 128 <Broadcast Multicast>		10
1306797	2003-11-19 17:10:09+02	2003-11-19 17:10:20.987661+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 32, ifAdminStatus up(1), ifOperStatus up(1), ifName pe-0/2/0		10
1306814	2003-11-19 17:10:09+02	2003-11-19 17:10:21.315928+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 <Up Broadcast Multicast>		10
1306790	2003-11-19 17:10:09+02	2003-11-19 17:10:20.958953+02	r201	3732	/kernel:	mt-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1306817	2003-11-19 17:10:09+02	2003-11-19 17:10:21.327534+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 34, ifAdminStatus up(1), ifOperStatus up(1), ifName ip-0/2/0		10
1306815	2003-11-19 17:10:09+02	2003-11-19 17:10:21.320041+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 <Up Broadcast Multicast>		10
1306816	2003-11-19 17:10:09+02	2003-11-19 17:10:21.323798+02	r201	3732	rpd[4418]:		EVENT <UpDown> index 136 <Up Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1306786	2003-11-19 17:10:09+02	2003-11-19 17:10:20.76346+02	r201	3732	/kernel:	pe-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1306795	2003-11-19 17:10:09+02	2003-11-19 17:10:20.980187+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 59 traps in queue 		2
1306801	2003-11-19 17:10:09+02	2003-11-19 17:10:21.113624+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 33, ifAdminStatus up(1), ifOperStatus up(1), ifName gr-0/2/0		10
1306806	2003-11-19 17:10:09+02	2003-11-19 17:10:21.176152+02	r201	3732	rpd[4418]:		EVENT <UpDown MTU> index 134 <Up Broadcast Multicast>		10
1306829	2003-11-19 17:10:09+02	2003-11-19 17:10:21.592935+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 70 traps in queue 		2
1306800	2003-11-19 17:10:09+02	2003-11-19 17:10:21.108642+02	r201	3732	rpd[4418]:		EVENT <UpDown MTU> index 130 <Up Broadcast Multicast>		10
1306794	2003-11-19 17:10:09+02	2003-11-19 17:10:20.97643+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 31, ifAdminStatus up(1), ifOperStatus up(1), ifName pd-0/2/0		10
1306788	2003-11-19 17:10:09+02	2003-11-19 17:10:20.837541+02	r201	3732	/kernel:	ip-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1306828	2003-11-19 17:10:09+02	2003-11-19 17:10:21.480239+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 69 traps in queue 		2
1306805	2003-11-19 17:10:09+02	2003-11-19 17:10:21.172337+02	r201	3732	rpd[4418]:		EVENT <UpDown MTU> index 133 <Up Broadcast Multicast>		10
1306813	2003-11-19 17:10:09+02	2003-11-19 17:10:21.311832+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 1.0.0.2/30 -> 1.0.0.3 <Up Broadcast Multicast>		10
1306787	2003-11-19 17:10:09+02	2003-11-19 17:10:20.802989+02	r201	3732	/kernel:	gr-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1306785	2003-11-19 17:10:09+02	2003-11-19 17:10:20.733432+02	r201	3732	/kernel:	pd-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1306784	2003-11-19 17:10:09+02	2003-11-19 17:10:20.725258+02	r201	3732	/kernel:	sp-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1306827	2003-11-19 17:10:09+02	2003-11-19 17:10:21.476524+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 68 traps in queue 		2
1306783	2003-11-19 17:10:09+02	2003-11-19 17:10:20.348243+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306824	2003-11-19 17:10:09+02	2003-11-19 17:10:21.464766+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 65 traps in queue 		2
1306826	2003-11-19 17:10:09+02	2003-11-19 17:10:21.472404+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 67 traps in queue 		2
1306825	2003-11-19 17:10:09+02	2003-11-19 17:10:21.468479+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 66 traps in queue 		2
1306833	2003-11-19 17:10:10+02	2003-11-19 17:10:21.612468+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306832	2003-11-19 17:10:10+02	2003-11-19 17:10:21.608545+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306662	2003-11-19 17:10:11+02	2003-11-19 17:10:11.722812+02	atlas	3730	rpd[4413]:	task_connect:	task BGP_100.10.100.254.20+179 addr 10.100.254.20+179: No route to host		10
1306665	2003-11-19 17:10:11+02	2003-11-19 17:10:11.736372+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 7 traps in queue 		2
1306664	2003-11-19 17:10:11+02	2003-11-19 17:10:11.732612+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 6 traps in queue 		2
1306840	2003-11-19 17:10:11+02	2003-11-19 17:10:22.360866+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306663	2003-11-19 17:10:11+02	2003-11-19 17:10:11.728216+02	atlas	3730	rpd[4413]:	bgp_connect_start:	connect 10.100.254.20 (Internal AS 100): No route to host		10
1306841	2003-11-19 17:10:11+02	2003-11-19 17:10:22.382529+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306666	2003-11-19 17:10:11+02	2003-11-19 17:10:11.7401+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 8 traps in queue 		2
1306661	2003-11-19 17:10:11+02	2003-11-19 17:10:11.613457+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 5 traps in queue 		2
1306843	2003-11-19 17:10:12+02	2003-11-19 17:10:23.392658+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306842	2003-11-19 17:10:12+02	2003-11-19 17:10:23.371027+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306745	2003-11-19 17:10:13+02	2003-11-19 17:10:13.406041+02	ganymede	3731	rpd[4513]:		EVENT UpDown ge-1/3/0.0 index 74 1.0.0.1/30 -> 1.0.0.3 <Up Broadcast Multicast>		10
1306736	2003-11-19 17:10:13+02	2003-11-19 17:10:13.260804+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 9 traps in queue 		2
1306744	2003-11-19 17:10:13+02	2003-11-19 17:10:13.396682+02	ganymede	3731	mib2d[4512]:	SNMP_TRAP_LINK_UP:	ifIndex 58, ifAdminStatus up(1), ifOperStatus up(1), ifName ge-1/3/0		10
1306737	2003-11-19 17:10:13+02	2003-11-19 17:10:13.264756+02	atlas	3730	mib2d[4412]:	SNMP_TRAP_LINK_UP:	ifIndex 24, ifAdminStatus up(1), ifOperStatus up(1), ifName ge-0/3/0		10
1306848	2003-11-19 17:10:13+02	2003-11-19 17:10:24.402512+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306847	2003-11-19 17:10:13+02	2003-11-19 17:10:24.391135+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306743	2003-11-19 17:10:13+02	2003-11-19 17:10:13.392945+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> ge-1/3/0.0 index 74 <Up Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1358173	2003-11-21 19:45:17+02	2003-11-21 19:45:18.004406+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1306738	2003-11-19 17:10:13+02	2003-11-19 17:10:13.268489+02	atlas	3730	rpd[4413]:		EVENT UpDown ge-0/3/0.0 index 72 1.1.0.2/30 -> 1.1.0.3 <Up Broadcast Multicast>		10
1306735	2003-11-19 17:10:13+02	2003-11-19 17:10:13.226137+02	atlas	3730	rpd[4413]:		EVENT <UpDown> ge-0/3/0.0 index 72 <Up Broadcast Multicast> address #0 0.90.69.9e.30.5d		10
1306739	2003-11-19 17:10:13+02	2003-11-19 17:10:13.272523+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 10 traps in queue 		2
1306748	2003-11-19 17:10:13+02	2003-11-19 17:10:13.448783+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> index 151 <Up Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1306740	2003-11-19 17:10:13+02	2003-11-19 17:10:13.276274+02	atlas	3730	rpd[4413]:		EVENT UpDown ge-0/3/0.0 index 72 <Up Broadcast Multicast>		10
1306747	2003-11-19 17:10:13+02	2003-11-19 17:10:13.436947+02	ganymede	3731	rpd[4513]:		EVENT UpDown ge-1/3/0.0 index 74 <Up Broadcast Multicast>		10
1306746	2003-11-19 17:10:13+02	2003-11-19 17:10:13.423651+02	ganymede	3731	rpd[4513]:		EVENT UpDown ge-1/3/0.0 index 74 <Up Broadcast Multicast>		10
1306742	2003-11-19 17:10:13+02	2003-11-19 17:10:13.388727+02	atlas	3730	rpd[4413]:		EVENT <UpDown> index 134 <Up Broadcast Multicast> address #0 0.90.69.9e.30.5d		10
1306741	2003-11-19 17:10:13+02	2003-11-19 17:10:13.383046+02	atlas	3730	rpd[4413]:		EVENT UpDown ge-0/3/0.0 index 72 <Up Broadcast Multicast>		10
1306866	2003-11-19 17:10:14+02	2003-11-19 17:10:25.785872+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306865	2003-11-19 17:10:14+02	2003-11-19 17:10:25.401234+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306878	2003-11-19 17:10:15+02	2003-11-19 17:10:26.436755+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306877	2003-11-19 17:10:15+02	2003-11-19 17:10:26.421343+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306880	2003-11-19 17:10:16+02	2003-11-19 17:10:27.446824+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306879	2003-11-19 17:10:16+02	2003-11-19 17:10:27.431352+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.21+646 addr 10.100.254.21+646: No route to host		10
1306885	2003-11-19 17:10:16+02	2003-11-19 17:10:27.713508+02	r201	3732	rpd[4418]:	RPD_ISIS_ADJUP:	IS-IS new L2 adjacency to 0011.1133.3325 on ge-0/3/0.0		10
1306903	2003-11-19 17:10:17+02	2003-11-19 17:10:28.959998+02	r201	3732	rpd[4418]:		EVENT UpDown sp-0/2/0.16383 index 67 10.0.0.1 -> 10.0.0.18 <Up Broadcast PointToPoint Multicast>		10
1306897	2003-11-19 17:10:17+02	2003-11-19 17:10:28.82659+02	r201	3732	/kernel:	sp-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1306904	2003-11-19 17:10:17+02	2003-11-19 17:10:28.963721+02	r201	3732	rpd[4418]:		EVENT <UpDown MTU> index 128 <Up Broadcast Multicast>		10
1306898	2003-11-19 17:10:17+02	2003-11-19 17:10:28.83256+02	r201	3732	rpd[4418]:		EVENT <UpDown> sp-0/2/0.16383 index 67 <Up Broadcast PointToPoint Multicast>		10
1306900	2003-11-19 17:10:17+02	2003-11-19 17:10:28.948589+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 78 traps in queue 		2
1306896	2003-11-19 17:10:17+02	2003-11-19 17:10:28.661197+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 76 traps in queue 		2
1306895	2003-11-19 17:10:17+02	2003-11-19 17:10:28.657483+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 75 traps in queue 		2
1306899	2003-11-19 17:10:17+02	2003-11-19 17:10:28.942988+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 77 traps in queue 		2
1306894	2003-11-19 17:10:17+02	2003-11-19 17:10:28.653758+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 74 traps in queue 		2
1306902	2003-11-19 17:10:17+02	2003-11-19 17:10:28.956269+02	r201	3732	rpd[4418]:		EVENT UpDown sp-0/2/0.16383 index 67 <Up Broadcast PointToPoint Multicast>		10
1306901	2003-11-19 17:10:17+02	2003-11-19 17:10:28.952505+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 24, ifAdminStatus up(1), ifOperStatus up(1), ifName sp-0/2/0		10
1306886	2003-11-19 17:10:17+02	2003-11-19 17:10:28.441414+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306889	2003-11-19 17:10:17+02	2003-11-19 17:10:28.633031+02	r201	3732	rpd[4418]:	RPD_LDP_SESSIONUP:	LDP session 10.100.254.21 is up		10
1306891	2003-11-19 17:10:17+02	2003-11-19 17:10:28.642423+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 73 traps in queue 		2
1306905	2003-11-19 17:10:18+02	2003-11-19 17:10:29.45139+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306839	2003-11-19 17:10:21+02	2003-11-19 17:10:21.982921+02	ganymede	3731	rpd[4513]:	RPD_LDP_NBRUP:	LDP neighbor 1.0.0.2 (ge-1/3/0.0) is up		10
1306838	2003-11-19 17:10:21+02	2003-11-19 17:10:21.742065+02	atlas	3730	rpd[4413]:	RPD_LDP_NBRUP:	LDP neighbor 1.1.0.1 (ge-0/3/0.0) is up		10
1306940	2003-11-19 17:10:27+02	2003-11-19 17:10:38.989702+02	r201	3732	/kernel:		pfe_peer_alloc !VALID(state 0)->OPENING tnp 301989898		10
1306941	2003-11-19 17:10:27+02	2003-11-19 17:10:39.145488+02	r201	3732	/kernel:	pic_listener_connect:	conn established: listener idx=16, addr=0x1200000a		10
1306884	2003-11-19 17:10:27+02	2003-11-19 17:10:27.709575+02	atlas	3730	rpd[4413]:	RPD_ISIS_ADJUP:	IS-IS new L2 adjacency to r201 on ge-0/3/0.0		10
1306939	2003-11-19 17:10:27+02	2003-11-19 17:10:38.98386+02	r201	3732	last		message repeated 9 times		10
1306947	2003-11-19 17:10:28+02	2003-11-19 17:10:39.531787+02	r201	3732	Slot		0, PIC Slot 2) PFEMAN: sent resync request to master 		10
1306943	2003-11-19 17:10:28+02	2003-11-19 17:10:39.155063+02	r201	3732	Slot		0, PIC Slot 2) PFEMAN: Established connection to Master 		10
1306944	2003-11-19 17:10:28+02	2003-11-19 17:10:39.158781+02	r201	3732	Slot		0, PIC Slot 2) Version 6.1R1.4 by builder on 2003-10-09 21:13:30 UTC 		10
1306945	2003-11-19 17:10:28+02	2003-11-19 17:10:39.163652+02	r201	3732	Slot		0, PIC Slot 2) SNTPD: Initial time of day set. 		10
1306946	2003-11-19 17:10:28+02	2003-11-19 17:10:39.169507+02	r201	3732	Slot		0, PIC Slot 2) Loopback mode is now disabled 		10
1306942	2003-11-19 17:10:28+02	2003-11-19 17:10:39.151141+02	r201	3732	Slot		0, PIC Slot 2) PFEMAN: Session manager active 		10
1306887	2003-11-19 17:10:28+02	2003-11-19 17:10:28.457779+02	atlas	3730	rpd[4413]:	RPD_LDP_SESSIONUP:	LDP session 10.100.254.23 is up		10
1306950	2003-11-19 17:10:28+02	2003-11-19 17:10:39.678769+02	r201	3732	Slot		0, PIC Slot 2) PIC online and initial configuration received 		10
1306949	2003-11-19 17:10:28+02	2003-11-19 17:10:39.672888+02	r201	3732	Slot		0, PIC Slot 2) PFEMAN: Got the resync ACK 		10
1306888	2003-11-19 17:10:28+02	2003-11-19 17:10:28.464938+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 11 traps in queue 		2
1306948	2003-11-19 17:10:28+02	2003-11-19 17:10:39.612329+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306890	2003-11-19 17:10:28+02	2003-11-19 17:10:28.638653+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 12 traps in queue 		2
1306893	2003-11-19 17:10:28+02	2003-11-19 17:10:28.649992+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 14 traps in queue 		2
1306892	2003-11-19 17:10:28+02	2003-11-19 17:10:28.646239+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 13 traps in queue 		2
1306951	2003-11-19 17:10:29+02	2003-11-19 17:10:40.188258+02	r201	3732	rpd[4418]:		EVENT <MTU> index 128 <Up Broadcast Multicast>		10
1306952	2003-11-19 17:10:29+02	2003-11-19 17:10:40.622537+02	r201	3732	rpd[4418]:	task_connect:	task LDP Conn.10.100.254.20+646 addr 10.100.254.20+646: No route to host		10
1306910	2003-11-19 17:10:31+02	2003-11-19 17:10:31.571506+02	ganymede	3731	rpd[4513]:	task_connect:	task BGP_100.10.100.254.21+179 addr 10.100.254.21+179: No route to host		10
1306911	2003-11-19 17:10:31+02	2003-11-19 17:10:31.591616+02	ganymede	3731	rpd[4513]:	bgp_connect_start:	connect 10.100.254.21 (Internal AS 100): No route to host		10
1306934	2003-11-19 17:10:37+02	2003-11-19 17:10:37.645037+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1306960	2003-11-19 17:10:46+02	2003-11-19 17:10:58.07902+02	r201	3732	last		message repeated 17 times		10
1306961	2003-11-19 17:10:46+02	2003-11-19 17:10:58.085585+02	r201	3732	rpd[4418]:	RPD_ISIS_ADJUP:	IS-IS new L2 adjacency to ganymede on ge-1/3/0.0		10
1306963	2003-11-19 17:10:47+02	2003-11-19 17:10:58.887285+02	r201	3732	rpd[4418]:	RPD_LDP_SESSIONUP:	LDP session 10.100.254.20 is up		10
1306966	2003-11-19 17:10:47+02	2003-11-19 17:10:58.941483+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 81 traps in queue 		2
1306965	2003-11-19 17:10:47+02	2003-11-19 17:10:58.937583+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 80 traps in queue 		2
1306967	2003-11-19 17:10:47+02	2003-11-19 17:10:59.054465+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 82 traps in queue 		2
1306964	2003-11-19 17:10:47+02	2003-11-19 17:10:58.933803+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 79 traps in queue 		2
1306959	2003-11-19 17:10:57+02	2003-11-19 17:10:58.074994+02	ganymede	3731	rpd[4513]:	RPD_ISIS_ADJUP:	IS-IS new L2 adjacency to r201 on ge-1/3/0.0		10
1306969	2003-11-19 17:10:58+02	2003-11-19 17:10:59.06395+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 16 traps in queue 		2
1306962	2003-11-19 17:10:58+02	2003-11-19 17:10:58.872626+02	ganymede	3731	rpd[4513]:	RPD_LDP_SESSIONUP:	LDP session 10.100.254.23 is up		10
1306968	2003-11-19 17:10:58+02	2003-11-19 17:10:59.060181+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 15 traps in queue 		2
1306990	2003-11-19 17:11:02+02	2003-11-19 17:11:13.40551+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1306997	2003-11-19 17:11:15+02	2003-11-19 17:11:15.763475+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 19 traps in queue 		2
1306998	2003-11-19 17:11:15+02	2003-11-19 17:11:15.767236+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 20 traps in queue 		2
1306994	2003-11-19 17:11:15+02	2003-11-19 17:11:15.629807+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 17 traps in queue 		2
1306995	2003-11-19 17:11:15+02	2003-11-19 17:11:15.753818+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 18 traps in queue 		2
1306996	2003-11-19 17:11:15+02	2003-11-19 17:11:15.759477+02	ganymede	3731	rpd[4513]:	bgp_pp_recv:	dropping 10.100.254.21 (Internal AS 100), connection collision prefers 10.100.254.21+1604 (proto)		10
1307005	2003-11-19 17:11:17+02	2003-11-19 17:11:18.00562+02	atlas	3730	rpd[4413]:	RPD_LAYER2_VC_UP:	 Layer-2 VC (VPN : x25_cqt, local-site : 1, remote-site : 2) state changed to UP		10
1307006	2003-11-19 17:11:18+02	2003-11-19 17:11:18.443669+02	ganymede	3731	rpd[4513]:	RPD_LAYER2_VC_UP:	 Layer-2 VC (VPN : x25_cqt, local-site : 2, remote-site : 1) state changed to UP		10
1332828	2003-11-20 13:08:31+02	2003-11-20 13:08:31.800804+02	r201	3732	xntpd[4414]:		offset -0.000485 sec freq 82.643 ppm error 0.000016 poll 9		500
1307084	2003-11-19 17:11:36+02	2003-11-19 17:11:36.564599+02	atlas	3730	/kernel:	e1-0/0/0:	received CCC status, removing CCC-Down status		10
1307115	2003-11-19 17:11:43+02	2003-11-19 17:11:43.960777+02	ganymede	3731	/kernel:	e1-0/0/0:	received CCC status, removing CCC-Down status		10
1346047	2003-11-20 19:31:31+02	2003-11-20 19:31:32.125908+02	ganymede	3731	xntpd[2770]:		offset 0.000335 sec freq 84.874 ppm error 0.000086 poll 10		500
1332909	2003-11-20 13:10:46+02	2003-11-20 13:10:46.947401+02	atlas	3730	snmpd[2244]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1351780	2003-11-21 17:21:18+02	2003-11-21 17:03:58.662662+02	jupiter	3727	chassisd[4445]:	CHASSISD_SNMP_TRAP6:	SNMP trap: Power Supply failed: jnxContentsContainerIndex 2, jnxContentsL1Index 2, jnxContentsL2Index 0, jnxContentsL3Index 0, jnxContentsDescr PEM 1, jnxOperatingState/Temp 6 		100
1345504	2003-11-20 19:33:14+02	2003-11-20 19:15:48.284486+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345507	2003-11-20 19:33:15+02	2003-11-20 19:15:49.294247+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345506	2003-11-20 19:33:15+02	2003-11-20 19:15:49.286143+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345508	2003-11-20 19:33:16+02	2003-11-20 19:15:50.285762+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345509	2003-11-20 19:33:16+02	2003-11-20 19:15:50.304488+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345510	2003-11-20 19:33:16+02	2003-11-20 19:15:50.308341+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345513	2003-11-20 19:33:17+02	2003-11-20 19:15:51.300835+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345512	2003-11-20 19:33:17+02	2003-11-20 19:15:51.286559+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345514	2003-11-20 19:33:17+02	2003-11-20 19:15:51.304646+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345517	2003-11-20 19:33:18+02	2003-11-20 19:15:52.356629+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345516	2003-11-20 19:33:18+02	2003-11-20 19:15:52.352811+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345515	2003-11-20 19:33:18+02	2003-11-20 19:15:52.332379+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345520	2003-11-20 19:33:19+02	2003-11-20 19:15:53.290898+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345519	2003-11-20 19:33:19+02	2003-11-20 19:15:53.286732+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345522	2003-11-20 19:33:20+02	2003-11-20 19:15:59.810064+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357178	2003-11-21 19:33:49+02	2003-11-21 19:16:30.333433+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307342	2003-11-19 17:12:37+02	2003-11-19 17:12:37.695721+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1302629	2003-11-19 17:12:39+02	2003-11-19 16:55:04.6822+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302636	2003-11-19 17:12:40+02	2003-11-19 16:55:05.682873+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302637	2003-11-19 17:12:40+02	2003-11-19 16:55:05.79042+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302640	2003-11-19 17:12:41+02	2003-11-19 16:55:06.692994+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302638	2003-11-19 17:12:41+02	2003-11-19 16:55:06.683567+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302639	2003-11-19 17:12:41+02	2003-11-19 16:55:06.687757+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302649	2003-11-19 17:12:42+02	2003-11-19 16:55:07.683385+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302651	2003-11-19 17:12:42+02	2003-11-19 16:55:07.691607+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302650	2003-11-19 17:12:42+02	2003-11-19 16:55:07.687641+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302653	2003-11-19 17:12:43+02	2003-11-19 16:55:08.695563+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302654	2003-11-19 17:12:43+02	2003-11-19 16:55:08.699352+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302652	2003-11-19 17:12:43+02	2003-11-19 16:55:08.684484+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302662	2003-11-19 17:12:44+02	2003-11-19 16:55:09.684136+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302663	2003-11-19 17:12:44+02	2003-11-19 16:55:09.690006+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1302707	2003-11-19 17:12:45+02	2003-11-19 16:55:18.990128+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346149	2003-11-20 19:34:35+02	2003-11-20 19:34:35.368822+02	atlas	3730	xntpd[2692]:		offset -0.000217 sec freq 78.176 ppm error 0.000317 poll 10		500
1333172	2003-11-20 13:18:47+02	2003-11-20 13:18:47.151716+02	atlas	3730	snmpd[2244]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1307470	2003-11-19 17:13:02+02	2003-11-19 17:13:13.457814+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1352425	2003-11-21 17:23:05+02	2003-11-21 17:23:05.69366+02	adrastea	3726	xntpd[2231]:		offset -0.000680 sec freq 76.476 ppm error 0.001080 poll 10		500
1333331	2003-11-20 13:23:05+02	2003-11-20 13:23:05.641609+02	adrastea	3726	xntpd[2231]:		offset -0.001107 sec freq 76.487 ppm error 0.000932 poll 10		500
1332713	2003-11-20 13:23:07+02	2003-11-20 13:05:38.723309+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332715	2003-11-20 13:23:08+02	2003-11-20 13:05:39.739673+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332714	2003-11-20 13:23:08+02	2003-11-20 13:05:39.724796+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332716	2003-11-20 13:23:09+02	2003-11-20 13:05:40.724661+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332718	2003-11-20 13:23:09+02	2003-11-20 13:05:40.739187+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332717	2003-11-20 13:23:09+02	2003-11-20 13:05:40.735404+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332721	2003-11-20 13:23:10+02	2003-11-20 13:05:41.749157+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332720	2003-11-20 13:23:10+02	2003-11-20 13:05:41.745347+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332719	2003-11-20 13:23:10+02	2003-11-20 13:05:41.725357+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332724	2003-11-20 13:23:11+02	2003-11-20 13:05:42.74491+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332723	2003-11-20 13:23:11+02	2003-11-20 13:05:42.741104+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332722	2003-11-20 13:23:11+02	2003-11-20 13:05:42.725411+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332726	2003-11-20 13:23:12+02	2003-11-20 13:05:43.736816+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332725	2003-11-20 13:23:12+02	2003-11-20 13:05:43.726078+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332729	2003-11-20 13:23:13+02	2003-11-20 13:05:50.162281+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333370	2003-11-20 13:24:33+02	2003-11-20 13:24:33.299081+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1333372	2003-11-20 13:24:33+02	2003-11-20 13:24:33.431724+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1333371	2003-11-20 13:24:33+02	2003-11-20 13:24:33.317841+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1333456	2003-11-20 13:26:47+02	2003-11-20 13:26:47.378141+02	atlas	3730	snmpd[2244]:	SNMPD_TRAP_QUEUE_MAX_ATTEMPTS:	trap_dq_send_traps: after 10 attempts, deleting 20 traps queued to 172.1.0.10 		2
1333455	2003-11-20 13:26:47+02	2003-11-20 13:26:47.356915+02	atlas	3730	snmpd[2244]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1332893	2003-11-20 13:28:07+02	2003-11-20 13:10:38.912367+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332894	2003-11-20 13:28:08+02	2003-11-20 13:10:39.91317+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332895	2003-11-20 13:28:08+02	2003-11-20 13:10:39.929537+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332897	2003-11-20 13:28:09+02	2003-11-20 13:10:40.924798+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332896	2003-11-20 13:28:09+02	2003-11-20 13:10:40.913683+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332898	2003-11-20 13:28:09+02	2003-11-20 13:10:40.928614+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332899	2003-11-20 13:28:10+02	2003-11-20 13:10:41.913703+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332900	2003-11-20 13:28:10+02	2003-11-20 13:10:41.934413+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332901	2003-11-20 13:28:10+02	2003-11-20 13:10:41.938249+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332903	2003-11-20 13:28:11+02	2003-11-20 13:10:43.037547+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332902	2003-11-20 13:28:11+02	2003-11-20 13:10:42.914682+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332904	2003-11-20 13:28:11+02	2003-11-20 13:10:43.043146+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332905	2003-11-20 13:28:12+02	2003-11-20 13:10:43.914423+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332906	2003-11-20 13:28:12+02	2003-11-20 13:10:43.928479+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1332911	2003-11-20 13:28:13+02	2003-11-20 13:10:50.292671+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333546	2003-11-20 13:29:42+02	2003-11-20 13:29:42.877002+02	ganymede	3731	ftpd[2828]:		connection from 172.26.27.2 (172.26.27.2)		10
1333549	2003-11-20 13:29:42+02	2003-11-20 13:29:43.05015+02	ganymede	3731	ftpd[2828]:		FTP LOGIN FROM 172.26.27.2 as lab		10
1333547	2003-11-20 13:29:42+02	2003-11-20 13:29:42.931376+02	ganymede	3731	ftpd[2828]:		PAM module 0 returned: [0]Success		10
1333548	2003-11-20 13:29:42+02	2003-11-20 13:29:43.044529+02	ganymede	3731	ftpd[2828]:		PAM authentication chain returned: [0]Success		10
1333552	2003-11-20 13:29:43+02	2003-11-20 13:29:43.145054+02	r201	3732	ftpd[4735]:		PAM authentication chain returned: [0]Success		10
1333551	2003-11-20 13:29:43+02	2003-11-20 13:29:43.139617+02	r201	3732	ftpd[4735]:		PAM module 0 returned: [0]Success		10
1333556	2003-11-20 13:29:43+02	2003-11-20 13:29:43.336385+02	atlas	3730	ftpd[2721]:		PAM authentication chain returned: [0]Success		10
1333555	2003-11-20 13:29:43+02	2003-11-20 13:29:43.330274+02	atlas	3730	ftpd[2721]:		PAM module 0 returned: [0]Success		10
1333553	2003-11-20 13:29:43+02	2003-11-20 13:29:43.148911+02	r201	3732	ftpd[4735]:		FTP LOGIN FROM 172.26.27.2 as lab		10
1333554	2003-11-20 13:29:43+02	2003-11-20 13:29:43.268542+02	atlas	3730	ftpd[2721]:		connection from 172.26.27.2 (172.26.27.2)		10
1351851	2003-11-21 17:23:42+02	2003-11-21 17:06:22.848766+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351853	2003-11-21 17:23:43+02	2003-11-21 17:06:23.976228+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351852	2003-11-21 17:23:43+02	2003-11-21 17:06:23.943714+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351856	2003-11-21 17:23:44+02	2003-11-21 17:06:24.867652+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351855	2003-11-21 17:23:44+02	2003-11-21 17:06:24.863859+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351854	2003-11-21 17:23:44+02	2003-11-21 17:06:24.850048+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351859	2003-11-21 17:23:45+02	2003-11-21 17:06:25.972272+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351858	2003-11-21 17:23:45+02	2003-11-21 17:06:25.859818+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351857	2003-11-21 17:23:45+02	2003-11-21 17:06:25.845258+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351862	2003-11-21 17:23:46+02	2003-11-21 17:06:26.916441+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351860	2003-11-21 17:23:46+02	2003-11-21 17:06:26.892402+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351861	2003-11-21 17:23:46+02	2003-11-21 17:06:26.912443+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351864	2003-11-21 17:23:47+02	2003-11-21 17:06:27.866296+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351863	2003-11-21 17:23:47+02	2003-11-21 17:06:27.845989+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1351867	2003-11-21 17:23:48+02	2003-11-21 17:06:33.557328+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333550	2003-11-20 13:29:43+02	2003-11-20 13:29:43.109538+02	r201	3732	ftpd[4735]:		connection from 172.26.27.2 (172.26.27.2)		10
1333557	2003-11-20 13:29:43+02	2003-11-20 13:29:43.340141+02	atlas	3730	ftpd[2721]:		FTP LOGIN FROM 172.26.27.2 as lab		10
1333644	2003-11-20 13:31:31+02	2003-11-20 13:31:32.028061+02	ganymede	3731	xntpd[2770]:		offset -0.000211 sec freq 84.850 ppm error 0.000029 poll 7		500
1345676	2003-11-20 19:38:14+02	2003-11-20 19:20:48.364476+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345677	2003-11-20 19:38:15+02	2003-11-20 19:20:49.363912+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345678	2003-11-20 19:38:15+02	2003-11-20 19:20:49.382673+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345679	2003-11-20 19:38:16+02	2003-11-20 19:20:50.364542+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345680	2003-11-20 19:38:16+02	2003-11-20 19:20:50.378204+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345681	2003-11-20 19:38:16+02	2003-11-20 19:20:50.383298+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345682	2003-11-20 19:38:17+02	2003-11-20 19:20:51.364886+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345684	2003-11-20 19:38:17+02	2003-11-20 19:20:51.378049+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345683	2003-11-20 19:38:17+02	2003-11-20 19:20:51.374202+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345687	2003-11-20 19:38:18+02	2003-11-20 19:20:52.387842+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345686	2003-11-20 19:38:18+02	2003-11-20 19:20:52.38402+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345685	2003-11-20 19:38:18+02	2003-11-20 19:20:52.365209+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345691	2003-11-20 19:38:19+02	2003-11-20 19:20:53.381027+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345690	2003-11-20 19:38:19+02	2003-11-20 19:20:53.365231+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345693	2003-11-20 19:38:20+02	2003-11-20 19:20:59.940788+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333066	2003-11-20 13:33:07+02	2003-11-20 13:15:39.100876+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333067	2003-11-20 13:33:08+02	2003-11-20 13:15:40.102605+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333068	2003-11-20 13:33:08+02	2003-11-20 13:15:40.120157+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333073	2003-11-20 13:33:09+02	2003-11-20 13:15:41.118631+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333072	2003-11-20 13:33:09+02	2003-11-20 13:15:41.114774+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333071	2003-11-20 13:33:09+02	2003-11-20 13:15:41.102632+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333074	2003-11-20 13:33:10+02	2003-11-20 13:15:42.102828+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333075	2003-11-20 13:33:10+02	2003-11-20 13:15:42.124876+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333076	2003-11-20 13:33:10+02	2003-11-20 13:15:42.128626+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333079	2003-11-20 13:33:11+02	2003-11-20 13:15:43.120532+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333078	2003-11-20 13:33:11+02	2003-11-20 13:15:43.102906+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333080	2003-11-20 13:33:11+02	2003-11-20 13:15:43.124388+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333082	2003-11-20 13:33:12+02	2003-11-20 13:15:44.116252+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333081	2003-11-20 13:33:12+02	2003-11-20 13:15:44.10361+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333085	2003-11-20 13:33:13+02	2003-11-20 13:15:50.423157+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333726	2003-11-20 13:34:35+02	2003-11-20 13:34:35.271182+02	atlas	3730	xntpd[2692]:		offset -0.000073 sec freq 78.093 ppm error 0.000384 poll 9		500
1303355	2003-11-19 17:15:33+02	2003-11-19 16:57:58.425974+02	jupiter	3727	chassisd[4445]:	CHASSISD_SNMP_TRAP6:	SNMP trap: Power Supply failed: jnxContentsContainerIndex 2, jnxContentsL1Index 2, jnxContentsL2Index 0, jnxContentsL3Index 0, jnxContentsDescr PEM 1, jnxOperatingState/Temp 6 		100
1346327	2003-11-20 19:40:06+02	2003-11-20 19:40:06.78877+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1346328	2003-11-20 19:40:06+02	2003-11-20 19:40:06.81385+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1346329	2003-11-20 19:40:06+02	2003-11-20 19:40:06.819007+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1352489	2003-11-21 17:24:45+02	2003-11-21 17:24:45.853105+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1352488	2003-11-21 17:24:45+02	2003-11-21 17:24:45.842529+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1352490	2003-11-21 17:24:45+02	2003-11-21 17:24:45.857137+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1333234	2003-11-20 13:38:07+02	2003-11-20 13:20:39.289762+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333237	2003-11-20 13:38:08+02	2003-11-20 13:20:40.326791+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333236	2003-11-20 13:38:08+02	2003-11-20 13:20:40.303841+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333238	2003-11-20 13:38:09+02	2003-11-20 13:20:41.29161+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333240	2003-11-20 13:38:09+02	2003-11-20 13:20:41.312536+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333239	2003-11-20 13:38:09+02	2003-11-20 13:20:41.308576+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333243	2003-11-20 13:38:10+02	2003-11-20 13:20:42.411706+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333242	2003-11-20 13:38:10+02	2003-11-20 13:20:42.40633+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333241	2003-11-20 13:38:10+02	2003-11-20 13:20:42.291079+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333246	2003-11-20 13:38:11+02	2003-11-20 13:20:43.317171+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333245	2003-11-20 13:38:11+02	2003-11-20 13:20:43.312063+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333244	2003-11-20 13:38:11+02	2003-11-20 13:20:43.292076+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333248	2003-11-20 13:38:12+02	2003-11-20 13:20:44.29186+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333249	2003-11-20 13:38:12+02	2003-11-20 13:20:44.309714+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333252	2003-11-20 13:38:13+02	2003-11-20 13:20:50.553396+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1308274	2003-11-19 17:16:37+02	2003-11-19 17:16:37.800633+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1346330	2003-11-20 19:40:06+02	2003-11-20 19:40:06.823938+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1346331	2003-11-20 19:40:06+02	2003-11-20 19:40:06.828888+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1346332	2003-11-20 19:40:06+02	2003-11-20 19:40:06.946952+02	ganymede	3731	mgd[2853]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1346333	2003-11-20 19:40:06+02	2003-11-20 19:40:06.952717+02	ganymede	3731	mgd[2853]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2853]		1
1346334	2003-11-20 19:40:06+02	2003-11-20 19:40:07.001083+02	ganymede	3731	mgd[2853]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1346335	2003-11-20 19:40:06+02	2003-11-20 19:40:07.100251+02	ganymede	3731	mgd[2853]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1346336	2003-11-20 19:40:07+02	2003-11-20 19:40:07.20273+02	ganymede	3731	mgd[2853]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show isis database extensive '		1
1346337	2003-11-20 19:40:07+02	2003-11-20 19:40:07.387634+02	ganymede	3731	mgd[2853]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show ospf database extensive '		1
1346338	2003-11-20 19:40:07+02	2003-11-20 19:40:07.476111+02	ganymede	3731	mgd[2853]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1346339	2003-11-20 19:40:07+02	2003-11-20 19:40:07.482075+02	ganymede	3731	mgd[2853]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1346340	2003-11-20 19:40:07+02	2003-11-20 19:40:07.527508+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[2851]:	exit status 0x100		10
1346353	2003-11-20 19:40:14+02	2003-11-20 19:40:14.904034+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1346343	2003-11-20 19:40:14+02	2003-11-20 19:40:14.703258+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1346349	2003-11-20 19:40:14+02	2003-11-20 19:40:14.883036+02	atlas	3730	login:		login from 172.26.27.115 on ttyp0 as lab		1
1346373	2003-11-20 19:40:14+02	2003-11-20 19:40:15.351536+02	adrastea	3726	mgd[5002]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1346345	2003-11-20 19:40:14+02	2003-11-20 19:40:14.754945+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1346355	2003-11-20 19:40:14+02	2003-11-20 19:40:14.916116+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1346372	2003-11-20 19:40:14+02	2003-11-20 19:40:15.346614+02	adrastea	3726	mgd[5003]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [5003]		1
1346371	2003-11-20 19:40:14+02	2003-11-20 19:40:15.341929+02	adrastea	3726	mgd[5003]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1346362	2003-11-20 19:40:14+02	2003-11-20 19:40:15.064452+02	atlas	3730	mgd[2744]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1346370	2003-11-20 19:40:14+02	2003-11-20 19:40:15.335453+02	ganymede	3731	mgd[2856]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2856]		1
1346369	2003-11-20 19:40:14+02	2003-11-20 19:40:15.330997+02	ganymede	3731	mgd[2856]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1346366	2003-11-20 19:40:14+02	2003-11-20 19:40:15.090585+02	r201	3732	mgd[4758]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1346368	2003-11-20 19:40:14+02	2003-11-20 19:40:15.325832+02	atlas	3730	mgd[2744]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1346367	2003-11-20 19:40:14+02	2003-11-20 19:40:15.202623+02	r201	3732	mgd[4758]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4758]		1
1346365	2003-11-20 19:40:14+02	2003-11-20 19:40:15.085234+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp1 as lab		1
1346364	2003-11-20 19:40:14+02	2003-11-20 19:40:15.080262+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp1		1
1346379	2003-11-20 19:40:14+02	2003-11-20 19:40:15.479417+02	ganymede	3731	mgd[2856]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1346351	2003-11-20 19:40:14+02	2003-11-20 19:40:14.892801+02	adrastea	3726	mgd[5002]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [5002]		1
1346378	2003-11-20 19:40:14+02	2003-11-20 19:40:15.47551+02	adrastea	3726	mgd[5002]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1346376	2003-11-20 19:40:14+02	2003-11-20 19:40:15.365008+02	ganymede	3731	mgd[2856]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1346375	2003-11-20 19:40:14+02	2003-11-20 19:40:15.36053+02	atlas	3730	mgd[2744]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1346377	2003-11-20 19:40:14+02	2003-11-20 19:40:15.469993+02	adrastea	3726	mgd[5003]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1346354	2003-11-20 19:40:14+02	2003-11-20 19:40:14.910033+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1346374	2003-11-20 19:40:14+02	2003-11-20 19:40:15.356085+02	r201	3732	mgd[4758]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1346352	2003-11-20 19:40:14+02	2003-11-20 19:40:14.896657+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1346358	2003-11-20 19:40:14+02	2003-11-20 19:40:15.038034+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1346356	2003-11-20 19:40:14+02	2003-11-20 19:40:14.921321+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1346357	2003-11-20 19:40:14+02	2003-11-20 19:40:15.030885+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1346363	2003-11-20 19:40:14+02	2003-11-20 19:40:15.071733+02	atlas	3730	mgd[2744]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2744]		1
1346359	2003-11-20 19:40:14+02	2003-11-20 19:40:15.043321+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1346360	2003-11-20 19:40:14+02	2003-11-20 19:40:15.048449+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1346381	2003-11-20 19:40:14+02	2003-11-20 19:40:15.487423+02	r201	3732	mgd[4758]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1346350	2003-11-20 19:40:14+02	2003-11-20 19:40:14.888333+02	adrastea	3726	mgd[5002]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1346380	2003-11-20 19:40:14+02	2003-11-20 19:40:15.483691+02	atlas	3730	mgd[2744]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1346348	2003-11-20 19:40:14+02	2003-11-20 19:40:14.876535+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1346344	2003-11-20 19:40:14+02	2003-11-20 19:40:14.713477+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp0 as lab		1
1308427	2003-11-19 17:17:02+02	2003-11-19 17:17:13.559427+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1355004	2003-11-21 18:43:44+02	2003-11-21 18:26:25.552528+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355006	2003-11-21 18:43:45+02	2003-11-21 18:26:26.561736+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355005	2003-11-21 18:43:45+02	2003-11-21 18:26:26.553383+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355008	2003-11-21 18:43:46+02	2003-11-21 18:26:27.564348+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355007	2003-11-21 18:43:46+02	2003-11-21 18:26:27.557291+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355009	2003-11-21 18:43:46+02	2003-11-21 18:26:27.676583+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355013	2003-11-21 18:43:47+02	2003-11-21 18:26:28.571456+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355012	2003-11-21 18:43:47+02	2003-11-21 18:26:28.567698+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355011	2003-11-21 18:43:47+02	2003-11-21 18:26:28.554052+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355016	2003-11-21 18:43:48+02	2003-11-21 18:26:29.568071+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355014	2003-11-21 18:43:48+02	2003-11-21 18:26:29.55551+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355015	2003-11-21 18:43:48+02	2003-11-21 18:26:29.563385+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355017	2003-11-21 18:43:49+02	2003-11-21 18:26:30.556181+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355018	2003-11-21 18:43:49+02	2003-11-21 18:26:30.573529+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355020	2003-11-21 18:43:50+02	2003-11-21 18:26:35.63965+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1308465	2003-11-19 17:17:23+02	2003-11-19 17:17:23.896297+02	r201	3732	xntpd[4414]:		synchronisation lost		1
1308464	2003-11-19 17:17:23+02	2003-11-19 17:17:23.891975+02	r201	3732	xntpd[4414]:		kernel pll status change 2041		1
1308463	2003-11-19 17:17:23+02	2003-11-19 17:17:23.871075+02	r201	3732	xntpd[4414]:		time reset 11.001546 s		1
1346347	2003-11-20 19:40:14+02	2003-11-20 19:40:14.870046+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1346346	2003-11-20 19:40:14+02	2003-11-20 19:40:14.76158+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1346511	2003-11-20 19:40:15+02	2003-11-20 19:40:20.018062+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346512	2003-11-20 19:40:15+02	2003-11-20 19:40:20.022082+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346434	2003-11-20 19:40:15+02	2003-11-20 19:40:16.998827+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/proc/2257/file', PID 2753, status 0		1
1346427	2003-11-20 19:40:15+02	2003-11-20 19:40:16.961455+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/proc/2257/file'		1
1346423	2003-11-20 19:40:15+02	2003-11-20 19:40:16.779146+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 5008, status 0		1
1346436	2003-11-20 19:40:15+02	2003-11-20 19:40:17.008597+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/proc/4431/file'		1
1346421	2003-11-20 19:40:15+02	2003-11-20 19:40:16.769122+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/proc/2224/file'		1
1346431	2003-11-20 19:40:15+02	2003-11-20 19:40:16.984528+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/proc/2234/file'		1
1346433	2003-11-20 19:40:15+02	2003-11-20 19:40:16.994619+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 5009, status 0		1
1346428	2003-11-20 19:40:15+02	2003-11-20 19:40:16.967668+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4763, status 0		1
1346432	2003-11-20 19:40:15+02	2003-11-20 19:40:16.988756+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/proc/4438/file', PID 4764, status 0		1
1346435	2003-11-20 19:40:15+02	2003-11-20 19:40:17.003967+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1346491	2003-11-20 19:40:15+02	2003-11-20 19:40:19.645784+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 5021, status 0		1
1346445	2003-11-20 19:40:15+02	2003-11-20 19:40:17.24651+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/proc/4433/file'		1
1346490	2003-11-20 19:40:15+02	2003-11-20 19:40:19.641569+02	ganymede	3731	mgd[2856]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1346519	2003-11-20 19:40:15+02	2003-11-20 19:40:20.328061+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346415	2003-11-20 19:40:15+02	2003-11-20 19:40:16.573346+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/proc/2255/file'		1
1346504	2003-11-20 19:40:15+02	2003-11-20 19:40:19.823891+02	ganymede	3731	mgd[2856]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1346522	2003-11-20 19:40:15+02	2003-11-20 19:40:20.495318+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2757, status 0		1
1346498	2003-11-20 19:40:15+02	2003-11-20 19:40:19.785092+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 5024, status 0		1
1346508	2003-11-20 19:40:15+02	2003-11-20 19:40:20.002439+02	adrastea	3726	mgd[5003]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1346515	2003-11-20 19:40:15+02	2003-11-20 19:40:20.038514+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2756, status 0		1
1346509	2003-11-20 19:40:15+02	2003-11-20 19:40:20.006481+02	adrastea	3726	mgd[5002]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1346462	2003-11-20 19:40:15+02	2003-11-20 19:40:19.087221+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 5012, status 0		1
1346510	2003-11-20 19:40:15+02	2003-11-20 19:40:20.01385+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346492	2003-11-20 19:40:15+02	2003-11-20 19:40:19.651055+02	atlas	3730	mgd[2744]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1346455	2003-11-20 19:40:15+02	2003-11-20 19:40:17.448793+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1346506	2003-11-20 19:40:15+02	2003-11-20 19:40:19.838816+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 5027, status 0		1
1346456	2003-11-20 19:40:15+02	2003-11-20 19:40:17.453902+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1346422	2003-11-20 19:40:15+02	2003-11-20 19:40:16.773834+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/proc/2260/file'		1
1346513	2003-11-20 19:40:15+02	2003-11-20 19:40:20.027337+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4770, status 0		1
1346493	2003-11-20 19:40:15+02	2003-11-20 19:40:19.655334+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1346529	2003-11-20 19:40:15+02	2003-11-20 19:40:20.760265+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5028, status 0		1
1346487	2003-11-20 19:40:15+02	2003-11-20 19:40:19.623485+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1346526	2003-11-20 19:40:15+02	2003-11-20 19:40:20.54638+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2869, status 0		1
1346417	2003-11-20 19:40:15+02	2003-11-20 19:40:16.697637+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/proc/4413/file', PID 4761, status 0		1
1346437	2003-11-20 19:40:15+02	2003-11-20 19:40:17.120971+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/proc/2234/file', PID 2860, status 0		1
1346430	2003-11-20 19:40:15+02	2003-11-20 19:40:16.979195+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/proc/2224/file', PID 2859, status 0		1
1346497	2003-11-20 19:40:15+02	2003-11-20 19:40:19.780854+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1346418	2003-11-20 19:40:15+02	2003-11-20 19:40:16.708614+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/proc/4424/file'		1
1346426	2003-11-20 19:40:15+02	2003-11-20 19:40:16.799062+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/proc/2260/file', PID 2752, status 0		1
1346420	2003-11-20 19:40:15+02	2003-11-20 19:40:16.7349+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/proc/4424/file', PID 4762, status 0		1
1346419	2003-11-20 19:40:15+02	2003-11-20 19:40:16.716131+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/proc/2255/file', PID 2751, status 0		1
1346438	2003-11-20 19:40:15+02	2003-11-20 19:40:17.129839+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/proc/4431/file', PID 4765, status 0		1
1346439	2003-11-20 19:40:15+02	2003-11-20 19:40:17.214039+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/proc/4439/file'		1
1346527	2003-11-20 19:40:15+02	2003-11-20 19:40:20.670005+02	ganymede	3731	mgd[2856]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1346429	2003-11-20 19:40:15+02	2003-11-20 19:40:16.974387+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/proc/4438/file'		1
1346494	2003-11-20 19:40:15+02	2003-11-20 19:40:19.66026+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 5022, status 0		1
1304030	2003-11-19 17:17:39+02	2003-11-19 17:00:04.870957+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304043	2003-11-19 17:17:40+02	2003-11-19 17:00:05.871706+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304044	2003-11-19 17:17:40+02	2003-11-19 17:00:05.880238+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304052	2003-11-19 17:17:41+02	2003-11-19 17:00:06.872486+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304054	2003-11-19 17:17:41+02	2003-11-19 17:00:06.958936+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304053	2003-11-19 17:17:41+02	2003-11-19 17:00:06.89325+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304058	2003-11-19 17:17:42+02	2003-11-19 17:00:08.116368+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304057	2003-11-19 17:17:42+02	2003-11-19 17:00:08.096138+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304056	2003-11-19 17:17:42+02	2003-11-19 17:00:08.03037+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333412	2003-11-20 13:43:07+02	2003-11-20 13:25:39.418399+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333414	2003-11-20 13:43:08+02	2003-11-20 13:25:40.423375+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333413	2003-11-20 13:43:08+02	2003-11-20 13:25:40.419133+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333416	2003-11-20 13:43:09+02	2003-11-20 13:25:41.427693+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333415	2003-11-20 13:43:09+02	2003-11-20 13:25:41.419683+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333417	2003-11-20 13:43:09+02	2003-11-20 13:25:41.483047+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333421	2003-11-20 13:43:10+02	2003-11-20 13:25:42.437758+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333420	2003-11-20 13:43:10+02	2003-11-20 13:25:42.419668+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333422	2003-11-20 13:43:10+02	2003-11-20 13:25:42.443513+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304066	2003-11-19 17:17:43+02	2003-11-19 17:00:08.872875+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304067	2003-11-19 17:17:43+02	2003-11-19 17:00:08.884711+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304068	2003-11-19 17:17:43+02	2003-11-19 17:00:08.888473+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304082	2003-11-19 17:17:44+02	2003-11-19 17:00:09.878975+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304081	2003-11-19 17:17:44+02	2003-11-19 17:00:09.872926+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304326	2003-11-19 17:17:45+02	2003-11-19 17:00:22.858137+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304387	2003-11-19 17:17:55+02	2003-11-19 17:00:24.356476+02	jupiter	3727	login:	tac_send_authen:	connect: timed out		1
1304384	2003-11-19 17:17:55+02	2003-11-19 17:00:24.192127+02	jupiter	3727	login:	tac_send_authen:	connect: timed out		1
1304385	2003-11-19 17:17:55+02	2003-11-19 17:00:24.306057+02	jupiter	3727	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp1		1
1304386	2003-11-19 17:17:55+02	2003-11-19 17:00:24.340819+02	jupiter	3727	login:		login from 172.26.27.115 on ttyp1 as lab		1
1304388	2003-11-19 17:17:55+02	2003-11-19 17:00:24.37393+02	jupiter	3727	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1304411	2003-11-19 17:17:55+02	2003-11-19 17:00:24.795302+02	jupiter	3727	login:		login from 172.26.27.115 on ttyp0 as lab		1
1304438	2003-11-19 17:17:55+02	2003-11-19 17:00:25.464744+02	jupiter	3727	mgd[6810]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1304437	2003-11-19 17:17:55+02	2003-11-19 17:00:25.459512+02	jupiter	3727	mgd[6809]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [6809]		1
1304436	2003-11-19 17:17:55+02	2003-11-19 17:00:25.454276+02	jupiter	3727	mgd[6809]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1304484	2003-11-19 17:17:56+02	2003-11-19 17:00:26.331397+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/proc/4457/file', PID 6827, status 0		1
1304480	2003-11-19 17:17:56+02	2003-11-19 17:00:26.207891+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/proc/4605/file', PID 6825, status 0		1
1304497	2003-11-19 17:17:56+02	2003-11-19 17:00:26.534709+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 6833, status 0		1
1304440	2003-11-19 17:17:56+02	2003-11-19 17:00:25.475987+02	jupiter	3727	mgd[6810]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1304441	2003-11-19 17:17:56+02	2003-11-19 17:00:25.480434+02	jupiter	3727	mgd[6809]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1304445	2003-11-19 17:17:56+02	2003-11-19 17:00:25.637298+02	jupiter	3727	mgd[6810]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1304478	2003-11-19 17:17:56+02	2003-11-19 17:00:26.200189+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/proc/4459/file', PID 6824, status 0		1
1304451	2003-11-19 17:17:56+02	2003-11-19 17:00:25.673925+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/proc/4616/file'		1
1304450	2003-11-19 17:17:56+02	2003-11-19 17:00:25.666671+02	jupiter	3727	mgd[6810]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1304452	2003-11-19 17:17:56+02	2003-11-19 17:00:25.679033+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/proc/4616/file', PID 6811, status 0		1
1304477	2003-11-19 17:17:56+02	2003-11-19 17:00:26.196355+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/proc/4459/file'		1
1304449	2003-11-19 17:17:56+02	2003-11-19 17:00:25.662218+02	jupiter	3727	mgd[6809]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1304479	2003-11-19 17:17:56+02	2003-11-19 17:00:26.203989+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/proc/4605/file'		1
1304462	2003-11-19 17:17:56+02	2003-11-19 17:00:25.870362+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/proc/4615/file'		1
1304456	2003-11-19 17:17:56+02	2003-11-19 17:00:25.847576+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/proc/4447/file', PID 6813, status 0		1
1304492	2003-11-19 17:17:56+02	2003-11-19 17:00:26.409474+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/proc/4457/file'		1
1304483	2003-11-19 17:17:56+02	2003-11-19 17:00:26.32557+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/proc/4457/file'		1
1304503	2003-11-19 17:17:56+02	2003-11-19 17:00:26.663909+02	jupiter	3727	mgd[6810]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1304482	2003-11-19 17:17:56+02	2003-11-19 17:00:26.21785+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/proc/4609/file', PID 6826, status 0		1
1304453	2003-11-19 17:17:56+02	2003-11-19 17:00:25.83427+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/proc/4615/file'		1
1304455	2003-11-19 17:17:56+02	2003-11-19 17:00:25.843771+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/proc/4447/file'		1
1304487	2003-11-19 17:17:56+02	2003-11-19 17:00:26.345262+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1304481	2003-11-19 17:17:56+02	2003-11-19 17:00:26.21165+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/proc/4609/file'		1
1304454	2003-11-19 17:17:56+02	2003-11-19 17:00:25.840014+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/proc/4615/file', PID 6812, status 0		1
1304491	2003-11-19 17:17:56+02	2003-11-19 17:00:26.402687+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/proc/4609/file', PID 6822, status 0		1
1304490	2003-11-19 17:17:56+02	2003-11-19 17:00:26.369255+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/proc/4461/file', PID 6830, status 0		1
1304494	2003-11-19 17:17:56+02	2003-11-19 17:00:26.519631+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1304495	2003-11-19 17:17:56+02	2003-11-19 17:00:26.525906+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 6832, status 0		1
1304496	2003-11-19 17:17:56+02	2003-11-19 17:00:26.529751+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1304485	2003-11-19 17:17:56+02	2003-11-19 17:00:26.335216+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1304493	2003-11-19 17:17:56+02	2003-11-19 17:00:26.513942+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/proc/4457/file', PID 6831, status 0		1
1304458	2003-11-19 17:17:56+02	2003-11-19 17:00:25.855156+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/proc/4601/file', PID 6814, status 0		1
1304460	2003-11-19 17:17:56+02	2003-11-19 17:00:25.862718+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/proc/4616/file'		1
1304457	2003-11-19 17:17:56+02	2003-11-19 17:00:25.851335+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/proc/4601/file'		1
1304461	2003-11-19 17:17:56+02	2003-11-19 17:00:25.866643+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/proc/4616/file', PID 6815, status 0		1
1333423	2003-11-20 13:43:11+02	2003-11-20 13:25:43.422148+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333424	2003-11-20 13:43:11+02	2003-11-20 13:25:43.427976+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333425	2003-11-20 13:43:11+02	2003-11-20 13:25:43.43179+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333426	2003-11-20 13:43:12+02	2003-11-20 13:25:44.420611+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333427	2003-11-20 13:43:12+02	2003-11-20 13:25:44.429151+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333430	2003-11-20 13:43:13+02	2003-11-20 13:25:50.683649+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1304502	2003-11-19 17:17:56+02	2003-11-19 17:00:26.556471+02	jupiter	3727	mgd[6809]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1304463	2003-11-19 17:17:56+02	2003-11-19 17:00:25.984879+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/proc/4615/file', PID 6816, status 0		1
1304501	2003-11-19 17:17:56+02	2003-11-19 17:00:26.552137+02	jupiter	3727	mgd[6809]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1304489	2003-11-19 17:17:56+02	2003-11-19 17:00:26.359977+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/proc/4461/file'		1
1304439	2003-11-19 17:17:56+02	2003-11-19 17:00:25.469779+02	jupiter	3727	mgd[6810]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [6810]		1
1304499	2003-11-19 17:17:56+02	2003-11-19 17:00:26.542565+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/proc/4461/file', PID 6834, status 0		1
1304488	2003-11-19 17:17:56+02	2003-11-19 17:00:26.349365+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 6829, status 0		1
1304466	2003-11-19 17:17:56+02	2003-11-19 17:00:25.999049+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/proc/4601/file'		1
1304467	2003-11-19 17:17:56+02	2003-11-19 17:00:26.002926+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/proc/4601/file', PID 6818, status 0		1
1304465	2003-11-19 17:17:56+02	2003-11-19 17:00:25.995068+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/proc/4447/file', PID 6817, status 0		1
1304464	2003-11-19 17:17:56+02	2003-11-19 17:00:25.990504+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/proc/4447/file'		1
1304459	2003-11-19 17:17:56+02	2003-11-19 17:00:25.85899+02	jupiter	3727	mgd[6809]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1304476	2003-11-19 17:17:56+02	2003-11-19 17:00:26.192415+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 6823, status 0		1
1304468	2003-11-19 17:17:56+02	2003-11-19 17:00:26.006764+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1304471	2003-11-19 17:17:56+02	2003-11-19 17:00:26.020127+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/proc/4459/file', PID 6820, status 0		1
1304470	2003-11-19 17:17:56+02	2003-11-19 17:00:26.016366+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/proc/4459/file'		1
1304469	2003-11-19 17:17:56+02	2003-11-19 17:00:26.010503+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 6819, status 0		1
1304500	2003-11-19 17:17:56+02	2003-11-19 17:00:26.548311+02	jupiter	3727	mgd[6810]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1304475	2003-11-19 17:17:56+02	2003-11-19 17:00:26.188604+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1304472	2003-11-19 17:17:56+02	2003-11-19 17:00:26.023874+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/proc/4605/file'		1
1304486	2003-11-19 17:17:56+02	2003-11-19 17:00:26.338948+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 6828, status 0		1
1304474	2003-11-19 17:17:56+02	2003-11-19 17:00:26.139635+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/proc/4609/file'		1
1304473	2003-11-19 17:17:56+02	2003-11-19 17:00:26.133957+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/proc/4605/file', PID 6821, status 0		1
1304498	2003-11-19 17:17:56+02	2003-11-19 17:00:26.538611+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/proc/4461/file'		1
1304526	2003-11-19 17:17:57+02	2003-11-19 17:00:27.2091+02	jupiter	3727	mgd[6810]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1304520	2003-11-19 17:17:57+02	2003-11-19 17:00:27.073789+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304513	2003-11-19 17:17:57+02	2003-11-19 17:00:27.043951+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304524	2003-11-19 17:17:57+02	2003-11-19 17:00:27.19962+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304525	2003-11-19 17:17:57+02	2003-11-19 17:00:27.205208+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6839, status 0		1
1304514	2003-11-19 17:17:57+02	2003-11-19 17:00:27.049535+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6836, status 0		1
1304516	2003-11-19 17:17:57+02	2003-11-19 17:00:27.058455+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304527	2003-11-19 17:17:57+02	2003-11-19 17:00:27.214967+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304512	2003-11-19 17:17:57+02	2003-11-19 17:00:26.930388+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6835, status 0		1
1304517	2003-11-19 17:17:57+02	2003-11-19 17:00:27.062176+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304519	2003-11-19 17:17:57+02	2003-11-19 17:00:27.069989+02	jupiter	3727	last		message repeated 4 times		10
1304523	2003-11-19 17:17:57+02	2003-11-19 17:00:27.193978+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6838, status 0		1
1304518	2003-11-19 17:17:57+02	2003-11-19 17:00:27.066057+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0xc38e30fc/32		10
1304522	2003-11-19 17:17:57+02	2003-11-19 17:00:27.081327+02	jupiter	3727	mgd[6810]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304515	2003-11-19 17:17:57+02	2003-11-19 17:00:27.054502+02	jupiter	3727	mgd[6809]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1304521	2003-11-19 17:17:57+02	2003-11-19 17:00:27.077576+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304511	2003-11-19 17:17:57+02	2003-11-19 17:00:26.925798+02	jupiter	3727	mgd[6809]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1304538	2003-11-19 17:17:58+02	2003-11-19 17:00:27.371593+02	jupiter	3727	mgd[6809]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6837, status 0		1
1304528	2003-11-19 17:17:58+02	2003-11-19 17:00:27.21878+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346525	2003-11-20 19:40:15+02	2003-11-20 19:40:20.533094+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346530	2003-11-20 19:40:15+02	2003-11-20 19:40:20.766398+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346391	2003-11-20 19:40:15+02	2003-11-20 19:40:16.10045+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1346384	2003-11-20 19:40:15+02	2003-11-20 19:40:15.508866+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/proc/2307/file'		1
1346382	2003-11-20 19:40:15+02	2003-11-20 19:40:15.491261+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/proc/2258/file'		1
1346383	2003-11-20 19:40:15+02	2003-11-20 19:40:15.500416+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/proc/2258/file', PID 2745, status 0		1
1346495	2003-11-20 19:40:15+02	2003-11-20 19:40:19.664278+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1346496	2003-11-20 19:40:15+02	2003-11-20 19:40:19.668165+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 5023, status 0		1
1346386	2003-11-20 19:40:15+02	2003-11-20 19:40:15.516755+02	adrastea	3726	mgd[5003]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1346385	2003-11-20 19:40:15+02	2003-11-20 19:40:15.513013+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/proc/2307/file', PID 2746, status 0		1
1346531	2003-11-20 19:40:15+02	2003-11-20 19:40:20.77678+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5029, status 0		1
1346516	2003-11-20 19:40:15+02	2003-11-20 19:40:20.057735+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346499	2003-11-20 19:40:15+02	2003-11-20 19:40:19.790449+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1346500	2003-11-20 19:40:15+02	2003-11-20 19:40:19.802307+02	adrastea	3726	mgd[5002]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1346502	2003-11-20 19:40:15+02	2003-11-20 19:40:19.814023+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1346501	2003-11-20 19:40:15+02	2003-11-20 19:40:19.810053+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 5025, status 0		1
1346520	2003-11-20 19:40:15+02	2003-11-20 19:40:20.360801+02	r201	3732	mgd[4758]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1346507	2003-11-20 19:40:15+02	2003-11-20 19:40:19.951381+02	r201	3732	mgd[4758]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1346503	2003-11-20 19:40:15+02	2003-11-20 19:40:19.818658+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 5026, status 0		1
1346443	2003-11-20 19:40:15+02	2003-11-20 19:40:17.235261+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/proc/4439/file', PID 4766, status 0		1
1346447	2003-11-20 19:40:15+02	2003-11-20 19:40:17.3604+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/proc/4433/file', PID 4767, status 0		1
1346442	2003-11-20 19:40:15+02	2003-11-20 19:40:17.230732+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 2754, status 0		1
1346441	2003-11-20 19:40:15+02	2003-11-20 19:40:17.223975+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1346444	2003-11-20 19:40:15+02	2003-11-20 19:40:17.241785+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/proc/2268/file'		1
1346533	2003-11-20 19:40:15+02	2003-11-20 19:40:20.874461+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346440	2003-11-20 19:40:15+02	2003-11-20 19:40:17.219032+02	adrastea	3726	mgd[5003]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1346452	2003-11-20 19:40:15+02	2003-11-20 19:40:17.428349+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/proc/4442/file'		1
1346458	2003-11-20 19:40:15+02	2003-11-20 19:40:18.299826+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/proc/2246/file', PID 2862, status 0		1
1346524	2003-11-20 19:40:15+02	2003-11-20 19:40:20.517908+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346528	2003-11-20 19:40:15+02	2003-11-20 19:40:20.74404+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346453	2003-11-20 19:40:15+02	2003-11-20 19:40:17.434969+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 2861, status 0		1
1346532	2003-11-20 19:40:15+02	2003-11-20 19:40:20.799244+02	adrastea	3726	mgd[5002]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1346523	2003-11-20 19:40:15+02	2003-11-20 19:40:20.505595+02	atlas	3730	mgd[2744]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1346521	2003-11-20 19:40:15+02	2003-11-20 19:40:20.458692+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346518	2003-11-20 19:40:15+02	2003-11-20 19:40:20.225629+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4771, status 0		1
1346454	2003-11-20 19:40:15+02	2003-11-20 19:40:17.444539+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/proc/2246/file'		1
1346387	2003-11-20 19:40:15+02	2003-11-20 19:40:15.630138+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1346425	2003-11-20 19:40:15+02	2003-11-20 19:40:16.789869+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1346413	2003-11-20 19:40:15+02	2003-11-20 19:40:16.528549+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/proc/2263/file', PID 2858, status 0		1
1346459	2003-11-20 19:40:15+02	2003-11-20 19:40:18.863571+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1346389	2003-11-20 19:40:15+02	2003-11-20 19:40:15.643648+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1346464	2003-11-20 19:40:15+02	2003-11-20 19:40:19.098245+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1346461	2003-11-20 19:40:15+02	2003-11-20 19:40:19.082913+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 2863, status 0		1
1346460	2003-11-20 19:40:15+02	2003-11-20 19:40:19.070744+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 5011, status 0		1
1346465	2003-11-20 19:40:15+02	2003-11-20 19:40:19.102912+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/proc/2247/file'		1
1346451	2003-11-20 19:40:15+02	2003-11-20 19:40:17.423957+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4768, status 0		1
1346474	2003-11-20 19:40:15+02	2003-11-20 19:40:19.332557+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 2866, status 0		1
1346472	2003-11-20 19:40:15+02	2003-11-20 19:40:19.3176+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 5013, status 0		1
1346467	2003-11-20 19:40:15+02	2003-11-20 19:40:19.220372+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/proc/2247/file', PID 2864, status 0		1
1346469	2003-11-20 19:40:15+02	2003-11-20 19:40:19.295122+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/proc/2243/file', PID 2865, status 0		1
1304536	2003-11-19 17:17:58+02	2003-11-19 17:00:27.359449+02	jupiter	3727	mgd[6810]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1304541	2003-11-19 17:17:58+02	2003-11-19 17:00:27.390213+02	jupiter	3727	inetd[4451]:	/usr/libexec/telnetd[6806]:	exit status 0x100		10
1304537	2003-11-19 17:17:58+02	2003-11-19 17:00:27.365723+02	jupiter	3727	inetd[4451]:	/usr/libexec/telnetd[6805]:	exit status 0x100		10
1304533	2003-11-19 17:17:58+02	2003-11-19 17:00:27.345979+02	jupiter	3727	mgd[6810]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 6840, status 0		1
1304529	2003-11-19 17:17:58+02	2003-11-19 17:00:27.222709+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0xc3990bfc/32		10
1304535	2003-11-19 17:17:58+02	2003-11-19 17:00:27.355643+02	jupiter	3727	mgd[6810]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1304540	2003-11-19 17:17:58+02	2003-11-19 17:00:27.386408+02	jupiter	3727	mgd[6809]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1304539	2003-11-19 17:17:58+02	2003-11-19 17:00:27.375352+02	jupiter	3727	mgd[6809]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1304531	2003-11-19 17:17:58+02	2003-11-19 17:00:27.230269+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304532	2003-11-19 17:17:58+02	2003-11-19 17:00:27.234128+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1304530	2003-11-19 17:17:58+02	2003-11-19 17:00:27.226523+02	jupiter	3727	last		message repeated 4 times		10
1346471	2003-11-20 19:40:15+02	2003-11-20 19:40:19.31249+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 5014, status 0		1
1346483	2003-11-20 19:40:15+02	2003-11-20 19:40:19.497622+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1346482	2003-11-20 19:40:15+02	2003-11-20 19:40:19.492408+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 5017, status 0		1
1346489	2003-11-20 19:40:15+02	2003-11-20 19:40:19.637017+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1346488	2003-11-20 19:40:15+02	2003-11-20 19:40:19.631441+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 5020, status 0		1
1346486	2003-11-20 19:40:15+02	2003-11-20 19:40:19.513147+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 5019, status 0		1
1346485	2003-11-20 19:40:15+02	2003-11-20 19:40:19.50627+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1346410	2003-11-20 19:40:15+02	2003-11-20 19:40:16.513622+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/proc/4453/file', PID 4760, status 0		1
1346388	2003-11-20 19:40:15+02	2003-11-20 19:40:15.635373+02	adrastea	3726	mgd[5002]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1346450	2003-11-20 19:40:15+02	2003-11-20 19:40:17.419195+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/proc/2268/file', PID 2755, status 0		1
1346397	2003-11-20 19:40:15+02	2003-11-20 19:40:16.310118+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1346622	2003-11-20 19:40:17+02	2003-11-20 19:40:22.75441+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1346446	2003-11-20 19:40:15+02	2003-11-20 19:40:17.252157+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1346449	2003-11-20 19:40:15+02	2003-11-20 19:40:17.414704+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 5010, status 0		1
1346448	2003-11-20 19:40:15+02	2003-11-20 19:40:17.368429+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1346393	2003-11-20 19:40:15+02	2003-11-20 19:40:16.146134+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1346412	2003-11-20 19:40:15+02	2003-11-20 19:40:16.522279+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/proc/2259/file', PID 2750, status 0		1
1346479	2003-11-20 19:40:15+02	2003-11-20 19:40:19.470936+02	atlas	3730	mgd[2744]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1346414	2003-11-20 19:40:15+02	2003-11-20 19:40:16.567059+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/proc/4413/file'		1
1346517	2003-11-20 19:40:15+02	2003-11-20 19:40:20.190212+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2868, status 0		1
1346466	2003-11-20 19:40:15+02	2003-11-20 19:40:19.110449+02	r201	3732	mgd[4758]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1346476	2003-11-20 19:40:15+02	2003-11-20 19:40:19.345356+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 5015, status 0		1
1346457	2003-11-20 19:40:15+02	2003-11-20 19:40:17.561161+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/proc/4442/file', PID 4769, status 0		1
1346475	2003-11-20 19:40:15+02	2003-11-20 19:40:19.340785+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1346416	2003-11-20 19:40:15+02	2003-11-20 19:40:16.578593+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1346463	2003-11-20 19:40:15+02	2003-11-20 19:40:19.093234+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1346473	2003-11-20 19:40:15+02	2003-11-20 19:40:19.325382+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1346468	2003-11-20 19:40:15+02	2003-11-20 19:40:19.228439+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/proc/2243/file'		1
1346505	2003-11-20 19:40:15+02	2003-11-20 19:40:19.832001+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1346470	2003-11-20 19:40:15+02	2003-11-20 19:40:19.306734+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1346424	2003-11-20 19:40:15+02	2003-11-20 19:40:16.7831+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1346480	2003-11-20 19:40:15+02	2003-11-20 19:40:19.475448+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 5016, status 0		1
1346477	2003-11-20 19:40:15+02	2003-11-20 19:40:19.459939+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1346411	2003-11-20 19:40:15+02	2003-11-20 19:40:16.517622+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 5007, status 0		1
1346478	2003-11-20 19:40:15+02	2003-11-20 19:40:19.46595+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 2867, status 0		1
1346514	2003-11-20 19:40:15+02	2003-11-20 19:40:20.032829+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346409	2003-11-20 19:40:15+02	2003-11-20 19:40:16.503588+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/proc/2263/file'		1
1346390	2003-11-20 19:40:15+02	2003-11-20 19:40:15.647831+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 2747, status 0		1
1346392	2003-11-20 19:40:15+02	2003-11-20 19:40:16.141639+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 5004, status 0		1
1346405	2003-11-20 19:40:15+02	2003-11-20 19:40:16.379588+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1346398	2003-11-20 19:40:15+02	2003-11-20 19:40:16.31739+02	ganymede	3731	mgd[2856]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1346396	2003-11-20 19:40:15+02	2003-11-20 19:40:16.191644+02	r201	3732	mgd[4758]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1346395	2003-11-20 19:40:15+02	2003-11-20 19:40:16.187734+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 5005, status 0		1
1346394	2003-11-20 19:40:15+02	2003-11-20 19:40:16.152524+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 2748, status 0		1
1346399	2003-11-20 19:40:15+02	2003-11-20 19:40:16.326853+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1346404	2003-11-20 19:40:15+02	2003-11-20 19:40:16.373766+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 5006, status 0		1
1346401	2003-11-20 19:40:15+02	2003-11-20 19:40:16.352431+02	ganymede	3731	mgd[2856]:	UI_CHILD_START:	Starting child '/proc/2244/file'		1
1346403	2003-11-20 19:40:15+02	2003-11-20 19:40:16.369879+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/proc/4453/file'		1
1346402	2003-11-20 19:40:15+02	2003-11-20 19:40:16.362556+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/proc/4434/file', PID 4759, status 0		1
1346481	2003-11-20 19:40:15+02	2003-11-20 19:40:19.484806+02	adrastea	3726	mgd[5002]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1346484	2003-11-20 19:40:15+02	2003-11-20 19:40:19.50178+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 5018, status 0		1
1333602	2003-11-20 13:48:07+02	2003-11-20 13:30:39.491646+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333604	2003-11-20 13:48:08+02	2003-11-20 13:30:40.493305+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333605	2003-11-20 13:48:08+02	2003-11-20 13:30:40.53896+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333606	2003-11-20 13:48:09+02	2003-11-20 13:30:41.492937+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333607	2003-11-20 13:48:09+02	2003-11-20 13:30:41.507809+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333608	2003-11-20 13:48:09+02	2003-11-20 13:30:41.512173+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333610	2003-11-20 13:48:10+02	2003-11-20 13:30:42.539266+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333611	2003-11-20 13:48:10+02	2003-11-20 13:30:42.543312+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333609	2003-11-20 13:48:10+02	2003-11-20 13:30:42.493699+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333614	2003-11-20 13:48:11+02	2003-11-20 13:30:43.502493+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333612	2003-11-20 13:48:11+02	2003-11-20 13:30:43.488773+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333613	2003-11-20 13:48:11+02	2003-11-20 13:30:43.498678+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333615	2003-11-20 13:48:12+02	2003-11-20 13:30:44.489432+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333616	2003-11-20 13:48:12+02	2003-11-20 13:30:44.615451+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333627	2003-11-20 13:48:13+02	2003-11-20 13:30:50.8147+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334218	2003-11-20 13:48:33+02	2003-11-20 13:48:33.935916+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1334219	2003-11-20 13:48:33+02	2003-11-20 13:48:34.043323+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1346611	2003-11-20 19:40:17+02	2003-11-20 19:40:22.435449+02	adrastea	3726	last		message repeated 4 times		10
1334217	2003-11-20 13:48:33+02	2003-11-20 13:48:33.932177+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1346406	2003-11-20 19:40:15+02	2003-11-20 19:40:16.383714+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 2749, status 0		1
1346407	2003-11-20 19:40:15+02	2003-11-20 19:40:16.490996+02	atlas	3730	mgd[2744]:	UI_CHILD_START:	Starting child '/proc/2259/file'		1
1346408	2003-11-20 19:40:15+02	2003-11-20 19:40:16.495281+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/proc/2244/file', PID 2857, status 0		1
1346400	2003-11-20 19:40:15+02	2003-11-20 19:40:16.336913+02	r201	3732	mgd[4758]:	UI_CHILD_START:	Starting child '/proc/4434/file'		1
1346587	2003-11-20 19:40:16+02	2003-11-20 19:40:22.101158+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b8f5fc/32		10
1346550	2003-11-20 19:40:16+02	2003-11-20 19:40:21.313365+02	atlas	3730	last		message repeated 2 times		10
1346565	2003-11-20 19:40:16+02	2003-11-20 19:40:21.60665+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1346561	2003-11-20 19:40:16+02	2003-11-20 19:40:21.570437+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1346582	2003-11-20 19:40:16+02	2003-11-20 19:40:21.96654+02	adrastea	3726	mgd[5003]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1346579	2003-11-20 19:40:16+02	2003-11-20 19:40:21.941133+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5031, status 0		1
1346601	2003-11-20 19:40:16+02	2003-11-20 19:40:22.282299+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1346578	2003-11-20 19:40:16+02	2003-11-20 19:40:21.936503+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346581	2003-11-20 19:40:16+02	2003-11-20 19:40:21.958664+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5032, status 0		1
1346535	2003-11-20 19:40:16+02	2003-11-20 19:40:20.908884+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc38da0fc/32		10
1346604	2003-11-20 19:40:16+02	2003-11-20 19:40:22.29647+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1346602	2003-11-20 19:40:16+02	2003-11-20 19:40:22.287625+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/1) ifd vptree not initialized		10
1346571	2003-11-20 19:40:16+02	2003-11-20 19:40:21.767072+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1346574	2003-11-20 19:40:16+02	2003-11-20 19:40:21.781035+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1346598	2003-11-20 19:40:16+02	2003-11-20 19:40:22.265458+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1346583	2003-11-20 19:40:16+02	2003-11-20 19:40:21.97054+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346570	2003-11-20 19:40:16+02	2003-11-20 19:40:21.761741+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1346554	2003-11-20 19:40:16+02	2003-11-20 19:40:21.345551+02	atlas	3730	mgd[2744]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2758, status 0		1
1346588	2003-11-20 19:40:16+02	2003-11-20 19:40:22.105+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b23ffc/32		10
1346560	2003-11-20 19:40:16+02	2003-11-20 19:40:21.557044+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1346573	2003-11-20 19:40:16+02	2003-11-20 19:40:21.776473+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1346558	2003-11-20 19:40:16+02	2003-11-20 19:40:21.546009+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1346540	2003-11-20 19:40:16+02	2003-11-20 19:40:21.136452+02	r201	3732	mgd[4758]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1346575	2003-11-20 19:40:16+02	2003-11-20 19:40:21.785866+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1346580	2003-11-20 19:40:16+02	2003-11-20 19:40:21.945321+02	adrastea	3726	mgd[5003]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346584	2003-11-20 19:40:16+02	2003-11-20 19:40:21.976281+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346586	2003-11-20 19:40:16+02	2003-11-20 19:40:21.985979+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b2c0fc/32		10
1346590	2003-11-20 19:40:16+02	2003-11-20 19:40:22.122497+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bac1fc/32		10
1346592	2003-11-20 19:40:16+02	2003-11-20 19:40:22.13114+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b357fc/32		10
1346596	2003-11-20 19:40:16+02	2003-11-20 19:40:22.153476+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1346599	2003-11-20 19:40:16+02	2003-11-20 19:40:22.2731+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1346603	2003-11-20 19:40:16+02	2003-11-20 19:40:22.291919+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1346559	2003-11-20 19:40:16+02	2003-11-20 19:40:21.552425+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1346577	2003-11-20 19:40:16+02	2003-11-20 19:40:21.900261+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1346605	2003-11-20 19:40:16+02	2003-11-20 19:40:22.300709+02	ganymede	3731	mgd[2856]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2870, status 0		1
1346585	2003-11-20 19:40:16+02	2003-11-20 19:40:21.981349+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b2c0fc/32		10
1346538	2003-11-20 19:40:16+02	2003-11-20 19:40:21.1237+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc38da0fc/32		10
1346594	2003-11-20 19:40:16+02	2003-11-20 19:40:22.140748+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b7d2fc/32		10
1346600	2003-11-20 19:40:16+02	2003-11-20 19:40:22.277662+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1346597	2003-11-20 19:40:16+02	2003-11-20 19:40:22.26017+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/0) ifd vptree not initialized		10
1346595	2003-11-20 19:40:16+02	2003-11-20 19:40:22.144734+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1346593	2003-11-20 19:40:16+02	2003-11-20 19:40:22.135811+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346591	2003-11-20 19:40:16+02	2003-11-20 19:40:22.126524+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346589	2003-11-20 19:40:16+02	2003-11-20 19:40:22.108901+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b23ffc/32		10
1346572	2003-11-20 19:40:16+02	2003-11-20 19:40:21.771302+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1346544	2003-11-20 19:40:16+02	2003-11-20 19:40:21.158717+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bcd6fc/32		10
1346536	2003-11-20 19:40:16+02	2003-11-20 19:40:20.918032+02	r201	3732	last		message repeated 3 times		10
1346556	2003-11-20 19:40:16+02	2003-11-20 19:40:21.423868+02	atlas	3730	mgd[2744]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1346543	2003-11-20 19:40:16+02	2003-11-20 19:40:21.153902+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355664	2003-11-21 18:45:04+02	2003-11-21 18:45:04.606789+02	ganymede	3731	mgd[3012]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1355665	2003-11-21 18:45:04+02	2003-11-21 18:45:04.610895+02	ganymede	3731	mgd[3012]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [3012]		1
1355663	2003-11-21 18:45:04+02	2003-11-21 18:45:04.598655+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1355662	2003-11-21 18:45:04+02	2003-11-21 18:45:04.591924+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1355660	2003-11-21 18:45:04+02	2003-11-21 18:45:04.476342+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1355659	2003-11-21 18:45:04+02	2003-11-21 18:45:04.460408+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1355677	2003-11-21 18:45:04+02	2003-11-21 18:45:04.816539+02	ganymede	3731	mgd[3012]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1355676	2003-11-21 18:45:04+02	2003-11-21 18:45:04.810748+02	ganymede	3731	mgd[3012]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1355661	2003-11-21 18:45:04+02	2003-11-21 18:45:04.482204+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1355678	2003-11-21 18:45:04+02	2003-11-21 18:45:04.874035+02	ganymede	3731	mgd[3012]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show isis database extensive '		1
1355679	2003-11-21 18:45:04+02	2003-11-21 18:45:05.060184+02	ganymede	3731	mgd[3012]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show ospf database extensive '		1
1355681	2003-11-21 18:45:05+02	2003-11-21 18:45:05.155447+02	ganymede	3731	mgd[3012]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1355682	2003-11-21 18:45:05+02	2003-11-21 18:45:05.264758+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[3010]:	exit status 0x100		10
1355680	2003-11-21 18:45:05+02	2003-11-21 18:45:05.147805+02	ganymede	3731	mgd[3012]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1355804	2003-11-21 18:45:12+02	2003-11-21 18:45:14.597116+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1355801	2003-11-21 18:45:12+02	2003-11-21 18:45:14.469134+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 3025, status 0		1
1355796	2003-11-21 18:45:12+02	2003-11-21 18:45:14.445484+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/proc/2243/file'		1
1355765	2003-11-21 18:45:12+02	2003-11-21 18:45:13.753802+02	adrastea	3726	mgd[5181]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1355690	2003-11-21 18:45:12+02	2003-11-21 18:45:12.310307+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1355792	2003-11-21 18:45:12+02	2003-11-21 18:45:14.413649+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/proc/2247/file'		1
1355725	2003-11-21 18:45:12+02	2003-11-21 18:45:12.942692+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1346534	2003-11-20 19:40:16+02	2003-11-20 19:40:20.898219+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346537	2003-11-20 19:40:16+02	2003-11-20 19:40:21.100137+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346541	2003-11-20 19:40:16+02	2003-11-20 19:40:21.141067+02	r201	3732	mgd[4758]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1346542	2003-11-20 19:40:16+02	2003-11-20 19:40:21.147132+02	r201	3732	inetd[4419]:	/usr/libexec/telnetd[4756]:	exit status 0x100		10
1346562	2003-11-20 19:40:16+02	2003-11-20 19:40:21.592362+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1346564	2003-11-20 19:40:16+02	2003-11-20 19:40:21.601952+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1346563	2003-11-20 19:40:16+02	2003-11-20 19:40:21.597769+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1346547	2003-11-20 19:40:16+02	2003-11-20 19:40:21.280336+02	adrastea	3726	mgd[5003]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1346568	2003-11-20 19:40:16+02	2003-11-20 19:40:21.750701+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1346548	2003-11-20 19:40:16+02	2003-11-20 19:40:21.294817+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346555	2003-11-20 19:40:16+02	2003-11-20 19:40:21.404561+02	atlas	3730	mgd[2744]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1346566	2003-11-20 19:40:16+02	2003-11-20 19:40:21.612022+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1346551	2003-11-20 19:40:16+02	2003-11-20 19:40:21.327101+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346552	2003-11-20 19:40:16+02	2003-11-20 19:40:21.331383+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346567	2003-11-20 19:40:16+02	2003-11-20 19:40:21.720343+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1346549	2003-11-20 19:40:16+02	2003-11-20 19:40:21.304494+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bb07fc/32		10
1346553	2003-11-20 19:40:16+02	2003-11-20 19:40:21.335594+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bb07fc/32		10
1346569	2003-11-20 19:40:16+02	2003-11-20 19:40:21.755016+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1346545	2003-11-20 19:40:16+02	2003-11-20 19:40:21.162669+02	adrastea	3726	last		message repeated 4 times		10
1346539	2003-11-20 19:40:16+02	2003-11-20 19:40:21.131929+02	r201	3732	mgd[4758]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4772, status 0		1
1346546	2003-11-20 19:40:16+02	2003-11-20 19:40:21.16735+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346557	2003-11-20 19:40:16+02	2003-11-20 19:40:21.54014+02	atlas	3730	inetd[2245]:	/usr/libexec/telnetd[2742]:	exit status 0x100		10
1346576	2003-11-20 19:40:16+02	2003-11-20 19:40:21.793382+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1346633	2003-11-20 19:40:17+02	2003-11-20 19:40:22.92625+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1346628	2003-11-20 19:40:17+02	2003-11-20 19:40:22.896095+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1346629	2003-11-20 19:40:17+02	2003-11-20 19:40:22.900583+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1346637	2003-11-20 19:40:17+02	2003-11-20 19:40:23.063319+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1346623	2003-11-20 19:40:17+02	2003-11-20 19:40:22.758688+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1346626	2003-11-20 19:40:17+02	2003-11-20 19:40:22.885435+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1346624	2003-11-20 19:40:17+02	2003-11-20 19:40:22.766879+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1346625	2003-11-20 19:40:17+02	2003-11-20 19:40:22.880961+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1346642	2003-11-20 19:40:17+02	2003-11-20 19:40:23.101751+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[4998]:	exit status 0x100		10
1346630	2003-11-20 19:40:17+02	2003-11-20 19:40:22.90817+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1346627	2003-11-20 19:40:17+02	2003-11-20 19:40:22.891508+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1346631	2003-11-20 19:40:17+02	2003-11-20 19:40:22.913958+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1346636	2003-11-20 19:40:17+02	2003-11-20 19:40:23.057095+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1346606	2003-11-20 19:40:17+02	2003-11-20 19:40:22.305341+02	ganymede	3731	mgd[2856]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1346620	2003-11-20 19:40:17+02	2003-11-20 19:40:22.691003+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1346609	2003-11-20 19:40:17+02	2003-11-20 19:40:22.424139+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346608	2003-11-20 19:40:17+02	2003-11-20 19:40:22.417713+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[2854]:	exit status 0x100		10
1346607	2003-11-20 19:40:17+02	2003-11-20 19:40:22.410809+02	ganymede	3731	mgd[2856]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1346632	2003-11-20 19:40:17+02	2003-11-20 19:40:22.919033+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1346610	2003-11-20 19:40:17+02	2003-11-20 19:40:22.428726+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bc35fc/32		10
1346621	2003-11-20 19:40:17+02	2003-11-20 19:40:22.696831+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1346612	2003-11-20 19:40:17+02	2003-11-20 19:40:22.443497+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346619	2003-11-20 19:40:17+02	2003-11-20 19:40:22.686673+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1346617	2003-11-20 19:40:17+02	2003-11-20 19:40:22.671683+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1346639	2003-11-20 19:40:17+02	2003-11-20 19:40:23.075527+02	adrastea	3726	mgd[5002]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1346635	2003-11-20 19:40:17+02	2003-11-20 19:40:23.050968+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1346638	2003-11-20 19:40:17+02	2003-11-20 19:40:23.069203+02	adrastea	3726	mgd[5002]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1346634	2003-11-20 19:40:17+02	2003-11-20 19:40:22.936513+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1346613	2003-11-20 19:40:17+02	2003-11-20 19:40:22.52211+02	adrastea	3726	mgd[5002]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5030, status 0		1
1333764	2003-11-20 13:53:07+02	2003-11-20 13:35:39.56542+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333766	2003-11-20 13:53:08+02	2003-11-20 13:35:40.592243+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333767	2003-11-20 13:53:08+02	2003-11-20 13:35:40.605944+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333769	2003-11-20 13:53:09+02	2003-11-20 13:35:41.56658+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333770	2003-11-20 13:53:09+02	2003-11-20 13:35:41.625489+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333771	2003-11-20 13:53:09+02	2003-11-20 13:35:41.677886+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333773	2003-11-20 13:53:10+02	2003-11-20 13:35:42.583352+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333772	2003-11-20 13:53:10+02	2003-11-20 13:35:42.566957+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333774	2003-11-20 13:53:10+02	2003-11-20 13:35:42.587115+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333777	2003-11-20 13:53:11+02	2003-11-20 13:35:43.627195+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333776	2003-11-20 13:53:11+02	2003-11-20 13:35:43.623424+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333775	2003-11-20 13:53:11+02	2003-11-20 13:35:43.567798+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333779	2003-11-20 13:53:12+02	2003-11-20 13:35:44.567688+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333780	2003-11-20 13:53:12+02	2003-11-20 13:35:44.589097+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333788	2003-11-20 13:53:13+02	2003-11-20 13:35:50.944778+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352024	2003-11-21 17:28:42+02	2003-11-21 17:11:23.051788+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352026	2003-11-21 17:28:43+02	2003-11-21 17:11:24.074114+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352025	2003-11-21 17:28:43+02	2003-11-21 17:11:24.053238+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352028	2003-11-21 17:28:44+02	2003-11-21 17:11:25.069927+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352027	2003-11-21 17:28:44+02	2003-11-21 17:11:25.053109+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352029	2003-11-21 17:28:44+02	2003-11-21 17:11:25.177606+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352032	2003-11-21 17:28:45+02	2003-11-21 17:11:26.065516+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352031	2003-11-21 17:28:45+02	2003-11-21 17:11:26.053804+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352033	2003-11-21 17:28:45+02	2003-11-21 17:11:26.071888+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352035	2003-11-21 17:28:46+02	2003-11-21 17:11:27.075742+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352036	2003-11-21 17:28:46+02	2003-11-21 17:11:27.081813+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352034	2003-11-21 17:28:46+02	2003-11-21 17:11:27.054069+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352039	2003-11-21 17:28:47+02	2003-11-21 17:11:28.259759+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352040	2003-11-21 17:28:47+02	2003-11-21 17:11:28.265007+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352052	2003-11-21 17:28:48+02	2003-11-21 17:11:33.687454+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346706	2003-11-20 19:40:18+02	2003-11-20 19:40:24.27564+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[5000]:	exit status 0x100		10
1346673	2003-11-20 19:40:18+02	2003-11-20 19:40:23.655192+02	adrastea	3726	mgd[5003]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5033, status 0		1
1346704	2003-11-20 19:40:18+02	2003-11-20 19:40:24.157367+02	adrastea	3726	mgd[5003]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1346705	2003-11-20 19:40:18+02	2003-11-20 19:40:24.270202+02	adrastea	3726	mgd[5003]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1357180	2003-11-21 19:33:49+02	2003-11-21 19:16:30.351263+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357182	2003-11-21 19:33:50+02	2003-11-21 19:16:31.343059+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357181	2003-11-21 19:33:50+02	2003-11-21 19:16:31.33314+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357185	2003-11-21 19:33:51+02	2003-11-21 19:16:36.94085+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357787	2003-11-21 19:34:35+02	2003-11-21 19:34:35.343683+02	atlas	3730	xntpd[2692]:		offset -0.000053 sec freq 78.147 ppm error 0.000044 poll 10		500
1333943	2003-11-20 13:58:08+02	2003-11-20 13:40:39.649366+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333946	2003-11-20 13:58:09+02	2003-11-20 13:40:40.658396+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333945	2003-11-20 13:58:09+02	2003-11-20 13:40:40.650025+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333948	2003-11-20 13:58:10+02	2003-11-20 13:40:41.669499+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333949	2003-11-20 13:58:10+02	2003-11-20 13:40:41.673305+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333947	2003-11-20 13:58:10+02	2003-11-20 13:40:41.650556+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333957	2003-11-20 13:58:11+02	2003-11-20 13:40:42.671728+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333956	2003-11-20 13:58:11+02	2003-11-20 13:40:42.653884+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333958	2003-11-20 13:58:11+02	2003-11-20 13:40:42.675495+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333960	2003-11-20 13:58:12+02	2003-11-20 13:40:43.652095+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333961	2003-11-20 13:58:12+02	2003-11-20 13:40:43.676751+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333962	2003-11-20 13:58:12+02	2003-11-20 13:40:43.681982+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333964	2003-11-20 13:58:13+02	2003-11-20 13:40:44.66992+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333963	2003-11-20 13:58:13+02	2003-11-20 13:40:44.651236+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1333967	2003-11-20 13:58:14+02	2003-11-20 13:40:51.074878+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334591	2003-11-20 14:00:00+02	2003-11-20 14:00:00.223723+02	r201	3732	CRON[4737]:		(root) CMD (newsyslog) 		10
1334596	2003-11-20 14:00:00+02	2003-11-20 14:00:00.526034+02	ganymede	3731	CRON[2830]:		(root) CMD (newsyslog) 		10
1334592	2003-11-20 14:00:00+02	2003-11-20 14:00:00.471236+02	adrastea	3726	CRON[4981]:		(root) CMD (newsyslog) 		10
1334598	2003-11-20 14:00:00+02	2003-11-20 14:00:00.63302+02	atlas	3730	CRON[2723]:		(root) CMD (newsyslog) 		10
1334018	2003-11-20 14:00:00+02	2003-11-20 13:42:32.236337+02	jupiter	3727	CRON[7048]:		(root) CMD (newsyslog) 		10
1305787	2003-11-19 17:22:39+02	2003-11-19 17:05:05.059788+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305789	2003-11-19 17:22:40+02	2003-11-19 17:05:06.06048+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305790	2003-11-19 17:22:40+02	2003-11-19 17:05:06.143274+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305799	2003-11-19 17:22:41+02	2003-11-19 17:05:07.142594+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305798	2003-11-19 17:22:41+02	2003-11-19 17:05:07.060877+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305800	2003-11-19 17:22:41+02	2003-11-19 17:05:07.14639+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305803	2003-11-19 17:22:42+02	2003-11-19 17:05:08.083692+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305801	2003-11-19 17:22:42+02	2003-11-19 17:05:08.065974+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305802	2003-11-19 17:22:42+02	2003-11-19 17:05:08.079891+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305812	2003-11-19 17:22:43+02	2003-11-19 17:05:09.075674+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305813	2003-11-19 17:22:43+02	2003-11-19 17:05:09.080469+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305811	2003-11-19 17:22:43+02	2003-11-19 17:05:09.061902+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305816	2003-11-19 17:22:44+02	2003-11-19 17:05:10.067671+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305815	2003-11-19 17:22:44+02	2003-11-19 17:05:10.061588+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345835	2003-11-20 19:43:14+02	2003-11-20 19:25:48.441778+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345838	2003-11-20 19:43:15+02	2003-11-20 19:25:49.568698+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345837	2003-11-20 19:43:15+02	2003-11-20 19:25:49.442437+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345842	2003-11-20 19:43:16+02	2003-11-20 19:25:50.456052+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345841	2003-11-20 19:43:16+02	2003-11-20 19:25:50.452172+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345840	2003-11-20 19:43:16+02	2003-11-20 19:25:50.443029+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345844	2003-11-20 19:43:17+02	2003-11-20 19:25:51.442697+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345846	2003-11-20 19:43:17+02	2003-11-20 19:25:51.452083+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345845	2003-11-20 19:43:17+02	2003-11-20 19:25:51.448311+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345848	2003-11-20 19:43:18+02	2003-11-20 19:25:52.58716+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345849	2003-11-20 19:43:18+02	2003-11-20 19:25:52.592501+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345847	2003-11-20 19:43:18+02	2003-11-20 19:25:52.443985+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345850	2003-11-20 19:43:19+02	2003-11-20 19:25:53.443628+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345851	2003-11-20 19:43:19+02	2003-11-20 19:25:53.453551+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1345854	2003-11-20 19:43:20+02	2003-11-20 19:26:00.071031+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1305869	2003-11-19 17:22:45+02	2003-11-19 17:05:19.249249+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309818	2003-11-19 17:23:05+02	2003-11-19 17:23:05.705293+02	adrastea	3726	xntpd[2231]:		offset -0.001030 sec freq 76.504 ppm error 0.000663 poll 10		500
1309834	2003-11-19 17:23:10+02	2003-11-19 17:23:10.533462+02	r201	3732	login:		PAM module 0 returned: [7]Authentication failure		1
1355719	2003-11-21 18:45:12+02	2003-11-21 18:45:12.80401+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/proc/2258/file'		1
1355812	2003-11-21 18:45:12+02	2003-11-21 18:45:14.816091+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 5190, status 0		1
1355698	2003-11-21 18:45:12+02	2003-11-21 18:45:12.472995+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1355772	2003-11-21 18:45:12+02	2003-11-21 18:45:13.983197+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/proc/4439/file'		1
1355800	2003-11-21 18:45:12+02	2003-11-21 18:45:14.464147+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 5186, status 0		1
1355692	2003-11-21 18:45:12+02	2003-11-21 18:45:12.434024+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1355829	2003-11-21 18:45:12+02	2003-11-21 18:45:15.398646+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 5197, status 0		1
1355805	2003-11-21 18:45:12+02	2003-11-21 18:45:14.601468+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 5187, status 0		1
1355811	2003-11-21 18:45:12+02	2003-11-21 18:45:14.636437+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1355808	2003-11-21 18:45:12+02	2003-11-21 18:45:14.620672+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 5188, status 0		1
1355685	2003-11-21 18:45:12+02	2003-11-21 18:45:12.172125+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1355758	2003-11-21 18:45:12+02	2003-11-21 18:45:13.552643+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/proc/4424/file'		1
1355809	2003-11-21 18:45:12+02	2003-11-21 18:45:14.626071+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1355817	2003-11-21 18:45:12+02	2003-11-21 18:45:15.058407+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 5192, status 0		1
1355819	2003-11-21 18:45:12+02	2003-11-21 18:45:15.070591+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 5193, status 0		1
1355810	2003-11-21 18:45:12+02	2003-11-21 18:45:14.632485+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 5189, status 0		1
1355764	2003-11-21 18:45:12+02	2003-11-21 18:45:13.747257+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/proc/4438/file'		1
1355769	2003-11-21 18:45:12+02	2003-11-21 18:45:13.800242+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/proc/2234/file'		1
1355824	2003-11-21 18:45:12+02	2003-11-21 18:45:15.209508+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 5195, status 0		1
1355816	2003-11-21 18:45:12+02	2003-11-21 18:45:15.053807+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1355760	2003-11-21 18:45:12+02	2003-11-21 18:45:13.560231+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/proc/4424/file', PID 4905, status 0		1
1355773	2003-11-21 18:45:12+02	2003-11-21 18:45:13.99157+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/proc/2234/file', PID 3019, status 0		1
1355814	2003-11-21 18:45:12+02	2003-11-21 18:45:14.878438+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 5191, status 0		1
1355756	2003-11-21 18:45:12+02	2003-11-21 18:45:13.544323+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/proc/2263/file'		1
1355770	2003-11-21 18:45:12+02	2003-11-21 18:45:13.807371+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1355828	2003-11-21 18:45:12+02	2003-11-21 18:45:15.385051+02	adrastea	3726	mgd[5181]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1355791	2003-11-21 18:45:12+02	2003-11-21 18:45:14.278711+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 3022, status 0		1
1355784	2003-11-21 18:45:12+02	2003-11-21 18:45:14.241354+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4911, status 0		1
1355697	2003-11-21 18:45:12+02	2003-11-21 18:45:12.467465+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1355807	2003-11-21 18:45:12+02	2003-11-21 18:45:14.615784+02	r201	3732	mgd[4901]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1355806	2003-11-21 18:45:12+02	2003-11-21 18:45:14.608182+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1355720	2003-11-21 18:45:12+02	2003-11-21 18:45:12.808385+02	adrastea	3726	mgd[5182]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1355786	2003-11-21 18:45:12+02	2003-11-21 18:45:14.250377+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/proc/2246/file', PID 3021, status 0		1
1355763	2003-11-21 18:45:12+02	2003-11-21 18:45:13.693207+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4906, status 0		1
1355771	2003-11-21 18:45:12+02	2003-11-21 18:45:13.819448+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/proc/4431/file', PID 4908, status 0		1
1355721	2003-11-21 18:45:12+02	2003-11-21 18:45:12.816363+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/proc/2258/file', PID 2887, status 0		1
1355795	2003-11-21 18:45:12+02	2003-11-21 18:45:14.441508+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/proc/2247/file', PID 3023, status 0		1
1355768	2003-11-21 18:45:12+02	2003-11-21 18:45:13.776442+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/proc/2224/file', PID 3018, status 0		1
1355724	2003-11-21 18:45:12+02	2003-11-21 18:45:12.936399+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/proc/2307/file', PID 2888, status 0		1
1355762	2003-11-21 18:45:12+02	2003-11-21 18:45:13.683892+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/proc/2224/file'		1
1355785	2003-11-21 18:45:12+02	2003-11-21 18:45:14.246223+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/proc/4442/file'		1
1355722	2003-11-21 18:45:12+02	2003-11-21 18:45:12.924957+02	adrastea	3726	mgd[5181]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1355815	2003-11-21 18:45:12+02	2003-11-21 18:45:15.047646+02	atlas	3730	mgd[2886]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1355793	2003-11-21 18:45:12+02	2003-11-21 18:45:14.425476+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 5185, status 0		1
1355723	2003-11-21 18:45:12+02	2003-11-21 18:45:12.932372+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/proc/2307/file'		1
1355747	2003-11-21 18:45:12+02	2003-11-21 18:45:13.379083+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/proc/4434/file'		1
1355757	2003-11-21 18:45:12+02	2003-11-21 18:45:13.548702+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/proc/4413/file', PID 4904, status 0		1
1355781	2003-11-21 18:45:12+02	2003-11-21 18:45:14.11459+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/proc/2246/file'		1
1355779	2003-11-21 18:45:12+02	2003-11-21 18:45:14.103805+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 3020, status 0		1
1355821	2003-11-21 18:45:12+02	2003-11-21 18:45:15.081583+02	ganymede	3731	mgd[3015]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1309835	2003-11-19 17:23:10+02	2003-11-19 17:23:10.545253+02	r201	3732	login:		PAM authentication chain returned: [7]Authentication failure		1
1309844	2003-11-19 17:23:12+02	2003-11-19 17:23:12.620736+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1309843	2003-11-19 17:23:12+02	2003-11-19 17:23:12.598734+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1309845	2003-11-19 17:23:12+02	2003-11-19 17:23:12.625784+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1309847	2003-11-19 17:23:12+02	2003-11-19 17:23:12.635961+02	r201	3732	login:		login from 172.26.24.241 on ttyp0 as lab		1
1309846	2003-11-19 17:23:12+02	2003-11-19 17:23:12.630836+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1309856	2003-11-19 17:23:13+02	2003-11-19 17:23:13.871206+02	r201	3732	mgd[4585]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4585]		1
1309855	2003-11-19 17:23:13+02	2003-11-19 17:23:13.865841+02	r201	3732	mgd[4585]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1309864	2003-11-19 17:23:16+02	2003-11-19 17:23:16.551835+02	r201	3732	mgd[4585]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show ldp traffic-statistics '		1
1309923	2003-11-19 17:23:18+02	2003-11-19 17:23:30.706268+02	r201	3732	last		message repeated 2 times		10
1334114	2003-11-20 14:03:08+02	2003-11-20 13:45:39.727595+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334117	2003-11-20 14:03:09+02	2003-11-20 13:45:40.739619+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334116	2003-11-20 14:03:09+02	2003-11-20 13:45:40.729367+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334120	2003-11-20 14:03:10+02	2003-11-20 13:45:41.754565+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334118	2003-11-20 14:03:10+02	2003-11-20 13:45:41.729363+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334119	2003-11-20 14:03:10+02	2003-11-20 13:45:41.750758+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334124	2003-11-20 14:03:11+02	2003-11-20 13:45:42.914791+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334123	2003-11-20 14:03:11+02	2003-11-20 13:45:42.909077+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334122	2003-11-20 14:03:11+02	2003-11-20 13:45:42.729551+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334126	2003-11-20 14:03:12+02	2003-11-20 13:45:43.74119+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334127	2003-11-20 14:03:12+02	2003-11-20 13:45:43.745021+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334125	2003-11-20 14:03:12+02	2003-11-20 13:45:43.729703+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334129	2003-11-20 14:03:13+02	2003-11-20 13:45:44.73693+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334128	2003-11-20 14:03:13+02	2003-11-20 13:45:44.725265+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334132	2003-11-20 14:03:14+02	2003-11-20 13:45:51.205693+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352721	2003-11-21 17:31:31+02	2003-11-21 17:31:32.068895+02	ganymede	3731	xntpd[2770]:		offset 0.000342 sec freq 84.879 ppm error 0.000122 poll 10		500
1346719	2003-11-20 19:57:45+02	2003-11-20 19:40:24.487167+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0xc397c8fc/32		10
1310173	2003-11-19 17:24:32+02	2003-11-19 17:24:33.154617+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1310175	2003-11-19 17:24:32+02	2003-11-19 17:24:33.162241+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1310174	2003-11-19 17:24:32+02	2003-11-19 17:24:33.158498+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1310199	2003-11-19 17:24:37+02	2003-11-19 17:24:38.002479+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1356635	2003-11-21 19:18:44+02	2003-11-21 19:01:26.125235+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356638	2003-11-21 19:18:45+02	2003-11-21 19:01:27.133469+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356637	2003-11-21 19:18:45+02	2003-11-21 19:01:27.101776+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356640	2003-11-21 19:18:46+02	2003-11-21 19:01:28.123873+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356639	2003-11-21 19:18:46+02	2003-11-21 19:01:28.102534+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356641	2003-11-21 19:18:46+02	2003-11-21 19:01:28.127788+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356643	2003-11-21 19:18:47+02	2003-11-21 19:01:29.120238+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356642	2003-11-21 19:18:47+02	2003-11-21 19:01:29.1032+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356644	2003-11-21 19:18:47+02	2003-11-21 19:01:29.124871+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356647	2003-11-21 19:18:48+02	2003-11-21 19:01:30.227215+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356646	2003-11-21 19:18:48+02	2003-11-21 19:01:30.115828+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356645	2003-11-21 19:18:48+02	2003-11-21 19:01:30.102618+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356649	2003-11-21 19:18:49+02	2003-11-21 19:01:31.111193+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356648	2003-11-21 19:18:49+02	2003-11-21 19:01:31.103237+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334283	2003-11-20 14:08:08+02	2003-11-20 13:50:39.801093+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334286	2003-11-20 14:08:09+02	2003-11-20 13:50:40.821298+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334285	2003-11-20 14:08:09+02	2003-11-20 13:50:40.802595+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334287	2003-11-20 14:08:10+02	2003-11-20 13:50:41.802378+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334288	2003-11-20 14:08:10+02	2003-11-20 13:50:41.817171+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334289	2003-11-20 14:08:10+02	2003-11-20 13:50:41.820922+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334290	2003-11-20 14:08:11+02	2003-11-20 13:50:42.804656+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334291	2003-11-20 14:08:11+02	2003-11-20 13:50:42.81313+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334292	2003-11-20 14:08:11+02	2003-11-20 13:50:42.816889+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334295	2003-11-20 14:08:12+02	2003-11-20 13:50:43.933565+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334294	2003-11-20 14:08:12+02	2003-11-20 13:50:43.823015+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334293	2003-11-20 14:08:12+02	2003-11-20 13:50:43.803542+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334297	2003-11-20 14:08:13+02	2003-11-20 13:50:44.81861+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334296	2003-11-20 14:08:13+02	2003-11-20 13:50:44.803916+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334301	2003-11-20 14:08:14+02	2003-11-20 13:50:51.336246+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346011	2003-11-20 19:48:14+02	2003-11-20 19:30:48.522828+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346012	2003-11-20 19:48:15+02	2003-11-20 19:30:49.516534+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346013	2003-11-20 19:48:15+02	2003-11-20 19:30:49.52982+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346014	2003-11-20 19:48:16+02	2003-11-20 19:30:50.516239+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310375	2003-11-19 17:25:13+02	2003-11-19 17:25:13.764524+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1310374	2003-11-19 17:25:13+02	2003-11-19 17:25:13.15923+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show '		1
1334900	2003-11-20 14:08:31+02	2003-11-20 14:08:31.821825+02	r201	3732	xntpd[4414]:		offset 0.000320 sec freq 82.630 ppm error 0.000158 poll 9		500
1352190	2003-11-21 17:33:42+02	2003-11-21 17:16:23.245236+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352192	2003-11-21 17:33:43+02	2003-11-21 17:16:24.246766+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352193	2003-11-21 17:33:43+02	2003-11-21 17:16:24.261254+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352196	2003-11-21 17:33:44+02	2003-11-21 17:16:25.266857+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352195	2003-11-21 17:33:44+02	2003-11-21 17:16:25.262826+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352194	2003-11-21 17:33:44+02	2003-11-21 17:16:25.246359+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352200	2003-11-21 17:33:45+02	2003-11-21 17:16:26.38115+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352199	2003-11-21 17:33:45+02	2003-11-21 17:16:26.363575+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352198	2003-11-21 17:33:45+02	2003-11-21 17:16:26.24734+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310509	2003-11-19 17:25:40+02	2003-11-19 17:25:44.318693+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show '		1
1346016	2003-11-20 19:48:16+02	2003-11-20 19:30:50.529279+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346015	2003-11-20 19:48:16+02	2003-11-20 19:30:50.52545+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346017	2003-11-20 19:48:17+02	2003-11-20 19:30:51.516869+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346019	2003-11-20 19:48:17+02	2003-11-20 19:30:51.539507+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346018	2003-11-20 19:48:17+02	2003-11-20 19:30:51.535714+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346022	2003-11-20 19:48:18+02	2003-11-20 19:30:52.531371+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346023	2003-11-20 19:48:18+02	2003-11-20 19:30:52.535238+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346021	2003-11-20 19:48:18+02	2003-11-20 19:30:52.516988+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346025	2003-11-20 19:48:19+02	2003-11-20 19:30:53.641154+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346024	2003-11-20 19:48:19+02	2003-11-20 19:30:53.622811+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346028	2003-11-20 19:48:20+02	2003-11-20 19:31:00.201523+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347038	2003-11-20 19:48:42+02	2003-11-20 19:48:43.535995+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1347037	2003-11-20 19:48:42+02	2003-11-20 19:48:43.532201+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1347036	2003-11-20 19:48:42+02	2003-11-20 19:48:43.125573+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1310611	2003-11-19 17:26:06+02	2003-11-19 17:26:06.585639+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'edit firewall '		1
1310620	2003-11-19 17:26:07+02	2003-11-19 17:26:07.287622+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show '		1
1355794	2003-11-21 18:45:12+02	2003-11-21 18:45:14.435981+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1355820	2003-11-21 18:45:12+02	2003-11-21 18:45:15.076672+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1355726	2003-11-21 18:45:12+02	2003-11-21 18:45:12.946531+02	ganymede	3731	mgd[3015]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1355727	2003-11-21 18:45:12+02	2003-11-21 18:45:12.950356+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 2889, status 0		1
1355799	2003-11-21 18:45:12+02	2003-11-21 18:45:14.458648+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1355802	2003-11-21 18:45:12+02	2003-11-21 18:45:14.586417+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1355830	2003-11-21 18:45:12+02	2003-11-21 18:45:15.421856+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1355787	2003-11-21 18:45:12+02	2003-11-21 18:45:14.256598+02	adrastea	3726	mgd[5182]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1355689	2003-11-21 18:45:12+02	2003-11-21 18:45:12.211583+02	atlas	3730	login:		login from 172.26.27.115 on ttyp0 as lab		1
1355739	2003-11-21 18:45:12+02	2003-11-21 18:45:13.174354+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/proc/2260/file'		1
1355688	2003-11-21 18:45:12+02	2003-11-21 18:45:12.206015+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1355777	2003-11-21 18:45:12+02	2003-11-21 18:45:14.094491+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/proc/4439/file', PID 4909, status 0		1
1355822	2003-11-21 18:45:12+02	2003-11-21 18:45:15.192708+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 5194, status 0		1
1355729	2003-11-21 18:45:12+02	2003-11-21 18:45:12.959298+02	r201	3732	mgd[4901]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1355775	2003-11-21 18:45:12+02	2003-11-21 18:45:14.077436+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1355789	2003-11-21 18:45:12+02	2003-11-21 18:45:14.268411+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1355778	2003-11-21 18:45:12+02	2003-11-21 18:45:14.099688+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/proc/4433/file'		1
1355740	2003-11-21 18:45:12+02	2003-11-21 18:45:13.178267+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/proc/2260/file', PID 2894, status 0		1
1355754	2003-11-21 18:45:12+02	2003-11-21 18:45:13.526123+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/proc/2244/file', PID 3016, status 0		1
1355797	2003-11-21 18:45:12+02	2003-11-21 18:45:14.449276+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/proc/2243/file', PID 3024, status 0		1
1355731	2003-11-21 18:45:12+02	2003-11-21 18:45:12.967402+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1355730	2003-11-21 18:45:12+02	2003-11-21 18:45:12.963333+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 2890, status 0		1
1355691	2003-11-21 18:45:12+02	2003-11-21 18:45:12.319402+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1355728	2003-11-21 18:45:12+02	2003-11-21 18:45:12.955225+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1355813	2003-11-21 18:45:12+02	2003-11-21 18:45:14.873755+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1355735	2003-11-21 18:45:12+02	2003-11-21 18:45:13.15264+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/proc/2255/file'		1
1355738	2003-11-21 18:45:12+02	2003-11-21 18:45:13.167648+02	adrastea	3726	mgd[5182]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1355734	2003-11-21 18:45:12+02	2003-11-21 18:45:13.14697+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/proc/2259/file', PID 2892, status 0		1
1355732	2003-11-21 18:45:12+02	2003-11-21 18:45:13.134178+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 2891, status 0		1
1355774	2003-11-21 18:45:12+02	2003-11-21 18:45:14.064838+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 5183, status 0		1
1355733	2003-11-21 18:45:12+02	2003-11-21 18:45:13.140328+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/proc/2259/file'		1
1355798	2003-11-21 18:45:12+02	2003-11-21 18:45:14.453335+02	atlas	3730	mgd[2886]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1355737	2003-11-21 18:45:12+02	2003-11-21 18:45:13.163861+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/proc/2255/file', PID 2893, status 0		1
1355736	2003-11-21 18:45:12+02	2003-11-21 18:45:13.156754+02	adrastea	3726	mgd[5181]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1355759	2003-11-21 18:45:12+02	2003-11-21 18:45:13.556438+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/proc/2263/file', PID 3017, status 0		1
1355790	2003-11-21 18:45:12+02	2003-11-21 18:45:14.272813+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1355782	2003-11-21 18:45:12+02	2003-11-21 18:45:14.23163+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1355780	2003-11-21 18:45:12+02	2003-11-21 18:45:14.108596+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/proc/4433/file', PID 4910, status 0		1
1355788	2003-11-21 18:45:12+02	2003-11-21 18:45:14.263587+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/proc/4442/file', PID 4912, status 0		1
1355767	2003-11-21 18:45:12+02	2003-11-21 18:45:13.76832+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/proc/4431/file'		1
1355693	2003-11-21 18:45:12+02	2003-11-21 18:45:12.441049+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1355718	2003-11-21 18:45:12+02	2003-11-21 18:45:12.798323+02	atlas	3730	mgd[2886]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1355748	2003-11-21 18:45:12+02	2003-11-21 18:45:13.38282+02	ganymede	3731	mgd[3015]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1355825	2003-11-21 18:45:12+02	2003-11-21 18:45:15.247748+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1355755	2003-11-21 18:45:12+02	2003-11-21 18:45:13.539059+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/proc/4413/file'		1
1355686	2003-11-21 18:45:12+02	2003-11-21 18:45:12.184237+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1355700	2003-11-21 18:45:12+02	2003-11-21 18:45:12.484803+02	r201	3732	login:		login from 172.26.27.115 on ttyp0 as lab		1
1355803	2003-11-21 18:45:12+02	2003-11-21 18:45:14.592397+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 3026, status 0		1
1355701	2003-11-21 18:45:12+02	2003-11-21 18:45:12.490287+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1355823	2003-11-21 18:45:12+02	2003-11-21 18:45:15.199719+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1335054	2003-11-20 14:12:34+02	2003-11-20 14:12:34.527975+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1335055	2003-11-20 14:12:34+02	2003-11-20 14:12:34.64329+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1335056	2003-11-20 14:12:34+02	2003-11-20 14:12:34.64891+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1334454	2003-11-20 14:13:08+02	2003-11-20 13:55:39.880247+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334455	2003-11-20 14:13:09+02	2003-11-20 13:55:40.880875+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334456	2003-11-20 14:13:09+02	2003-11-20 13:55:40.888963+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334459	2003-11-20 14:13:10+02	2003-11-20 13:55:42.011273+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334458	2003-11-20 14:13:10+02	2003-11-20 13:55:41.900311+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334457	2003-11-20 14:13:10+02	2003-11-20 13:55:41.88135+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334462	2003-11-20 14:13:11+02	2003-11-20 13:55:42.91783+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334460	2003-11-20 14:13:11+02	2003-11-20 13:55:42.881386+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334461	2003-11-20 14:13:11+02	2003-11-20 13:55:42.913801+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334463	2003-11-20 14:13:12+02	2003-11-20 13:55:43.882309+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334464	2003-11-20 14:13:12+02	2003-11-20 13:55:43.890524+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310673	2003-11-19 17:26:20+02	2003-11-19 17:26:20.277432+02	ganymede	3731	mgd[10563]:	UI_CFG_AUDIT_SET:	User 'lab' set: [firewall family mpls filter josef term all then count] <unconfigured> -> "josef"		1
1310672	2003-11-19 17:26:20+02	2003-11-19 17:26:20.154075+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set family mpls filter josef term all then count josef '		1
1310682	2003-11-19 17:26:21+02	2003-11-19 17:26:21.644878+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'top '		1
1310692	2003-11-19 17:26:23+02	2003-11-19 17:26:23.701328+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'edit interfaces ge-1/3/0 '		1
1310694	2003-11-19 17:26:24+02	2003-11-19 17:26:24.275687+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show '		1
1310736	2003-11-19 17:26:34+02	2003-11-19 17:26:34.408008+02	ganymede	3731	mgd[10563]:	UI_CFG_AUDIT_SET:	User 'lab' set: [interfaces ge-1/3/0 unit 0 family mpls filter input] <unconfigured> -> "josef"		1
1310735	2003-11-19 17:26:34+02	2003-11-19 17:26:34.353768+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set unit 0 family mpls filter input josef '		1
1310757	2003-11-19 17:26:38+02	2003-11-19 17:26:38.18307+02	ganymede	3731	mgd[10563]:	UI_CFG_AUDIT_SET:	User 'lab' set: [interfaces ge-1/3/0 unit 0 family mpls filter output] <unconfigured> -> "josef"		1
1310756	2003-11-19 17:26:38+02	2003-11-19 17:26:38.17768+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set unit 0 family mpls filter output josef '		1
1334465	2003-11-20 14:13:12+02	2003-11-20 13:55:43.89435+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334467	2003-11-20 14:13:13+02	2003-11-20 13:55:44.882137+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334468	2003-11-20 14:13:13+02	2003-11-20 13:55:44.900705+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334470	2003-11-20 14:13:14+02	2003-11-20 13:55:51.466572+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1358166	2003-11-21 19:45:17+02	2003-11-21 19:45:17.832812+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1310766	2003-11-19 17:26:39+02	2003-11-19 17:26:40.039237+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'top '		1
1310787	2003-11-19 17:26:44+02	2003-11-19 17:26:45.101099+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: exporting juniper.conf		1
1310786	2003-11-19 17:26:44+02	2003-11-19 17:26:45.094754+02	ganymede	3731	mgd[10563]:	UI_COMMIT:	User 'lab' performed commit		100
1310785	2003-11-19 17:26:44+02	2003-11-19 17:26:45.080223+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'commit '		1
1310783	2003-11-19 17:26:44+02	2003-11-19 17:26:44.483137+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set firewall family mpls filter josef interface-specific '		1
1310784	2003-11-19 17:26:44+02	2003-11-19 17:26:44.499529+02	ganymede	3731	mgd[10563]:	UI_CFG_AUDIT_SET:	User 'lab' set: [firewall family mpls filter josef] <unconfigured> -> "interface-specific"		1
1310807	2003-11-19 17:26:45+02	2003-11-19 17:26:45.607557+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/rpd'		1
1310809	2003-11-19 17:26:45+02	2003-11-19 17:26:45.776958+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/mib2d'		1
1310801	2003-11-19 17:26:45+02	2003-11-19 17:26:45.457223+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: dropping unchanged foreign files		1
1310805	2003-11-19 17:26:45+02	2003-11-19 17:26:45.58152+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/sbin/dcd'		1
1310789	2003-11-19 17:26:45+02	2003-11-19 17:26:45.168767+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: propagating foreign files		1
1310790	2003-11-19 17:26:45+02	2003-11-19 17:26:45.217386+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: complete foreign files		1
1310791	2003-11-19 17:26:45+02	2003-11-19 17:26:45.257674+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: copying configuration to juniper.data+		1
1310806	2003-11-19 17:26:45+02	2003-11-19 17:26:45.603218+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/sbin/dcd', PID 10818, status 0		1
1310808	2003-11-19 17:26:45+02	2003-11-19 17:26:45.738977+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/rpd', PID 10819, status 0		1
1310810	2003-11-19 17:26:45+02	2003-11-19 17:26:45.826464+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/mib2d', PID 10820, status 0		1
1310815	2003-11-19 17:26:45+02	2003-11-19 17:26:46.031412+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/pfed'		1
1310812	2003-11-19 17:26:45+02	2003-11-19 17:26:45.937895+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/apsd', PID 10821, status 0		1
1310811	2003-11-19 17:26:45+02	2003-11-19 17:26:45.832228+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/apsd'		1
1310814	2003-11-19 17:26:45+02	2003-11-19 17:26:46.025549+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/vrrpd', PID 10822, status 0		1
1310813	2003-11-19 17:26:45+02	2003-11-19 17:26:45.943438+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/vrrpd'		1
1310804	2003-11-19 17:26:45+02	2003-11-19 17:26:45.577417+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwd', PID 10816, status 0		1
1310788	2003-11-19 17:26:45+02	2003-11-19 17:26:45.137126+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: setup foreign files		1
1310803	2003-11-19 17:26:45+02	2003-11-19 17:26:45.573394+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwd'		1
1310802	2003-11-19 17:26:45+02	2003-11-19 17:26:45.567801+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: daemons checking new configuration		1
1310842	2003-11-19 17:26:46+02	2003-11-19 17:26:46.947778+02	ganymede	3731	init:		ntp (PID 10732) exit on SIGHUP, will be restarted to get the new config		10
1310841	2003-11-19 17:26:46+02	2003-11-19 17:26:46.841521+02	ganymede	3731	mgd[10828]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1310839	2003-11-19 17:26:46+02	2003-11-19 17:26:46.831236+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'MIB2 daemon', pid 4512, signal 1, status 0		1
1310832	2003-11-19 17:26:46+02	2003-11-19 17:26:46.739801+02	ganymede	3731	mgd[10828]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [10828]		1
1310840	2003-11-19 17:26:46+02	2003-11-19 17:26:46.837684+02	ganymede	3731	mgd[10828]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1310834	2003-11-19 17:26:46+02	2003-11-19 17:26:46.749062+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: notifying daemons of new configuration		1
1310817	2003-11-19 17:26:46+02	2003-11-19 17:26:46.152476+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/kmd'		1
1310843	2003-11-19 17:26:46+02	2003-11-19 17:26:46.953036+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1310830	2003-11-19 17:26:46+02	2003-11-19 17:26:46.588261+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: activating '/var/db/juniper.data'		1
1310827	2003-11-19 17:26:46+02	2003-11-19 17:26:46.493236+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: commit wrapup...		1
1310833	2003-11-19 17:26:46+02	2003-11-19 17:26:46.745252+02	ganymede	3731	mgd[10828]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1310838	2003-11-19 17:26:46+02	2003-11-19 17:26:46.824892+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'Routing protocol daemon', pid 4513, signal 1, status 0		1
1310829	2003-11-19 17:26:46+02	2003-11-19 17:26:46.503167+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: activating '/var/etc/kmd.conf'		1
1310825	2003-11-19 17:26:46+02	2003-11-19 17:26:46.484297+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp3 as lab		1
1310831	2003-11-19 17:26:46+02	2003-11-19 17:26:46.608972+02	ganymede	3731	mgd[10828]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1310824	2003-11-19 17:26:46+02	2003-11-19 17:26:46.479202+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1310823	2003-11-19 17:26:46+02	2003-11-19 17:26:46.474175+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1310816	2003-11-19 17:26:46+02	2003-11-19 17:26:46.14278+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/pfed', PID 10823, status 0		1
1310828	2003-11-19 17:26:46+02	2003-11-19 17:26:46.499142+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: activating '/var/etc/ntp.conf'		1
1310826	2003-11-19 17:26:46+02	2003-11-19 17:26:46.489301+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/fud', PID 10827, status 0		1
1310835	2003-11-19 17:26:46+02	2003-11-19 17:26:46.752793+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'Firewall daemon', pid 4522, signal 1, status 0		1
1310844	2003-11-19 17:26:46+02	2003-11-19 17:26:47.095805+02	ganymede	3731	init:		ntp (PID 10832) started		10
1310820	2003-11-19 17:26:46+02	2003-11-19 17:26:46.262284+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/fud'		1
1310845	2003-11-19 17:26:46+02	2003-11-19 17:26:47.105237+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/proc/4522/file'		1
1310822	2003-11-19 17:26:46+02	2003-11-19 17:26:46.467812+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1310837	2003-11-19 17:26:46+02	2003-11-19 17:26:46.820118+02	ganymede	3731	rpd[4513]:	RPD_TASK_REINIT:	Reinitializing		10
1310836	2003-11-19 17:26:46+02	2003-11-19 17:26:46.814467+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'Interface daemon', pid 4523, signal 1, status 0		1
1310819	2003-11-19 17:26:46+02	2003-11-19 17:26:46.256292+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/kmd', PID 10826, status 0		1
1310821	2003-11-19 17:26:46+02	2003-11-19 17:26:46.356734+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1310852	2003-11-19 17:26:47+02	2003-11-19 17:26:47.307745+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/proc/4516/file'		1
1310847	2003-11-19 17:26:47+02	2003-11-19 17:26:47.152489+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/proc/4522/file', PID 10833, status 0		1
1310846	2003-11-19 17:26:47+02	2003-11-19 17:26:47.146829+02	ganymede	3731	rpd[4513]:		task_reconfigure reinitializing done		10
1310853	2003-11-19 17:26:47+02	2003-11-19 17:26:47.321954+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/proc/4516/file', PID 10836, status 0		1
1310854	2003-11-19 17:26:47+02	2003-11-19 17:26:47.325721+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1310863	2003-11-19 17:26:47+02	2003-11-19 17:26:47.47298+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 10837, status 0		1
1310864	2003-11-19 17:26:47+02	2003-11-19 17:26:47.476704+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/proc/4425/file'		1
1310875	2003-11-19 17:26:47+02	2003-11-19 17:26:47.884652+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/proc/4426/file', PID 10840, status 0		1
1310874	2003-11-19 17:26:47+02	2003-11-19 17:26:47.880875+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/proc/4426/file'		1
1310873	2003-11-19 17:26:47+02	2003-11-19 17:26:47.876244+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/proc/4520/file', PID 10839, status 0		1
1310851	2003-11-19 17:26:47+02	2003-11-19 17:26:47.194041+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/proc/4399/file', PID 10835, status 0		1
1310850	2003-11-19 17:26:47+02	2003-11-19 17:26:47.181068+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/proc/4399/file'		1
1310872	2003-11-19 17:26:47+02	2003-11-19 17:26:47.870687+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/proc/4520/file'		1
1310870	2003-11-19 17:26:47+02	2003-11-19 17:26:47.675278+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'IPSec Key Management daemon', pid 4519, signal 1, status 0		1
1310867	2003-11-19 17:26:47+02	2003-11-19 17:26:47.488086+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'Sonet APS daemon', pid 4514, signal 1, status 0		1
1310866	2003-11-19 17:26:47+02	2003-11-19 17:26:47.484312+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'NTP daemon', pid 10732, signal 1, status 0		1
1310865	2003-11-19 17:26:47+02	2003-11-19 17:26:47.480586+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/proc/4425/file', PID 10838, status 0		1
1310869	2003-11-19 17:26:47+02	2003-11-19 17:26:47.594421+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'PFE daemon', pid 4405, signal 1, status 0		1
1310871	2003-11-19 17:26:47+02	2003-11-19 17:26:47.761199+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'Forwarding UDP daemon', pid 4408, signal 1, status 0		1
1310868	2003-11-19 17:26:47+02	2003-11-19 17:26:47.515582+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'VRRP daemon', pid 4515, signal 1, status 0		1
1310878	2003-11-19 17:26:47+02	2003-11-19 17:26:47.89655+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1310879	2003-11-19 17:26:47+02	2003-11-19 17:26:47.900846+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 10842, status 0		1
1310876	2003-11-19 17:26:47+02	2003-11-19 17:26:47.888877+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/proc/4409/file'		1
1310877	2003-11-19 17:26:47+02	2003-11-19 17:26:47.892597+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/proc/4409/file', PID 10841, status 0		1
1310849	2003-11-19 17:26:47+02	2003-11-19 17:26:47.163985+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/proc/4523/file', PID 10834, status 0		1
1310848	2003-11-19 17:26:47+02	2003-11-19 17:26:47.156267+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/proc/4523/file'		1
1310880	2003-11-19 17:26:47+02	2003-11-19 17:26:47.904703+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/proc/4429/file'		1
1310882	2003-11-19 17:26:47+02	2003-11-19 17:26:48.020781+02	ganymede	3731	mgd[10828]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1310881	2003-11-19 17:26:47+02	2003-11-19 17:26:47.908446+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/proc/4429/file', PID 10844, status 0		1
1310883	2003-11-19 17:26:47+02	2003-11-19 17:26:48.028393+02	ganymede	3731	mgd[10563]:	UI_COMMIT_PROGRESS:	commit: signaling 'SNMP daemon', pid 4402, signal 31, status 0		1
1310890	2003-11-19 17:26:48+02	2003-11-19 17:26:48.944835+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1310889	2003-11-19 17:26:48+02	2003-11-19 17:26:48.940524+02	ganymede	3731	mgd[10828]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1310888	2003-11-19 17:26:48+02	2003-11-19 17:26:48.936605+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10846, status 0		1
1310887	2003-11-19 17:26:48+02	2003-11-19 17:26:48.932829+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1310886	2003-11-19 17:26:48+02	2003-11-19 17:26:48.883084+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10845, status 0		1
1310885	2003-11-19 17:26:48+02	2003-11-19 17:26:48.862151+02	ganymede	3731	mgd[10828]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1310884	2003-11-19 17:26:48+02	2003-11-19 17:26:48.441797+02	ganymede	3731	mgd[10828]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1310919	2003-11-19 17:26:49+02	2003-11-19 17:26:50.157286+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10848, status 0		1
1310915	2003-11-19 17:26:49+02	2003-11-19 17:26:50.120687+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1310912	2003-11-19 17:26:49+02	2003-11-19 17:26:50.107779+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1310917	2003-11-19 17:26:49+02	2003-11-19 17:26:50.129653+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1310911	2003-11-19 17:26:49+02	2003-11-19 17:26:49.995541+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1310901	2003-11-19 17:26:49+02	2003-11-19 17:26:49.802261+02	ganymede	3731	last		message repeated 5 times		10
1310909	2003-11-19 17:26:49+02	2003-11-19 17:26:49.987025+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1310918	2003-11-19 17:26:49+02	2003-11-19 17:26:50.133387+02	ganymede	3731	mgd[10828]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 10847, status 0		1
1310916	2003-11-19 17:26:49+02	2003-11-19 17:26:50.124418+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1310908	2003-11-19 17:26:49+02	2003-11-19 17:26:49.940044+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/0) ifd vptree not initialized		10
1310907	2003-11-19 17:26:49+02	2003-11-19 17:26:49.928995+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1310910	2003-11-19 17:26:49+02	2003-11-19 17:26:49.991785+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1310906	2003-11-19 17:26:49+02	2003-11-19 17:26:49.925268+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1310905	2003-11-19 17:26:49+02	2003-11-19 17:26:49.921545+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bef0fc/32		10
1310902	2003-11-19 17:26:49+02	2003-11-19 17:26:49.907766+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1310899	2003-11-19 17:26:49+02	2003-11-19 17:26:49.768518+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1310914	2003-11-19 17:26:49+02	2003-11-19 17:26:50.116918+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1310903	2003-11-19 17:26:49+02	2003-11-19 17:26:49.913621+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bef0fc/32		10
1310913	2003-11-19 17:26:49+02	2003-11-19 17:26:50.113105+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/1) ifd vptree not initialized		10
1310900	2003-11-19 17:26:49+02	2003-11-19 17:26:49.79849+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bef0fc/32		10
1310904	2003-11-19 17:26:49+02	2003-11-19 17:26:49.917713+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1310921	2003-11-19 17:26:50+02	2003-11-19 17:26:50.193828+02	ganymede	3731	mgd[10828]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1310922	2003-11-19 17:26:50+02	2003-11-19 17:26:50.344679+02	ganymede	3731	inetd[4403]:	/usr/libexec/telnetd[10824]:	exit status 0x100		10
1310920	2003-11-19 17:26:50+02	2003-11-19 17:26:50.17646+02	ganymede	3731	mgd[10828]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1310924	2003-11-19 17:26:50+02	2003-11-19 17:26:51.098058+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1310925	2003-11-19 17:26:50+02	2003-11-19 17:26:51.10605+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1310934	2003-11-19 17:26:51+02	2003-11-19 17:26:51.368999+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10849, status 0		1
1310936	2003-11-19 17:26:51+02	2003-11-19 17:26:52.095054+02	ganymede	3731	xntpd[10832]:		kern_enable is 1		1
1310939	2003-11-19 17:26:51+02	2003-11-19 17:26:52.106459+02	ganymede	3731	xntpd[10832]:		using kernel phase-lock loop 2041		1
1310937	2003-11-19 17:26:51+02	2003-11-19 17:26:52.098889+02	ganymede	3731	xntpd[10832]:		using kernel phase-lock loop 2001		1
1310938	2003-11-19 17:26:51+02	2003-11-19 17:26:52.102741+02	ganymede	3731	xntpd[10832]:		frequency initialized 84.242 from /var/db/ntp.drift		1
1310935	2003-11-19 17:26:51+02	2003-11-19 17:26:52.080798+02	ganymede	3731	xntpd[10832]:		ntpd 4.0.99b Thu Oct  9 20:39:08 GMT 2003 (1)		1
1310942	2003-11-19 17:26:52+02	2003-11-19 17:26:52.759703+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10850, status 0		1
1310940	2003-11-19 17:26:52+02	2003-11-19 17:26:52.542174+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1310941	2003-11-19 17:26:52+02	2003-11-19 17:26:52.563189+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1310950	2003-11-19 17:26:54+02	2003-11-19 17:26:54.432344+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1310951	2003-11-19 17:26:54+02	2003-11-19 17:26:54.441254+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1310953	2003-11-19 17:26:54+02	2003-11-19 17:26:54.64739+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10851, status 0		1
1310963	2003-11-19 17:26:55+02	2003-11-19 17:26:55.50007+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1352202	2003-11-21 17:33:46+02	2003-11-21 17:16:27.267577+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352201	2003-11-21 17:33:46+02	2003-11-21 17:16:27.247435+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352203	2003-11-21 17:33:46+02	2003-11-21 17:16:27.271393+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352205	2003-11-21 17:33:47+02	2003-11-21 17:16:28.247915+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352206	2003-11-21 17:33:47+02	2003-11-21 17:16:28.263184+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352208	2003-11-21 17:33:48+02	2003-11-21 17:16:33.818279+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352814	2003-11-21 17:34:35+02	2003-11-21 17:34:35.320394+02	atlas	3730	xntpd[2692]:		offset -0.000061 sec freq 78.148 ppm error 0.000096 poll 10		500
1310962	2003-11-19 17:26:55+02	2003-11-19 17:26:55.494188+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1310964	2003-11-19 17:26:55+02	2003-11-19 17:26:55.707363+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10852, status 0		1
1310966	2003-11-19 17:26:56+02	2003-11-19 17:26:56.56064+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1310967	2003-11-19 17:26:56+02	2003-11-19 17:26:56.757644+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10853, status 0		1
1310965	2003-11-19 17:26:56+02	2003-11-19 17:26:56.545794+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1310978	2003-11-19 17:26:57+02	2003-11-19 17:26:57.737951+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10854, status 0		1
1310976	2003-11-19 17:26:57+02	2003-11-19 17:26:57.527288+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1310977	2003-11-19 17:26:57+02	2003-11-19 17:26:57.532925+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1310981	2003-11-19 17:26:58+02	2003-11-19 17:26:58.69787+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10855, status 0		1
1310980	2003-11-19 17:26:58+02	2003-11-19 17:26:58.495693+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1310979	2003-11-19 17:26:58+02	2003-11-19 17:26:58.481543+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1310992	2003-11-19 17:26:59+02	2003-11-19 17:26:59.649771+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10856, status 0		1
1310990	2003-11-19 17:26:59+02	2003-11-19 17:26:59.43088+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1310991	2003-11-19 17:26:59+02	2003-11-19 17:26:59.436515+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1310994	2003-11-19 17:27:00+02	2003-11-19 17:27:00.332111+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1310993	2003-11-19 17:27:00+02	2003-11-19 17:27:00.320056+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1310995	2003-11-19 17:27:00+02	2003-11-19 17:27:00.528466+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10857, status 0		1
1311002	2003-11-19 17:27:01+02	2003-11-19 17:27:01.2133+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1311003	2003-11-19 17:27:01+02	2003-11-19 17:27:01.217097+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1334627	2003-11-20 14:18:03+02	2003-11-20 14:00:35.576437+02	jupiter	3727	chassisd[4445]:	CHASSISD_SNMP_TRAP6:	SNMP trap: Power Supply failed: jnxContentsContainerIndex 2, jnxContentsL1Index 2, jnxContentsL2Index 0, jnxContentsL3Index 0, jnxContentsDescr PEM 1, jnxOperatingState/Temp 6 		100
1334634	2003-11-20 14:18:08+02	2003-11-20 14:00:39.958303+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334636	2003-11-20 14:18:09+02	2003-11-20 14:00:40.974306+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334635	2003-11-20 14:18:09+02	2003-11-20 14:00:40.954891+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334638	2003-11-20 14:18:10+02	2003-11-20 14:00:41.954765+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334639	2003-11-20 14:18:10+02	2003-11-20 14:00:42.063533+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334640	2003-11-20 14:18:10+02	2003-11-20 14:00:42.069261+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334641	2003-11-20 14:18:11+02	2003-11-20 14:00:42.955355+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334642	2003-11-20 14:18:11+02	2003-11-20 14:00:42.97706+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334643	2003-11-20 14:18:11+02	2003-11-20 14:00:42.980886+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334644	2003-11-20 14:18:12+02	2003-11-20 14:00:43.955544+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334646	2003-11-20 14:18:12+02	2003-11-20 14:00:43.978693+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334645	2003-11-20 14:18:12+02	2003-11-20 14:00:43.974705+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334647	2003-11-20 14:18:13+02	2003-11-20 14:00:44.955924+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334648	2003-11-20 14:18:13+02	2003-11-20 14:00:44.968404+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334651	2003-11-20 14:18:14+02	2003-11-20 14:00:51.596737+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311012	2003-11-19 17:27:01+02	2003-11-19 17:27:01.393428+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10858, status 0		1
1311017	2003-11-19 17:27:01+02	2003-11-19 17:27:02.075316+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1311018	2003-11-19 17:27:01+02	2003-11-19 17:27:02.082386+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1311024	2003-11-19 17:27:02+02	2003-11-19 17:27:03.033095+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1311019	2003-11-19 17:27:02+02	2003-11-19 17:27:02.288689+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10859, status 0		1
1311025	2003-11-19 17:27:02+02	2003-11-19 17:27:03.082428+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1311026	2003-11-19 17:27:03+02	2003-11-19 17:27:03.198176+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10860, status 0		1
1311043	2003-11-19 17:27:04+02	2003-11-19 17:27:04.498415+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10861, status 0		1
1311042	2003-11-19 17:27:04+02	2003-11-19 17:27:04.299503+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1311041	2003-11-19 17:27:04+02	2003-11-19 17:27:04.290067+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1311054	2003-11-19 17:27:05+02	2003-11-19 17:27:05.431013+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10862, status 0		1
1311045	2003-11-19 17:27:05+02	2003-11-19 17:27:05.153227+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1311044	2003-11-19 17:27:05+02	2003-11-19 17:27:05.1445+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1311107	2003-11-19 17:27:16+02	2003-11-19 17:27:16.529417+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show l2vpn connections extensive '		1
1311141	2003-11-19 17:27:23+02	2003-11-19 17:27:23.462001+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show chassis hardware '		1
1355783	2003-11-21 18:45:12+02	2003-11-21 18:45:14.235745+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 5184, status 0		1
1355826	2003-11-21 18:45:12+02	2003-11-21 18:45:15.283056+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 5196, status 0		1
1355699	2003-11-21 18:45:12+02	2003-11-21 18:45:12.47842+02	atlas	3730	mgd[2886]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1355818	2003-11-21 18:45:12+02	2003-11-21 18:45:15.063096+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1355761	2003-11-21 18:45:12+02	2003-11-21 18:45:13.564973+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1355696	2003-11-21 18:45:12+02	2003-11-21 18:45:12.458491+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1355687	2003-11-21 18:45:12+02	2003-11-21 18:45:12.193858+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1355695	2003-11-21 18:45:12+02	2003-11-21 18:45:12.453384+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1355751	2003-11-21 18:45:12+02	2003-11-21 18:45:13.399359+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/proc/2268/file', PID 2897, status 0		1
1355711	2003-11-21 18:45:12+02	2003-11-21 18:45:12.657664+02	ganymede	3731	mgd[3015]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [3015]		1
1355750	2003-11-21 18:45:12+02	2003-11-21 18:45:13.395549+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/proc/4453/file'		1
1355753	2003-11-21 18:45:12+02	2003-11-21 18:45:13.520604+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/proc/4453/file', PID 4903, status 0		1
1355776	2003-11-21 18:45:12+02	2003-11-21 18:45:14.08922+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1355702	2003-11-21 18:45:12+02	2003-11-21 18:45:12.601701+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp1		1
1355742	2003-11-21 18:45:12+02	2003-11-21 18:45:13.29408+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/proc/2257/file', PID 2895, status 0		1
1355703	2003-11-21 18:45:12+02	2003-11-21 18:45:12.61608+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp0 as lab		1
1355706	2003-11-21 18:45:12+02	2003-11-21 18:45:12.634809+02	atlas	3730	mgd[2886]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1355707	2003-11-21 18:45:12+02	2003-11-21 18:45:12.638852+02	r201	3732	mgd[4901]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1355827	2003-11-21 18:45:12+02	2003-11-21 18:45:15.304713+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1355704	2003-11-21 18:45:12+02	2003-11-21 18:45:12.622113+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp1 as lab		1
1355705	2003-11-21 18:45:12+02	2003-11-21 18:45:12.62732+02	atlas	3730	mgd[2886]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2886]		1
1355717	2003-11-21 18:45:12+02	2003-11-21 18:45:12.787547+02	adrastea	3726	mgd[5182]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [5182]		1
1355708	2003-11-21 18:45:12+02	2003-11-21 18:45:12.645553+02	r201	3732	mgd[4901]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4901]		1
1355710	2003-11-21 18:45:12+02	2003-11-21 18:45:12.653928+02	atlas	3730	mgd[2886]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1355766	2003-11-21 18:45:12+02	2003-11-21 18:45:13.762231+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/proc/4438/file', PID 4907, status 0		1
1355741	2003-11-21 18:45:12+02	2003-11-21 18:45:13.182922+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/proc/2257/file'		1
1355709	2003-11-21 18:45:12+02	2003-11-21 18:45:12.649628+02	ganymede	3731	mgd[3015]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1355752	2003-11-21 18:45:12+02	2003-11-21 18:45:13.511741+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/proc/2244/file'		1
1355712	2003-11-21 18:45:12+02	2003-11-21 18:45:12.761585+02	r201	3732	mgd[4901]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1355745	2003-11-21 18:45:12+02	2003-11-21 18:45:13.309258+02	r201	3732	mgd[4901]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1355716	2003-11-21 18:45:12+02	2003-11-21 18:45:12.779703+02	adrastea	3726	mgd[5182]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1355746	2003-11-21 18:45:12+02	2003-11-21 18:45:13.37531+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/proc/2268/file'		1
1355744	2003-11-21 18:45:12+02	2003-11-21 18:45:13.304976+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 2896, status 0		1
1355715	2003-11-21 18:45:12+02	2003-11-21 18:45:12.7756+02	adrastea	3726	mgd[5181]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [5181]		1
1355694	2003-11-21 18:45:12+02	2003-11-21 18:45:12.446764+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1355743	2003-11-21 18:45:12+02	2003-11-21 18:45:13.300099+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1355713	2003-11-21 18:45:12+02	2003-11-21 18:45:12.76752+02	ganymede	3731	mgd[3015]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1355714	2003-11-21 18:45:12+02	2003-11-21 18:45:12.771477+02	adrastea	3726	mgd[5181]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1355749	2003-11-21 18:45:12+02	2003-11-21 18:45:13.390809+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/proc/4434/file', PID 4902, status 0		1
1355877	2003-11-21 18:45:13+02	2003-11-21 18:45:16.390335+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4915, status 0		1
1355894	2003-11-21 18:45:13+02	2003-11-21 18:45:16.876783+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1355832	2003-11-21 18:45:13+02	2003-11-21 18:45:15.531717+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 5198, status 0		1
1355843	2003-11-21 18:45:13+02	2003-11-21 18:45:15.814927+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 5202, status 0		1
1355873	2003-11-21 18:45:13+02	2003-11-21 18:45:16.366377+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc395d5fc/32		10
1355902	2003-11-21 18:45:13+02	2003-11-21 18:45:17.073859+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 5205, status 0		1
1355857	2003-11-21 18:45:13+02	2003-11-21 18:45:16.067461+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355917	2003-11-21 18:45:13+02	2003-11-21 18:45:17.263671+02	atlas	3730	mgd[2886]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1355831	2003-11-21 18:45:13+02	2003-11-21 18:45:15.426359+02	ganymede	3731	mgd[3015]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1355833	2003-11-21 18:45:13+02	2003-11-21 18:45:15.562536+02	adrastea	3726	mgd[5181]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1355859	2003-11-21 18:45:13+02	2003-11-21 18:45:16.078405+02	r201	3732	mgd[4901]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1306628	2003-11-19 17:27:40+02	2003-11-19 17:10:05.198111+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306629	2003-11-19 17:27:41+02	2003-11-19 17:10:06.193779+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306630	2003-11-19 17:27:41+02	2003-11-19 17:10:06.207916+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306632	2003-11-19 17:27:42+02	2003-11-19 17:10:07.196589+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306634	2003-11-19 17:27:42+02	2003-11-19 17:10:07.221709+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306633	2003-11-19 17:27:42+02	2003-11-19 17:10:07.217912+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306635	2003-11-19 17:27:43+02	2003-11-19 17:10:08.19436+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306636	2003-11-19 17:27:43+02	2003-11-19 17:10:08.213681+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306637	2003-11-19 17:27:43+02	2003-11-19 17:10:08.217515+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306642	2003-11-19 17:27:44+02	2003-11-19 17:10:09.312759+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306640	2003-11-19 17:27:44+02	2003-11-19 17:10:09.200187+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306641	2003-11-19 17:27:44+02	2003-11-19 17:10:09.204019+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306646	2003-11-19 17:27:45+02	2003-11-19 17:10:10.195054+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346190	2003-11-20 19:53:14+02	2003-11-20 19:35:48.593367+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346192	2003-11-20 19:53:15+02	2003-11-20 19:35:49.602889+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346191	2003-11-20 19:53:15+02	2003-11-20 19:35:49.595127+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346194	2003-11-20 19:53:16+02	2003-11-20 19:35:50.612822+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346195	2003-11-20 19:53:16+02	2003-11-20 19:35:50.616711+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346193	2003-11-20 19:53:16+02	2003-11-20 19:35:50.594732+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346197	2003-11-20 19:53:17+02	2003-11-20 19:35:51.622755+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346196	2003-11-20 19:53:17+02	2003-11-20 19:35:51.609938+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346198	2003-11-20 19:53:17+02	2003-11-20 19:35:51.676983+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346201	2003-11-20 19:53:18+02	2003-11-20 19:35:52.623612+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346200	2003-11-20 19:53:18+02	2003-11-20 19:35:52.619797+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346199	2003-11-20 19:53:18+02	2003-11-20 19:35:52.597711+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346205	2003-11-20 19:53:19+02	2003-11-20 19:35:53.655552+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346204	2003-11-20 19:53:19+02	2003-11-20 19:35:53.651639+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346212	2003-11-20 19:53:20+02	2003-11-20 19:36:00.331537+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306647	2003-11-19 17:27:45+02	2003-11-19 17:10:10.2054+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1306778	2003-11-19 17:27:46+02	2003-11-19 17:10:19.379402+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311297	2003-11-19 17:27:57+02	2003-11-19 17:27:57.88698+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run request chassis pic pic-slot 2 offline fpc-slot 0 '		1
1311298	2003-11-19 17:27:57+02	2003-11-19 17:27:57.926786+02	ganymede	3731	chassisd[4397]:	CHASSISD_TRACE_PIC_OFFLINE:	Taking PIC offline -- FPC slot 0, PIC slot 2 reason Offlined by cli command 		10
1311299	2003-11-19 17:27:57+02	2003-11-19 17:27:57.931113+02	ganymede	3731	feb	CMFPC:	Offline CMD request for PIC 0/2 		10
1311315	2003-11-19 17:27:58+02	2003-11-19 17:27:58.393346+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(70) family 2		10
1311343	2003-11-19 17:27:58+02	2003-11-19 17:27:58.881735+02	ganymede	3731	mib2d[4512]:	SNMP_TRAP_LINK_DOWN:	ifIndex 40, ifAdminStatus up(1), ifOperStatus down(2), ifName mt-0/2/0		10
1311318	2003-11-19 17:27:58+02	2003-11-19 17:27:58.406247+02	ganymede	3731	mib2d[4512]:	SNMP_TRAP_LINK_DOWN:	ifIndex 36, ifAdminStatus up(1), ifOperStatus down(2), ifName gr-0/2/0		10
1311322	2003-11-19 17:27:58+02	2003-11-19 17:27:58.580132+02	ganymede	3731	rpd[4513]:		EVENT <UpDown MTU> index 138 <Broadcast Multicast>		10
1311306	2003-11-19 17:27:58+02	2003-11-19 17:27:58.196671+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> sp-0/2/0.16383 index 70 <Broadcast PointToPoint Multicast>		10
1311337	2003-11-19 17:27:58+02	2003-11-19 17:27:58.747643+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 137 <Broadcast Multicast>		10
1311301	2003-11-19 17:27:58+02	2003-11-19 17:27:58.163289+02	ganymede	3731	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 1, af 2, run-len 0		10
1311332	2003-11-19 17:27:58+02	2003-11-19 17:27:58.727995+02	ganymede	3731	rpd[4513]:		EVENT <Delete> sp-0/2/0.16383 index 70 <Broadcast PointToPoint Multicast>		10
1311342	2003-11-19 17:27:58+02	2003-11-19 17:27:58.8778+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 141 <Broadcast Multicast>		10
1311300	2003-11-19 17:27:58+02	2003-11-19 17:27:58.156804+02	ganymede	3731	chassisd[4397]:	CHASSISD_IFDEV_DETACH_PIC:	ifdev_detach_pic(0/2) 		10
1311325	2003-11-19 17:27:58+02	2003-11-19 17:27:58.591478+02	ganymede	3731	rpd[4513]:		EVENT Delete sp-0/2/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1311341	2003-11-19 17:27:58+02	2003-11-19 17:27:58.874072+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 140 <Broadcast Multicast>		10
1311330	2003-11-19 17:27:58+02	2003-11-19 17:27:58.718889+02	ganymede	3731	rpd[4513]:		EVENT Delete sp-0/2/0.16383 index 70 10.0.0.1 -> 10.0.0.18 <Broadcast PointToPoint Multicast>		10
1311340	2003-11-19 17:27:58+02	2003-11-19 17:27:58.868848+02	ganymede	3731	mib2d[4512]:	SNMP_TRAP_LINK_DOWN:	ifIndex 39, ifAdminStatus up(1), ifOperStatus down(2), ifName vt-0/2/0		10
1311339	2003-11-19 17:27:58+02	2003-11-19 17:27:58.756869+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 139 <Broadcast Multicast>		10
1311302	2003-11-19 17:27:58+02	2003-11-19 17:27:58.169936+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(69) local_prefix 0xc68c680e dest_prefix 0xc68c6822 dest_plen 32 flags 0x3		10
1311316	2003-11-19 17:27:58+02	2003-11-19 17:27:58.397123+02	ganymede	3731	rpd[4513]:		EVENT UpDown sp-0/2/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1311317	2003-11-19 17:27:58+02	2003-11-19 17:27:58.402427+02	ganymede	3731	/kernel:	sp-0/2/0:	ifl config: op: 3; sub: 16383; flags: 0x8010, curr: 0x8010.		10
1311336	2003-11-19 17:27:58+02	2003-11-19 17:27:58.74377+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 136 <Broadcast Multicast>		10
1311331	2003-11-19 17:27:58+02	2003-11-19 17:27:58.724182+02	ganymede	3731	rpd[4513]:		EVENT Delete sp-0/2/0.16383 index 70 <Broadcast PointToPoint Multicast>		10
1311305	2003-11-19 17:27:58+02	2003-11-19 17:27:58.192001+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(69) family 2		10
1311323	2003-11-19 17:27:58+02	2003-11-19 17:27:58.583845+02	ganymede	3731	rpd[4513]:		EVENT <UpDown MTU> index 139 <Broadcast Multicast>		10
1311344	2003-11-19 17:27:58+02	2003-11-19 17:27:58.885449+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 142 <Broadcast Multicast>		10
1311324	2003-11-19 17:27:58+02	2003-11-19 17:27:58.587577+02	ganymede	3731	rpd[4513]:		EVENT Delete sp-0/2/0.0 index 69 10.10.10.1 -> 10.10.10.2 <Broadcast PointToPoint Multicast>		10
1311328	2003-11-19 17:27:58+02	2003-11-19 17:27:58.602688+02	ganymede	3731	rpd[4513]:		EVENT <UpDown MTU> index 140 <Broadcast Multicast>		10
1311304	2003-11-19 17:27:58+02	2003-11-19 17:27:58.182798+02	ganymede	3731	mib2d[4512]:	SNMP_TRAP_LINK_DOWN:	ifIndex 29, ifAdminStatus up(1), ifOperStatus down(2), ifName sp-0/2/0		10
1311303	2003-11-19 17:27:58+02	2003-11-19 17:27:58.17634+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(69) local_prefix 0xc68c680e dest_prefix 0xc68c6822 dest_plen 32 flags 0x3		10
1311307	2003-11-19 17:27:58+02	2003-11-19 17:27:58.201659+02	ganymede	3731	mib2d[4512]:	SNMP_TRAP_LINK_DOWN:	ifIndex 32, ifAdminStatus up(1), ifOperStatus down(2), ifName pd-0/2/0		10
1311338	2003-11-19 17:27:58+02	2003-11-19 17:27:58.753156+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 138 <Broadcast Multicast>		10
1311321	2003-11-19 17:27:58+02	2003-11-19 17:27:58.576292+02	ganymede	3731	rpd[4513]:		EVENT <UpDown MTU> index 137 <Broadcast Multicast>		10
1311314	2003-11-19 17:27:58+02	2003-11-19 17:27:58.388612+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> sp-0/2/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1311308	2003-11-19 17:27:58+02	2003-11-19 17:27:58.208559+02	ganymede	3731	rpd[4513]:		EVENT UpDown sp-0/2/0.16383 index 70 <Broadcast PointToPoint Multicast>		10
1311309	2003-11-19 17:27:58+02	2003-11-19 17:27:58.215995+02	ganymede	3731	/kernel:	sp-0/2/0:	ifl config: op: 3; sub: 0; flags: 0x8010, curr: 0x8010.		10
1311310	2003-11-19 17:27:58+02	2003-11-19 17:27:58.328881+02	ganymede	3731	rpd[4513]:		EVENT UpDown sp-0/2/0.16383 index 70 10.0.0.1 -> 10.0.0.18 <Broadcast PointToPoint Multicast Localup>		10
1311329	2003-11-19 17:27:58+02	2003-11-19 17:27:58.606405+02	ganymede	3731	rpd[4513]:		EVENT <UpDown MTU> index 141 <Broadcast Multicast>		10
1311319	2003-11-19 17:27:58+02	2003-11-19 17:27:58.41021+02	ganymede	3731	rpd[4513]:		EVENT UpDown sp-0/2/0.0 index 69 10.10.10.1 -> 10.10.10.2 <Broadcast PointToPoint Multicast Localup>		10
1311311	2003-11-19 17:27:58+02	2003-11-19 17:27:58.334209+02	ganymede	3731	Slot		0, PIC Slot 2) Loopback mode is now disabled 		10
1311313	2003-11-19 17:27:58+02	2003-11-19 17:27:58.384864+02	ganymede	3731	mib2d[4512]:	SNMP_TRAP_LINK_DOWN:	ifIndex 35, ifAdminStatus up(1), ifOperStatus down(2), ifName pe-0/2/0		10
1311320	2003-11-19 17:27:58+02	2003-11-19 17:27:58.570948+02	ganymede	3731	rpd[4513]:		EVENT <UpDown MTU> index 136 <Broadcast Multicast>		10
1311327	2003-11-19 17:27:58+02	2003-11-19 17:27:58.598979+02	ganymede	3731	rpd[4513]:		EVENT  mo-0/3/0.16383 index 71 10.0.0.1 -> 10.0.0.19 <Up Broadcast PointToPoint Multicast Localup>		10
1311333	2003-11-19 17:27:58+02	2003-11-19 17:27:58.731786+02	ganymede	3731	mib2d[4512]:	SNMP_TRAP_LINK_DOWN:	ifIndex 38, ifAdminStatus up(1), ifOperStatus down(2), ifName ip-0/2/0		10
1311312	2003-11-19 17:27:58+02	2003-11-19 17:27:58.381098+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(70) local_prefix 0xc6726b8e dest_prefix 0xc6726ba2 dest_plen 32 flags 0x3		10
1311334	2003-11-19 17:27:58+02	2003-11-19 17:27:58.735642+02	ganymede	3731	rpd[4513]:		EVENT <UpDown MTU> index 142 <Broadcast Multicast>		10
1311335	2003-11-19 17:27:58+02	2003-11-19 17:27:58.739641+02	ganymede	3731	chassisd[4397]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power off: jnxFruContentsIndex 8, jnxFruL1Index 1, jnxFruL2Index 3, jnxFruL3Index 0, jnxFruName PIC: Adaptive Services @ 0/2/*, jnxFruType 11, jnxFruSlot 1, jnxFruOfflineReason 7, jnxFruLastPowerOff 163393604, jnxFruLastPowerOn 10431 		100
1311326	2003-11-19 17:27:58+02	2003-11-19 17:27:58.595209+02	ganymede	3731	rpd[4513]:		EVENT <Delete> sp-0/2/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1311379	2003-11-19 17:28:05+02	2003-11-19 17:28:05.864455+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10863, status 0		1
1311377	2003-11-19 17:28:05+02	2003-11-19 17:28:05.650458+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1311378	2003-11-19 17:28:05+02	2003-11-19 17:28:05.656063+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1311382	2003-11-19 17:28:06+02	2003-11-19 17:28:06.76237+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1311383	2003-11-19 17:28:06+02	2003-11-19 17:28:06.964411+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10864, status 0		1
1335419	2003-11-20 14:23:05+02	2003-11-20 14:23:05.65666+02	adrastea	3726	xntpd[2231]:		offset -0.000836 sec freq 76.487 ppm error 0.001098 poll 10		500
1334800	2003-11-20 14:23:08+02	2003-11-20 14:05:40.031899+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334801	2003-11-20 14:23:09+02	2003-11-20 14:05:41.033348+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334802	2003-11-20 14:23:09+02	2003-11-20 14:05:41.054228+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334804	2003-11-20 14:23:10+02	2003-11-20 14:05:42.04976+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334803	2003-11-20 14:23:10+02	2003-11-20 14:05:42.033033+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334805	2003-11-20 14:23:10+02	2003-11-20 14:05:42.053584+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334809	2003-11-20 14:23:11+02	2003-11-20 14:05:43.050653+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334808	2003-11-20 14:23:11+02	2003-11-20 14:05:43.045515+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334807	2003-11-20 14:23:11+02	2003-11-20 14:05:43.033896+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334812	2003-11-20 14:23:12+02	2003-11-20 14:05:44.060601+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334811	2003-11-20 14:23:12+02	2003-11-20 14:05:44.056685+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334810	2003-11-20 14:23:12+02	2003-11-20 14:05:44.033958+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334813	2003-11-20 14:23:13+02	2003-11-20 14:05:45.034682+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334814	2003-11-20 14:23:13+02	2003-11-20 14:05:45.05126+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334817	2003-11-20 14:23:14+02	2003-11-20 14:05:51.726934+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356652	2003-11-21 19:18:50+02	2003-11-21 19:01:36.550522+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311381	2003-11-19 17:28:06+02	2003-11-19 17:28:06.756366+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1311394	2003-11-19 17:28:07+02	2003-11-19 17:28:07.777249+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10865, status 0		1
1311393	2003-11-19 17:28:07+02	2003-11-19 17:28:07.60281+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1311392	2003-11-19 17:28:07+02	2003-11-19 17:28:07.599102+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1311395	2003-11-19 17:28:08+02	2003-11-19 17:28:08.455384+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1311397	2003-11-19 17:28:08+02	2003-11-19 17:28:08.664397+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10866, status 0		1
1311396	2003-11-19 17:28:08+02	2003-11-19 17:28:08.47215+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1347320	2003-11-20 19:56:52+02	2003-11-20 19:56:52.736432+02	ganymede	3731	mgd[2600]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'exit '		1
1347322	2003-11-20 19:56:52+02	2003-11-20 19:56:52.746648+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[2598]:	exit status 0x100		10
1347321	2003-11-20 19:56:52+02	2003-11-20 19:56:52.742709+02	ganymede	3731	mgd[2600]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1334987	2003-11-20 14:28:08+02	2003-11-20 14:10:40.111006+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334988	2003-11-20 14:28:09+02	2003-11-20 14:10:41.11291+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334989	2003-11-20 14:28:09+02	2003-11-20 14:10:41.124581+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334992	2003-11-20 14:28:10+02	2003-11-20 14:10:42.138404+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334991	2003-11-20 14:28:10+02	2003-11-20 14:10:42.134619+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334990	2003-11-20 14:28:10+02	2003-11-20 14:10:42.112192+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334994	2003-11-20 14:28:11+02	2003-11-20 14:10:43.115034+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334993	2003-11-20 14:28:11+02	2003-11-20 14:10:43.107081+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334995	2003-11-20 14:28:11+02	2003-11-20 14:10:43.118842+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334997	2003-11-20 14:28:12+02	2003-11-20 14:10:44.108106+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334998	2003-11-20 14:28:12+02	2003-11-20 14:10:44.232942+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1334999	2003-11-20 14:28:12+02	2003-11-20 14:10:44.238565+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335000	2003-11-20 14:28:13+02	2003-11-20 14:10:45.107758+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335001	2003-11-20 14:28:13+02	2003-11-20 14:10:45.122772+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335003	2003-11-20 14:28:14+02	2003-11-20 14:10:51.857684+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355889	2003-11-21 18:45:13+02	2003-11-21 18:45:16.676961+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1355885	2003-11-21 18:45:13+02	2003-11-21 18:45:16.593947+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1355834	2003-11-21 18:45:13+02	2003-11-21 18:45:15.571086+02	r201	3732	mgd[4901]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1355868	2003-11-21 18:45:13+02	2003-11-21 18:45:16.237806+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355916	2003-11-21 18:45:13+02	2003-11-21 18:45:17.259751+02	atlas	3730	mgd[2886]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1355866	2003-11-21 18:45:13+02	2003-11-21 18:45:16.223514+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355886	2003-11-21 18:45:13+02	2003-11-21 18:45:16.599653+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1355842	2003-11-21 18:45:13+02	2003-11-21 18:45:15.723735+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1355914	2003-11-21 18:45:13+02	2003-11-21 18:45:17.252006+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b620fc/32		10
1355874	2003-11-21 18:45:13+02	2003-11-21 18:45:16.375338+02	r201	3732	last		message repeated 3 times		10
1355919	2003-11-21 18:45:13+02	2003-11-21 18:45:17.271475+02	adrastea	3726	mgd[5182]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1355913	2003-11-21 18:45:13+02	2003-11-21 18:45:17.247508+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355846	2003-11-21 18:45:13+02	2003-11-21 18:45:15.835321+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355845	2003-11-21 18:45:13+02	2003-11-21 18:45:15.829398+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1355922	2003-11-21 18:45:13+02	2003-11-21 18:45:17.394575+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355921	2003-11-21 18:45:13+02	2003-11-21 18:45:17.279108+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5210, status 0		1
1355863	2003-11-21 18:45:13+02	2003-11-21 18:45:16.207863+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5207, status 0		1
1355865	2003-11-21 18:45:13+02	2003-11-21 18:45:16.218546+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355893	2003-11-21 18:45:13+02	2003-11-21 18:45:16.857631+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1355884	2003-11-21 18:45:13+02	2003-11-21 18:45:16.588609+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1355837	2003-11-21 18:45:13+02	2003-11-21 18:45:15.591357+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1355892	2003-11-21 18:45:13+02	2003-11-21 18:45:16.801587+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1355861	2003-11-21 18:45:13+02	2003-11-21 18:45:16.090794+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5206, status 0		1
1355876	2003-11-21 18:45:13+02	2003-11-21 18:45:16.386164+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc395d5fc/32		10
1355887	2003-11-21 18:45:13+02	2003-11-21 18:45:16.60745+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1355891	2003-11-21 18:45:13+02	2003-11-21 18:45:16.688299+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1355900	2003-11-21 18:45:13+02	2003-11-21 18:45:16.908874+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1355910	2003-11-21 18:45:13+02	2003-11-21 18:45:17.127972+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b620fc/32		10
1355838	2003-11-21 18:45:13+02	2003-11-21 18:45:15.596155+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 5200, status 0		1
1355879	2003-11-21 18:45:13+02	2003-11-21 18:45:16.398791+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b7d3fc/32		10
1355844	2003-11-21 18:45:13+02	2003-11-21 18:45:15.823415+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2898, status 0		1
1355840	2003-11-21 18:45:13+02	2003-11-21 18:45:15.607416+02	atlas	3730	mgd[2886]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355836	2003-11-21 18:45:13+02	2003-11-21 18:45:15.58686+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 5199, status 0		1
1355890	2003-11-21 18:45:13+02	2003-11-21 18:45:16.683426+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1355847	2003-11-21 18:45:13+02	2003-11-21 18:45:15.840097+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 5203, status 0		1
1355924	2003-11-21 18:45:13+02	2003-11-21 18:45:17.40708+02	adrastea	3726	mgd[5182]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1355878	2003-11-21 18:45:13+02	2003-11-21 18:45:16.394783+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355839	2003-11-21 18:45:13+02	2003-11-21 18:45:15.60274+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1355864	2003-11-21 18:45:13+02	2003-11-21 18:45:16.213539+02	adrastea	3726	mgd[5181]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1355835	2003-11-21 18:45:13+02	2003-11-21 18:45:15.579507+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1355841	2003-11-21 18:45:13+02	2003-11-21 18:45:15.615433+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 5201, status 0		1
1355909	2003-11-21 18:45:13+02	2003-11-21 18:45:17.123976+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355849	2003-11-21 18:45:13+02	2003-11-21 18:45:15.901568+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355858	2003-11-21 18:45:13+02	2003-11-21 18:45:16.073842+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4914, status 0		1
1355901	2003-11-21 18:45:13+02	2003-11-21 18:45:16.91279+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1355907	2003-11-21 18:45:13+02	2003-11-21 18:45:17.112713+02	r201	3732	inetd[4419]:	/usr/libexec/telnetd[4899]:	exit status 0x100		10
1355925	2003-11-21 18:45:13+02	2003-11-21 18:45:17.411574+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355918	2003-11-21 18:45:13+02	2003-11-21 18:45:17.267486+02	atlas	3730	inetd[2245]:	/usr/libexec/telnetd[2884]:	exit status 0x100		10
1355908	2003-11-21 18:45:13+02	2003-11-21 18:45:17.117819+02	adrastea	3726	mgd[5182]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1355867	2003-11-21 18:45:13+02	2003-11-21 18:45:16.228118+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 3027, status 0		1
1355915	2003-11-21 18:45:13+02	2003-11-21 18:45:17.255923+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2900, status 0		1
1355896	2003-11-21 18:45:13+02	2003-11-21 18:45:16.891851+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1346615	2003-11-20 19:57:43+02	2003-11-20 19:40:22.535873+02	jupiter	3727	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp1		1
1346614	2003-11-20 19:57:43+02	2003-11-20 19:40:22.527528+02	jupiter	3727	login:	tac_send_authen:	connect: timed out		1
1346616	2003-11-20 19:57:43+02	2003-11-20 19:40:22.650193+02	jupiter	3727	login:		login from 172.26.27.115 on ttyp1 as lab		1
1346667	2003-11-20 19:57:44+02	2003-11-20 19:40:23.569435+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/proc/4601/file', PID 7079, status 0		1
1346641	2003-11-20 19:57:44+02	2003-11-20 19:40:23.091662+02	jupiter	3727	login:		login from 172.26.27.115 on ttyp0 as lab		1
1346682	2003-11-20 19:57:44+02	2003-11-20 19:40:23.849987+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/proc/4609/file'		1
1346645	2003-11-20 19:57:44+02	2003-11-20 19:40:23.23994+02	jupiter	3727	mgd[7072]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1346647	2003-11-20 19:57:44+02	2003-11-20 19:40:23.249297+02	jupiter	3727	mgd[7072]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1346700	2003-11-20 19:57:44+02	2003-11-20 19:40:24.140808+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/proc/4461/file', PID 7095, status 0		1
1346640	2003-11-20 19:57:44+02	2003-11-20 19:40:23.084088+02	jupiter	3727	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1346644	2003-11-20 19:57:44+02	2003-11-20 19:40:23.126139+02	jupiter	3727	mgd[7071]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [7071]		1
1346646	2003-11-20 19:57:44+02	2003-11-20 19:40:23.244045+02	jupiter	3727	mgd[7072]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [7072]		1
1346672	2003-11-20 19:57:44+02	2003-11-20 19:40:23.651452+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/proc/4459/file'		1
1346671	2003-11-20 19:57:44+02	2003-11-20 19:40:23.647339+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 7081, status 0		1
1346675	2003-11-20 19:57:44+02	2003-11-20 19:40:23.770133+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/proc/4459/file'		1
1346657	2003-11-20 19:57:44+02	2003-11-20 19:40:23.419257+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/proc/4616/file'		1
1346697	2003-11-20 19:57:44+02	2003-11-20 19:40:24.12896+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 7094, status 0		1
1346685	2003-11-20 19:57:44+02	2003-11-20 19:40:23.970046+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/proc/4457/file'		1
1346650	2003-11-20 19:57:44+02	2003-11-20 19:40:23.264762+02	jupiter	3727	mgd[7072]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1346649	2003-11-20 19:57:44+02	2003-11-20 19:40:23.259641+02	jupiter	3727	mgd[7071]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1346655	2003-11-20 19:57:44+02	2003-11-20 19:40:23.410203+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/proc/4615/file'		1
1346648	2003-11-20 19:57:44+02	2003-11-20 19:40:23.25437+02	jupiter	3727	mgd[7071]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1346651	2003-11-20 19:57:44+02	2003-11-20 19:40:23.270344+02	jupiter	3727	mgd[7071]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1346656	2003-11-20 19:57:44+02	2003-11-20 19:40:23.415516+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/proc/4615/file', PID 7074, status 0		1
1346653	2003-11-20 19:57:44+02	2003-11-20 19:40:23.287079+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/proc/4616/file', PID 7073, status 0		1
1346699	2003-11-20 19:57:44+02	2003-11-20 19:40:24.137066+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/proc/4461/file'		1
1346659	2003-11-20 19:57:44+02	2003-11-20 19:40:23.42866+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/proc/4615/file'		1
1346703	2003-11-20 19:57:44+02	2003-11-20 19:40:24.153662+02	jupiter	3727	mgd[7071]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1346681	2003-11-20 19:57:44+02	2003-11-20 19:40:23.846104+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/proc/4605/file', PID 7086, status 0		1
1346701	2003-11-20 19:57:44+02	2003-11-20 19:40:24.144529+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/proc/4461/file', PID 7096, status 0		1
1335705	2003-11-20 14:31:31+02	2003-11-20 14:31:32.043982+02	ganymede	3731	xntpd[2770]:		offset 0.001049 sec freq 84.850 ppm error 0.000242 poll 9		500
1352363	2003-11-21 17:38:42+02	2003-11-21 17:21:23.438936+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352364	2003-11-21 17:38:43+02	2003-11-21 17:21:24.439665+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352365	2003-11-21 17:38:43+02	2003-11-21 17:21:24.444551+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352366	2003-11-21 17:38:44+02	2003-11-21 17:21:25.440103+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352368	2003-11-21 17:38:44+02	2003-11-21 17:21:25.484733+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352367	2003-11-21 17:38:44+02	2003-11-21 17:21:25.480935+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352370	2003-11-21 17:38:45+02	2003-11-21 17:21:26.45172+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352371	2003-11-21 17:38:45+02	2003-11-21 17:21:26.456564+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352369	2003-11-21 17:38:45+02	2003-11-21 17:21:26.440155+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352374	2003-11-21 17:38:46+02	2003-11-21 17:21:27.440985+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352375	2003-11-21 17:38:46+02	2003-11-21 17:21:27.459633+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352376	2003-11-21 17:38:46+02	2003-11-21 17:21:27.463397+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352378	2003-11-21 17:38:47+02	2003-11-21 17:21:28.45628+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352377	2003-11-21 17:38:47+02	2003-11-21 17:21:28.441018+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352380	2003-11-21 17:38:48+02	2003-11-21 17:21:33.947651+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335156	2003-11-20 14:33:08+02	2003-11-20 14:15:40.184439+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335158	2003-11-20 14:33:09+02	2003-11-20 14:15:41.194127+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335157	2003-11-20 14:33:09+02	2003-11-20 14:15:41.185725+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335160	2003-11-20 14:33:10+02	2003-11-20 14:15:42.204127+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335159	2003-11-20 14:33:10+02	2003-11-20 14:15:42.186781+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335161	2003-11-20 14:33:10+02	2003-11-20 14:15:42.207955+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335165	2003-11-20 14:33:11+02	2003-11-20 14:15:43.247982+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335163	2003-11-20 14:33:11+02	2003-11-20 14:15:43.185462+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335164	2003-11-20 14:33:11+02	2003-11-20 14:15:43.241771+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346686	2003-11-20 19:57:44+02	2003-11-20 19:40:23.975295+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/proc/4457/file', PID 7089, status 0		1
1346652	2003-11-20 19:57:44+02	2003-11-20 19:40:23.275391+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/proc/4616/file'		1
1346696	2003-11-20 19:57:44+02	2003-11-20 19:40:24.125201+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 7093, status 0		1
1346677	2003-11-20 19:57:44+02	2003-11-20 19:40:23.825993+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/proc/4459/file', PID 7084, status 0		1
1346666	2003-11-20 19:57:44+02	2003-11-20 19:40:23.565608+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/proc/4601/file'		1
1346660	2003-11-20 19:57:44+02	2003-11-20 19:40:23.432591+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/proc/4615/file', PID 7076, status 0		1
1346692	2003-11-20 19:57:44+02	2003-11-20 19:40:23.99853+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 7090, status 0		1
1346695	2003-11-20 19:57:44+02	2003-11-20 19:40:24.119979+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1346702	2003-11-20 19:57:44+02	2003-11-20 19:40:24.14826+02	jupiter	3727	mgd[7072]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1346689	2003-11-20 19:57:44+02	2003-11-20 19:40:23.986617+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/proc/4457/file'		1
1346687	2003-11-20 19:57:44+02	2003-11-20 19:40:23.979032+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1346663	2003-11-20 19:57:44+02	2003-11-20 19:40:23.44412+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/proc/4447/file', PID 7077, status 0		1
1346679	2003-11-20 19:57:44+02	2003-11-20 19:40:23.8362+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/proc/4605/file'		1
1346688	2003-11-20 19:57:44+02	2003-11-20 19:40:23.982893+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/proc/4609/file', PID 7088, status 0		1
1346676	2003-11-20 19:57:44+02	2003-11-20 19:40:23.775813+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/proc/4459/file', PID 7083, status 0		1
1346664	2003-11-20 19:57:44+02	2003-11-20 19:40:23.447826+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/proc/4601/file'		1
1346668	2003-11-20 19:57:44+02	2003-11-20 19:40:23.573251+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/proc/4601/file', PID 7080, status 0		1
1346690	2003-11-20 19:57:44+02	2003-11-20 19:40:23.99043+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/proc/4457/file', PID 7091, status 0		1
1346669	2003-11-20 19:57:44+02	2003-11-20 19:40:23.639851+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1346684	2003-11-20 19:57:44+02	2003-11-20 19:40:23.857526+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/proc/4609/file', PID 7087, status 0		1
1346694	2003-11-20 19:57:44+02	2003-11-20 19:40:24.006002+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 7092, status 0		1
1346680	2003-11-20 19:57:44+02	2003-11-20 19:40:23.842251+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/proc/4605/file', PID 7085, status 0		1
1346643	2003-11-20 19:57:44+02	2003-11-20 19:40:23.116586+02	jupiter	3727	mgd[7071]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1346678	2003-11-20 19:57:44+02	2003-11-20 19:40:23.832408+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/proc/4605/file'		1
1346683	2003-11-20 19:57:44+02	2003-11-20 19:40:23.853792+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/proc/4609/file'		1
1346654	2003-11-20 19:57:44+02	2003-11-20 19:40:23.303725+02	jupiter	3727	mgd[7072]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1346698	2003-11-20 19:57:44+02	2003-11-20 19:40:24.132982+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/proc/4461/file'		1
1346662	2003-11-20 19:57:44+02	2003-11-20 19:40:23.440026+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/proc/4447/file'		1
1346618	2003-11-20 19:57:44+02	2003-11-20 19:40:22.678018+02	jupiter	3727	login:	tac_send_authen:	connect: timed out		1
1346693	2003-11-20 19:57:44+02	2003-11-20 19:40:24.002266+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1346658	2003-11-20 19:57:44+02	2003-11-20 19:40:23.424944+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/proc/4616/file', PID 7075, status 0		1
1346674	2003-11-20 19:57:44+02	2003-11-20 19:40:23.658906+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 7082, status 0		1
1346661	2003-11-20 19:57:44+02	2003-11-20 19:40:23.436306+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/proc/4447/file'		1
1346670	2003-11-20 19:57:44+02	2003-11-20 19:40:23.643607+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1346707	2003-11-20 19:57:44+02	2003-11-20 19:40:24.32571+02	jupiter	3727	mgd[7072]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1346665	2003-11-20 19:57:44+02	2003-11-20 19:40:23.560185+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/proc/4447/file', PID 7078, status 0		1
1346691	2003-11-20 19:57:44+02	2003-11-20 19:40:23.994821+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1346714	2003-11-20 19:57:45+02	2003-11-20 19:40:24.358678+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346712	2003-11-20 19:57:45+02	2003-11-20 19:40:24.344738+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346725	2003-11-20 19:57:45+02	2003-11-20 19:40:24.640043+02	jupiter	3727	mgd[7071]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346722	2003-11-20 19:57:45+02	2003-11-20 19:40:24.524242+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346723	2003-11-20 19:57:45+02	2003-11-20 19:40:24.528072+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 7100, status 0		1
1346718	2003-11-20 19:57:45+02	2003-11-20 19:40:24.483431+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346709	2003-11-20 19:57:45+02	2003-11-20 19:40:24.333366+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346716	2003-11-20 19:57:45+02	2003-11-20 19:40:24.47588+02	jupiter	3727	mgd[7072]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1346717	2003-11-20 19:57:45+02	2003-11-20 19:40:24.47973+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346711	2003-11-20 19:57:45+02	2003-11-20 19:40:24.341024+02	jupiter	3727	mgd[7072]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1346708	2003-11-20 19:57:45+02	2003-11-20 19:40:24.329593+02	jupiter	3727	mgd[7071]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1346715	2003-11-20 19:57:45+02	2003-11-20 19:40:24.470481+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 7098, status 0		1
1335167	2003-11-20 14:33:12+02	2003-11-20 14:15:44.246003+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335166	2003-11-20 14:33:12+02	2003-11-20 14:15:44.209425+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335168	2003-11-20 14:33:12+02	2003-11-20 14:15:44.249938+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335169	2003-11-20 14:33:13+02	2003-11-20 14:15:45.18657+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335170	2003-11-20 14:33:13+02	2003-11-20 14:15:45.205674+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335173	2003-11-20 14:33:14+02	2003-11-20 14:15:51.988125+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335797	2003-11-20 14:34:35+02	2003-11-20 14:34:35.285095+02	atlas	3730	xntpd[2692]:		offset 0.001399 sec freq 78.094 ppm error 0.000344 poll 10		500
1346721	2003-11-20 19:57:45+02	2003-11-20 19:40:24.501223+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346724	2003-11-20 19:57:45+02	2003-11-20 19:40:24.532023+02	jupiter	3727	mgd[7071]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1346710	2003-11-20 19:57:45+02	2003-11-20 19:40:24.33722+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 7097, status 0		1
1346713	2003-11-20 19:57:45+02	2003-11-20 19:40:24.348463+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 7099, status 0		1
1346720	2003-11-20 19:57:45+02	2003-11-20 19:40:24.490939+02	jupiter	3727	last		message repeated 4 times		10
1346729	2003-11-20 19:57:46+02	2003-11-20 19:40:24.705411+02	jupiter	3727	last		message repeated 4 times		10
1346727	2003-11-20 19:57:46+02	2003-11-20 19:40:24.697091+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346730	2003-11-20 19:57:46+02	2003-11-20 19:40:24.71642+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346734	2003-11-20 19:57:46+02	2003-11-20 19:40:24.734211+02	jupiter	3727	mgd[7072]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1346732	2003-11-20 19:57:46+02	2003-11-20 19:40:24.726599+02	jupiter	3727	mgd[7072]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 7101, status 0		1
1346731	2003-11-20 19:57:46+02	2003-11-20 19:40:24.722846+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1346733	2003-11-20 19:57:46+02	2003-11-20 19:40:24.730369+02	jupiter	3727	mgd[7071]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 7102, status 0		1
1346735	2003-11-20 19:57:46+02	2003-11-20 19:40:24.890054+02	jupiter	3727	mgd[7072]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1346728	2003-11-20 19:57:46+02	2003-11-20 19:40:24.700944+02	jupiter	3727	/kernel:	in_ifalrequest:	.local. op 5 local 0xc397cbfc/32		10
1346737	2003-11-20 19:57:47+02	2003-11-20 19:40:24.900089+02	jupiter	3727	mgd[7071]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1346736	2003-11-20 19:57:47+02	2003-11-20 19:40:24.895349+02	jupiter	3727	inetd[4451]:	/usr/libexec/telnetd[7067]:	exit status 0x100		10
1346738	2003-11-20 19:57:47+02	2003-11-20 19:40:24.903837+02	jupiter	3727	mgd[7071]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1346739	2003-11-20 19:57:47+02	2003-11-20 19:40:24.907684+02	jupiter	3727	inetd[4451]:	/usr/libexec/telnetd[7068]:	exit status 0x100		10
1335874	2003-11-20 14:36:35+02	2003-11-20 14:36:35.157145+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1335872	2003-11-20 14:36:35+02	2003-11-20 14:36:35.142183+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1335873	2003-11-20 14:36:35+02	2003-11-20 14:36:35.151303+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1355872	2003-11-21 18:45:13+02	2003-11-21 18:45:16.361531+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1335322	2003-11-20 14:38:08+02	2003-11-20 14:20:40.26292+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335325	2003-11-20 14:38:09+02	2003-11-20 14:20:41.380655+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335324	2003-11-20 14:38:09+02	2003-11-20 14:20:41.26429+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335330	2003-11-20 14:38:10+02	2003-11-20 14:20:42.322052+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335329	2003-11-20 14:38:10+02	2003-11-20 14:20:42.318207+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335328	2003-11-20 14:38:10+02	2003-11-20 14:20:42.309972+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335334	2003-11-20 14:38:11+02	2003-11-20 14:20:43.343006+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335333	2003-11-20 14:38:11+02	2003-11-20 14:20:43.285617+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335332	2003-11-20 14:38:11+02	2003-11-20 14:20:43.264935+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335337	2003-11-20 14:38:12+02	2003-11-20 14:20:44.285151+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335335	2003-11-20 14:38:12+02	2003-11-20 14:20:44.264912+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335336	2003-11-20 14:38:12+02	2003-11-20 14:20:44.281349+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335338	2003-11-20 14:38:13+02	2003-11-20 14:20:45.265555+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335339	2003-11-20 14:38:13+02	2003-11-20 14:20:45.277066+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335342	2003-11-20 14:38:14+02	2003-11-20 14:20:52.118494+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346761	2003-11-20 19:58:15+02	2003-11-20 19:40:48.677354+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346762	2003-11-20 19:58:16+02	2003-11-20 19:40:49.678208+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346763	2003-11-20 19:58:16+02	2003-11-20 19:40:49.689926+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346766	2003-11-20 19:58:17+02	2003-11-20 19:40:50.833095+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346765	2003-11-20 19:58:17+02	2003-11-20 19:40:50.725411+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346764	2003-11-20 19:58:17+02	2003-11-20 19:40:50.67856+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346767	2003-11-20 19:58:18+02	2003-11-20 19:40:51.678679+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346768	2003-11-20 19:58:18+02	2003-11-20 19:40:51.695774+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346769	2003-11-20 19:58:18+02	2003-11-20 19:40:51.699696+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346778	2003-11-20 19:58:19+02	2003-11-20 19:40:52.679356+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346779	2003-11-20 19:58:19+02	2003-11-20 19:40:52.68497+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346780	2003-11-20 19:58:19+02	2003-11-20 19:40:52.689041+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346781	2003-11-20 19:58:20+02	2003-11-20 19:40:53.679252+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346782	2003-11-20 19:58:20+02	2003-11-20 19:40:53.715805+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346785	2003-11-20 19:58:21+02	2003-11-20 19:41:00.462152+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347436	2003-11-20 20:00:00+02	2003-11-20 20:00:00.301419+02	atlas	3730	CRON[2760]:		(root) CMD (newsyslog) 		10
1347437	2003-11-20 20:00:00+02	2003-11-20 20:00:00.326563+02	ganymede	3731	CRON[2872]:		(root) CMD (newsyslog) 		10
1346850	2003-11-20 20:00:00+02	2003-11-20 19:42:34.082533+02	jupiter	3727	CRON[7104]:		(root) CMD (newsyslog) 		10
1347449	2003-11-20 20:00:00+02	2003-11-20 20:00:01.117329+02	adrastea	3726	CRON[5035]:		(root) CMD (newsyslog) 		10
1347448	2003-11-20 20:00:00+02	2003-11-20 20:00:00.866201+02	r201	3732	CRON[4774]:		(root) CMD (newsyslog) 		10
1313117	2003-11-19 17:32:38+02	2003-11-19 17:34:37.147456+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1307900	2003-11-19 17:32:40+02	2003-11-19 17:15:05.271147+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307910	2003-11-19 17:32:41+02	2003-11-19 17:15:06.340452+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307909	2003-11-19 17:32:41+02	2003-11-19 17:15:06.272732+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307913	2003-11-19 17:32:42+02	2003-11-19 17:15:07.284358+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307912	2003-11-19 17:32:42+02	2003-11-19 17:15:07.280552+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307911	2003-11-19 17:32:42+02	2003-11-19 17:15:07.272435+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307923	2003-11-19 17:32:43+02	2003-11-19 17:15:08.329116+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307922	2003-11-19 17:32:43+02	2003-11-19 17:15:08.278658+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307921	2003-11-19 17:32:43+02	2003-11-19 17:15:08.273006+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307925	2003-11-19 17:32:44+02	2003-11-19 17:15:09.287633+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307924	2003-11-19 17:32:44+02	2003-11-19 17:15:09.273192+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307926	2003-11-19 17:32:44+02	2003-11-19 17:15:09.397327+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307933	2003-11-19 17:32:45+02	2003-11-19 17:15:10.273875+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307934	2003-11-19 17:32:45+02	2003-11-19 17:15:10.282359+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1307978	2003-11-19 17:32:46+02	2003-11-19 17:15:19.509496+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335501	2003-11-20 14:43:08+02	2003-11-20 14:25:40.346581+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335503	2003-11-20 14:43:09+02	2003-11-20 14:25:41.367326+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335502	2003-11-20 14:43:09+02	2003-11-20 14:25:41.347608+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335505	2003-11-20 14:43:10+02	2003-11-20 14:25:42.36266+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335506	2003-11-20 14:43:10+02	2003-11-20 14:25:42.475219+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335504	2003-11-20 14:43:10+02	2003-11-20 14:25:42.34775+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335507	2003-11-20 14:43:11+02	2003-11-20 14:25:43.347851+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335509	2003-11-20 14:43:11+02	2003-11-20 14:25:43.361183+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335508	2003-11-20 14:43:11+02	2003-11-20 14:25:43.357362+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335511	2003-11-20 14:43:12+02	2003-11-20 14:25:44.353137+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335510	2003-11-20 14:43:12+02	2003-11-20 14:25:44.343858+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335512	2003-11-20 14:43:12+02	2003-11-20 14:25:44.357166+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335514	2003-11-20 14:43:13+02	2003-11-20 14:25:45.363115+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335513	2003-11-20 14:43:13+02	2003-11-20 14:25:45.343693+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335517	2003-11-20 14:43:14+02	2003-11-20 14:25:52.24886+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1312749	2003-11-19 17:33:13+02	2003-11-19 17:33:13.96991+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1335666	2003-11-20 14:48:08+02	2003-11-20 14:30:40.425079+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335667	2003-11-20 14:48:09+02	2003-11-20 14:30:41.42589+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335668	2003-11-20 14:48:09+02	2003-11-20 14:30:41.431801+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335670	2003-11-20 14:48:10+02	2003-11-20 14:30:42.446973+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335671	2003-11-20 14:48:10+02	2003-11-20 14:30:42.451994+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335669	2003-11-20 14:48:10+02	2003-11-20 14:30:42.426368+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335675	2003-11-20 14:48:11+02	2003-11-20 14:30:43.446588+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335673	2003-11-20 14:48:11+02	2003-11-20 14:30:43.426305+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355856	2003-11-21 18:45:13+02	2003-11-21 18:45:16.062704+02	atlas	3730	mgd[2886]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1355895	2003-11-21 18:45:13+02	2003-11-21 18:45:16.88066+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1355923	2003-11-21 18:45:13+02	2003-11-21 18:45:17.400411+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5211, status 0		1
1355920	2003-11-21 18:45:13+02	2003-11-21 18:45:17.275226+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355888	2003-11-21 18:45:13+02	2003-11-21 18:45:16.664883+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1355875	2003-11-21 18:45:13+02	2003-11-21 18:45:16.380075+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355855	2003-11-21 18:45:13+02	2003-11-21 18:45:16.058472+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355853	2003-11-21 18:45:13+02	2003-11-21 18:45:16.046201+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355881	2003-11-21 18:45:13+02	2003-11-21 18:45:16.459292+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355852	2003-11-21 18:45:13+02	2003-11-21 18:45:16.041765+02	r201	3732	mgd[4901]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4913, status 0		1
1355848	2003-11-21 18:45:13+02	2003-11-21 18:45:15.846344+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1355906	2003-11-21 18:45:13+02	2003-11-21 18:45:17.107594+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 5209, status 0		1
1355883	2003-11-21 18:45:13+02	2003-11-21 18:45:16.583929+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1355851	2003-11-21 18:45:13+02	2003-11-21 18:45:15.926327+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1355850	2003-11-21 18:45:13+02	2003-11-21 18:45:15.916627+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 5204, status 0		1
1355854	2003-11-21 18:45:13+02	2003-11-21 18:45:16.051672+02	atlas	3730	mgd[2886]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2899, status 0		1
1355871	2003-11-21 18:45:13+02	2003-11-21 18:45:16.253778+02	ganymede	3731	mgd[3015]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355860	2003-11-21 18:45:13+02	2003-11-21 18:45:16.086776+02	r201	3732	mgd[4901]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355880	2003-11-21 18:45:13+02	2003-11-21 18:45:16.402747+02	adrastea	3726	last		message repeated 4 times		10
1355912	2003-11-21 18:45:13+02	2003-11-21 18:45:17.241794+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355870	2003-11-21 18:45:13+02	2003-11-21 18:45:16.247014+02	ganymede	3731	mgd[3015]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1355903	2003-11-21 18:45:13+02	2003-11-21 18:45:17.087445+02	adrastea	3726	mgd[5182]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1355904	2003-11-21 18:45:13+02	2003-11-21 18:45:17.092515+02	r201	3732	mgd[4901]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1355911	2003-11-21 18:45:13+02	2003-11-21 18:45:17.132626+02	atlas	3730	last		message repeated 2 times		10
1355899	2003-11-21 18:45:13+02	2003-11-21 18:45:16.904777+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1355882	2003-11-21 18:45:13+02	2003-11-21 18:45:16.57445+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1355869	2003-11-21 18:45:13+02	2003-11-21 18:45:16.2422+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 3028, status 0		1
1355905	2003-11-21 18:45:13+02	2003-11-21 18:45:17.098855+02	r201	3732	mgd[4901]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1355897	2003-11-21 18:45:13+02	2003-11-21 18:45:16.895795+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1355862	2003-11-21 18:45:13+02	2003-11-21 18:45:16.202644+02	adrastea	3726	mgd[5181]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1355898	2003-11-21 18:45:13+02	2003-11-21 18:45:16.899916+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1355947	2003-11-21 18:45:14+02	2003-11-21 18:45:17.795561+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355966	2003-11-21 18:45:14+02	2003-11-21 18:45:18.15257+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1355954	2003-11-21 18:45:14+02	2003-11-21 18:45:17.944094+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1355953	2003-11-21 18:45:14+02	2003-11-21 18:45:17.939118+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1355963	2003-11-21 18:45:14+02	2003-11-21 18:45:18.140147+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1355928	2003-11-21 18:45:14+02	2003-11-21 18:45:17.428402+02	ganymede	3731	last		message repeated 5 times		10
1355931	2003-11-21 18:45:14+02	2003-11-21 18:45:17.443127+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355951	2003-11-21 18:45:14+02	2003-11-21 18:45:17.815952+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1355968	2003-11-21 18:45:14+02	2003-11-21 18:45:18.160293+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1355934	2003-11-21 18:45:14+02	2003-11-21 18:45:17.614425+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1355927	2003-11-21 18:45:14+02	2003-11-21 18:45:17.424519+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b3e6fc/32		10
1355950	2003-11-21 18:45:14+02	2003-11-21 18:45:17.811967+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355930	2003-11-21 18:45:14+02	2003-11-21 18:45:17.439363+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b3e6fc/32		10
1355969	2003-11-21 18:45:14+02	2003-11-21 18:45:18.167113+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1355933	2003-11-21 18:45:14+02	2003-11-21 18:45:17.60752+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1355935	2003-11-21 18:45:14+02	2003-11-21 18:45:17.618324+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/0) ifd vptree not initialized		10
1355945	2003-11-21 18:45:14+02	2003-11-21 18:45:17.787186+02	ganymede	3731	mgd[3015]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1355965	2003-11-21 18:45:14+02	2003-11-21 18:45:18.148557+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1355938	2003-11-21 18:45:14+02	2003-11-21 18:45:17.642898+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1355944	2003-11-21 18:45:14+02	2003-11-21 18:45:17.782685+02	ganymede	3731	mgd[3015]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1355948	2003-11-21 18:45:14+02	2003-11-21 18:45:17.799446+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1ba17fc/32		10
1355967	2003-11-21 18:45:14+02	2003-11-21 18:45:18.156439+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1355952	2003-11-21 18:45:14+02	2003-11-21 18:45:17.933175+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1335674	2003-11-20 14:48:11+02	2003-11-20 14:30:43.442772+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335677	2003-11-20 14:48:12+02	2003-11-20 14:30:44.438542+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335676	2003-11-20 14:48:12+02	2003-11-20 14:30:44.422276+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335678	2003-11-20 14:48:12+02	2003-11-20 14:30:44.442372+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335680	2003-11-20 14:48:13+02	2003-11-20 14:30:45.434288+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335679	2003-11-20 14:48:13+02	2003-11-20 14:30:45.422128+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335685	2003-11-20 14:48:14+02	2003-11-20 14:30:52.379347+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346943	2003-11-20 20:03:15+02	2003-11-20 19:45:48.750466+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346945	2003-11-20 20:03:16+02	2003-11-20 19:45:49.843324+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346944	2003-11-20 20:03:16+02	2003-11-20 19:45:49.75214+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346946	2003-11-20 20:03:17+02	2003-11-20 19:45:50.75188+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346947	2003-11-20 20:03:17+02	2003-11-20 19:45:50.759772+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346948	2003-11-20 20:03:17+02	2003-11-20 19:45:50.86625+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346949	2003-11-20 20:03:18+02	2003-11-20 19:45:51.752608+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346951	2003-11-20 20:03:18+02	2003-11-20 19:45:51.772468+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346950	2003-11-20 20:03:18+02	2003-11-20 19:45:51.76867+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346954	2003-11-20 20:03:19+02	2003-11-20 19:45:52.764746+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346955	2003-11-20 20:03:19+02	2003-11-20 19:45:52.768611+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346953	2003-11-20 20:03:19+02	2003-11-20 19:45:52.752473+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346957	2003-11-20 20:03:20+02	2003-11-20 19:45:53.774586+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346956	2003-11-20 20:03:20+02	2003-11-20 19:45:53.753249+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1346960	2003-11-20 20:03:21+02	2003-11-20 19:46:00.592535+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347587	2003-11-20 20:03:46+02	2003-11-20 20:03:46.336278+02	r201	3732	login:		PAM authentication chain returned: [7]Authentication failure		1
1347586	2003-11-20 20:03:46+02	2003-11-20 20:03:46.320126+02	r201	3732	login:		PAM module 0 returned: [7]Authentication failure		1
1347593	2003-11-20 20:03:49+02	2003-11-20 20:03:50.228024+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1347591	2003-11-20 20:03:49+02	2003-11-20 20:03:50.100666+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1347592	2003-11-20 20:03:49+02	2003-11-20 20:03:50.22129+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1347594	2003-11-20 20:03:49+02	2003-11-20 20:03:50.233071+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1347595	2003-11-20 20:03:49+02	2003-11-20 20:03:50.238025+02	r201	3732	login:		login on ttyd0 as lab		1
1347597	2003-11-20 20:03:50+02	2003-11-20 20:03:50.246977+02	r201	3732	mgd[4776]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4776]		1
1347596	2003-11-20 20:03:50+02	2003-11-20 20:03:50.243059+02	r201	3732	mgd[4776]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1347599	2003-11-20 20:03:51+02	2003-11-20 20:03:51.853545+02	r201	3732	mgd[4776]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1347598	2003-11-20 20:03:51+02	2003-11-20 20:03:51.838837+02	r201	3732	mgd[4776]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'exit '		1
1335835	2003-11-20 14:53:08+02	2003-11-20 14:35:40.584527+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335838	2003-11-20 14:53:09+02	2003-11-20 14:35:41.633542+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335837	2003-11-20 14:53:09+02	2003-11-20 14:35:41.584837+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335839	2003-11-20 14:53:10+02	2003-11-20 14:35:42.587428+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335840	2003-11-20 14:53:10+02	2003-11-20 14:35:42.602803+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335841	2003-11-20 14:53:10+02	2003-11-20 14:35:42.714288+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335843	2003-11-20 14:53:11+02	2003-11-20 14:35:43.598537+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335844	2003-11-20 14:53:11+02	2003-11-20 14:35:43.602352+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335842	2003-11-20 14:53:11+02	2003-11-20 14:35:43.585466+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335846	2003-11-20 14:53:12+02	2003-11-20 14:35:44.608531+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335847	2003-11-20 14:53:12+02	2003-11-20 14:35:44.612358+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335845	2003-11-20 14:53:12+02	2003-11-20 14:35:44.590508+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335850	2003-11-20 14:53:13+02	2003-11-20 14:35:45.591134+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335851	2003-11-20 14:53:13+02	2003-11-20 14:35:45.7143+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1335852	2003-11-20 14:53:14+02	2003-11-20 14:35:52.509593+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356735	2003-11-21 19:21:32+02	2003-11-21 19:04:13.777161+02	jupiter	3727	chassisd[4445]:	CHASSISD_SNMP_TRAP6:	SNMP trap: Power Supply failed: jnxContentsContainerIndex 2, jnxContentsL1Index 2, jnxContentsL2Index 0, jnxContentsL3Index 0, jnxContentsDescr PEM 1, jnxOperatingState/Temp 6 		100
1352537	2003-11-21 17:43:43+02	2003-11-21 17:26:23.632279+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352538	2003-11-21 17:43:44+02	2003-11-21 17:26:24.649411+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352539	2003-11-21 17:43:44+02	2003-11-21 17:26:24.653211+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352540	2003-11-21 17:43:45+02	2003-11-21 17:26:25.633121+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352541	2003-11-21 17:43:45+02	2003-11-21 17:26:25.646066+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352542	2003-11-21 17:43:45+02	2003-11-21 17:26:25.650627+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352544	2003-11-21 17:43:46+02	2003-11-21 17:26:26.633994+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352545	2003-11-21 17:43:46+02	2003-11-21 17:26:26.64292+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352546	2003-11-21 17:43:46+02	2003-11-21 17:26:26.646754+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352549	2003-11-21 17:43:47+02	2003-11-21 17:26:27.634073+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352550	2003-11-21 17:43:47+02	2003-11-21 17:26:27.691663+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352551	2003-11-21 17:43:47+02	2003-11-21 17:26:27.695433+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352553	2003-11-21 17:43:48+02	2003-11-21 17:26:28.651845+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352552	2003-11-21 17:43:48+02	2003-11-21 17:26:28.63466+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352555	2003-11-21 17:43:49+02	2003-11-21 17:26:34.077936+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313733	2003-11-19 17:36:44+02	2003-11-19 17:36:44.610007+02	ganymede	3731	/kernel:	pfe_listener_disconnect:	conn dropped: listener idx=16, tnpaddr=301989898		10
1313732	2003-11-19 17:36:44+02	2003-11-19 17:36:44.603601+02	ganymede	3731	/kernel:	peer_inputs:	soreceive() error 50		500
1336014	2003-11-20 14:58:08+02	2003-11-20 14:40:40.777441+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336017	2003-11-20 14:58:09+02	2003-11-20 14:40:41.790584+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336016	2003-11-20 14:58:09+02	2003-11-20 14:40:41.777996+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336018	2003-11-20 14:58:10+02	2003-11-20 14:40:42.779167+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336020	2003-11-20 14:58:10+02	2003-11-20 14:40:42.804425+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336019	2003-11-20 14:58:10+02	2003-11-20 14:40:42.80065+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336022	2003-11-20 14:58:11+02	2003-11-20 14:40:43.780438+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336023	2003-11-20 14:58:11+02	2003-11-20 14:40:43.797636+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336024	2003-11-20 14:58:11+02	2003-11-20 14:40:43.908801+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336027	2003-11-20 14:58:12+02	2003-11-20 14:40:44.792155+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336028	2003-11-20 14:58:12+02	2003-11-20 14:40:44.795974+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336026	2003-11-20 14:58:12+02	2003-11-20 14:40:44.779539+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336029	2003-11-20 14:58:13+02	2003-11-20 14:40:45.779955+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336030	2003-11-20 14:58:13+02	2003-11-20 14:40:45.788084+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336032	2003-11-20 14:58:14+02	2003-11-20 14:40:52.640002+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355936	2003-11-21 18:45:14+02	2003-11-21 18:45:17.623696+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1355929	2003-11-21 18:45:14+02	2003-11-21 18:45:17.43555+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355926	2003-11-21 18:45:14+02	2003-11-21 18:45:17.420534+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1355949	2003-11-21 18:45:14+02	2003-11-21 18:45:17.808072+02	adrastea	3726	last		message repeated 4 times		10
1355955	2003-11-21 18:45:14+02	2003-11-21 18:45:17.948253+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1355962	2003-11-21 18:45:14+02	2003-11-21 18:45:18.133559+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1355957	2003-11-21 18:45:14+02	2003-11-21 18:45:17.999317+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1355937	2003-11-21 18:45:14+02	2003-11-21 18:45:17.639042+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1355961	2003-11-21 18:45:14+02	2003-11-21 18:45:18.018255+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1355956	2003-11-21 18:45:14+02	2003-11-21 18:45:17.995418+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1355970	2003-11-21 18:45:14+02	2003-11-21 18:45:18.184247+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1355964	2003-11-21 18:45:14+02	2003-11-21 18:45:18.143924+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1355941	2003-11-21 18:45:14+02	2003-11-21 18:45:17.656921+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1355946	2003-11-21 18:45:14+02	2003-11-21 18:45:17.791133+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[3013]:	exit status 0x100		10
1355958	2003-11-21 18:45:14+02	2003-11-21 18:45:18.003083+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1355959	2003-11-21 18:45:14+02	2003-11-21 18:45:18.007785+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1355960	2003-11-21 18:45:14+02	2003-11-21 18:45:18.014321+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1355939	2003-11-21 18:45:14+02	2003-11-21 18:45:17.646811+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1355940	2003-11-21 18:45:14+02	2003-11-21 18:45:17.653096+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/1) ifd vptree not initialized		10
1355932	2003-11-21 18:45:14+02	2003-11-21 18:45:17.601765+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b3e6fc/32		10
1355942	2003-11-21 18:45:14+02	2003-11-21 18:45:17.77184+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1355972	2003-11-21 18:45:14+02	2003-11-21 18:45:18.304777+02	adrastea	3726	mgd[5181]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1355973	2003-11-21 18:45:14+02	2003-11-21 18:45:18.313866+02	adrastea	3726	mgd[5181]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1355971	2003-11-21 18:45:14+02	2003-11-21 18:45:18.188963+02	adrastea	3726	mgd[5181]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5208, status 0		1
1355943	2003-11-21 18:45:14+02	2003-11-21 18:45:17.777638+02	ganymede	3731	mgd[3015]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 3029, status 0		1
1355984	2003-11-21 18:45:15+02	2003-11-21 18:45:18.470681+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[5178]:	exit status 0x100		10
1355974	2003-11-21 18:45:15+02	2003-11-21 18:45:18.317708+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[5177]:	exit status 0x100		10
1355981	2003-11-21 18:45:15+02	2003-11-21 18:45:18.458877+02	adrastea	3726	mgd[5182]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5212, status 0		1
1355983	2003-11-21 18:45:15+02	2003-11-21 18:45:18.466644+02	adrastea	3726	mgd[5182]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1355982	2003-11-21 18:45:15+02	2003-11-21 18:45:18.462814+02	adrastea	3726	mgd[5182]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1336646	2003-11-20 15:00:00+02	2003-11-20 15:00:00.2101+02	r201	3732	CRON[4740]:		(root) CMD (newsyslog) 		10
1336654	2003-11-20 15:00:00+02	2003-11-20 15:00:00.57769+02	atlas	3730	CRON[2726]:		(root) CMD (newsyslog) 		10
1336648	2003-11-20 15:00:00+02	2003-11-20 15:00:00.304213+02	adrastea	3726	CRON[4984]:		(root) CMD (newsyslog) 		10
1336652	2003-11-20 15:00:00+02	2003-11-20 15:00:00.565572+02	ganymede	3731	CRON[2835]:		(root) CMD (newsyslog) 		10
1336086	2003-11-20 15:00:00+02	2003-11-20 14:42:32.261106+02	jupiter	3727	CRON[7051]:		(root) CMD (newsyslog) 		10
1347123	2003-11-20 20:08:15+02	2003-11-20 19:50:48.829229+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347124	2003-11-20 20:08:16+02	2003-11-20 19:50:49.830808+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347125	2003-11-20 20:08:16+02	2003-11-20 19:50:49.845819+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347126	2003-11-20 20:08:17+02	2003-11-20 19:50:50.830361+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347128	2003-11-20 20:08:17+02	2003-11-20 19:50:50.955737+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347127	2003-11-20 20:08:17+02	2003-11-20 19:50:50.950411+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347131	2003-11-20 20:08:18+02	2003-11-20 19:50:51.841292+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347130	2003-11-20 20:08:18+02	2003-11-20 19:50:51.832128+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347132	2003-11-20 20:08:18+02	2003-11-20 19:50:51.895409+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347136	2003-11-20 20:08:19+02	2003-11-20 19:50:52.855321+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347135	2003-11-20 20:08:19+02	2003-11-20 19:50:52.851505+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347134	2003-11-20 20:08:19+02	2003-11-20 19:50:52.831125+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347139	2003-11-20 20:08:20+02	2003-11-20 19:50:53.847079+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347138	2003-11-20 20:08:20+02	2003-11-20 19:50:53.831805+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347141	2003-11-20 20:08:21+02	2003-11-20 19:51:00.722814+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347775	2003-11-20 20:08:31+02	2003-11-20 20:08:31.924122+02	r201	3732	xntpd[4414]:		offset 0.000390 sec freq 82.664 ppm error 0.000344 poll 6		500
1336674	2003-11-20 15:00:35+02	2003-11-20 15:00:35.773338+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1336675	2003-11-20 15:00:35+02	2003-11-20 15:00:35.886779+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1336673	2003-11-20 15:00:35+02	2003-11-20 15:00:35.756382+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1309099	2003-11-19 17:37:40+02	2003-11-19 17:20:05.349629+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309100	2003-11-19 17:37:41+02	2003-11-19 17:20:06.350679+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309101	2003-11-19 17:37:41+02	2003-11-19 17:20:06.36483+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309109	2003-11-19 17:37:42+02	2003-11-19 17:20:07.351009+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309110	2003-11-19 17:37:42+02	2003-11-19 17:20:07.373987+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309111	2003-11-19 17:37:42+02	2003-11-19 17:20:07.378045+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309114	2003-11-19 17:37:43+02	2003-11-19 17:20:08.371817+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309113	2003-11-19 17:37:43+02	2003-11-19 17:20:08.367985+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309112	2003-11-19 17:37:43+02	2003-11-19 17:20:08.351332+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309124	2003-11-19 17:37:44+02	2003-11-19 17:20:09.389315+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309122	2003-11-19 17:37:44+02	2003-11-19 17:20:09.35743+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309123	2003-11-19 17:37:44+02	2003-11-19 17:20:09.383965+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309125	2003-11-19 17:37:45+02	2003-11-19 17:20:10.352181+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309126	2003-11-19 17:37:45+02	2003-11-19 17:20:10.359695+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1309175	2003-11-19 17:37:46+02	2003-11-19 17:20:19.639707+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314035	2003-11-19 17:37:50+02	2003-11-19 17:37:50.751635+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1314034	2003-11-19 17:37:50+02	2003-11-19 17:37:50.747833+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1314036	2003-11-19 17:37:50+02	2003-11-19 17:37:50.811892+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10869, status 0		1
1336168	2003-11-20 15:03:08+02	2003-11-20 14:45:40.9661+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336170	2003-11-20 15:03:09+02	2003-11-20 14:45:41.987831+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336169	2003-11-20 15:03:09+02	2003-11-20 14:45:41.966781+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336173	2003-11-20 15:03:10+02	2003-11-20 14:45:42.985579+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336174	2003-11-20 15:03:10+02	2003-11-20 14:45:42.989505+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336172	2003-11-20 15:03:10+02	2003-11-20 14:45:42.966372+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336178	2003-11-20 15:03:11+02	2003-11-20 14:45:44.088849+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336176	2003-11-20 15:03:11+02	2003-11-20 14:45:43.967205+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336177	2003-11-20 15:03:11+02	2003-11-20 14:45:44.083668+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336182	2003-11-20 15:03:12+02	2003-11-20 14:45:44.993962+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336181	2003-11-20 15:03:12+02	2003-11-20 14:45:44.99019+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336180	2003-11-20 15:03:12+02	2003-11-20 14:45:44.967257+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336184	2003-11-20 15:03:13+02	2003-11-20 14:45:45.986081+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336183	2003-11-20 15:03:13+02	2003-11-20 14:45:45.967929+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336186	2003-11-20 15:03:14+02	2003-11-20 14:45:52.770482+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1353189	2003-11-21 17:45:07+02	2003-11-21 17:45:07.847524+02	ganymede	3731	mgd[2989]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1353186	2003-11-21 17:45:07+02	2003-11-21 17:45:07.67091+02	ganymede	3731	mgd[2989]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1353190	2003-11-21 17:45:07+02	2003-11-21 17:45:07.950184+02	ganymede	3731	mgd[2989]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show isis database extensive '		1
1353181	2003-11-21 17:45:07+02	2003-11-21 17:45:07.536903+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1353187	2003-11-21 17:45:07+02	2003-11-21 17:45:07.674885+02	ganymede	3731	mgd[2989]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2989]		1
1353182	2003-11-21 17:45:07+02	2003-11-21 17:45:07.647327+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1353185	2003-11-21 17:45:07+02	2003-11-21 17:45:07.665594+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1353183	2003-11-21 17:45:07+02	2003-11-21 17:45:07.654998+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1353184	2003-11-21 17:45:07+02	2003-11-21 17:45:07.660445+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1353188	2003-11-21 17:45:07+02	2003-11-21 17:45:07.748611+02	ganymede	3731	mgd[2989]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1353192	2003-11-21 17:45:08+02	2003-11-21 17:45:08.268794+02	ganymede	3731	mgd[2989]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1353194	2003-11-21 17:45:08+02	2003-11-21 17:45:08.343825+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[2987]:	exit status 0x100		10
1353193	2003-11-21 17:45:08+02	2003-11-21 17:45:08.339524+02	ganymede	3731	mgd[2989]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1353191	2003-11-21 17:45:08+02	2003-11-21 17:45:08.135805+02	ganymede	3731	mgd[2989]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show ospf database extensive '		1
1353229	2003-11-21 17:45:15+02	2003-11-21 17:45:16.11305+02	adrastea	3726	mgd[5143]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [5143]		1
1353201	2003-11-21 17:45:15+02	2003-11-21 17:45:15.611819+02	atlas	3730	login:		login from 172.26.27.115 on ttyp0 as lab		1
1353197	2003-11-21 17:45:15+02	2003-11-21 17:45:15.55377+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1353202	2003-11-21 17:45:15+02	2003-11-21 17:45:15.719423+02	atlas	3730	mgd[2866]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1353236	2003-11-21 17:45:15+02	2003-11-21 17:45:16.248538+02	ganymede	3731	mgd[2992]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1347938	2003-11-20 20:12:43+02	2003-11-20 20:12:43.741052+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1347939	2003-11-20 20:12:43+02	2003-11-20 20:12:43.758996+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1347940	2003-11-20 20:12:43+02	2003-11-20 20:12:43.762755+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1336342	2003-11-20 15:08:09+02	2003-11-20 14:50:41.154336+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336343	2003-11-20 15:08:10+02	2003-11-20 14:50:42.155759+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336344	2003-11-20 15:08:10+02	2003-11-20 14:50:42.17053+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336347	2003-11-20 15:08:11+02	2003-11-20 14:50:43.17016+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336346	2003-11-20 15:08:11+02	2003-11-20 14:50:43.166326+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336345	2003-11-20 15:08:11+02	2003-11-20 14:50:43.155465+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336350	2003-11-20 15:08:12+02	2003-11-20 14:50:44.180154+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336348	2003-11-20 15:08:12+02	2003-11-20 14:50:44.156271+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336349	2003-11-20 15:08:12+02	2003-11-20 14:50:44.176297+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336353	2003-11-20 15:08:13+02	2003-11-20 14:50:45.175914+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336352	2003-11-20 15:08:13+02	2003-11-20 14:50:45.17207+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336351	2003-11-20 15:08:13+02	2003-11-20 14:50:45.156439+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336355	2003-11-20 15:08:14+02	2003-11-20 14:50:46.182068+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336354	2003-11-20 15:08:14+02	2003-11-20 14:50:46.166458+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336358	2003-11-20 15:08:15+02	2003-11-20 14:50:52.900846+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336965	2003-11-20 15:08:31+02	2003-11-20 15:08:31.842492+02	r201	3732	xntpd[4414]:		offset 0.000713 sec freq 82.634 ppm error 0.000182 poll 8		500
1347282	2003-11-20 20:13:15+02	2003-11-20 19:55:48.93906+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347284	2003-11-20 20:13:16+02	2003-11-20 19:55:49.909405+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347285	2003-11-20 20:13:16+02	2003-11-20 19:55:49.922289+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347288	2003-11-20 20:13:17+02	2003-11-20 19:55:50.918113+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347289	2003-11-20 20:13:17+02	2003-11-20 19:55:50.921936+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347287	2003-11-20 20:13:17+02	2003-11-20 19:55:50.909289+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347292	2003-11-20 20:13:18+02	2003-11-20 19:55:51.950163+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347291	2003-11-20 20:13:18+02	2003-11-20 19:55:51.909205+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347293	2003-11-20 20:13:18+02	2003-11-20 19:55:52.064101+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347296	2003-11-20 20:13:19+02	2003-11-20 19:55:52.929806+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347295	2003-11-20 20:13:19+02	2003-11-20 19:55:52.925865+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347294	2003-11-20 20:13:19+02	2003-11-20 19:55:52.910189+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347298	2003-11-20 20:13:20+02	2003-11-20 19:55:53.919469+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347297	2003-11-20 20:13:20+02	2003-11-20 19:55:53.91012+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347302	2003-11-20 20:13:21+02	2003-11-20 19:56:00.853539+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1353235	2003-11-21 17:45:15+02	2003-11-21 17:45:16.244305+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/proc/2307/file'		1
1353203	2003-11-21 17:45:15+02	2003-11-21 17:45:15.724944+02	atlas	3730	mgd[2866]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2866]		1
1353204	2003-11-21 17:45:15+02	2003-11-21 17:45:15.728896+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1353231	2003-11-21 17:45:15+02	2003-11-21 17:45:16.1224+02	atlas	3730	mgd[2866]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1353232	2003-11-21 17:45:15+02	2003-11-21 17:45:16.228451+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/proc/2258/file'		1
1353241	2003-11-21 17:45:15+02	2003-11-21 17:45:16.273208+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1353228	2003-11-21 17:45:15+02	2003-11-21 17:45:16.106203+02	adrastea	3726	mgd[5143]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1353247	2003-11-21 17:45:15+02	2003-11-21 17:45:16.411665+02	adrastea	3726	mgd[5143]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1353205	2003-11-21 17:45:15+02	2003-11-21 17:45:15.734396+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1353251	2003-11-21 17:45:15+02	2003-11-21 17:45:16.429664+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/proc/2244/file'		1
1353208	2003-11-21 17:45:15+02	2003-11-21 17:45:15.750367+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1353249	2003-11-21 17:45:15+02	2003-11-21 17:45:16.419344+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/proc/2255/file'		1
1353248	2003-11-21 17:45:15+02	2003-11-21 17:45:16.415493+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/proc/2259/file', PID 2872, status 0		1
1353244	2003-11-21 17:45:15+02	2003-11-21 17:45:16.392867+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1353253	2003-11-21 17:45:15+02	2003-11-21 17:45:16.598716+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/proc/2260/file'		1
1353200	2003-11-21 17:45:15+02	2003-11-21 17:45:15.606657+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1353238	2003-11-21 17:45:15+02	2003-11-21 17:45:16.258726+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1353240	2003-11-21 17:45:15+02	2003-11-21 17:45:16.268978+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 2869, status 0		1
1353223	2003-11-21 17:45:15+02	2003-11-21 17:45:16.083252+02	atlas	3730	mgd[2866]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1353252	2003-11-21 17:45:15+02	2003-11-21 17:45:16.589755+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/proc/2255/file', PID 2873, status 0		1
1353243	2003-11-21 17:45:15+02	2003-11-21 17:45:16.388978+02	adrastea	3726	mgd[5142]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1353237	2003-11-21 17:45:15+02	2003-11-21 17:45:16.252467+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/proc/2307/file', PID 2868, status 0		1
1353239	2003-11-21 17:45:15+02	2003-11-21 17:45:16.26334+02	r201	3732	mgd[4881]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1353213	2003-11-21 17:45:15+02	2003-11-21 17:45:15.885331+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1353220	2003-11-21 17:45:15+02	2003-11-21 17:45:15.930932+02	ganymede	3731	mgd[2992]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2992]		1
1353222	2003-11-21 17:45:15+02	2003-11-21 17:45:16.077861+02	r201	3732	mgd[4881]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4881]		1
1353221	2003-11-21 17:45:15+02	2003-11-21 17:45:15.968423+02	r201	3732	mgd[4881]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1353234	2003-11-21 17:45:15+02	2003-11-21 17:45:16.239603+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/proc/2258/file', PID 2867, status 0		1
1353214	2003-11-21 17:45:15+02	2003-11-21 17:45:15.893529+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1353242	2003-11-21 17:45:15+02	2003-11-21 17:45:16.383165+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 2870, status 0		1
1353224	2003-11-21 17:45:15+02	2003-11-21 17:45:16.087957+02	ganymede	3731	mgd[2992]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1353210	2003-11-21 17:45:15+02	2003-11-21 17:45:15.761667+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp0 as lab		1
1353212	2003-11-21 17:45:15+02	2003-11-21 17:45:15.878773+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1353209	2003-11-21 17:45:15+02	2003-11-21 17:45:15.756016+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1353246	2003-11-21 17:45:15+02	2003-11-21 17:45:16.407528+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/proc/2259/file'		1
1353207	2003-11-21 17:45:15+02	2003-11-21 17:45:15.744933+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1353225	2003-11-21 17:45:15+02	2003-11-21 17:45:16.091983+02	r201	3732	mgd[4881]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1353245	2003-11-21 17:45:15+02	2003-11-21 17:45:16.402791+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 2871, status 0		1
1353206	2003-11-21 17:45:15+02	2003-11-21 17:45:15.73968+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1353199	2003-11-21 17:45:15+02	2003-11-21 17:45:15.601684+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1353219	2003-11-21 17:45:15+02	2003-11-21 17:45:15.92281+02	ganymede	3731	mgd[2992]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1353198	2003-11-21 17:45:15+02	2003-11-21 17:45:15.5667+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1353218	2003-11-21 17:45:15+02	2003-11-21 17:45:15.91535+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp1 as lab		1
1353216	2003-11-21 17:45:15+02	2003-11-21 17:45:15.90459+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp1		1
1353217	2003-11-21 17:45:15+02	2003-11-21 17:45:15.91137+02	atlas	3730	mgd[2866]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1353211	2003-11-21 17:45:15+02	2003-11-21 17:45:15.770741+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1353215	2003-11-21 17:45:15+02	2003-11-21 17:45:15.8993+02	r201	3732	login:		login from 172.26.27.115 on ttyp0 as lab		1
1353230	2003-11-21 17:45:15+02	2003-11-21 17:45:16.117738+02	adrastea	3726	mgd[5142]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1353233	2003-11-21 17:45:15+02	2003-11-21 17:45:16.233946+02	adrastea	3726	mgd[5143]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1353250	2003-11-21 17:45:15+02	2003-11-21 17:45:16.423226+02	ganymede	3731	mgd[2992]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1353226	2003-11-21 17:45:15+02	2003-11-21 17:45:16.096048+02	adrastea	3726	mgd[5142]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1314796	2003-11-19 17:40:27+02	2003-11-19 17:40:27.235095+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1314798	2003-11-19 17:40:27+02	2003-11-19 17:40:27.447485+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10870, status 0		1
1314797	2003-11-19 17:40:27+02	2003-11-19 17:40:27.241072+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1314799	2003-11-19 17:40:28+02	2003-11-19 17:40:28.140219+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1314800	2003-11-19 17:40:28+02	2003-11-19 17:40:28.154945+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1314801	2003-11-19 17:40:28+02	2003-11-19 17:40:28.357664+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10871, status 0		1
1314824	2003-11-19 17:40:30+02	2003-11-19 17:40:31.200173+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1314823	2003-11-19 17:40:30+02	2003-11-19 17:40:31.092773+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1314828	2003-11-19 17:40:31+02	2003-11-19 17:40:31.980342+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10873, status 0		1
1314825	2003-11-19 17:40:31+02	2003-11-19 17:40:31.307727+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10872, status 0		1
1314827	2003-11-19 17:40:31+02	2003-11-19 17:40:31.782768+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1314826	2003-11-19 17:40:31+02	2003-11-19 17:40:31.760857+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1314829	2003-11-19 17:40:32+02	2003-11-19 17:40:32.444905+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1314830	2003-11-19 17:40:32+02	2003-11-19 17:40:32.465422+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1314831	2003-11-19 17:40:32+02	2003-11-19 17:40:32.658054+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10874, status 0		1
1314841	2003-11-19 17:40:33+02	2003-11-19 17:40:33.440872+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1314842	2003-11-19 17:40:33+02	2003-11-19 17:40:33.444739+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 10875, status 0		1
1314840	2003-11-19 17:40:33+02	2003-11-19 17:40:33.435985+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1314843	2003-11-19 17:40:34+02	2003-11-19 17:40:34.337412+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'exit '		1
1314844	2003-11-19 17:40:34+02	2003-11-19 17:40:34.462199+02	ganymede	3731	mgd[10563]:	UI_DBASE_LOGOUT_EVENT:	User 'lab' exiting configuration mode		1
1314880	2003-11-19 17:40:36+02	2003-11-19 17:40:36.524484+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/proc/4399/file'		1
1314875	2003-11-19 17:40:36+02	2003-11-19 17:40:36.50385+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1314876	2003-11-19 17:40:36+02	2003-11-19 17:40:36.507791+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/proc/4522/file'		1
1314891	2003-11-19 17:40:36+02	2003-11-19 17:40:36.721275+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/proc/4426/file', PID 10883, status 0		1
1314889	2003-11-19 17:40:36+02	2003-11-19 17:40:36.671116+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/proc/4520/file', PID 10882, status 0		1
1314886	2003-11-19 17:40:36+02	2003-11-19 17:40:36.659755+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/proc/4425/file'		1
1314896	2003-11-19 17:40:36+02	2003-11-19 17:40:36.850376+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/proc/4429/file'		1
1314883	2003-11-19 17:40:36+02	2003-11-19 17:40:36.536488+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/proc/4516/file', PID 10879, status 0		1
1314881	2003-11-19 17:40:36+02	2003-11-19 17:40:36.528632+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/proc/4399/file', PID 10878, status 0		1
1314895	2003-11-19 17:40:36+02	2003-11-19 17:40:36.845929+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 10885, status 0		1
1314882	2003-11-19 17:40:36+02	2003-11-19 17:40:36.532682+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/proc/4516/file'		1
1314885	2003-11-19 17:40:36+02	2003-11-19 17:40:36.656019+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 10880, status 0		1
1314884	2003-11-19 17:40:36+02	2003-11-19 17:40:36.650338+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1314894	2003-11-19 17:40:36+02	2003-11-19 17:40:36.840253+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1314892	2003-11-19 17:40:36+02	2003-11-19 17:40:36.724979+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/proc/4409/file'		1
1357391	2003-11-21 19:23:05+02	2003-11-21 19:23:05.728111+02	adrastea	3726	xntpd[2231]:		offset -0.000866 sec freq 76.475 ppm error 0.000787 poll 10		500
1314893	2003-11-19 17:40:36+02	2003-11-19 17:40:36.729227+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/proc/4409/file', PID 10884, status 0		1
1314897	2003-11-19 17:40:36+02	2003-11-19 17:40:36.854326+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/proc/4429/file', PID 10886, status 0		1
1314887	2003-11-19 17:40:36+02	2003-11-19 17:40:36.663461+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/proc/4425/file', PID 10881, status 0		1
1314888	2003-11-19 17:40:36+02	2003-11-19 17:40:36.667183+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/proc/4520/file'		1
1314879	2003-11-19 17:40:36+02	2003-11-19 17:40:36.520642+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/proc/4523/file', PID 10877, status 0		1
1314878	2003-11-19 17:40:36+02	2003-11-19 17:40:36.516211+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/proc/4523/file'		1
1314890	2003-11-19 17:40:36+02	2003-11-19 17:40:36.717459+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/proc/4426/file'		1
1314877	2003-11-19 17:40:36+02	2003-11-19 17:40:36.512385+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/proc/4522/file', PID 10876, status 0		1
1315072	2003-11-19 17:40:38+02	2003-11-19 17:40:48.033292+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1336515	2003-11-20 15:13:09+02	2003-11-20 14:55:41.344312+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336517	2003-11-20 15:13:10+02	2003-11-20 14:55:42.35305+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336516	2003-11-20 15:13:10+02	2003-11-20 14:55:42.344084+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336518	2003-11-20 15:13:11+02	2003-11-20 14:55:43.345032+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336519	2003-11-20 15:13:11+02	2003-11-20 14:55:43.364047+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336520	2003-11-20 15:13:11+02	2003-11-20 14:55:43.371481+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336522	2003-11-20 15:13:12+02	2003-11-20 14:55:44.359681+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336521	2003-11-20 15:13:12+02	2003-11-20 14:55:44.345415+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336523	2003-11-20 15:13:12+02	2003-11-20 14:55:44.363741+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336524	2003-11-20 15:13:13+02	2003-11-20 14:55:45.345572+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336525	2003-11-20 15:13:13+02	2003-11-20 14:55:45.35444+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336526	2003-11-20 15:13:13+02	2003-11-20 14:55:45.358194+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336527	2003-11-20 15:13:14+02	2003-11-20 14:55:46.345275+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336528	2003-11-20 15:13:14+02	2003-11-20 14:55:46.364303+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336531	2003-11-20 15:13:15+02	2003-11-20 14:55:53.031196+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314936	2003-11-19 17:40:39+02	2003-11-19 17:40:39.599964+02	ganymede	3731	mgd[10563]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'request system reboot '		1
1314938	2003-11-19 17:40:40+02	2003-11-19 17:40:40.559886+02	ganymede	3731	mgd[10563]:	UI_CHILD_START:	Starting child '/sbin/shutdown'		1
1314937	2003-11-19 17:40:40+02	2003-11-19 17:40:40.546524+02	ganymede	3731	mgd[10563]:	UI_REBOOT_EVENT:	System rebooted by 'lab'		1
1314947	2003-11-19 17:40:41+02	2003-11-19 17:40:41.232139+02	ganymede	3731	mgd[10563]:	UI_CHILD_STATUS:	Cleanup child '/sbin/shutdown', PID 10887, status 0		1
1314982	2003-11-19 17:40:46+02	2003-11-19 17:40:46.530516+02	ganymede	3731	rpd[4513]:		EVENT Delete mo-0/3/0.16383 index 71 10.0.0.1 -> 10.0.0.19 <Broadcast PointToPoint Multicast>		10
1315060	2003-11-19 17:40:46+02	2003-11-19 17:40:47.715005+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_DOWN:	ifIndex 22, ifAdminStatus up(1), ifOperStatus down(2), ifName ge-1/3/0		10
1315035	2003-11-19 17:40:46+02	2003-11-19 17:40:47.401666+02	ganymede	3731	rpd[4513]:		EVENT Delete fe-1/0/3.0 index 72 11.0.0.2/24 -> 11.0.0.255 <Broadcast Multicast>		10
1315042	2003-11-19 17:40:46+02	2003-11-19 17:40:47.530487+02	ganymede	3731	rpd[4513]:		EVENT Delete so-1/2/0.0 index 73 <Broadcast PointToPoint Multicast>		10
1315026	2003-11-19 17:40:46+02	2003-11-19 17:40:47.217134+02	ganymede	3731	xntpd[10832]:		ntpd exiting on signal 15		1
1315019	2003-11-19 17:40:46+02	2003-11-19 17:40:47.073127+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(73) local_prefix 0xc68bc58e dest_prefix 0xc68bc5a2 dest_plen 30 flags 0x3		10
1314996	2003-11-19 17:40:46+02	2003-11-19 17:40:46.69763+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(77) family 36		10
1314995	2003-11-19 17:40:46+02	2003-11-19 17:40:46.693913+02	ganymede	3731	rpd[4513]:		EVENT Delete so-0/1/0.0 index 68 <Broadcast PointToPoint Multicast>		10
1314997	2003-11-19 17:40:46+02	2003-11-19 17:40:46.701388+02	ganymede	3731	rpd[4513]:		EVENT Delete so-0/1/0.0 index 68 192.3.1.1 -> 192.3.1.1 <Broadcast PointToPoint Multicast>		10
1314993	2003-11-19 17:40:46+02	2003-11-19 17:40:46.68613+02	ganymede	3731	rpd[4513]:		EVENT <Delete> mo-0/3/0.16383 index 71 <Broadcast PointToPoint Multicast>		10
1315068	2003-11-19 17:40:46+02	2003-11-19 17:40:47.913792+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 <Broadcast Multicast>		10
1314987	2003-11-19 17:40:46+02	2003-11-19 17:40:46.553147+02	ganymede	3731	rpd[4513]:	RPD_LAYER2_VC_DOWN:	 Layer-2 VC (VPN : x25_cqt, local-site : 2, remote-site : 1) state changed from UP to Dn		10
1314975	2003-11-19 17:40:46+02	2003-11-19 17:40:46.373368+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(71) local_prefix 0xc687328e dest_prefix 0xc68732a2 dest_plen 32 flags 0x3		10
1315040	2003-11-19 17:40:46+02	2003-11-19 17:40:47.420546+02	ganymede	3731	rpd[4513]:		EVENT Delete so-1/2/0.0 index 73 <Broadcast PointToPoint Multicast>		10
1315010	2003-11-19 17:40:46+02	2003-11-19 17:40:46.907227+02	ganymede	3731	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 1, af 2, run-len 0		10
1314973	2003-11-19 17:40:46+02	2003-11-19 17:40:46.362093+02	ganymede	3731	chassisd[4397]:	CHASSISD_IFDEV_DETACH_FPC:	ifdev_detach(0) 		10
1314988	2003-11-19 17:40:46+02	2003-11-19 17:40:46.557142+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(68) local_prefix 0xc672590e dest_prefix 0xc6725922 dest_plen 30 flags 0x3		10
1315017	2003-11-19 17:40:46+02	2003-11-19 17:40:47.062499+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 156 <Broadcast Multicast>		10
1315006	2003-11-19 17:40:46+02	2003-11-19 17:40:46.890631+02	ganymede	3731	rpd[4513]:		EVENT <Delete> e1-0/0/0.0 index 77 <Broadcast PointToPoint Multicast>		10
1315005	2003-11-19 17:40:46+02	2003-11-19 17:40:46.886764+02	ganymede	3731	rpd[4513]:		EVENT Delete e1-0/0/0.0 index 77 <Broadcast PointToPoint Multicast>		10
1315004	2003-11-19 17:40:46+02	2003-11-19 17:40:46.882759+02	ganymede	3731	eccd[4429]:		SIGTERM received, exiting 		10
1315003	2003-11-19 17:40:46+02	2003-11-19 17:40:46.876236+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> index 144 <Broadcast Multicast> address #0 0.90.69.a0.14.7e		10
1315009	2003-11-19 17:40:46+02	2003-11-19 17:40:46.9025+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 155 <Broadcast Multicast>		10
1315023	2003-11-19 17:40:46+02	2003-11-19 17:40:47.204253+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 145 <Broadcast Multicast> address #0 0.90.69.a0.14.7f		10
1315018	2003-11-19 17:40:46+02	2003-11-19 17:40:47.068047+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 144 <Broadcast Multicast> address #0 0.90.69.a0.14.7e		10
1315020	2003-11-19 17:40:46+02	2003-11-19 17:40:47.078036+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(66) local_prefix 0xc68a8e8e dest_prefix 0 dest_plen 0 flags 0x2		10
1315007	2003-11-19 17:40:46+02	2003-11-19 17:40:46.894359+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 153 <Broadcast Multicast>		10
1315067	2003-11-19 17:40:46+02	2003-11-19 17:40:47.853591+02	r201	3732	rpd[4418]:	RPD_ISIS_ADJDOWN:	IS-IS lost L2 adjacency to ganymede on ge-1/3/0.0, reason: Interface Down		10
1315037	2003-11-19 17:40:46+02	2003-11-19 17:40:47.409255+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 147 <Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1315014	2003-11-19 17:40:46+02	2003-11-19 17:40:47.034662+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(72) family 2		10
1315016	2003-11-19 17:40:46+02	2003-11-19 17:40:47.057342+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> index 147 <Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1315015	2003-11-19 17:40:46+02	2003-11-19 17:40:47.044171+02	ganymede	3731	rpd[4513]:		EVENT UpDown fe-1/0/3.0 index 72 11.0.0.2/24 -> 11.0.0.255 <Broadcast Multicast Localup>		10
1315012	2003-11-19 17:40:46+02	2003-11-19 17:40:47.022303+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(72) local_prefix 0xc686d88e dest_prefix 0xc686d8a2 dest_plen 24 flags 0x3		10
1315021	2003-11-19 17:40:46+02	2003-11-19 17:40:47.087574+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(73) family 2		10
1315034	2003-11-19 17:40:46+02	2003-11-19 17:40:47.397774+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> index 151 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1315043	2003-11-19 17:40:46+02	2003-11-19 17:40:47.536126+02	ganymede	3731	rpd[4513]:		EVENT <Delete> so-1/2/0.0 index 73 <Broadcast PointToPoint Multicast>		10
1315066	2003-11-19 17:40:46+02	2003-11-19 17:40:47.847481+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 86 traps in queue 		2
1315041	2003-11-19 17:40:46+02	2003-11-19 17:40:47.424405+02	ganymede	3731	rpd[4513]:		EVENT Delete so-1/2/0.0 index 73 192.1.1.1 -> 192.1.1.1 <Broadcast PointToPoint Multicast>		10
1314974	2003-11-19 17:40:46+02	2003-11-19 17:40:46.368108+02	ganymede	3731	craftd[4399]:	craftd_user_conn_shutdown:	socket 7, errno = 0 		10
1315032	2003-11-19 17:40:46+02	2003-11-19 17:40:47.350488+02	ganymede	3731	rpd[4513]:	RPD_ISIS_ADJDOWN:	IS-IS lost L2 adjacency to r201 on ge-1/3/0.0, reason: Interface Down		10
1315028	2003-11-19 17:40:46+02	2003-11-19 17:40:47.229253+02	ganymede	3731	rpd[4513]:		EVENT UpDown ge-1/3/0.0 index 74 1.0.0.1/30 -> 1.0.0.3 <Broadcast Multicast Localup>		10
1315027	2003-11-19 17:40:46+02	2003-11-19 17:40:47.220946+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> ge-1/3/0.0 index 74 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1315033	2003-11-19 17:40:46+02	2003-11-19 17:40:47.356185+02	ganymede	3731	rpd[4513]:		EVENT UpDown ge-1/3/0.0 index 74 <Broadcast Multicast>		10
1315029	2003-11-19 17:40:46+02	2003-11-19 17:40:47.233124+02	ganymede	3731	rpd[4513]:	RPD_LDP_NBRDOWN:	LDP neighbor 1.0.0.2 (ge-1/3/0.0) is down		10
1315030	2003-11-19 17:40:46+02	2003-11-19 17:40:47.236851+02	ganymede	3731	rpd[4513]:	RPD_LDP_SESSIONDOWN:	LDP session 10.100.254.23 is down, reason: all adjacencies down		10
1315065	2003-11-19 17:40:46+02	2003-11-19 17:40:47.843707+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 <Broadcast Multicast>		10
1315059	2003-11-19 17:40:46+02	2003-11-19 17:40:47.711279+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 84 traps in queue 		2
1315048	2003-11-19 17:40:46+02	2003-11-19 17:40:47.558376+02	ganymede	3731	rpd[4513]:	bgp_peer_delete:	NOTIFICATION sent to 10.100.254.21 (Internal AS 100): code 6 (Cease) subcode 3 (Peer Unconfigured), Reason: Peer Deletion		10
1315058	2003-11-19 17:40:46+02	2003-11-19 17:40:47.707512+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 83 traps in queue 		2
1315064	2003-11-19 17:40:46+02	2003-11-19 17:40:47.839903+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 85 traps in queue 		2
1315047	2003-11-19 17:40:46+02	2003-11-19 17:40:47.554578+02	ganymede	3731	rpd[4513]:	RPD_SIGNAL_TERMINATE:	first termination signal received		10
1315057	2003-11-19 17:40:46+02	2003-11-19 17:40:47.70364+02	r201	3732	rpd[4418]:		EVENT <UpDown> ge-1/3/0.0 index 69 <Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1315062	2003-11-19 17:40:46+02	2003-11-19 17:40:47.830524+02	r201	3732	rpd[4418]:	RPD_LDP_NBRDOWN:	LDP neighbor 1.0.0.1 (ge-1/3/0.0) is down		10
1315022	2003-11-19 17:40:46+02	2003-11-19 17:40:47.200403+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(73) family 7		10
1314980	2003-11-19 17:40:46+02	2003-11-19 17:40:46.400843+02	ganymede	3731	rpd[4513]:		EVENT UpDown mo-0/3/0.16383 index 71 10.0.0.1 -> 10.0.0.19 <Broadcast PointToPoint Multicast Localup>		10
1315061	2003-11-19 17:40:46+02	2003-11-19 17:40:47.71873+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 1.0.0.2/30 -> 1.0.0.3 <Broadcast Multicast Localup>		10
1314992	2003-11-19 17:40:46+02	2003-11-19 17:40:46.680539+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(68) family 7		10
1315031	2003-11-19 17:40:46+02	2003-11-19 17:40:47.240604+02	ganymede	3731	rpd[4513]:		EVENT UpDown ge-1/3/0.0 index 74 <Broadcast Multicast>		10
1314977	2003-11-19 17:40:46+02	2003-11-19 17:40:46.385529+02	ganymede	3731	mib2d[4512]:	SNMP_TRAP_LINK_DOWN:	ifIndex 60, ifAdminStatus up(1), ifOperStatus down(2), ifName mo-0/3/0		10
1314976	2003-11-19 17:40:46+02	2003-11-19 17:40:46.378216+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(65) local_prefix 0xc672660e dest_prefix 0 dest_plen 0 flags 0x2		10
1315001	2003-11-19 17:40:46+02	2003-11-19 17:40:46.759738+02	ganymede	3731	fsad[4427]:	FSAD_TERMINATING_SIGNAL:	Received terminating signal Terminated; preparing to clean up		10
1314981	2003-11-19 17:40:46+02	2003-11-19 17:40:46.404662+02	ganymede	3731	rpd[4513]:		EVENT <UpDown MTU> index 143 <Broadcast Multicast>		10
1315000	2003-11-19 17:40:46+02	2003-11-19 17:40:46.755931+02	ganymede	3731	rpd[4513]:		EVENT <Delete> so-0/1/0.0 index 68 <Broadcast PointToPoint Multicast>		10
1314989	2003-11-19 17:40:46+02	2003-11-19 17:40:46.560923+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> index 153 <Broadcast Multicast>		10
1314979	2003-11-19 17:40:46+02	2003-11-19 17:40:46.395224+02	ganymede	3731	rpd[4513]:		EVENT UpDown mo-0/3/0.16383 index 71 <Broadcast PointToPoint Multicast>		10
1314990	2003-11-19 17:40:46+02	2003-11-19 17:40:46.564635+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(68) family 2		10
1314991	2003-11-19 17:40:46+02	2003-11-19 17:40:46.570505+02	ganymede	3731	rpd[4513]:		EVENT Delete mo-0/3/0.16383 index 71 <Broadcast PointToPoint Multicast>		10
1315036	2003-11-19 17:40:46+02	2003-11-19 17:40:47.405399+02	ganymede	3731	rpd[4513]:		EVENT <Delete> fe-1/0/3.0 index 72 <Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1315011	2003-11-19 17:40:46+02	2003-11-19 17:40:46.913312+02	ganymede	3731	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 2, af 2, run-len 0		10
1314999	2003-11-19 17:40:46+02	2003-11-19 17:40:46.70902+02	ganymede	3731	rpd[4513]:		EVENT Delete so-0/1/0.0 index 68 <Broadcast PointToPoint Multicast>		10
1314998	2003-11-19 17:40:46+02	2003-11-19 17:40:46.705092+02	ganymede	3731	chassisd[4397]:	CHASSISD_IFDEV_DETACH_FPC:	ifdev_detach(1) 		10
1314986	2003-11-19 17:40:46+02	2003-11-19 17:40:46.547449+02	ganymede	3731	rpd[4513]:		EVENT UpDown e1-0/0/0.0 index 77 <Broadcast PointToPoint Multicast>		10
1315063	2003-11-19 17:40:46+02	2003-11-19 17:40:47.836116+02	r201	3732	rpd[4418]:	RPD_LDP_SESSIONDOWN:	LDP session 10.100.254.20 is down, reason: all adjacencies down		10
1315025	2003-11-19 17:40:46+02	2003-11-19 17:40:47.211961+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 146 <Broadcast Multicast> address #0 0.90.69.a0.14.80		10
1315002	2003-11-19 17:40:46+02	2003-11-19 17:40:46.870504+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 152 <Broadcast Multicast>		10
1314972	2003-11-19 17:40:46+02	2003-11-19 17:40:46.23932+02	ganymede	3731	shutdown:		reboot by root: 		10
1315044	2003-11-19 17:40:46+02	2003-11-19 17:40:47.541033+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 150 <Broadcast Multicast>		10
1315045	2003-11-19 17:40:46+02	2003-11-19 17:40:47.544897+02	ganymede	3731	rpd[4513]:	RPD_SNMP_SARECV:	snmp_epi_recv: error from sam_recv: 0		500
1314978	2003-11-19 17:40:46+02	2003-11-19 17:40:46.390089+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> mo-0/3/0.16383 index 71 <Broadcast PointToPoint Multicast>		10
1315038	2003-11-19 17:40:46+02	2003-11-19 17:40:47.413092+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 148 <Broadcast Multicast> address #0 0.90.69.a0.14.9d		10
1315024	2003-11-19 17:40:46+02	2003-11-19 17:40:47.207998+02	ganymede	3731	chassisd[4397]:	CHASSISD_IFDEV_DETACH_ALL_PSEUDO:	ifdev_detach(pseudo devices: all) 		10
1314983	2003-11-19 17:40:46+02	2003-11-19 17:40:46.536261+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(71) family 2		10
1315039	2003-11-19 17:40:46+02	2003-11-19 17:40:47.416821+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 149 <Broadcast Multicast> address #0 0.90.69.a0.14.9e		10
1315008	2003-11-19 17:40:46+02	2003-11-19 17:40:46.898063+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 154 <Broadcast Multicast>		10
1314984	2003-11-19 17:40:46+02	2003-11-19 17:40:46.54001+02	ganymede	3731	feb		Monitor IPC 0.3: passing loopback (Disable) to MIPS. 		10
1315069	2003-11-19 17:40:46+02	2003-11-19 17:40:47.918472+02	r201	3732	rpd[4418]:		EVENT <UpDown> index 136 <Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1315013	2003-11-19 17:40:46+02	2003-11-19 17:40:47.029628+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> fe-1/0/3.0 index 72 <Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1314985	2003-11-19 17:40:46+02	2003-11-19 17:40:46.54373+02	ganymede	3731	rpd[4513]:		EVENT <UpDown> e1-0/0/0.0 index 77 <Broadcast PointToPoint Multicast>		10
1314994	2003-11-19 17:40:46+02	2003-11-19 17:40:46.690066+02	ganymede	3731	rpd[4513]:		EVENT <Delete> index 143 <Broadcast Multicast>		10
1315076	2003-11-19 17:40:47+02	2003-11-19 17:40:48.106967+02	atlas	3730	/kernel:	e1-0/0/0:	received CCC status, setting CCC-Down		10
1315071	2003-11-19 17:40:47+02	2003-11-19 17:40:47.926254+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 88 traps in queue 		2
1315074	2003-11-19 17:40:47+02	2003-11-19 17:40:48.043599+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 22 traps in queue 		2
1315073	2003-11-19 17:40:47+02	2003-11-19 17:40:48.039819+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 21 traps in queue 		2
1315077	2003-11-19 17:40:47+02	2003-11-19 17:40:48.113062+02	atlas	3730	rpd[4413]:	RPD_LAYER2_VC_DOWN:	 Layer-2 VC (VPN : x25_cqt, local-site : 1, remote-site : 2) state changed from UP to DELETED		10
1353227	2003-11-21 17:45:15+02	2003-11-21 17:45:16.10208+02	adrastea	3726	mgd[5142]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [5142]		1
1353329	2003-11-21 17:45:16+02	2003-11-21 17:45:18.159233+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1353355	2003-11-21 17:45:16+02	2003-11-21 17:45:19.05825+02	adrastea	3726	mgd[5142]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1353381	2003-11-21 17:45:16+02	2003-11-21 17:45:19.591225+02	adrastea	3726	mgd[5142]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1353356	2003-11-21 17:45:16+02	2003-11-21 17:45:19.065821+02	r201	3732	mgd[4881]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1353315	2003-11-21 17:45:16+02	2003-11-21 17:45:17.842711+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/proc/2243/file', PID 3001, status 0		1
1353373	2003-11-21 17:45:16+02	2003-11-21 17:45:19.534539+02	r201	3732	mgd[4881]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1353341	2003-11-21 17:45:16+02	2003-11-21 17:45:18.484892+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 5158, status 0		1
1353390	2003-11-21 17:45:16+02	2003-11-21 17:45:19.754141+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1353333	2003-11-21 17:45:16+02	2003-11-21 17:45:18.435795+02	ganymede	3731	mgd[2992]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1353351	2003-11-21 17:45:16+02	2003-11-21 17:45:18.868754+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 5163, status 0		1
1353327	2003-11-21 17:45:16+02	2003-11-21 17:45:18.125954+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1353261	2003-11-21 17:45:16+02	2003-11-21 17:45:16.687565+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1353324	2003-11-21 17:45:16+02	2003-11-21 17:45:18.112812+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1353303	2003-11-21 17:45:16+02	2003-11-21 17:45:17.641665+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4891, status 0		1
1353339	2003-11-21 17:45:16+02	2003-11-21 17:45:18.469726+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1353285	2003-11-21 17:45:16+02	2003-11-21 17:45:17.201071+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1353350	2003-11-21 17:45:16+02	2003-11-21 17:45:18.861794+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1353297	2003-11-21 17:45:16+02	2003-11-21 17:45:17.401966+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/proc/4433/file'		1
1353257	2003-11-21 17:45:16+02	2003-11-21 17:45:16.66898+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/proc/2257/file'		1
1353291	2003-11-21 17:45:16+02	2003-11-21 17:45:17.262804+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/proc/4431/file', PID 4888, status 0		1
1353282	2003-11-21 17:45:16+02	2003-11-21 17:45:17.129602+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/proc/2234/file', PID 2996, status 0		1
1353275	2003-11-21 17:45:16+02	2003-11-21 17:45:16.981161+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/proc/4424/file'		1
1353300	2003-11-21 17:45:16+02	2003-11-21 17:45:17.472609+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1353302	2003-11-21 17:45:16+02	2003-11-21 17:45:17.598842+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1353347	2003-11-21 17:45:16+02	2003-11-21 17:45:18.839903+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1353284	2003-11-21 17:45:16+02	2003-11-21 17:45:17.189992+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/proc/4438/file'		1
1353346	2003-11-21 17:45:16+02	2003-11-21 17:45:18.834223+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 5161, status 0		1
1353283	2003-11-21 17:45:16+02	2003-11-21 17:45:17.184187+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4886, status 0		1
1353365	2003-11-21 17:45:16+02	2003-11-21 17:45:19.232199+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4893, status 0		1
1353340	2003-11-21 17:45:16+02	2003-11-21 17:45:18.473915+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1353343	2003-11-21 17:45:16+02	2003-11-21 17:45:18.607545+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1353357	2003-11-21 17:45:16+02	2003-11-21 17:45:19.071465+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 5165, status 0		1
1353345	2003-11-21 17:45:16+02	2003-11-21 17:45:18.822514+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 5160, status 0		1
1353323	2003-11-21 17:45:16+02	2003-11-21 17:45:18.104854+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1353304	2003-11-21 17:45:16+02	2003-11-21 17:45:17.649698+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1353342	2003-11-21 17:45:16+02	2003-11-21 17:45:18.600485+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 5159, status 0		1
1353255	2003-11-21 17:45:16+02	2003-11-21 17:45:16.655187+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/proc/2263/file'		1
1353258	2003-11-21 17:45:16+02	2003-11-21 17:45:16.672986+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/proc/2263/file', PID 2994, status 0		1
1353325	2003-11-21 17:45:16+02	2003-11-21 17:45:18.116764+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 5152, status 0		1
1353321	2003-11-21 17:45:16+02	2003-11-21 17:45:17.924304+02	r201	3732	mgd[4881]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1353289	2003-11-21 17:45:16+02	2003-11-21 17:45:17.249992+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 5146, status 0		1
1353254	2003-11-21 17:45:16+02	2003-11-21 17:45:16.603099+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/proc/2244/file', PID 2993, status 0		1
1353380	2003-11-21 17:45:16+02	2003-11-21 17:45:19.587232+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353391	2003-11-21 17:45:16+02	2003-11-21 17:45:19.765877+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc38f5ffc/32		10
1315329	2003-11-19 17:43:33+02	2003-11-19 17:43:34.08175+02	ganymede	3731	/kernel:		setting ldconfig path: /usr/lib		10
1353277	2003-11-21 17:45:16+02	2003-11-21 17:45:16.991214+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/proc/2224/file', PID 2995, status 0		1
1353270	2003-11-21 17:45:16+02	2003-11-21 17:45:16.834638+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/proc/2224/file'		1
1353349	2003-11-21 17:45:16+02	2003-11-21 17:45:18.854492+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 5162, status 0		1
1353360	2003-11-21 17:45:16+02	2003-11-21 17:45:19.096076+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 5166, status 0		1
1353387	2003-11-21 17:45:16+02	2003-11-21 17:45:19.725777+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1315070	2003-11-19 17:40:47+02	2003-11-19 17:40:47.922372+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 87 traps in queue 		2
1315113	2003-11-19 17:40:50+02	2003-11-19 17:40:51.143605+02	ganymede	3731	init:		pfe (PID 4405) exited with status=0 Normal Exit		10
1315118	2003-11-19 17:40:50+02	2003-11-19 17:40:51.219158+02	ganymede	3731	init:		craft-control (PID 4399) exited with status=0 Normal Exit		10
1315115	2003-11-19 17:40:50+02	2003-11-19 17:40:51.152719+02	ganymede	3731	init:		inet-process (PID 4403) exited with status=0 Normal Exit		10
1315095	2003-11-19 17:40:50+02	2003-11-19 17:40:50.775443+02	ganymede	3731	init:		ipsec-key-management (PID 4519) exited with status=0 Normal Exit		10
1315088	2003-11-19 17:40:50+02	2003-11-19 17:40:50.54481+02	ganymede	3731	/kernel:		rdp retransmit error: Network is down (50) src 1:1020 dest 2:16385		500
1315117	2003-11-19 17:40:50+02	2003-11-19 17:40:51.215394+02	ganymede	3731	init:		management (PID 4401) exited with status=0 Normal Exit		10
1315116	2003-11-19 17:40:50+02	2003-11-19 17:40:51.156656+02	ganymede	3731	init:		snmp (PID 4402) exited with status=0 Normal Exit		10
1315094	2003-11-19 17:40:50+02	2003-11-19 17:40:50.681709+02	ganymede	3731	init:		remote-hello (PID 4520) exited with status=0 Normal Exit		10
1315119	2003-11-19 17:40:50+02	2003-11-19 17:40:51.224213+02	ganymede	3731	init:		alarm-control (PID 4398) exited with status=0 Normal Exit		10
1315092	2003-11-19 17:40:50+02	2003-11-19 17:40:50.673494+02	ganymede	3731	init:		firewall (PID 4522) exited with status=0 Normal Exit		10
1315112	2003-11-19 17:40:50+02	2003-11-19 17:40:51.139896+02	ganymede	3731	init:		remote-operations (PID 4406) exited with status=0 Normal Exit		10
1315085	2003-11-19 17:40:50+02	2003-11-19 17:40:50.374166+02	ganymede	3731	/kernel:	fxp1:	link media DOWN 10Mb / half-duplex		10
1315093	2003-11-19 17:40:50+02	2003-11-19 17:40:50.677476+02	ganymede	3731	init:		link-management (PID 4521) exited with status=0 Normal Exit		10
1315108	2003-11-19 17:40:50+02	2003-11-19 17:40:51.019619+02	ganymede	3731	init:		internal-routing-service (PID 4425) exited with status=0 Normal Exit		10
1315100	2003-11-19 17:40:50+02	2003-11-19 17:40:50.980507+02	ganymede	3731	init:		sonet-aps (PID 4514) exited with status=0 Normal Exit		10
1315101	2003-11-19 17:40:50+02	2003-11-19 17:40:50.986069+02	ganymede	3731	init:		mib-process (PID 4512) exited with status=0 Normal Exit		10
1315099	2003-11-19 17:40:50+02	2003-11-19 17:40:50.874338+02	ganymede	3731	init:		vrrp (PID 4515) exited with status=0 Normal Exit		10
1315098	2003-11-19 17:40:50+02	2003-11-19 17:40:50.858214+02	ganymede	3731	init:		sampling (PID 4516) exited with status=0 Normal Exit		10
1315091	2003-11-19 17:40:50+02	2003-11-19 17:40:50.666599+02	ganymede	3731	init:		interface-control (PID 4523) exited with status=0 Normal Exit		10
1315122	2003-11-19 17:40:50+02	2003-11-19 17:40:51.341139+02	ganymede	3731	init:		watchdog (PID 4394) exited with status=0 Normal Exit		10
1315086	2003-11-19 17:40:50+02	2003-11-19 17:40:50.383381+02	ganymede	3731	/kernel:		rdp retransmit error: Network is down (50) src 1:1020 dest 2:16385		500
1315090	2003-11-19 17:40:50+02	2003-11-19 17:40:50.660896+02	ganymede	3731	init:		ntp (PID 10832) exited with status=0 Normal Exit		10
1315107	2003-11-19 17:40:50+02	2003-11-19 17:40:51.013327+02	ganymede	3731	init:		routing-socket-proxy (PID 4426) exited with status=0 Normal Exit		10
1315103	2003-11-19 17:40:50+02	2003-11-19 17:40:50.994468+02	ganymede	3731	init:		neighbor-liveness (PID 4430) exited with status=0 Normal Exit		10
1315104	2003-11-19 17:40:50+02	2003-11-19 17:40:51.000492+02	ganymede	3731	init:		ecc-error-logging (PID 4429) exited with status=0 Normal Exit		500
1315102	2003-11-19 17:40:50+02	2003-11-19 17:40:50.99052+02	ganymede	3731	init:		pgm (PID 4431) exited with status=0 Normal Exit		10
1315121	2003-11-19 17:40:50+02	2003-11-19 17:40:51.33733+02	ganymede	3731	init:		tnp-process (PID 4395) exited with status=0 Normal Exit		10
1315111	2003-11-19 17:40:50+02	2003-11-19 17:40:51.136155+02	ganymede	3731	init:		network-access (PID 4407) exited with status=0 Normal Exit		10
1315109	2003-11-19 17:40:50+02	2003-11-19 17:40:51.02337+02	ganymede	3731	init:		disk-monitoring (PID 4409) exited with status=0 Normal Exit		10
1315120	2003-11-19 17:40:50+02	2003-11-19 17:40:51.331553+02	ganymede	3731	init:		chassis-control (PID 4397) exited with status=0 Normal Exit		10
1315110	2003-11-19 17:40:50+02	2003-11-19 17:40:51.130571+02	ganymede	3731	init:		helper (PID 4408) exited with status=0 Normal Exit		10
1315114	2003-11-19 17:40:50+02	2003-11-19 17:40:51.147305+02	ganymede	3731	init:		sntp (PID 4404) exited with status=0 Normal Exit		10
1315096	2003-11-19 17:40:50+02	2003-11-19 17:40:50.796098+02	ganymede	3731	init:		class-of-service (PID 4518) exited with status=0 Normal Exit		10
1315106	2003-11-19 17:40:50+02	2003-11-19 17:40:51.00826+02	ganymede	3731	init:		pic-services-logging (PID 4427) exited with status=0 Normal Exit		10
1315105	2003-11-19 17:40:50+02	2003-11-19 17:40:51.004477+02	ganymede	3731	init:		adaptive-services (PID 4428) exited with status=0 Normal Exit		10
1315097	2003-11-19 17:40:50+02	2003-11-19 17:40:50.840919+02	ganymede	3731	init:		ilmi (PID 4517) exited with status=0 Normal Exit		10
1315133	2003-11-19 17:40:52+02	2003-11-19 17:40:52.465715+02	ganymede	3731	/kernel:	peer_inputs:	soreceive() error 64		500
1315136	2003-11-19 17:40:52+02	2003-11-19 17:40:52.480651+02	ganymede	3731	/kernel:	TNP:	version is changing to 2		10
1315134	2003-11-19 17:40:52+02	2003-11-19 17:40:52.472819+02	ganymede	3731	/kernel:	pfe_listener_disconnect:	conn dropped: listener idx=0, tnpaddr=2		10
1315135	2003-11-19 17:40:52+02	2003-11-19 17:40:52.476841+02	ganymede	3731	/kernel:	TNP:	deleting neighbor 2 from interface fxp1.		10
1315132	2003-11-19 17:40:52+02	2003-11-19 17:40:52.459641+02	ganymede	3731	/kernel:		rdp keepalive expired, connection dropped - src 1:1020 dest 2:16385		10
1315130	2003-11-19 17:40:52+02	2003-11-19 17:40:52.442956+02	ganymede	3731	/kernel:		rdp retransmit error: Network is down (50) src 1:1020 dest 2:16385		500
1315138	2003-11-19 17:40:52+02	2003-11-19 17:40:52.488107+02	ganymede	3731	pccardd[4237]:		pccardd terminated: signal 15 received		10
1315137	2003-11-19 17:40:52+02	2003-11-19 17:40:52.48439+02	ganymede	3731	rpd[4513]:	RPD_SIGNAL_TERMINATE:	second termination signal received		10
1315142	2003-11-19 17:40:56+02	2003-11-19 17:40:56.289972+02	ganymede	3731	rpd[4513]:	RPD_EXIT:	Exit rpd[4513] version 6.1R1.4 built by builder on 2003-10-09 20:28:45 UTC, caller 80a16c6		10
1315143	2003-11-19 17:40:56+02	2003-11-19 17:40:56.326296+02	ganymede	3731	syslogd:		exiting on signal 14		10
1315149	2003-11-19 17:41:14+02	2003-11-19 17:41:14.174909+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1315161	2003-11-19 17:41:47+02	2003-11-19 17:41:47.392799+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 23 traps in queue 		2
1315160	2003-11-19 17:41:47+02	2003-11-19 17:41:47.379436+02	atlas	3730	rpd[4413]:	bgp_traffic_timeout:	NOTIFICATION sent to 10.100.254.20 (Internal AS 100): code 4 (Hold Timer Expired Error), Reason: holdtime expired for 10.100.254.20 (Internal AS 100)		10
1315162	2003-11-19 17:41:47+02	2003-11-19 17:41:47.396554+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 24 traps in queue 		2
1315196	2003-11-19 17:42:19+02	2003-11-19 17:42:19.541913+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 28 traps in queue 		2
1315195	2003-11-19 17:42:19+02	2003-11-19 17:42:19.538157+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 27 traps in queue 		2
1315194	2003-11-19 17:42:19+02	2003-11-19 17:42:19.532453+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 26 traps in queue 		2
1315193	2003-11-19 17:42:19+02	2003-11-19 17:42:19.420556+02	atlas	3730	rpd[4413]:	bgp_connect_start:	connect 10.100.254.20 (Internal AS 100): No route to host		10
1315192	2003-11-19 17:42:19+02	2003-11-19 17:42:19.416213+02	atlas	3730	rpd[4413]:	task_connect:	task BGP_100.10.100.254.20+179 addr 10.100.254.20+179: No route to host		10
1315191	2003-11-19 17:42:19+02	2003-11-19 17:42:19.39312+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 25 traps in queue 		2
1310317	2003-11-19 17:42:40+02	2003-11-19 17:25:05.423373+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310320	2003-11-19 17:42:41+02	2003-11-19 17:25:06.440182+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310319	2003-11-19 17:42:41+02	2003-11-19 17:25:06.4248+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310331	2003-11-19 17:42:42+02	2003-11-19 17:25:07.432425+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310330	2003-11-19 17:42:42+02	2003-11-19 17:25:07.424651+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310332	2003-11-19 17:42:42+02	2003-11-19 17:25:07.474987+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310333	2003-11-19 17:42:43+02	2003-11-19 17:25:08.4247+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310334	2003-11-19 17:42:43+02	2003-11-19 17:25:08.445154+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310335	2003-11-19 17:42:43+02	2003-11-19 17:25:08.450667+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310345	2003-11-19 17:42:44+02	2003-11-19 17:25:09.441841+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310344	2003-11-19 17:42:44+02	2003-11-19 17:25:09.425575+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310346	2003-11-19 17:42:44+02	2003-11-19 17:25:09.547965+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310348	2003-11-19 17:42:45+02	2003-11-19 17:25:10.426549+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310349	2003-11-19 17:42:45+02	2003-11-19 17:25:10.436876+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1310406	2003-11-19 17:42:46+02	2003-11-19 17:25:19.77+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315222	2003-11-19 17:42:51+02	2003-11-19 17:42:51.542295+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 32 traps in queue 		2
1315221	2003-11-19 17:42:51+02	2003-11-19 17:42:51.437055+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 31 traps in queue 		2
1315220	2003-11-19 17:42:51+02	2003-11-19 17:42:51.433316+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 30 traps in queue 		2
1315217	2003-11-19 17:42:51+02	2003-11-19 17:42:51.407982+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 29 traps in queue 		2
1315219	2003-11-19 17:42:51+02	2003-11-19 17:42:51.428925+02	atlas	3730	rpd[4413]:	bgp_connect_start:	connect 10.100.254.20 (Internal AS 100): No route to host		10
1315218	2003-11-19 17:42:51+02	2003-11-19 17:42:51.424673+02	atlas	3730	rpd[4413]:	task_connect:	task BGP_100.10.100.254.20+179 addr 10.100.254.20+179: No route to host		10
1315293	2003-11-19 17:43:23+02	2003-11-19 17:43:23.436263+02	atlas	3730	rpd[4413]:	bgp_connect_start:	connect 10.100.254.20 (Internal AS 100): No route to host		10
1336685	2003-11-20 15:18:09+02	2003-11-20 15:00:41.53152+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336688	2003-11-20 15:18:10+02	2003-11-20 15:00:42.549024+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336687	2003-11-20 15:18:10+02	2003-11-20 15:00:42.533272+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336689	2003-11-20 15:18:11+02	2003-11-20 15:00:43.191403+02	jupiter	3727	chassisd[4445]:	CHASSISD_SNMP_TRAP6:	SNMP trap: Power Supply failed: jnxContentsContainerIndex 2, jnxContentsL1Index 2, jnxContentsL2Index 0, jnxContentsL3Index 0, jnxContentsDescr PEM 1, jnxOperatingState/Temp 6 		100
1336690	2003-11-20 15:18:11+02	2003-11-20 15:00:43.532798+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336692	2003-11-20 15:18:11+02	2003-11-20 15:00:43.548604+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336691	2003-11-20 15:18:11+02	2003-11-20 15:00:43.54474+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336695	2003-11-20 15:18:12+02	2003-11-20 15:00:44.664609+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336694	2003-11-20 15:18:12+02	2003-11-20 15:00:44.658769+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336693	2003-11-20 15:18:12+02	2003-11-20 15:00:44.533596+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336697	2003-11-20 15:18:13+02	2003-11-20 15:00:45.539673+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336696	2003-11-20 15:18:13+02	2003-11-20 15:00:45.533684+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336698	2003-11-20 15:18:13+02	2003-11-20 15:00:45.543489+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336701	2003-11-20 15:18:14+02	2003-11-20 15:00:46.540481+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336700	2003-11-20 15:18:14+02	2003-11-20 15:00:46.534239+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336704	2003-11-20 15:18:15+02	2003-11-20 15:00:53.161571+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347483	2003-11-20 20:18:15+02	2003-11-20 20:00:48.981217+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315291	2003-11-19 17:43:23+02	2003-11-19 17:43:23.418278+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 33 traps in queue 		2
1315296	2003-11-19 17:43:23+02	2003-11-19 17:43:23.448208+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 36 traps in queue 		2
1315292	2003-11-19 17:43:23+02	2003-11-19 17:43:23.432278+02	atlas	3730	rpd[4413]:	task_connect:	task BGP_100.10.100.254.20+179 addr 10.100.254.20+179: No route to host		10
1315295	2003-11-19 17:43:23+02	2003-11-19 17:43:23.444397+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 35 traps in queue 		2
1315294	2003-11-19 17:43:23+02	2003-11-19 17:43:23.440641+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 34 traps in queue 		2
1315331	2003-11-19 17:43:33+02	2003-11-19 17:43:34.199743+02	ganymede	3731	/kernel:		cron		10
1315325	2003-11-19 17:43:33+02	2003-11-19 17:43:33.926416+02	ganymede	3731	ntpdate[2170]:		step time server 172.26.27.3 offset -12.990889 sec		10
1315326	2003-11-19 17:43:33+02	2003-11-19 17:43:34.067799+02	ganymede	3731	/kernel:		.		10
1315330	2003-11-19 17:43:33+02	2003-11-19 17:43:34.193968+02	ganymede	3731	/kernel:		starting standard daemons:		10
1315323	2003-11-19 17:43:33+02	2003-11-19 17:43:33.918739+02	ganymede	3731	/kernel:	TNP:	version is changing to 1		10
1315322	2003-11-19 17:43:33+02	2003-11-19 17:43:33.914995+02	ganymede	3731	/kernel:	fxp1:	link media UP 100Mb / full-duplex		10
1315328	2003-11-19 17:43:33+02	2003-11-19 17:43:34.077933+02	ganymede	3731	/kernel:		.		10
1315327	2003-11-19 17:43:33+02	2003-11-19 17:43:34.074051+02	ganymede	3731	/kernel:		Starting final network daemons:		10
1315332	2003-11-19 17:43:33+02	2003-11-19 17:43:34.203556+02	ganymede	3731	cron[2185]:		(CRON) STARTUP (fork ok) 		10
1315324	2003-11-19 17:43:33+02	2003-11-19 17:43:33.922586+02	ganymede	3731	/kernel:	TNP:	adding neighbor 2 to interface fxp1.		10
1315321	2003-11-19 17:43:33+02	2003-11-19 17:43:33.895235+02	ganymede	3731	/kernel:	fxp0:	link media UP 100Mb / full-duplex		10
1315365	2003-11-19 17:43:34+02	2003-11-19 17:43:35.090365+02	ganymede	3731	init:		process_mode current_mode=UNKNOWN, requested_mode=MASTER_ONLY, cmd=routing 		10
1315345	2003-11-19 17:43:34+02	2003-11-19 17:43:34.584479+02	ganymede	3731	/kernel:		Wed Nov 19 16:43:34 CET 2003		10
1315373	2003-11-19 17:43:34+02	2003-11-19 17:43:35.228165+02	ganymede	3731	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1315362	2003-11-19 17:43:34+02	2003-11-19 17:43:35.025505+02	ganymede	3731	init:		process_mode mode=BOTH cmd=snmp master_mode=-1		10
1315368	2003-11-19 17:43:34+02	2003-11-19 17:43:35.103555+02	ganymede	3731	init:		process_mode current_mode=UNKNOWN, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1315367	2003-11-19 17:43:34+02	2003-11-19 17:43:35.099694+02	ganymede	3731	init:		inet-process (PID 2228) started		10
1315336	2003-11-19 17:43:34+02	2003-11-19 17:43:34.444402+02	ganymede	3731	/kernel:	Microcode:	Header revision 1, Date 5/5/1999, Platform Id 20		10
1315366	2003-11-19 17:43:34+02	2003-11-19 17:43:35.095504+02	ganymede	3731	init:		process_mode mode=BOTH cmd=inet-process master_mode=-1		10
1315333	2003-11-19 17:43:34+02	2003-11-19 17:43:34.42803+02	ganymede	3731	/kernel:		.		10
1315356	2003-11-19 17:43:34+02	2003-11-19 17:43:34.891508+02	ganymede	3731	init:		process_mode mode=BOTH cmd=craft-control master_mode=-1		10
1315335	2003-11-19 17:43:34+02	2003-11-19 17:43:34.439629+02	ganymede	3731	/kernel:		microcode kld		10
1315344	2003-11-19 17:43:34+02	2003-11-19 17:43:34.58066+02	ganymede	3731	/kernel:		.		10
1315355	2003-11-19 17:43:34+02	2003-11-19 17:43:34.872429+02	ganymede	3731	init:		alarm-control (PID 2223) started		10
1315354	2003-11-19 17:43:34+02	2003-11-19 17:43:34.806078+02	ganymede	3731	init:		process_mode mode=BOTH cmd=alarm-control master_mode=-1		10
1315358	2003-11-19 17:43:34+02	2003-11-19 17:43:34.899075+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ntp master_mode=-1		10
1315363	2003-11-19 17:43:34+02	2003-11-19 17:43:35.082853+02	ganymede	3731	init:		snmp (PID 2227) started		10
1315334	2003-11-19 17:43:34+02	2003-11-19 17:43:34.434893+02	ganymede	3731	/kernel:		Initial rc.i386 initialization:		10
1315351	2003-11-19 17:43:34+02	2003-11-19 17:43:34.716961+02	ganymede	3731	init:		interface-control (PID 2221) started		10
1315364	2003-11-19 17:43:34+02	2003-11-19 17:43:35.086627+02	ganymede	3731	init:		process_mode current_mode=UNKNOWN, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1315352	2003-11-19 17:43:34+02	2003-11-19 17:43:34.720713+02	ganymede	3731	init:		process_mode mode=BOTH cmd=chassis-control master_mode=-1		10
1315369	2003-11-19 17:43:34+02	2003-11-19 17:43:35.107282+02	ganymede	3731	chassisd[2222]:		 CHASSISD release 6.1R1.4 built by builder on 2003-10-09 20:21:27 UTC 		10
1315343	2003-11-19 17:43:34+02	2003-11-19 17:43:34.576874+02	ganymede	3731	/kernel:		starting local daemons:		10
1315361	2003-11-19 17:43:34+02	2003-11-19 17:43:35.021666+02	ganymede	3731	init:		management (PID 2226) started		10
1315353	2003-11-19 17:43:34+02	2003-11-19 17:43:34.76227+02	ganymede	3731	init:		chassis-control (PID 2222) started		10
1315372	2003-11-19 17:43:34+02	2003-11-19 17:43:35.224437+02	ganymede	3731	/kernel:	TNP:	adding neighbor 1 to interface fxp1.		10
1315357	2003-11-19 17:43:34+02	2003-11-19 17:43:34.895351+02	ganymede	3731	init:		craft-control (PID 2224) started		10
1315350	2003-11-19 17:43:34+02	2003-11-19 17:43:34.713061+02	ganymede	3731	init:		process_mode mode=RESTART cmd=interface-control master_mode=-1		10
1315342	2003-11-19 17:43:34+02	2003-11-19 17:43:34.572903+02	ganymede	3731	/kernel:		.		10
1315346	2003-11-19 17:43:34+02	2003-11-19 17:43:34.5882+02	ganymede	3731	init:		process_mode mode=BOTH cmd=watchdog master_mode=-1		10
1315348	2003-11-19 17:43:34+02	2003-11-19 17:43:34.595831+02	ganymede	3731	init:		process_mode mode=BOTH cmd=tnp-process master_mode=-1		10
1315347	2003-11-19 17:43:34+02	2003-11-19 17:43:34.591911+02	ganymede	3731	init:		watchdog (PID 2219) started		10
1315349	2003-11-19 17:43:34+02	2003-11-19 17:43:34.600981+02	ganymede	3731	init:		tnp-process (PID 2220) started		10
1315338	2003-11-19 17:43:34+02	2003-11-19 17:43:34.452415+02	ganymede	3731	/kernel:		.		10
1315341	2003-11-19 17:43:34+02	2003-11-19 17:43:34.56848+02	ganymede	3731	/kernel:		Local package initialization:		10
1315371	2003-11-19 17:43:34+02	2003-11-19 17:43:35.220672+02	ganymede	3731	/kernel:	mastership:	routing engine 0 becoming master		10
1315360	2003-11-19 17:43:34+02	2003-11-19 17:43:35.015802+02	ganymede	3731	init:		process_mode mode=BOTH cmd=management master_mode=-1		10
1315337	2003-11-19 17:43:34+02	2003-11-19 17:43:34.448565+02	ganymede	3731	/kernel:	Microcode:	updated from revision 0 to 11, date=05051999		10
1315370	2003-11-19 17:43:34+02	2003-11-19 17:43:35.214878+02	ganymede	3731	init:		process_mode current_mode=UNKNOWN, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1315340	2003-11-19 17:43:34+02	2003-11-19 17:43:34.562921+02	ganymede	3731	/kernel:		.		10
1315359	2003-11-19 17:43:34+02	2003-11-19 17:43:34.903484+02	ganymede	3731	init:		ntp (PID 2225) started		10
1315339	2003-11-19 17:43:34+02	2003-11-19 17:43:34.456331+02	ganymede	3731	/kernel:		rc.i386 configuring syscons:		10
1315378	2003-11-19 17:43:35+02	2003-11-19 17:43:36.061593+02	ganymede	3731	craftd[2224]:		craftd detected platform m10 		10
1315376	2003-11-19 17:43:35+02	2003-11-19 17:43:35.917018+02	ganymede	3731	xntpd[2225]:		ntpd 4.0.99b Thu Oct  9 20:39:08 GMT 2003 (1)		1
1315375	2003-11-19 17:43:35+02	2003-11-19 17:43:35.800351+02	ganymede	3731	init:		sntp (PID 2229) started		10
1315377	2003-11-19 17:43:35+02	2003-11-19 17:43:35.929667+02	ganymede	3731	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1315402	2003-11-19 17:43:36+02	2003-11-19 17:43:36.79076+02	ganymede	3731	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1315415	2003-11-19 17:43:36+02	2003-11-19 17:43:36.955558+02	ganymede	3731	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1315382	2003-11-19 17:43:36+02	2003-11-19 17:43:36.312445+02	ganymede	3731	xntpd[2225]:		frequency initialized 84.242 from /var/db/ntp.drift		1
1315421	2003-11-19 17:43:36+02	2003-11-19 17:43:37.148691+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pgm 		10
1315381	2003-11-19 17:43:36+02	2003-11-19 17:43:36.308638+02	ganymede	3731	xntpd[2225]:		using kernel phase-lock loop 2040		1
1315401	2003-11-19 17:43:36+02	2003-11-19 17:43:36.78679+02	ganymede	3731	init:		link-management (PID 2239) started		10
1315410	2003-11-19 17:43:36+02	2003-11-19 17:43:36.934193+02	ganymede	3731	init:		internal-routing-service (PID 2242) started		10
1315391	2003-11-19 17:43:36+02	2003-11-19 17:43:36.638689+02	ganymede	3731	init:		class-of-service (PID 2234) started		10
1315403	2003-11-19 17:43:36+02	2003-11-19 17:43:36.794502+02	ganymede	3731	init:		syslogd (PID 2093) started		10
1315399	2003-11-19 17:43:36+02	2003-11-19 17:43:36.671008+02	ganymede	3731	init:		remote-hello (PID 2238) started		10
1315380	2003-11-19 17:43:36+02	2003-11-19 17:43:36.302981+02	ganymede	3731	xntpd[2225]:		kern_enable is 1		1
1315383	2003-11-19 17:43:36+02	2003-11-19 17:43:36.316249+02	ganymede	3731	xntpd[2225]:		using kernel phase-lock loop 2041		1
1315414	2003-11-19 17:43:36+02	2003-11-19 17:43:36.951633+02	ganymede	3731	init:		pic-services-logging (PID 2244) started		10
1315379	2003-11-19 17:43:36+02	2003-11-19 17:43:36.187298+02	ganymede	3731	init:		pfe (PID 2230) started		10
1315400	2003-11-19 17:43:36+02	2003-11-19 17:43:36.783002+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1315387	2003-11-19 17:43:36+02	2003-11-19 17:43:36.516803+02	ganymede	3731	init:		ilmi (PID 2232) started		10
1315384	2003-11-19 17:43:36+02	2003-11-19 17:43:36.499776+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1315386	2003-11-19 17:43:36+02	2003-11-19 17:43:36.511435+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1315393	2003-11-19 17:43:36+02	2003-11-19 17:43:36.646325+02	ganymede	3731	init:		network-access (PID 2235) started		10
1315420	2003-11-19 17:43:36+02	2003-11-19 17:43:37.142972+02	ganymede	3731	init:		neighbor-liveness (PID 2247) started		10
1315413	2003-11-19 17:43:36+02	2003-11-19 17:43:36.947829+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1315409	2003-11-19 17:43:36+02	2003-11-19 17:43:36.82134+02	ganymede	3731	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1315408	2003-11-19 17:43:36+02	2003-11-19 17:43:36.817604+02	ganymede	3731	init:		firewall (PID 2241) started		10
1315392	2003-11-19 17:43:36+02	2003-11-19 17:43:36.642423+02	ganymede	3731	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1315394	2003-11-19 17:43:36+02	2003-11-19 17:43:36.650047+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1315398	2003-11-19 17:43:36+02	2003-11-19 17:43:36.667205+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1315396	2003-11-19 17:43:36+02	2003-11-19 17:43:36.659194+02	ganymede	3731	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1315412	2003-11-19 17:43:36+02	2003-11-19 17:43:36.943892+02	ganymede	3731	init:		routing-socket-proxy (PID 2243) started		10
1315404	2003-11-19 17:43:36+02	2003-11-19 17:43:36.798207+02	ganymede	3731	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1315395	2003-11-19 17:43:36+02	2003-11-19 17:43:36.655183+02	ganymede	3731	init:		ipsec-key-management (PID 2236) started		10
1315407	2003-11-19 17:43:36+02	2003-11-19 17:43:36.8139+02	ganymede	3731	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1315406	2003-11-19 17:43:36+02	2003-11-19 17:43:36.810072+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1315397	2003-11-19 17:43:36+02	2003-11-19 17:43:36.663319+02	ganymede	3731	init:		helper (PID 2237) started		10
1315422	2003-11-19 17:43:36+02	2003-11-19 17:43:37.153662+02	ganymede	3731	init:		pgm (PID 2248) started		10
1353274	2003-11-21 17:45:16+02	2003-11-21 17:45:16.973541+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/proc/4413/file', PID 4884, status 0		1
1353389	2003-11-21 17:45:16+02	2003-11-21 17:45:19.738048+02	r201	3732	last		message repeated 3 times		10
1353331	2003-11-21 17:45:16+02	2003-11-21 17:45:18.219656+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 5154, status 0		1
1353272	2003-11-21 17:45:16+02	2003-11-21 17:45:16.94752+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/proc/2268/file', PID 2877, status 0		1
1353352	2003-11-21 17:45:16+02	2003-11-21 17:45:18.98387+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1353330	2003-11-21 17:45:16+02	2003-11-21 17:45:18.189121+02	atlas	3730	mgd[2866]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1353273	2003-11-21 17:45:16+02	2003-11-21 17:45:16.968904+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 5144, status 0		1
1353384	2003-11-21 17:45:16+02	2003-11-21 17:45:19.705993+02	ganymede	3731	mgd[2992]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1353308	2003-11-21 17:45:16+02	2003-11-21 17:45:17.672328+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/proc/2247/file'		1
1353269	2003-11-21 17:45:16+02	2003-11-21 17:45:16.830166+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1353292	2003-11-21 17:45:16+02	2003-11-21 17:45:17.379493+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/proc/4439/file'		1
1353368	2003-11-21 17:45:16+02	2003-11-21 17:45:19.316905+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2878, status 0		1
1353259	2003-11-21 17:45:16+02	2003-11-21 17:45:16.67753+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/proc/2257/file', PID 2875, status 0		1
1353290	2003-11-21 17:45:16+02	2003-11-21 17:45:17.256239+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1353328	2003-11-21 17:45:16+02	2003-11-21 17:45:18.131306+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 5153, status 0		1
1353361	2003-11-21 17:45:16+02	2003-11-21 17:45:19.10061+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1353318	2003-11-21 17:45:16+02	2003-11-21 17:45:17.85638+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 3002, status 0		1
1353306	2003-11-21 17:45:16+02	2003-11-21 17:45:17.660665+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 2999, status 0		1
1353353	2003-11-21 17:45:16+02	2003-11-21 17:45:19.034643+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 5164, status 0		1
1353362	2003-11-21 17:45:16+02	2003-11-21 17:45:19.213494+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353369	2003-11-21 17:45:16+02	2003-11-21 17:45:19.32638+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5168, status 0		1
1353377	2003-11-21 17:45:16+02	2003-11-21 17:45:19.573858+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2879, status 0		1
1353388	2003-11-21 17:45:16+02	2003-11-21 17:45:19.733314+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc38f5ffc/32		10
1353392	2003-11-21 17:45:16+02	2003-11-21 17:45:19.94748+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4895, status 0		1
1353311	2003-11-21 17:45:16+02	2003-11-21 17:45:17.68621+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/proc/2247/file', PID 3000, status 0		1
1353358	2003-11-21 17:45:16+02	2003-11-21 17:45:19.081197+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1353305	2003-11-21 17:45:16+02	2003-11-21 17:45:17.656301+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/proc/4442/file'		1
1353296	2003-11-21 17:45:16+02	2003-11-21 17:45:17.397134+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/proc/4439/file', PID 4889, status 0		1
1353293	2003-11-21 17:45:16+02	2003-11-21 17:45:17.384589+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 2997, status 0		1
1353335	2003-11-21 17:45:16+02	2003-11-21 17:45:18.448468+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1353374	2003-11-21 17:45:16+02	2003-11-21 17:45:19.542416+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353295	2003-11-21 17:45:16+02	2003-11-21 17:45:17.393331+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 5147, status 0		1
1353276	2003-11-21 17:45:16+02	2003-11-21 17:45:16.984982+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1353359	2003-11-21 17:45:16+02	2003-11-21 17:45:19.091705+02	adrastea	3726	mgd[5142]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1353334	2003-11-21 17:45:16+02	2003-11-21 17:45:18.443261+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 5155, status 0		1
1353262	2003-11-21 17:45:16+02	2003-11-21 17:45:16.797965+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/proc/4434/file'		1
1353317	2003-11-21 17:45:16+02	2003-11-21 17:45:17.852447+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1353372	2003-11-21 17:45:16+02	2003-11-21 17:45:19.474528+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4894, status 0		1
1353313	2003-11-21 17:45:16+02	2003-11-21 17:45:17.808267+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 5149, status 0		1
1353316	2003-11-21 17:45:16+02	2003-11-21 17:45:17.84733+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1353264	2003-11-21 17:45:16+02	2003-11-21 17:45:16.807816+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/proc/4453/file'		1
1353326	2003-11-21 17:45:16+02	2003-11-21 17:45:18.121509+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 5151, status 0		1
1353307	2003-11-21 17:45:16+02	2003-11-21 17:45:17.668063+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/proc/4442/file', PID 4892, status 0		1
1353320	2003-11-21 17:45:16+02	2003-11-21 17:45:17.914878+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 3003, status 0		1
1353367	2003-11-21 17:45:16+02	2003-11-21 17:45:19.303602+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353280	2003-11-21 17:45:16+02	2003-11-21 17:45:17.005027+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1353286	2003-11-21 17:45:16+02	2003-11-21 17:45:17.220797+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/proc/4438/file', PID 4887, status 0		1
1353364	2003-11-21 17:45:16+02	2003-11-21 17:45:19.228314+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353375	2003-11-21 17:45:16+02	2003-11-21 17:45:19.548412+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 3004, status 0		1
1315389	2003-11-19 17:43:36+02	2003-11-19 17:43:36.526675+02	ganymede	3731	init:		remote-operations (PID 2233) started		10
1315418	2003-11-19 17:43:36+02	2003-11-19 17:43:36.981296+02	ganymede	3731	init:		ecc-error-logging (PID 2246) started		500
1315416	2003-11-19 17:43:36+02	2003-11-19 17:43:36.959318+02	ganymede	3731	init:		adaptive-services (PID 2245) started		10
1315390	2003-11-19 17:43:36+02	2003-11-19 17:43:36.633112+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1315388	2003-11-19 17:43:36+02	2003-11-19 17:43:36.52168+02	ganymede	3731	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1315417	2003-11-19 17:43:36+02	2003-11-19 17:43:36.977579+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1315411	2003-11-19 17:43:36+02	2003-11-19 17:43:36.940023+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1315405	2003-11-19 17:43:36+02	2003-11-19 17:43:36.801905+02	ganymede	3731	init:		disk-monitoring (PID 2240) started		10
1315419	2003-11-19 17:43:36+02	2003-11-19 17:43:36.985075+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=neighbor-liveness 		10
1315425	2003-11-19 17:43:36+02	2003-11-19 17:43:37.166485+02	ganymede	3731	alarmd[2223]:		craftd connection succeeded after 1 retries 		10
1315385	2003-11-19 17:43:36+02	2003-11-19 17:43:36.506641+02	ganymede	3731	init:		sampling (PID 2231) started		10
1315428	2003-11-19 17:43:37+02	2003-11-19 17:43:37.641199+02	ganymede	3731	alarmd[2223]:		resending alarm state 		10
1315427	2003-11-19 17:43:37+02	2003-11-19 17:43:37.368061+02	ganymede	3731	init:	Multiuser:	old requested_transition==0x0 sighupped=1 		10
1315426	2003-11-19 17:43:37+02	2003-11-19 17:43:37.309748+02	ganymede	3731	smartd[2240]:		smartd starting, pid 2240		10
1315437	2003-11-19 17:43:39+02	2003-11-19 17:43:39.503588+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1315455	2003-11-19 17:43:39+02	2003-11-19 17:43:39.840642+02	ganymede	3731	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1315458	2003-11-19 17:43:39+02	2003-11-19 17:43:39.851893+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1315447	2003-11-19 17:43:39+02	2003-11-19 17:43:39.653902+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1315445	2003-11-19 17:43:39+02	2003-11-19 17:43:39.644555+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1315456	2003-11-19 17:43:39+02	2003-11-19 17:43:39.844442+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1315436	2003-11-19 17:43:39+02	2003-11-19 17:43:39.499725+02	ganymede	3731	init:		process_mode mode=BOTH cmd=craft-control master_mode=1		10
1315461	2003-11-19 17:43:39+02	2003-11-19 17:43:39.969194+02	ganymede	3731	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1315433	2003-11-19 17:43:39+02	2003-11-19 17:43:39.487876+02	ganymede	3731	init:		clean_process:killing process interface-control as mastership/failover mode changed! 		10
1315438	2003-11-19 17:43:39+02	2003-11-19 17:43:39.507353+02	ganymede	3731	init:		process_mode mode=BOTH cmd=management master_mode=1		10
1315430	2003-11-19 17:43:39+02	2003-11-19 17:43:39.474214+02	ganymede	3731	init:		process_mode mode=BOTH cmd=tnp-process master_mode=1		10
1315459	2003-11-19 17:43:39+02	2003-11-19 17:43:39.856507+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1315432	2003-11-19 17:43:39+02	2003-11-19 17:43:39.483976+02	ganymede	3731	init:		clean_process:process interface-control RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1315466	2003-11-19 17:43:39+02	2003-11-19 17:43:40.358258+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1315460	2003-11-19 17:43:39+02	2003-11-19 17:43:39.963482+02	ganymede	3731	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1315429	2003-11-19 17:43:39+02	2003-11-19 17:43:39.352581+02	ganymede	3731	init:		process_mode mode=BOTH cmd=watchdog master_mode=1		10
1315446	2003-11-19 17:43:39+02	2003-11-19 17:43:39.648264+02	ganymede	3731	init:		sonet-aps (PID 2253) started		10
1315457	2003-11-19 17:43:39+02	2003-11-19 17:43:39.84815+02	ganymede	3731	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1315470	2003-11-19 17:43:39+02	2003-11-19 17:43:40.483086+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=neighbor-liveness 		10
1315465	2003-11-19 17:43:39+02	2003-11-19 17:43:40.354409+02	ganymede	3731	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1315464	2003-11-19 17:43:39+02	2003-11-19 17:43:40.350518+02	ganymede	3731	init:		clean_process:process firewall RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1315431	2003-11-19 17:43:39+02	2003-11-19 17:43:39.480014+02	ganymede	3731	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1315467	2003-11-19 17:43:39+02	2003-11-19 17:43:40.362954+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1315468	2003-11-19 17:43:39+02	2003-11-19 17:43:40.366885+02	ganymede	3731	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1315471	2003-11-19 17:43:39+02	2003-11-19 17:43:40.488727+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pgm 		10
1315469	2003-11-19 17:43:39+02	2003-11-19 17:43:40.370619+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1315435	2003-11-19 17:43:39+02	2003-11-19 17:43:39.49577+02	ganymede	3731	init:		process_mode mode=BOTH cmd=alarm-control master_mode=1		10
1315463	2003-11-19 17:43:39+02	2003-11-19 17:43:40.303038+02	ganymede	3731	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1315444	2003-11-19 17:43:39+02	2003-11-19 17:43:39.640789+02	ganymede	3731	init:		process_mode mode=BOTH cmd=inet-process master_mode=1		10
1315454	2003-11-19 17:43:39+02	2003-11-19 17:43:39.792424+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1315443	2003-11-19 17:43:39+02	2003-11-19 17:43:39.636971+02	ganymede	3731	init:		routing (PID 2252) started		10
1315434	2003-11-19 17:43:39+02	2003-11-19 17:43:39.491637+02	ganymede	3731	init:		process_mode mode=BOTH cmd=chassis-control master_mode=1		10
1315442	2003-11-19 17:43:39+02	2003-11-19 17:43:39.633064+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing 		10
1315440	2003-11-19 17:43:39+02	2003-11-19 17:43:39.62302+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1315439	2003-11-19 17:43:39+02	2003-11-19 17:43:39.511163+02	ganymede	3731	init:		process_mode mode=BOTH cmd=snmp master_mode=1		10
1315462	2003-11-19 17:43:39+02	2003-11-19 17:43:39.973099+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1315441	2003-11-19 17:43:39+02	2003-11-19 17:43:39.628602+02	ganymede	3731	init:		mib-process (PID 2251) started		10
1315453	2003-11-19 17:43:39+02	2003-11-19 17:43:39.788593+02	ganymede	3731	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1315452	2003-11-19 17:43:39+02	2003-11-19 17:43:39.78487+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1315449	2003-11-19 17:43:39+02	2003-11-19 17:43:39.661618+02	ganymede	3731	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1315448	2003-11-19 17:43:39+02	2003-11-19 17:43:39.657882+02	ganymede	3731	init:		vrrp (PID 2254) started		10
1315451	2003-11-19 17:43:39+02	2003-11-19 17:43:39.78093+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1315450	2003-11-19 17:43:39+02	2003-11-19 17:43:39.774946+02	ganymede	3731	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1315478	2003-11-19 17:43:40+02	2003-11-19 17:43:40.635345+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_COLD_START:	trap_generate_cold: SNMP trap: cold start 		2
1315474	2003-11-19 17:43:40+02	2003-11-19 17:43:40.503283+02	ganymede	3731	init:		interface-control (PID 2221) exited with status=0 Normal Exit		10
1315476	2003-11-19 17:43:40+02	2003-11-19 17:43:40.510946+02	ganymede	3731	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1315477	2003-11-19 17:43:40+02	2003-11-19 17:43:40.626999+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 2 traps in queue 		2
1315473	2003-11-19 17:43:40+02	2003-11-19 17:43:40.499453+02	ganymede	3731	rpd[2252]:	RPD_START:	Start rpd[2252] version 6.1R1.4 built 2003-10-09 20:28:45 UTC		10
1315472	2003-11-19 17:43:40+02	2003-11-19 17:43:40.494838+02	ganymede	3731	init:	Multiuser:	old requested_transition==0x0 sighupped=0 		10
1315480	2003-11-19 17:43:40+02	2003-11-19 17:43:40.748693+02	ganymede	3731	tnp.bootpd[2256]:	BOOTPD_BOOTSTRING:	Boot string: boot 1 sbr.jbf		10
1315475	2003-11-19 17:43:40+02	2003-11-19 17:43:40.507212+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 1 traps in queue 		2
1315479	2003-11-19 17:43:40+02	2003-11-19 17:43:40.743063+02	ganymede	3731	tnp.bootpd[2256]:	BOOTPD_VERSION:	Version: TNP.BOOTPD release 6.1R1.4 built by builder on 2003-10-09 20:17:47 UTC		10
1315482	2003-11-19 17:43:40+02	2003-11-19 17:43:40.756296+02	ganymede	3731	rpd[2252]:	krt_ifstate_get_socket:	ifstate option is set		10
1315481	2003-11-19 17:43:40+02	2003-11-19 17:43:40.75253+02	ganymede	3731	init:		interface-control (PID 2258) started		10
1315484	2003-11-19 17:43:41+02	2003-11-19 17:43:41.299991+02	ganymede	3731	smartd[2240]:		Device /dev/ad1a, found and is SMART capable		10
1315483	2003-11-19 17:43:41+02	2003-11-19 17:43:41.200763+02	ganymede	3731	tnp.tftpd[2259]:	TFTPD_CONNECT_INFO:	TFTP read from address 2 port 1024 file sbr.jbf		10
1315487	2003-11-19 17:43:43+02	2003-11-19 17:43:44.040547+02	ganymede	3731	rpd[2252]:	RPD_TASK_BEGIN:	Commencing routing updates, version 6.1R1.4, built 2003-10-09 20:28:45 UTC by builder		10
1315319	2003-11-19 17:43:43+02	2003-11-19 17:43:32.99799+02	ganymede	3731	/kernel:		Doing additional network setup:		10
1315316	2003-11-19 17:43:43+02	2003-11-19 17:43:32.968974+02	ganymede	3731	/kernel:		Additional routing options:		10
1315317	2003-11-19 17:43:43+02	2003-11-19 17:43:32.990367+02	ganymede	3731	/kernel:		ipsec kld		10
1315320	2003-11-19 17:43:43+02	2003-11-19 17:43:33.102917+02	ganymede	3731	/kernel:		ntpdate		10
1315485	2003-11-19 17:43:43+02	2003-11-19 17:43:43.783266+02	ganymede	3731	rpd[2252]:	bgp_peer_init:	BGP peer 10.100.254.21 (Internal AS 100) local address 10.100.254.20 not found.  Leaving peer idled		10
1315318	2003-11-19 17:43:43+02	2003-11-19 17:43:32.994282+02	ganymede	3731	/kernel:		.		10
1315486	2003-11-19 17:43:43+02	2003-11-19 17:43:43.801834+02	ganymede	3731	rpd[2252]:	bgp_set_peer_if:	BGP peer 192.1.1.2 (External AS 64513) interface not found.  Leaving peer idled		10
1315518	2003-11-19 17:43:44+02	2003-11-19 17:43:44.869847+02	ganymede	3731	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1315553	2003-11-19 17:43:44+02	2003-11-19 17:43:45.500223+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1315492	2003-11-19 17:43:44+02	2003-11-19 17:43:44.518974+02	ganymede	3731	init:		process_mode mode=BOTH cmd=watchdog master_mode=1		10
1315545	2003-11-19 17:43:44+02	2003-11-19 17:43:45.358166+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1315510	2003-11-19 17:43:44+02	2003-11-19 17:43:44.837081+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1315551	2003-11-19 17:43:44+02	2003-11-19 17:43:45.492729+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1315549	2003-11-19 17:43:44+02	2003-11-19 17:43:45.483189+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1315543	2003-11-19 17:43:44+02	2003-11-19 17:43:45.350647+02	ganymede	3731	init:		process_mode mode=BOTH cmd=inet-process master_mode=1		10
1315550	2003-11-19 17:43:44+02	2003-11-19 17:43:45.488889+02	ganymede	3731	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1315552	2003-11-19 17:43:44+02	2003-11-19 17:43:45.496482+02	ganymede	3731	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1315517	2003-11-19 17:43:44+02	2003-11-19 17:43:44.866098+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1315558	2003-11-19 17:43:44+02	2003-11-19 17:43:45.519288+02	ganymede	3731	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1315542	2003-11-19 17:43:44+02	2003-11-19 17:43:45.296447+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing 		10
1315509	2003-11-19 17:43:44+02	2003-11-19 17:43:44.813603+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1315500	2003-11-19 17:43:44+02	2003-11-19 17:43:44.668767+02	ganymede	3731	init:		process_mode mode=BOTH cmd=management master_mode=1		10
1315525	2003-11-19 17:43:44+02	2003-11-19 17:43:45.009492+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1315531	2003-11-19 17:43:44+02	2003-11-19 17:43:45.14314+02	ganymede	3731	init:		process_mode mode=BOTH cmd=watchdog master_mode=1		10
1315501	2003-11-19 17:43:44+02	2003-11-19 17:43:44.672719+02	ganymede	3731	init:		process_mode mode=BOTH cmd=snmp master_mode=1		10
1315524	2003-11-19 17:43:44+02	2003-11-19 17:43:45.005746+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1315560	2003-11-19 17:43:44+02	2003-11-19 17:43:45.639939+02	ganymede	3731	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1315506	2003-11-19 17:43:44+02	2003-11-19 17:43:44.693913+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1347485	2003-11-20 20:18:16+02	2003-11-20 20:00:49.995865+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347484	2003-11-20 20:18:16+02	2003-11-20 20:00:49.983431+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347489	2003-11-20 20:18:17+02	2003-11-20 20:00:50.994287+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347488	2003-11-20 20:18:17+02	2003-11-20 20:00:50.990471+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347487	2003-11-20 20:18:17+02	2003-11-20 20:00:50.982349+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347492	2003-11-20 20:18:18+02	2003-11-20 20:00:51.989832+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347493	2003-11-20 20:18:18+02	2003-11-20 20:00:51.993678+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347491	2003-11-20 20:18:18+02	2003-11-20 20:00:51.982839+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347495	2003-11-20 20:18:19+02	2003-11-20 20:00:52.996441+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347496	2003-11-20 20:18:19+02	2003-11-20 20:00:53.000281+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347494	2003-11-20 20:18:19+02	2003-11-20 20:00:52.983194+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347498	2003-11-20 20:18:20+02	2003-11-20 20:00:53.983531+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347499	2003-11-20 20:18:20+02	2003-11-20 20:00:53.987845+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347501	2003-11-20 20:18:21+02	2003-11-20 20:01:00.983216+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347509	2003-11-20 20:18:47+02	2003-11-20 20:01:20.846453+02	jupiter	3727	chassisd[4445]:	CHASSISD_SNMP_TRAP6:	SNMP trap: Power Supply failed: jnxContentsContainerIndex 2, jnxContentsL1Index 2, jnxContentsL2Index 0, jnxContentsL3Index 0, jnxContentsDescr PEM 1, jnxOperatingState/Temp 6 		100
1315541	2003-11-19 17:43:44+02	2003-11-19 17:43:45.292684+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1315516	2003-11-19 17:43:44+02	2003-11-19 17:43:44.859887+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1315520	2003-11-19 17:43:44+02	2003-11-19 17:43:44.989812+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1315534	2003-11-19 17:43:44+02	2003-11-19 17:43:45.155177+02	ganymede	3731	init:		clean_process:process interface-control RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1315528	2003-11-19 17:43:44+02	2003-11-19 17:43:45.023702+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=neighbor-liveness 		10
1315513	2003-11-19 17:43:44+02	2003-11-19 17:43:44.848462+02	ganymede	3731	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1315556	2003-11-19 17:43:44+02	2003-11-19 17:43:45.511431+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1315519	2003-11-19 17:43:44+02	2003-11-19 17:43:44.9841+02	ganymede	3731	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1315502	2003-11-19 17:43:44+02	2003-11-19 17:43:44.676766+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1315544	2003-11-19 17:43:44+02	2003-11-19 17:43:45.35444+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1315533	2003-11-19 17:43:44+02	2003-11-19 17:43:45.151269+02	ganymede	3731	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1315554	2003-11-19 17:43:44+02	2003-11-19 17:43:45.503985+02	ganymede	3731	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1315512	2003-11-19 17:43:44+02	2003-11-19 17:43:44.844626+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1315569	2003-11-19 17:43:44+02	2003-11-19 17:43:45.793165+02	ganymede	3731	init:	Multiuser:	old requested_transition==0x0 sighupped=0 		10
1315562	2003-11-19 17:43:44+02	2003-11-19 17:43:45.648089+02	ganymede	3731	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1315568	2003-11-19 17:43:44+02	2003-11-19 17:43:45.67756+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pgm 		10
1315557	2003-11-19 17:43:44+02	2003-11-19 17:43:45.515338+02	ganymede	3731	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1315527	2003-11-19 17:43:44+02	2003-11-19 17:43:45.019787+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1315555	2003-11-19 17:43:44+02	2003-11-19 17:43:45.507709+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1315567	2003-11-19 17:43:44+02	2003-11-19 17:43:45.669546+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=neighbor-liveness 		10
1315526	2003-11-19 17:43:44+02	2003-11-19 17:43:45.015656+02	ganymede	3731	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1315563	2003-11-19 17:43:44+02	2003-11-19 17:43:45.651913+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1315511	2003-11-19 17:43:44+02	2003-11-19 17:43:44.84086+02	ganymede	3731	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1315505	2003-11-19 17:43:44+02	2003-11-19 17:43:44.687966+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1315494	2003-11-19 17:43:44+02	2003-11-19 17:43:44.528837+02	ganymede	3731	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1315493	2003-11-19 17:43:44+02	2003-11-19 17:43:44.524089+02	ganymede	3731	init:		process_mode mode=BOTH cmd=tnp-process master_mode=1		10
1315515	2003-11-19 17:43:44+02	2003-11-19 17:43:44.856135+02	ganymede	3731	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1315514	2003-11-19 17:43:44+02	2003-11-19 17:43:44.852335+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1315504	2003-11-19 17:43:44+02	2003-11-19 17:43:44.684237+02	ganymede	3731	init:		process_mode mode=BOTH cmd=inet-process master_mode=1		10
1315561	2003-11-19 17:43:44+02	2003-11-19 17:43:45.643774+02	ganymede	3731	init:		clean_process:process firewall RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1315503	2003-11-19 17:43:44+02	2003-11-19 17:43:44.680483+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing 		10
1315523	2003-11-19 17:43:44+02	2003-11-19 17:43:45.001089+02	ganymede	3731	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1315536	2003-11-19 17:43:44+02	2003-11-19 17:43:45.164899+02	ganymede	3731	init:		process_mode mode=BOTH cmd=alarm-control master_mode=1		10
1315530	2003-11-19 17:43:44+02	2003-11-19 17:43:45.13875+02	ganymede	3731	init:	Multiuser:	old requested_transition==0x0 sighupped=1 		10
1315566	2003-11-19 17:43:44+02	2003-11-19 17:43:45.665272+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1315508	2003-11-19 17:43:44+02	2003-11-19 17:43:44.705171+02	ganymede	3731	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1315565	2003-11-19 17:43:44+02	2003-11-19 17:43:45.659605+02	ganymede	3731	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1315535	2003-11-19 17:43:44+02	2003-11-19 17:43:45.158978+02	ganymede	3731	init:		process_mode mode=BOTH cmd=chassis-control master_mode=1		10
1315491	2003-11-19 17:43:44+02	2003-11-19 17:43:44.511986+02	ganymede	3731	rpd[2252]:		EVENT UpDown lsi.32768 index 67 <Up Broadcast PointToPoint Multicast>		10
1315559	2003-11-19 17:43:44+02	2003-11-19 17:43:45.634119+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1315499	2003-11-19 17:43:44+02	2003-11-19 17:43:44.663112+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1315564	2003-11-19 17:43:44+02	2003-11-19 17:43:45.655874+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1315532	2003-11-19 17:43:44+02	2003-11-19 17:43:45.147221+02	ganymede	3731	init:		process_mode mode=BOTH cmd=tnp-process master_mode=1		10
1315498	2003-11-19 17:43:44+02	2003-11-19 17:43:44.552269+02	ganymede	3731	init:		process_mode mode=BOTH cmd=craft-control master_mode=1		10
1315529	2003-11-19 17:43:44+02	2003-11-19 17:43:45.133175+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pgm 		10
1315539	2003-11-19 17:43:44+02	2003-11-19 17:43:45.283136+02	ganymede	3731	init:		process_mode mode=BOTH cmd=management master_mode=1		10
1315548	2003-11-19 17:43:44+02	2003-11-19 17:43:45.370406+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1315546	2003-11-19 17:43:44+02	2003-11-19 17:43:45.361872+02	ganymede	3731	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1337480	2003-11-20 15:23:05+02	2003-11-20 15:23:05.682275+02	adrastea	3726	xntpd[2231]:		offset -0.000451 sec freq 76.486 ppm error 0.000824 poll 10		500
1336868	2003-11-20 15:23:09+02	2003-11-20 15:05:41.720624+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336869	2003-11-20 15:23:10+02	2003-11-20 15:05:42.721553+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336870	2003-11-20 15:23:10+02	2003-11-20 15:05:42.731221+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336873	2003-11-20 15:23:11+02	2003-11-20 15:05:43.746652+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336871	2003-11-20 15:23:11+02	2003-11-20 15:05:43.722004+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336872	2003-11-20 15:23:11+02	2003-11-20 15:05:43.742709+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336877	2003-11-20 15:23:12+02	2003-11-20 15:05:44.73167+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315522	2003-11-19 17:43:44+02	2003-11-19 17:43:44.99737+02	ganymede	3731	init:		clean_process:process firewall RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1315507	2003-11-19 17:43:44+02	2003-11-19 17:43:44.697731+02	ganymede	3731	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1315540	2003-11-19 17:43:44+02	2003-11-19 17:43:45.288828+02	ganymede	3731	init:		process_mode mode=BOTH cmd=snmp master_mode=1		10
1315547	2003-11-19 17:43:44+02	2003-11-19 17:43:45.366569+02	ganymede	3731	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1315497	2003-11-19 17:43:44+02	2003-11-19 17:43:44.545141+02	ganymede	3731	init:		process_mode mode=BOTH cmd=alarm-control master_mode=1		10
1315489	2003-11-19 17:43:44+02	2003-11-19 17:43:44.357349+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> lsi.32768 index 67 <Up Broadcast PointToPoint Multicast>		10
1315521	2003-11-19 17:43:44+02	2003-11-19 17:43:44.993632+02	ganymede	3731	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1315488	2003-11-19 17:43:44+02	2003-11-19 17:43:44.136552+02	ganymede	3731	rpd[2252]:		bgp_listen_reset		10
1315496	2003-11-19 17:43:44+02	2003-11-19 17:43:44.538859+02	ganymede	3731	init:		process_mode mode=BOTH cmd=chassis-control master_mode=1		10
1315537	2003-11-19 17:43:44+02	2003-11-19 17:43:45.168611+02	ganymede	3731	init:		process_mode mode=BOTH cmd=craft-control master_mode=1		10
1315538	2003-11-19 17:43:44+02	2003-11-19 17:43:45.172488+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1315495	2003-11-19 17:43:44+02	2003-11-19 17:43:44.534086+02	ganymede	3731	init:		clean_process:process interface-control RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1315490	2003-11-19 17:43:44+02	2003-11-19 17:43:44.369871+02	ganymede	3731	rpd[2252]:		EVENT UpDown lsi.32768 index 67 <Up Broadcast PointToPoint Multicast>		10
1315570	2003-11-19 17:43:45+02	2003-11-19 17:43:45.79706+02	ganymede	3731	craftd[2224]:		chassisd connection succeeded after 6 retries 		10
1315571	2003-11-19 17:43:45+02	2003-11-19 17:43:45.800776+02	ganymede	3731	alarmd[2223]:		chassisd connection succeeded after 9 retries 		10
1315572	2003-11-19 17:43:45+02	2003-11-19 17:43:45.804647+02	ganymede	3731	alarmd[2223]:		resending alarm state 		10
1315582	2003-11-19 17:43:46+02	2003-11-19 17:43:47.138477+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 6 <Up Broadcast Loopback Multicast>		10
1315584	2003-11-19 17:43:46+02	2003-11-19 17:43:47.147557+02	ganymede	3731	rpd[2252]:		EVENT <Add> lo0.16383 index 68 <Up Broadcast Loopback Multicast>		10
1315575	2003-11-19 17:43:46+02	2003-11-19 17:43:46.929497+02	ganymede	3731	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 1, af 2, run-len 0		10
1315577	2003-11-19 17:43:46+02	2003-11-19 17:43:46.949518+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 5 <Up Broadcast Multicast>		10
1315581	2003-11-19 17:43:46+02	2003-11-19 17:43:47.134652+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 66 <Up Broadcast Multicast>		10
1315576	2003-11-19 17:43:46+02	2003-11-19 17:43:46.945728+02	ganymede	3731	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 2, af 2, run-len 0		10
1315587	2003-11-19 17:43:46+02	2003-11-19 17:43:47.15894+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 68 <Up Broadcast Multicast>		10
1315578	2003-11-19 17:43:46+02	2003-11-19 17:43:47.017754+02	ganymede	3731	rpd[2252]:		EVENT <SNMP Index> fxp0.0 index 1 <Up Broadcast Multicast> address #0 0.a0.a5.28.1f.7		10
1315579	2003-11-19 17:43:46+02	2003-11-19 17:43:47.123634+02	ganymede	3731	rpd[2252]:		EVENT <SNMP Index> fxp1.0 index 2 <Up Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315589	2003-11-19 17:43:46+02	2003-11-19 17:43:47.273183+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 64 <Up Broadcast Multicast>		10
1315588	2003-11-19 17:43:46+02	2003-11-19 17:43:47.162788+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 67 <Up Broadcast Multicast>		10
1315586	2003-11-19 17:43:46+02	2003-11-19 17:43:47.155234+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 69 <Up Broadcast Multicast>		10
1315580	2003-11-19 17:43:46+02	2003-11-19 17:43:47.129361+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 65 <Up Broadcast Multicast>		10
1315585	2003-11-19 17:43:46+02	2003-11-19 17:43:47.151294+02	ganymede	3731	rpd[2252]:		EVENT <MTU> lo0.16383 index 68 <Up Broadcast Loopback Multicast>		10
1315583	2003-11-19 17:43:46+02	2003-11-19 17:43:47.143845+02	ganymede	3731	rpd[2252]:		EVENT <SNMP Index> lo0.0 index 64 <Up Broadcast Loopback Multicast>		10
1315591	2003-11-19 17:43:48+02	2003-11-19 17:43:49.12064+02	ganymede	3731	tnp.tftpd[2259]:	TFTPD_SENDCOMPLETE_INFO:	Sent 6144 blocks of 1024 and 1 block of 72 for file '/usr/share/pfe/sbr.jbf' 		10
1315593	2003-11-19 17:43:54+02	2003-11-19 17:43:54.54382+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_DETACH_FPC:	ifdev_detach(1) 		10
1315592	2003-11-19 17:43:54+02	2003-11-19 17:43:54.527161+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_DETACH_FPC:	ifdev_detach(0) 		10
1315598	2003-11-19 17:43:54+02	2003-11-19 17:43:54.990831+02	ganymede	3731	rpd[2252]:		EVENT <Bandwidth> fxp1.0 index 2 <Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315595	2003-11-19 17:43:54+02	2003-11-19 17:43:54.965454+02	ganymede	3731	/kernel:	fxp1:	link media DOWN 10Mb / half-duplex		10
1353401	2003-11-21 17:45:17+02	2003-11-21 17:45:20.082457+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1ba1ffc/32		10
1315597	2003-11-19 17:43:54+02	2003-11-19 17:43:54.987109+02	ganymede	3731	rpd[2252]:		EVENT <Bandwidth UpDown> index 2 <Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1357495	2003-11-21 19:43:45+02	2003-11-21 19:26:26.482482+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357497	2003-11-21 19:43:46+02	2003-11-21 19:26:27.482708+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357498	2003-11-21 19:43:46+02	2003-11-21 19:26:27.488735+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357501	2003-11-21 19:43:47+02	2003-11-21 19:26:28.505278+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357502	2003-11-21 19:43:47+02	2003-11-21 19:26:28.511221+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357500	2003-11-21 19:43:47+02	2003-11-21 19:26:28.483628+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357503	2003-11-21 19:43:48+02	2003-11-21 19:26:29.483688+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357504	2003-11-21 19:43:48+02	2003-11-21 19:26:29.501101+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357505	2003-11-21 19:43:48+02	2003-11-21 19:26:29.504867+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357506	2003-11-21 19:43:49+02	2003-11-21 19:26:30.484672+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357508	2003-11-21 19:43:49+02	2003-11-21 19:26:30.500917+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357507	2003-11-21 19:43:49+02	2003-11-21 19:26:30.496897+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357510	2003-11-21 19:43:50+02	2003-11-21 19:26:31.492658+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357509	2003-11-21 19:43:50+02	2003-11-21 19:26:31.484554+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1357514	2003-11-21 19:43:51+02	2003-11-21 19:26:37.202697+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315596	2003-11-19 17:43:54+02	2003-11-19 17:43:54.983336+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> fxp1.0 index 2 <Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315594	2003-11-19 17:43:54+02	2003-11-19 17:43:54.614822+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_DETACH_ALL_PSEUDO:	ifdev_detach(pseudo devices: all) 		10
1315603	2003-11-19 17:43:59+02	2003-11-19 17:43:59.180511+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 4, ifAdminStatus up(1), ifOperStatus up(1), ifName lsi		10
1315632	2003-11-19 17:43:59+02	2003-11-19 17:43:59.667539+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 19 traps in queue 		2
1315625	2003-11-19 17:43:59+02	2003-11-19 17:43:59.53789+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 11, ifAdminStatus up(1), ifOperStatus up(1), ifName pimd		10
1315621	2003-11-19 17:43:59+02	2003-11-19 17:43:59.522934+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 28, ifAdminStatus up(1), ifOperStatus up(1), ifName lo0.16383		10
1315641	2003-11-19 17:43:59+02	2003-11-19 17:43:59.813079+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 28 traps in queue 		2
1315637	2003-11-19 17:43:59+02	2003-11-19 17:43:59.688841+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 24 traps in queue 		2
1315645	2003-11-19 17:43:59+02	2003-11-19 17:43:59.916119+02	ganymede	3731	/kernel:	TNP:	version is changing to 2		10
1315604	2003-11-19 17:43:59+02	2003-11-19 17:43:59.1847+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 4 traps in queue 		2
1315642	2003-11-19 17:43:59+02	2003-11-19 17:43:59.816894+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 29 traps in queue 		2
1315602	2003-11-19 17:43:59+02	2003-11-19 17:43:59.165434+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 3 traps in queue 		2
1315611	2003-11-19 17:43:59+02	2003-11-19 17:43:59.32291+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_DOWN:	ifIndex 14, ifAdminStatus up(1), ifOperStatus down(2), ifName fxp1.0		10
1315615	2003-11-19 17:43:59+02	2003-11-19 17:43:59.338179+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 9, ifAdminStatus up(1), ifOperStatus up(1), ifName ipip		10
1315618	2003-11-19 17:43:59+02	2003-11-19 17:43:59.351318+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 11 traps in queue 		2
1315612	2003-11-19 17:43:59+02	2003-11-19 17:43:59.326621+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 8 traps in queue 		2
1315610	2003-11-19 17:43:59+02	2003-11-19 17:43:59.319166+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 7 traps in queue 		2
1315620	2003-11-19 17:43:59+02	2003-11-19 17:43:59.519049+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 12 traps in queue 		2
1315628	2003-11-19 17:43:59+02	2003-11-19 17:43:59.549407+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 7, ifAdminStatus up(1), ifOperStatus up(1), ifName tap		10
1315619	2003-11-19 17:43:59+02	2003-11-19 17:43:59.513425+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 16, ifAdminStatus up(1), ifOperStatus up(1), ifName lo0.0		10
1315623	2003-11-19 17:43:59+02	2003-11-19 17:43:59.530384+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 12, ifAdminStatus up(1), ifOperStatus up(1), ifName mtun		10
1315605	2003-11-19 17:43:59+02	2003-11-19 17:43:59.189722+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 5, ifAdminStatus up(1), ifOperStatus up(1), ifName dsc		10
1315622	2003-11-19 17:43:59+02	2003-11-19 17:43:59.52667+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 13 traps in queue 		2
1315636	2003-11-19 17:43:59+02	2003-11-19 17:43:59.68511+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 23 traps in queue 		2
1315614	2003-11-19 17:43:59+02	2003-11-19 17:43:59.334316+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 9 traps in queue 		2
1315627	2003-11-19 17:43:59+02	2003-11-19 17:43:59.545684+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 10, ifAdminStatus up(1), ifOperStatus up(1), ifName pime		10
1315635	2003-11-19 17:43:59+02	2003-11-19 17:43:59.681201+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 22 traps in queue 		2
1315633	2003-11-19 17:43:59+02	2003-11-19 17:43:59.671275+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 20 traps in queue 		2
1315634	2003-11-19 17:43:59+02	2003-11-19 17:43:59.675133+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 21 traps in queue 		2
1315626	2003-11-19 17:43:59+02	2003-11-19 17:43:59.541838+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 15 traps in queue 		2
1315638	2003-11-19 17:43:59+02	2003-11-19 17:43:59.692748+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 25 traps in queue 		2
1315640	2003-11-19 17:43:59+02	2003-11-19 17:43:59.809073+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 27 traps in queue 		2
1315639	2003-11-19 17:43:59+02	2003-11-19 17:43:59.803363+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 26 traps in queue 		2
1315644	2003-11-19 17:43:59+02	2003-11-19 17:43:59.91182+02	ganymede	3731	/kernel:	TNP:	deleting neighbor 2 from interface fxp1.		10
1353406	2003-11-21 17:45:17+02	2003-11-21 17:45:20.238881+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1315624	2003-11-19 17:43:59+02	2003-11-19 17:43:59.534157+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 14 traps in queue 		2
1315631	2003-11-19 17:43:59+02	2003-11-19 17:43:59.66359+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 18 traps in queue 		2
1315609	2003-11-19 17:43:59+02	2003-11-19 17:43:59.313429+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 13, ifAdminStatus up(1), ifOperStatus up(1), ifName fxp0.0		10
1315643	2003-11-19 17:43:59+02	2003-11-19 17:43:59.883825+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 30 traps in queue 		2
1315630	2003-11-19 17:43:59+02	2003-11-19 17:43:59.659177+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 17 traps in queue 		2
1315613	2003-11-19 17:43:59+02	2003-11-19 17:43:59.330331+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 8, ifAdminStatus up(1), ifOperStatus up(1), ifName gre		10
1315616	2003-11-19 17:43:59+02	2003-11-19 17:43:59.341886+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 10 traps in queue 		2
1336875	2003-11-20 15:23:12+02	2003-11-20 15:05:44.721623+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336876	2003-11-20 15:23:12+02	2003-11-20 15:05:44.727718+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336878	2003-11-20 15:23:13+02	2003-11-20 15:05:45.722784+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336880	2003-11-20 15:23:13+02	2003-11-20 15:05:45.867067+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336879	2003-11-20 15:23:13+02	2003-11-20 15:05:45.861483+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336881	2003-11-20 15:23:14+02	2003-11-20 15:05:46.722584+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336882	2003-11-20 15:23:14+02	2003-11-20 15:05:46.742725+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1336885	2003-11-20 15:23:15+02	2003-11-20 15:05:53.29202+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315629	2003-11-19 17:43:59+02	2003-11-19 17:43:59.653428+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 16 traps in queue 		2
1315608	2003-11-19 17:43:59+02	2003-11-19 17:43:59.204601+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 6 traps in queue 		2
1315606	2003-11-19 17:43:59+02	2003-11-19 17:43:59.194832+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 5 traps in queue 		2
1315607	2003-11-19 17:43:59+02	2003-11-19 17:43:59.199716+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 1, ifAdminStatus up(1), ifOperStatus up(1), ifName fxp0		10
1315617	2003-11-19 17:43:59+02	2003-11-19 17:43:59.347518+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 6, ifAdminStatus up(1), ifOperStatus up(1), ifName lo0		10
1315649	2003-11-19 17:44:05+02	2003-11-19 17:44:05.537898+02	ganymede	3731	login:		PAM module 0 returned: [7]Authentication failure		1
1315650	2003-11-19 17:44:05+02	2003-11-19 17:44:05.55629+02	ganymede	3731	login:		PAM authentication chain returned: [7]Authentication failure		1
1315654	2003-11-19 17:44:07+02	2003-11-19 17:44:07.883713+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1315653	2003-11-19 17:44:07+02	2003-11-19 17:44:07.877852+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1315652	2003-11-19 17:44:07+02	2003-11-19 17:44:07.872279+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1315655	2003-11-19 17:44:07+02	2003-11-19 17:44:07.906558+02	ganymede	3731	login:		login from 172.26.24.241 on ttyp0 as lab		1
1315651	2003-11-19 17:44:07+02	2003-11-19 17:44:07.86183+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1315656	2003-11-19 17:44:09+02	2003-11-19 17:44:10.085125+02	ganymede	3731	mgd[2395]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1315657	2003-11-19 17:44:09+02	2003-11-19 17:44:10.105238+02	ganymede	3731	mgd[2395]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2395]		1
1315670	2003-11-19 17:44:11+02	2003-11-19 17:44:12.099248+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 31 traps in queue 		2
1315671	2003-11-19 17:44:11+02	2003-11-19 17:44:12.102988+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 32 traps in queue 		2
1315664	2003-11-19 17:44:11+02	2003-11-19 17:44:11.834243+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1315663	2003-11-19 17:44:11+02	2003-11-19 17:44:11.827589+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2396, status 0		1
1315661	2003-11-19 17:44:11+02	2003-11-19 17:44:11.607812+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1315669	2003-11-19 17:44:11+02	2003-11-19 17:44:12.093637+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> fxp1.0 index 2 <Up Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315665	2003-11-19 17:44:11+02	2003-11-19 17:44:11.845549+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2397, status 0		1
1315667	2003-11-19 17:44:11+02	2003-11-19 17:44:11.857495+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1315666	2003-11-19 17:44:11+02	2003-11-19 17:44:11.850221+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces terse '		1
1315658	2003-11-19 17:44:11+02	2003-11-19 17:44:11.471519+02	ganymede	3731	/kernel:	fxp1:	media DOWN 100Mb / full-duplex		10
1315660	2003-11-19 17:44:11+02	2003-11-19 17:44:11.599262+02	ganymede	3731	rpd[2252]:		EVENT <Bandwidth> fxp1.0 index 2 <Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315659	2003-11-19 17:44:11+02	2003-11-19 17:44:11.59363+02	ganymede	3731	rpd[2252]:		EVENT <Bandwidth> index 2 <Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315668	2003-11-19 17:44:11+02	2003-11-19 17:44:11.984377+02	ganymede	3731	/kernel:	fxp1:	link UP 100Mb / full-duplex		10
1315673	2003-11-19 17:44:11+02	2003-11-19 17:44:12.161564+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 2 <Up Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315672	2003-11-19 17:44:11+02	2003-11-19 17:44:12.10689+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 2, ifAdminStatus up(1), ifOperStatus up(1), ifName fxp1		10
1315674	2003-11-19 17:44:11+02	2003-11-19 17:44:12.165347+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2398, status 0		1
1315678	2003-11-19 17:44:13+02	2003-11-19 17:44:14.036829+02	ganymede	3731	tnp.bootpd[2399]:	BOOTPD_VERSION:	Version: TNP.BOOTPD release 6.1R1.4 built by builder on 2003-10-09 20:17:47 UTC		10
1315677	2003-11-19 17:44:13+02	2003-11-19 17:44:14.032908+02	ganymede	3731	/kernel:	TNP:	adding neighbor 2 to interface fxp1.		10
1315676	2003-11-19 17:44:13+02	2003-11-19 17:44:14.017881+02	ganymede	3731	/kernel:	TNP:	version is changing to 1		10
1315679	2003-11-19 17:44:13+02	2003-11-19 17:44:14.143559+02	ganymede	3731	tnp.bootpd[2399]:	BOOTPD_BOOTSTRING:	Boot string: boot 1 sbr.jbf		10
1315680	2003-11-19 17:44:13+02	2003-11-19 17:44:14.149193+02	ganymede	3731	tnp.tftpd[2401]:	TFTPD_CONNECT_INFO:	TFTP read from address 2 port 1024 file sbr.jbf		10
1315688	2003-11-19 17:44:18+02	2003-11-19 17:44:18.455126+02	ganymede	3731	tnp.tftpd[2401]:	TFTPD_SENDCOMPLETE_INFO:	Sent 6144 blocks of 1024 and 1 block of 72 for file '/usr/share/pfe/sbr.jbf' 		10
1315695	2003-11-19 17:44:20+02	2003-11-19 17:44:20.241415+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 36 traps in queue 		2
1315690	2003-11-19 17:44:20+02	2003-11-19 17:44:20.207319+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 33 traps in queue 		2
1315693	2003-11-19 17:44:20+02	2003-11-19 17:44:20.231148+02	ganymede	3731	rpd[2252]:	bgp_connect_start:	connect 10.100.254.21 (Internal AS 100): No route to host		10
1315694	2003-11-19 17:44:20+02	2003-11-19 17:44:20.235651+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 35 traps in queue 		2
1315692	2003-11-19 17:44:20+02	2003-11-19 17:44:20.226312+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 34 traps in queue 		2
1315691	2003-11-19 17:44:20+02	2003-11-19 17:44:20.220878+02	ganymede	3731	rpd[2252]:	task_connect:	task BGP_100.10.100.254.21+179 addr 10.100.254.21+179: No route to host		10
1315699	2003-11-19 17:44:27+02	2003-11-19 17:44:27.452959+02	atlas	3730	rpd[4413]:	bgp_connect_start:	connect 10.100.254.20 (Internal AS 100): No route to host		10
1315697	2003-11-19 17:44:27+02	2003-11-19 17:44:27.428569+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 37 traps in queue 		2
1315702	2003-11-19 17:44:27+02	2003-11-19 17:44:27.468729+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 40 traps in queue 		2
1315698	2003-11-19 17:44:27+02	2003-11-19 17:44:27.448687+02	atlas	3730	rpd[4413]:	task_connect:	task BGP_100.10.100.254.20+179 addr 10.100.254.20+179: No route to host		10
1315700	2003-11-19 17:44:27+02	2003-11-19 17:44:27.457439+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 38 traps in queue 		2
1315701	2003-11-19 17:44:27+02	2003-11-19 17:44:27.461246+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 39 traps in queue 		2
1315708	2003-11-19 17:44:43+02	2003-11-19 17:44:43.217731+02	ganymede	3731	snmpd[2227]:	SNMPD_THROTTLE_QUEUE_DRAINED:	trap_throttle_timer_handler: cleared all throttled traps 		2
1315711	2003-11-19 17:44:43+02	2003-11-19 17:44:43.569456+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_DOWN:	ifIndex 2, ifAdminStatus up(1), ifOperStatus down(2), ifName fxp1		10
1315710	2003-11-19 17:44:43+02	2003-11-19 17:44:43.565421+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> fxp1.0 index 2 <Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315709	2003-11-19 17:44:43+02	2003-11-19 17:44:43.4745+02	ganymede	3731	/kernel:	fxp1:	link media DOWN 10Mb / half-duplex		10
1315712	2003-11-19 17:44:43+02	2003-11-19 17:44:43.573424+02	ganymede	3731	rpd[2252]:		EVENT <Bandwidth UpDown> index 2 <Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315713	2003-11-19 17:44:43+02	2003-11-19 17:44:43.577264+02	ganymede	3731	rpd[2252]:		EVENT <Bandwidth> fxp1.0 index 2 <Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315716	2003-11-19 17:44:44+02	2003-11-19 17:44:44.596155+02	ganymede	3731	rpd[2252]:		EVENT <Bandwidth> fxp1.0 index 2 <Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315718	2003-11-19 17:44:44+02	2003-11-19 17:44:44.987875+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> fxp1.0 index 2 <Up Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315715	2003-11-19 17:44:44+02	2003-11-19 17:44:44.488969+02	ganymede	3731	rpd[2252]:		EVENT <Bandwidth> index 2 <Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315714	2003-11-19 17:44:44+02	2003-11-19 17:44:44.47658+02	ganymede	3731	/kernel:	fxp1:	media DOWN 100Mb / full-duplex		10
1315719	2003-11-19 17:44:44+02	2003-11-19 17:44:44.991685+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 2, ifAdminStatus up(1), ifOperStatus up(1), ifName fxp1		10
1315720	2003-11-19 17:44:44+02	2003-11-19 17:44:44.995579+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 2 <Up Broadcast Multicast> address #0 0.a0.a5.28.1f.6		10
1315717	2003-11-19 17:44:44+02	2003-11-19 17:44:44.974432+02	ganymede	3731	/kernel:	fxp1:	link UP 100Mb / full-duplex		10
1315729	2003-11-19 17:44:52+02	2003-11-19 17:44:52.490356+02	ganymede	3731	/kernel:		pfe_peer_alloc !VALID(state 0)->OPENING tnp 2		10
1315733	2003-11-19 17:44:52+02	2003-11-19 17:44:52.505312+02	ganymede	3731	feb	SNTPD:	Initial time of day set. 		10
1315728	2003-11-19 17:44:52+02	2003-11-19 17:44:52.48663+02	ganymede	3731	feb	CM:	Established connection to routing engine 		10
1315727	2003-11-19 17:44:52+02	2003-11-19 17:44:52.482826+02	ganymede	3731	feb		On-board NVRAM contains diagnostic information. 		10
1315726	2003-11-19 17:44:52+02	2003-11-19 17:44:52.47714+02	ganymede	3731	feb		Version 6.1R1.4 by builder on 2003-10-09 21:04:51 UTC 		10
1315725	2003-11-19 17:44:52+02	2003-11-19 17:44:52.229614+02	ganymede	3731	rpd[2252]:	bgp_connect_start:	connect 10.100.254.21 (Internal AS 100): No route to host		10
1315732	2003-11-19 17:44:52+02	2003-11-19 17:44:52.501568+02	ganymede	3731	feb	PFEMAN:	Established connection to Master 		10
1315731	2003-11-19 17:44:52+02	2003-11-19 17:44:52.497882+02	ganymede	3731	feb	PFEMAN:	Session manager active 		10
1315730	2003-11-19 17:44:52+02	2003-11-19 17:44:52.494176+02	ganymede	3731	/kernel:	pfe_listener_connect:	conn established: listener idx=0, tnpaddr=2		10
1315735	2003-11-19 17:44:52+02	2003-11-19 17:44:52.615639+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_DETACH_ALL_PSEUDO:	ifdev_detach(pseudo devices: all) 		10
1337520	2003-11-20 15:24:36+02	2003-11-20 15:24:36.388585+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1337521	2003-11-20 15:24:36+02	2003-11-20 15:24:36.392468+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1337519	2003-11-20 15:24:36+02	2003-11-20 15:24:36.371018+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1315734	2003-11-19 17:44:52+02	2003-11-19 17:44:52.509078+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 6, jnxFruL1Index 1, jnxFruL2Index 0, jnxFruL3Index 0, jnxFruName FEB, jnxFruType 5, jnxFruSlot 1, jnxFruOfflineReason 2, jnxFruLastPowerOff 7196, jnxFruLastPowerOn 7196 		100
1315724	2003-11-19 17:44:52+02	2003-11-19 17:44:52.209035+02	ganymede	3731	rpd[2252]:	task_connect:	task BGP_100.10.100.254.21+179 addr 10.100.254.21+179: No route to host		10
1315736	2003-11-19 17:44:53+02	2003-11-19 17:44:54.11914+02	ganymede	3731	chassisd[2222]:	CHASSISD_FRU_EVENT:	fpc_m40_recv_restart: FPC slot 0 restart 		10
1315737	2003-11-19 17:44:54+02	2003-11-19 17:44:54.221421+02	ganymede	3731	chassisd[2222]:	CHASSISD_FRU_EVENT:	fpc_m40_recv_restart: FPC slot 1 restart 		10
1315746	2003-11-19 17:45:06+02	2003-11-19 17:45:06.653787+02	ganymede	3731	chassisd[2222]:	CHASSISD_FRU_EVENT:	scb_recv_slot_attach: FPC slot 0 attach 		10
1315775	2003-11-19 17:45:17+02	2003-11-19 17:45:17.964626+02	ganymede	3731	chassisd[2222]:	CHASSISD_FRU_EVENT:	scb_recv_slot_attach: FPC slot 1 attach 		10
1315777	2003-11-19 17:45:17+02	2003-11-19 17:45:18.0854+02	ganymede	3731	feb		COS IPC: Received FC->Q map, entries 4, op add 		10
1315776	2003-11-19 17:45:17+02	2003-11-19 17:45:18.063923+02	ganymede	3731	feb	PFEMAN:	sent Resync request to Master 		10
1315778	2003-11-19 17:45:17+02	2003-11-19 17:45:18.130535+02	ganymede	3731	feb		COS IPC: Received FC->Q map, entries 4, op add 		10
1315779	2003-11-19 17:45:18+02	2003-11-19 17:45:18.134782+02	ganymede	3731	feb	PFEMAN:	received Resync complete. 		10
1315783	2003-11-19 17:45:19+02	2003-11-19 17:45:19.997895+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 1, jnxFruL2Index 2, jnxFruL3Index 0, jnxFruName PIC:  @ 0/1/*, jnxFruType 11, jnxFruSlot 1, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 9970 		100
1315784	2003-11-19 17:45:19+02	2003-11-19 17:45:20.104632+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 1, jnxFruL2Index 3, jnxFruL3Index 0, jnxFruName PIC:  @ 0/2/*, jnxFruType 11, jnxFruSlot 1, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 9982 		100
1315780	2003-11-19 17:45:19+02	2003-11-19 17:45:19.255863+02	ganymede	3731	feb	CM:	Slot 0: On-line 		10
1315781	2003-11-19 17:45:19+02	2003-11-19 17:45:19.270825+02	ganymede	3731	feb	CM:	Slot 1: On-line 		10
1315782	2003-11-19 17:45:19+02	2003-11-19 17:45:19.879296+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 1, jnxFruL2Index 1, jnxFruL3Index 0, jnxFruName PIC:  @ 0/0/*, jnxFruType 11, jnxFruSlot 1, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 9960 		100
1315789	2003-11-19 17:45:20+02	2003-11-19 17:45:20.454404+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 2, jnxFruL2Index 2, jnxFruL3Index 0, jnxFruName PIC:  @ 1/1/*, jnxFruType 11, jnxFruSlot 2, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 10017 		100
1315791	2003-11-19 17:45:20+02	2003-11-19 17:45:20.692668+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 2, jnxFruL2Index 4, jnxFruL3Index 0, jnxFruName PIC:  @ 1/3/*, jnxFruType 11, jnxFruSlot 2, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 10041 		100
1315790	2003-11-19 17:45:20+02	2003-11-19 17:45:20.573794+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 2, jnxFruL2Index 3, jnxFruL3Index 0, jnxFruName PIC:  @ 1/2/*, jnxFruType 11, jnxFruSlot 2, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 10029 		100
1315788	2003-11-19 17:45:20+02	2003-11-19 17:45:20.336013+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 2, jnxFruL2Index 1, jnxFruL3Index 0, jnxFruName PIC:  @ 1/0/*, jnxFruType 11, jnxFruSlot 2, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 10006 		100
1353378	2003-11-21 17:45:16+02	2003-11-21 17:45:19.578136+02	atlas	3730	mgd[2866]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1353299	2003-11-21 17:45:16+02	2003-11-21 17:45:17.462604+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/proc/4433/file', PID 4890, status 0		1
1353319	2003-11-21 17:45:16+02	2003-11-21 17:45:17.861976+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1353322	2003-11-21 17:45:16+02	2003-11-21 17:45:18.098293+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 5150, status 0		1
1353263	2003-11-21 17:45:16+02	2003-11-21 17:45:16.803312+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/proc/4434/file', PID 4882, status 0		1
1353314	2003-11-21 17:45:16+02	2003-11-21 17:45:17.83709+02	atlas	3730	mgd[2866]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1353344	2003-11-21 17:45:16+02	2003-11-21 17:45:18.656176+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1353348	2003-11-21 17:45:16+02	2003-11-21 17:45:18.846153+02	ganymede	3731	mgd[2992]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1353310	2003-11-21 17:45:16+02	2003-11-21 17:45:17.681499+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1353271	2003-11-21 17:45:16+02	2003-11-21 17:45:16.838542+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/proc/4413/file'		1
1353363	2003-11-21 17:45:16+02	2003-11-21 17:45:19.223698+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353366	2003-11-21 17:45:16+02	2003-11-21 17:45:19.237386+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353354	2003-11-21 17:45:16+02	2003-11-21 17:45:19.049145+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1353332	2003-11-21 17:45:16+02	2003-11-21 17:45:18.397439+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1353287	2003-11-21 17:45:16+02	2003-11-21 17:45:17.236068+02	r201	3732	mgd[4881]:	UI_CHILD_START:	Starting child '/proc/4431/file'		1
1353266	2003-11-21 17:45:16+02	2003-11-21 17:45:16.815493+02	adrastea	3726	mgd[5142]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1353309	2003-11-21 17:45:16+02	2003-11-21 17:45:17.677133+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 5148, status 0		1
1353370	2003-11-21 17:45:16+02	2003-11-21 17:45:19.34724+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353288	2003-11-21 17:45:16+02	2003-11-21 17:45:17.244864+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1353281	2003-11-21 17:45:16+02	2003-11-21 17:45:17.01554+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 5145, status 0		1
1353267	2003-11-21 17:45:16+02	2003-11-21 17:45:16.821338+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/proc/4453/file', PID 4883, status 0		1
1353265	2003-11-21 17:45:16+02	2003-11-21 17:45:16.811693+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 2876, status 0		1
1353301	2003-11-21 17:45:16+02	2003-11-21 17:45:17.479814+02	adrastea	3726	mgd[5143]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1353256	2003-11-21 17:45:16+02	2003-11-21 17:45:16.659064+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/proc/2260/file', PID 2874, status 0		1
1353260	2003-11-21 17:45:16+02	2003-11-21 17:45:16.683566+02	r201	3732	mgd[4881]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1353382	2003-11-21 17:45:16+02	2003-11-21 17:45:19.697387+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353298	2003-11-21 17:45:16+02	2003-11-21 17:45:17.405827+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/proc/2246/file', PID 2998, status 0		1
1353371	2003-11-21 17:45:16+02	2003-11-21 17:45:19.353653+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353383	2003-11-21 17:45:16+02	2003-11-21 17:45:19.701361+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 3005, status 0		1
1353278	2003-11-21 17:45:16+02	2003-11-21 17:45:16.997503+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/proc/2234/file'		1
1353279	2003-11-21 17:45:16+02	2003-11-21 17:45:17.001313+02	r201	3732	mgd[4881]:	UI_CHILD_STATUS:	Cleanup child '/proc/4424/file', PID 4885, status 0		1
1353376	2003-11-21 17:45:16+02	2003-11-21 17:45:19.553027+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353395	2003-11-21 17:45:16+02	2003-11-21 17:45:20.002304+02	r201	3732	inetd[4419]:	/usr/libexec/telnetd[4879]:	exit status 0x100		10
1353268	2003-11-21 17:45:16+02	2003-11-21 17:45:16.825147+02	atlas	3730	mgd[2866]:	UI_CHILD_START:	Starting child '/proc/2268/file'		1
1353337	2003-11-21 17:45:16+02	2003-11-21 17:45:18.459172+02	adrastea	3726	mgd[5142]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1353338	2003-11-21 17:45:16+02	2003-11-21 17:45:18.464613+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 5157, status 0		1
1353312	2003-11-21 17:45:16+02	2003-11-21 17:45:17.799534+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/proc/2243/file'		1
1353294	2003-11-21 17:45:16+02	2003-11-21 17:45:17.389318+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/proc/2246/file'		1
1353379	2003-11-21 17:45:16+02	2003-11-21 17:45:19.582716+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5169, status 0		1
1353393	2003-11-21 17:45:16+02	2003-11-21 17:45:19.987366+02	r201	3732	mgd[4881]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1353394	2003-11-21 17:45:16+02	2003-11-21 17:45:19.997989+02	r201	3732	mgd[4881]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1353336	2003-11-21 17:45:16+02	2003-11-21 17:45:18.452628+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 5156, status 0		1
1353385	2003-11-21 17:45:16+02	2003-11-21 17:45:19.711744+02	ganymede	3731	mgd[2992]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353466	2003-11-21 17:45:17+02	2003-11-21 17:45:21.395791+02	adrastea	3726	mgd[5142]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1353443	2003-11-21 17:45:17+02	2003-11-21 17:45:21.033822+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1353459	2003-11-21 17:45:17+02	2003-11-21 17:45:21.209033+02	adrastea	3726	mgd[5143]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1353445	2003-11-21 17:45:17+02	2003-11-21 17:45:21.042396+02	atlas	3730	mgd[2866]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1353418	2003-11-21 17:45:17+02	2003-11-21 17:45:20.482167+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1353415	2003-11-21 17:45:17+02	2003-11-21 17:45:20.463397+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1353416	2003-11-21 17:45:17+02	2003-11-21 17:45:20.470711+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1353460	2003-11-21 17:45:17+02	2003-11-21 17:45:21.269138+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1315785	2003-11-19 17:45:20+02	2003-11-19 17:45:20.220696+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 8, jnxFruL1Index 1, jnxFruL2Index 4, jnxFruL3Index 0, jnxFruName PIC:  @ 0/3/*, jnxFruType 11, jnxFruSlot 1, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 9994 		100
1315822	2003-11-19 17:45:22+02	2003-11-19 17:45:23.130097+02	ganymede	3731	feb	sp-0/2:	Releasing the Apollo reset 		10
1315806	2003-11-19 17:45:22+02	2003-11-19 17:45:22.95452+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 130 <Broadcast Multicast>		10
1315837	2003-11-19 17:45:22+02	2003-11-19 17:45:23.449342+02	ganymede	3731	rpd[2252]:		EVENT Add sp-0/2/0.0 index 71 10.10.10.1 -> 10.10.10.2 <Broadcast PointToPoint Multicast>		10
1315815	2003-11-19 17:45:22+02	2003-11-19 17:45:23.100295+02	ganymede	3731	rpd[2252]:		EVENT <> so-0/1/0.0 index 70 <Broadcast PointToPoint Multicast>		10
1315813	2003-11-19 17:45:22+02	2003-11-19 17:45:22.99014+02	ganymede	3731	rpd[2252]:		bgp_listen_reset		10
1315821	2003-11-19 17:45:22+02	2003-11-19 17:45:23.126255+02	ganymede	3731	/kernel:	e1-0/0/0:	received CCC status, setting CCC-Down		10
1315820	2003-11-19 17:45:22+02	2003-11-19 17:45:23.122475+02	ganymede	3731	rpd[2252]:		EVENT Add so-0/1/0.0 index 70 <Broadcast PointToPoint Multicast>		10
1315841	2003-11-19 17:45:22+02	2003-11-19 17:45:23.466371+02	ganymede	3731	/kernel:	sp-0/2/0:	ifl config: op: 1; sub: 16383; flags: 0x8010, curr: 0xdead.		10
1315804	2003-11-19 17:45:22+02	2003-11-19 17:45:22.944584+02	ganymede	3731	rpd[2252]:		EVENT Add e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1315799	2003-11-19 17:45:22+02	2003-11-19 17:45:22.817551+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 129 <Broadcast Multicast>		10
1315802	2003-11-19 17:45:22+02	2003-11-19 17:45:22.830891+02	ganymede	3731	/kernel:	if_pfe_ds1:	Added nic 0, pic 0 port 2, chan 0, type 18(E1)		10
1315797	2003-11-19 17:45:22+02	2003-11-19 17:45:22.807763+02	ganymede	3731	rpd[2252]:		EVENT <Add> e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1315836	2003-11-19 17:45:22+02	2003-11-19 17:45:23.445476+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd ip-0/2/0 		10
1315811	2003-11-19 17:45:22+02	2003-11-19 17:45:22.982594+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 132 <Broadcast Multicast>		10
1315803	2003-11-19 17:45:22+02	2003-11-19 17:45:22.834642+02	ganymede	3731	rpd[2252]:		EVENT <> e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1315796	2003-11-19 17:45:22+02	2003-11-19 17:45:22.804033+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_DOWN:	ifIndex 77, ifAdminStatus up(1), ifOperStatus down(2), ifName e1-0/0/0.0		10
1315829	2003-11-19 17:45:22+02	2003-11-19 17:45:23.310216+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd pe-0/2/0 		10
1315812	2003-11-19 17:45:22+02	2003-11-19 17:45:22.986438+02	ganymede	3731	rpd[2252]:		EVENT <Add> so-0/1/0.0 index 70 <Broadcast PointToPoint Multicast>		10
1315795	2003-11-19 17:45:22+02	2003-11-19 17:45:22.800282+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd e1-0/0/1 		10
1315794	2003-11-19 17:45:22+02	2003-11-19 17:45:22.794651+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 128 <Broadcast Multicast>		10
1315838	2003-11-19 17:45:22+02	2003-11-19 17:45:23.455066+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 134 <Broadcast Multicast>		10
1315826	2003-11-19 17:45:22+02	2003-11-19 17:45:23.297881+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 133 <Broadcast Multicast>		10
1315814	2003-11-19 17:45:22+02	2003-11-19 17:45:23.094675+02	ganymede	3731	rpd[2252]:		EVENT <MTU> so-0/1/0.0 index 70 <Broadcast PointToPoint Multicast>		10
1315825	2003-11-19 17:45:22+02	2003-11-19 17:45:23.250169+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd pd-0/2/0 		10
1315798	2003-11-19 17:45:22+02	2003-11-19 17:45:22.813446+02	ganymede	3731	/kernel:	if_pfe_ds1:	Added nic 0, pic 0 port 1, chan 0, type 18(E1)		10
1315840	2003-11-19 17:45:22+02	2003-11-19 17:45:23.462621+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 135 <Broadcast Multicast>		10
1315824	2003-11-19 17:45:22+02	2003-11-19 17:45:23.244586+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 133 <Broadcast Multicast>		10
1315839	2003-11-19 17:45:22+02	2003-11-19 17:45:23.458886+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd vt-0/2/0 		10
1315823	2003-11-19 17:45:22+02	2003-11-19 17:45:23.133968+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd sp-0/2/0 		10
1315805	2003-11-19 17:45:22+02	2003-11-19 17:45:22.950602+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd e1-0/0/3 		10
1315827	2003-11-19 17:45:22+02	2003-11-19 17:45:23.301885+02	ganymede	3731	/kernel:	sp-0/2/0:	ifl config: op: 1; sub: 0; flags: 0x8010, curr: 0xdead.		10
1315793	2003-11-19 17:45:22+02	2003-11-19 17:45:22.682367+02	ganymede	3731	/kernel:	if_pfe_ds1:	Added nic 0, pic 0 port 0, chan 0, type 18(E1)		10
1315835	2003-11-19 17:45:22+02	2003-11-19 17:45:23.440273+02	ganymede	3731	rpd[2252]:		EVENT Add sp-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1315843	2003-11-19 17:45:22+02	2003-11-19 17:45:23.476171+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd mt-0/2/0 		10
1315828	2003-11-19 17:45:22+02	2003-11-19 17:45:23.306135+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 134 <Broadcast Multicast>		10
1315801	2003-11-19 17:45:22+02	2003-11-19 17:45:22.824988+02	ganymede	3731	rpd[2252]:		EVENT <MTU> e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1315792	2003-11-19 17:45:22+02	2003-11-19 17:45:22.651761+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd e1-0/0/0 		10
1315842	2003-11-19 17:45:22+02	2003-11-19 17:45:23.47028+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 136 <Broadcast Multicast>		10
1315810	2003-11-19 17:45:22+02	2003-11-19 17:45:22.975635+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd so-0/1/0 		10
1315819	2003-11-19 17:45:22+02	2003-11-19 17:45:23.118332+02	ganymede	3731	rpd[2252]:		EVENT <> so-0/1/0.0 index 70 <Broadcast PointToPoint Multicast>		10
1315816	2003-11-19 17:45:22+02	2003-11-19 17:45:23.104086+02	ganymede	3731	rpd[2252]:		EVENT Add so-0/1/0.0 index 70 <Broadcast PointToPoint Multicast>		10
1315800	2003-11-19 17:45:22+02	2003-11-19 17:45:22.821263+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd e1-0/0/2 		10
1315834	2003-11-19 17:45:22+02	2003-11-19 17:45:23.434659+02	ganymede	3731	rpd[2252]:		EVENT <> sp-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1315818	2003-11-19 17:45:22+02	2003-11-19 17:45:23.111792+02	ganymede	3731	rpd[2252]:		EVENT <MTU> so-0/1/0.0 index 70 <Broadcast PointToPoint Multicast>		10
1315817	2003-11-19 17:45:22+02	2003-11-19 17:45:23.107985+02	ganymede	3731	rpd[2252]:		EVENT Add so-0/1/0.0 index 70 192.3.1.1 -> 192.3.1.1 <Broadcast PointToPoint Multicast>		10
1315833	2003-11-19 17:45:22+02	2003-11-19 17:45:23.327169+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd gr-0/2/0 		10
1315808	2003-11-19 17:45:22+02	2003-11-19 17:45:22.962051+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 131 <Broadcast Multicast>		10
1315832	2003-11-19 17:45:22+02	2003-11-19 17:45:23.321613+02	ganymede	3731	rpd[2252]:		EVENT <MTU> sp-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1315807	2003-11-19 17:45:22+02	2003-11-19 17:45:22.958309+02	ganymede	3731	/kernel:	if_pfe_ds1:	Added nic 0, pic 0 port 3, chan 0, type 18(E1)		10
1315831	2003-11-19 17:45:22+02	2003-11-19 17:45:23.317891+02	ganymede	3731	/kernel:	in_services_ifarequest:	sp-0/2/0		10
1315830	2003-11-19 17:45:22+02	2003-11-19 17:45:23.31409+02	ganymede	3731	rpd[2252]:		EVENT <Add> sp-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1315852	2003-11-19 17:45:23+02	2003-11-19 17:45:23.619127+02	ganymede	3731	rpd[2252]:		EVENT Add sp-0/2/0.16383 index 72 10.0.0.1 -> 10.0.0.18 <Broadcast PointToPoint Multicast>		10
1315848	2003-11-19 17:45:23+02	2003-11-19 17:45:23.604073+02	ganymede	3731	rpd[2252]:		EVENT <Add> sp-0/2/0.16383 index 72 <Broadcast PointToPoint Multicast>		10
1315846	2003-11-19 17:45:23+02	2003-11-19 17:45:23.596189+02	ganymede	3731	/kernel:	in_services_ifarequest:	sp-0/2/0		10
1398220	2003-11-25 13:00:34+02	2003-11-25 13:00:34.749974+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1398221	2003-11-25 13:00:34+02	2003-11-25 13:00:34.759452+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1398222	2003-11-25 13:00:34+02	2003-11-25 13:00:34.763285+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1315844	2003-11-19 17:45:23+02	2003-11-19 17:45:23.584628+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_DOWN:	ifIndex 31, ifAdminStatus up(1), ifOperStatus down(2), ifName sp-0/2/0.16383		10
1315845	2003-11-19 17:45:23+02	2003-11-19 17:45:23.590349+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 137 <Broadcast Multicast>		10
1315847	2003-11-19 17:45:23+02	2003-11-19 17:45:23.600178+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 138 <Broadcast Multicast>		10
1315849	2003-11-19 17:45:23+02	2003-11-19 17:45:23.60791+02	ganymede	3731	rpd[2252]:		EVENT <MTU> sp-0/2/0.16383 index 72 <Broadcast PointToPoint Multicast>		10
1315853	2003-11-19 17:45:23+02	2003-11-19 17:45:23.623323+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 138 <Broadcast Multicast>		10
1315851	2003-11-19 17:45:23+02	2003-11-19 17:45:23.615397+02	ganymede	3731	rpd[2252]:		EVENT Add sp-0/2/0.16383 index 72 <Broadcast PointToPoint Multicast>		10
1315850	2003-11-19 17:45:23+02	2003-11-19 17:45:23.61164+02	ganymede	3731	rpd[2252]:		EVENT <> sp-0/2/0.16383 index 72 <Broadcast PointToPoint Multicast>		10
1315854	2003-11-19 17:45:23+02	2003-11-19 17:45:23.734645+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 139 <Broadcast Multicast>		10
1315862	2003-11-19 17:45:24+02	2003-11-19 17:45:24.799079+02	ganymede	3731	rpd[2252]:		EVENT Add mo-0/3/0.16383 index 73 <Broadcast PointToPoint Multicast>		10
1315861	2003-11-19 17:45:24+02	2003-11-19 17:45:24.793233+02	ganymede	3731	/kernel:	in_monitor_ifarequest:	mo-0/3/0		10
1315863	2003-11-19 17:45:24+02	2003-11-19 17:45:24.802901+02	ganymede	3731	rpd[2252]:		EVENT Add mo-0/3/0.16383 index 73 10.0.0.1 -> 10.0.0.19 <Broadcast PointToPoint Multicast>		10
1315859	2003-11-19 17:45:24+02	2003-11-19 17:45:24.690059+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_DOWN:	ifIndex 61, ifAdminStatus up(1), ifOperStatus down(2), ifName mo-0/3/0.16383		10
1315860	2003-11-19 17:45:24+02	2003-11-19 17:45:24.694011+02	ganymede	3731	rpd[2252]:		EVENT <MTU> mo-0/3/0.16383 index 73 <Broadcast PointToPoint Multicast>		10
1315858	2003-11-19 17:45:24+02	2003-11-19 17:45:24.684615+02	ganymede	3731	rpd[2252]:		EVENT <Add> mo-0/3/0.16383 index 73 <Broadcast PointToPoint Multicast>		10
1315857	2003-11-19 17:45:24+02	2003-11-19 17:45:24.680018+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 140 <Broadcast Multicast>		10
1315856	2003-11-19 17:45:24+02	2003-11-19 17:45:24.656327+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd mo-0/3/0 		10
1315870	2003-11-19 17:45:25+02	2003-11-19 17:45:25.475838+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd fe-1/0/2 		10
1315877	2003-11-19 17:45:25+02	2003-11-19 17:45:25.611651+02	ganymede	3731	rpd[2252]:		EVENT Add fe-1/0/3.0 index 74 11.0.0.2/24 -> 11.0.0.255 <Broadcast Multicast>		10
1315876	2003-11-19 17:45:25+02	2003-11-19 17:45:25.607863+02	ganymede	3731	rpd[2252]:		EVENT <MTU> fe-1/0/3.0 index 74 <Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1315869	2003-11-19 17:45:25+02	2003-11-19 17:45:25.47166+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 142 <Broadcast Multicast> address #0 0.90.69.a0.14.7f		10
1315875	2003-11-19 17:45:25+02	2003-11-19 17:45:25.604045+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_DOWN:	ifIndex 62, ifAdminStatus up(1), ifOperStatus down(2), ifName fe-1/0/3.0		10
1315868	2003-11-19 17:45:25+02	2003-11-19 17:45:25.466778+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd fe-1/0/1 		10
1315867	2003-11-19 17:45:25+02	2003-11-19 17:45:25.462967+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 141 <Broadcast Multicast> address #0 0.90.69.a0.14.7e		10
1315873	2003-11-19 17:45:25+02	2003-11-19 17:45:25.594695+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 144 <Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1315866	2003-11-19 17:45:25+02	2003-11-19 17:45:25.456773+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd fe-1/0/0 		10
1315871	2003-11-19 17:45:25+02	2003-11-19 17:45:25.480732+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 143 <Broadcast Multicast> address #0 0.90.69.a0.14.80		10
1315874	2003-11-19 17:45:25+02	2003-11-19 17:45:25.60029+02	ganymede	3731	rpd[2252]:		EVENT <Add> fe-1/0/3.0 index 74 <Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1315872	2003-11-19 17:45:25+02	2003-11-19 17:45:25.484891+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd fe-1/0/3 		10
1315889	2003-11-19 17:45:29+02	2003-11-19 17:45:29.752968+02	ganymede	3731	/kernel:	e1-0/0/3:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315914	2003-11-19 17:45:29+02	2003-11-19 17:45:30.2304+02	ganymede	3731	rpd[2252]:		EVENT UpDown fe-1/0/3.0 index 74 11.0.0.2/24 -> 11.0.0.255 <Up Broadcast Multicast>		10
1315907	2003-11-19 17:45:29+02	2003-11-19 17:45:30.094919+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 136 <Up Broadcast Multicast>		10
1315897	2003-11-19 17:45:29+02	2003-11-19 17:45:29.945041+02	ganymede	3731	/kernel:	fe-1/0/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315887	2003-11-19 17:45:29+02	2003-11-19 17:45:29.743374+02	ganymede	3731	/kernel:	e1-0/0/1:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315899	2003-11-19 17:45:29+02	2003-11-19 17:45:29.952774+02	ganymede	3731	/kernel:	fe-1/0/2:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315912	2003-11-19 17:45:29+02	2003-11-19 17:45:30.115905+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 141 <Up Broadcast Multicast> address #0 0.90.69.a0.14.7e		10
1315908	2003-11-19 17:45:29+02	2003-11-19 17:45:30.098788+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 137 <Up Broadcast Multicast>		10
1315906	2003-11-19 17:45:29+02	2003-11-19 17:45:30.091129+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 135 <Up Broadcast Multicast>		10
1315893	2003-11-19 17:45:29+02	2003-11-19 17:45:29.905154+02	ganymede	3731	/kernel:	ip-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315905	2003-11-19 17:45:29+02	2003-11-19 17:45:30.086533+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 134 <Up Broadcast Multicast>		10
1315894	2003-11-19 17:45:29+02	2003-11-19 17:45:29.930107+02	ganymede	3731	/kernel:	vt-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315895	2003-11-19 17:45:29+02	2003-11-19 17:45:29.935387+02	ganymede	3731	/kernel:	mt-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315903	2003-11-19 17:45:29+02	2003-11-19 17:45:30.076663+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 128 <Up Broadcast Multicast>		10
1315898	2003-11-19 17:45:29+02	2003-11-19 17:45:29.949016+02	ganymede	3731	/kernel:	fe-1/0/1:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315904	2003-11-19 17:45:29+02	2003-11-19 17:45:30.082724+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 133 <Broadcast Multicast>		10
1315896	2003-11-19 17:45:29+02	2003-11-19 17:45:29.939302+02	ganymede	3731	/kernel:	mo-0/3/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315886	2003-11-19 17:45:29+02	2003-11-19 17:45:29.738403+02	ganymede	3731	/kernel:	so-0/1/0:	Asserting SONET alarm(s) LOL LOS 		10
1315915	2003-11-19 17:45:29+02	2003-11-19 17:45:30.275169+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 144 <Up Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1315910	2003-11-19 17:45:29+02	2003-11-19 17:45:30.106238+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 139 <Up Broadcast Multicast>		10
1315911	2003-11-19 17:45:29+02	2003-11-19 17:45:30.109996+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 140 <Broadcast Multicast>		10
1315902	2003-11-19 17:45:29+02	2003-11-19 17:45:29.967178+02	ganymede	3731	rpd[2252]:		EVENT UpDown e1-0/0/0.0 index 69 <Up Broadcast PointToPoint Multicast>		10
1315909	2003-11-19 17:45:29+02	2003-11-19 17:45:30.102489+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 138 <Up Broadcast Multicast>		10
1315888	2003-11-19 17:45:29+02	2003-11-19 17:45:29.748211+02	ganymede	3731	/kernel:	e1-0/0/2:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315892	2003-11-19 17:45:29+02	2003-11-19 17:45:29.796538+02	ganymede	3731	/kernel:	gr-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315890	2003-11-19 17:45:29+02	2003-11-19 17:45:29.758312+02	ganymede	3731	/kernel:	pd-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315901	2003-11-19 17:45:29+02	2003-11-19 17:45:29.963204+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 73, ifAdminStatus up(1), ifOperStatus up(1), ifName e1-0/0/0		10
1315913	2003-11-19 17:45:29+02	2003-11-19 17:45:30.22473+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> fe-1/0/3.0 index 74 <Up Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1315900	2003-11-19 17:45:29+02	2003-11-19 17:45:29.959141+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> e1-0/0/0.0 index 69 <Up Broadcast PointToPoint Multicast>		10
1315891	2003-11-19 17:45:29+02	2003-11-19 17:45:29.763064+02	ganymede	3731	/kernel:	pe-0/2/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1315919	2003-11-19 17:45:30+02	2003-11-19 17:45:30.73443+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 32, ifAdminStatus up(1), ifOperStatus up(1), ifName pd-0/2/0		10
1315922	2003-11-19 17:45:30+02	2003-11-19 17:45:30.766188+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 38, ifAdminStatus up(1), ifOperStatus up(1), ifName ip-0/2/0		10
1315923	2003-11-19 17:45:30+02	2003-11-19 17:45:30.954808+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 39, ifAdminStatus up(1), ifOperStatus up(1), ifName vt-0/2/0		10
1315921	2003-11-19 17:45:30+02	2003-11-19 17:45:30.761785+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 36, ifAdminStatus up(1), ifOperStatus up(1), ifName gr-0/2/0		10
1315920	2003-11-19 17:45:30+02	2003-11-19 17:45:30.753292+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 35, ifAdminStatus up(1), ifOperStatus up(1), ifName pe-0/2/0		10
1315924	2003-11-19 17:45:30+02	2003-11-19 17:45:30.960539+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 40, ifAdminStatus up(1), ifOperStatus up(1), ifName mt-0/2/0		10
1315926	2003-11-19 17:45:30+02	2003-11-19 17:45:30.968016+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 51, ifAdminStatus up(1), ifOperStatus up(1), ifName fe-1/0/3		10
1315925	2003-11-19 17:45:30+02	2003-11-19 17:45:30.964295+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 46, ifAdminStatus up(1), ifOperStatus up(1), ifName fe-1/0/0		10
1337051	2003-11-20 15:28:09+02	2003-11-20 15:10:41.789049+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337053	2003-11-20 15:28:10+02	2003-11-20 15:10:42.799776+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337052	2003-11-20 15:28:10+02	2003-11-20 15:10:42.789859+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337054	2003-11-20 15:28:11+02	2003-11-20 15:10:43.796596+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337055	2003-11-20 15:28:11+02	2003-11-20 15:10:43.809749+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337056	2003-11-20 15:28:11+02	2003-11-20 15:10:43.813588+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337059	2003-11-20 15:28:12+02	2003-11-20 15:10:44.809332+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315932	2003-11-19 17:45:31+02	2003-11-19 17:45:31.56471+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 43 traps in queue 		2
1315930	2003-11-19 17:45:31+02	2003-11-19 17:45:31.452808+02	atlas	3730	rpd[4413]:	bgp_connect_start:	connect 10.100.254.20 (Internal AS 100): No route to host		10
1315929	2003-11-19 17:45:31+02	2003-11-19 17:45:31.448565+02	atlas	3730	rpd[4413]:	task_connect:	task BGP_100.10.100.254.20+179 addr 10.100.254.20+179: No route to host		10
1315931	2003-11-19 17:45:31+02	2003-11-19 17:45:31.459836+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 42 traps in queue 		2
1315933	2003-11-19 17:45:31+02	2003-11-19 17:45:31.569017+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 44 traps in queue 		2
1315928	2003-11-19 17:45:31+02	2003-11-19 17:45:31.439861+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 41 traps in queue 		2
1315962	2003-11-19 17:45:32+02	2003-11-19 17:45:33.034981+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd ge-1/3/0 		10
1315957	2003-11-19 17:45:32+02	2003-11-19 17:45:32.906544+02	ganymede	3731	rpd[2252]:		EVENT Add so-1/2/0.0 index 75 <Broadcast PointToPoint Multicast>		10
1315969	2003-11-19 17:45:32+02	2003-11-19 17:45:33.063232+02	ganymede	3731	rpd[2252]:		EVENT Add ge-1/3/0.0 index 76 <Broadcast Multicast>		10
1315960	2003-11-19 17:45:32+02	2003-11-19 17:45:32.919283+02	ganymede	3731	rpd[2252]:		EVENT <> so-1/2/0.0 index 75 <Broadcast PointToPoint Multicast>		10
1315943	2003-11-19 17:45:32+02	2003-11-19 17:45:32.727182+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1315944	2003-11-19 17:45:32+02	2003-11-19 17:45:32.732416+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1315942	2003-11-19 17:45:32+02	2003-11-19 17:45:32.705414+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1315968	2003-11-19 17:45:32+02	2003-11-19 17:45:33.059524+02	ganymede	3731	rpd[2252]:		EVENT <> ge-1/3/0.0 index 76 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1315955	2003-11-19 17:45:32+02	2003-11-19 17:45:32.898859+02	ganymede	3731	rpd[2252]:		EVENT <MTU> so-1/2/0.0 index 75 <Broadcast PointToPoint Multicast>		10
1315940	2003-11-19 17:45:32+02	2003-11-19 17:45:32.589069+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1315939	2003-11-19 17:45:32+02	2003-11-19 17:45:32.58259+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1315956	2003-11-19 17:45:32+02	2003-11-19 17:45:32.902657+02	ganymede	3731	rpd[2252]:		EVENT <> so-1/2/0.0 index 75 <Broadcast PointToPoint Multicast>		10
1315946	2003-11-19 17:45:32+02	2003-11-19 17:45:32.742322+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/0) ifd vptree not initialized		10
1315938	2003-11-19 17:45:32+02	2003-11-19 17:45:32.576152+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd at-1/1/0 		10
1315953	2003-11-19 17:45:32+02	2003-11-19 17:45:32.890427+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 147 <Broadcast Multicast>		10
1315954	2003-11-19 17:45:32+02	2003-11-19 17:45:32.894965+02	ganymede	3731	rpd[2252]:		EVENT <Add> so-1/2/0.0 index 75 <Broadcast PointToPoint Multicast>		10
1315952	2003-11-19 17:45:32+02	2003-11-19 17:45:32.884718+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd so-1/2/0 		10
1315965	2003-11-19 17:45:32+02	2003-11-19 17:45:33.048323+02	ganymede	3731	rpd[2252]:		EVENT <MTU> ge-1/3/0.0 index 76 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1315958	2003-11-19 17:45:32+02	2003-11-19 17:45:32.910323+02	ganymede	3731	rpd[2252]:		EVENT Add so-1/2/0.0 index 75 192.1.1.1 -> 192.1.1.1 <Broadcast PointToPoint Multicast>		10
1315963	2003-11-19 17:45:32+02	2003-11-19 17:45:33.040729+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 148 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1315967	2003-11-19 17:45:32+02	2003-11-19 17:45:33.055799+02	ganymede	3731	rpd[2252]:		EVENT <MTU> ge-1/3/0.0 index 76 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1315964	2003-11-19 17:45:32+02	2003-11-19 17:45:33.044605+02	ganymede	3731	rpd[2252]:		EVENT <Add> ge-1/3/0.0 index 76 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1315959	2003-11-19 17:45:32+02	2003-11-19 17:45:32.915275+02	ganymede	3731	rpd[2252]:		EVENT <MTU> so-1/2/0.0 index 75 <Broadcast PointToPoint Multicast>		10
1315945	2003-11-19 17:45:32+02	2003-11-19 17:45:32.737392+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1315948	2003-11-19 17:45:32+02	2003-11-19 17:45:32.758597+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1315972	2003-11-19 17:45:32+02	2003-11-19 17:45:33.184747+02	ganymede	3731	rpd[2252]:		EVENT Add ge-1/3/0.0 index 76 <Broadcast Multicast>		10
1315971	2003-11-19 17:45:32+02	2003-11-19 17:45:33.070888+02	ganymede	3731	rpd[2252]:		EVENT <> ge-1/3/0.0 index 76 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1315966	2003-11-19 17:45:32+02	2003-11-19 17:45:33.052033+02	ganymede	3731	rpd[2252]:		EVENT Add ge-1/3/0.0 index 76 1.0.0.1/30 -> 1.0.0.3 <Broadcast Multicast>		10
1315970	2003-11-19 17:45:32+02	2003-11-19 17:45:33.067168+02	ganymede	3731	rpd[2252]:		EVENT <MTU> ge-1/3/0.0 index 76 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1315941	2003-11-19 17:45:32+02	2003-11-19 17:45:32.59457+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/0) ifd vptree not initialized		10
1315949	2003-11-19 17:45:32+02	2003-11-19 17:45:32.767278+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 145 <Broadcast Multicast> address #0 0.90.69.a0.14.9d		10
1315947	2003-11-19 17:45:32+02	2003-11-19 17:45:32.751314+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1315961	2003-11-19 17:45:32+02	2003-11-19 17:45:32.924972+02	ganymede	3731	rpd[2252]:		EVENT Add so-1/2/0.0 index 75 <Broadcast PointToPoint Multicast>		10
1315950	2003-11-19 17:45:32+02	2003-11-19 17:45:32.772498+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_CREATE_NOTICE:	create_pics: add ifd at-1/1/1 		10
1315951	2003-11-19 17:45:32+02	2003-11-19 17:45:32.777678+02	ganymede	3731	rpd[2252]:		EVENT <Add Bandwidth MTU> index 146 <Broadcast Multicast> address #0 0.90.69.a0.14.9e		10
1315983	2003-11-19 17:45:33+02	2003-11-19 17:45:34.080426+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1355185	2003-11-21 18:48:44+02	2003-11-21 18:31:25.630368+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355186	2003-11-21 18:48:45+02	2003-11-21 18:31:26.632268+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355187	2003-11-21 18:48:45+02	2003-11-21 18:31:26.641556+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355190	2003-11-21 18:48:46+02	2003-11-21 18:31:27.659295+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355189	2003-11-21 18:48:46+02	2003-11-21 18:31:27.631878+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355191	2003-11-21 18:48:46+02	2003-11-21 18:31:27.663194+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355193	2003-11-21 18:48:47+02	2003-11-21 18:31:28.647483+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355194	2003-11-21 18:48:47+02	2003-11-21 18:31:28.707501+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355192	2003-11-21 18:48:47+02	2003-11-21 18:31:28.632637+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355195	2003-11-21 18:48:48+02	2003-11-21 18:31:29.632757+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355197	2003-11-21 18:48:48+02	2003-11-21 18:31:29.647048+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355196	2003-11-21 18:48:48+02	2003-11-21 18:31:29.643218+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355199	2003-11-21 18:48:49+02	2003-11-21 18:31:30.653347+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355198	2003-11-21 18:48:49+02	2003-11-21 18:31:30.633354+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355203	2003-11-21 18:48:50+02	2003-11-21 18:31:35.769684+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315991	2003-11-19 17:45:33+02	2003-11-19 17:45:34.110956+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1315976	2003-11-19 17:45:33+02	2003-11-19 17:45:33.898683+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 89 traps in queue 		2
1315990	2003-11-19 17:45:33+02	2003-11-19 17:45:34.107214+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/1) ifd vptree not initialized		10
1315985	2003-11-19 17:45:33+02	2003-11-19 17:45:34.08787+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/1) ifd vptree not initialized		10
1315989	2003-11-19 17:45:33+02	2003-11-19 17:45:34.102767+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1315993	2003-11-19 17:45:33+02	2003-11-19 17:45:34.231501+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 7, jnxFruL1Index 2, jnxFruL2Index 0, jnxFruL3Index 0, jnxFruName FPC @ 1/*/*, jnxFruType 3, jnxFruSlot 2, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 11373 		100
1315978	2003-11-19 17:45:33+02	2003-11-19 17:45:33.953878+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_UP:	ifIndex 22, ifAdminStatus up(1), ifOperStatus up(1), ifName ge-1/3/0		10
1315977	2003-11-19 17:45:33+02	2003-11-19 17:45:33.949973+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 90 traps in queue 		2
1315992	2003-11-19 17:45:33+02	2003-11-19 17:45:34.225658+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1315982	2003-11-19 17:45:33+02	2003-11-19 17:45:34.074804+02	r201	3732	rpd[4418]:		EVENT <UpDown> index 136 <Up Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1315988	2003-11-19 17:45:33+02	2003-11-19 17:45:34.099043+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1315981	2003-11-19 17:45:33+02	2003-11-19 17:45:33.965867+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 <Up Broadcast Multicast>		10
1315974	2003-11-19 17:45:33+02	2003-11-19 17:45:33.535449+02	ganymede	3731	chassisd[2222]:	CHASSISD_SNMP_TRAP10:	SNMP trap: FRU power on: jnxFruContentsIndex 7, jnxFruL1Index 1, jnxFruL2Index 0, jnxFruL3Index 0, jnxFruName FPC @ 0/*/*, jnxFruType 3, jnxFruSlot 1, jnxFruOfflineReason 2, jnxFruLastPowerOff 0, jnxFruLastPowerOn 11326 		100
1315979	2003-11-19 17:45:33+02	2003-11-19 17:45:33.957891+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 1.0.0.2/30 -> 1.0.0.3 <Up Broadcast Multicast>		10
1315980	2003-11-19 17:45:33+02	2003-11-19 17:45:33.962153+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 <Up Broadcast Multicast>		10
1315975	2003-11-19 17:45:33+02	2003-11-19 17:45:33.840832+02	r201	3732	rpd[4418]:		EVENT <UpDown> ge-1/3/0.0 index 69 <Up Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1315986	2003-11-19 17:45:33+02	2003-11-19 17:45:34.091563+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1315987	2003-11-19 17:45:33+02	2003-11-19 17:45:34.095327+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1315984	2003-11-19 17:45:33+02	2003-11-19 17:45:34.084164+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1315999	2003-11-19 17:45:34+02	2003-11-19 17:45:34.908034+02	ganymede	3731	tnp.tftpd[2404]:	TFTPD_CONNECT_INFO:	TFTP read from address 2 port 1 file monitor.jbf		10
1315994	2003-11-19 17:45:34+02	2003-11-19 17:45:34.235841+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_DOWN:	ifIndex 59, ifAdminStatus up(1), ifOperStatus down(2), ifName ge-1/3/0.0		10
1315998	2003-11-19 17:45:34+02	2003-11-19 17:45:34.878611+02	ganymede	3731	rpd[2252]:	RPD_LDP_NBRUP:	LDP neighbor 1.0.0.2 (ge-1/3/0.0) is up		10
1316002	2003-11-19 17:45:35+02	2003-11-19 17:45:35.645259+02	ganymede	3731	rpd[2252]:		EVENT UpDown ge-1/3/0.0 index 76 1.0.0.1/30 -> 1.0.0.3 <Up Broadcast Multicast>		10
1316007	2003-11-19 17:45:35+02	2003-11-19 17:45:35.666676+02	ganymede	3731	rpd[2252]:	RPD_ISIS_ADJUP:	IS-IS new L2 adjacency to 0011.1122.2225 on ge-1/3/0.0		10
1316001	2003-11-19 17:45:35+02	2003-11-19 17:45:35.535603+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 58, ifAdminStatus up(1), ifOperStatus up(1), ifName ge-1/3/0		10
1316000	2003-11-19 17:45:35+02	2003-11-19 17:45:35.197694+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> ge-1/3/0.0 index 76 <Up Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1316006	2003-11-19 17:45:35+02	2003-11-19 17:45:35.662703+02	r201	3732	rpd[4418]:	RPD_ISIS_ADJUP:	IS-IS new L2 adjacency to ganymede on ge-1/3/0.0		10
1316005	2003-11-19 17:45:35+02	2003-11-19 17:45:35.658941+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 148 <Up Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1316004	2003-11-19 17:45:35+02	2003-11-19 17:45:35.654996+02	ganymede	3731	rpd[2252]:		EVENT UpDown ge-1/3/0.0 index 76 <Up Broadcast Multicast>		10
1316003	2003-11-19 17:45:35+02	2003-11-19 17:45:35.651021+02	ganymede	3731	rpd[2252]:		EVENT UpDown ge-1/3/0.0 index 76 <Up Broadcast Multicast>		10
1316008	2003-11-19 17:45:36+02	2003-11-19 17:45:36.205779+02	r201	3732	rpd[4418]:	RPD_LDP_NBRUP:	LDP neighbor 1.0.0.1 (ge-1/3/0.0) is up		10
1316012	2003-11-19 17:45:36+02	2003-11-19 17:45:36.676889+02	ganymede	3731	tnp.tftpd[2404]:	TFTPD_SENDCOMPLETE_INFO:	Sent 688 blocks of 1024 and 1 block of 40 for file '/usr/share/pfe/monitor.jbf' 		10
1316013	2003-11-19 17:45:36+02	2003-11-19 17:45:36.694295+02	ganymede	3731	feb		Monitor FTP 0.3: total retrieved 704552 bytes. 		10
1316020	2003-11-19 17:45:37+02	2003-11-19 17:45:37.416746+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 94 traps in queue 		2
1316024	2003-11-19 17:45:37+02	2003-11-19 17:45:37.554243+02	ganymede	3731	rpd[2252]:	RPD_LDP_SESSIONUP:	LDP session 10.100.254.23 is up		10
1316021	2003-11-19 17:45:37+02	2003-11-19 17:45:37.430939+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 45 traps in queue 		2
1316019	2003-11-19 17:45:37+02	2003-11-19 17:45:37.405002+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 93 traps in queue 		2
1316016	2003-11-19 17:45:37+02	2003-11-19 17:45:37.306287+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 92 traps in queue 		2
1316015	2003-11-19 17:45:37+02	2003-11-19 17:45:37.258222+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 91 traps in queue 		2
1316018	2003-11-19 17:45:37+02	2003-11-19 17:45:37.379907+02	ganymede	3731	/kernel:	at-1/1/1:	Asserting SONET alarm(s) LOL LOS 		10
1337058	2003-11-20 15:28:12+02	2003-11-20 15:10:44.805564+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337057	2003-11-20 15:28:12+02	2003-11-20 15:10:44.790529+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337061	2003-11-20 15:28:13+02	2003-11-20 15:10:45.844007+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337062	2003-11-20 15:28:13+02	2003-11-20 15:10:45.955975+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337060	2003-11-20 15:28:13+02	2003-11-20 15:10:45.826031+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337063	2003-11-20 15:28:14+02	2003-11-20 15:10:46.791491+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337064	2003-11-20 15:28:14+02	2003-11-20 15:10:46.812625+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337074	2003-11-20 15:28:15+02	2003-11-20 15:10:53.526739+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1316023	2003-11-19 17:45:37+02	2003-11-19 17:45:37.550434+02	ganymede	3731	/kernel:	so-1/2/0:	Asserting SONET alarm(s) LOL LOS 		10
1316017	2003-11-19 17:45:37+02	2003-11-19 17:45:37.336+02	ganymede	3731	/kernel:	at-1/1/0:	Asserting SONET alarm(s) LOL LOS 		10
1316014	2003-11-19 17:45:37+02	2003-11-19 17:45:37.221601+02	r201	3732	rpd[4418]:	RPD_LDP_SESSIONUP:	LDP session 10.100.254.20 is up		10
1316022	2003-11-19 17:45:37+02	2003-11-19 17:45:37.54485+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 46 traps in queue 		2
1316036	2003-11-19 17:45:38+02	2003-11-19 17:45:39.006956+02	ganymede	3731	feb		Monitor IPC 0.3: passing loopback (Disable) to MIPS. 		10
1316035	2003-11-19 17:45:38+02	2003-11-19 17:45:38.807742+02	ganymede	3731	feb		Monitor PIC 0.3: ++Version 6.1R1.4 by builder on 2003-10-09 21:12:36 UTC 		10
1316034	2003-11-19 17:45:38+02	2003-11-19 17:45:38.758447+02	ganymede	3731	feb	PFEMAN:	Bound PIC 0/3 		10
1316039	2003-11-19 17:45:39+02	2003-11-19 17:45:39.288903+02	ganymede	3731	rpd[2252]:		EVENT UpDown sp-0/2/0.16383 index 72 <Up Broadcast PointToPoint Multicast>		10
1316041	2003-11-19 17:45:39+02	2003-11-19 17:45:39.405739+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 133 <Up Broadcast Multicast>		10
1316040	2003-11-19 17:45:39+02	2003-11-19 17:45:39.292931+02	ganymede	3731	rpd[2252]:		EVENT UpDown sp-0/2/0.16383 index 72 10.0.0.1 -> 10.0.0.18 <Up Broadcast PointToPoint Multicast>		10
1316038	2003-11-19 17:45:39+02	2003-11-19 17:45:39.284925+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 29, ifAdminStatus up(1), ifOperStatus up(1), ifName sp-0/2/0		10
1316037	2003-11-19 17:45:39+02	2003-11-19 17:45:39.277984+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> sp-0/2/0.16383 index 72 <Up Broadcast PointToPoint Multicast>		10
1316043	2003-11-19 17:45:40+02	2003-11-19 17:45:40.29656+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> mo-0/3/0.16383 index 73 <Up Broadcast PointToPoint Multicast>		10
1316042	2003-11-19 17:45:40+02	2003-11-19 17:45:40.279233+02	ganymede	3731	/kernel:	mo-0/3/0:	mfr_bl_linkstate_child_ifd_change: can't find unit 0 ifl		10
1316047	2003-11-19 17:45:40+02	2003-11-19 17:45:40.366764+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 140 <Up Broadcast Multicast>		10
1316046	2003-11-19 17:45:40+02	2003-11-19 17:45:40.363023+02	ganymede	3731	rpd[2252]:		EVENT UpDown mo-0/3/0.16383 index 73 10.0.0.1 -> 10.0.0.19 <Up Broadcast PointToPoint Multicast>		10
1316044	2003-11-19 17:45:40+02	2003-11-19 17:45:40.300475+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 60, ifAdminStatus up(1), ifOperStatus up(1), ifName mo-0/3/0		10
1316045	2003-11-19 17:45:40+02	2003-11-19 17:45:40.359169+02	ganymede	3731	rpd[2252]:		EVENT UpDown mo-0/3/0.16383 index 73 <Up Broadcast PointToPoint Multicast>		10
1316053	2003-11-19 17:45:41+02	2003-11-19 17:45:41.618247+02	ganymede	3731	feb		Monitor PIC 0.3: ++Monitor: SAMPLEDC: Connected to sampled 		10
1316055	2003-11-19 17:45:41+02	2003-11-19 17:45:41.743595+02	ganymede	3731	feb		Monitor PIC 0.3: ++Monitor: RTSPC: IFL --> SNMP resync completed 		10
1316054	2003-11-19 17:45:41+02	2003-11-19 17:45:41.667902+02	ganymede	3731	feb		Monitor PIC 0.3: ++Monitor: RTSPC: Connected to rtspd 		10
1316066	2003-11-19 17:45:45+02	2003-11-19 17:45:45.76048+02	ganymede	3731	feb		Monitor PIC 0.3: ++Monitor: SAMPLEDC: Route record resync completed 		10
1348301	2003-11-20 20:23:05+02	2003-11-20 20:23:05.76838+02	adrastea	3726	xntpd[2231]:		offset -0.000475 sec freq 76.483 ppm error 0.000830 poll 10		500
1347684	2003-11-20 20:23:15+02	2003-11-20 20:05:49.05973+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347687	2003-11-20 20:23:16+02	2003-11-20 20:05:50.081919+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347686	2003-11-20 20:23:16+02	2003-11-20 20:05:50.061277+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347690	2003-11-20 20:23:17+02	2003-11-20 20:05:51.081451+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347688	2003-11-20 20:23:17+02	2003-11-20 20:05:51.061011+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1316074	2003-11-19 17:45:50+02	2003-11-19 17:45:50.740411+02	ganymede	3731	Slot		0, PIC Slot 2) Version 6.1R1.4 by builder on 2003-10-09 21:13:30 UTC 		10
1316073	2003-11-19 17:45:50+02	2003-11-19 17:45:50.736653+02	ganymede	3731	Slot		0, PIC Slot 2) PFEMAN: Established connection to Master 		10
1316075	2003-11-19 17:45:50+02	2003-11-19 17:45:50.74423+02	ganymede	3731	Slot		0, PIC Slot 2) SNTPD: Initial time of day set. 		10
1316076	2003-11-19 17:45:50+02	2003-11-19 17:45:50.979801+02	ganymede	3731	Slot		0, PIC Slot 2) Loopback mode is now disabled 		10
1316072	2003-11-19 17:45:50+02	2003-11-19 17:45:50.732681+02	ganymede	3731	Slot		0, PIC Slot 2) PFEMAN: Session manager active 		10
1316071	2003-11-19 17:45:50+02	2003-11-19 17:45:50.726865+02	ganymede	3731	/kernel:	pic_listener_connect:	conn established: listener idx=16, addr=0x1200000a		10
1316070	2003-11-19 17:45:50+02	2003-11-19 17:45:50.608013+02	ganymede	3731	/kernel:		pfe_peer_alloc !VALID(state 0)->OPENING tnp 301989898		10
1316079	2003-11-19 17:45:51+02	2003-11-19 17:45:51.145872+02	ganymede	3731	Slot		0, PIC Slot 2) ifl_tbl: Adding channel entry for ifl 71: 8191 		10
1316086	2003-11-19 17:45:51+02	2003-11-19 17:45:51.647096+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 56, ifAdminStatus up(1), ifOperStatus up(1), ifName sp-0/2/0.0		10
1316085	2003-11-19 17:45:51+02	2003-11-19 17:45:51.643217+02	ganymede	3731	rpd[2252]:		EVENT <MTU> index 133 <Up Broadcast Multicast>		10
1316092	2003-11-19 17:45:51+02	2003-11-19 17:45:51.780656+02	ganymede	3731	Slot		0, PIC Slot 2) ifl_tbl: unit 0 change ifl(71) 		10
1316084	2003-11-19 17:45:51+02	2003-11-19 17:45:51.637341+02	ganymede	3731	/kernel:	set_pfe_sample_params:	rate 1, pps 1000, NH-id 301, class 1, af 2, run-len 0		10
1316087	2003-11-19 17:45:51+02	2003-11-19 17:45:51.650817+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> sp-0/2/0.0 index 71 <Up Broadcast PointToPoint Multicast>		10
1316083	2003-11-19 17:45:51+02	2003-11-19 17:45:51.425516+02	ganymede	3731	Slot		0, PIC Slot 2) PIC online and initial configuration received 		10
1316077	2003-11-19 17:45:51+02	2003-11-19 17:45:51.136038+02	ganymede	3731	Slot		0, PIC Slot 2) PFEMAN: sent resync request to master 		10
1316081	2003-11-19 17:45:51+02	2003-11-19 17:45:51.41599+02	ganymede	3731	Slot		0, PIC Slot 2) ifl_tbl: added subunit 0 ip address 10.10.10.1 		10
1316078	2003-11-19 17:45:51+02	2003-11-19 17:45:51.142003+02	ganymede	3731	Slot		0, PIC Slot 2) ifl_tbl: unit 0 add ifl(71) 		10
1316090	2003-11-19 17:45:51+02	2003-11-19 17:45:51.663457+02	ganymede	3731	Slot		0, PIC Slot 2) ifl_tbl: Updating alias for ifl 71 from 0 to 0 		10
1316082	2003-11-19 17:45:51+02	2003-11-19 17:45:51.421704+02	ganymede	3731	Slot		0, PIC Slot 2) PFEMAN: Got the resync ACK 		10
1316091	2003-11-19 17:45:51+02	2003-11-19 17:45:51.775083+02	ganymede	3731	Slot		0, PIC Slot 2) ip_update_rt_ifl() update [71][0] 		10
1316088	2003-11-19 17:45:51+02	2003-11-19 17:45:51.6553+02	ganymede	3731	rpd[2252]:		EVENT UpDown sp-0/2/0.0 index 71 <Up Broadcast PointToPoint Multicast>		10
1316089	2003-11-19 17:45:51+02	2003-11-19 17:45:51.659659+02	ganymede	3731	rpd[2252]:		EVENT UpDown sp-0/2/0.0 index 71 10.10.10.1 -> 10.10.10.2 <Up Broadcast PointToPoint Multicast>		10
1316093	2003-11-19 17:45:52+02	2003-11-19 17:45:53.018971+02	ganymede	3731	feb		Monitor PIC 0.3: ++SNTPD: Initial time of day set. 		10
1353420	2003-11-21 17:45:17+02	2003-11-21 17:45:20.497289+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1353446	2003-11-21 17:45:17+02	2003-11-21 17:45:21.047043+02	atlas	3730	mgd[2866]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1353403	2003-11-21 17:45:17+02	2003-11-21 17:45:20.207692+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1353409	2003-11-21 17:45:17+02	2003-11-21 17:45:20.263933+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1353449	2003-11-21 17:45:17+02	2003-11-21 17:45:21.060177+02	adrastea	3726	mgd[5143]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1353408	2003-11-21 17:45:17+02	2003-11-21 17:45:20.259018+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1353444	2003-11-21 17:45:17+02	2003-11-21 17:45:21.0385+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1353439	2003-11-21 17:45:17+02	2003-11-21 17:45:20.860184+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1353440	2003-11-21 17:45:17+02	2003-11-21 17:45:20.864017+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1353423	2003-11-21 17:45:17+02	2003-11-21 17:45:20.624089+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1353422	2003-11-21 17:45:17+02	2003-11-21 17:45:20.617613+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1353430	2003-11-21 17:45:17+02	2003-11-21 17:45:20.700913+02	ganymede	3731	last		message repeated 5 times		10
1353447	2003-11-21 17:45:17+02	2003-11-21 17:45:21.050906+02	atlas	3730	inetd[2245]:	/usr/libexec/telnetd[2864]:	exit status 0x100		10
1353424	2003-11-21 17:45:17+02	2003-11-21 17:45:20.629173+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1353462	2003-11-21 17:45:17+02	2003-11-21 17:45:21.377857+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bd5cfc/32		10
1353404	2003-11-21 17:45:17+02	2003-11-21 17:45:20.213155+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bd63fc/32		10
1353455	2003-11-21 17:45:17+02	2003-11-21 17:45:21.191433+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353451	2003-11-21 17:45:17+02	2003-11-21 17:45:21.067826+02	adrastea	3726	mgd[5142]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5170, status 0		1
1353452	2003-11-21 17:45:17+02	2003-11-21 17:45:21.177423+02	ganymede	3731	mgd[2992]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1353421	2003-11-21 17:45:17+02	2003-11-21 17:45:20.505583+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1353453	2003-11-21 17:45:17+02	2003-11-21 17:45:21.183805+02	ganymede	3731	mgd[2992]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1353454	2003-11-21 17:45:17+02	2003-11-21 17:45:21.187602+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[2990]:	exit status 0x100		10
1353433	2003-11-21 17:45:17+02	2003-11-21 17:45:20.825123+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1353457	2003-11-21 17:45:17+02	2003-11-21 17:45:21.201098+02	adrastea	3726	mgd[5143]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1353434	2003-11-21 17:45:17+02	2003-11-21 17:45:20.828953+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bad1fc/32		10
1353425	2003-11-21 17:45:17+02	2003-11-21 17:45:20.633741+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1353397	2003-11-21 17:45:17+02	2003-11-21 17:45:20.016574+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1ba1ffc/32		10
1353407	2003-11-21 17:45:17+02	2003-11-21 17:45:20.254916+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1353412	2003-11-21 17:45:17+02	2003-11-21 17:45:20.390581+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1353417	2003-11-21 17:45:17+02	2003-11-21 17:45:20.477913+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1353463	2003-11-21 17:45:17+02	2003-11-21 17:45:21.384388+02	adrastea	3726	last		message repeated 4 times		10
1353419	2003-11-21 17:45:17+02	2003-11-21 17:45:20.486346+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1353458	2003-11-21 17:45:17+02	2003-11-21 17:45:21.205104+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5172, status 0		1
1353450	2003-11-21 17:45:17+02	2003-11-21 17:45:21.064042+02	ganymede	3731	mgd[2992]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 3006, status 0		1
1353413	2003-11-21 17:45:17+02	2003-11-21 17:45:20.441779+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1353410	2003-11-21 17:45:17+02	2003-11-21 17:45:20.269353+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1353411	2003-11-21 17:45:17+02	2003-11-21 17:45:20.274454+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1353399	2003-11-21 17:45:17+02	2003-11-21 17:45:20.03034+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1353426	2003-11-21 17:45:17+02	2003-11-21 17:45:20.638378+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1353461	2003-11-21 17:45:17+02	2003-11-21 17:45:21.272931+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1353456	2003-11-21 17:45:17+02	2003-11-21 17:45:21.19729+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5171, status 0		1
1353448	2003-11-21 17:45:17+02	2003-11-21 17:45:21.055469+02	adrastea	3726	mgd[5143]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1353396	2003-11-21 17:45:17+02	2003-11-21 17:45:20.011023+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1353467	2003-11-21 17:45:17+02	2003-11-21 17:45:21.400472+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[5138]:	exit status 0x100		10
1353464	2003-11-21 17:45:17+02	2003-11-21 17:45:21.388321+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1353438	2003-11-21 17:45:17+02	2003-11-21 17:45:20.856495+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1353441	2003-11-21 17:45:17+02	2003-11-21 17:45:20.867925+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1353442	2003-11-21 17:45:17+02	2003-11-21 17:45:21.027733+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/1) ifd vptree not initialized		10
1353435	2003-11-21 17:45:17+02	2003-11-21 17:45:20.832656+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1353429	2003-11-21 17:45:17+02	2003-11-21 17:45:20.697109+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bad1fc/32		10
1353437	2003-11-21 17:45:17+02	2003-11-21 17:45:20.852746+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/0) ifd vptree not initialized		10
1353405	2003-11-21 17:45:17+02	2003-11-21 17:45:20.222699+02	adrastea	3726	last		message repeated 4 times		10
1353427	2003-11-21 17:45:17+02	2003-11-21 17:45:20.64303+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 5167, status 0		1
1337768	2003-11-20 15:31:31+02	2003-11-20 15:31:32.05985+02	ganymede	3731	xntpd[2770]:		offset -0.000019 sec freq 84.874 ppm error 0.000410 poll 9		500
1316214	2003-11-19 17:46:35+02	2003-11-19 17:46:35.482085+02	ganymede	3731	rpd[2252]:	bgp_pp_recv:	dropping 10.100.254.21 (Internal AS 100), connection collision prefers 10.100.254.21+1675 (proto)		10
1316215	2003-11-19 17:46:35+02	2003-11-19 17:46:35.488313+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 49 traps in queue 		2
1316212	2003-11-19 17:46:35+02	2003-11-19 17:46:35.456943+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 47 traps in queue 		2
1316213	2003-11-19 17:46:35+02	2003-11-19 17:46:35.478298+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 48 traps in queue 		2
1316216	2003-11-19 17:46:35+02	2003-11-19 17:46:35.502083+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 50 traps in queue 		2
1316246	2003-11-19 17:46:37+02	2003-11-19 17:46:37.810388+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 128 <Broadcast Multicast>		10
1316245	2003-11-19 17:46:37+02	2003-11-19 17:46:37.805043+02	ganymede	3731	rpd[2252]:		EVENT UpDown e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1316248	2003-11-19 17:46:37+02	2003-11-19 17:46:38.09385+02	atlas	3730	rpd[4413]:	RPD_LAYER2_VC_UP:	 Layer-2 VC (VPN : x25_cqt, local-site : 1, remote-site : 2) state changed to UP		10
1316244	2003-11-19 17:46:37+02	2003-11-19 17:46:37.798005+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_DOWN:	ifIndex 73, ifAdminStatus up(1), ifOperStatus down(2), ifName e1-0/0/0		10
1316243	2003-11-19 17:46:37+02	2003-11-19 17:46:37.784235+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1316250	2003-11-19 17:46:38+02	2003-11-19 17:46:38.765758+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 73, ifAdminStatus up(1), ifOperStatus up(1), ifName e1-0/0/0		10
1316252	2003-11-19 17:46:38+02	2003-11-19 17:46:38.832867+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 128 <Up Broadcast Multicast>		10
1347689	2003-11-20 20:23:17+02	2003-11-20 20:05:51.077634+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347694	2003-11-20 20:23:18+02	2003-11-20 20:05:52.178399+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347693	2003-11-20 20:23:18+02	2003-11-20 20:05:52.173146+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347692	2003-11-20 20:23:18+02	2003-11-20 20:05:52.061326+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347695	2003-11-20 20:23:19+02	2003-11-20 20:05:53.061884+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347697	2003-11-20 20:23:19+02	2003-11-20 20:05:53.08708+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347696	2003-11-20 20:23:19+02	2003-11-20 20:05:53.083305+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347699	2003-11-20 20:23:20+02	2003-11-20 20:05:54.078996+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347698	2003-11-20 20:23:20+02	2003-11-20 20:05:54.062523+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347702	2003-11-20 20:23:21+02	2003-11-20 20:06:01.113945+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1316249	2003-11-19 17:46:38+02	2003-11-19 17:46:38.656635+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> e1-0/0/0.0 index 69 <Up Broadcast PointToPoint Multicast>		10
1316251	2003-11-19 17:46:38+02	2003-11-19 17:46:38.771414+02	ganymede	3731	rpd[2252]:		EVENT UpDown e1-0/0/0.0 index 69 <Up Broadcast PointToPoint Multicast>		10
1316256	2003-11-19 17:46:39+02	2003-11-19 17:46:40.059022+02	atlas	3730	rpd[4413]:	RPD_LAYER2_VC_DOWN:	 Layer-2 VC (VPN : x25_cqt, local-site : 1, remote-site : 2) state changed from UP to VC-Dn		10
1316255	2003-11-19 17:46:39+02	2003-11-19 17:46:40.049948+02	atlas	3730	/kernel:	e1-0/0/0:	received CCC status, removing CCC-Down status		10
1316257	2003-11-19 17:46:40+02	2003-11-19 17:46:40.157356+02	ganymede	3731	rpd[2252]:	RPD_LAYER2_VC_UP:	 Layer-2 VC (VPN : x25_cqt, local-site : 2, remote-site : 1) state changed to UP		10
1316269	2003-11-19 17:46:41+02	2003-11-19 17:46:42.276195+02	atlas	3730	rpd[4413]:	RPD_LAYER2_VC_UP:	 Layer-2 VC (VPN : x25_cqt, local-site : 1, remote-site : 2) state changed to UP		10
1316268	2003-11-19 17:46:41+02	2003-11-19 17:46:41.899791+02	atlas	3730	/kernel:	e1-0/0/0:	received CCC status, setting CCC-Down		10
1337214	2003-11-20 15:33:09+02	2003-11-20 15:15:41.867377+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337219	2003-11-20 15:33:10+02	2003-11-20 15:15:42.882421+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337218	2003-11-20 15:33:10+02	2003-11-20 15:15:42.868832+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337221	2003-11-20 15:33:11+02	2003-11-20 15:15:43.878243+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337222	2003-11-20 15:33:11+02	2003-11-20 15:15:43.882234+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337220	2003-11-20 15:33:11+02	2003-11-20 15:15:43.863569+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337225	2003-11-20 15:33:12+02	2003-11-20 15:15:44.878383+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337224	2003-11-20 15:33:12+02	2003-11-20 15:15:44.874528+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337223	2003-11-20 15:33:12+02	2003-11-20 15:15:44.864393+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337227	2003-11-20 15:33:13+02	2003-11-20 15:15:45.864336+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337229	2003-11-20 15:33:13+02	2003-11-20 15:15:45.88783+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337228	2003-11-20 15:33:13+02	2003-11-20 15:15:45.88401+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337231	2003-11-20 15:33:14+02	2003-11-20 15:15:46.865007+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337232	2003-11-20 15:33:14+02	2003-11-20 15:15:46.927127+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337240	2003-11-20 15:33:15+02	2003-11-20 15:15:53.552612+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337876	2003-11-20 15:34:35+02	2003-11-20 15:34:35.300284+02	atlas	3730	xntpd[2692]:		offset 0.000682 sec freq 78.095 ppm error 0.000227 poll 9		500
1316458	2003-11-19 17:46:59+02	2003-11-19 17:46:59.994541+02	ganymede	3731	/kernel:	e1-0/0/0:	received CCC status, removing CCC-Down status		10
1316476	2003-11-19 17:47:07+02	2003-11-19 17:47:07.472356+02	atlas	3730	/kernel:	e1-0/0/0:	received CCC status, removing CCC-Down status		10
1353414	2003-11-21 17:45:17+02	2003-11-21 17:45:20.455236+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1353400	2003-11-21 17:45:17+02	2003-11-21 17:45:20.034988+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1353402	2003-11-21 17:45:17+02	2003-11-21 17:45:20.197657+02	atlas	3730	mgd[2866]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2880, status 0		1
1353465	2003-11-21 17:45:17+02	2003-11-21 17:45:21.392072+02	adrastea	3726	mgd[5142]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1353398	2003-11-21 17:45:17+02	2003-11-21 17:45:20.025584+02	atlas	3730	last		message repeated 2 times		10
1353431	2003-11-21 17:45:17+02	2003-11-21 17:45:20.704712+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1353428	2003-11-21 17:45:17+02	2003-11-21 17:45:20.649178+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1353432	2003-11-21 17:45:17+02	2003-11-21 17:45:20.819307+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bad1fc/32		10
1353436	2003-11-21 17:45:17+02	2003-11-21 17:45:20.847557+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1353489	2003-11-21 17:45:18+02	2003-11-21 17:45:21.724996+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1353494	2003-11-21 17:45:18+02	2003-11-21 17:45:21.857431+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1353485	2003-11-21 17:45:18+02	2003-11-21 17:45:21.706316+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1353479	2003-11-21 17:45:18+02	2003-11-21 17:45:21.568527+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1353492	2003-11-21 17:45:18+02	2003-11-21 17:45:21.849663+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1353497	2003-11-21 17:45:18+02	2003-11-21 17:45:21.918884+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1353493	2003-11-21 17:45:18+02	2003-11-21 17:45:21.853553+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1353488	2003-11-21 17:45:18+02	2003-11-21 17:45:21.720965+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1353495	2003-11-21 17:45:18+02	2003-11-21 17:45:21.911043+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1353499	2003-11-21 17:45:18+02	2003-11-21 17:45:21.93844+02	adrastea	3726	mgd[5143]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 5173, status 0		1
1353482	2003-11-21 17:45:18+02	2003-11-21 17:45:21.690041+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1353481	2003-11-21 17:45:18+02	2003-11-21 17:45:21.683826+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1353484	2003-11-21 17:45:18+02	2003-11-21 17:45:21.701713+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1353491	2003-11-21 17:45:18+02	2003-11-21 17:45:21.843094+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1353496	2003-11-21 17:45:18+02	2003-11-21 17:45:21.915011+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1353490	2003-11-21 17:45:18+02	2003-11-21 17:45:21.837468+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1353498	2003-11-21 17:45:18+02	2003-11-21 17:45:21.923145+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1353486	2003-11-21 17:45:18+02	2003-11-21 17:45:21.711361+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1353487	2003-11-21 17:45:18+02	2003-11-21 17:45:21.715921+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1353483	2003-11-21 17:45:18+02	2003-11-21 17:45:21.697772+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1353480	2003-11-21 17:45:18+02	2003-11-21 17:45:21.678122+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1353545	2003-11-21 17:45:19+02	2003-11-21 17:45:23.136882+02	adrastea	3726	mgd[5143]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1353547	2003-11-21 17:45:19+02	2003-11-21 17:45:23.155998+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[5140]:	exit status 0x100		10
1353544	2003-11-21 17:45:19+02	2003-11-21 17:45:23.131804+02	adrastea	3726	mgd[5143]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1311902	2003-11-19 17:47:40+02	2003-11-19 17:30:05.501791+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311912	2003-11-19 17:47:41+02	2003-11-19 17:30:06.5172+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311911	2003-11-19 17:47:41+02	2003-11-19 17:30:06.502988+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311914	2003-11-19 17:47:42+02	2003-11-19 17:30:07.513303+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311915	2003-11-19 17:47:42+02	2003-11-19 17:30:07.517334+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311913	2003-11-19 17:47:42+02	2003-11-19 17:30:07.503539+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311926	2003-11-19 17:47:43+02	2003-11-19 17:30:08.630792+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311925	2003-11-19 17:47:43+02	2003-11-19 17:30:08.523639+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311924	2003-11-19 17:47:43+02	2003-11-19 17:30:08.504213+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311927	2003-11-19 17:47:44+02	2003-11-19 17:30:09.503534+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311929	2003-11-19 17:47:44+02	2003-11-19 17:30:09.524102+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311928	2003-11-19 17:47:44+02	2003-11-19 17:30:09.520202+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311940	2003-11-19 17:47:45+02	2003-11-19 17:30:10.509798+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311939	2003-11-19 17:47:45+02	2003-11-19 17:30:10.504078+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1311995	2003-11-19 17:47:46+02	2003-11-19 17:30:19.900144+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1316566	2003-11-19 17:48:33+02	2003-11-19 17:48:33.838402+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1316565	2003-11-19 17:48:33+02	2003-11-19 17:48:33.832627+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1316567	2003-11-19 17:48:33+02	2003-11-19 17:48:33.947485+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1316573	2003-11-19 17:48:38+02	2003-11-19 17:48:38.615912+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1337398	2003-11-20 15:38:09+02	2003-11-20 15:20:41.941304+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337400	2003-11-20 15:38:10+02	2003-11-20 15:20:42.95108+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337399	2003-11-20 15:38:10+02	2003-11-20 15:20:42.941971+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337403	2003-11-20 15:38:11+02	2003-11-20 15:20:43.966214+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337402	2003-11-20 15:38:11+02	2003-11-20 15:20:43.96235+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337401	2003-11-20 15:38:11+02	2003-11-20 15:20:43.942613+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337412	2003-11-20 15:38:12+02	2003-11-20 15:20:44.961754+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337411	2003-11-20 15:38:12+02	2003-11-20 15:20:44.957939+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337410	2003-11-20 15:38:12+02	2003-11-20 15:20:44.942609+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337413	2003-11-20 15:38:13+02	2003-11-20 15:20:45.94346+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337415	2003-11-20 15:38:13+02	2003-11-20 15:20:45.956487+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337414	2003-11-20 15:38:13+02	2003-11-20 15:20:45.952646+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337416	2003-11-20 15:38:14+02	2003-11-20 15:20:46.943363+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337417	2003-11-20 15:38:14+02	2003-11-20 15:20:46.962621+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337420	2003-11-20 15:38:15+02	2003-11-20 15:20:53.683149+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1316668	2003-11-19 17:49:14+02	2003-11-19 17:49:14.380136+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1316703	2003-11-19 17:49:28+02	2003-11-19 17:49:28.153934+02	atlas	3730	xntpd[4726]:		offset -0.000190 sec freq 76.289 ppm error 0.000539 poll 10		500
1347861	2003-11-20 20:28:15+02	2003-11-20 20:10:49.138625+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347862	2003-11-20 20:28:16+02	2003-11-20 20:10:50.139389+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347863	2003-11-20 20:28:16+02	2003-11-20 20:10:50.15514+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347866	2003-11-20 20:28:17+02	2003-11-20 20:10:51.154109+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347865	2003-11-20 20:28:17+02	2003-11-20 20:10:51.150315+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347864	2003-11-20 20:28:17+02	2003-11-20 20:10:51.139945+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347869	2003-11-20 20:28:18+02	2003-11-20 20:10:52.16355+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347867	2003-11-20 20:28:18+02	2003-11-20 20:10:52.140013+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347868	2003-11-20 20:28:18+02	2003-11-20 20:10:52.159742+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347871	2003-11-20 20:28:19+02	2003-11-20 20:10:53.155505+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347872	2003-11-20 20:28:19+02	2003-11-20 20:10:53.26856+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347870	2003-11-20 20:28:19+02	2003-11-20 20:10:53.140891+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347873	2003-11-20 20:28:20+02	2003-11-20 20:10:54.140692+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347874	2003-11-20 20:28:20+02	2003-11-20 20:10:54.151478+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1347878	2003-11-20 20:28:21+02	2003-11-20 20:11:01.244282+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313244	2003-11-19 17:52:40+02	2003-11-19 17:35:05.575068+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313254	2003-11-19 17:52:41+02	2003-11-19 17:35:06.582414+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313253	2003-11-19 17:52:41+02	2003-11-19 17:35:06.576396+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313255	2003-11-19 17:52:42+02	2003-11-19 17:35:07.576245+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313257	2003-11-19 17:52:42+02	2003-11-19 17:35:07.595952+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313256	2003-11-19 17:52:42+02	2003-11-19 17:35:07.591493+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313266	2003-11-19 17:52:43+02	2003-11-19 17:35:08.576496+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313268	2003-11-19 17:52:43+02	2003-11-19 17:35:08.587821+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313267	2003-11-19 17:52:43+02	2003-11-19 17:35:08.582601+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313271	2003-11-19 17:52:44+02	2003-11-19 17:35:09.631118+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313272	2003-11-19 17:52:44+02	2003-11-19 17:35:09.735342+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313270	2003-11-19 17:52:44+02	2003-11-19 17:35:09.577101+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313281	2003-11-19 17:52:45+02	2003-11-19 17:35:10.577318+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313282	2003-11-19 17:52:45+02	2003-11-19 17:35:10.735352+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1313330	2003-11-19 17:52:46+02	2003-11-19 17:35:20.030493+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337571	2003-11-20 15:43:09+02	2003-11-20 15:25:42.021867+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337572	2003-11-20 15:43:10+02	2003-11-20 15:25:43.022978+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337573	2003-11-20 15:43:10+02	2003-11-20 15:25:43.034125+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337574	2003-11-20 15:43:11+02	2003-11-20 15:25:44.023849+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337575	2003-11-20 15:43:11+02	2003-11-20 15:25:44.04409+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337576	2003-11-20 15:43:11+02	2003-11-20 15:25:44.047877+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337578	2003-11-20 15:43:12+02	2003-11-20 15:25:45.049499+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337580	2003-11-20 15:43:12+02	2003-11-20 15:25:45.067615+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337579	2003-11-20 15:43:12+02	2003-11-20 15:25:45.063898+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337583	2003-11-20 15:43:13+02	2003-11-20 15:25:46.039822+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337582	2003-11-20 15:43:13+02	2003-11-20 15:25:46.035594+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337581	2003-11-20 15:43:13+02	2003-11-20 15:25:46.023953+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337584	2003-11-20 15:43:14+02	2003-11-20 15:25:47.023458+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337585	2003-11-20 15:43:14+02	2003-11-20 15:25:47.031312+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337589	2003-11-20 15:43:15+02	2003-11-20 15:25:53.813627+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1316992	2003-11-19 17:53:16+02	2003-11-19 17:53:16.777225+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1316994	2003-11-19 17:53:16+02	2003-11-19 17:53:16.820498+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces terse '		1
1316995	2003-11-19 17:53:16+02	2003-11-19 17:53:16.824334+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1316993	2003-11-19 17:53:16+02	2003-11-19 17:53:16.81434+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2406, status 0		1
1316996	2003-11-19 17:53:16+02	2003-11-19 17:53:16.850479+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2407, status 0		1
1316998	2003-11-19 17:53:19+02	2003-11-19 17:53:19.637863+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show firewall '		1
1316999	2003-11-19 17:53:19+02	2003-11-19 17:53:19.762758+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317000	2003-11-19 17:53:19+02	2003-11-19 17:53:19.928254+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2408, status 0		1
1317001	2003-11-19 17:53:20+02	2003-11-19 17:53:20.910958+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show firewall '		1
1317002	2003-11-19 17:53:20+02	2003-11-19 17:53:20.925449+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317004	2003-11-19 17:53:20+02	2003-11-19 17:53:21.117847+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2409, status 0		1
1317011	2003-11-19 17:53:21+02	2003-11-19 17:53:22.107797+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2410, status 0		1
1317010	2003-11-19 17:53:21+02	2003-11-19 17:53:21.937349+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317009	2003-11-19 17:53:21+02	2003-11-19 17:53:21.931787+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show firewall '		1
1317014	2003-11-19 17:53:22+02	2003-11-19 17:53:22.977973+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2411, status 0		1
1317012	2003-11-19 17:53:22+02	2003-11-19 17:53:22.756158+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show firewall '		1
1317013	2003-11-19 17:53:22+02	2003-11-19 17:53:22.774849+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317017	2003-11-19 17:53:23+02	2003-11-19 17:53:23.629034+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show firewall '		1
1317019	2003-11-19 17:53:23+02	2003-11-19 17:53:23.837977+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2412, status 0		1
1317018	2003-11-19 17:53:23+02	2003-11-19 17:53:23.65639+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317020	2003-11-19 17:53:24+02	2003-11-19 17:53:24.492377+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show firewall '		1
1317022	2003-11-19 17:53:24+02	2003-11-19 17:53:24.698025+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2413, status 0		1
1317021	2003-11-19 17:53:24+02	2003-11-19 17:53:24.510316+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317025	2003-11-19 17:53:25+02	2003-11-19 17:53:25.548143+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2414, status 0		1
1317023	2003-11-19 17:53:25+02	2003-11-19 17:53:25.343189+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show firewall '		1
1356811	2003-11-21 19:23:45+02	2003-11-21 19:06:26.17879+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356813	2003-11-21 19:23:46+02	2003-11-21 19:06:27.175262+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356814	2003-11-21 19:23:46+02	2003-11-21 19:06:27.195725+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356817	2003-11-21 19:23:47+02	2003-11-21 19:06:28.196713+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356816	2003-11-21 19:23:47+02	2003-11-21 19:06:28.192842+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356815	2003-11-21 19:23:47+02	2003-11-21 19:06:28.175036+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356819	2003-11-21 19:23:48+02	2003-11-21 19:06:29.17589+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356820	2003-11-21 19:23:48+02	2003-11-21 19:06:29.29104+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356821	2003-11-21 19:23:48+02	2003-11-21 19:06:29.296699+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356824	2003-11-21 19:23:49+02	2003-11-21 19:06:30.202349+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356823	2003-11-21 19:23:49+02	2003-11-21 19:06:30.198422+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356822	2003-11-21 19:23:49+02	2003-11-21 19:06:30.175818+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356826	2003-11-21 19:23:50+02	2003-11-21 19:06:31.193209+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356825	2003-11-21 19:23:50+02	2003-11-21 19:06:31.176531+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1356830	2003-11-21 19:23:51+02	2003-11-21 19:06:36.681377+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1317024	2003-11-19 17:53:25+02	2003-11-19 17:53:25.363965+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317026	2003-11-19 17:53:26+02	2003-11-19 17:53:26.243597+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show firewall '		1
1317031	2003-11-19 17:53:26+02	2003-11-19 17:53:27.11733+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317030	2003-11-19 17:53:26+02	2003-11-19 17:53:27.111254+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show firewall '		1
1317027	2003-11-19 17:53:26+02	2003-11-19 17:53:26.260111+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317028	2003-11-19 17:53:26+02	2003-11-19 17:53:26.448245+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2415, status 0		1
1317032	2003-11-19 17:53:27+02	2003-11-19 17:53:27.318621+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2416, status 0		1
1317033	2003-11-19 17:53:27+02	2003-11-19 17:53:27.88848+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show firewall '		1
1317034	2003-11-19 17:53:27+02	2003-11-19 17:53:27.897161+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317035	2003-11-19 17:53:27+02	2003-11-19 17:53:28.098483+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2417, status 0		1
1348587	2003-11-20 20:31:31+02	2003-11-20 20:31:32.14234+02	ganymede	3731	xntpd[2770]:		offset 0.000503 sec freq 84.906 ppm error 0.000088 poll 6		500
1317223	2003-11-19 17:56:38+02	2003-11-19 17:56:38.820244+02	atlas	3730	snmpd[4411]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1317250	2003-11-19 17:57:14+02	2003-11-19 17:57:14.585514+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1314637	2003-11-19 17:57:40+02	2003-11-19 17:40:05.653755+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314639	2003-11-19 17:57:41+02	2003-11-19 17:40:06.674015+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314638	2003-11-19 17:57:41+02	2003-11-19 17:40:06.654492+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314648	2003-11-19 17:57:42+02	2003-11-19 17:40:07.671747+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314647	2003-11-19 17:57:42+02	2003-11-19 17:40:07.654917+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314649	2003-11-19 17:57:42+02	2003-11-19 17:40:07.675685+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337734	2003-11-20 15:48:09+02	2003-11-20 15:30:42.112946+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337736	2003-11-20 15:48:10+02	2003-11-20 15:30:43.131403+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337735	2003-11-20 15:48:10+02	2003-11-20 15:30:43.114438+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337740	2003-11-20 15:48:11+02	2003-11-20 15:30:44.200816+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337739	2003-11-20 15:48:11+02	2003-11-20 15:30:44.115578+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337741	2003-11-20 15:48:11+02	2003-11-20 15:30:44.204588+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337744	2003-11-20 15:48:12+02	2003-11-20 15:30:45.126742+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337742	2003-11-20 15:48:12+02	2003-11-20 15:30:45.114657+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337743	2003-11-20 15:48:12+02	2003-11-20 15:30:45.122898+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337747	2003-11-20 15:48:13+02	2003-11-20 15:30:46.136739+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337746	2003-11-20 15:48:13+02	2003-11-20 15:30:46.132913+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337745	2003-11-20 15:48:13+02	2003-11-20 15:30:46.114763+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337749	2003-11-20 15:48:14+02	2003-11-20 15:30:47.128641+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337748	2003-11-20 15:48:14+02	2003-11-20 15:30:47.115445+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337753	2003-11-20 15:48:15+02	2003-11-20 15:30:53.945045+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338352	2003-11-20 15:48:36+02	2003-11-20 15:48:36.984611+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1338354	2003-11-20 15:48:36+02	2003-11-20 15:48:37.005373+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1338353	2003-11-20 15:48:36+02	2003-11-20 15:48:37.0016+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1314651	2003-11-19 17:57:43+02	2003-11-19 17:40:08.665729+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314650	2003-11-19 17:57:43+02	2003-11-19 17:40:08.655987+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314652	2003-11-19 17:57:43+02	2003-11-19 17:40:08.669658+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314661	2003-11-19 17:57:44+02	2003-11-19 17:40:09.656031+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314662	2003-11-19 17:57:44+02	2003-11-19 17:40:09.732134+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314663	2003-11-19 17:57:44+02	2003-11-19 17:40:09.736125+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314665	2003-11-19 17:57:45+02	2003-11-19 17:40:10.655822+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314666	2003-11-19 17:57:45+02	2003-11-19 17:40:10.671459+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1314733	2003-11-19 17:57:46+02	2003-11-19 17:40:20.160771+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1317266	2003-11-19 17:57:55+02	2003-11-19 17:57:55.146349+02	atlas	3730	mgd[4589]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show '		1
1399588	2003-11-25 13:40:04+02	2003-11-25 13:40:04.451306+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1399589	2003-11-25 13:40:04+02	2003-11-25 13:40:04.469196+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1399590	2003-11-25 13:40:04+02	2003-11-25 13:40:04.474784+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1399591	2003-11-25 13:40:04+02	2003-11-25 13:40:04.479767+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1399592	2003-11-25 13:40:04+02	2003-11-25 13:40:04.486754+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1399593	2003-11-25 13:40:04+02	2003-11-25 13:40:04.570295+02	ganymede	3731	mgd[3703]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1399594	2003-11-25 13:40:04+02	2003-11-25 13:40:04.575784+02	ganymede	3731	mgd[3703]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [3703]		1
1399595	2003-11-25 13:40:04+02	2003-11-25 13:40:04.680938+02	ganymede	3731	mgd[3703]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1399596	2003-11-25 13:40:04+02	2003-11-25 13:40:04.761287+02	ganymede	3731	mgd[3703]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1399597	2003-11-25 13:40:04+02	2003-11-25 13:40:04.863553+02	ganymede	3731	mgd[3703]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show isis database extensive '		1
1399598	2003-11-25 13:40:05+02	2003-11-25 13:40:05.052613+02	ganymede	3731	mgd[3703]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show ospf database extensive '		1
1399599	2003-11-25 13:40:05+02	2003-11-25 13:40:05.137044+02	ganymede	3731	mgd[3703]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1399600	2003-11-25 13:40:05+02	2003-11-25 13:40:05.144712+02	ganymede	3731	mgd[3703]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1399601	2003-11-25 13:40:05+02	2003-11-25 13:40:05.148673+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[3701]:	exit status 0x100		10
1399603	2003-11-25 13:40:12+02	2003-11-25 13:40:12.110732+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1399604	2003-11-25 13:40:12+02	2003-11-25 13:40:12.14155+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp0 as lab		1
1399605	2003-11-25 13:40:12+02	2003-11-25 13:40:12.25117+02	adrastea	3726	mgd[6004]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1399606	2003-11-25 13:40:12+02	2003-11-25 13:40:12.258246+02	adrastea	3726	mgd[6004]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [6004]		1
1399607	2003-11-25 13:40:12+02	2003-11-25 13:40:12.312332+02	adrastea	3726	mgd[6004]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1399608	2003-11-25 13:40:12+02	2003-11-25 13:40:12.346191+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp1		1
1399609	2003-11-25 13:40:12+02	2003-11-25 13:40:12.365755+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp1 as lab		1
1399610	2003-11-25 13:40:12+02	2003-11-25 13:40:12.389743+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1399611	2003-11-25 13:40:12+02	2003-11-25 13:40:12.402966+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1399612	2003-11-25 13:40:12+02	2003-11-25 13:40:12.410273+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1399613	2003-11-25 13:40:12+02	2003-11-25 13:40:12.416148+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1399614	2003-11-25 13:40:12+02	2003-11-25 13:40:12.42703+02	atlas	3730	login:		login from 172.26.27.115 on ttyp0 as lab		1
1399615	2003-11-25 13:40:12+02	2003-11-25 13:40:12.54595+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1399616	2003-11-25 13:40:12+02	2003-11-25 13:40:12.555043+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1399617	2003-11-25 13:40:12+02	2003-11-25 13:40:12.560509+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1399618	2003-11-25 13:40:12+02	2003-11-25 13:40:12.565605+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1399619	2003-11-25 13:40:12+02	2003-11-25 13:40:12.570386+02	r201	3732	login:		login from 172.26.27.115 on ttyp0 as lab		1
1399620	2003-11-25 13:40:12+02	2003-11-25 13:40:12.575537+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1399621	2003-11-25 13:40:12+02	2003-11-25 13:40:12.580955+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1399622	2003-11-25 13:40:12+02	2003-11-25 13:40:12.586096+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1399623	2003-11-25 13:40:12+02	2003-11-25 13:40:12.59446+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1399624	2003-11-25 13:40:12+02	2003-11-25 13:40:12.599547+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1399625	2003-11-25 13:40:12+02	2003-11-25 13:40:12.71169+02	adrastea	3726	mgd[6005]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1399626	2003-11-25 13:40:12+02	2003-11-25 13:40:12.717604+02	adrastea	3726	mgd[6005]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [6005]		1
1317304	2003-11-19 17:58:13+02	2003-11-19 17:58:14.004576+02	atlas	3730	mgd[4589]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'top '		1
1317312	2003-11-19 17:58:17+02	2003-11-19 17:58:18.07362+02	atlas	3730	mgd[4589]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show | compare rollback 1 '		1
1317331	2003-11-19 17:58:37+02	2003-11-19 17:58:37.948924+02	atlas	3730	mgd[4589]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set interfaces e1-0/0/0 e1-options timeslots 2 '		1
1317332	2003-11-19 17:58:37+02	2003-11-19 17:58:37.95838+02	atlas	3730	mgd[4589]:	UI_CFG_AUDIT_SET:	User 'lab' set: [interfaces e1-0/0/0 e1-options timeslots] <unconfigured> -> "2"		1
1317350	2003-11-19 17:58:50+02	2003-11-19 17:58:50.520986+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/usr/sbin/rpd'		1
1317352	2003-11-19 17:58:50+02	2003-11-19 17:58:50.585097+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/usr/sbin/mib2d'		1
1317360	2003-11-19 17:58:50+02	2003-11-19 17:58:50.978551+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/pfed', PID 4805, status 0		1
1317351	2003-11-19 17:58:50+02	2003-11-19 17:58:50.578844+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/rpd', PID 4801, status 0		1
1317347	2003-11-19 17:58:50+02	2003-11-19 17:58:50.506957+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: daemons checking new configuration		1
1317342	2003-11-19 17:58:50+02	2003-11-19 17:58:50.226172+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: setup foreign files		1
1317362	2003-11-19 17:58:50+02	2003-11-19 17:58:51.101473+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/kmd', PID 4806, status 0		1
1317359	2003-11-19 17:58:50+02	2003-11-19 17:58:50.896936+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/usr/sbin/pfed'		1
1317353	2003-11-19 17:58:50+02	2003-11-19 17:58:50.678948+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/mib2d', PID 4802, status 0		1
1317341	2003-11-19 17:58:50+02	2003-11-19 17:58:50.184044+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: exporting juniper.conf		1
1317340	2003-11-19 17:58:50+02	2003-11-19 17:58:50.179001+02	atlas	3730	mgd[4589]:	UI_COMMIT:	User 'lab' performed commit		100
1317354	2003-11-19 17:58:50+02	2003-11-19 17:58:50.684944+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/usr/sbin/apsd'		1
1317339	2003-11-19 17:58:50+02	2003-11-19 17:58:50.169474+02	atlas	3730	mgd[4589]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'commit '		1
1317356	2003-11-19 17:58:50+02	2003-11-19 17:58:50.77808+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/apsd', PID 4803, status 0		1
1317357	2003-11-19 17:58:50+02	2003-11-19 17:58:50.886934+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/usr/sbin/vrrpd'		1
1317358	2003-11-19 17:58:50+02	2003-11-19 17:58:50.89297+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/vrrpd', PID 4804, status 0		1
1317363	2003-11-19 17:58:50+02	2003-11-19 17:58:51.109305+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/usr/sbin/fud'		1
1317361	2003-11-19 17:58:50+02	2003-11-19 17:58:50.986451+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/usr/sbin/kmd'		1
1317344	2003-11-19 17:58:50+02	2003-11-19 17:58:50.298008+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: complete foreign files		1
1317343	2003-11-19 17:58:50+02	2003-11-19 17:58:50.267037+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: propagating foreign files		1
1317349	2003-11-19 17:58:50+02	2003-11-19 17:58:50.516983+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/sbin/dcd', PID 4800, status 0		1
1317346	2003-11-19 17:58:50+02	2003-11-19 17:58:50.33979+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: dropping unchanged foreign files		1
1317348	2003-11-19 17:58:50+02	2003-11-19 17:58:50.512956+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/sbin/dcd'		1
1317345	2003-11-19 17:58:50+02	2003-11-19 17:58:50.334771+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: copying configuration to juniper.data+		1
1317399	2003-11-19 17:58:51+02	2003-11-19 17:58:52.111154+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/proc/4407/file'		1
1317369	2003-11-19 17:58:51+02	2003-11-19 17:58:51.340467+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1317372	2003-11-19 17:58:51+02	2003-11-19 17:58:51.356783+02	atlas	3730	login:		login from 172.26.27.115 on ttyp2 as lab		1
1317402	2003-11-19 17:58:51+02	2003-11-19 17:58:52.123249+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/proc/4419/file', PID 4817, status 0		1
1317373	2003-11-19 17:58:51+02	2003-11-19 17:58:51.361796+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: activating '/var/db/juniper.data'		1
1317366	2003-11-19 17:58:51+02	2003-11-19 17:58:51.215564+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: activating '/var/etc/ntp.conf'		1
1317365	2003-11-19 17:58:51+02	2003-11-19 17:58:51.211799+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: commit wrapup...		1
1317364	2003-11-19 17:58:51+02	2003-11-19 17:58:51.205103+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/fud', PID 4809, status 0		1
1317368	2003-11-19 17:58:51+02	2003-11-19 17:58:51.335575+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1317394	2003-11-19 17:58:51+02	2003-11-19 17:58:51.96362+02	atlas	3730	mgd[4811]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1317377	2003-11-19 17:58:51+02	2003-11-19 17:58:51.486858+02	atlas	3730	mgd[4811]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1317398	2003-11-19 17:58:51+02	2003-11-19 17:58:52.106065+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/proc/4442/file', PID 4815, status 0		1
1317411	2003-11-19 17:58:51+02	2003-11-19 17:58:52.266303+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/proc/4429/file'		1
1317410	2003-11-19 17:58:51+02	2003-11-19 17:58:52.26207+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/proc/4433/file', PID 4821, status 0		1
1317409	2003-11-19 17:58:51+02	2003-11-19 17:58:52.258348+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/proc/4433/file'		1
1317397	2003-11-19 17:58:51+02	2003-11-19 17:58:52.100018+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/proc/4442/file'		1
1317396	2003-11-19 17:58:51+02	2003-11-19 17:58:51.982901+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/proc/4431/file', PID 4814, status 0		1
1317395	2003-11-19 17:58:51+02	2003-11-19 17:58:51.970055+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/proc/4431/file'		1
1317367	2003-11-19 17:58:51+02	2003-11-19 17:58:51.329795+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: activating '/var/etc/kmd.conf'		1
1317407	2003-11-19 17:58:51+02	2003-11-19 17:58:52.248782+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/proc/4426/file'		1
1317401	2003-11-19 17:58:51+02	2003-11-19 17:58:52.118734+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/proc/4419/file'		1
1317371	2003-11-19 17:58:51+02	2003-11-19 17:58:51.351172+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1317385	2003-11-19 17:58:51+02	2003-11-19 17:58:51.698216+02	atlas	3730	init:		ntp (PID 4726) exit on SIGHUP, will be restarted to get the new config		10
1317400	2003-11-19 17:58:51+02	2003-11-19 17:58:52.114991+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/proc/4407/file', PID 4816, status 0		1
1317386	2003-11-19 17:58:51+02	2003-11-19 17:58:51.701983+02	atlas	3730	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1317384	2003-11-19 17:58:51+02	2003-11-19 17:58:51.691968+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: signaling 'MIB2 daemon', pid 4412, signal 1, status 0		1
1317380	2003-11-19 17:58:51+02	2003-11-19 17:58:51.512404+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: signaling 'Interface daemon', pid 4442, signal 1, status 0		1
1317382	2003-11-19 17:58:51+02	2003-11-19 17:58:51.59525+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: signaling 'Routing protocol daemon', pid 4413, signal 1, status 0		1
1317379	2003-11-19 17:58:51+02	2003-11-19 17:58:51.496258+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: notifying daemons of new configuration		1
1317378	2003-11-19 17:58:51+02	2003-11-19 17:58:51.492489+02	atlas	3730	mgd[4811]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4811]		1
1317383	2003-11-19 17:58:51+02	2003-11-19 17:58:51.612313+02	atlas	3730	rpd[4413]:		task_reconfigure reinitializing done		10
1317406	2003-11-19 17:58:51+02	2003-11-19 17:58:52.142043+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/proc/4432/file', PID 4819, status 0		1
1317404	2003-11-19 17:58:51+02	2003-11-19 17:58:52.134335+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4818, status 0		1
1317393	2003-11-19 17:58:51+02	2003-11-19 17:58:51.957274+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: signaling 'PFE daemon', pid 4418, signal 1, status 0		1
1317387	2003-11-19 17:58:51+02	2003-11-19 17:58:51.806857+02	atlas	3730	init:		ntp (PID 4813) started		10
1317391	2003-11-19 17:58:51+02	2003-11-19 17:58:51.874636+02	atlas	3730	mgd[4811]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1317390	2003-11-19 17:58:51+02	2003-11-19 17:58:51.820371+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: signaling 'Sonet APS daemon', pid 4415, signal 1, status 0		1
1317370	2003-11-19 17:58:51+02	2003-11-19 17:58:51.345453+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1317388	2003-11-19 17:58:51+02	2003-11-19 17:58:51.812624+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: signaling 'NTP daemon', pid 4726, signal 1, status 0		1
1317389	2003-11-19 17:58:51+02	2003-11-19 17:58:51.816613+02	atlas	3730	mgd[4811]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1317408	2003-11-19 17:58:51+02	2003-11-19 17:58:52.254576+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/proc/4426/file', PID 4820, status 0		1
1317392	2003-11-19 17:58:51+02	2003-11-19 17:58:51.881343+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: signaling 'VRRP daemon', pid 4416, signal 1, status 0		1
1317405	2003-11-19 17:58:51+02	2003-11-19 17:58:52.138325+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/proc/4432/file'		1
1317403	2003-11-19 17:58:51+02	2003-11-19 17:58:52.129029+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1317381	2003-11-19 17:58:51+02	2003-11-19 17:58:51.516536+02	atlas	3730	rpd[4413]:	RPD_TASK_REINIT:	Reinitializing		10
1317421	2003-11-19 17:58:52+02	2003-11-19 17:58:52.673054+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317415	2003-11-19 17:58:52+02	2003-11-19 17:58:52.283427+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/proc/4436/file'		1
1317412	2003-11-19 17:58:52+02	2003-11-19 17:58:52.27016+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/proc/4429/file', PID 4822, status 0		1
1317414	2003-11-19 17:58:52+02	2003-11-19 17:58:52.277717+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4823, status 0		1
1317413	2003-11-19 17:58:52+02	2003-11-19 17:58:52.273953+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1317419	2003-11-19 17:58:52+02	2003-11-19 17:58:52.456415+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: signaling 'Forwarding UDP daemon', pid 4425, signal 1, status 0		1
1317418	2003-11-19 17:58:52+02	2003-11-19 17:58:52.452543+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: signaling 'IPSec Key Management daemon', pid 4424, signal 1, status 0		1
1317417	2003-11-19 17:58:52+02	2003-11-19 17:58:52.446903+02	atlas	3730	mgd[4811]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1317420	2003-11-19 17:58:52+02	2003-11-19 17:58:52.460168+02	atlas	3730	mgd[4811]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1317424	2003-11-19 17:58:52+02	2003-11-19 17:58:52.738129+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4827, status 0		1
1317422	2003-11-19 17:58:52+02	2003-11-19 17:58:52.73063+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4826, status 0		1
1317423	2003-11-19 17:58:52+02	2003-11-19 17:58:52.734396+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317416	2003-11-19 17:58:52+02	2003-11-19 17:58:52.28719+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/proc/4436/file', PID 4824, status 0		1
1317425	2003-11-19 17:58:52+02	2003-11-19 17:58:52.741862+02	atlas	3730	mgd[4811]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1317426	2003-11-19 17:58:52+02	2003-11-19 17:58:52.745577+02	atlas	3730	mgd[4811]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317442	2003-11-19 17:58:53+02	2003-11-19 17:58:53.547599+02	atlas	3730	inetd[4414]:	/usr/libexec/telnetd[4807]:	exit status 0x100		10
1317430	2003-11-19 17:58:53+02	2003-11-19 17:58:53.258365+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1317444	2003-11-19 17:58:53+02	2003-11-19 17:58:53.631541+02	atlas	3730	rpd[4413]:		EVENT <Bandwidth> e1-0/0/0.0 index 69 <Up Broadcast PointToPoint Multicast>		10
1317443	2003-11-19 17:58:53+02	2003-11-19 17:58:53.625718+02	atlas	3730	rpd[4413]:		EVENT <Bandwidth> index 135 <Up Broadcast Multicast>		10
1317427	2003-11-19 17:58:53+02	2003-11-19 17:58:53.235899+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1317428	2003-11-19 17:58:53+02	2003-11-19 17:58:53.250751+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bc26fc/32		10
1317441	2003-11-19 17:58:53+02	2003-11-19 17:58:53.533072+02	atlas	3730	mgd[4811]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1317431	2003-11-19 17:58:53+02	2003-11-19 17:58:53.262176+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1317432	2003-11-19 17:58:53+02	2003-11-19 17:58:53.268117+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bc26fc/32		10
1317440	2003-11-19 17:58:53+02	2003-11-19 17:58:53.528848+02	atlas	3730	mgd[4811]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1317429	2003-11-19 17:58:53+02	2003-11-19 17:58:53.254526+02	atlas	3730	last		message repeated 2 times		10
1317434	2003-11-19 17:58:53+02	2003-11-19 17:58:53.293909+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 52 traps in queue 		2
1317439	2003-11-19 17:58:53+02	2003-11-19 17:58:53.517152+02	atlas	3730	mgd[4811]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4828, status 0		1
1317433	2003-11-19 17:58:53+02	2003-11-19 17:58:53.272012+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 51 traps in queue 		2
1317435	2003-11-19 17:58:53+02	2003-11-19 17:58:53.299609+02	atlas	3730	mgd[4589]:	UI_COMMIT_PROGRESS:	commit: signaling 'SNMP daemon', pid 4411, signal 31, status 0		1
1317454	2003-11-19 17:58:56+02	2003-11-19 17:58:56.733334+02	atlas	3730	xntpd[4813]:		using kernel phase-lock loop 2041		1
1317453	2003-11-19 17:58:56+02	2003-11-19 17:58:56.729514+02	atlas	3730	xntpd[4813]:		frequency initialized 76.289 from /var/db/ntp.drift		1
1317452	2003-11-19 17:58:56+02	2003-11-19 17:58:56.72556+02	atlas	3730	xntpd[4813]:		using kernel phase-lock loop 2001		1
1317451	2003-11-19 17:58:56+02	2003-11-19 17:58:56.721749+02	atlas	3730	xntpd[4813]:		kern_enable is 1		1
1317450	2003-11-19 17:58:56+02	2003-11-19 17:58:56.707542+02	atlas	3730	xntpd[4813]:		ntpd 4.0.99b Thu Oct  9 20:39:08 GMT 2003 (1)		1
1317459	2003-11-19 17:58:57+02	2003-11-19 17:58:57.853142+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4829, status 0		1
1317458	2003-11-19 17:58:57+02	2003-11-19 17:58:57.831631+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317465	2003-11-19 17:59:00+02	2003-11-19 17:59:00.7463+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4830, status 0		1
1317464	2003-11-19 17:59:00+02	2003-11-19 17:59:00.733436+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317463	2003-11-19 17:59:00+02	2003-11-19 17:59:00.712239+02	atlas	3730	mgd[4589]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show interfaces e1-0/0/0 extensive '		1
1317495	2003-11-19 17:59:06+02	2003-11-19 17:59:06.978427+02	ganymede	3731	mgd[2395]:	UI_DBASE_LOGIN_EVENT:	User 'lab' entering configuration mode		1
1317494	2003-11-19 17:59:06+02	2003-11-19 17:59:06.962738+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'configure '		1
1317499	2003-11-19 17:59:08+02	2003-11-19 17:59:09.099666+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'edit interfaces e1-0/0/0 '		1
1317501	2003-11-19 17:59:09+02	2003-11-19 17:59:09.703374+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show '		1
1317506	2003-11-19 17:59:13+02	2003-11-19 17:59:14.20907+02	ganymede	3731	mgd[2395]:	UI_CFG_AUDIT_SET:	User 'lab' set: [interfaces e1-0/0/0 e1-options timeslots] <unconfigured> -> "2"		1
1317505	2003-11-19 17:59:13+02	2003-11-19 17:59:14.05678+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set e1-options timeslots 2 '		1
1317509	2003-11-19 17:59:14+02	2003-11-19 17:59:14.751863+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: exporting juniper.conf		1
1348040	2003-11-20 20:33:15+02	2003-11-20 20:15:49.212053+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348043	2003-11-20 20:33:16+02	2003-11-20 20:15:50.221713+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348042	2003-11-20 20:33:16+02	2003-11-20 20:15:50.215579+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348046	2003-11-20 20:33:17+02	2003-11-20 20:15:51.226578+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348045	2003-11-20 20:33:17+02	2003-11-20 20:15:51.222752+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348044	2003-11-20 20:33:17+02	2003-11-20 20:15:51.213057+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348049	2003-11-20 20:33:18+02	2003-11-20 20:15:52.235882+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348047	2003-11-20 20:33:18+02	2003-11-20 20:15:52.213026+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348048	2003-11-20 20:33:18+02	2003-11-20 20:15:52.232041+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348052	2003-11-20 20:33:19+02	2003-11-20 20:15:53.231584+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348051	2003-11-20 20:33:19+02	2003-11-20 20:15:53.227701+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348050	2003-11-20 20:33:19+02	2003-11-20 20:15:53.214741+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348055	2003-11-20 20:33:20+02	2003-11-20 20:15:54.214279+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348056	2003-11-20 20:33:20+02	2003-11-20 20:15:54.223216+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348058	2003-11-20 20:33:21+02	2003-11-20 20:16:01.375139+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1317518	2003-11-19 17:59:14+02	2003-11-19 17:59:15.06608+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/rpd'		1
1317508	2003-11-19 17:59:14+02	2003-11-19 17:59:14.746835+02	ganymede	3731	mgd[2395]:	UI_COMMIT:	User 'lab' performed commit		100
1317507	2003-11-19 17:59:14+02	2003-11-19 17:59:14.727868+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'commit '		1
1317513	2003-11-19 17:59:14+02	2003-11-19 17:59:14.906359+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: copying configuration to juniper.data+		1
1317512	2003-11-19 17:59:14+02	2003-11-19 17:59:14.887718+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: complete foreign files		1
1317510	2003-11-19 17:59:14+02	2003-11-19 17:59:14.842391+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: setup foreign files		1
1317517	2003-11-19 17:59:14+02	2003-11-19 17:59:15.059261+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/sbin/dcd', PID 2420, status 0		1
1317511	2003-11-19 17:59:14+02	2003-11-19 17:59:14.876393+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: propagating foreign files		1
1317516	2003-11-19 17:59:14+02	2003-11-19 17:59:15.027458+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/sbin/dcd'		1
1317514	2003-11-19 17:59:14+02	2003-11-19 17:59:14.911087+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: dropping unchanged foreign files		1
1317515	2003-11-19 17:59:14+02	2003-11-19 17:59:14.915214+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: daemons checking new configuration		1
1317525	2003-11-19 17:59:15+02	2003-11-19 17:59:15.470486+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/vrrpd', PID 2424, status 0		1
1317521	2003-11-19 17:59:15+02	2003-11-19 17:59:15.277871+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/mib2d', PID 2422, status 0		1
1317529	2003-11-19 17:59:15+02	2003-11-19 17:59:15.689353+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/kmd', PID 2426, status 0		1
1317523	2003-11-19 17:59:15+02	2003-11-19 17:59:15.374037+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/apsd', PID 2423, status 0		1
1317524	2003-11-19 17:59:15+02	2003-11-19 17:59:15.380282+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/vrrpd'		1
1317528	2003-11-19 17:59:15+02	2003-11-19 17:59:15.591535+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/kmd'		1
1317526	2003-11-19 17:59:15+02	2003-11-19 17:59:15.577124+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/pfed'		1
1317520	2003-11-19 17:59:15+02	2003-11-19 17:59:15.186562+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/mib2d'		1
1317527	2003-11-19 17:59:15+02	2003-11-19 17:59:15.584464+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/pfed', PID 2425, status 0		1
1317519	2003-11-19 17:59:15+02	2003-11-19 17:59:15.17986+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/rpd', PID 2421, status 0		1
1317535	2003-11-19 17:59:15+02	2003-11-19 17:59:15.936119+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1317534	2003-11-19 17:59:15+02	2003-11-19 17:59:15.833068+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: activating '/var/etc/kmd.conf'		1
1317522	2003-11-19 17:59:15+02	2003-11-19 17:59:15.284017+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/apsd'		1
1317530	2003-11-19 17:59:15+02	2003-11-19 17:59:15.695682+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/fud'		1
1317531	2003-11-19 17:59:15+02	2003-11-19 17:59:15.820617+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/fud', PID 2428, status 0		1
1317533	2003-11-19 17:59:15+02	2003-11-19 17:59:15.829307+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: activating '/var/etc/ntp.conf'		1
1317532	2003-11-19 17:59:15+02	2003-11-19 17:59:15.824994+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: commit wrapup...		1
1317538	2003-11-19 17:59:15+02	2003-11-19 17:59:16.057827+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1317537	2003-11-19 17:59:15+02	2003-11-19 17:59:16.052878+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1317536	2003-11-19 17:59:15+02	2003-11-19 17:59:16.047232+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: activating '/var/db/juniper.data'		1
1317539	2003-11-19 17:59:15+02	2003-11-19 17:59:16.062845+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1317540	2003-11-19 17:59:15+02	2003-11-19 17:59:16.067945+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp1 as lab		1
1317541	2003-11-19 17:59:15+02	2003-11-19 17:59:16.073024+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: notifying daemons of new configuration		1
1317542	2003-11-19 17:59:15+02	2003-11-19 17:59:16.091652+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: signaling 'Interface daemon', pid 2258, signal 1, status 0		1
1317553	2003-11-19 17:59:16+02	2003-11-19 17:59:16.598175+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: signaling 'PFE daemon', pid 2230, signal 1, status 0		1
1317552	2003-11-19 17:59:16+02	2003-11-19 17:59:16.592454+02	ganymede	3731	init:		ntp (PID 2433) started		10
1317543	2003-11-19 17:59:16+02	2003-11-19 17:59:16.192236+02	ganymede	3731	rpd[2252]:	RPD_TASK_REINIT:	Reinitializing		10
1317551	2003-11-19 17:59:16+02	2003-11-19 17:59:16.542723+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: signaling 'VRRP daemon', pid 2254, signal 1, status 0		1
1317547	2003-11-19 17:59:16+02	2003-11-19 17:59:16.422746+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: signaling 'NTP daemon', pid 2225, signal 1, status 0		1
1317546	2003-11-19 17:59:16+02	2003-11-19 17:59:16.417172+02	ganymede	3731	init:		ntp (PID 2225) exit on SIGHUP, will be restarted to get the new config		10
1317545	2003-11-19 17:59:16+02	2003-11-19 17:59:16.301929+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: signaling 'MIB2 daemon', pid 2251, signal 1, status 0		1
1317544	2003-11-19 17:59:16+02	2003-11-19 17:59:16.202839+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: signaling 'Routing protocol daemon', pid 2252, signal 1, status 0		1
1317550	2003-11-19 17:59:16+02	2003-11-19 17:59:16.508882+02	ganymede	3731	rpd[2252]:		task_reconfigure reinitializing done		10
1317549	2003-11-19 17:59:16+02	2003-11-19 17:59:16.504736+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1317548	2003-11-19 17:59:16+02	2003-11-19 17:59:16.473162+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: signaling 'Sonet APS daemon', pid 2253, signal 1, status 0		1
1317554	2003-11-19 17:59:16+02	2003-11-19 17:59:16.783313+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: signaling 'IPSec Key Management daemon', pid 2236, signal 1, status 0		1
1317559	2003-11-19 17:59:16+02	2003-11-19 17:59:17.120935+02	ganymede	3731	mgd[2432]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1317555	2003-11-19 17:59:16+02	2003-11-19 17:59:16.789358+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: signaling 'Forwarding UDP daemon', pid 2237, signal 1, status 0		1
1317557	2003-11-19 17:59:16+02	2003-11-19 17:59:16.998305+02	ganymede	3731	mgd[2432]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2432]		1
1317556	2003-11-19 17:59:16+02	2003-11-19 17:59:16.937938+02	ganymede	3731	mgd[2432]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1317558	2003-11-19 17:59:16+02	2003-11-19 17:59:17.00211+02	ganymede	3731	mgd[2432]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1317576	2003-11-19 17:59:17+02	2003-11-19 17:59:18.167242+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/proc/2243/file'		1
1317566	2003-11-19 17:59:17+02	2003-11-19 17:59:17.638061+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/proc/2224/file'		1
1317570	2003-11-19 17:59:17+02	2003-11-19 17:59:17.89465+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1317569	2003-11-19 17:59:17+02	2003-11-19 17:59:17.712802+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/proc/2231/file', PID 2438, status 0		1
1317575	2003-11-19 17:59:17+02	2003-11-19 17:59:18.062274+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/proc/2238/file', PID 2441, status 0		1
1317572	2003-11-19 17:59:17+02	2003-11-19 17:59:17.96113+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/proc/2242/file'		1
1317571	2003-11-19 17:59:17+02	2003-11-19 17:59:17.955068+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 2439, status 0		1
1317573	2003-11-19 17:59:17+02	2003-11-19 17:59:18.002609+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/proc/2242/file', PID 2440, status 0		1
1317574	2003-11-19 17:59:17+02	2003-11-19 17:59:18.043849+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/proc/2238/file'		1
1317578	2003-11-19 17:59:17+02	2003-11-19 17:59:18.178649+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/proc/2240/file'		1
1317577	2003-11-19 17:59:17+02	2003-11-19 17:59:18.172866+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/proc/2243/file', PID 2442, status 0		1
1317568	2003-11-19 17:59:17+02	2003-11-19 17:59:17.70373+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/proc/2231/file'		1
1317565	2003-11-19 17:59:17+02	2003-11-19 17:59:17.474806+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/proc/2258/file', PID 2436, status 0		1
1317560	2003-11-19 17:59:17+02	2003-11-19 17:59:17.154282+02	ganymede	3731	mgd[2432]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1317564	2003-11-19 17:59:17+02	2003-11-19 17:59:17.406555+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/proc/2258/file'		1
1317561	2003-11-19 17:59:17+02	2003-11-19 17:59:17.30414+02	ganymede	3731	mgd[2395]:	UI_COMMIT_PROGRESS:	commit: signaling 'SNMP daemon', pid 2227, signal 31, status 0		1
1317567	2003-11-19 17:59:17+02	2003-11-19 17:59:17.698234+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/proc/2224/file', PID 2437, status 0		1
1317563	2003-11-19 17:59:17+02	2003-11-19 17:59:17.402593+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 2435, status 0		1
1317562	2003-11-19 17:59:17+02	2003-11-19 17:59:17.398809+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1317594	2003-11-19 17:59:18+02	2003-11-19 17:59:19.269691+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317580	2003-11-19 17:59:18+02	2003-11-19 17:59:18.19227+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1317579	2003-11-19 17:59:18+02	2003-11-19 17:59:18.182692+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/proc/2240/file', PID 2443, status 0		1
1317581	2003-11-19 17:59:18+02	2003-11-19 17:59:18.266603+02	ganymede	3731	rpd[2252]:		EVENT <Bandwidth> index 128 <Up Broadcast Multicast>		10
1317593	2003-11-19 17:59:18+02	2003-11-19 17:59:19.247818+02	ganymede	3731	/kernel:	e1-0/0/0:	received CCC status, setting CCC-Down		10
1317586	2003-11-19 17:59:18+02	2003-11-19 17:59:18.45721+02	ganymede	3731	rpd[2252]:	RPD_LAYER2_VC_DOWN:	 Layer-2 VC (VPN : x25_cqt, local-site : 2, remote-site : 1) state changed from UP to Dn		10
1317582	2003-11-19 17:59:18+02	2003-11-19 17:59:18.27288+02	ganymede	3731	rpd[2252]:		EVENT <Bandwidth> e1-0/0/0.0 index 69 <Up Broadcast PointToPoint Multicast>		10
1317583	2003-11-19 17:59:18+02	2003-11-19 17:59:18.337459+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1317584	2003-11-19 17:59:18+02	2003-11-19 17:59:18.343701+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_DOWN:	ifIndex 73, ifAdminStatus up(1), ifOperStatus down(2), ifName e1-0/0/0		10
1317585	2003-11-19 17:59:18+02	2003-11-19 17:59:18.34754+02	ganymede	3731	rpd[2252]:		EVENT UpDown e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1317592	2003-11-19 17:59:18+02	2003-11-19 17:59:18.741482+02	ganymede	3731	mgd[2432]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1317591	2003-11-19 17:59:18+02	2003-11-19 17:59:18.558552+02	ganymede	3731	mgd[2432]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1317588	2003-11-19 17:59:18+02	2003-11-19 17:59:18.46675+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 2444, status 0		1
1317587	2003-11-19 17:59:18+02	2003-11-19 17:59:18.462898+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 128 <Broadcast Multicast>		10
1317589	2003-11-19 17:59:18+02	2003-11-19 17:59:18.472672+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/proc/2246/file'		1
1317599	2003-11-19 17:59:18+02	2003-11-19 17:59:19.413568+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317597	2003-11-19 17:59:18+02	2003-11-19 17:59:19.398401+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2447, status 0		1
1317596	2003-11-19 17:59:18+02	2003-11-19 17:59:19.38774+02	ganymede	3731	mgd[2432]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317595	2003-11-19 17:59:18+02	2003-11-19 17:59:19.273605+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2446, status 0		1
1317598	2003-11-19 17:59:18+02	2003-11-19 17:59:19.408392+02	ganymede	3731	mgd[2432]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1317590	2003-11-19 17:59:18+02	2003-11-19 17:59:18.476499+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/proc/2246/file', PID 2445, status 0		1
1317612	2003-11-19 17:59:19+02	2003-11-19 17:59:19.979625+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 128 <Up Broadcast Multicast>		10
1317602	2003-11-19 17:59:19+02	2003-11-19 17:59:19.709362+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1317611	2003-11-19 17:59:19+02	2003-11-19 17:59:19.973417+02	ganymede	3731	rpd[2252]:		EVENT UpDown e1-0/0/0.0 index 69 <Up Broadcast PointToPoint Multicast>		10
1317610	2003-11-19 17:59:19+02	2003-11-19 17:59:19.963071+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_UP:	ifIndex 73, ifAdminStatus up(1), ifOperStatus up(1), ifName e1-0/0/0		10
1317605	2003-11-19 17:59:19+02	2003-11-19 17:59:19.799979+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1352705	2003-11-21 17:48:43+02	2003-11-21 17:31:23.925519+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352706	2003-11-21 17:48:44+02	2003-11-21 17:31:24.826602+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352707	2003-11-21 17:48:44+02	2003-11-21 17:31:24.944887+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352711	2003-11-21 17:48:45+02	2003-11-21 17:31:25.881443+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352710	2003-11-21 17:48:45+02	2003-11-21 17:31:25.83202+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352709	2003-11-21 17:48:45+02	2003-11-21 17:31:25.826365+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352713	2003-11-21 17:48:46+02	2003-11-21 17:31:26.848532+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1353723	2003-11-21 17:48:46+02	2003-11-21 17:48:46.467969+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1352712	2003-11-21 17:48:46+02	2003-11-21 17:31:26.826972+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352714	2003-11-21 17:48:46+02	2003-11-21 17:31:26.852294+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1353722	2003-11-21 17:48:46+02	2003-11-21 17:48:46.455578+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1353724	2003-11-21 17:48:46+02	2003-11-21 17:48:46.47191+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1352718	2003-11-21 17:48:47+02	2003-11-21 17:31:27.950142+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352716	2003-11-21 17:48:47+02	2003-11-21 17:31:27.827268+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352717	2003-11-21 17:48:47+02	2003-11-21 17:31:27.944873+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352719	2003-11-21 17:48:48+02	2003-11-21 17:31:28.827578+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352720	2003-11-21 17:48:48+02	2003-11-21 17:31:28.840051+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352723	2003-11-21 17:48:49+02	2003-11-21 17:31:34.208027+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1317603	2003-11-19 17:59:19+02	2003-11-19 17:59:19.791594+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bae2fc/32		10
1317609	2003-11-19 17:59:19+02	2003-11-19 17:59:19.959045+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> e1-0/0/0.0 index 69 <Up Broadcast PointToPoint Multicast>		10
1317606	2003-11-19 17:59:19+02	2003-11-19 17:59:19.907252+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bae2fc/32		10
1317604	2003-11-19 17:59:19+02	2003-11-19 17:59:19.79548+02	ganymede	3731	last		message repeated 5 times		10
1317608	2003-11-19 17:59:19+02	2003-11-19 17:59:19.953133+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bae2fc/32		10
1317607	2003-11-19 17:59:19+02	2003-11-19 17:59:19.912836+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1317626	2003-11-19 17:59:20+02	2003-11-19 17:59:20.878745+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[2427]:	exit status 0x100		10
1317613	2003-11-19 17:59:20+02	2003-11-19 17:59:20.472492+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1317624	2003-11-19 17:59:20+02	2003-11-19 17:59:20.764681+02	ganymede	3731	mgd[2432]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1317618	2003-11-19 17:59:20+02	2003-11-19 17:59:20.629392+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1317617	2003-11-19 17:59:20+02	2003-11-19 17:59:20.622324+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1317628	2003-11-19 17:59:20+02	2003-11-19 17:59:20.892304+02	ganymede	3731	rpd[2252]:	RPD_LAYER2_VC_UP:	 Layer-2 VC (VPN : x25_cqt, local-site : 2, remote-site : 1) state changed to UP		10
1317616	2003-11-19 17:59:20+02	2003-11-19 17:59:20.607359+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1317615	2003-11-19 17:59:20+02	2003-11-19 17:59:20.496682+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/0) ifd vptree not initialized		10
1317614	2003-11-19 17:59:20+02	2003-11-19 17:59:20.49284+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1317627	2003-11-19 17:59:20+02	2003-11-19 17:59:20.887932+02	atlas	3730	rpd[4413]:	RPD_LAYER2_VC_DOWN:	 Layer-2 VC (VPN : x25_cqt, local-site : 1, remote-site : 2) state changed from UP to VC-Dn		10
1317619	2003-11-19 17:59:20+02	2003-11-19 17:59:20.634938+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1317620	2003-11-19 17:59:20+02	2003-11-19 17:59:20.68306+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/1) ifd vptree not initialized		10
1317621	2003-11-19 17:59:20+02	2003-11-19 17:59:20.688296+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1317623	2003-11-19 17:59:20+02	2003-11-19 17:59:20.74861+02	ganymede	3731	mgd[2432]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2448, status 0		1
1317625	2003-11-19 17:59:20+02	2003-11-19 17:59:20.770477+02	ganymede	3731	mgd[2432]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1317622	2003-11-19 17:59:20+02	2003-11-19 17:59:20.743091+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1317635	2003-11-19 17:59:21+02	2003-11-19 17:59:21.684073+02	ganymede	3731	xntpd[2433]:		using kernel phase-lock loop 2041		1
1317634	2003-11-19 17:59:21+02	2003-11-19 17:59:21.680358+02	ganymede	3731	xntpd[2433]:		frequency initialized 84.242 from /var/db/ntp.drift		1
1317632	2003-11-19 17:59:21+02	2003-11-19 17:59:21.672815+02	ganymede	3731	xntpd[2433]:		kern_enable is 1		1
1317633	2003-11-19 17:59:21+02	2003-11-19 17:59:21.676626+02	ganymede	3731	xntpd[2433]:		using kernel phase-lock loop 2001		1
1317631	2003-11-19 17:59:21+02	2003-11-19 17:59:21.619873+02	ganymede	3731	xntpd[2433]:		ntpd 4.0.99b Thu Oct  9 20:39:08 GMT 2003 (1)		1
1317630	2003-11-19 17:59:21+02	2003-11-19 17:59:21.613559+02	ganymede	3731	/kernel:	e1-0/0/0:	received CCC status, removing CCC-Down status		10
1317636	2003-11-19 17:59:22+02	2003-11-19 17:59:22.650439+02	atlas	3730	/kernel:	e1-0/0/0:	received CCC status, setting CCC-Down		10
1317637	2003-11-19 17:59:22+02	2003-11-19 17:59:22.670409+02	atlas	3730	rpd[4413]:	RPD_LAYER2_VC_UP:	 Layer-2 VC (VPN : x25_cqt, local-site : 1, remote-site : 2) state changed to UP		10
1317642	2003-11-19 17:59:35+02	2003-11-19 17:59:35.520616+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show '		1
1317643	2003-11-19 17:59:37+02	2003-11-19 17:59:37.791384+02	atlas	3730	/kernel:	e1-0/0/0:	received CCC status, removing CCC-Down status		10
1317647	2003-11-19 17:59:39+02	2003-11-19 17:59:39.676789+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show l2vpn connections '		1
1337915	2003-11-20 15:53:09+02	2003-11-20 15:35:42.192509+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337916	2003-11-20 15:53:10+02	2003-11-20 15:35:43.193251+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337917	2003-11-20 15:53:10+02	2003-11-20 15:35:43.214595+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337919	2003-11-20 15:53:11+02	2003-11-20 15:35:44.211337+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337920	2003-11-20 15:53:11+02	2003-11-20 15:35:44.215163+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337918	2003-11-20 15:53:11+02	2003-11-20 15:35:44.193798+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337923	2003-11-20 15:53:12+02	2003-11-20 15:35:45.314193+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337921	2003-11-20 15:53:12+02	2003-11-20 15:35:45.193395+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337922	2003-11-20 15:53:12+02	2003-11-20 15:35:45.308632+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337925	2003-11-20 15:53:13+02	2003-11-20 15:35:46.1941+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337927	2003-11-20 15:53:13+02	2003-11-20 15:35:46.205967+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337926	2003-11-20 15:53:13+02	2003-11-20 15:35:46.202147+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337928	2003-11-20 15:53:14+02	2003-11-20 15:35:47.194087+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337929	2003-11-20 15:53:14+02	2003-11-20 15:35:47.212037+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1337931	2003-11-20 15:53:15+02	2003-11-20 15:35:54.074375+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1317654	2003-11-19 17:59:42+02	2003-11-19 17:59:42.158532+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317655	2003-11-19 17:59:42+02	2003-11-19 17:59:42.355804+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2449, status 0		1
1317653	2003-11-19 17:59:42+02	2003-11-19 17:59:42.14269+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317657	2003-11-19 17:59:43+02	2003-11-19 17:59:43.139914+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317659	2003-11-19 17:59:43+02	2003-11-19 17:59:43.365942+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2450, status 0		1
1317658	2003-11-19 17:59:43+02	2003-11-19 17:59:43.144663+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317663	2003-11-19 17:59:44+02	2003-11-19 17:59:44.315702+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317664	2003-11-19 17:59:44+02	2003-11-19 17:59:44.335109+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317665	2003-11-19 17:59:44+02	2003-11-19 17:59:44.527115+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2451, status 0		1
1317668	2003-11-19 17:59:45+02	2003-11-19 17:59:45.45623+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2452, status 0		1
1317667	2003-11-19 17:59:45+02	2003-11-19 17:59:45.231334+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317666	2003-11-19 17:59:45+02	2003-11-19 17:59:45.216863+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317672	2003-11-19 17:59:45+02	2003-11-19 17:59:46.10179+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317673	2003-11-19 17:59:45+02	2003-11-19 17:59:46.114407+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317676	2003-11-19 17:59:46+02	2003-11-19 17:59:47.07809+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317833	2003-11-19 18:01:17+02	2003-11-19 18:01:17.864804+02	r201	3732	login:		login from 172.26.27.115 on ttyp1 as lab		1
1317675	2003-11-19 17:59:46+02	2003-11-19 17:59:46.954026+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317674	2003-11-19 17:59:46+02	2003-11-19 17:59:46.316193+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2453, status 0		1
1317677	2003-11-19 17:59:47+02	2003-11-19 17:59:47.166306+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2454, status 0		1
1317681	2003-11-19 17:59:47+02	2003-11-19 17:59:47.717523+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317682	2003-11-19 17:59:47+02	2003-11-19 17:59:47.723212+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317683	2003-11-19 17:59:47+02	2003-11-19 17:59:47.926235+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2455, status 0		1
1317686	2003-11-19 17:59:48+02	2003-11-19 17:59:48.596483+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2456, status 0		1
1317685	2003-11-19 17:59:48+02	2003-11-19 17:59:48.403637+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317684	2003-11-19 17:59:48+02	2003-11-19 17:59:48.389837+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317688	2003-11-19 17:59:48+02	2003-11-19 17:59:49.052147+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317689	2003-11-19 17:59:48+02	2003-11-19 17:59:49.057993+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317690	2003-11-19 17:59:49+02	2003-11-19 17:59:49.266402+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2457, status 0		1
1317728	2003-11-19 18:00:00+02	2003-11-19 18:00:00.94262+02	atlas	3730	CRON[4832]:		(root) CMD (newsyslog) 		10
1317723	2003-11-19 18:00:00+02	2003-11-19 18:00:00.740999+02	adrastea	3726	CRON[4775]:		(root) CMD (newsyslog) 		10
1315199	2003-11-19 18:00:00+02	2003-11-19 17:42:26.234413+02	jupiter	3727	CRON[6842]:		(root) CMD (newsyslog) 		10
1317726	2003-11-19 18:00:00+02	2003-11-19 18:00:00.934572+02	r201	3732	CRON[4587]:		(root) CMD (newsyslog) 		10
1317715	2003-11-19 18:00:00+02	2003-11-19 18:00:00.384702+02	ganymede	3731	CRON[2459]:		(root) CMD (newsyslog) 		10
1358172	2003-11-21 19:45:17+02	2003-11-21 19:45:17.997162+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1317763	2003-11-19 18:00:43+02	2003-11-19 18:00:48.818588+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2461, status 0		1
1317762	2003-11-19 18:00:43+02	2003-11-19 18:00:48.708437+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317761	2003-11-19 18:00:43+02	2003-11-19 18:00:48.704301+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317766	2003-11-19 18:00:44+02	2003-11-19 18:00:48.831796+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317765	2003-11-19 18:00:44+02	2003-11-19 18:00:48.828047+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317767	2003-11-19 18:00:44+02	2003-11-19 18:00:48.835532+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2462, status 0		1
1317771	2003-11-19 18:00:45+02	2003-11-19 18:00:48.908301+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317770	2003-11-19 18:00:45+02	2003-11-19 18:00:48.904455+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2463, status 0		1
1317768	2003-11-19 18:00:45+02	2003-11-19 18:00:48.839289+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317772	2003-11-19 18:00:45+02	2003-11-19 18:00:48.911993+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317769	2003-11-19 18:00:45+02	2003-11-19 18:00:48.843182+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317775	2003-11-19 18:00:46+02	2003-11-19 18:00:49.030254+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317774	2003-11-19 18:00:46+02	2003-11-19 18:00:49.0264+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317773	2003-11-19 18:00:46+02	2003-11-19 18:00:49.020808+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2464, status 0		1
1317777	2003-11-19 18:00:46+02	2003-11-19 18:00:49.039453+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2465, status 0		1
1317780	2003-11-19 18:00:47+02	2003-11-19 18:00:49.051069+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2466, status 0		1
1317778	2003-11-19 18:00:47+02	2003-11-19 18:00:49.043479+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317781	2003-11-19 18:00:47+02	2003-11-19 18:00:49.055217+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1317782	2003-11-19 18:00:47+02	2003-11-19 18:00:49.05908+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317779	2003-11-19 18:00:47+02	2003-11-19 18:00:49.047197+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1317783	2003-11-19 18:00:48+02	2003-11-19 18:00:49.168568+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2467, status 0		1
1317799	2003-11-19 18:01:09+02	2003-11-19 18:01:09.797668+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1317804	2003-11-19 18:01:09+02	2003-11-19 18:01:09.93354+02	ganymede	3731	mgd[2470]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1317807	2003-11-19 18:01:09+02	2003-11-19 18:01:10.110093+02	ganymede	3731	mgd[2470]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1317800	2003-11-19 18:01:09+02	2003-11-19 18:01:09.806534+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1317801	2003-11-19 18:01:09+02	2003-11-19 18:01:09.811529+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1317803	2003-11-19 18:01:09+02	2003-11-19 18:01:09.927563+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp1 as lab		1
1317806	2003-11-19 18:01:09+02	2003-11-19 18:01:10.01007+02	ganymede	3731	mgd[2470]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1317802	2003-11-19 18:01:09+02	2003-11-19 18:01:09.920876+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1317805	2003-11-19 18:01:09+02	2003-11-19 18:01:09.987455+02	ganymede	3731	mgd[2470]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2470]		1
1317813	2003-11-19 18:01:10+02	2003-11-19 18:01:10.535289+02	ganymede	3731	mgd[2470]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1317815	2003-11-19 18:01:10+02	2003-11-19 18:01:10.545979+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[2468]:	exit status 0x100		10
1317814	2003-11-19 18:01:10+02	2003-11-19 18:01:10.541956+02	ganymede	3731	mgd[2470]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1317811	2003-11-19 18:01:10+02	2003-11-19 18:01:10.212017+02	ganymede	3731	mgd[2470]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show isis database extensive '		1
1317812	2003-11-19 18:01:10+02	2003-11-19 18:01:10.447301+02	ganymede	3731	mgd[2470]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show ospf database extensive '		1
1317846	2003-11-19 18:01:17+02	2003-11-19 18:01:18.102578+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp1		1
1317862	2003-11-19 18:01:17+02	2003-11-19 18:01:18.401151+02	adrastea	3726	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1317839	2003-11-19 18:01:17+02	2003-11-19 18:01:17.952321+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1317857	2003-11-19 18:01:17+02	2003-11-19 18:01:18.272617+02	adrastea	3726	mgd[4781]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1317865	2003-11-19 18:01:17+02	2003-11-19 18:01:18.415618+02	adrastea	3726	mgd[4781]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1317856	2003-11-19 18:01:17+02	2003-11-19 18:01:18.267867+02	adrastea	3726	mgd[4782]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4782]		1
1317855	2003-11-19 18:01:17+02	2003-11-19 18:01:18.263652+02	adrastea	3726	mgd[4782]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1317847	2003-11-19 18:01:17+02	2003-11-19 18:01:18.111092+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp1 as lab		1
1317864	2003-11-19 18:01:17+02	2003-11-19 18:01:18.411815+02	atlas	3730	mgd[4836]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1317854	2003-11-19 18:01:17+02	2003-11-19 18:01:18.251775+02	r201	3732	mgd[4591]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1317853	2003-11-19 18:01:17+02	2003-11-19 18:01:18.24776+02	atlas	3730	mgd[4836]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4836]		1
1317848	2003-11-19 18:01:17+02	2003-11-19 18:01:18.116315+02	r201	3732	mgd[4591]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1317827	2003-11-19 18:01:17+02	2003-11-19 18:01:17.674237+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1317831	2003-11-19 18:01:17+02	2003-11-19 18:01:17.752001+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1317838	2003-11-19 18:01:17+02	2003-11-19 18:01:17.946366+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp1 as lab		1
1317849	2003-11-19 18:01:17+02	2003-11-19 18:01:18.121276+02	ganymede	3731	mgd[2473]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1317860	2003-11-19 18:01:17+02	2003-11-19 18:01:18.285616+02	adrastea	3726	mgd[4781]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1317858	2003-11-19 18:01:17+02	2003-11-19 18:01:18.2765+02	ganymede	3731	mgd[2473]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1317832	2003-11-19 18:01:17+02	2003-11-19 18:01:17.859798+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1317828	2003-11-19 18:01:17+02	2003-11-19 18:01:17.685082+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp0 as lab		1
1317829	2003-11-19 18:01:17+02	2003-11-19 18:01:17.734411+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1317830	2003-11-19 18:01:17+02	2003-11-19 18:01:17.740595+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1317836	2003-11-19 18:01:17+02	2003-11-19 18:01:17.88373+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1317859	2003-11-19 18:01:17+02	2003-11-19 18:01:18.280331+02	atlas	3730	mgd[4836]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1317845	2003-11-19 18:01:17+02	2003-11-19 18:01:18.096609+02	adrastea	3726	mgd[4781]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4781]		1
1317841	2003-11-19 18:01:17+02	2003-11-19 18:01:17.966548+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1317863	2003-11-19 18:01:17+02	2003-11-19 18:01:18.407497+02	ganymede	3731	mgd[2473]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1317834	2003-11-19 18:01:17+02	2003-11-19 18:01:17.872078+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1317852	2003-11-19 18:01:17+02	2003-11-19 18:01:18.241564+02	atlas	3730	mgd[4836]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1317840	2003-11-19 18:01:17+02	2003-11-19 18:01:17.95794+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1348209	2003-11-20 20:38:15+02	2003-11-20 20:20:49.285291+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348221	2003-11-20 20:38:16+02	2003-11-20 20:20:50.287016+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348222	2003-11-20 20:38:16+02	2003-11-20 20:20:50.292556+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348223	2003-11-20 20:38:17+02	2003-11-20 20:20:51.288428+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348225	2003-11-20 20:38:17+02	2003-11-20 20:20:51.312922+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348224	2003-11-20 20:38:17+02	2003-11-20 20:20:51.308889+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348228	2003-11-20 20:38:18+02	2003-11-20 20:20:52.307394+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348226	2003-11-20 20:38:18+02	2003-11-20 20:20:52.287435+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348227	2003-11-20 20:38:18+02	2003-11-20 20:20:52.303593+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348231	2003-11-20 20:38:19+02	2003-11-20 20:20:53.30441+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348230	2003-11-20 20:38:19+02	2003-11-20 20:20:53.300597+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348229	2003-11-20 20:38:19+02	2003-11-20 20:20:53.287547+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348232	2003-11-20 20:38:20+02	2003-11-20 20:20:54.288274+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348233	2003-11-20 20:38:20+02	2003-11-20 20:20:54.310446+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348237	2003-11-20 20:38:21+02	2003-11-20 20:21:01.505045+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1317835	2003-11-19 18:01:17+02	2003-11-19 18:01:17.878604+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1317837	2003-11-19 18:01:17+02	2003-11-19 18:01:17.889016+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1317861	2003-11-19 18:01:17+02	2003-11-19 18:01:18.290174+02	r201	3732	mgd[4591]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1317842	2003-11-19 18:01:17+02	2003-11-19 18:01:18.079011+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1317844	2003-11-19 18:01:17+02	2003-11-19 18:01:18.092473+02	adrastea	3726	mgd[4781]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1317851	2003-11-19 18:01:17+02	2003-11-19 18:01:18.131276+02	r201	3732	mgd[4591]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [4591]		1
1317843	2003-11-19 18:01:17+02	2003-11-19 18:01:18.085515+02	atlas	3730	login:		login from 172.26.27.115 on ttyp2 as lab		1
1317850	2003-11-19 18:01:17+02	2003-11-19 18:01:18.125144+02	ganymede	3731	mgd[2473]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [2473]		1
1317912	2003-11-19 18:01:18+02	2003-11-19 18:01:19.329015+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/proc/2242/file', PID 2479, status 0		1
1317962	2003-11-19 18:01:18+02	2003-11-19 18:01:20.709062+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 4800, status 0		1
1317897	2003-11-19 18:01:18+02	2003-11-19 18:01:19.03388+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4787, status 0		1
1317960	2003-11-19 18:01:18+02	2003-11-19 18:01:20.57468+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4799, status 0		1
1317906	2003-11-19 18:01:18+02	2003-11-19 18:01:19.192495+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/proc/4419/file'		1
1317926	2003-11-19 18:01:18+02	2003-11-19 18:01:19.562966+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/proc/2240/file', PID 2482, status 0		1
1317974	2003-11-19 18:01:18+02	2003-11-19 18:01:21.265889+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4596, status 0		1
1317900	2003-11-19 18:01:18+02	2003-11-19 18:01:19.04635+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/proc/4407/file'		1
1319185	2003-11-19 18:05:18+02	2003-11-19 18:05:20.290039+02	atlas	3730	init:		pgm (PID 2267) started		10
1317955	2003-11-19 18:01:18+02	2003-11-19 18:01:20.544803+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/proc/4424/file', PID 4595, status 0		1
1317946	2003-11-19 18:01:18+02	2003-11-19 18:01:20.281167+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4846, status 0		1
1317957	2003-11-19 18:01:18+02	2003-11-19 18:01:20.559766+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 4798, status 0		1
1317956	2003-11-19 18:01:18+02	2003-11-19 18:01:20.549489+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 4797, status 0		1
1317959	2003-11-19 18:01:18+02	2003-11-19 18:01:20.569296+02	ganymede	3731	mgd[2473]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1317883	2003-11-19 18:01:18+02	2003-11-19 18:01:18.792821+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/proc/4453/file', PID 4593, status 0		1
1317958	2003-11-19 18:01:18+02	2003-11-19 18:01:20.564774+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1317925	2003-11-19 18:01:18+02	2003-11-19 18:01:19.558315+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/proc/4432/file', PID 4842, status 0		1
1317870	2003-11-19 18:01:18+02	2003-11-19 18:01:18.437581+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 4784, status 0		1
1317875	2003-11-19 18:01:18+02	2003-11-19 18:01:18.654961+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1318021	2003-11-19 18:01:18+02	2003-11-19 18:01:22.22012+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317923	2003-11-19 18:01:18+02	2003-11-19 18:01:19.544646+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/proc/2240/file'		1
1317961	2003-11-19 18:01:18+02	2003-11-19 18:01:20.599471+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1317872	2003-11-19 18:01:18+02	2003-11-19 18:01:18.639037+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/proc/4434/file'		1
1318008	2003-11-19 18:01:18+02	2003-11-19 18:01:21.859366+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1318020	2003-11-19 18:01:18+02	2003-11-19 18:01:22.203329+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4810, status 0		1
1318013	2003-11-19 18:01:18+02	2003-11-19 18:01:22.081819+02	adrastea	3726	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1317922	2003-11-19 18:01:18+02	2003-11-19 18:01:19.539066+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/proc/2243/file', PID 2481, status 0		1
1317935	2003-11-19 18:01:18+02	2003-11-19 18:01:19.835986+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 4793, status 0		1
1317966	2003-11-19 18:01:18+02	2003-11-19 18:01:21.040821+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 4802, status 0		1
1317873	2003-11-19 18:01:18+02	2003-11-19 18:01:18.644733+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1317963	2003-11-19 18:01:18+02	2003-11-19 18:01:20.849766+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1317964	2003-11-19 18:01:18+02	2003-11-19 18:01:20.890459+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 4801, status 0		1
1317965	2003-11-19 18:01:18+02	2003-11-19 18:01:20.979989+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1317972	2003-11-19 18:01:18+02	2003-11-19 18:01:21.252771+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4804, status 0		1
1317985	2003-11-19 18:01:18+02	2003-11-19 18:01:21.428648+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/proc/4439/file', PID 4599, status 0		1
1317973	2003-11-19 18:01:18+02	2003-11-19 18:01:21.261113+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1317918	2003-11-19 18:01:18+02	2003-11-19 18:01:19.403098+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/proc/2243/file'		1
1317896	2003-11-19 18:01:18+02	2003-11-19 18:01:18.961966+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/proc/4442/file', PID 4838, status 0		1
1317969	2003-11-19 18:01:18+02	2003-11-19 18:01:21.126099+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/2250/file', PID 4803, status 0		1
1317968	2003-11-19 18:01:18+02	2003-11-19 18:01:21.118873+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1317895	2003-11-19 18:01:18+02	2003-11-19 18:01:18.957547+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/proc/2231/file'		1
1317933	2003-11-19 18:01:18+02	2003-11-19 18:01:19.817188+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/proc/4426/file', PID 4843, status 0		1
1317971	2003-11-19 18:01:18+02	2003-11-19 18:01:21.135142+02	atlas	3730	mgd[4836]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1317970	2003-11-19 18:01:18+02	2003-11-19 18:01:21.13086+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1317894	2003-11-19 18:01:18+02	2003-11-19 18:01:18.95135+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/proc/2224/file', PID 2476, status 0		1
1317893	2003-11-19 18:01:18+02	2003-11-19 18:01:18.947333+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/proc/4442/file'		1
1317932	2003-11-19 18:01:18+02	2003-11-19 18:01:19.690095+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/proc/2246/file'		1
1317936	2003-11-19 18:01:18+02	2003-11-19 18:01:19.892087+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1317976	2003-11-19 18:01:18+02	2003-11-19 18:01:21.274595+02	adrastea	3726	mgd[4781]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1317944	2003-11-19 18:01:18+02	2003-11-19 18:01:20.220874+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/proc/4413/file'		1
1317975	2003-11-19 18:01:18+02	2003-11-19 18:01:21.270401+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/proc/4438/file'		1
1317871	2003-11-19 18:01:18+02	2003-11-19 18:01:18.442494+02	ganymede	3731	mgd[2473]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1317869	2003-11-19 18:01:18+02	2003-11-19 18:01:18.433718+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1317877	2003-11-19 18:01:18+02	2003-11-19 18:01:18.663426+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/proc/2258/file'		1
1317904	2003-11-19 18:01:18+02	2003-11-19 18:01:19.18049+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1317937	2003-11-19 18:01:18+02	2003-11-19 18:01:19.989281+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/proc/2246/file', PID 2484, status 0		1
1317939	2003-11-19 18:01:18+02	2003-11-19 18:01:20.068238+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/proc/4429/file'		1
1317943	2003-11-19 18:01:18+02	2003-11-19 18:01:20.215711+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1317945	2003-11-19 18:01:18+02	2003-11-19 18:01:20.276304+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 4795, status 0		1
1317947	2003-11-19 18:01:18+02	2003-11-19 18:01:20.288563+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/2230/file'		1
1317948	2003-11-19 18:01:18+02	2003-11-19 18:01:20.296085+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/proc/4436/file'		1
1317949	2003-11-19 18:01:18+02	2003-11-19 18:01:20.302486+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/proc/4436/file', PID 4847, status 0		1
1317951	2003-11-19 18:01:18+02	2003-11-19 18:01:20.313314+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/proc/4424/file'		1
1317953	2003-11-19 18:01:18+02	2003-11-19 18:01:20.474018+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 4796, status 0		1
1317967	2003-11-19 18:01:18+02	2003-11-19 18:01:21.049213+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1318001	2003-11-19 18:01:18+02	2003-11-19 18:01:21.617034+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1318018	2003-11-19 18:01:18+02	2003-11-19 18:01:22.177602+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1317927	2003-11-19 18:01:18+02	2003-11-19 18:01:19.566679+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1317899	2003-11-19 18:01:18+02	2003-11-19 18:01:19.042551+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/proc/2231/file', PID 2477, status 0		1
1317977	2003-11-19 18:01:18+02	2003-11-19 18:01:21.279956+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/lrmuxd', PID 4805, status 0		1
1318012	2003-11-19 18:01:18+02	2003-11-19 18:01:22.071328+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317866	2003-11-19 18:01:18+02	2003-11-19 18:01:18.420065+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/proc/2251/file'		1
1317979	2003-11-19 18:01:18+02	2003-11-19 18:01:21.289225+02	ganymede	3731	mgd[2473]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1317867	2003-11-19 18:01:18+02	2003-11-19 18:01:18.424213+02	r201	3732	mgd[4591]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1317978	2003-11-19 18:01:18+02	2003-11-19 18:01:21.284883+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/proc/4438/file', PID 4597, status 0		1
1317931	2003-11-19 18:01:18+02	2003-11-19 18:01:19.582405+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/proc/2250/file'		1
1317980	2003-11-19 18:01:18+02	2003-11-19 18:01:21.293293+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1318011	2003-11-19 18:01:18+02	2003-11-19 18:01:21.956303+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4808, status 0		1
1317983	2003-11-19 18:01:18+02	2003-11-19 18:01:21.418846+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/proc/4431/file', PID 4598, status 0		1
1317984	2003-11-19 18:01:18+02	2003-11-19 18:01:21.42418+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/proc/4439/file'		1
1317868	2003-11-19 18:01:18+02	2003-11-19 18:01:18.429836+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 4783, status 0		1
1317924	2003-11-19 18:01:18+02	2003-11-19 18:01:19.554426+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/proc/2253/file'		1
1317942	2003-11-19 18:01:18+02	2003-11-19 18:01:20.199178+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/proc/4429/file', PID 4845, status 0		1
1317982	2003-11-19 18:01:18+02	2003-11-19 18:01:21.409998+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/proc/4431/file'		1
1318010	2003-11-19 18:01:18+02	2003-11-19 18:01:21.943377+02	atlas	3730	mgd[4836]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1317898	2003-11-19 18:01:18+02	2003-11-19 18:01:19.038557+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/proc/2252/file'		1
1317928	2003-11-19 18:01:18+02	2003-11-19 18:01:19.570631+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/proc/4426/file'		1
1318009	2003-11-19 18:01:18+02	2003-11-19 18:01:21.872212+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4849, status 0		1
1317886	2003-11-19 18:01:18+02	2003-11-19 18:01:18.805885+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/proc/4431/file'		1
1317981	2003-11-19 18:01:18+02	2003-11-19 18:01:21.297633+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/2256/file', PID 4806, status 0		1
1317909	2003-11-19 18:01:18+02	2003-11-19 18:01:19.204971+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/2251/file', PID 4789, status 0		1
1317991	2003-11-19 18:01:18+02	2003-11-19 18:01:21.46217+02	adrastea	3726	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1318019	2003-11-19 18:01:18+02	2003-11-19 18:01:22.192138+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317916	2003-11-19 18:01:18+02	2003-11-19 18:01:19.392214+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1317934	2003-11-19 18:01:18+02	2003-11-19 18:01:19.824112+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/proc/4433/file'		1
1317876	2003-11-19 18:01:18+02	2003-11-19 18:01:18.659598+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 2474, status 0		1
1317954	2003-11-19 18:01:18+02	2003-11-19 18:01:20.538238+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1317940	2003-11-19 18:01:18+02	2003-11-19 18:01:20.077868+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4794, status 0		1
1317990	2003-11-19 18:01:18+02	2003-11-19 18:01:21.45554+02	adrastea	3726	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1317986	2003-11-19 18:01:18+02	2003-11-19 18:01:21.433816+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/proc/4433/file'		1
1317885	2003-11-19 18:01:18+02	2003-11-19 18:01:18.801959+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/proc/2241/file', PID 4786, status 0		1
1317921	2003-11-19 18:01:18+02	2003-11-19 18:01:19.43409+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/proc/2248/file', PID 4791, status 0		1
1317902	2003-11-19 18:01:18+02	2003-11-19 18:01:19.170947+02	adrastea	3726	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1318007	2003-11-19 18:01:18+02	2003-11-19 18:01:21.846962+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4848, status 0		1
1317987	2003-11-19 18:01:18+02	2003-11-19 18:01:21.440096+02	atlas	3730	mgd[4836]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1317874	2003-11-19 18:01:18+02	2003-11-19 18:01:18.650882+02	adrastea	3726	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1317989	2003-11-19 18:01:18+02	2003-11-19 18:01:21.451413+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/usr/sbin/ksyncd'		1
1317988	2003-11-19 18:01:18+02	2003-11-19 18:01:21.444622+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/proc/4433/file', PID 4600, status 0		1
1317996	2003-11-19 18:01:18+02	2003-11-19 18:01:21.594465+02	adrastea	3726	mgd[4781]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1318015	2003-11-19 18:01:18+02	2003-11-19 18:01:22.158284+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1317911	2003-11-19 18:01:18+02	2003-11-19 18:01:19.212883+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/proc/4419/file', PID 4840, status 0		1
1317995	2003-11-19 18:01:18+02	2003-11-19 18:01:21.587051+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317880	2003-11-19 18:01:18+02	2003-11-19 18:01:18.676702+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/proc/2230/file', PID 4785, status 0		1
1317938	2003-11-19 18:01:18+02	2003-11-19 18:01:20.063725+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/proc/4433/file', PID 4844, status 0		1
1317884	2003-11-19 18:01:18+02	2003-11-19 18:01:18.79653+02	atlas	3730	mgd[4836]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show version '		1
1317901	2003-11-19 18:01:18+02	2003-11-19 18:01:19.055309+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/proc/2252/file', PID 4788, status 0		1
1317919	2003-11-19 18:01:18+02	2003-11-19 18:01:19.417802+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 4841, status 0		1
1317992	2003-11-19 18:01:18+02	2003-11-19 18:01:21.569582+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 4601, status 0		1
1317881	2003-11-19 18:01:18+02	2003-11-19 18:01:18.680695+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/proc/2241/file'		1
1317879	2003-11-19 18:01:18+02	2003-11-19 18:01:18.672986+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/proc/4453/file'		1
1317882	2003-11-19 18:01:18+02	2003-11-19 18:01:18.789002+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/proc/2258/file', PID 2475, status 0		1
1317920	2003-11-19 18:01:18+02	2003-11-19 18:01:19.430195+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/proc/4432/file'		1
1317994	2003-11-19 18:01:18+02	2003-11-19 18:01:21.579434+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/proc/4442/file', PID 4602, status 0		1
1317993	2003-11-19 18:01:18+02	2003-11-19 18:01:21.574547+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/proc/4442/file'		1
1317892	2003-11-19 18:01:18+02	2003-11-19 18:01:18.94158+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1317878	2003-11-19 18:01:18+02	2003-11-19 18:01:18.667831+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/proc/4434/file', PID 4592, status 0		1
1317890	2003-11-19 18:01:18+02	2003-11-19 18:01:18.829024+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/proc/2224/file'		1
1318014	2003-11-19 18:01:18+02	2003-11-19 18:01:22.086244+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317917	2003-11-19 18:01:18+02	2003-11-19 18:01:19.396792+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/proc/2238/file', PID 2480, status 0		1
1317929	2003-11-19 18:01:18+02	2003-11-19 18:01:19.574457+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/proc/2253/file', PID 4792, status 0		1
1318017	2003-11-19 18:01:18+02	2003-11-19 18:01:22.173481+02	adrastea	3726	last		message repeated 4 times		10
1317941	2003-11-19 18:01:18+02	2003-11-19 18:01:20.084808+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/usr/sbin/lrmuxd'		1
1317930	2003-11-19 18:01:18+02	2003-11-19 18:01:19.578436+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/ksyncd', PID 2483, status 0		1
1318016	2003-11-19 18:01:18+02	2003-11-19 18:01:22.168671+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b8f1fc/32		10
1317913	2003-11-19 18:01:18+02	2003-11-19 18:01:19.334742+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/proc/2238/file'		1
1317891	2003-11-19 18:01:18+02	2003-11-19 18:01:18.833007+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/proc/4431/file', PID 4837, status 0		1
1317915	2003-11-19 18:01:18+02	2003-11-19 18:01:19.388465+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/proc/2248/file'		1
1317952	2003-11-19 18:01:18+02	2003-11-19 18:01:20.429046+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/proc/2256/file'		1
1318006	2003-11-19 18:01:18+02	2003-11-19 18:01:21.84148+02	r201	3732	mgd[4591]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show chassis hardware '		1
1317910	2003-11-19 18:01:18+02	2003-11-19 18:01:19.209077+02	adrastea	3726	mgd[4782]:	UI_CHILD_START:	Starting child '/proc/2269/file'		1
1338084	2003-11-20 15:58:09+02	2003-11-20 15:40:42.27062+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338086	2003-11-20 15:58:10+02	2003-11-20 15:40:43.283823+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338085	2003-11-20 15:58:10+02	2003-11-20 15:40:43.266386+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338089	2003-11-20 15:58:11+02	2003-11-20 15:40:44.279515+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338090	2003-11-20 15:58:11+02	2003-11-20 15:40:44.283345+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338088	2003-11-20 15:58:11+02	2003-11-20 15:40:44.266928+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338091	2003-11-20 15:58:12+02	2003-11-20 15:40:45.266962+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338092	2003-11-20 15:58:12+02	2003-11-20 15:40:45.276529+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338093	2003-11-20 15:58:12+02	2003-11-20 15:40:45.28035+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338095	2003-11-20 15:58:13+02	2003-11-20 15:40:46.285358+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338094	2003-11-20 15:58:13+02	2003-11-20 15:40:46.267922+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338096	2003-11-20 15:58:13+02	2003-11-20 15:40:46.289108+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338099	2003-11-20 15:58:14+02	2003-11-20 15:40:47.282094+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338098	2003-11-20 15:58:14+02	2003-11-20 15:40:47.26771+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338101	2003-11-20 15:58:15+02	2003-11-20 15:40:54.204659+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1358288	2003-11-21 19:45:18+02	2003-11-21 19:45:20.424074+02	r201	3732	mgd[4921]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1317997	2003-11-19 18:01:18+02	2003-11-19 18:01:21.599516+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317908	2003-11-19 18:01:18+02	2003-11-19 18:01:19.201138+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/proc/2242/file'		1
1317999	2003-11-19 18:01:18+02	2003-11-19 18:01:21.607464+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317907	2003-11-19 18:01:18+02	2003-11-19 18:01:19.197212+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/serviced', PID 2478, status 0		1
1317950	2003-11-19 18:01:18+02	2003-11-19 18:01:20.308549+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/proc/4413/file', PID 4594, status 0		1
1317998	2003-11-19 18:01:18+02	2003-11-19 18:01:21.603456+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2485, status 0		1
1318005	2003-11-19 18:01:18+02	2003-11-19 18:01:21.836209+02	atlas	3730	mgd[4836]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1317905	2003-11-19 18:01:18+02	2003-11-19 18:01:19.18865+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/proc/4407/file', PID 4839, status 0		1
1317914	2003-11-19 18:01:18+02	2003-11-19 18:01:19.338674+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/proc/2269/file', PID 4790, status 0		1
1318000	2003-11-19 18:01:18+02	2003-11-19 18:01:21.612154+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4807, status 0		1
1317903	2003-11-19 18:01:18+02	2003-11-19 18:01:19.176708+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/usr/sbin/serviced'		1
1318004	2003-11-19 18:01:18+02	2003-11-19 18:01:21.830534+02	ganymede	3731	mgd[2473]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1318002	2003-11-19 18:01:18+02	2003-11-19 18:01:21.770113+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2486, status 0		1
1318003	2003-11-19 18:01:18+02	2003-11-19 18:01:21.815769+02	ganymede	3731	mgd[2473]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1318051	2003-11-19 18:01:19+02	2003-11-19 18:01:22.863025+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1318057	2003-11-19 18:01:19+02	2003-11-19 18:01:23.008133+02	atlas	3730	mgd[4836]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1318033	2003-11-19 18:01:19+02	2003-11-19 18:01:22.523929+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1318053	2003-11-19 18:01:19+02	2003-11-19 18:01:22.9864+02	atlas	3730	mgd[4836]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4850, status 0		1
1318052	2003-11-19 18:01:19+02	2003-11-19 18:01:22.98053+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b59afc/32		10
1318055	2003-11-19 18:01:19+02	2003-11-19 18:01:22.996248+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1318056	2003-11-19 18:01:19+02	2003-11-19 18:01:23.00177+02	atlas	3730	mgd[4836]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1318059	2003-11-19 18:01:19+02	2003-11-19 18:01:23.024618+02	r201	3732	mgd[4591]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1318031	2003-11-19 18:01:19+02	2003-11-19 18:01:22.403819+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1318058	2003-11-19 18:01:19+02	2003-11-19 18:01:23.014357+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4604, status 0		1
1318046	2003-11-19 18:01:19+02	2003-11-19 18:01:22.753368+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1318022	2003-11-19 18:01:19+02	2003-11-19 18:01:22.347884+02	r201	3732	mgd[4591]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show configuration '		1
1318069	2003-11-19 18:01:19+02	2003-11-19 18:01:23.272215+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1318067	2003-11-19 18:01:19+02	2003-11-19 18:01:23.254396+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b1a8fc/32		10
1318062	2003-11-19 18:01:19+02	2003-11-19 18:01:23.201369+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1318060	2003-11-19 18:01:19+02	2003-11-19 18:01:23.032006+02	atlas	3730	inetd[4414]:	/usr/libexec/telnetd[4834]:	exit status 0x100		10
1318066	2003-11-19 18:01:19+02	2003-11-19 18:01:23.248942+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b238fc/32		10
1318068	2003-11-19 18:01:19+02	2003-11-19 18:01:23.262439+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bb4ffc/32		10
1318064	2003-11-19 18:01:19+02	2003-11-19 18:01:23.234994+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1baa5fc/32		10
1318065	2003-11-19 18:01:19+02	2003-11-19 18:01:23.241208+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b98ffc/32		10
1318063	2003-11-19 18:01:19+02	2003-11-19 18:01:23.22668+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b7dbfc/32		10
1318074	2003-11-19 18:01:19+02	2003-11-19 18:01:23.402253+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1318073	2003-11-19 18:01:19+02	2003-11-19 18:01:23.396745+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1318032	2003-11-19 18:01:19+02	2003-11-19 18:01:22.509183+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1318072	2003-11-19 18:01:19+02	2003-11-19 18:01:23.391033+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b3e7fc/32		10
1318034	2003-11-19 18:01:19+02	2003-11-19 18:01:22.529495+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1318090	2003-11-19 18:01:19+02	2003-11-19 18:01:23.732601+02	ganymede	3731	mgd[2473]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1318080	2003-11-19 18:01:19+02	2003-11-19 18:01:23.429435+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/1) ifd vptree not initialized		10
1318071	2003-11-19 18:01:19+02	2003-11-19 18:01:23.283343+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1318092	2003-11-19 18:01:19+02	2003-11-19 18:01:23.849166+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[2471]:	exit status 0x100		10
1318091	2003-11-19 18:01:19+02	2003-11-19 18:01:23.740139+02	ganymede	3731	mgd[2473]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1318079	2003-11-19 18:01:19+02	2003-11-19 18:01:23.424376+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1318028	2003-11-19 18:01:19+02	2003-11-19 18:01:22.385756+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1318036	2003-11-19 18:01:19+02	2003-11-19 18:01:22.5763+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1318042	2003-11-19 18:01:19+02	2003-11-19 18:01:22.730195+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1318049	2003-11-19 18:01:19+02	2003-11-19 18:01:22.805903+02	atlas	3730	last		message repeated 2 times		10
1318061	2003-11-19 18:01:19+02	2003-11-19 18:01:23.036889+02	r201	3732	mgd[4591]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1318070	2003-11-19 18:01:19+02	2003-11-19 18:01:23.277785+02	ganymede	3731	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b980fc/32		10
1318081	2003-11-19 18:01:19+02	2003-11-19 18:01:23.435848+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1338736	2003-11-20 16:00:00+02	2003-11-20 16:00:00.522713+02	atlas	3730	CRON[2729]:		(root) CMD (newsyslog) 		10
1338731	2003-11-20 16:00:00+02	2003-11-20 16:00:00.250272+02	adrastea	3726	CRON[4987]:		(root) CMD (newsyslog) 		10
1338735	2003-11-20 16:00:00+02	2003-11-20 16:00:00.460779+02	ganymede	3731	CRON[2838]:		(root) CMD (newsyslog) 		10
1338161	2003-11-20 16:00:00+02	2003-11-20 15:42:33.225675+02	jupiter	3727	CRON[7056]:		(root) CMD (newsyslog) 		10
1338743	2003-11-20 16:00:01+02	2003-11-20 16:00:01.105289+02	r201	3732	CRON[4743]:		(root) CMD (newsyslog) 		10
1318087	2003-11-19 18:01:19+02	2003-11-19 18:01:23.655978+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1318078	2003-11-19 18:01:19+02	2003-11-19 18:01:23.42051+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1318050	2003-11-19 18:01:19+02	2003-11-19 18:01:22.813886+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1318048	2003-11-19 18:01:19+02	2003-11-19 18:01:22.765769+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1b59afc/32		10
1318077	2003-11-19 18:01:19+02	2003-11-19 18:01:23.415428+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1318047	2003-11-19 18:01:19+02	2003-11-19 18:01:22.757453+02	atlas	3730	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1318075	2003-11-19 18:01:19+02	2003-11-19 18:01:23.406215+02	ganymede	3731	/kernel:	atmvp_getnext:	(at-1/1/0) ifd vptree not initialized		10
1318076	2003-11-19 18:01:19+02	2003-11-19 18:01:23.410133+02	ganymede	3731	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1318084	2003-11-19 18:01:19+02	2003-11-19 18:01:23.559616+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1318054	2003-11-19 18:01:19+02	2003-11-19 18:01:22.992032+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4603, status 0		1
1318035	2003-11-19 18:01:19+02	2003-11-19 18:01:22.539805+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1318045	2003-11-19 18:01:19+02	2003-11-19 18:01:22.74916+02	adrastea	3726	mgd[4781]:	UI_CHILD_START:	Starting child '/sbin/ifinfo'		1
1318030	2003-11-19 18:01:19+02	2003-11-19 18:01:22.396143+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1318089	2003-11-19 18:01:19+02	2003-11-19 18:01:23.724565+02	r201	3732	mgd[4591]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4605, status 0		1
1318083	2003-11-19 18:01:19+02	2003-11-19 18:01:23.555561+02	ganymede	3731	mgd[2473]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 2487, status 0		1
1318082	2003-11-19 18:01:19+02	2003-11-19 18:01:23.549714+02	ganymede	3731	/kernel:	ifvp_request:	ifvp is NULL 		10
1318044	2003-11-19 18:01:19+02	2003-11-19 18:01:22.744268+02	adrastea	3726	mgd[4781]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show interfaces extensive '		1
1318029	2003-11-19 18:01:19+02	2003-11-19 18:01:22.390044+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1318088	2003-11-19 18:01:19+02	2003-11-19 18:01:23.675734+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc3919efc/32		10
1318037	2003-11-19 18:01:19+02	2003-11-19 18:01:22.595445+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1318025	2003-11-19 18:01:19+02	2003-11-19 18:01:22.37007+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1318023	2003-11-19 18:01:19+02	2003-11-19 18:01:22.353178+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1318024	2003-11-19 18:01:19+02	2003-11-19 18:01:22.363776+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1318086	2003-11-19 18:01:19+02	2003-11-19 18:01:23.651759+02	r201	3732	last		message repeated 3 times		10
1318040	2003-11-19 18:01:19+02	2003-11-19 18:01:22.61234+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1318039	2003-11-19 18:01:19+02	2003-11-19 18:01:22.604449+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1318026	2003-11-19 18:01:19+02	2003-11-19 18:01:22.375486+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1318027	2003-11-19 18:01:19+02	2003-11-19 18:01:22.37975+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1318038	2003-11-19 18:01:19+02	2003-11-19 18:01:22.600056+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1318085	2003-11-19 18:01:19+02	2003-11-19 18:01:23.628025+02	r201	3732	/kernel:	in_ifalrequest:	.local. op 5 local 0xc3919efc/32		10
1318043	2003-11-19 18:01:19+02	2003-11-19 18:01:22.736029+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4811, status 0		1
1318041	2003-11-19 18:01:19+02	2003-11-19 18:01:22.619187+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1318107	2003-11-19 18:01:20+02	2003-11-19 18:01:24.037092+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1318105	2003-11-19 18:01:20+02	2003-11-19 18:01:24.02668+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 atm_vpinode:c6727c00		10
1318102	2003-11-19 18:01:20+02	2003-11-19 18:01:24.009068+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1318115	2003-11-19 18:01:20+02	2003-11-19 18:01:24.261311+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1318112	2003-11-19 18:01:20+02	2003-11-19 18:01:24.172806+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1318114	2003-11-19 18:01:20+02	2003-11-19 18:01:24.253685+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1318113	2003-11-19 18:01:20+02	2003-11-19 18:01:24.239599+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1318103	2003-11-19 18:01:20+02	2003-11-19 18:01:24.013005+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) found, operation: 4 ifvp: 0xc6727c00 		10
1318095	2003-11-19 18:01:20+02	2003-11-19 18:01:23.876275+02	r201	3732	inetd[4419]:	/usr/libexec/telnetd[4589]:	exit status 0x100		10
1318117	2003-11-19 18:01:20+02	2003-11-19 18:01:24.275204+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc6915a00 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1318094	2003-11-19 18:01:20+02	2003-11-19 18:01:23.871584+02	r201	3732	mgd[4591]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1318116	2003-11-19 18:01:20+02	2003-11-19 18:01:24.270677+02	adrastea	3726	/kernel:	flags:	1 cookie:1		10
1318120	2003-11-19 18:01:20+02	2003-11-19 18:01:24.356738+02	adrastea	3726	/kernel:	atmvp_getnext:	(at-6/0/1) ifd vptree not initialized		10
1318118	2003-11-19 18:01:20+02	2003-11-19 18:01:24.290663+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 4		10
1318121	2003-11-19 18:01:20+02	2003-11-19 18:01:24.3643+02	adrastea	3726	/kernel:	atmvp_request:	vpi (0) not found, operation: 5		10
1318125	2003-11-19 18:01:20+02	2003-11-19 18:01:24.486364+02	adrastea	3726	mgd[4782]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1318122	2003-11-19 18:01:20+02	2003-11-19 18:01:24.470866+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1318123	2003-11-19 18:01:20+02	2003-11-19 18:01:24.476629+02	adrastea	3726	mgd[4782]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4809, status 0		1
1318124	2003-11-19 18:01:20+02	2003-11-19 18:01:24.481123+02	adrastea	3726	mgd[4782]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1318126	2003-11-19 18:01:20+02	2003-11-19 18:01:24.491046+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[4779]:	exit status 0x100		10
1318127	2003-11-19 18:01:20+02	2003-11-19 18:01:24.4969+02	adrastea	3726	mgd[4781]:	UI_CHILD_STATUS:	Cleanup child '/sbin/ifinfo', PID 4812, status 0		1
1318101	2003-11-19 18:01:20+02	2003-11-19 18:01:23.904804+02	adrastea	3726	last		message repeated 4 times		10
1318106	2003-11-19 18:01:20+02	2003-11-19 18:01:24.032422+02	adrastea	3726	/kernel:		if_pfe_msg_if_reply Received IFVP_STATS, vpi:0 opackets:0ipackets:0		10
1318135	2003-11-19 18:01:20+02	2003-11-19 18:01:24.833202+02	adrastea	3726	mgd[4781]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1318134	2003-11-19 18:01:20+02	2003-11-19 18:01:24.824821+02	adrastea	3726	mgd[4781]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1318093	2003-11-19 18:01:20+02	2003-11-19 18:01:23.863479+02	r201	3732	mgd[4591]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1318099	2003-11-19 18:01:20+02	2003-11-19 18:01:23.894463+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0/0		10
1318100	2003-11-19 18:01:20+02	2003-11-19 18:01:23.899347+02	adrastea	3726	/kernel:	in_ifalrequest:	.local. op 5 local 0xc1bc37fc/32		10
1318104	2003-11-19 18:01:20+02	2003-11-19 18:01:24.017218+02	adrastea	3726	/kernel:	if_pfe_atm_vpstats:	op 4 		10
1318110	2003-11-19 18:01:20+02	2003-11-19 18:01:24.050751+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1318111	2003-11-19 18:01:20+02	2003-11-19 18:01:24.05493+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1318119	2003-11-19 18:01:20+02	2003-11-19 18:01:24.301723+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1318136	2003-11-19 18:01:20+02	2003-11-19 18:01:24.83773+02	adrastea	3726	inetd[2236]:	/usr/libexec/telnetd[4777]:	exit status 0x100		10
1318108	2003-11-19 18:01:20+02	2003-11-19 18:01:24.041497+02	adrastea	3726	/kernel:	ifvp_request:	ifvp is NULL 		10
1318109	2003-11-19 18:01:20+02	2003-11-19 18:01:24.045526+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1318277	2003-11-19 18:02:03+02	2003-11-19 18:02:03.771725+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1318278	2003-11-19 18:02:03+02	2003-11-19 18:02:03.959824+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2488, status 0		1
1318276	2003-11-19 18:02:03+02	2003-11-19 18:02:03.753061+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1318286	2003-11-19 18:02:04+02	2003-11-19 18:02:04.802672+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1318287	2003-11-19 18:02:04+02	2003-11-19 18:02:04.87655+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1318288	2003-11-19 18:02:04+02	2003-11-19 18:02:05.010038+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2489, status 0		1
1318294	2003-11-19 18:02:06+02	2003-11-19 18:02:07.090367+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/usr/sbin/dfwinfo', PID 2490, status 0		1
1318293	2003-11-19 18:02:06+02	2003-11-19 18:02:06.884715+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/usr/sbin/dfwinfo'		1
1318292	2003-11-19 18:02:06+02	2003-11-19 18:02:06.879007+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'run show firewall '		1
1318300	2003-11-19 18:02:09+02	2003-11-19 18:02:09.606321+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'top '		1
1318305	2003-11-19 18:02:10+02	2003-11-19 18:02:10.43863+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'exit '		1
1318306	2003-11-19 18:02:10+02	2003-11-19 18:02:10.455+02	ganymede	3731	mgd[2395]:	UI_DBASE_LOGOUT_EVENT:	User 'lab' exiting configuration mode		1
1318310	2003-11-19 18:02:13+02	2003-11-19 18:02:13.812019+02	ganymede	3731	mgd[2395]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'request system reboot '		1
1318317	2003-11-19 18:02:14+02	2003-11-19 18:02:14.661367+02	ganymede	3731	mgd[2395]:	UI_CHILD_START:	Starting child '/sbin/shutdown'		1
1318316	2003-11-19 18:02:14+02	2003-11-19 18:02:14.651818+02	ganymede	3731	mgd[2395]:	UI_REBOOT_EVENT:	System rebooted by 'lab'		1
1318318	2003-11-19 18:02:15+02	2003-11-19 18:02:15.337183+02	ganymede	3731	mgd[2395]:	UI_CHILD_STATUS:	Cleanup child '/sbin/shutdown', PID 2491, status 0		1
1318324	2003-11-19 18:02:18+02	2003-11-19 18:02:18.641018+02	atlas	3730	mgd[4589]:	UI_DBASE_LOGOUT_EVENT:	User 'lab' exiting configuration mode		1
1318323	2003-11-19 18:02:18+02	2003-11-19 18:02:18.621729+02	atlas	3730	mgd[4589]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'exit '		1
1318376	2003-11-19 18:02:20+02	2003-11-19 18:02:21.204018+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(73) family 2		10
1318329	2003-11-19 18:02:20+02	2003-11-19 18:02:20.465948+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(69) family 36		10
1318372	2003-11-19 18:02:20+02	2003-11-19 18:02:21.188723+02	ganymede	3731	rpd[2252]:		EVENT Delete so-0/1/0.0 index 70 192.3.1.1 -> 192.3.1.1 <Broadcast PointToPoint Multicast>		10
1318341	2003-11-19 18:02:20+02	2003-11-19 18:02:20.723664+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(70) family 2		10
1318396	2003-11-19 18:02:20+02	2003-11-19 18:02:21.508113+02	ganymede	3731	rpd[2252]:		EVENT Delete UpDown mo-0/3/0.16383 index 73 <Broadcast PointToPoint Multicast>		10
1318349	2003-11-19 18:02:20+02	2003-11-19 18:02:20.860455+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(71) local_prefix 0xc686400e dest_prefix 0xc6864022 dest_plen 32 flags 0x3		10
1318331	2003-11-19 18:02:20+02	2003-11-19 18:02:20.475319+02	ganymede	3731	mib2d[2251]:	SNMP_TRAP_LINK_DOWN:	ifIndex 73, ifAdminStatus up(1), ifOperStatus down(2), ifName e1-0/0/0		10
1318366	2003-11-19 18:02:20+02	2003-11-19 18:02:21.040274+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 136 <Broadcast Multicast>		10
1318358	2003-11-19 18:02:20+02	2003-11-19 18:02:21.005585+02	ganymede	3731	rpd[2252]:		EVENT UpDown sp-0/2/0.16383 index 72 10.0.0.1 -> 10.0.0.18 <Broadcast PointToPoint Multicast Localup>		10
1318353	2003-11-19 18:02:20+02	2003-11-19 18:02:20.875849+02	ganymede	3731	feb		Monitor PIC 0.3: ++Monitor: delete all of RR tree 		10
1318413	2003-11-19 18:02:20+02	2003-11-19 18:02:21.834885+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 145 <Broadcast Multicast> address #0 0.90.69.a0.14.9d		10
1318420	2003-11-19 18:02:20+02	2003-11-19 18:02:21.973071+02	atlas	3730	mgd[4589]:	UI_CHILD_START:	Starting child '/sbin/shutdown'		1
1318327	2003-11-19 18:02:20+02	2003-11-19 18:02:20.347974+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_DETACH_FPC:	ifdev_detach(0) 		10
1318346	2003-11-19 18:02:20+02	2003-11-19 18:02:20.743855+02	ganymede	3731	Slot		0, PIC Slot 2) Loopback mode is now disabled 		10
1318373	2003-11-19 18:02:20+02	2003-11-19 18:02:21.192585+02	ganymede	3731	rpd[2252]:		EVENT Delete so-0/1/0.0 index 70 <Broadcast PointToPoint Multicast>		10
1318407	2003-11-19 18:02:20+02	2003-11-19 18:02:21.80998+02	ganymede	3731	rpd[2252]:	bgp_peer_delete:	NOTIFICATION sent to 10.100.254.21 (Internal AS 100): code 6 (Cease) subcode 3 (Peer Unconfigured), Reason: Peer Deletion		10
1318348	2003-11-19 18:02:20+02	2003-11-19 18:02:20.85661+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 130 <Broadcast Multicast>		10
1318347	2003-11-19 18:02:20+02	2003-11-19 18:02:20.851137+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 129 <Broadcast Multicast>		10
1318398	2003-11-19 18:02:20+02	2003-11-19 18:02:21.628414+02	ganymede	3731	rpd[2252]:		EVENT <Delete UpDown> index 140 <Broadcast Multicast>		10
1318325	2003-11-19 18:02:20+02	2003-11-19 18:02:20.286677+02	atlas	3730	mgd[4589]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'request system reboot '		1
1318375	2003-11-19 18:02:20+02	2003-11-19 18:02:21.200301+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(65) local_prefix 0xc687060e dest_prefix 0 dest_plen 0 flags 0x2		10
1318352	2003-11-19 18:02:20+02	2003-11-19 18:02:20.871835+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> sp-0/2/0.16383 index 72 <Broadcast PointToPoint Multicast>		10
1318387	2003-11-19 18:02:20+02	2003-11-19 18:02:21.469938+02	ganymede	3731	rpd[2252]:		EVENT <Delete> sp-0/2/0.16383 index 72 <Broadcast PointToPoint Multicast>		10
1318374	2003-11-19 18:02:20+02	2003-11-19 18:02:21.196332+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(73) local_prefix 0xc689bd8e dest_prefix 0xc689bda2 dest_plen 32 flags 0x3		10
1318406	2003-11-19 18:02:20+02	2003-11-19 18:02:21.702777+02	ganymede	3731	rpd[2252]:	RPD_ISIS_ADJDOWN:	IS-IS lost L2 adjacency to r201 on ge-1/3/0.0, reason: Protocol Shutdown		10
1318393	2003-11-19 18:02:20+02	2003-11-19 18:02:21.494391+02	ganymede	3731	rpd[2252]:		EVENT <Delete UpDown> index 138 <Broadcast Multicast>		10
1318351	2003-11-19 18:02:20+02	2003-11-19 18:02:20.868082+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(71) family 2		10
1318404	2003-11-19 18:02:20+02	2003-11-19 18:02:21.694827+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_DETACH_ALL_PSEUDO:	ifdev_detach(pseudo devices: all) 		10
1318350	2003-11-19 18:02:20+02	2003-11-19 18:02:20.864239+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(71) local_prefix 0xc686400e dest_prefix 0xc6864022 dest_plen 32 flags 0x3		10
1318405	2003-11-19 18:02:20+02	2003-11-19 18:02:21.698795+02	ganymede	3731	rpd[2252]:	RPD_SIGNAL_TERMINATE:	first termination signal received		10
1318340	2003-11-19 18:02:20+02	2003-11-19 18:02:20.719846+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(70) local_prefix 0xc6893c0e dest_prefix 0xc6893c22 dest_plen 30 flags 0x3		10
1318357	2003-11-19 18:02:20+02	2003-11-19 18:02:21.000003+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(72) family 2		10
1338250	2003-11-20 16:03:09+02	2003-11-20 15:45:42.3439+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338252	2003-11-20 16:03:10+02	2003-11-20 15:45:43.367452+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338251	2003-11-20 16:03:10+02	2003-11-20 15:45:43.345485+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338254	2003-11-20 16:03:11+02	2003-11-20 15:45:44.36397+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338253	2003-11-20 16:03:11+02	2003-11-20 15:45:44.345133+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338255	2003-11-20 16:03:11+02	2003-11-20 15:45:44.367804+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1318382	2003-11-19 18:02:20+02	2003-11-19 18:02:21.339852+02	ganymede	3731	rpd[2252]:		EVENT Delete sp-0/2/0.16383 index 72 10.0.0.1 -> 10.0.0.18 <Broadcast PointToPoint Multicast>		10
1318395	2003-11-19 18:02:20+02	2003-11-19 18:02:21.504335+02	ganymede	3731	rpd[2252]:		EVENT Delete UpDown mo-0/3/0.16383 index 73 10.0.0.1 -> 10.0.0.19 <Broadcast PointToPoint Multicast Localup>		10
1318337	2003-11-19 18:02:20+02	2003-11-19 18:02:20.587088+02	ganymede	3731	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 2, af 2, run-len 0		10
1318354	2003-11-19 18:02:20+02	2003-11-19 18:02:20.881557+02	ganymede	3731	/kernel:	sp-0/2/0:	ifl config: op: 3; sub: 0; flags: 0x8010, curr: 0x8010.		10
1318381	2003-11-19 18:02:20+02	2003-11-19 18:02:21.335887+02	ganymede	3731	xntpd[2433]:		ntpd exiting on signal 15		1
1318380	2003-11-19 18:02:20+02	2003-11-19 18:02:21.332079+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 132 <Broadcast Multicast>		10
1318326	2003-11-19 18:02:20+02	2003-11-19 18:02:20.3411+02	ganymede	3731	shutdown:		reboot by root: 		10
1318412	2003-11-19 18:02:20+02	2003-11-19 18:02:21.831163+02	ganymede	3731	rpd[2252]:		EVENT <Delete UpDown> index 144 <Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1318397	2003-11-19 18:02:20+02	2003-11-19 18:02:21.622679+02	ganymede	3731	rpd[2252]:		EVENT <Delete UpDown> mo-0/3/0.16383 index 73 <Broadcast PointToPoint Multicast>		10
1318379	2003-11-19 18:02:20+02	2003-11-19 18:02:21.3207+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(74) family 2		10
1318408	2003-11-19 18:02:20+02	2003-11-19 18:02:21.815529+02	ganymede	3731	rpd[2252]:	RPD_LDP_NBRDOWN:	LDP neighbor 1.0.0.2 (ge-1/3/0.0) is down		10
1318377	2003-11-19 18:02:20+02	2003-11-19 18:02:21.30994+02	ganymede	3731	rpd[2252]:		EVENT <Delete> so-0/1/0.0 index 70 <Broadcast PointToPoint Multicast>		10
1318419	2003-11-19 18:02:20+02	2003-11-19 18:02:21.969367+02	atlas	3730	mgd[4589]:	UI_REBOOT_EVENT:	System rebooted by 'lab'		1
1318378	2003-11-19 18:02:20+02	2003-11-19 18:02:21.315338+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(74) local_prefix 0xc672520e dest_prefix 0xc6725222 dest_plen 24 flags 0x3		10
1318336	2003-11-19 18:02:20+02	2003-11-19 18:02:20.55581+02	ganymede	3731	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 1, af 2, run-len 0		10
1318335	2003-11-19 18:02:20+02	2003-11-19 18:02:20.551765+02	ganymede	3731	rpd[2252]:		EVENT Delete e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1318344	2003-11-19 18:02:20+02	2003-11-19 18:02:20.73504+02	ganymede	3731	/kernel:		if_msg_ifl_family_delete(70) family 7		10
1318345	2003-11-19 18:02:20+02	2003-11-19 18:02:20.738787+02	ganymede	3731	Slot		0, PIC Slot 2) ifl_tbl: Deleting alias for ifl 69: 0 		10
1318334	2003-11-19 18:02:20+02	2003-11-19 18:02:20.54211+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 128 <Broadcast Multicast>		10
1318411	2003-11-19 18:02:20+02	2003-11-19 18:02:21.827425+02	ganymede	3731	rpd[2252]:		EVENT <Delete UpDown> fe-1/0/3.0 index 74 <Broadcast Multicast> address #0 0.90.69.a0.14.81		10
1318356	2003-11-19 18:02:20+02	2003-11-19 18:02:20.891947+02	ganymede	3731	/kernel:		if_msg_ifl_addr_delete(72) local_prefix 0xc68abc0e dest_prefix 0xc68abc22 dest_plen 32 flags 0x3		10
1318339	2003-11-19 18:02:20+02	2003-11-19 18:02:20.715925+02	ganymede	3731	rpd[2252]:		EVENT <Delete> e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1318394	2003-11-19 18:02:20+02	2003-11-19 18:02:21.498671+02	ganymede	3731	rpd[2252]:		EVENT <Delete UpDown> index 139 <Broadcast Multicast>		10
1318355	2003-11-19 18:02:20+02	2003-11-19 18:02:20.888131+02	ganymede	3731	rpd[2252]:		EVENT UpDown sp-0/2/0.16383 index 72 <Broadcast PointToPoint Multicast>		10
1318338	2003-11-19 18:02:20+02	2003-11-19 18:02:20.709946+02	ganymede	3731	feb		Monitor PIC 0.3: ++Monitor: SAMPLEDC: Socket to SAMPLED closed 		10
1318385	2003-11-19 18:02:20+02	2003-11-19 18:02:21.352296+02	ganymede	3731	rpd[2252]:		EVENT Delete sp-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1318409	2003-11-19 18:02:20+02	2003-11-19 18:02:21.819352+02	ganymede	3731	rpd[2252]:	RPD_LDP_SESSIONDOWN:	LDP session 10.100.254.23 is down, reason: all adjacencies down		10
1318410	2003-11-19 18:02:20+02	2003-11-19 18:02:21.823153+02	ganymede	3731	rpd[2252]:		EVENT Delete UpDown fe-1/0/3.0 index 74 11.0.0.2/24 -> 11.0.0.255 <Broadcast Multicast Localup>		10
1318386	2003-11-19 18:02:20+02	2003-11-19 18:02:21.356535+02	ganymede	3731	rpd[2252]:		EVENT <Delete> sp-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1318364	2003-11-19 18:02:20+02	2003-11-19 18:02:21.032201+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 133 <Broadcast Multicast>		10
1318383	2003-11-19 18:02:20+02	2003-11-19 18:02:21.344285+02	ganymede	3731	rpd[2252]:		EVENT Delete sp-0/2/0.16383 index 72 <Broadcast PointToPoint Multicast>		10
1318342	2003-11-19 18:02:20+02	2003-11-19 18:02:20.727562+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 128 <Broadcast Multicast>		10
1318418	2003-11-19 18:02:20+02	2003-11-19 18:02:21.965616+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> index 148 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1318332	2003-11-19 18:02:20+02	2003-11-19 18:02:20.479393+02	ganymede	3731	rpd[2252]:		EVENT UpDown e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1318416	2003-11-19 18:02:20+02	2003-11-19 18:02:21.84786+02	ganymede	3731	rpd[2252]:		EVENT UpDown ge-1/3/0.0 index 76 <Broadcast Multicast>		10
1318390	2003-11-19 18:02:20+02	2003-11-19 18:02:21.48295+02	ganymede	3731	rpd[2252]:		EVENT <Delete UpDown> index 135 <Broadcast Multicast>		10
1318391	2003-11-19 18:02:20+02	2003-11-19 18:02:21.486689+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 136 <Broadcast Multicast>		10
1318388	2003-11-19 18:02:20+02	2003-11-19 18:02:21.475358+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 133 <Broadcast Multicast>		10
1318371	2003-11-19 18:02:20+02	2003-11-19 18:02:21.18484+02	ganymede	3731	eccd[2246]:		SIGTERM received, exiting 		10
1318389	2003-11-19 18:02:20+02	2003-11-19 18:02:21.479172+02	ganymede	3731	rpd[2252]:		EVENT <Delete UpDown> index 134 <Broadcast Multicast>		10
1318330	2003-11-19 18:02:20+02	2003-11-19 18:02:20.47081+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1318402	2003-11-19 18:02:20+02	2003-11-19 18:02:21.687213+02	ganymede	3731	rpd[2252]:	RPD_SNMP_SARECV:	snmp_epi_recv: error from sam_recv: 0		500
1318333	2003-11-19 18:02:20+02	2003-11-19 18:02:20.535584+02	ganymede	3731	rpd[2252]:	RPD_LAYER2_VC_DOWN:	 Layer-2 VC (VPN : x25_cqt, local-site : 2, remote-site : 1) state changed from UP to Dn		10
1318399	2003-11-19 18:02:20+02	2003-11-19 18:02:21.632216+02	ganymede	3731	rpd[2252]:		EVENT <Delete UpDown> index 141 <Broadcast Multicast> address #0 0.90.69.a0.14.7e		10
1318415	2003-11-19 18:02:20+02	2003-11-19 18:02:21.84404+02	ganymede	3731	rpd[2252]:		EVENT UpDown ge-1/3/0.0 index 76 1.0.0.1/30 -> 1.0.0.3 <Broadcast Multicast Localup>		10
1318362	2003-11-19 18:02:20+02	2003-11-19 18:02:21.024416+02	ganymede	3731	rpd[2252]:		EVENT UpDown sp-0/2/0.0 index 71 10.10.10.1 -> 10.10.10.2 <Broadcast PointToPoint Multicast Localup>		10
1348379	2003-11-20 20:43:15+02	2003-11-20 20:25:49.504431+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348381	2003-11-20 20:43:16+02	2003-11-20 20:25:50.525539+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348380	2003-11-20 20:43:16+02	2003-11-20 20:25:50.505221+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348384	2003-11-20 20:43:17+02	2003-11-20 20:25:51.525313+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348382	2003-11-20 20:43:17+02	2003-11-20 20:25:51.505655+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348383	2003-11-20 20:43:17+02	2003-11-20 20:25:51.521525+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348386	2003-11-20 20:43:18+02	2003-11-20 20:25:52.518217+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348387	2003-11-20 20:43:18+02	2003-11-20 20:25:52.522009+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348385	2003-11-20 20:43:18+02	2003-11-20 20:25:52.50566+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348389	2003-11-20 20:43:19+02	2003-11-20 20:25:53.527284+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348390	2003-11-20 20:43:19+02	2003-11-20 20:25:53.531313+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348388	2003-11-20 20:43:19+02	2003-11-20 20:25:53.506614+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348392	2003-11-20 20:43:20+02	2003-11-20 20:25:54.52304+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348391	2003-11-20 20:43:20+02	2003-11-20 20:25:54.511526+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348396	2003-11-20 20:43:21+02	2003-11-20 20:26:01.635445+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1318360	2003-11-19 18:02:20+02	2003-11-19 18:02:21.013147+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> sp-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1318363	2003-11-19 18:02:20+02	2003-11-19 18:02:21.028388+02	ganymede	3731	feb		Monitor IPC 0.3: passing loopback (Disable) to MIPS. 		10
1318359	2003-11-19 18:02:20+02	2003-11-19 18:02:21.009341+02	ganymede	3731	/kernel:	sp-0/2/0:	ifl config: op: 3; sub: 16383; flags: 0x8010, curr: 0x8010.		10
1318361	2003-11-19 18:02:20+02	2003-11-19 18:02:21.016895+02	ganymede	3731	rpd[2252]:		EVENT UpDown sp-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1318414	2003-11-19 18:02:20+02	2003-11-19 18:02:21.83866+02	ganymede	3731	rpd[2252]:		EVENT <UpDown> ge-1/3/0.0 index 76 <Broadcast Multicast> address #0 0.90.69.a0.14.db		10
1318328	2003-11-19 18:02:20+02	2003-11-19 18:02:20.45999+02	ganymede	3731	craftd[2224]:	craftd_user_conn_shutdown:	socket 7, errno = 0 		10
1318343	2003-11-19 18:02:20+02	2003-11-19 18:02:20.731322+02	ganymede	3731	feb		Monitor PIC 0.3: ++Monitor: delete all of AS tree 		10
1318401	2003-11-19 18:02:20+02	2003-11-19 18:02:21.639778+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 143 <Broadcast Multicast> address #0 0.90.69.a0.14.80		10
1318392	2003-11-19 18:02:20+02	2003-11-19 18:02:21.490602+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 137 <Broadcast Multicast>		10
1318365	2003-11-19 18:02:20+02	2003-11-19 18:02:21.035925+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 131 <Broadcast Multicast>		10
1318400	2003-11-19 18:02:20+02	2003-11-19 18:02:21.635948+02	ganymede	3731	rpd[2252]:		EVENT <Delete> index 142 <Broadcast Multicast> address #0 0.90.69.a0.14.7f		10
1318384	2003-11-19 18:02:20+02	2003-11-19 18:02:21.348251+02	ganymede	3731	rpd[2252]:		EVENT Delete sp-0/2/0.0 index 71 10.10.10.1 -> 10.10.10.2 <Broadcast PointToPoint Multicast>		10
1318367	2003-11-19 18:02:20+02	2003-11-19 18:02:21.149944+02	ganymede	3731	fsad[2244]:	FSAD_TERMINATING_SIGNAL:	Received terminating signal Terminated; preparing to clean up		10
1318368	2003-11-19 18:02:20+02	2003-11-19 18:02:21.173428+02	ganymede	3731	chassisd[2222]:	CHASSISD_IFDEV_DETACH_FPC:	ifdev_detach(1) 		10
1318370	2003-11-19 18:02:20+02	2003-11-19 18:02:21.180986+02	ganymede	3731	rpd[2252]:		EVENT Delete so-0/1/0.0 index 70 <Broadcast PointToPoint Multicast>		10
1318417	2003-11-19 18:02:20+02	2003-11-19 18:02:21.960016+02	ganymede	3731	rpd[2252]:		EVENT UpDown ge-1/3/0.0 index 76 <Broadcast Multicast>		10
1318369	2003-11-19 18:02:20+02	2003-11-19 18:02:21.177158+02	ganymede	3731	rpd[2252]:		EVENT <UpDown MTU> index 137 <Broadcast Multicast>		10
1318422	2003-11-19 18:02:21+02	2003-11-19 18:02:21.982621+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 95 traps in queue 		2
1318427	2003-11-19 18:02:21+02	2003-11-19 18:02:22.109964+02	r201	3732	rpd[4418]:	RPD_LDP_SESSIONDOWN:	LDP session 10.100.254.20 is down, reason: all adjacencies down		10
1318438	2003-11-19 18:02:21+02	2003-11-19 18:02:22.335494+02	atlas	3730	mgd[4589]:	UI_CHILD_STATUS:	Cleanup child '/sbin/shutdown', PID 4851, status 0		1
1318421	2003-11-19 18:02:21+02	2003-11-19 18:02:21.976813+02	r201	3732	rpd[4418]:		EVENT <UpDown> ge-1/3/0.0 index 69 <Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1318426	2003-11-19 18:02:21+02	2003-11-19 18:02:21.998325+02	r201	3732	rpd[4418]:	RPD_LDP_NBRDOWN:	LDP neighbor 1.0.0.1 (ge-1/3/0.0) is down		10
1318423	2003-11-19 18:02:21+02	2003-11-19 18:02:21.986684+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 96 traps in queue 		2
1318430	2003-11-19 18:02:21+02	2003-11-19 18:02:22.123854+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 <Broadcast Multicast>		10
1318425	2003-11-19 18:02:21+02	2003-11-19 18:02:21.994399+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 1.0.0.2/30 -> 1.0.0.3 <Broadcast Multicast Localup>		10
1318424	2003-11-19 18:02:21+02	2003-11-19 18:02:21.990596+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_DOWN:	ifIndex 22, ifAdminStatus up(1), ifOperStatus down(2), ifName ge-1/3/0		10
1318429	2003-11-19 18:02:21+02	2003-11-19 18:02:22.120018+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 98 traps in queue 		2
1318428	2003-11-19 18:02:21+02	2003-11-19 18:02:22.115697+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 97 traps in queue 		2
1318437	2003-11-19 18:02:21+02	2003-11-19 18:02:22.329966+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 54 traps in queue 		2
1318432	2003-11-19 18:02:21+02	2003-11-19 18:02:22.205458+02	r201	3732	rpd[4418]:		EVENT UpDown ge-1/3/0.0 index 69 <Broadcast Multicast>		10
1318431	2003-11-19 18:02:21+02	2003-11-19 18:02:22.201536+02	r201	3732	rpd[4418]:	RPD_ISIS_ADJDOWN:	IS-IS lost L2 adjacency to ganymede on ge-1/3/0.0, reason: Interface Down		10
1318435	2003-11-19 18:02:21+02	2003-11-19 18:02:22.216877+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 100 traps in queue 		2
1318436	2003-11-19 18:02:21+02	2003-11-19 18:02:22.222644+02	atlas	3730	snmpd[4411]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 53 traps in queue 		2
1318433	2003-11-19 18:02:21+02	2003-11-19 18:02:22.209261+02	r201	3732	rpd[4418]:		EVENT <UpDown> index 136 <Broadcast Multicast> address #0 0.90.69.94.b8.db		10
1318434	2003-11-19 18:02:21+02	2003-11-19 18:02:22.213172+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 99 traps in queue 		2
1318440	2003-11-19 18:02:22+02	2003-11-19 18:02:22.687775+02	atlas	3730	/kernel:	e1-0/0/0:	received CCC status, setting CCC-Down		10
1318441	2003-11-19 18:02:22+02	2003-11-19 18:02:22.709646+02	atlas	3730	rpd[4413]:	RPD_LAYER2_VC_DOWN:	 Layer-2 VC (VPN : x25_cqt, local-site : 1, remote-site : 2) state changed from UP to DELETED		10
1318446	2003-11-19 18:02:24+02	2003-11-19 18:02:24.518165+02	ganymede	3731	/kernel:	fxp1:	link media DOWN 10Mb / half-duplex		10
1318466	2003-11-19 18:02:24+02	2003-11-19 18:02:24.902606+02	ganymede	3731	init:		remote-hello (PID 2238) exited with status=0 Normal Exit		10
1318459	2003-11-19 18:02:24+02	2003-11-19 18:02:24.763077+02	ganymede	3731	init:		adaptive-services (PID 2245) exited with status=0 Normal Exit		10
1318478	2003-11-19 18:02:24+02	2003-11-19 18:02:25.089562+02	ganymede	3731	init:		management (PID 2226) exited with status=0 Normal Exit		10
1318447	2003-11-19 18:02:24+02	2003-11-19 18:02:24.526171+02	ganymede	3731	/kernel:		rdp retransmit error: Network is down (50) src 1:1020 dest 2:26625		500
1318456	2003-11-19 18:02:24+02	2003-11-19 18:02:24.74999+02	ganymede	3731	init:		pgm (PID 2248) exited with status=0 Normal Exit		10
1318465	2003-11-19 18:02:24+02	2003-11-19 18:02:24.790823+02	ganymede	3731	init:		link-management (PID 2239) exited with status=0 Normal Exit		10
1338257	2003-11-20 16:03:12+02	2003-11-20 15:45:45.358699+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338258	2003-11-20 16:03:12+02	2003-11-20 15:45:45.362493+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338256	2003-11-20 16:03:12+02	2003-11-20 15:45:45.345875+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338259	2003-11-20 16:03:13+02	2003-11-20 15:45:46.345968+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338260	2003-11-20 16:03:13+02	2003-11-20 15:45:46.354406+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338261	2003-11-20 16:03:13+02	2003-11-20 15:45:46.437237+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338264	2003-11-20 16:03:14+02	2003-11-20 15:45:47.346628+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338265	2003-11-20 16:03:14+02	2003-11-20 15:45:47.368859+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338267	2003-11-20 16:03:15+02	2003-11-20 15:45:54.335127+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1318455	2003-11-19 18:02:24+02	2003-11-19 18:02:24.574427+02	ganymede	3731	init:		mib-process (PID 2251) exited with status=0 Normal Exit		10
1318451	2003-11-19 18:02:24+02	2003-11-19 18:02:24.548018+02	ganymede	3731	init:		ntp (PID 2433) exited with status=0 Normal Exit		10
1318473	2003-11-19 18:02:24+02	2003-11-19 18:02:24.955504+02	ganymede	3731	init:		sampling (PID 2231) exited with status=0 Normal Exit		10
1318467	2003-11-19 18:02:24+02	2003-11-19 18:02:24.909765+02	ganymede	3731	init:		helper (PID 2237) exited with status=0 Normal Exit		10
1318468	2003-11-19 18:02:24+02	2003-11-19 18:02:24.915002+02	ganymede	3731	init:		ipsec-key-management (PID 2236) exited with status=0 Normal Exit		10
1318469	2003-11-19 18:02:24+02	2003-11-19 18:02:24.921302+02	ganymede	3731	init:		network-access (PID 2235) exited with status=0 Normal Exit		10
1318454	2003-11-19 18:02:24+02	2003-11-19 18:02:24.570672+02	ganymede	3731	init:		sonet-aps (PID 2253) exited with status=0 Normal Exit		10
1318470	2003-11-19 18:02:24+02	2003-11-19 18:02:24.928765+02	ganymede	3731	init:		class-of-service (PID 2234) exited with status=0 Normal Exit		10
1318453	2003-11-19 18:02:24+02	2003-11-19 18:02:24.56318+02	ganymede	3731	init:		vrrp (PID 2254) exited with status=0 Normal Exit		10
1318472	2003-11-19 18:02:24+02	2003-11-19 18:02:24.948879+02	ganymede	3731	init:		ilmi (PID 2232) exited with status=0 Normal Exit		10
1318452	2003-11-19 18:02:24+02	2003-11-19 18:02:24.556873+02	ganymede	3731	init:		interface-control (PID 2258) exited with status=0 Normal Exit		10
1318475	2003-11-19 18:02:24+02	2003-11-19 18:02:24.97077+02	ganymede	3731	init:		sntp (PID 2229) exited with status=0 Normal Exit		10
1318471	2003-11-19 18:02:24+02	2003-11-19 18:02:24.94203+02	ganymede	3731	init:		remote-operations (PID 2233) exited with status=0 Normal Exit		10
1318479	2003-11-19 18:02:24+02	2003-11-19 18:02:25.093694+02	ganymede	3731	init:		craft-control (PID 2224) exited with status=0 Normal Exit		10
1318481	2003-11-19 18:02:24+02	2003-11-19 18:02:25.10237+02	ganymede	3731	init:		chassis-control (PID 2222) exited with status=0 Normal Exit		10
1318458	2003-11-19 18:02:24+02	2003-11-19 18:02:24.759318+02	ganymede	3731	init:		ecc-error-logging (PID 2246) exited with status=0 Normal Exit		500
1318480	2003-11-19 18:02:24+02	2003-11-19 18:02:25.097418+02	ganymede	3731	init:		alarm-control (PID 2223) exited with status=0 Normal Exit		10
1318483	2003-11-19 18:02:24+02	2003-11-19 18:02:25.110176+02	ganymede	3731	init:		watchdog (PID 2219) exited with status=0 Normal Exit		10
1318482	2003-11-19 18:02:24+02	2003-11-19 18:02:25.106338+02	ganymede	3731	init:		tnp-process (PID 2220) exited with status=0 Normal Exit		10
1318474	2003-11-19 18:02:24+02	2003-11-19 18:02:24.963621+02	ganymede	3731	init:		pfe (PID 2230) exited with status=0 Normal Exit		10
1318457	2003-11-19 18:02:24+02	2003-11-19 18:02:24.755456+02	ganymede	3731	init:		neighbor-liveness (PID 2247) exited with status=0 Normal Exit		10
1318476	2003-11-19 18:02:24+02	2003-11-19 18:02:25.080069+02	ganymede	3731	init:		inet-process (PID 2228) exited with status=0 Normal Exit		10
1318477	2003-11-19 18:02:24+02	2003-11-19 18:02:25.08567+02	ganymede	3731	init:		snmp (PID 2227) exited with status=0 Normal Exit		10
1318464	2003-11-19 18:02:24+02	2003-11-19 18:02:24.785253+02	ganymede	3731	init:		disk-monitoring (PID 2240) exited with status=0 Normal Exit		10
1318462	2003-11-19 18:02:24+02	2003-11-19 18:02:24.774255+02	ganymede	3731	init:		internal-routing-service (PID 2242) exited with status=0 Normal Exit		10
1318449	2003-11-19 18:02:24+02	2003-11-19 18:02:24.538702+02	ganymede	3731	/kernel:		rdp retransmit error: Network is down (50) src 1:1020 dest 2:26625		500
1318461	2003-11-19 18:02:24+02	2003-11-19 18:02:24.770523+02	ganymede	3731	init:		routing-socket-proxy (PID 2243) exited with status=0 Normal Exit		10
1318463	2003-11-19 18:02:24+02	2003-11-19 18:02:24.777978+02	ganymede	3731	init:		firewall (PID 2241) exited with status=0 Normal Exit		10
1318460	2003-11-19 18:02:24+02	2003-11-19 18:02:24.766799+02	ganymede	3731	init:		pic-services-logging (PID 2244) exited with status=0 Normal Exit		10
1318518	2003-11-19 18:02:26+02	2003-11-19 18:02:27.248459+02	atlas	3730	rpd[4413]:		EVENT <Delete> so-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1318508	2003-11-19 18:02:26+02	2003-11-19 18:02:27.090977+02	atlas	3730	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 2, af 2, run-len 0		10
1318527	2003-11-19 18:02:26+02	2003-11-19 18:02:27.45333+02	atlas	3730	rpd[4413]:		EVENT <Delete UpDown> e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1318492	2003-11-19 18:02:26+02	2003-11-19 18:02:26.763339+02	atlas	3730	shutdown:		reboot by root: 		10
1318520	2003-11-19 18:02:26+02	2003-11-19 18:02:27.257161+02	atlas	3730	rpd[4413]:		EVENT Delete ge-0/3/0.0 index 72 <Broadcast Multicast>		10
1318500	2003-11-19 18:02:26+02	2003-11-19 18:02:26.939+02	atlas	3730	/kernel:		if_msg_ifl_family_delete(71) family 7		10
1318517	2003-11-19 18:02:26+02	2003-11-19 18:02:27.244732+02	atlas	3730	rpd[4413]:		EVENT Delete so-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1318499	2003-11-19 18:02:26+02	2003-11-19 18:02:26.931479+02	atlas	3730	rpd[4413]:		EVENT <UpDown> ge-0/3/0.0 index 72 <Broadcast Multicast> address #0 0.90.69.9e.30.5d		10
1318507	2003-11-19 18:02:26+02	2003-11-19 18:02:27.08705+02	atlas	3730	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 1, af 2, run-len 0		10
1318530	2003-11-19 18:02:26+02	2003-11-19 18:02:27.464514+02	atlas	3730	rpd[4413]:		EVENT <Delete> index 136 <Broadcast Multicast>		10
1318529	2003-11-19 18:02:26+02	2003-11-19 18:02:27.460803+02	atlas	3730	rpd[4413]:		EVENT <Delete UpDown> index 135 <Broadcast Multicast>		10
1318534	2003-11-19 18:02:26+02	2003-11-19 18:02:27.585632+02	atlas	3730	rpd[4413]:	RPD_SNMP_SARECV:	snmp_epi_recv: error from sam_recv: 0		500
1318528	2003-11-19 18:02:26+02	2003-11-19 18:02:27.457067+02	atlas	3730	eccd[4436]:		SIGTERM received, exiting 		10
1318533	2003-11-19 18:02:26+02	2003-11-19 18:02:27.580059+02	atlas	3730	xntpd[4813]:		ntpd exiting on signal 15		1
1318511	2003-11-19 18:02:26+02	2003-11-19 18:02:27.111174+02	atlas	3730	rpd[4413]:	RPD_ISIS_ADJDOWN:	IS-IS lost L2 adjacency to r201 on ge-0/3/0.0, reason: Interface Down		10
1318531	2003-11-19 18:02:26+02	2003-11-19 18:02:27.468587+02	atlas	3730	rpd[4413]:		EVENT <Delete> index 137 <Broadcast Multicast>		10
1355353	2003-11-21 18:53:44+02	2003-11-21 18:36:25.708932+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355356	2003-11-21 18:53:45+02	2003-11-21 18:36:26.72774+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355355	2003-11-21 18:53:45+02	2003-11-21 18:36:26.710196+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355358	2003-11-21 18:53:46+02	2003-11-21 18:36:27.760222+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355357	2003-11-21 18:53:46+02	2003-11-21 18:36:27.710195+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1355359	2003-11-21 18:53:46+02	2003-11-21 18:36:27.765152+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1318498	2003-11-19 18:02:26+02	2003-11-19 18:02:26.927458+02	atlas	3730	/kernel:		if_msg_ifl_family_delete(71) family 2		10
1318504	2003-11-19 18:02:26+02	2003-11-19 18:02:27.075496+02	atlas	3730	/kernel:		if_msg_ifl_family_delete(72) family 2		10
1318519	2003-11-19 18:02:26+02	2003-11-19 18:02:27.253398+02	atlas	3730	rpd[4413]:		EVENT <Delete> index 133 <Broadcast Multicast>		10
1318509	2003-11-19 18:02:26+02	2003-11-19 18:02:27.102141+02	atlas	3730	/kernel:		if_msg_ifl_family_delete(72) family 33		10
1318532	2003-11-19 18:02:26+02	2003-11-19 18:02:27.472366+02	atlas	3730	rpd[4413]:		EVENT <Delete> index 138 <Broadcast Multicast>		10
1318488	2003-11-19 18:02:26+02	2003-11-19 18:02:26.570204+02	ganymede	3731	/kernel:	peer_inputs:	soreceive() error 64		500
1318503	2003-11-19 18:02:26+02	2003-11-19 18:02:27.070078+02	atlas	3730	/kernel:		if_msg_ifl_addr_delete(72) local_prefix 0xc672680e dest_prefix 0xc6726822 dest_plen 30 flags 0x3		10
1318491	2003-11-19 18:02:26+02	2003-11-19 18:02:26.684255+02	ganymede	3731	pccardd[2070]:		pccardd terminated: signal 15 received		10
1318536	2003-11-19 18:02:26+02	2003-11-19 18:02:27.597724+02	atlas	3730	rpd[4413]:	RPD_SIGNAL_TERMINATE:	first termination signal received		10
1318490	2003-11-19 18:02:26+02	2003-11-19 18:02:26.57946+02	ganymede	3731	rpd[2252]:	RPD_SIGNAL_TERMINATE:	second termination signal received		10
1318510	2003-11-19 18:02:26+02	2003-11-19 18:02:27.105856+02	atlas	3730	rpd[4413]:		EVENT UpDown ge-0/3/0.0 index 72 <Broadcast Multicast>		10
1318502	2003-11-19 18:02:26+02	2003-11-19 18:02:26.964366+02	atlas	3730	rpd[4413]:	RPD_LDP_NBRDOWN:	LDP neighbor 1.1.0.1 (ge-0/3/0.0) is down		10
1318489	2003-11-19 18:02:26+02	2003-11-19 18:02:26.575542+02	ganymede	3731	/kernel:	pfe_listener_disconnect:	conn dropped: listener idx=0, tnpaddr=2		10
1318487	2003-11-19 18:02:26+02	2003-11-19 18:02:26.562255+02	ganymede	3731	/kernel:		rdp keepalive expired, connection dropped - src 1:1020 dest 2:26625		10
1318537	2003-11-19 18:02:26+02	2003-11-19 18:02:27.601534+02	atlas	3730	rpd[4413]:	RPD_EXIT:	Exit rpd[4413] version 6.1R1.4 built by builder on 2003-10-09 20:28:45 UTC, caller 80a0af6		10
1318501	2003-11-19 18:02:26+02	2003-11-19 18:02:26.960558+02	atlas	3730	rpd[4413]:		EVENT UpDown ge-0/3/0.0 index 72 1.1.0.2/30 -> 1.1.0.3 <Broadcast Multicast Localup>		10
1318516	2003-11-19 18:02:26+02	2003-11-19 18:02:27.234488+02	atlas	3730	rpd[4413]:		EVENT Delete so-0/2/0.0 index 71 <Broadcast PointToPoint Multicast>		10
1318512	2003-11-19 18:02:26+02	2003-11-19 18:02:27.114913+02	atlas	3730	chassisd[4405]:	CHASSISD_IFDEV_DETACH_ALL_PSEUDO:	ifdev_detach(pseudo devices: all) 		10
1318526	2003-11-19 18:02:26+02	2003-11-19 18:02:27.44784+02	atlas	3730	rpd[4413]:		EVENT Delete UpDown e1-0/0/0.0 index 69 <Broadcast PointToPoint Multicast>		10
1318497	2003-11-19 18:02:26+02	2003-11-19 18:02:26.902533+02	atlas	3730	rpd[4413]:		EVENT Delete so-0/2/0.0 index 71 192.2.1.1 -> 192.2.1.1 <Broadcast PointToPoint Multicast>		10
1318506	2003-11-19 18:02:26+02	2003-11-19 18:02:27.083128+02	atlas	3730	/kernel:		if_msg_ifl_family_delete(72) family 7		10
1318522	2003-11-19 18:02:26+02	2003-11-19 18:02:27.268948+02	atlas	3730	rpd[4413]:		EVENT Delete ge-0/3/0.0 index 72 1.1.0.2/30 -> 1.1.0.3 <Broadcast Multicast>		10
1318513	2003-11-19 18:02:26+02	2003-11-19 18:02:27.22007+02	atlas	3730	/kernel:		if_msg_ifl_family_delete(69) family 36		10
1318525	2003-11-19 18:02:26+02	2003-11-19 18:02:27.443842+02	atlas	3730	fsad[4434]:	FSAD_TERMINATING_SIGNAL:	Received terminating signal Terminated; preparing to clean up		10
1318496	2003-11-19 18:02:26+02	2003-11-19 18:02:26.896555+02	atlas	3730	/kernel:		if_msg_ifl_addr_delete(66) local_prefix 0xc672660e dest_prefix 0 dest_plen 0 flags 0x2		10
1318505	2003-11-19 18:02:26+02	2003-11-19 18:02:27.079376+02	atlas	3730	rpd[4413]:	RPD_LDP_SESSIONDOWN:	LDP session 10.100.254.23 is down, reason: all adjacencies down		10
1318521	2003-11-19 18:02:26+02	2003-11-19 18:02:27.263084+02	atlas	3730	rpd[4413]:		EVENT Delete ge-0/3/0.0 index 72 <Broadcast Multicast>		10
1318494	2003-11-19 18:02:26+02	2003-11-19 18:02:26.885093+02	atlas	3730	craftd[4407]:	craftd_user_conn_shutdown:	socket 7, errno = 0 		10
1318515	2003-11-19 18:02:26+02	2003-11-19 18:02:27.23048+02	atlas	3730	rpd[4413]:		EVENT <UpDown> index 134 <Broadcast Multicast> address #0 0.90.69.9e.30.5d		10
1318493	2003-11-19 18:02:26+02	2003-11-19 18:02:26.880632+02	atlas	3730	chassisd[4405]:	CHASSISD_IFDEV_DETACH_FPC:	ifdev_detach(0) 		10
1318495	2003-11-19 18:02:26+02	2003-11-19 18:02:26.890273+02	atlas	3730	/kernel:		if_msg_ifl_addr_delete(71) local_prefix 0xc68acf8e dest_prefix 0xc68acfa2 dest_plen 30 flags 0x3		10
1318524	2003-11-19 18:02:26+02	2003-11-19 18:02:27.387673+02	atlas	3730	rpd[4413]:		EVENT <Delete> index 134 <Broadcast Multicast> address #0 0.90.69.9e.30.5d		10
1318514	2003-11-19 18:02:26+02	2003-11-19 18:02:27.225564+02	atlas	3730	rpd[4413]:		EVENT UpDown ge-0/3/0.0 index 72 <Broadcast Multicast>		10
1318523	2003-11-19 18:02:26+02	2003-11-19 18:02:27.381965+02	atlas	3730	rpd[4413]:		EVENT <Delete> ge-0/3/0.0 index 72 <Broadcast Multicast> address #0 0.90.69.9e.30.5d		10
1318552	2003-11-19 18:02:27+02	2003-11-19 18:02:27.812986+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 106 traps in queue 		2
1318545	2003-11-19 18:02:27+02	2003-11-19 18:02:27.783666+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 103 traps in queue 		2
1318542	2003-11-19 18:02:27+02	2003-11-19 18:02:27.623025+02	r201	3732	rpd[4418]:		EVENT UpDown ge-0/3/0.0 index 68 1.1.0.1/30 -> 1.1.0.3 <Broadcast Multicast Localup>		10
1318543	2003-11-19 18:02:27+02	2003-11-19 18:02:27.730082+02	r201	3732	rpd[4418]:	RPD_LDP_NBRDOWN:	LDP neighbor 1.1.0.2 (ge-0/3/0.0) is down		10
1318541	2003-11-19 18:02:27+02	2003-11-19 18:02:27.617095+02	r201	3732	mib2d[4417]:	SNMP_TRAP_LINK_DOWN:	ifIndex 21, ifAdminStatus up(1), ifOperStatus down(2), ifName ge-0/3/0		10
1318540	2003-11-19 18:02:27+02	2003-11-19 18:02:27.613378+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 102 traps in queue 		2
1318538	2003-11-19 18:02:27+02	2003-11-19 18:02:27.605809+02	r201	3732	rpd[4418]:		EVENT <UpDown> ge-0/3/0.0 index 68 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1318544	2003-11-19 18:02:27+02	2003-11-19 18:02:27.735568+02	r201	3732	rpd[4418]:	RPD_LDP_SESSIONDOWN:	LDP session 10.100.254.21 is down, reason: all adjacencies down		10
1318551	2003-11-19 18:02:27+02	2003-11-19 18:02:27.807193+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 105 traps in queue 		2
1318547	2003-11-19 18:02:27+02	2003-11-19 18:02:27.791535+02	r201	3732	rpd[4418]:		EVENT UpDown ge-0/3/0.0 index 68 <Broadcast Multicast>		10
1318546	2003-11-19 18:02:27+02	2003-11-19 18:02:27.787638+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 104 traps in queue 		2
1318550	2003-11-19 18:02:27+02	2003-11-19 18:02:27.803477+02	r201	3732	rpd[4418]:		EVENT <UpDown> index 135 <Broadcast Multicast> address #0 0.90.69.94.b8.5d		10
1318549	2003-11-19 18:02:27+02	2003-11-19 18:02:27.799726+02	r201	3732	rpd[4418]:		EVENT UpDown ge-0/3/0.0 index 68 <Broadcast Multicast>		10
1318548	2003-11-19 18:02:27+02	2003-11-19 18:02:27.79582+02	r201	3732	rpd[4418]:	RPD_ISIS_ADJDOWN:	IS-IS lost L2 adjacency to atlas on ge-0/3/0.0, reason: Interface Down		10
1318539	2003-11-19 18:02:27+02	2003-11-19 18:02:27.609657+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to destination queue, 101 traps in queue 		2
1318587	2003-11-19 18:02:30+02	2003-11-19 18:02:31.354339+02	atlas	3730	init:		inet-process (PID 4414) exited with status=0 Normal Exit		10
1318580	2003-11-19 18:02:30+02	2003-11-19 18:02:31.213713+02	atlas	3730	init:		remote-operations (PID 4421) exited with status=0 Normal Exit		10
1318592	2003-11-19 18:02:30+02	2003-11-19 18:02:31.52113+02	atlas	3730	init:		craft-control (PID 4407) exited with status=0 Normal Exit		10
1318575	2003-11-19 18:02:30+02	2003-11-19 18:02:31.194813+02	atlas	3730	init:		remote-hello (PID 4426) exited with status=0 Normal Exit		10
1318574	2003-11-19 18:02:30+02	2003-11-19 18:02:31.190736+02	atlas	3730	init:		link-management (PID 4427) exited with status=0 Normal Exit		10
1318586	2003-11-19 18:02:30+02	2003-11-19 18:02:31.350271+02	atlas	3730	init:		sonet-aps (PID 4415) exited with status=0 Normal Exit		10
1318573	2003-11-19 18:02:30+02	2003-11-19 18:02:31.185832+02	atlas	3730	init:		disk-monitoring (PID 4429) exited with status=0 Normal Exit		10
1318582	2003-11-19 18:02:30+02	2003-11-19 18:02:31.331727+02	atlas	3730	init:		sampling (PID 4419) exited with status=0 Normal Exit		10
1318579	2003-11-19 18:02:30+02	2003-11-19 18:02:31.210008+02	atlas	3730	init:		class-of-service (PID 4422) exited with status=0 Normal Exit		10
1318589	2003-11-19 18:02:30+02	2003-11-19 18:02:31.405912+02	atlas	3730	init:		mib-process (PID 4412) exited with status=0 Normal Exit		10
1318581	2003-11-19 18:02:30+02	2003-11-19 18:02:31.217428+02	atlas	3730	init:		ilmi (PID 4420) exited with status=0 Normal Exit		10
1318591	2003-11-19 18:02:30+02	2003-11-19 18:02:31.414701+02	atlas	3730	init:		management (PID 4409) exited with status=0 Normal Exit		10
1318559	2003-11-19 18:02:30+02	2003-11-19 18:02:30.919062+02	atlas	3730	/kernel:		rdp retransmit error: Network is down (50) src 1:1020 dest 2:52225		500
1318554	2003-11-19 18:02:30+02	2003-11-19 18:02:30.391446+02	ganymede	3731	/kernel:	TNP:	version is changing to 2		10
1318588	2003-11-19 18:02:30+02	2003-11-19 18:02:31.40215+02	atlas	3730	init:		routing (PID 4413) exited with status=0 Normal Exit		10
1318584	2003-11-19 18:02:30+02	2003-11-19 18:02:31.342451+02	atlas	3730	init:		sntp (PID 4417) exited with status=0 Normal Exit		10
1318558	2003-11-19 18:02:30+02	2003-11-19 18:02:30.89904+02	atlas	3730	/kernel:	fxp1:	link media DOWN 10Mb / half-duplex		10
1318590	2003-11-19 18:02:30+02	2003-11-19 18:02:31.410842+02	atlas	3730	init:		snmp (PID 4411) exited with status=0 Normal Exit		10
1318556	2003-11-19 18:02:30+02	2003-11-19 18:02:30.435039+02	ganymede	3731	init:		routing (PID 2252) exited with status=0 Normal Exit		10
1318557	2003-11-19 18:02:30+02	2003-11-19 18:02:30.440753+02	ganymede	3731	syslogd:		exiting on signal 14		10
1318555	2003-11-19 18:02:30+02	2003-11-19 18:02:30.43128+02	ganymede	3731	rpd[2252]:	RPD_EXIT:	Exit rpd[2252] version 6.1R1.4 built by builder on 2003-10-09 20:28:45 UTC, caller 80a16c6		10
1318578	2003-11-19 18:02:30+02	2003-11-19 18:02:31.20623+02	atlas	3730	init:		network-access (PID 4423) exited with status=0 Normal Exit		10
1318594	2003-11-19 18:02:30+02	2003-11-19 18:02:31.53059+02	atlas	3730	init:		chassis-control (PID 4405) exited with status=0 Normal Exit		10
1318572	2003-11-19 18:02:30+02	2003-11-19 18:02:31.180129+02	atlas	3730	init:		firewall (PID 4431) exited with status=0 Normal Exit		10
1318596	2003-11-19 18:02:30+02	2003-11-19 18:02:31.538037+02	atlas	3730	init:		watchdog (PID 4402) exited with status=0 Normal Exit		10
1318561	2003-11-19 18:02:30+02	2003-11-19 18:02:30.929676+02	atlas	3730	/kernel:		rdp retransmit error: Network is down (50) src 1:1020 dest 2:52225		500
1318585	2003-11-19 18:02:30+02	2003-11-19 18:02:31.346442+02	atlas	3730	init:		vrrp (PID 4416) exited with status=0 Normal Exit		10
1318564	2003-11-19 18:02:30+02	2003-11-19 18:02:31.049678+02	atlas	3730	init:		interface-control (PID 4442) exited with status=0 Normal Exit		10
1318593	2003-11-19 18:02:30+02	2003-11-19 18:02:31.526775+02	atlas	3730	init:		alarm-control (PID 4406) exited with status=0 Normal Exit		10
1318563	2003-11-19 18:02:30+02	2003-11-19 18:02:31.045903+02	atlas	3730	init:		ntp (PID 4813) exited with status=0 Normal Exit		10
1318553	2003-11-19 18:02:30+02	2003-11-19 18:02:30.382724+02	ganymede	3731	/kernel:	TNP:	deleting neighbor 2 from interface fxp1.		10
1318583	2003-11-19 18:02:30+02	2003-11-19 18:02:31.337572+02	atlas	3730	init:		pfe (PID 4418) exited with status=0 Normal Exit		10
1318595	2003-11-19 18:02:30+02	2003-11-19 18:02:31.534306+02	atlas	3730	init:		tnp-process (PID 4403) exited with status=0 Normal Exit		10
1318566	2003-11-19 18:02:30+02	2003-11-19 18:02:31.05726+02	atlas	3730	init:		neighbor-liveness (PID 4437) exited with status=0 Normal Exit		10
1318565	2003-11-19 18:02:30+02	2003-11-19 18:02:31.053479+02	atlas	3730	init:		pgm (PID 4438) exited with status=0 Normal Exit		10
1318577	2003-11-19 18:02:30+02	2003-11-19 18:02:31.202506+02	atlas	3730	init:		ipsec-key-management (PID 4424) exited with status=0 Normal Exit		10
1318576	2003-11-19 18:02:30+02	2003-11-19 18:02:31.198589+02	atlas	3730	init:		helper (PID 4425) exited with status=0 Normal Exit		10
1318570	2003-11-19 18:02:30+02	2003-11-19 18:02:31.072381+02	atlas	3730	init:		routing-socket-proxy (PID 4433) exited with status=0 Normal Exit		10
1318568	2003-11-19 18:02:30+02	2003-11-19 18:02:31.0647+02	atlas	3730	init:		adaptive-services (PID 4435) exited with status=0 Normal Exit		10
1318567	2003-11-19 18:02:30+02	2003-11-19 18:02:31.060987+02	atlas	3730	init:		ecc-error-logging (PID 4436) exited with status=0 Normal Exit		500
1318571	2003-11-19 18:02:30+02	2003-11-19 18:02:31.076097+02	atlas	3730	init:		internal-routing-service (PID 4432) exited with status=0 Normal Exit		10
1318569	2003-11-19 18:02:30+02	2003-11-19 18:02:31.068477+02	atlas	3730	init:		pic-services-logging (PID 4434) exited with status=0 Normal Exit		10
1318601	2003-11-19 18:02:32+02	2003-11-19 18:02:33.120241+02	atlas	3730	/kernel:	pfe_listener_disconnect:	conn dropped: listener idx=0, tnpaddr=2		10
1318600	2003-11-19 18:02:32+02	2003-11-19 18:02:32.994067+02	atlas	3730	/kernel:	peer_inputs:	soreceive() error 64		500
1318603	2003-11-19 18:02:32+02	2003-11-19 18:02:33.132056+02	atlas	3730	/kernel:	TNP:	version is changing to 2		10
1318604	2003-11-19 18:02:32+02	2003-11-19 18:02:33.137803+02	atlas	3730	pccardd[4252]:		pccardd terminated: signal 15 received		10
1318602	2003-11-19 18:02:32+02	2003-11-19 18:02:33.12821+02	atlas	3730	/kernel:	TNP:	deleting neighbor 2 from interface fxp1.		10
1318597	2003-11-19 18:02:32+02	2003-11-19 18:02:32.961728+02	atlas	3730	/kernel:		rdp retransmit error: Network is down (50) src 1:1020 dest 2:52225		500
1318599	2003-11-19 18:02:32+02	2003-11-19 18:02:32.988077+02	atlas	3730	/kernel:		rdp keepalive expired, connection dropped - src 1:1020 dest 2:52225		10
1318608	2003-11-19 18:02:36+02	2003-11-19 18:02:36.842813+02	atlas	3730	syslogd:		exiting on signal 14		10
1315741	2003-11-19 18:02:40+02	2003-11-19 17:45:05.731829+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315748	2003-11-19 18:02:41+02	2003-11-19 17:45:06.73293+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315749	2003-11-19 18:02:41+02	2003-11-19 17:45:06.737317+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315751	2003-11-19 18:02:42+02	2003-11-19 17:45:07.748021+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315752	2003-11-19 18:02:42+02	2003-11-19 17:45:07.751845+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315750	2003-11-19 18:02:42+02	2003-11-19 17:45:07.733164+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315755	2003-11-19 18:02:43+02	2003-11-19 17:45:08.850207+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315754	2003-11-19 18:02:43+02	2003-11-19 17:45:08.844573+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315753	2003-11-19 18:02:43+02	2003-11-19 17:45:08.734047+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315758	2003-11-19 18:02:44+02	2003-11-19 17:45:09.743659+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315757	2003-11-19 18:02:44+02	2003-11-19 17:45:09.739747+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315756	2003-11-19 18:02:44+02	2003-11-19 17:45:09.734169+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315760	2003-11-19 18:02:45+02	2003-11-19 17:45:10.776281+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315759	2003-11-19 18:02:45+02	2003-11-19 17:45:10.729662+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1315787	2003-11-19 18:02:46+02	2003-11-19 17:45:20.290568+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1318673	2003-11-19 18:05:04+02	2003-11-19 18:05:07.22531+02	ganymede	3731	/kernel:		.		10
1318674	2003-11-19 18:05:04+02	2003-11-19 18:05:07.229072+02	ganymede	3731	/kernel:		checking for core dump...		10
1318672	2003-11-19 18:05:04+02	2003-11-19 18:05:07.198265+02	ganymede	3731	/kernel:		syslogd		10
1318676	2003-11-19 18:05:04+02	2003-11-19 18:05:07.362487+02	ganymede	3731	savecore:		Router rebooting after a normal shutdown....		10
1318675	2003-11-19 18:05:04+02	2003-11-19 18:05:07.344267+02	ganymede	3731	/kernel:	savecore:	Router rebooting after a normal shutdown....		10
1318693	2003-11-19 18:05:07+02	2003-11-19 18:05:07.536244+02	ganymede	3731	/kernel:		starting standard daemons:		10
1318724	2003-11-19 18:05:07+02	2003-11-19 18:05:08.249937+02	ganymede	3731	init:		management (PID 2226) started		10
1318691	2003-11-19 18:05:07+02	2003-11-19 18:05:07.527275+02	ganymede	3731	/kernel:		.		10
1352882	2003-11-21 17:53:43+02	2003-11-21 17:36:24.020922+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352883	2003-11-21 17:53:44+02	2003-11-21 17:36:25.022836+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352884	2003-11-21 17:53:44+02	2003-11-21 17:36:25.03495+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352887	2003-11-21 17:53:45+02	2003-11-21 17:36:26.034522+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1318708	2003-11-19 18:05:07+02	2003-11-19 18:05:08.028598+02	ganymede	3731	/kernel:		Wed Nov 19 17:05:07 CET 2003		10
1318718	2003-11-19 18:05:07+02	2003-11-19 18:05:08.227268+02	ganymede	3731	init:		alarm-control (PID 2223) started		10
1318677	2003-11-19 18:05:07+02	2003-11-19 18:05:07.366328+02	ganymede	3731	/kernel:		Additional routing options:		10
1318723	2003-11-19 18:05:07+02	2003-11-19 18:05:08.246215+02	ganymede	3731	init:		process_mode mode=BOTH cmd=management master_mode=-1		10
1318702	2003-11-19 18:05:07+02	2003-11-19 18:05:07.900888+02	ganymede	3731	/kernel:		rc.i386 configuring syscons:		10
1318684	2003-11-19 18:05:07+02	2003-11-19 18:05:07.394789+02	ganymede	3731	/kernel:	TNP:	version is changing to 1		10
1318697	2003-11-19 18:05:07+02	2003-11-19 18:05:07.877488+02	ganymede	3731	/kernel:		Initial rc.i386 initialization:		10
1318730	2003-11-19 18:05:07+02	2003-11-19 18:05:08.384016+02	ganymede	3731	chassisd[2222]:		 CHASSISD release 6.1R1.4 built by builder on 2003-10-09 20:21:27 UTC 		10
1318726	2003-11-19 18:05:07+02	2003-11-19 18:05:08.36876+02	ganymede	3731	init:		snmp (PID 2227) started		10
1318679	2003-11-19 18:05:07+02	2003-11-19 18:05:07.374338+02	ganymede	3731	/kernel:		.		10
1318706	2003-11-19 18:05:07+02	2003-11-19 18:05:08.019201+02	ganymede	3731	/kernel:		starting local daemons:		10
1318705	2003-11-19 18:05:07+02	2003-11-19 18:05:08.012515+02	ganymede	3731	/kernel:		.		10
1318720	2003-11-19 18:05:07+02	2003-11-19 18:05:08.234795+02	ganymede	3731	init:		craft-control (PID 2224) started		10
1318710	2003-11-19 18:05:07+02	2003-11-19 18:05:08.037673+02	ganymede	3731	init:		watchdog (PID 2219) started		10
1318682	2003-11-19 18:05:07+02	2003-11-19 18:05:07.385561+02	ganymede	3731	/kernel:	fxp0:	link media UP 100Mb / full-duplex		10
1318717	2003-11-19 18:05:07+02	2003-11-19 18:05:08.223274+02	ganymede	3731	init:		process_mode mode=BOTH cmd=alarm-control master_mode=-1		10
1318709	2003-11-19 18:05:07+02	2003-11-19 18:05:08.033457+02	ganymede	3731	init:		process_mode mode=BOTH cmd=watchdog master_mode=-1		10
1318715	2003-11-19 18:05:07+02	2003-11-19 18:05:08.212466+02	ganymede	3731	init:		process_mode mode=BOTH cmd=chassis-control master_mode=-1		10
1318696	2003-11-19 18:05:07+02	2003-11-19 18:05:07.871018+02	ganymede	3731	/kernel:		.		10
1318712	2003-11-19 18:05:07+02	2003-11-19 18:05:08.051259+02	ganymede	3731	init:		tnp-process (PID 2220) started		10
1318681	2003-11-19 18:05:07+02	2003-11-19 18:05:07.381859+02	ganymede	3731	/kernel:		ntpdate		10
1318690	2003-11-19 18:05:07+02	2003-11-19 18:05:07.523516+02	ganymede	3731	/kernel:		Starting final network daemons:		10
1318698	2003-11-19 18:05:07+02	2003-11-19 18:05:07.882537+02	ganymede	3731	/kernel:		microcode kld		10
1318703	2003-11-19 18:05:07+02	2003-11-19 18:05:07.904768+02	ganymede	3731	/kernel:		.		10
1318704	2003-11-19 18:05:07+02	2003-11-19 18:05:07.908472+02	ganymede	3731	/kernel:		Local package initialization:		10
1318713	2003-11-19 18:05:07+02	2003-11-19 18:05:08.103697+02	ganymede	3731	init:		process_mode mode=RESTART cmd=interface-control master_mode=-1		10
1318722	2003-11-19 18:05:07+02	2003-11-19 18:05:08.242354+02	ganymede	3731	init:		ntp (PID 2225) started		10
1318707	2003-11-19 18:05:07+02	2003-11-19 18:05:08.023824+02	ganymede	3731	/kernel:		.		10
1318695	2003-11-19 18:05:07+02	2003-11-19 18:05:07.652498+02	ganymede	3731	cron[2185]:		(CRON) STARTUP (fork ok) 		10
1318714	2003-11-19 18:05:07+02	2003-11-19 18:05:08.107495+02	ganymede	3731	init:		interface-control (PID 2221) started		10
1318719	2003-11-19 18:05:07+02	2003-11-19 18:05:08.231066+02	ganymede	3731	init:		process_mode mode=BOTH cmd=craft-control master_mode=-1		10
1318716	2003-11-19 18:05:07+02	2003-11-19 18:05:08.217929+02	ganymede	3731	init:		chassis-control (PID 2222) started		10
1318694	2003-11-19 18:05:07+02	2003-11-19 18:05:07.540026+02	ganymede	3731	/kernel:		cron		10
1318729	2003-11-19 18:05:07+02	2003-11-19 18:05:08.380241+02	ganymede	3731	init:		process_mode mode=BOTH cmd=inet-process master_mode=-1		10
1318701	2003-11-19 18:05:07+02	2003-11-19 18:05:07.897008+02	ganymede	3731	/kernel:		.		10
1318692	2003-11-19 18:05:07+02	2003-11-19 18:05:07.531131+02	ganymede	3731	/kernel:		setting ldconfig path: /usr/lib		10
1318689	2003-11-19 18:05:07+02	2003-11-19 18:05:07.51976+02	ganymede	3731	/kernel:		.		10
1318725	2003-11-19 18:05:07+02	2003-11-19 18:05:08.362967+02	ganymede	3731	init:		process_mode mode=BOTH cmd=snmp master_mode=-1		10
1318711	2003-11-19 18:05:07+02	2003-11-19 18:05:08.041595+02	ganymede	3731	init:		process_mode mode=BOTH cmd=tnp-process master_mode=-1		10
1318721	2003-11-19 18:05:07+02	2003-11-19 18:05:08.238519+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ntp master_mode=-1		10
1318728	2003-11-19 18:05:07+02	2003-11-19 18:05:08.376429+02	ganymede	3731	init:		process_mode current_mode=UNKNOWN, requested_mode=MASTER_ONLY, cmd=routing 		10
1318727	2003-11-19 18:05:07+02	2003-11-19 18:05:08.372563+02	ganymede	3731	init:		process_mode current_mode=UNKNOWN, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1318683	2003-11-19 18:05:07+02	2003-11-19 18:05:07.39106+02	ganymede	3731	/kernel:	fxp1:	link media UP 100Mb / full-duplex		10
1318680	2003-11-19 18:05:07+02	2003-11-19 18:05:07.378037+02	ganymede	3731	/kernel:		Doing additional network setup:		10
1318678	2003-11-19 18:05:07+02	2003-11-19 18:05:07.370036+02	ganymede	3731	/kernel:		ipsec kld		10
1318700	2003-11-19 18:05:07+02	2003-11-19 18:05:07.891347+02	ganymede	3731	/kernel:	Microcode:	updated from revision 0 to 11, date=05051999		10
1318686	2003-11-19 18:05:07+02	2003-11-19 18:05:07.508349+02	ganymede	3731	ntpdate[2170]:		step time server 172.26.27.3 offset -0.014938 sec		10
1318699	2003-11-19 18:05:07+02	2003-11-19 18:05:07.887179+02	ganymede	3731	/kernel:	Microcode:	Header revision 1, Date 5/5/1999, Platform Id 20		10
1318685	2003-11-19 18:05:07+02	2003-11-19 18:05:07.502757+02	ganymede	3731	/kernel:	TNP:	adding neighbor 2 to interface fxp1.		10
1318735	2003-11-19 18:05:08+02	2003-11-19 18:05:08.512457+02	ganymede	3731	/kernel:	mastership:	routing engine 0 becoming master		10
1318762	2003-11-19 18:05:08+02	2003-11-19 18:05:08.891894+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1318769	2003-11-19 18:05:08+02	2003-11-19 18:05:09.0295+02	ganymede	3731	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1318747	2003-11-19 18:05:08+02	2003-11-19 18:05:08.67475+02	ganymede	3731	init:		sampling (PID 2234) started		10
1318748	2003-11-19 18:05:08+02	2003-11-19 18:05:08.67873+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1318751	2003-11-19 18:05:08+02	2003-11-19 18:05:08.738768+02	ganymede	3731	init:		remote-operations (PID 2236) started		10
1318755	2003-11-19 18:05:08+02	2003-11-19 18:05:08.862569+02	ganymede	3731	init:		network-access (PID 2238) started		10
1318764	2003-11-19 18:05:08+02	2003-11-19 18:05:08.899689+02	ganymede	3731	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1318773	2003-11-19 18:05:08+02	2003-11-19 18:05:09.048343+02	ganymede	3731	smartd[2243]:		smartd starting, pid 2243		10
1318763	2003-11-19 18:05:08+02	2003-11-19 18:05:08.8956+02	ganymede	3731	init:		link-management (PID 2242) started		10
1338428	2003-11-20 16:08:10+02	2003-11-20 15:50:42.562525+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338430	2003-11-20 16:08:11+02	2003-11-20 15:50:43.563381+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338431	2003-11-20 16:08:11+02	2003-11-20 15:50:43.569275+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338433	2003-11-20 16:08:12+02	2003-11-20 15:50:44.564343+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338435	2003-11-20 16:08:12+02	2003-11-20 15:50:44.578169+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338434	2003-11-20 16:08:12+02	2003-11-20 15:50:44.574354+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338437	2003-11-20 16:08:13+02	2003-11-20 15:50:45.692218+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338438	2003-11-20 16:08:13+02	2003-11-20 15:50:45.697871+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1318768	2003-11-19 18:05:08+02	2003-11-19 18:05:09.025779+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1318731	2003-11-19 18:05:08+02	2003-11-19 18:05:08.387804+02	ganymede	3731	init:		inet-process (PID 2228) started		10
1318767	2003-11-19 18:05:08+02	2003-11-19 18:05:09.021944+02	ganymede	3731	init:		disk-monitoring (PID 2243) started		10
1318770	2003-11-19 18:05:08+02	2003-11-19 18:05:09.035028+02	ganymede	3731	craftd[2224]:		craftd detected platform m10 		10
1318739	2003-11-19 18:05:08+02	2003-11-19 18:05:08.530832+02	ganymede	3731	init:		sonet-aps (PID 2230) started		10
1318746	2003-11-19 18:05:08+02	2003-11-19 18:05:08.670043+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1318765	2003-11-19 18:05:08+02	2003-11-19 18:05:09.012464+02	ganymede	3731	init:		syslogd (PID 2093) started		10
1318736	2003-11-19 18:05:08+02	2003-11-19 18:05:08.518092+02	ganymede	3731	/kernel:	TNP:	adding neighbor 1 to interface fxp1.		10
1318745	2003-11-19 18:05:08+02	2003-11-19 18:05:08.664213+02	ganymede	3731	init:		pfe (PID 2233) started		10
1318753	2003-11-19 18:05:08+02	2003-11-19 18:05:08.746677+02	ganymede	3731	init:		class-of-service (PID 2237) started		10
1318752	2003-11-19 18:05:08+02	2003-11-19 18:05:08.742727+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1318766	2003-11-19 18:05:08+02	2003-11-19 18:05:09.01796+02	ganymede	3731	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1318774	2003-11-19 18:05:08+02	2003-11-19 18:05:09.118736+02	ganymede	3731	init:		firewall (PID 2244) started		10
1318771	2003-11-19 18:05:08+02	2003-11-19 18:05:09.039032+02	ganymede	3731	tnp.bootpd[2229]:	BOOTPD_VERSION:	Version: TNP.BOOTPD release 6.1R1.4 built by builder on 2003-10-09 20:17:47 UTC		10
1318759	2003-11-19 18:05:08+02	2003-11-19 18:05:08.87921+02	ganymede	3731	init:		helper (PID 2240) started		10
1318744	2003-11-19 18:05:08+02	2003-11-19 18:05:08.550785+02	ganymede	3731	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1318738	2003-11-19 18:05:08+02	2003-11-19 18:05:08.527031+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1318737	2003-11-19 18:05:08+02	2003-11-19 18:05:08.523057+02	ganymede	3731	xntpd[2225]:		ntpd 4.0.99b Thu Oct  9 20:39:08 GMT 2003 (1)		1
1318750	2003-11-19 18:05:08+02	2003-11-19 18:05:08.735043+02	ganymede	3731	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1318743	2003-11-19 18:05:08+02	2003-11-19 18:05:08.546986+02	ganymede	3731	init:		sntp (PID 2232) started		10
1318761	2003-11-19 18:05:08+02	2003-11-19 18:05:08.888067+02	ganymede	3731	init:		remote-hello (PID 2241) started		10
1318741	2003-11-19 18:05:08+02	2003-11-19 18:05:08.538315+02	ganymede	3731	init:		vrrp (PID 2231) started		10
1318760	2003-11-19 18:05:08+02	2003-11-19 18:05:08.88413+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1318740	2003-11-19 18:05:08+02	2003-11-19 18:05:08.534605+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1318757	2003-11-19 18:05:08+02	2003-11-19 18:05:08.871818+02	ganymede	3731	init:		ipsec-key-management (PID 2239) started		10
1318756	2003-11-19 18:05:08+02	2003-11-19 18:05:08.86808+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1318754	2003-11-19 18:05:08+02	2003-11-19 18:05:08.750476+02	ganymede	3731	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1318758	2003-11-19 18:05:08+02	2003-11-19 18:05:08.875527+02	ganymede	3731	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1318749	2003-11-19 18:05:08+02	2003-11-19 18:05:08.730948+02	ganymede	3731	init:		ilmi (PID 2235) started		10
1318742	2003-11-19 18:05:08+02	2003-11-19 18:05:08.542512+02	ganymede	3731	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1318775	2003-11-19 18:05:09+02	2003-11-19 18:05:09.326658+02	ganymede	3731	tnp.bootpd[2229]:	BOOTPD_BOOTSTRING:	Boot string: boot 1 sbr.jbf		10
1318797	2003-11-19 18:05:10+02	2003-11-19 18:05:11.42367+02	ganymede	3731	init:	Multiuser:	old requested_transition==0x0 sighupped=1 		10
1318798	2003-11-19 18:05:10+02	2003-11-19 18:05:11.427356+02	ganymede	3731	xntpd[2225]:		kern_enable is 1		1
1318799	2003-11-19 18:05:10+02	2003-11-19 18:05:11.434003+02	ganymede	3731	xntpd[2225]:		using kernel phase-lock loop 2040		1
1318788	2003-11-19 18:05:10+02	2003-11-19 18:05:11.27718+02	ganymede	3731	init:		pic-services-logging (PID 2248) started		10
1318786	2003-11-19 18:05:10+02	2003-11-19 18:05:11.26809+02	ganymede	3731	init:		routing-socket-proxy (PID 2247) started		10
1318793	2003-11-19 18:05:10+02	2003-11-19 18:05:11.296188+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=neighbor-liveness 		10
1318800	2003-11-19 18:05:10+02	2003-11-19 18:05:11.437957+02	ganymede	3731	alarmd[2223]:		craftd connection succeeded after 0 retries 		10
1318792	2003-11-19 18:05:10+02	2003-11-19 18:05:11.292466+02	ganymede	3731	init:		ecc-error-logging (PID 2250) started		500
1318785	2003-11-19 18:05:10+02	2003-11-19 18:05:11.262573+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1318783	2003-11-19 18:05:10+02	2003-11-19 18:05:11.11908+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 1 traps in queue 		2
1318782	2003-11-19 18:05:10+02	2003-11-19 18:05:10.490341+02	ganymede	3731	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1318796	2003-11-19 18:05:10+02	2003-11-19 18:05:11.419835+02	ganymede	3731	init:		pgm (PID 2252) started		10
1318784	2003-11-19 18:05:10+02	2003-11-19 18:05:11.150996+02	ganymede	3731	init:		internal-routing-service (PID 2246) started		10
1318795	2003-11-19 18:05:10+02	2003-11-19 18:05:11.414202+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pgm 		10
1318794	2003-11-19 18:05:10+02	2003-11-19 18:05:11.29989+02	ganymede	3731	init:		neighbor-liveness (PID 2251) started		10
1318791	2003-11-19 18:05:10+02	2003-11-19 18:05:11.28867+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1318789	2003-11-19 18:05:10+02	2003-11-19 18:05:11.280919+02	ganymede	3731	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1318790	2003-11-19 18:05:10+02	2003-11-19 18:05:11.284774+02	ganymede	3731	init:		adaptive-services (PID 2249) started		10
1318787	2003-11-19 18:05:10+02	2003-11-19 18:05:11.273032+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1318801	2003-11-19 18:05:10+02	2003-11-19 18:05:11.441952+02	ganymede	3731	alarmd[2223]:		resending alarm state 		10
1318809	2003-11-19 18:05:11+02	2003-11-19 18:05:12.243667+02	ganymede	3731	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1348557	2003-11-20 20:48:15+02	2003-11-20 20:30:49.701907+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348558	2003-11-20 20:48:16+02	2003-11-20 20:30:50.699304+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348559	2003-11-20 20:48:16+02	2003-11-20 20:30:50.710491+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348562	2003-11-20 20:48:17+02	2003-11-20 20:30:51.710354+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348560	2003-11-20 20:48:17+02	2003-11-20 20:30:51.698848+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348561	2003-11-20 20:48:17+02	2003-11-20 20:30:51.706497+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348565	2003-11-20 20:48:18+02	2003-11-20 20:30:52.832037+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348563	2003-11-20 20:48:18+02	2003-11-20 20:30:52.704954+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348564	2003-11-20 20:48:18+02	2003-11-20 20:30:52.826677+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348567	2003-11-20 20:48:19+02	2003-11-20 20:30:53.714039+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348566	2003-11-20 20:48:19+02	2003-11-20 20:30:53.704562+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348568	2003-11-20 20:48:19+02	2003-11-20 20:30:53.719573+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348570	2003-11-20 20:48:20+02	2003-11-20 20:30:54.70592+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348571	2003-11-20 20:48:20+02	2003-11-20 20:30:54.722223+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1348574	2003-11-20 20:48:21+02	2003-11-20 20:31:01.765891+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1318803	2003-11-19 18:05:11+02	2003-11-19 18:05:11.449405+02	ganymede	3731	xntpd[2225]:		using kernel phase-lock loop 2041		1
1318806	2003-11-19 18:05:11+02	2003-11-19 18:05:11.609232+02	ganymede	3731	init:		process_mode mode=BOTH cmd=watchdog master_mode=1		10
1318807	2003-11-19 18:05:11+02	2003-11-19 18:05:12.219904+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 2 traps in queue 		2
1318802	2003-11-19 18:05:11+02	2003-11-19 18:05:11.4457+02	ganymede	3731	xntpd[2225]:		frequency initialized 84.242 from /var/db/ntp.drift		1
1318808	2003-11-19 18:05:11+02	2003-11-19 18:05:12.239556+02	ganymede	3731	init:		process_mode mode=BOTH cmd=tnp-process master_mode=1		10
1318811	2003-11-19 18:05:11+02	2003-11-19 18:05:12.284787+02	ganymede	3731	init:		clean_process:killing process interface-control as mastership/failover mode changed! 		10
1318810	2003-11-19 18:05:11+02	2003-11-19 18:05:12.247418+02	ganymede	3731	init:		clean_process:process interface-control RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1318815	2003-11-19 18:05:12+02	2003-11-19 18:05:12.4282+02	ganymede	3731	init:		process_mode mode=BOTH cmd=alarm-control master_mode=1		10
1318936	2003-11-19 18:05:12+02	2003-11-19 18:05:16.205941+02	ganymede	3731	init:		process_mode mode=BOTH cmd=management master_mode=1		10
1318821	2003-11-19 18:05:12+02	2003-11-19 18:05:12.844587+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1318820	2003-11-19 18:05:12+02	2003-11-19 18:05:12.719003+02	ganymede	3731	init:		process_mode mode=BOTH cmd=craft-control master_mode=1		10
1318813	2003-11-19 18:05:12+02	2003-11-19 18:05:12.296985+02	ganymede	3731	snmpd[2227]:	SNMPD_TRAP_COLD_START:	trap_generate_cold: SNMP trap: cold start 		2
1318814	2003-11-19 18:05:12+02	2003-11-19 18:05:12.422574+02	ganymede	3731	init:		process_mode mode=BOTH cmd=chassis-control master_mode=1		10
1318812	2003-11-19 18:05:12+02	2003-11-19 18:05:12.288601+02	ganymede	3731	smartd[2243]:		Device /dev/ad1a, found and is SMART capable		10
1318841	2003-11-19 18:05:13+02	2003-11-19 18:05:14.103757+02	atlas	3730	/kernel:	md0:	Malloc disk		10
1318912	2003-11-19 18:05:13+02	2003-11-19 18:05:15.785075+02	atlas	3730	/kernel:		Setting initial options: 		10
1318927	2003-11-19 18:05:13+02	2003-11-19 18:05:16.059588+02	atlas	3730	/kernel:	TNP:	adding neighbor 2 to interface fxp1.		10
1318898	2003-11-19 18:05:13+02	2003-11-19 18:05:15.51474+02	atlas	3730	/kernel:	/dev/ad0s1e:			10
1318829	2003-11-19 18:05:13+02	2003-11-19 18:05:13.603774+02	atlas	3730	/kernel:		builder@wyvern.juniper.net:/build/wyvern-c/6.1R1.4/obj-i386/sys/compile/JUNIPER		10
1318923	2003-11-19 18:05:13+02	2003-11-19 18:05:16.042627+02	atlas	3730	/kernel:		syslogd		10
1318925	2003-11-19 18:05:13+02	2003-11-19 18:05:16.051949+02	atlas	3730	/kernel:	fxp1:	link media UP 100Mb / full-duplex		10
1318924	2003-11-19 18:05:13+02	2003-11-19 18:05:16.048068+02	atlas	3730	/kernel:	fxp0:	link media UP 100Mb / full-duplex		10
1318880	2003-11-19 18:05:13+02	2003-11-19 18:05:15.164357+02	atlas	3730	/kernel:	DEVFS:	ready to run		10
1318933	2003-11-19 18:05:13+02	2003-11-19 18:05:16.19258+02	atlas	3730	/kernel:		checking for core dump...		10
1318934	2003-11-19 18:05:13+02	2003-11-19 18:05:16.19817+02	atlas	3730	/kernel:	savecore:	Router rebooting after a normal shutdown....		10
1318873	2003-11-19 18:05:13+02	2003-11-19 18:05:14.915054+02	atlas	3730	/kernel:		sio1 at port 0x3e8-0x3ef irq 5 on isa0		10
1318839	2003-11-19 18:05:13+02	2003-11-19 18:05:14.044241+02	atlas	3730	/kernel:	DEVFS:	ready for devices		10
1318822	2003-11-19 18:05:13+02	2003-11-19 18:05:13.304396+02	atlas	3730	syslogd:		restart		10
1318847	2003-11-19 18:05:13+02	2003-11-19 18:05:14.237842+02	atlas	3730	/kernel:	isab0:	<Intel 82371AB PCI to ISA bridge> at device 7.0 on pci0		10
1318902	2003-11-19 18:05:13+02	2003-11-19 18:05:15.530229+02	atlas	3730	/kernel:		(54 frags, 6294 blocks, 0.1% fragmentation)		10
1318827	2003-11-19 18:05:13+02	2003-11-19 18:05:13.479814+02	atlas	3730	/kernel:		The Regents of the University of California. All rights reserved.		10
1318920	2003-11-19 18:05:13+02	2003-11-19 18:05:15.921083+02	atlas	3730	/kernel:		.		10
1318899	2003-11-19 18:05:13+02	2003-11-19 18:05:15.518635+02	atlas	3730	/kernel:		clean, 11061 free 		10
1318869	2003-11-19 18:05:13+02	2003-11-19 18:05:14.893156+02	atlas	3730	/kernel:	pccard0:	<PC Card bus -- legacy version> on pcic0		10
1318867	2003-11-19 18:05:13+02	2003-11-19 18:05:14.781061+02	atlas	3730	/kernel:	pcic0:	management irq 11		10
1318871	2003-11-19 18:05:13+02	2003-11-19 18:05:14.903844+02	atlas	3730	/kernel:		sio0 at port 0x3f8-0x3ff irq 4 flags 0x90 on isa0		10
1318849	2003-11-19 18:05:13+02	2003-11-19 18:05:14.354112+02	atlas	3730	/kernel:	atapci0:	<Intel PIIX4 ATA33 controller> port 0xf000-0xf00f at device 7.1 on pci0		10
1318842	2003-11-19 18:05:13+02	2003-11-19 18:05:14.108064+02	atlas	3730	/kernel:		DRAM Data Integrity Mode: ECC Mode with h/w scrubbing		10
1318826	2003-11-19 18:05:13+02	2003-11-19 18:05:13.471214+02	atlas	3730	/kernel:		Copyright (c) 1979, 1980, 1983, 1986, 1988, 1989, 1991, 1992, 1993, 1994		10
1318866	2003-11-19 18:05:13+02	2003-11-19 18:05:14.775143+02	atlas	3730	/kernel:	pcic0:	<VLSI 82C146> at port 0x3e0 iomem 0xd0000 irq 10 on isa0		10
1318848	2003-11-19 18:05:13+02	2003-11-19 18:05:14.243431+02	atlas	3730	/kernel:	isa0:	<ISA bus> on isab0		10
1318878	2003-11-19 18:05:13+02	2003-11-19 18:05:15.04458+02	atlas	3730	/kernel:	fxp0:	Ethernet address 00:a0:a5:28:1e:1b		10
1318918	2003-11-19 18:05:13+02	2003-11-19 18:05:15.91358+02	atlas	3730	/kernel:		.		10
1318856	2003-11-19 18:05:13+02	2003-11-19 18:05:14.495058+02	atlas	3730	/kernel:	pcic-pci1:	TI12XX PCI Config Reg: [pci only]		10
1318917	2003-11-19 18:05:13+02	2003-11-19 18:05:15.909786+02	atlas	3730	/kernel:		PCCARD Memory address set to 0xd4000		10
1338436	2003-11-20 16:08:13+02	2003-11-20 15:50:45.564199+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338439	2003-11-20 16:08:14+02	2003-11-20 15:50:46.565023+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338441	2003-11-20 16:08:14+02	2003-11-20 15:50:46.584339+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338440	2003-11-20 16:08:14+02	2003-11-20 15:50:46.580183+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338443	2003-11-20 16:08:15+02	2003-11-20 15:50:47.575859+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338442	2003-11-20 16:08:15+02	2003-11-20 15:50:47.564844+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1338446	2003-11-20 16:08:16+02	2003-11-20 15:50:54.46524+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1339043	2003-11-20 16:08:31+02	2003-11-20 16:08:31.863084+02	r201	3732	xntpd[4414]:		offset -0.000268 sec freq 82.636 ppm error 0.000179 poll 10		500
1318862	2003-11-19 18:05:13+02	2003-11-19 18:05:14.627833+02	atlas	3730	/kernel:	atkbdc0:	<Keyboard controller (i8042)> at port 0x60,0x64 on isa0		10
1318850	2003-11-19 18:05:13+02	2003-11-19 18:05:14.360103+02	atlas	3730	/kernel:	ata0:	at 0x1f0 irq 14 on atapci0		10
1318851	2003-11-19 18:05:13+02	2003-11-19 18:05:14.364464+02	atlas	3730	/kernel:	pci0:	<Intel 82371AB/EB (PIIX4) USB controller> at 7.2 irq 11		10
1318915	2003-11-19 18:05:13+02	2003-11-19 18:05:15.901758+02	atlas	3730	/kernel:		.		10
1318831	2003-11-19 18:05:13+02	2003-11-19 18:05:13.644135+02	atlas	3730	/kernel:		Timecounter "TSC"  frequency 331706094 Hz		10
1318896	2003-11-19 18:05:13+02	2003-11-19 18:05:15.505659+02	atlas	3730	/kernel:	/dev/ad0s1e:			10
1318868	2003-11-19 18:05:13+02	2003-11-19 18:05:14.78748+02	atlas	3730	/kernel:	pcic0:	Polling mode		10
1318870	2003-11-19 18:05:13+02	2003-11-19 18:05:14.897441+02	atlas	3730	/kernel:	pccard1:	<PC Card bus -- legacy version> on pcic0		10
1318903	2003-11-19 18:05:13+02	2003-11-19 18:05:15.642599+02	atlas	3730	/kernel:	/dev/ad1s1f:			10
1318852	2003-11-19 18:05:13+02	2003-11-19 18:05:14.368795+02	atlas	3730	/kernel:	smb0:	<Intel 82371AB SMB controller> port 0x5000-0x500f at device 7.3 on pci0		10
1318937	2003-11-19 18:05:13+02	2003-11-19 18:05:16.209667+02	ganymede	3731	init:		process_mode mode=BOTH cmd=snmp master_mode=1		10
1318861	2003-11-19 18:05:13+02	2003-11-19 18:05:14.623572+02	atlas	3730	/kernel:		ata2 at port 0x170-0x177,0x376 irq 15 on isa0		10
1318844	2003-11-19 18:05:13+02	2003-11-19 18:05:14.223176+02	atlas	3730	/kernel:	npx0:	INT 16 interface		10
1318832	2003-11-19 18:05:13+02	2003-11-19 18:05:13.649383+02	atlas	3730	/kernel:	CPU:	Pentium II/Pentium II Xeon/Celeron (331.71-MHz 686-class CPU)		10
1318895	2003-11-19 18:05:13+02	2003-11-19 18:05:15.501887+02	atlas	3730	/kernel:		clean, 50406 free 		10
1318830	2003-11-19 18:05:13+02	2003-11-19 18:05:13.637457+02	atlas	3730	/kernel:		Timecounter "i8254"  frequency 1193182 Hz		10
1318823	2003-11-19 18:05:13+02	2003-11-19 18:05:13.341352+02	atlas	3730	/kernel:		Copyright (c) 1996-2001, Juniper Networks, Inc.		10
1318838	2003-11-19 18:05:13+02	2003-11-19 18:05:13.928168+02	atlas	3730	/kernel:		Preloaded elf kernel "kernel" at 0xc057b000.		10
1318840	2003-11-19 18:05:13+02	2003-11-19 18:05:14.09934+02	atlas	3730	/kernel:		Pentium Pro MTRR support enabled		10
1318865	2003-11-19 18:05:13+02	2003-11-19 18:05:14.769472+02	atlas	3730	/kernel:	sc0:	MDA <16 virtual consoles, flags=0x100>		10
1318893	2003-11-19 18:05:13+02	2003-11-19 18:05:15.492582+02	atlas	3730	/kernel:		FILESYSTEM CLEAN; SKIPPING CHECKS		10
1318932	2003-11-19 18:05:13+02	2003-11-19 18:05:16.080406+02	atlas	3730	/kernel:		.		10
1318905	2003-11-19 18:05:13+02	2003-11-19 18:05:15.651671+02	atlas	3730	/kernel:	/dev/ad1s1f:			10
1318913	2003-11-19 18:05:13+02	2003-11-19 18:05:15.892558+02	atlas	3730	/kernel:		debugger_on_panic=NO		10
1318919	2003-11-19 18:05:13+02	2003-11-19 18:05:15.917329+02	atlas	3730	/kernel:		Doing initial network setup:		10
1318939	2003-11-19 18:05:13+02	2003-11-19 18:05:16.217183+02	ganymede	3731	init:		mib-process (PID 2258) started		10
1318935	2003-11-19 18:05:13+02	2003-11-19 18:05:16.202156+02	atlas	3730	savecore:		Router rebooting after a normal shutdown....		10
1318926	2003-11-19 18:05:13+02	2003-11-19 18:05:16.055856+02	atlas	3730	/kernel:	TNP:	version is changing to 1		10
1318853	2003-11-19 18:05:13+02	2003-11-19 18:05:14.373742+02	atlas	3730	/kernel:	pcic-pci0:	<TI PCI-1251B PCI-CardBus Bridge> mem 0xe6205000-0xe6205fff irq 15 at device 13.0 on pci0		10
1318914	2003-11-19 18:05:13+02	2003-11-19 18:05:15.897991+02	atlas	3730	/kernel:		debugger_on_break=NO		10
1318854	2003-11-19 18:05:13+02	2003-11-19 18:05:14.483175+02	atlas	3730	/kernel:	pcic-pci0:	TI12XX PCI Config Reg: [pci only]		10
1318881	2003-11-19 18:05:13+02	2003-11-19 18:05:15.176406+02	atlas	3730	/kernel:	ad0:	91MB <SanDisk SDCFB-96> [734/8/32] at ata0-master using PIO1		10
1318894	2003-11-19 18:05:13+02	2003-11-19 18:05:15.498062+02	atlas	3730	/kernel:	/dev/ad0s1a:			10
1318855	2003-11-19 18:05:13+02	2003-11-19 18:05:14.489342+02	atlas	3730	/kernel:	pcic-pci1:	<TI PCI-1251B PCI-CardBus Bridge> mem 0xe6200000-0xe6200fff irq 7 at device 13.1 on pci0		10
1318882	2003-11-19 18:05:13+02	2003-11-19 18:05:15.186214+02	atlas	3730	/kernel:	ad1:	11513MB <IBM-DARA-212000> [23392/16/63] at ata0-slave using UDMA33		10
1318938	2003-11-19 18:05:13+02	2003-11-19 18:05:16.213469+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1318897	2003-11-19 18:05:13+02	2003-11-19 18:05:15.50939+02	atlas	3730	/kernel:		FILESYSTEM CLEAN; SKIPPING CHECKS		10
1318911	2003-11-19 18:05:13+02	2003-11-19 18:05:15.781241+02	atlas	3730	/kernel:	mgd:	commit complete		10
1318921	2003-11-19 18:05:13+02	2003-11-19 18:05:15.926549+02	atlas	3730	/kernel:		Initial interface configuration:		10
1318879	2003-11-19 18:05:13+02	2003-11-19 18:05:15.156498+02	atlas	3730	/kernel:	fxp1:	Ethernet address 00:a0:a5:28:1e:1a		10
1318872	2003-11-19 18:05:13+02	2003-11-19 18:05:14.908305+02	atlas	3730	/kernel:	sio0:	type 16550A, console		10
1318863	2003-11-19 18:05:13+02	2003-11-19 18:05:14.632238+02	atlas	3730	/kernel:	vga0:	<Generic ISA VGA> at port 0x3b0-0x3bb iomem 0xb0000-0xb7fff on isa0		10
1318846	2003-11-19 18:05:13+02	2003-11-19 18:05:14.233596+02	atlas	3730	/kernel:	pci0:	<PCI bus> on pcib0		10
1318885	2003-11-19 18:05:13+02	2003-11-19 18:05:15.350151+02	atlas	3730	/kernel:		Mounted jkernel package on /dev/vn1...		10
1318908	2003-11-19 18:05:13+02	2003-11-19 18:05:15.723714+02	atlas	3730	/kernel:	tunefs:			10
1318860	2003-11-19 18:05:13+02	2003-11-19 18:05:14.619153+02	atlas	3730	/kernel:	fxp1:	<Intel EtherExpress Pro 10/100B Ethernet> port 0xe000-0xe03f mem 0xe6000000-0xe60fffff,0xe6207000-0xe6207fff irq 10 at device 19.0 on pci0		10
1318857	2003-11-19 18:05:13+02	2003-11-19 18:05:14.49984+02	atlas	3730	/kernel:	fxp0:	<Intel EtherExpress Pro 10/100B Ethernet> port 0xd800-0xd83f mem 0xe6100000-0xe61fffff,0xe6204000-0xe6204fff irq 7 at device 16.0 on pci0		10
1318874	2003-11-19 18:05:13+02	2003-11-19 18:05:15.023379+02	atlas	3730	/kernel:	sio1:	type 16550A		10
1318864	2003-11-19 18:05:13+02	2003-11-19 18:05:14.743242+02	atlas	3730	/kernel:	sc0:	<System console> at flags 0x100 on isa0		10
1318892	2003-11-19 18:05:13+02	2003-11-19 18:05:15.383345+02	atlas	3730	/kernel:	/dev/ad0s1a:			10
1318834	2003-11-19 18:05:13+02	2003-11-19 18:05:13.773164+02	atlas	3730	/kernel:		Features=0x183f9ff<FPU,VME,DE,PSE,TSC,MSR,PAE,MCE,CX8,SEP,MTRR,PGE,MCA,CMOV,PAT,PSE36,MMX,FXSR>		10
1318906	2003-11-19 18:05:13+02	2003-11-19 18:05:15.716196+02	atlas	3730	/kernel:		clean, 8981424 free 		10
1318883	2003-11-19 18:05:13+02	2003-11-19 18:05:15.192767+02	atlas	3730	/kernel:		Mounting root from ufs:/dev/ad0s1a		10
1318910	2003-11-19 18:05:13+02	2003-11-19 18:05:15.740133+02	atlas	3730	/kernel:				10
1318901	2003-11-19 18:05:13+02	2003-11-19 18:05:15.526495+02	atlas	3730	/kernel:		(13 frags, 1381 blocks, 0.1% fragmentation)		10
1318833	2003-11-19 18:05:13+02	2003-11-19 18:05:13.662229+02	atlas	3730	/kernel:		Origin = "GenuineIntel"  Id = 0x66a  Stepping = 10		10
1357446	2003-11-21 19:24:48+02	2003-11-21 19:24:49.027542+02	adrastea	3726	/kernel:	flags:	1 cookie:0		10
1357447	2003-11-21 19:24:48+02	2003-11-21 19:24:49.033236+02	adrastea	3726	/kernel:		if_pfe_atm_iflstat_ipc ifvc:0xc68d8200 ibyte:0 obytes:0 opkts:0 ipkts:0 		10
1357445	2003-11-21 19:24:48+02	2003-11-21 19:24:48.90859+02	adrastea	3726	/kernel:	if_pfe_atm_iflstat_ipc:	(at-6/0/0)received iflstat message: hdrtype=0x48		10
1318825	2003-11-19 18:05:13+02	2003-11-19 18:05:13.462846+02	atlas	3730	/kernel:		Copyright (c) 1992-2001 The FreeBSD Project.		10
1318835	2003-11-19 18:05:13+02	2003-11-19 18:05:13.848593+02	atlas	3730	/kernel:		real memory  = 805240832 (786368K bytes)		10
1318884	2003-11-19 18:05:13+02	2003-11-19 18:05:15.343654+02	atlas	3730	/kernel:		Mounted jbase package on /dev/vn0...		10
1318828	2003-11-19 18:05:13+02	2003-11-19 18:05:13.492674+02	atlas	3730	/kernel:		JUNOS 6.1R1.4 #0: 2003-10-09 20:51:23 UTC		10
1318900	2003-11-19 18:05:13+02	2003-11-19 18:05:15.522647+02	atlas	3730	/kernel:		(54 frags, 6294 blocks, 0.1% fragmentation)		10
1318891	2003-11-19 18:05:13+02	2003-11-19 18:05:15.378898+02	atlas	3730	/kernel:		Automatic reboot in progress...		10
1318845	2003-11-19 18:05:13+02	2003-11-19 18:05:14.229347+02	atlas	3730	/kernel:	pcib0:	<Intel 82443BX host to PCI bridge (AGP disabled)> on motherboard		10
1318904	2003-11-19 18:05:13+02	2003-11-19 18:05:15.647965+02	atlas	3730	/kernel:		FILESYSTEM CLEAN; SKIPPING CHECKS		10
1318907	2003-11-19 18:05:13+02	2003-11-19 18:05:15.71999+02	atlas	3730	/kernel:		(392 frags, 1122629 blocks, 0.0% fragmentation)		10
1318909	2003-11-19 18:05:13+02	2003-11-19 18:05:15.727431+02	atlas	3730	/kernel:		soft updates set		10
1318886	2003-11-19 18:05:13+02	2003-11-19 18:05:15.354833+02	atlas	3730	/kernel:		Mounted jpfe package on /dev/vn2...		10
1318888	2003-11-19 18:05:13+02	2003-11-19 18:05:15.363862+02	atlas	3730	/kernel:		Mounted jroute package on /dev/vn4...		10
1318877	2003-11-19 18:05:13+02	2003-11-19 18:05:15.040115+02	atlas	3730	/kernel:	sio3:	configured irq 7 not in bitmap of probed irqs 0		10
1318916	2003-11-19 18:05:13+02	2003-11-19 18:05:15.905451+02	atlas	3730	/kernel:		Enable PC-card:		10
1318922	2003-11-19 18:05:13+02	2003-11-19 18:05:15.930308+02	atlas	3730	/kernel:		additional daemons:		10
1318843	2003-11-19 18:05:13+02	2003-11-19 18:05:14.114144+02	atlas	3730	/kernel:	npx0:	<math processor> on motherboard		10
1318887	2003-11-19 18:05:13+02	2003-11-19 18:05:15.359293+02	atlas	3730	/kernel:		Mounted jdocs package on /dev/vn3...		10
1318889	2003-11-19 18:05:13+02	2003-11-19 18:05:15.368187+02	atlas	3730	/kernel:		Mounted jcrypto package on /dev/vn5...		10
1318876	2003-11-19 18:05:13+02	2003-11-19 18:05:15.035648+02	atlas	3730	/kernel:	sio2:	type 16550A		10
1318859	2003-11-19 18:05:13+02	2003-11-19 18:05:14.613168+02	atlas	3730	/kernel:	pci1:	<PCI bus> on pcib1		10
1318836	2003-11-19 18:05:13+02	2003-11-19 18:05:13.90504+02	atlas	3730	/kernel:	sio0:	gdb debugging port		10
1318824	2003-11-19 18:05:13+02	2003-11-19 18:05:13.453123+02	atlas	3730	/kernel:		All rights reserved.		10
1318858	2003-11-19 18:05:13+02	2003-11-19 18:05:14.504347+02	atlas	3730	/kernel:	pcib1:	<DEC 21150 PCI-PCI bridge> at device 17.0 on pci0		10
1318890	2003-11-19 18:05:13+02	2003-11-19 18:05:15.374533+02	atlas	3730	/kernel:	swapon:	adding /dev/ad1s1b as swap device		10
1318875	2003-11-19 18:05:13+02	2003-11-19 18:05:15.029358+02	atlas	3730	/kernel:		sio2 at port 0x2f8-0x2ff irq 3 on isa0		10
1318837	2003-11-19 18:05:13+02	2003-11-19 18:05:13.91155+02	atlas	3730	/kernel:		avail memory = 777297920 (759080K bytes)		10
1318975	2003-11-19 18:05:14+02	2003-11-19 18:05:16.812068+02	atlas	3730	/kernel:		starting local daemons:		10
1318961	2003-11-19 18:05:14+02	2003-11-19 18:05:16.53818+02	ganymede	3731	tnp.bootpd[2229]:	BOOTPD_BOOTSTRING:	Boot string: boot 1 sbr.jbf		10
1318992	2003-11-19 18:05:14+02	2003-11-19 18:05:17.042525+02	ganymede	3731	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1318976	2003-11-19 18:05:14+02	2003-11-19 18:05:16.818044+02	atlas	3730	/kernel:		.		10
1318991	2003-11-19 18:05:14+02	2003-11-19 18:05:17.038683+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1319003	2003-11-19 18:05:14+02	2003-11-19 18:05:17.31449+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1318962	2003-11-19 18:05:14+02	2003-11-19 18:05:16.543172+02	ganymede	3731	rpd[2259]:	krt_ifstate_get_socket:	ifstate option is set		10
1318955	2003-11-19 18:05:14+02	2003-11-19 18:05:16.512909+02	ganymede	3731	rpd[2259]:	RPD_START:	Start rpd[2259] version 6.1R1.4 built 2003-10-09 20:28:45 UTC		10
1318997	2003-11-19 18:05:14+02	2003-11-19 18:05:17.171184+02	ganymede	3731	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1318981	2003-11-19 18:05:14+02	2003-11-19 18:05:16.88655+02	atlas	3730	init:		tnp-process (PID 2235) started		10
1319016	2003-11-19 18:05:14+02	2003-11-19 18:05:17.529301+02	atlas	3730	chassisd[2237]:		 CHASSISD release 6.1R1.4 built by builder on 2003-10-09 20:21:27 UTC 		10
1319012	2003-11-19 18:05:14+02	2003-11-19 18:05:17.354186+02	ganymede	3731	init:		interface-control (PID 2263) started		10
1318941	2003-11-19 18:05:14+02	2003-11-19 18:05:16.227866+02	atlas	3730	/kernel:		Additional routing options:		10
1318968	2003-11-19 18:05:14+02	2003-11-19 18:05:16.67396+02	atlas	3730	/kernel:	Microcode:	Header revision 1, Date 5/5/1999, Platform Id 20		10
1318952	2003-11-19 18:05:14+02	2003-11-19 18:05:16.397782+02	atlas	3730	/kernel:		cron		10
1319008	2003-11-19 18:05:14+02	2003-11-19 18:05:17.335506+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pgm 		10
1319005	2003-11-19 18:05:14+02	2003-11-19 18:05:17.323951+02	ganymede	3731	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1319009	2003-11-19 18:05:14+02	2003-11-19 18:05:17.339199+02	ganymede	3731	init:	Multiuser:	old requested_transition==0x0 sighupped=0 		10
1318990	2003-11-19 18:05:14+02	2003-11-19 18:05:17.034955+02	ganymede	3731	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1318979	2003-11-19 18:05:14+02	2003-11-19 18:05:16.829367+02	atlas	3730	init:		watchdog (PID 2234) started		10
1318949	2003-11-19 18:05:14+02	2003-11-19 18:05:16.386679+02	atlas	3730	/kernel:		.		10
1319006	2003-11-19 18:05:14+02	2003-11-19 18:05:17.327648+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1318944	2003-11-19 18:05:14+02	2003-11-19 18:05:16.367773+02	atlas	3730	/kernel:		Doing additional network setup:		10
1318940	2003-11-19 18:05:14+02	2003-11-19 18:05:16.22414+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing 		10
1318945	2003-11-19 18:05:14+02	2003-11-19 18:05:16.371493+02	atlas	3730	/kernel:		ntpdate		10
1319004	2003-11-19 18:05:14+02	2003-11-19 18:05:17.320152+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1318953	2003-11-19 18:05:14+02	2003-11-19 18:05:16.502652+02	atlas	3730	cron[2200]:		(CRON) STARTUP (fork ok) 		10
1318954	2003-11-19 18:05:14+02	2003-11-19 18:05:16.508095+02	ganymede	3731	init:		routing (PID 2259) started		10
1318963	2003-11-19 18:05:14+02	2003-11-19 18:05:16.653028+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1318989	2003-11-19 18:05:14+02	2003-11-19 18:05:17.031039+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1319015	2003-11-19 18:05:14+02	2003-11-19 18:05:17.525426+02	atlas	3730	init:		chassis-control (PID 2237) started		10
1318942	2003-11-19 18:05:14+02	2003-11-19 18:05:16.231538+02	atlas	3730	/kernel:		ipsec kld		10
1318943	2003-11-19 18:05:14+02	2003-11-19 18:05:16.342595+02	atlas	3730	/kernel:		.		10
1318950	2003-11-19 18:05:14+02	2003-11-19 18:05:16.390384+02	atlas	3730	/kernel:		setting ldconfig path: /usr/lib		10
1318967	2003-11-19 18:05:14+02	2003-11-19 18:05:16.670203+02	atlas	3730	/kernel:		microcode kld		10
1318974	2003-11-19 18:05:14+02	2003-11-19 18:05:16.808271+02	atlas	3730	/kernel:		.		10
1318977	2003-11-19 18:05:14+02	2003-11-19 18:05:16.821836+02	atlas	3730	/kernel:		Wed Nov 19 17:05:14 CET 2003		10
1318978	2003-11-19 18:05:14+02	2003-11-19 18:05:16.825657+02	atlas	3730	init:		process_mode mode=BOTH cmd=watchdog master_mode=-1		10
1318999	2003-11-19 18:05:14+02	2003-11-19 18:05:17.181486+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1318966	2003-11-19 18:05:14+02	2003-11-19 18:05:16.666474+02	atlas	3730	/kernel:		Initial rc.i386 initialization:		10
1318965	2003-11-19 18:05:14+02	2003-11-19 18:05:16.662754+02	atlas	3730	/kernel:		.		10
1318988	2003-11-19 18:05:14+02	2003-11-19 18:05:17.027229+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1318956	2003-11-19 18:05:14+02	2003-11-19 18:05:16.516845+02	ganymede	3731	init:		process_mode mode=BOTH cmd=inet-process master_mode=1		10
1318987	2003-11-19 18:05:14+02	2003-11-19 18:05:17.0231+02	atlas	3730	init:		process_mode mode=BOTH cmd=chassis-control master_mode=-1		10
1318984	2003-11-19 18:05:14+02	2003-11-19 18:05:17.010466+02	atlas	3730	init:		interface-control (PID 2236) started		10
1318994	2003-11-19 18:05:14+02	2003-11-19 18:05:17.158033+02	ganymede	3731	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1318951	2003-11-19 18:05:14+02	2003-11-19 18:05:16.394098+02	atlas	3730	/kernel:		starting standard daemons:		10
1318947	2003-11-19 18:05:14+02	2003-11-19 18:05:16.378935+02	atlas	3730	/kernel:		.		10
1319007	2003-11-19 18:05:14+02	2003-11-19 18:05:17.331378+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=neighbor-liveness 		10
1318995	2003-11-19 18:05:14+02	2003-11-19 18:05:17.161953+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1318998	2003-11-19 18:05:14+02	2003-11-19 18:05:17.17767+02	ganymede	3731	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1318971	2003-11-19 18:05:14+02	2003-11-19 18:05:16.685193+02	atlas	3730	/kernel:		rc.i386 configuring syscons:		10
1319011	2003-11-19 18:05:14+02	2003-11-19 18:05:17.346696+02	ganymede	3731	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1318964	2003-11-19 18:05:14+02	2003-11-19 18:05:16.658938+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1318986	2003-11-19 18:05:14+02	2003-11-19 18:05:17.017925+02	ganymede	3731	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1319000	2003-11-19 18:05:14+02	2003-11-19 18:05:17.185385+02	ganymede	3731	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1318993	2003-11-19 18:05:14+02	2003-11-19 18:05:17.15261+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1319002	2003-11-19 18:05:14+02	2003-11-19 18:05:17.200073+02	ganymede	3731	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1318946	2003-11-19 18:05:14+02	2003-11-19 18:05:16.375228+02	atlas	3730	ntpdate[2185]:		step time server 172.26.27.3 offset 0.114722 sec		10
1318996	2003-11-19 18:05:14+02	2003-11-19 18:05:17.167478+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1318969	2003-11-19 18:05:14+02	2003-11-19 18:05:16.677687+02	atlas	3730	/kernel:	Microcode:	updated from revision 0 to 11, date=05051999		10
1318980	2003-11-19 18:05:14+02	2003-11-19 18:05:16.882671+02	atlas	3730	init:		process_mode mode=BOTH cmd=tnp-process master_mode=-1		10
1319013	2003-11-19 18:05:14+02	2003-11-19 18:05:17.464441+02	r201	3732	snmpd[4416]:	SNMPD_SEND_FAILURE:	trap_io_send_trap_now: send to (172.1.0.10) failure: No route to host 		2
1318948	2003-11-19 18:05:14+02	2003-11-19 18:05:16.382936+02	atlas	3730	/kernel:		Starting final network daemons:		10
1319010	2003-11-19 18:05:14+02	2003-11-19 18:05:17.342976+02	ganymede	3731	init:		interface-control (PID 2221) exited with status=0 Normal Exit		10
1319014	2003-11-19 18:05:14+02	2003-11-19 18:05:17.470583+02	r201	3732	snmpd[4416]:	SNMPD_TRAP_QUEUE_MAX_ATTEMPTS:	trap_dq_send_traps: after 10 attempts, deleting 106 traps queued to 172.1.0.10 		2
1319020	2003-11-19 18:05:14+02	2003-11-19 18:05:17.547421+02	atlas	3730	init:		alarm-control (PID 2238) started		10
1319001	2003-11-19 18:05:14+02	2003-11-19 18:05:17.189131+02	ganymede	3731	init:		clean_process:process firewall RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1319017	2003-11-19 18:05:14+02	2003-11-19 18:05:17.533058+02	atlas	3730	init:		process_mode mode=BOTH cmd=alarm-control master_mode=-1		10
1318970	2003-11-19 18:05:14+02	2003-11-19 18:05:16.681398+02	atlas	3730	/kernel:		.		10
1318972	2003-11-19 18:05:14+02	2003-11-19 18:05:16.688864+02	atlas	3730	/kernel:		.		10
1318973	2003-11-19 18:05:14+02	2003-11-19 18:05:16.804358+02	atlas	3730	/kernel:		Local package initialization:		10
1319018	2003-11-19 18:05:14+02	2003-11-19 18:05:17.538748+02	atlas	3730	/kernel:	mastership:	routing engine 0 becoming master		10
1318983	2003-11-19 18:05:14+02	2003-11-19 18:05:17.004982+02	atlas	3730	init:		process_mode mode=RESTART cmd=interface-control master_mode=-1		10
1318985	2003-11-19 18:05:14+02	2003-11-19 18:05:17.014214+02	ganymede	3731	tnp.tftpd[2262]:	TFTPD_CONNECT_INFO:	TFTP read from address 2 port 1024 file sbr.jbf		10
1318982	2003-11-19 18:05:14+02	2003-11-19 18:05:16.890357+02	ganymede	3731	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1319052	2003-11-19 18:05:15+02	2003-11-19 18:05:18.178199+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1319037	2003-11-19 18:05:15+02	2003-11-19 18:05:17.83793+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing 		10
1319062	2003-11-19 18:05:15+02	2003-11-19 18:05:18.337956+02	atlas	3730	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1319039	2003-11-19 18:05:15+02	2003-11-19 18:05:17.845654+02	atlas	3730	init:		routing (PID 2244) started		10
1319024	2003-11-19 18:05:15+02	2003-11-19 18:05:17.665648+02	atlas	3730	init:		ntp (PID 2240) started		10
1319045	2003-11-19 18:05:15+02	2003-11-19 18:05:17.979734+02	atlas	3730	init:		vrrp (PID 2247) started		10
1319058	2003-11-19 18:05:15+02	2003-11-19 18:05:18.20161+02	atlas	3730	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1319043	2003-11-19 18:05:15+02	2003-11-19 18:05:17.972283+02	atlas	3730	init:		sonet-aps (PID 2246) started		10
1319027	2003-11-19 18:05:15+02	2003-11-19 18:05:17.67878+02	atlas	3730	init:		management (PID 2241) started		10
1319055	2003-11-19 18:05:15+02	2003-11-19 18:05:18.189524+02	atlas	3730	init:		remote-operations (PID 2252) started		10
1319064	2003-11-19 18:05:15+02	2003-11-19 18:05:18.347541+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1319021	2003-11-19 18:05:15+02	2003-11-19 18:05:17.652622+02	atlas	3730	init:		process_mode mode=BOTH cmd=craft-control master_mode=1		10
1319057	2003-11-19 18:05:15+02	2003-11-19 18:05:18.197888+02	atlas	3730	init:		class-of-service (PID 2253) started		10
1319023	2003-11-19 18:05:15+02	2003-11-19 18:05:17.661846+02	atlas	3730	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1319054	2003-11-19 18:05:15+02	2003-11-19 18:05:18.18583+02	atlas	3730	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1319053	2003-11-19 18:05:15+02	2003-11-19 18:05:18.182092+02	atlas	3730	init:		ilmi (PID 2251) started		10
1319067	2003-11-19 18:05:15+02	2003-11-19 18:05:18.358805+02	atlas	3730	rpd[2244]:	krt_ifstate_get_socket:	ifstate option is set		10
1319036	2003-11-19 18:05:15+02	2003-11-19 18:05:17.83309+02	atlas	3730	init:		mib-process (PID 2243) started		10
1319022	2003-11-19 18:05:15+02	2003-11-19 18:05:17.658059+02	atlas	3730	init:		craft-control (PID 2239) started		10
1319056	2003-11-19 18:05:15+02	2003-11-19 18:05:18.194114+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1319035	2003-11-19 18:05:15+02	2003-11-19 18:05:17.828217+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1319025	2003-11-19 18:05:15+02	2003-11-19 18:05:17.669394+02	atlas	3730	init:		process_mode mode=BOTH cmd=management master_mode=1		10
1319038	2003-11-19 18:05:15+02	2003-11-19 18:05:17.84185+02	atlas	3730	rpd[2244]:	RPD_START:	Start rpd[2244] version 6.1R1.4 built 2003-10-09 20:28:45 UTC		10
1319060	2003-11-19 18:05:15+02	2003-11-19 18:05:18.209312+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1319061	2003-11-19 18:05:15+02	2003-11-19 18:05:18.322644+02	atlas	3730	init:		ipsec-key-management (PID 2255) started		10
1319034	2003-11-19 18:05:15+02	2003-11-19 18:05:17.8245+02	atlas	3730	init:		snmp (PID 2242) started		10
1319047	2003-11-19 18:05:15+02	2003-11-19 18:05:17.988052+02	atlas	3730	init:		sntp (PID 2248) started		10
1319059	2003-11-19 18:05:15+02	2003-11-19 18:05:18.205608+02	atlas	3730	init:		network-access (PID 2254) started		10
1319066	2003-11-19 18:05:15+02	2003-11-19 18:05:18.355103+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1319065	2003-11-19 18:05:15+02	2003-11-19 18:05:18.351343+02	atlas	3730	init:		remote-hello (PID 2257) started		10
1319019	2003-11-19 18:05:15+02	2003-11-19 18:05:17.54275+02	atlas	3730	/kernel:	TNP:	adding neighbor 1 to interface fxp1.		10
1319044	2003-11-19 18:05:15+02	2003-11-19 18:05:17.976039+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1319033	2003-11-19 18:05:15+02	2003-11-19 18:05:17.820098+02	atlas	3730	craftd[2239]:		craftd detected platform m5 		10
1319063	2003-11-19 18:05:15+02	2003-11-19 18:05:18.343504+02	atlas	3730	init:		helper (PID 2256) started		10
1319028	2003-11-19 18:05:15+02	2003-11-19 18:05:17.68464+02	atlas	3730	init:		process_mode mode=BOTH cmd=snmp master_mode=1		10
1319046	2003-11-19 18:05:15+02	2003-11-19 18:05:17.984273+02	atlas	3730	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1319030	2003-11-19 18:05:15+02	2003-11-19 18:05:17.699262+02	atlas	3730	xntpd[2240]:		using kernel phase-lock loop 2040		1
1319029	2003-11-19 18:05:15+02	2003-11-19 18:05:17.688534+02	atlas	3730	xntpd[2240]:		kern_enable is 1		1
1319048	2003-11-19 18:05:15+02	2003-11-19 18:05:17.993956+02	atlas	3730	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1319042	2003-11-19 18:05:15+02	2003-11-19 18:05:17.968251+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1319026	2003-11-19 18:05:15+02	2003-11-19 18:05:17.674669+02	atlas	3730	xntpd[2240]:		ntpd 4.0.99b Thu Oct  9 20:39:08 GMT 2003 (1)		1
1319032	2003-11-19 18:05:15+02	2003-11-19 18:05:17.816327+02	atlas	3730	xntpd[2240]:		using kernel phase-lock loop 2041		1
1319050	2003-11-19 18:05:15+02	2003-11-19 18:05:18.007534+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1319031	2003-11-19 18:05:15+02	2003-11-19 18:05:17.812593+02	atlas	3730	xntpd[2240]:		frequency initialized 76.289 from /var/db/ntp.drift		1
1319041	2003-11-19 18:05:15+02	2003-11-19 18:05:17.962642+02	atlas	3730	init:		inet-process (PID 2245) started		10
1319049	2003-11-19 18:05:15+02	2003-11-19 18:05:17.997683+02	atlas	3730	init:		pfe (PID 2249) started		10
1319051	2003-11-19 18:05:15+02	2003-11-19 18:05:18.172595+02	atlas	3730	init:		sampling (PID 2250) started		10
1319040	2003-11-19 18:05:15+02	2003-11-19 18:05:17.849391+02	atlas	3730	init:		process_mode mode=BOTH cmd=inet-process master_mode=1		10
1319068	2003-11-19 18:05:16+02	2003-11-19 18:05:18.362711+02	atlas	3730	init:		link-management (PID 2258) started		10
1319070	2003-11-19 18:05:16+02	2003-11-19 18:05:18.370193+02	atlas	3730	alarmd[2238]:		craftd connection succeeded after 1 retries 		10
1319079	2003-11-19 18:05:17+02	2003-11-19 18:05:18.518218+02	atlas	3730	alarmd[2238]:		resending alarm state 		10
1319074	2003-11-19 18:05:17+02	2003-11-19 18:05:18.496865+02	ganymede	3731	rpd[2259]:	RPD_TASK_BEGIN:	Commencing routing updates, version 6.1R1.4, built 2003-10-09 20:28:45 UTC by builder		10
1319078	2003-11-19 18:05:17+02	2003-11-19 18:05:18.514226+02	atlas	3730	/kernel:		Nov 19 17:05:16 init: process_mode mode=BOTH cmd=syslogd master_mode=1		10
1319077	2003-11-19 18:05:17+02	2003-11-19 18:05:18.508378+02	ganymede	3731	rpd[2259]:		EVENT UpDown lsi.32768 index 67 <Up Broadcast PointToPoint Multicast>		10
1319076	2003-11-19 18:05:17+02	2003-11-19 18:05:18.504662+02	ganymede	3731	rpd[2259]:		EVENT <UpDown> lsi.32768 index 67 <Up Broadcast PointToPoint Multicast>		10
1319082	2003-11-19 18:05:17+02	2003-11-19 18:05:18.640099+02	ganymede	3731	rpd[2259]:		EVENT UpDown lsi.32768 index 67 <Up Broadcast PointToPoint Multicast>		10
1319072	2003-11-19 18:05:17+02	2003-11-19 18:05:18.489172+02	ganymede	3731	rpd[2259]:	bgp_set_peer_if:	BGP peer 192.1.1.2 (External AS 64513) interface not found.  Leaving peer idled		10
1319071	2003-11-19 18:05:17+02	2003-11-19 18:05:18.483193+02	ganymede	3731	rpd[2259]:	bgp_peer_init:	BGP peer 10.100.254.21 (Internal AS 100) local address 10.100.254.20 not found.  Leaving peer idled		10
1319075	2003-11-19 18:05:17+02	2003-11-19 18:05:18.500727+02	ganymede	3731	rpd[2259]:		bgp_listen_reset		10
1319087	2003-11-19 18:05:18+02	2003-11-19 18:05:18.65879+02	ganymede	3731	init:		process_mode mode=BOTH cmd=chassis-control master_mode=1		10
1319144	2003-11-19 18:05:18+02	2003-11-19 18:05:19.608956+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1319113	2003-11-19 18:05:18+02	2003-11-19 18:05:19.115335+02	ganymede	3731	init:		clean_process:process firewall RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1319147	2003-11-19 18:05:18+02	2003-11-19 18:05:19.622113+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1319176	2003-11-19 18:05:18+02	2003-11-19 18:05:20.125281+02	atlas	3730	init:		pic-services-logging (PID 2263) started		10
1319105	2003-11-19 18:05:18+02	2003-11-19 18:05:18.969861+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ipsec-key-management 		10
1319128	2003-11-19 18:05:18+02	2003-11-19 18:05:19.330073+02	ganymede	3731	init:		process_mode mode=BOTH cmd=craft-control master_mode=1		10
1319167	2003-11-19 18:05:18+02	2003-11-19 18:05:19.97893+02	ganymede	3731	alarmd[2223]:		chassisd connection succeeded after 7 retries 		10
1319125	2003-11-19 18:05:18+02	2003-11-19 18:05:19.271067+02	ganymede	3731	init:		clean_process:process interface-control RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1319114	2003-11-19 18:05:18+02	2003-11-19 18:05:19.119459+02	ganymede	3731	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1319135	2003-11-19 18:05:18+02	2003-11-19 18:05:19.461533+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1319083	2003-11-19 18:05:18+02	2003-11-19 18:05:18.643878+02	ganymede	3731	init:		process_mode mode=BOTH cmd=watchdog master_mode=1		10
1319126	2003-11-19 18:05:18+02	2003-11-19 18:05:19.322554+02	ganymede	3731	init:		process_mode mode=BOTH cmd=chassis-control master_mode=1		10
1319142	2003-11-19 18:05:18+02	2003-11-19 18:05:19.600911+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1319165	2003-11-19 18:05:18+02	2003-11-19 18:05:19.971449+02	atlas	3730	smartd[2259]:		smartd starting, pid 2259		10
1319100	2003-11-19 18:05:18+02	2003-11-19 18:05:18.84071+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1319156	2003-11-19 18:05:18+02	2003-11-19 18:05:19.762787+02	ganymede	3731	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1319130	2003-11-19 18:05:18+02	2003-11-19 18:05:19.337868+02	ganymede	3731	init:		process_mode mode=BOTH cmd=management master_mode=1		10
1319134	2003-11-19 18:05:18+02	2003-11-19 18:05:19.457809+02	ganymede	3731	init:		process_mode mode=BOTH cmd=inet-process master_mode=1		10
1319127	2003-11-19 18:05:18+02	2003-11-19 18:05:19.326331+02	ganymede	3731	init:		process_mode mode=BOTH cmd=alarm-control master_mode=1		10
1319155	2003-11-19 18:05:18+02	2003-11-19 18:05:19.758643+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1319178	2003-11-19 18:05:18+02	2003-11-19 18:05:20.138285+02	atlas	3730	init:		adaptive-services (PID 2264) started		10
1319159	2003-11-19 18:05:18+02	2003-11-19 18:05:19.774119+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pgm 		10
1319102	2003-11-19 18:05:18+02	2003-11-19 18:05:18.958119+02	ganymede	3731	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1319093	2003-11-19 18:05:18+02	2003-11-19 18:05:18.812845+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1319110	2003-11-19 18:05:18+02	2003-11-19 18:05:18.989365+02	ganymede	3731	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1319086	2003-11-19 18:05:18+02	2003-11-19 18:05:18.655083+02	ganymede	3731	init:		clean_process:process interface-control RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1319096	2003-11-19 18:05:18+02	2003-11-19 18:05:18.825708+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sonet-aps 		10
1319140	2003-11-19 18:05:18+02	2003-11-19 18:05:19.486331+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1319146	2003-11-19 18:05:18+02	2003-11-19 18:05:19.616418+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1319139	2003-11-19 18:05:18+02	2003-11-19 18:05:19.481138+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1319137	2003-11-19 18:05:18+02	2003-11-19 18:05:19.46914+02	ganymede	3731	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1319138	2003-11-19 18:05:18+02	2003-11-19 18:05:19.477339+02	ganymede	3731	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1319133	2003-11-19 18:05:18+02	2003-11-19 18:05:19.454078+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing 		10
1319164	2003-11-19 18:05:18+02	2003-11-19 18:05:19.967727+02	atlas	3730	init:		disk-monitoring (PID 2259) started		10
1319095	2003-11-19 18:05:18+02	2003-11-19 18:05:18.820656+02	ganymede	3731	init:		process_mode mode=BOTH cmd=inet-process master_mode=1		10
1319145	2003-11-19 18:05:18+02	2003-11-19 18:05:19.612698+02	ganymede	3731	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1319160	2003-11-19 18:05:18+02	2003-11-19 18:05:19.778096+02	ganymede	3731	init:	Multiuser:	old requested_transition==0x0 sighupped=0 		10
1319091	2003-11-19 18:05:18+02	2003-11-19 18:05:18.784477+02	ganymede	3731	init:		process_mode mode=BOTH cmd=management master_mode=1		10
1319157	2003-11-19 18:05:18+02	2003-11-19 18:05:19.766471+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1319158	2003-11-19 18:05:18+02	2003-11-19 18:05:19.770233+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=neighbor-liveness 		10
1319094	2003-11-19 18:05:18+02	2003-11-19 18:05:18.816715+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing 		10
1319109	2003-11-19 18:05:18+02	2003-11-19 18:05:18.985644+02	ganymede	3731	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1319154	2003-11-19 18:05:18+02	2003-11-19 18:05:19.754818+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1319163	2003-11-19 18:05:18+02	2003-11-19 18:05:19.964021+02	ganymede	3731	craftd[2224]:		chassisd connection succeeded after 5 retries 		10
1319161	2003-11-19 18:05:18+02	2003-11-19 18:05:19.954517+02	ganymede	3731	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 1, af 2, run-len 0		10
1352885	2003-11-21 17:53:45+02	2003-11-21 17:36:26.022439+02	jupiter	3727	fpc2		.pm3388.2.3. port 0: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352886	2003-11-21 17:53:45+02	2003-11-21 17:36:26.030764+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352890	2003-11-21 17:53:46+02	2003-11-21 17:36:27.150303+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352889	2003-11-21 17:53:46+02	2003-11-21 17:36:27.022872+02	jupiter	3727	fpc2		.pm3388.2.3. port 1: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352891	2003-11-21 17:53:46+02	2003-11-21 17:36:27.155755+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352892	2003-11-21 17:53:47+02	2003-11-21 17:36:28.023522+02	jupiter	3727	fpc2		.pm3388.2.3. port 2: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352893	2003-11-21 17:53:47+02	2003-11-21 17:36:28.036606+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352894	2003-11-21 17:53:47+02	2003-11-21 17:36:28.04207+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352896	2003-11-21 17:53:48+02	2003-11-21 17:36:29.032229+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352895	2003-11-21 17:53:48+02	2003-11-21 17:36:29.022861+02	jupiter	3727	fpc2		.pm3388.2.3. port 3: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1352898	2003-11-21 17:53:49+02	2003-11-21 17:36:34.338195+02	jupiter	3727	fpc2		.pm3388.2.3. port 5: OUT_DOOL, SERDES Receive Data Out of Lock 		10
1402073	2003-11-25 14:40:04+02	2003-11-25 14:40:05.015794+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1402074	2003-11-25 14:40:04+02	2003-11-25 14:40:05.058559+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1402075	2003-11-25 14:40:04+02	2003-11-25 14:40:05.063561+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1402076	2003-11-25 14:40:04+02	2003-11-25 14:40:05.070013+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1402077	2003-11-25 14:40:04+02	2003-11-25 14:40:05.076906+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1402078	2003-11-25 14:40:05+02	2003-11-25 14:40:05.137884+02	ganymede	3731	mgd[3726]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1402079	2003-11-25 14:40:05+02	2003-11-25 14:40:05.14487+02	ganymede	3731	mgd[3726]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [3726]		1
1402080	2003-11-25 14:40:05+02	2003-11-25 14:40:05.255414+02	ganymede	3731	mgd[3726]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-width 0 '		1
1402081	2003-11-25 14:40:05+02	2003-11-25 14:40:05.325424+02	ganymede	3731	mgd[3726]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'set cli screen-length 0 '		1
1402082	2003-11-25 14:40:05+02	2003-11-25 14:40:05.429903+02	ganymede	3731	mgd[3726]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show isis database extensive '		1
1402083	2003-11-25 14:40:05+02	2003-11-25 14:40:05.622824+02	ganymede	3731	mgd[3726]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'show ospf database extensive '		1
1402084	2003-11-25 14:40:05+02	2003-11-25 14:40:05.711472+02	ganymede	3731	mgd[3726]:	UI_CMDLINE_READ_LINE:	User 'lab', command 'quit '		1
1402085	2003-11-25 14:40:05+02	2003-11-25 14:40:05.71712+02	ganymede	3731	mgd[3726]:	UI_LOGOUT_EVENT:	User 'lab' logout		1
1402086	2003-11-25 14:40:05+02	2003-11-25 14:40:05.721791+02	ganymede	3731	inetd[2228]:	/usr/libexec/telnetd[3724]:	exit status 0x100		10
1402092	2003-11-25 14:40:12+02	2003-11-25 14:40:12.778741+02	adrastea	3726	login:	LOGIN_INFORMATION:	login of user lab from host 172.26.27.115 on device ttyp0		1
1402093	2003-11-25 14:40:12+02	2003-11-25 14:40:12.801753+02	adrastea	3726	login:		login from 172.26.27.115 on ttyp0 as lab		1
1402094	2003-11-25 14:40:12+02	2003-11-25 14:40:12.825825+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1402095	2003-11-25 14:40:12+02	2003-11-25 14:40:12.832077+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1402096	2003-11-25 14:40:12+02	2003-11-25 14:40:12.837894+02	atlas	3730	login:		PAM module 0 returned: [0]Success		1
1402097	2003-11-25 14:40:12+02	2003-11-25 14:40:12.843188+02	atlas	3730	login:		PAM authentication chain returned: [0]Success		1
1402098	2003-11-25 14:40:12+02	2003-11-25 14:40:12.848756+02	atlas	3730	login:		login from 172.26.27.115 on ttyp0 as lab		1
1402099	2003-11-25 14:40:12+02	2003-11-25 14:40:12.863804+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1402100	2003-11-25 14:40:12+02	2003-11-25 14:40:12.977747+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1402101	2003-11-25 14:40:12+02	2003-11-25 14:40:12.986827+02	ganymede	3731	login:		PAM module 0 returned: [0]Success		1
1402102	2003-11-25 14:40:12+02	2003-11-25 14:40:12.994163+02	ganymede	3731	login:		PAM authentication chain returned: [0]Success		1
1402103	2003-11-25 14:40:12+02	2003-11-25 14:40:12.999611+02	ganymede	3731	login:		login from 172.26.27.115 on ttyp0 as lab		1
1402104	2003-11-25 14:40:12+02	2003-11-25 14:40:13.00711+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1402105	2003-11-25 14:40:12+02	2003-11-25 14:40:13.012324+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1402106	2003-11-25 14:40:12+02	2003-11-25 14:40:13.018204+02	r201	3732	login:		PAM module 0 returned: [0]Success		1
1402107	2003-11-25 14:40:12+02	2003-11-25 14:40:13.023561+02	r201	3732	login:		PAM authentication chain returned: [0]Success		1
1402108	2003-11-25 14:40:12+02	2003-11-25 14:40:13.031475+02	r201	3732	login:		login from 172.26.27.115 on ttyp0 as lab		1
1402109	2003-11-25 14:40:12+02	2003-11-25 14:40:13.037566+02	atlas	3730	mgd[3518]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1402110	2003-11-25 14:40:12+02	2003-11-25 14:40:13.146803+02	atlas	3730	mgd[3518]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [3518]		1
1402111	2003-11-25 14:40:12+02	2003-11-25 14:40:13.152422+02	adrastea	3726	mgd[6043]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1402112	2003-11-25 14:40:12+02	2003-11-25 14:40:13.156279+02	adrastea	3726	mgd[6043]:	UI_LOGIN_EVENT:	User 'lab' login, class 'j-superuser' [6043]		1
1402113	2003-11-25 14:40:12+02	2003-11-25 14:40:13.160045+02	ganymede	3731	mgd[3729]:	UI_AUTH_EVENT:	Authenticated user 'lab' at permission level 'j-superuser'		1
1319111	2003-11-19 18:05:18+02	2003-11-19 18:05:19.102699+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1319175	2003-11-19 18:05:18+02	2003-11-19 18:05:20.121389+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1319108	2003-11-19 18:05:18+02	2003-11-19 18:05:18.98182+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=link-management 		10
1319177	2003-11-19 18:05:18+02	2003-11-19 18:05:20.129009+02	atlas	3730	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1319148	2003-11-19 18:05:18+02	2003-11-19 18:05:19.625956+02	ganymede	3731	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1319174	2003-11-19 18:05:18+02	2003-11-19 18:05:20.117663+02	atlas	3730	init:		routing-socket-proxy (PID 2262) started		10
1319112	2003-11-19 18:05:18+02	2003-11-19 18:05:19.10832+02	ganymede	3731	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1319092	2003-11-19 18:05:18+02	2003-11-19 18:05:18.808952+02	ganymede	3731	init:		process_mode mode=BOTH cmd=snmp master_mode=1		10
1319184	2003-11-19 18:05:18+02	2003-11-19 18:05:20.283219+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pgm 		10
1319081	2003-11-19 18:05:18+02	2003-11-19 18:05:18.634488+02	atlas	3730	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1319107	2003-11-19 18:05:18+02	2003-11-19 18:05:18.977903+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1319169	2003-11-19 18:05:18+02	2003-11-19 18:05:19.98657+02	atlas	3730	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1319181	2003-11-19 18:05:18+02	2003-11-19 18:05:20.263766+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=neighbor-liveness 		10
1319162	2003-11-19 18:05:18+02	2003-11-19 18:05:19.960239+02	ganymede	3731	/kernel:	set_pfe_sample_params:	rate 0, pps 0, NH-id 0, class 2, af 2, run-len 0		10
1319141	2003-11-19 18:05:18+02	2003-11-19 18:05:19.595302+02	ganymede	3731	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1319098	2003-11-19 18:05:18+02	2003-11-19 18:05:18.833237+02	ganymede	3731	init:		process_mode mode=BOTH cmd=sntp master_mode=1		10
1319172	2003-11-19 18:05:18+02	2003-11-19 18:05:20.110102+02	atlas	3730	init:		internal-routing-service (PID 2261) started		10
1319173	2003-11-19 18:05:18+02	2003-11-19 18:05:20.113959+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1319097	2003-11-19 18:05:18+02	2003-11-19 18:05:18.829513+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1319099	2003-11-19 18:05:18+02	2003-11-19 18:05:18.83696+02	ganymede	3731	init:		process_mode mode=BOTH cmd=pfe master_mode=1		10
1319180	2003-11-19 18:05:18+02	2003-11-19 18:05:20.150893+02	atlas	3730	init:		ecc-error-logging (PID 2265) started		500
1319171	2003-11-19 18:05:18+02	2003-11-19 18:05:20.104411+02	atlas	3730	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1319182	2003-11-19 18:05:18+02	2003-11-19 18:05:20.270583+02	atlas	3730	init:		neighbor-liveness (PID 2266) started		10
1319151	2003-11-19 18:05:18+02	2003-11-19 18:05:19.742674+02	ganymede	3731	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1319123	2003-11-19 18:05:18+02	2003-11-19 18:05:19.263243+02	ganymede	3731	init:		process_mode mode=BOTH cmd=tnp-process master_mode=1		10
1319085	2003-11-19 18:05:18+02	2003-11-19 18:05:18.651322+02	ganymede	3731	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1319124	2003-11-19 18:05:18+02	2003-11-19 18:05:19.2672+02	ganymede	3731	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1319179	2003-11-19 18:05:18+02	2003-11-19 18:05:20.144072+02	atlas	3730	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1319115	2003-11-19 18:05:18+02	2003-11-19 18:05:19.123308+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1319132	2003-11-19 18:05:18+02	2003-11-19 18:05:19.450247+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=mib-process 		10
1319104	2003-11-19 18:05:18+02	2003-11-19 18:05:18.966142+02	ganymede	3731	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1319168	2003-11-19 18:05:18+02	2003-11-19 18:05:19.982768+02	ganymede	3731	alarmd[2223]:		resending alarm state 		10
1319166	2003-11-19 18:05:18+02	2003-11-19 18:05:19.975213+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1319103	2003-11-19 18:05:18+02	2003-11-19 18:05:18.962323+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1319150	2003-11-19 18:05:18+02	2003-11-19 18:05:19.633446+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1319149	2003-11-19 18:05:18+02	2003-11-19 18:05:19.629696+02	ganymede	3731	init:		process_mode mode=BOTH cmd=disk-monitoring master_mode=1		10
1319136	2003-11-19 18:05:18+02	2003-11-19 18:05:19.465432+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=vrrp 		10
1319170	2003-11-19 18:05:18+02	2003-11-19 18:05:19.990687+02	atlas	3730	init:		firewall (PID 2260) started		10
1319152	2003-11-19 18:05:18+02	2003-11-19 18:05:19.746561+02	ganymede	3731	init:		clean_process:process firewall RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1319131	2003-11-19 18:05:18+02	2003-11-19 18:05:19.444419+02	ganymede	3731	init:		process_mode mode=BOTH cmd=snmp master_mode=1		10
1319080	2003-11-19 18:05:18+02	2003-11-19 18:05:18.522242+02	atlas	3730	init:		syslogd (PID 2108) started		10
1319090	2003-11-19 18:05:18+02	2003-11-19 18:05:18.670697+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1319101	2003-11-19 18:05:18+02	2003-11-19 18:05:18.952635+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1319084	2003-11-19 18:05:18+02	2003-11-19 18:05:18.647588+02	ganymede	3731	init:		process_mode mode=BOTH cmd=tnp-process master_mode=1		10
1319153	2003-11-19 18:05:18+02	2003-11-19 18:05:19.75083+02	ganymede	3731	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1319122	2003-11-19 18:05:18+02	2003-11-19 18:05:19.258279+02	ganymede	3731	init:		process_mode mode=BOTH cmd=watchdog master_mode=1		10
1319116	2003-11-19 18:05:18+02	2003-11-19 18:05:19.127046+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pic-services-logging 		10
1319088	2003-11-19 18:05:18+02	2003-11-19 18:05:18.663128+02	ganymede	3731	init:		process_mode mode=BOTH cmd=alarm-control master_mode=1		10
1319129	2003-11-19 18:05:18+02	2003-11-19 18:05:19.333938+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ntp master_mode=1		10
1319089	2003-11-19 18:05:18+02	2003-11-19 18:05:18.666958+02	ganymede	3731	init:		process_mode mode=BOTH cmd=craft-control master_mode=1		10
1319143	2003-11-19 18:05:18+02	2003-11-19 18:05:19.605017+02	ganymede	3731	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1319121	2003-11-19 18:05:18+02	2003-11-19 18:05:19.25265+02	ganymede	3731	init:	Multiuser:	old requested_transition==0x0 sighupped=1 		10
1319117	2003-11-19 18:05:18+02	2003-11-19 18:05:19.130757+02	ganymede	3731	init:		process_mode mode=BOTH cmd=adaptive-services master_mode=1		10
1319118	2003-11-19 18:05:18+02	2003-11-19 18:05:19.136612+02	ganymede	3731	init:		process_mode mode=BOTH cmd=ecc-error-logging master_mode=1		500
1319120	2003-11-19 18:05:18+02	2003-11-19 18:05:19.144129+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=pgm 		10
1319106	2003-11-19 18:05:18+02	2003-11-19 18:05:18.973826+02	ganymede	3731	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1319119	2003-11-19 18:05:18+02	2003-11-19 18:05:19.140348+02	ganymede	3731	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=neighbor-liveness 		10
1319187	2003-11-19 18:05:19+02	2003-11-19 18:05:20.306927+02	atlas	3730	snmpd[2242]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 2 traps in queue 		2
1319188	2003-11-19 18:05:19+02	2003-11-19 18:05:20.31191+02	atlas	3730	snmpd[2242]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to throttle queue, 3 traps in queue 		2
1319186	2003-11-19 18:05:19+02	2003-11-19 18:05:20.301816+02	atlas	3730	snmpd[2242]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.115 to throttle queue, 1 traps in queue 		2
1319193	2003-11-19 18:05:19+02	2003-11-19 18:05:20.447285+02	atlas	3730	smartd[2259]:		Device /dev/ad1a, found and is SMART capable		10
1319189	2003-11-19 18:05:19+02	2003-11-19 18:05:20.317272+02	atlas	3730	snmpd[2242]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.1.0.10 to throttle queue, 4 traps in queue 		2
1319190	2003-11-19 18:05:19+02	2003-11-19 18:05:20.323296+02	atlas	3730	snmpd[2242]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.75 to throttle queue, 5 traps in queue 		2
1319191	2003-11-19 18:05:19+02	2003-11-19 18:05:20.434848+02	atlas	3730	snmpd[2242]:	SNMPD_TRAP_QUEUED:	Adding trap to 172.26.27.75 to throttle queue, 6 traps in queue 		2
1319192	2003-11-19 18:05:19+02	2003-11-19 18:05:20.440729+02	atlas	3730	snmpd[2242]:	SNMPD_TRAP_COLD_START:	trap_generate_cold: SNMP trap: cold start 		2
1319224	2003-11-19 18:05:20+02	2003-11-19 18:05:21.590224+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=remote-hello 		10
1319220	2003-11-19 18:05:20+02	2003-11-19 18:05:21.573217+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=class-of-service 		10
1319217	2003-11-19 18:05:20+02	2003-11-19 18:05:21.450408+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=sampling 		10
1319218	2003-11-19 18:05:20+02	2003-11-19 18:05:21.454186+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=ilmi 		10
1319223	2003-11-19 18:05:20+02	2003-11-19 18:05:21.586476+02	atlas	3730	init:		process_mode mode=BOTH cmd=helper master_mode=1		10
1319201	2003-11-19 18:05:20+02	2003-11-19 18:05:21.228179+02	atlas	3730	init:		process_mode mode=RESTART cmd=interface-control master_mode=1		10
1319228	2003-11-19 18:05:20+02	2003-11-19 18:05:21.605296+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=BACKUP_ONLY, cmd=kernel-replication 		10
1319236	2003-11-19 18:05:20+02	2003-11-19 18:05:21.747029+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=neighbor-liveness 		10
1319212	2003-11-19 18:05:20+02	2003-11-19 18:05:21.371871+02	atlas	3730	init:		process_mode mode=BOTH cmd=inet-process master_mode=1		10
1319206	2003-11-19 18:05:20+02	2003-11-19 18:05:21.247334+02	atlas	3730	init:		process_mode mode=BOTH cmd=craft-control master_mode=1		10
1319219	2003-11-19 18:05:20+02	2003-11-19 18:05:21.45791+02	atlas	3730	init:		process_mode mode=BOTH cmd=remote-operations master_mode=1		10
1319232	2003-11-19 18:05:20+02	2003-11-19 18:05:21.731983+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing-socket-proxy 		10
1319229	2003-11-19 18:05:20+02	2003-11-19 18:05:21.609022+02	atlas	3730	init:		process_mode mode=RESTART cmd=firewall master_mode=1		10
1319226	2003-11-19 18:05:20+02	2003-11-19 18:05:21.597653+02	atlas	3730	init:		process_mode mode=BOTH cmd=syslogd master_mode=1		10
1319230	2003-11-19 18:05:20+02	2003-11-19 18:05:21.722741+02	atlas	3730	init:		clean_process:process firewall RESTART mode old master_mode 0 new master=1 old failover=0 new failover = 0		10
1319231	2003-11-19 18:05:20+02	2003-11-19 18:05:21.72822+02	atlas	3730	init:		process_mode mode=BOTH cmd=internal-routing-service master_mode=1		10
1319211	2003-11-19 18:05:20+02	2003-11-19 18:05:21.368132+02	atlas	3730	init:		process_mode current_mode=MASTER, requested_mode=MASTER_ONLY, cmd=routing 		10
1319208	2003-11-19 18:05:20+02	2003-11-19 18:05:21.25479+02	atlas	3730	init:		process_mode mode=BOTH cmd=management master_mode=1		10
1319198	2003-11-19 18:05:20+02	2003-11-19 18:05:21.000009+02	atlas	3730	tnp.tftpd[2271]:	TFTPD_CONNECT_INFO:	TFTP read from address 2 port 1024 file sbr.jbf		10
1319221	2003-11-19 18:05:20+02	2003-11-19 18:05:21.578686+02	atlas	3730	init:		process_mode mode=BOTH cmd=network-access master_mode=1		10
1319235	2003-11-19 18:05:20+02	2003-11-19 18:05:21.743312+02	atlas	3730	init:		process_mode mode=BOTH cmd=ecc-err