--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: router_configuration; Type: TABLE; Schema: public; Owner: ngnms; Tablespace: 
--

CREATE TABLE router_configuration (
    id integer NOT NULL,
    router_id integer NOT NULL,
    data bytea NOT NULL,
    created timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.router_configuration OWNER TO ngnms;

--
-- Name: router_configuration_id_seq; Type: SEQUENCE; Schema: public; Owner: ngnms
--

CREATE SEQUENCE router_configuration_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.router_configuration_id_seq OWNER TO ngnms;

--
-- Name: router_configuration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ngnms
--

ALTER SEQUENCE router_configuration_id_seq OWNED BY router_configuration.id;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: ngnms
--

ALTER TABLE ONLY router_configuration ALTER COLUMN id SET DEFAULT nextval('router_configuration_id_seq'::regclass);


--
-- Data for Name: router_configuration; Type: TABLE DATA; Schema: public; Owner: ngnms
--

COPY router_configuration (id, router_id, data, created) FROM stdin;
1	3808	\\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	2012-04-18 19:20:23
2	3808	\\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	2012-04-19 20:00:17
3	3809	\\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	2012-04-18 19:07:52
4	3809	\\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	2012-04-19 19:59:50
5	3810	\\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	2012-04-19 12:01:48
6	3811	\\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	2012-04-18 17:05:26
7	3811	\\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	2012-04-19 17:07:29
8	3812	\\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	2012-04-18 17:05:49
9	3812	\\x2323204c61737420636f6d6d69743a20323031322d30342d31382031373a30353a3439205554432062792078757365720a76657273696f6e2031302e3452332e343b0a73797374656d207b0a20202020686f73742d6e616d6520434f52452d502d3031423b0a20202020646f6d61696e2d6e616d65207874336c61623b0a202020206261636b75702d726f75746572203137322e32342e31312e312064657374696e6174696f6e203139322e3136382e302e302f31363b0a20202020726f6f742d61757468656e7469636174696f6e207b0a2020202020202020656e637279707465642d70617373776f72642022243124466f6b616f446273243731666449596633584c34725652634a684d41676630223b202323205345435245542d444154410a202020207d0a202020206e616d652d736572766572207b0a20202020202020203139322e3136382e3235342e3130343b0a20202020202020203139322e3136382e34322e3130313b0a202020207d0a202020206c6f67696e207b0a20202020202020206d65737361676520225c6e5c6e232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323235c6e5c6e20202020202020202020202057454c434f4d4520544f205854334c41425c6e5c6e556e617574686f72697a6564206163636573732069732073747269636c792070726f686962697465642e5c6e4966206e6f7420617574686f72697a65642c206c6f67206f66662073797374656d20696d6d6564696174656c79215c6e5c6e232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323235c6e223b0a2020202020202020636c61737320737570706f7274207b0a2020202020202020202020207065726d697373696f6e73205b207669657720766965772d636f6e66696775726174696f6e205d3b0a20202020202020202020202064656e792d636f6d6d616e6473202272656c6f61647c7265626f6f747c706f7765722d6f66667c706f7765722d6f6e223b0a20202020202020207d0a2020202020202020636c617373207874336c616275736572207b0a2020202020202020202020207065726d697373696f6e7320616c6c3b0a20202020202020202020202064656e792d636f6e66696775726174696f6e202273797374656d20726f6f742d61757468656e7469636174696f6e7c696e74657266616365732066787030223b0a20202020202020207d0a202020202020202075736572207465737431207b0a20202020202020202020202075696420323030383b0a202020202020202020202020636c61737320737570706f72743b0a20202020202020202020202061757468656e7469636174696f6e207b0a20202020202020202020202020202020656e637279707465642d70617373776f72642022243124595756757375626d24576f484a4c7777504a71685939357a6551625169342f223b202323205345435245542d444154410a2020202020202020202020207d0a20202020202020207d0a202020202020202075736572207875736572207b0a20202020202020202020202075696420323030303b0a202020202020202020202020636c6173732073757065722d757365723b0a20202020202020202020202061757468656e7469636174696f6e207b0a20202020202020202020202020202020656e637279707465642d70617373776f726420222431244f694e454146626e24797956714e554c35535151544a364c666139617a782f223b202323205345435245542d444154410a2020202020202020202020207d0a20202020202020207d0a202020207d0a202020207365727669636573207b0a20202020202020206674703b0a2020202020202020737368207b0a20202020202020202020202070726f746f636f6c2d76657273696f6e2076323b0a20202020202020207d0a202020202020202074656c6e65743b0a202020207d0a202020207379736c6f67207b0a202020202020202075736572202a207b0a202020202020202020202020616e7920656d657267656e63793b0a20202020202020207d0a202020202020202066696c65206d65737361676573207b0a202020202020202020202020616e79206e6f746963653b0a202020202020202020202020617574686f72697a6174696f6e20696e666f3b0a20202020202020207d0a202020202020202066696c6520696e7465726163746976652d636f6d6d616e6473207b0a202020202020202020202020696e7465726163746976652d636f6d6d616e647320616e793b0a20202020202020207d0a202020202020202066696c652064656661756c742d6c6f672d6d65737361676573207b0a202020202020202020202020616e7920616e793b0a202020202020202020202020737472756374757265642d646174613b0a20202020202020207d0a202020207d0a202020206e7470207b0a2020202020202020736572766572203139322e3136382e3235342e3130313b0a2020202020202020736572766572203139322e3136382e3235342e3130323b0a2020202020202020736f757263652d61646472657373203137322e32342e31312e31343b0a202020207d0a7d0a63686173736973207b0a20202020616767726567617465642d64657669636573207b0a202020202020202065746865726e6574207b0a2020202020202020202020206465766963652d636f756e7420353b0a20202020202020207d0a202020207d0a202020206670632031207b0a20202020202020207069632030207b0a20202020202020202020202074756e6e656c2d7365727669636573207b0a2020202020202020202020202020202062616e6477696474682031673b0a2020202020202020202020207d0a20202020202020207d0a202020207d0a202020206e6574776f726b2d73657276696365732069703b0a7d0a696e7465726661636573207b0a2020202067652d312f302f30207b0a2020202020202020756e69742030207b0a2020202020202020202020206465736372697074696f6e2022446f776e2d4c696e6b20746f20435553542d50452d303162223b0a20202020202020202020202066616d696c7920696e6574207b0a20202020202020202020202020202020616464726573732031302e312e312e352f33313b0a2020202020202020202020207d0a20202020202020202020202066616d696c792069736f3b0a20202020202020202020202066616d696c79206d706c733b0a20202020202020207d0a202020207d0a2020202067652d312f312f30207b0a2020202020202020756e69742030207b0a2020202020202020202020206465736372697074696f6e2022582d4c696e6b20746f20434f52452d502d303161223b0a20202020202020202020202066616d696c7920696e6574207b0a20202020202020202020202020202020616464726573732031302e312e322e312f33313b0a2020202020202020202020207d0a20202020202020202020202066616d696c792069736f3b0a20202020202020202020202066616d696c79206d706c733b0a20202020202020207d0a202020207d0a2020202067652d312f312f33207b0a2020202020202020756e69742030207b0a2020202020202020202020206465736372697074696f6e2022446f776e2d4c696e6b20746f20414e542d50452d303142223b0a20202020202020202020202066616d696c7920696e6574207b0a20202020202020202020202020202020616464726573732031302e312e332e352f33313b0a2020202020202020202020207d0a20202020202020202020202066616d696c792069736f3b0a20202020202020202020202066616d696c79206d706c733b0a20202020202020207d0a202020207d0a2020202066787030207b0a2020202020202020756e69742030207b0a20202020202020202020202066616d696c7920696e6574207b0a2020202020202020202020202020202061646472657373203137322e32342e31312e31342f32343b0a2020202020202020202020207d0a20202020202020207d0a202020207d0a202020206c6f30207b0a2020202020202020756e69742030207b0a20202020202020202020202066616d696c7920696e6574207b0a20202020202020202020202020202020616464726573732031302e312e302e332f33323b0a2020202020202020202020207d0a20202020202020202020202066616d696c792069736f207b0a20202020202020202020202020202020616464726573732034392e303031302e303030312e303030302e303030332e30303b0a2020202020202020202020207d0a20202020202020207d0a202020207d0a7d0a736e6d70207b0a20202020636f6e746163742022415251495641204c4142223b0a20202020636f6d6d756e697479207075626c6963207b0a2020202020202020636c69656e7473207b0a2020202020202020202020203139322e3136382e302e302f31363b0a20202020202020207d0a202020207d0a7d0a726f7574696e672d6f7074696f6e73207b0a20202020737461746963207b0a2020202020202020726f757465203139322e3136382e302e302f3136207b0a2020202020202020202020206e6578742d686f70203137322e32342e31312e313b0a2020202020202020202020206e6f2d72656164766572746973653b0a20202020202020207d0a202020207d0a202020206175746f6e6f6d6f75732d73797374656d2036353030303b0a7d0a70726f746f636f6c73207b0a2020202072737670207b0a2020202020202020696e746572666163652067652d312f302f302e303b0a2020202020202020696e746572666163652067652d312f312f302e303b0a2020202020202020696e746572666163652067652d312f312f332e303b0a202020207d0a202020206d706c73207b0a2020202020202020696e7465726661636520616c6c3b0a2020202020202020696e7465726661636520667870302e30207b0a20202020202020202020202064697361626c653b0a20202020202020207d0a202020207d0a2020202069736973207b0a20202020202020206c6576656c20312064697361626c653b0a20202020202020206c6576656c203220776964652d6d6574726963732d6f6e6c793b0a2020202020202020696e746572666163652067652d312f302f302e30207b0a202020202020202020202020706f696e742d746f2d706f696e743b0a2020202020202020202020206c6576656c20312064697361626c653b0a20202020202020207d0a2020202020202020696e746572666163652067652d312f312f302e30207b0a202020202020202020202020706f696e742d746f2d706f696e743b0a2020202020202020202020206c6576656c20312064697361626c653b0a20202020202020207d0a2020202020202020696e746572666163652067652d312f312f332e30207b0a202020202020202020202020706f696e742d746f2d706f696e743b0a2020202020202020202020206c6576656c20312064697361626c653b0a20202020202020207d0a2020202020202020696e74657266616365206c6f302e30207b0a202020202020202020202020706173736976653b0a20202020202020207d0a202020207d0a202020206c6470207b0a20202020202020207472616e73706f72742d6164647265737320726f757465722d69643b0a2020202020202020696e7465726661636520616c6c3b0a2020202020202020696e7465726661636520667870302e30207b0a20202020202020202020202064697361626c653b0a20202020202020207d0a202020207d0a7d0a0a	2012-04-19 19:06:49
10	3813	\\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	2012-04-18 17:26:02
11	3813	\\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	2012-04-19 20:26:02
12	3814	\\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	2012-04-18 19:08:29
13	3814	\\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	2012-04-19 20:03:03
\.


--
-- Name: router_configuration_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ngnms
--

SELECT pg_catalog.setval('router_configuration_id_seq', 13, true);


--
-- Name: router_configuration_id_key; Type: CONSTRAINT; Schema: public; Owner: ngnms; Tablespace: 
--

ALTER TABLE ONLY router_configuration
    ADD CONSTRAINT router_configuration_id_key UNIQUE (id);


--
-- Name: fk_router_id_conf; Type: FK CONSTRAINT; Schema: public; Owner: ngnms
--

ALTER TABLE ONLY router_configuration
    ADD CONSTRAINT fk_router_id_conf FOREIGN KEY (router_id) REFERENCES routers(router_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- PostgreSQL database dump complete
--

